# Generated by CodiumAI

import pytest

from src.coverage_checker_zcool import JsonCoverageService

"""
Code Analysis

Main functionalities:
The JsonCoverageService class is a concrete implementation of the AbstractCoverageService abstract class. It is designed to retrieve the actual coverage percentage from a JSON file containing coverage data.

Methods:
- get_actual_coverage(): This method overrides the abstract method defined in the AbstractCoverageService class. It returns the actual coverage percentage by accessing the 'percent_covered' field in the 'totals' dictionary of the coverage_json field.

Fields:
- coverage_json: This field is a dictionary that contains the coverage data in JSON format. It is passed to the class constructor and used by the get_actual_coverage() method to retrieve the actual coverage percentage.
"""


class TestJsonCoverageService:
    #  Tests that get_actual_coverage returns the correct value when given a valid JSON input
    def test_valid_json_input(self):
        json_coverage_service = JsonCoverageService({'totals': {'percent_covered': 80}})
        assert json_coverage_service.get_actual_coverage() == 80

    #  Tests that get_actual_coverage returns 0 when the 'totals' key is missing from the input JSON
    def test_missing_totals_key(self):
        json_coverage_service = JsonCoverageService({})
        assert json_coverage_service.get_actual_coverage() == 0

    #  Tests that get_actual_coverage returns 0 when the 'percent_covered' key is missing from the 'totals' key in the input JSON
    def test_missing_percent_covered_key(self):
        json_coverage_service = JsonCoverageService({'totals': {}})
        assert json_coverage_service.get_actual_coverage() == 0

    #  Tests that get_actual_coverage returns 0 when the 'percent_covered' key in the 'totals' key in the input JSON is not a number
    def test_percent_covered_not_a_number(self):
        json_coverage_service = JsonCoverageService({'totals': {'percent_covered': 'not a number'}})
        assert json_coverage_service.get_actual_coverage() == 0
