# Generated by CodiumAI
from unittest.mock import Mock

# Dependencies:
# pip install pytest-mock
import pytest

from src.coverage_checker_zcool.classes import AbstractCoverageService, AbstractOutputService, CheckCoverage

"""
Code Analysis

Main functionalities:
The CheckCoverage class is responsible for checking the actual coverage against the expected coverage and printing the result using the provided output service. If the actual coverage is greater than or equal to the expected coverage, the class prints "Ohh yeah !!!" and exits with a success exit code. Otherwise, it prints "Ohh no ???" and exits with a failure exit code.

Methods:
- __post_init__: initializes the CheckCoverage object and performs the coverage check. If the actual coverage is greater than or equal to the expected coverage, it prints "Ohh yeah !!!" and exits with a success exit code. Otherwise, it prints "Ohh no ???" and exits with a failure exit code.

Fields:
- expected_coverage: an integer representing the expected coverage.
- coverage_service: an object that implements the AbstractCoverageService interface and provides the actual coverage value.
- output_service: an object that implements the AbstractOutputService interface and is used to print the coverage check result.
"""


class TestCheckCoverage:
    #  Tests that CheckCoverage exits with SUCCESS_EXIT_CODE when actual_coverage is greater than or equal to expected_coverage
    def test_actual_coverage_greater_than_expected_coverage(self):
        coverage_service = Mock(spec=AbstractCoverageService)

        coverage_service.get_actual_coverage.return_value = 80

        is_enough, actual_coverage_value = CheckCoverage(
            expected_coverage=70,
            coverage_service=coverage_service
        ).is_enough()

        assert is_enough is True
        assert actual_coverage_value == 80
