
## Introduction

WQChartPy is an an open-source Python package for producing most of the graphical diagrams for visualization of water geochemistry data. Utilizing the commonly used comma-separated values (CSV) file as the input data format, WQChartPy can produce eleven geochemical diagrams including not only the traditional Piper trilinear, Durov, Chadha, Stiff, Chernoff face, Schoeller, Gibbs, and Gaillardet diagram, but also the recently proposed diagrams such as the rectangle Piper, color-coded Piper and HFE-D diagrams that have not been implemented in previous software. 

This is the first release of WQChartPy. As a Python-based cross platform program, WQChartPy works on Windows, MacOS X and GNU/Linux. We provided a self-contained Jupyter notebook file to illustrate how to use WQChartPy. Users with a little Python experience can do the whole process from data to the graphical diagrams. Buidling on the oldest and most popular Python plotting library Matplotlib, the figures generated by WQChartPy can be saved as portable network graphics (PNG), scalable vector graphics (SVG) or portable document format (PDF). WQChartPy is an open-source project and any assistance is welcomed. Please email the development team if you want to contribute.

## Installation

WQChartPy requires **Python** 3.7 (or higher). We recommend using [Anaconda](https://www.anaconda.com/) on Windows or Linux platforms. 

The easiest way to install is via `pip`:

To install WQChartPy type:

    pip install wqchartpy

To update WQChartPy type:

    pip install wqchartpy --upgrade

To uninstall WQChartPy type:

    pip uninstall wqchartpy
    
Another way is to manually install WQChartPy with `setup.py`. Preliminary steps to take:

    1. Download the package and extract it into a local directory

    2. cd into the root directory where setup.py is located using an Anaconda Prompt

    3. Enter: python setup.py install
    
## Requirements:

- [NumPy](https://www.numpy.org)
- [Pandas](https://pandas.pydata.org/)
- [Matplotlib](https://www.scipy.org/scipylib)
- [SciPy](https://salib.readthedocs.io/en/latest/)
    
## How to use

We recommend to start by executing the [workflow](https://github.com/jyangfsu/WQChartPy/blob/main/examples/example1.ipynb) provided in the examples folder. 

## License

WQChartPy is distributed under the GNU General Public License v3.0. See the [LICENSE](https://github.com/jyangfsu/WQChartPy/LICENSE) file for details.

## Contributing to WQChartPy

Users are welcome to submit bug reports, feature requests, and code contributions to this project through GitHub or mail to us at jingyang@cug.edu.cn or mye@fsu.edu.
