"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineMergeAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const merge_branches_function_1 = require("./merge-branches-function");
/**
 * Represents a reference to a CodePipelineMergeAction.
 */
class CodePipelineMergeAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    bound(scope, _stage, options) {
        const { repository, sourceCommitSpecifier, destinationCommitSpecifier, crossAccountRole } = this.props;
        const mergeBranchesFunction = new merge_branches_function_1.MergeBranchesFunction(scope, 'MergeBranchesFunction', {
            repository,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [mergeBranchesFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        mergeBranchesFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codepipeline:PutJobSuccessResult', 'codepipeline:PutJobFailureResult'],
        }));
        return {
            configuration: {
                FunctionName: mergeBranchesFunction.functionName,
                UserParameters: aws_cdk_lib_1.Stack.of(scope).toJsonString({
                    repositoryName: repository.repositoryName,
                    sourceCommitSpecifier,
                    destinationCommitSpecifier,
                }),
            },
        };
    }
}
exports.CodePipelineMergeAction = CodePipelineMergeAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineMergeAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-merge-action.CodePipelineMergeAction", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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