import { IRepository } from 'aws-cdk-lib/aws-codecommit';
import { CommonAwsActionProps, IStage, ActionBindOptions, ActionConfig } from 'aws-cdk-lib/aws-codepipeline';
import { Action } from 'aws-cdk-lib/aws-codepipeline-actions';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface CodePipelineMergeActionProps extends CommonAwsActionProps {
    /**
     * The CodeCommit repository.
     */
    readonly repository: IRepository;
    /**
     * The branch, tag, HEAD, or other fully qualified reference used to
     * identify a commit (for example, a branch name or a full commit ID).
     */
    readonly sourceCommitSpecifier: string;
    /**
     * The branch, tag, HEAD, or other fully qualified reference used to
     * identify a commit (for example, a branch name or a full commit ID).
     */
    readonly destinationCommitSpecifier: string;
    /**
     * Role for crossAccount permission
     */
    readonly crossAccountRole?: IRole;
}
/**
 * Represents a reference to a CodePipelineMergeAction.
 */
export declare class CodePipelineMergeAction extends Action {
    private readonly props;
    constructor(props: CodePipelineMergeActionProps);
    protected bound(scope: Construct, _stage: IStage, options: ActionBindOptions): ActionConfig;
}
