#!/usr/bin/env python3

import enum


class error(enum.IntEnum):
    """Error codes exported from Zephyr `hci_types.h`"""

    SUCCESS = (0x00, "Success")
    UNKNOWN_CMD = (0x01, "UNKNOWN HCI COMMAND")
    UNKNOWN_CONN_ID = (0x02, "UNKNOWN CONNECTION IDENTIFIER")
    HW_FAILURE = (0x03, "HARDWARE FAILURE")
    PAGE_TIMEOUT = (0x04, "PAGE TIMEOUT")
    AUTH_FAIL = (0x05, "AUTHENTICATION FAILURE")
    PIN_OR_KEY_MISSING = (0x06, "PIN OR KEY MISSING")
    MEM_CAPACITY_EXCEEDED = (0x07, "MEMORY CAPACITY EXCEEDED")
    CONN_TIMEOUT = (0x08, "CONNECTION TIMEOUT")
    CONN_LIMIT_EXCEEDED = (0x09, "CONNECTION LIMIT EXCEEDED")
    SYNC_CONN_LIMIT_EXCEEDED = (0x0A, "SYNCHRONOUS CONNECTION LIMIT TO A DEVICE EXCEEDED")
    CONN_ALREADY_EXISTS = (0x0B, "CONNECTION ALREADY EXISTS")
    CMD_DISALLOWED = (0x0C, "COMMAND DISALLOWED")
    INSUFFICIENT_RESOURCES = (0x0D, "CONNECTION REJECTED DUE TO LIMITED RESOURCES")
    INSUFFICIENT_SECURITY = (0x0E, "CONNECTION REJECTED DUE TO SECURITY REASONS")
    BD_ADDR_UNACCEPTABLE = (0x0F, "CONNECTION REJECTED DUE TO UNACCEPTABLE BD_ADDR")
    CONN_ACCEPT_TIMEOUT = (0x10, "CONNECTION ACCEPT TIMEOUT EXCEEDED")
    UNSUPP_FEATURE_PARAM_VAL = (0x11, "UNSUPPORTED FEATURE OR PARAMETER VALUE")
    INVALID_PARAM = (0x12, "INVALID HCI COMMAND PARAMETERS")
    REMOTE_USER_TERM_CONN = (0x13, "REMOTE USER TERMINATED CONNECTION")
    REMOTE_LOW_RESOURCES = (0x14, "REMOTE DEVICE TERMINATED CONNECTION DUE TO LOW RESOURCES")
    REMOTE_POWER_OFF = (0x15, "REMOTE DEVICE TERMINATED CONNECTION DUE TO POWER OFF")
    LOCALHOST_TERM_CONN = (0x16, "CONNECTION TERMINATED BY LOCAL HOST")
    REPEATED_ATTEMPTS = (0x17, "REPEATED ATTEMPTS")
    PAIRING_NOT_ALLOWED = (0x18, "PAIRING NOT ALLOWED")
    UNKNOWN_LMP_PDU = (0x19, "UNKNOWN LMP PDU")
    UNSUPP_REMOTE_FEATURE = (0x1A, "UNSUPPORTED REMOTE FEATURE")
    SCO_OFFSET_REJECTED = (0x1B, "SCO OFFSET REJECTED")
    SCO_INTERVAL_REJECTED = (0x1C, "SCO INTERVAL REJECTED")
    SCO_AIR_MODE_REJECTED = (0x1D, "SCO AIR MODE REJECTED")
    INVALID_LL_PARAM = (0x1E, "INVALID LL PARAMETERS")
    UNSPECIFIED = (0x1F, "UNSPECIFIED ERROR")
    UNSUPP_LL_PARAM_VAL = (0x20, "UNSUPPORTED LL PARAMETER VALUE")
    ROLE_CHANGE_NOT_ALLOWED = (0x21, "ROLE CHANGE NOT ALLOWED")
    LL_RESP_TIMEOUT = (0x22, "LL RESPONSE TIMEOUT")
    LL_PROC_COLLISION = (0x23, "LL PROCEDURE COLLISION")
    LMP_PDU_NOT_ALLOWED = (0x24, "LMP PDU NOT ALLOWED")
    ENC_MODE_NOT_ACCEPTABLE = (0x25, "ENCRYPTION MODE NOT ACCEPTABLE")
    LINK_KEY_CANNOT_BE_CHANGED = (0x26, "LINK KEY CANNOT BE CHANGED")
    REQUESTED_QOS_NOT_SUPPORTED = (0x27, "REQUESTED QoS NOT SUPPORTED")
    INSTANT_PASSED = (0x28, "INSTANT PASSED")
    PAIRING_NOT_SUPPORTED = (0x29, "PAIRING WITH UNIT KEY NOT SUPPORTED")
    DIFF_TRANS_COLLISION = (0x2A, "DIFFERENT TRANSACTION COLLISION")
    QOS_UNACCEPTABLE_PARAM = (0x2C, "QoS UNACCEPTABLE PARAMETER")
    QOS_REJECTED = (0x2D, "QoS REJECTED")
    CHAN_ASSESS_NOT_SUPPORTED = (0x2E, "CHANNEL ASSESSMENT NOT SUPPORTED")
    INSUFF_SECURITY = (0x2F, "INSUFFICIENT SECURITY")
    PARAM_OUT_OF_MANDATORY_RANGE = (0x30, "PARAMETER OUT OF MANDATORY RANGE")
    ROLE_SWITCH_PENDING = (0x32, "ROLE SWITCH PENDING")
    RESERVED_SLOT_VIOLATION = (0x34, "RESERVED SLOT VIOLATION")
    ROLE_SWITCH_FAILED = (0x35, "ROLE SWITCH FAILED")
    EXT_INQ_RESP_TOO_LARGE = (0x36, "EXTENDED INQUIRY RESPONSE TOO LARGE")
    SIMPLE_PAIR_NOT_SUPP_BY_HOST = (0x37, "SECURE SIMPLE PAIRING NOT SUPPORTED BY HOST")
    HOST_BUSY_PAIRING = (0x38, "HOST BUSY–PAIRING")
    CONN_REJECTED_DUE_TO_NO_CHAN = (0x39, "CONNECTION REJECTED DUE TO NO SUITABLE CHANNEL FOUND")
    CONTROLLER_BUSY = (0x3A, "CONTROLLER BUSY")
    UNACCEPT_CONN_PARAM = (0x3B, "UNACCEPTABLE CONNECTION PARAMETERS")
    ADV_TIMEOUT = (0x3C, "ADVERTISING TIMEOUT")
    TERM_DUE_TO_MIC_FAIL = (0x3D, "CONNECTION TERMINATED DUE TO MIC FAILURE")
    CONN_FAIL_TO_ESTAB = (0x3E, "CONNECTION FAILED TO BE ESTABLISHED")
    MAC_CONN_FAILED = (0x3F, "LEGACY ERROR")
    CLOCK_ADJUST_REJECTED = (0x40, "COARSE CLOCK ADJUSTMENT REJECTED")
    SUBMAP_NOT_DEFINED = (0x41, "TYPE0 SUBMAP NOT DEFINED")
    UNKNOWN_ADV_IDENTIFIER = (0x42, "UNKNOWN ADVERTISING IDENTIFIER")
    LIMIT_REACHED = (0x43, "LIMIT REACHED")
    OP_CANCELLED_BY_HOST = (0x44, "OPERATION CANCELLED BY HOST")
    PACKET_TOO_LONG = (0x45, "PACKET TOO LONG")
    TOO_LATE = (0x46, "TOO LATE")
    TOO_EARLY = (0x47, "TOO EARLY")

    description: str

    def __new__(cls, value: int, description: str = ""):
        obj = int.__new__(cls, value)
        obj._value_ = value
        obj.description = description
        return obj

    @classmethod
    def strerror(cls, int) -> str:
        return cls(int).description
