#!/usr/bin/env python3
# mypy: ignore-errors
"""Autogenerated TDF decoding logic"""

import ctypes

from infuse_iot.generated.tdf_base import TdfReadingBase, TdfStructBase


class structs:
    class tdf_struct_mcuboot_img_sem_ver(TdfStructBase):
        """MCUboot semantic versioning struct"""

        _fields_ = [
            ("major", ctypes.c_uint8),
            ("minor", ctypes.c_uint8),
            ("revision", ctypes.c_uint16),
            ("build_num", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "major": "",
            "minor": "",
            "revision": "",
            "build_num": "",
        }
        _display_fmt_ = {
            "major": "{}",
            "minor": "{}",
            "revision": "{}",
            "build_num": "0x{:08x}",
        }

    class tdf_struct_xyz_16bit(TdfStructBase):
        """Generic 3-axis sensor reading"""

        _fields_ = [
            ("x", ctypes.c_int16),
            ("y", ctypes.c_int16),
            ("z", ctypes.c_int16),
        ]
        _pack_ = 1
        _postfix_ = {
            "x": "",
            "y": "",
            "z": "",
        }
        _display_fmt_ = {
            "x": "{}",
            "y": "{}",
            "z": "{}",
        }

    class tdf_struct_gcs_location(TdfStructBase):
        """Geographic Coordinate System location"""

        _fields_ = [
            ("_latitude", ctypes.c_int32),
            ("_longitude", ctypes.c_int32),
            ("_height", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "latitude": "deg",
            "longitude": "deg",
            "height": "m",
        }
        _display_fmt_ = {
            "latitude": "{:.5f}",
            "longitude": "{:.5f}",
            "height": "{:.3f}",
        }

        @property
        def latitude(self):
            return self._latitude * 1e-07

        @property
        def longitude(self):
            return self._longitude * 1e-07

        @property
        def height(self):
            return self._height * 0.001

    class tdf_struct_lte_cell_id_local(TdfStructBase):
        """LTE cell ID (Local)"""

        _fields_ = [
            ("eci", ctypes.c_uint32),
            ("tac", ctypes.c_uint16),
        ]
        _pack_ = 1
        _postfix_ = {
            "eci": "",
            "tac": "",
        }
        _display_fmt_ = {
            "eci": "{}",
            "tac": "{}",
        }

    class tdf_struct_lte_cell_id_global(TdfStructBase):
        """LTE cell ID (Global)"""

        _fields_ = [
            ("mcc", ctypes.c_uint16),
            ("mnc", ctypes.c_uint16),
            ("eci", ctypes.c_uint32),
            ("tac", ctypes.c_uint16),
        ]
        _pack_ = 1
        _postfix_ = {
            "mcc": "",
            "mnc": "",
            "eci": "",
            "tac": "",
        }
        _display_fmt_ = {
            "mcc": "{}",
            "mnc": "{}",
            "eci": "{}",
            "tac": "{}",
        }

    class tdf_struct_lte_cell_neighbour(TdfStructBase):
        """LTE cell ID (Global)"""

        _fields_ = [
            ("earfcn", ctypes.c_uint32),
            ("pci", ctypes.c_uint16),
            ("_time_diff", ctypes.c_uint16),
            ("_rsrp", ctypes.c_uint8),
            ("rsrq", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "earfcn": "",
            "pci": "",
            "time_diff": "s",
            "rsrp": "dBm",
            "rsrq": "dB",
        }
        _display_fmt_ = {
            "earfcn": "{}",
            "pci": "{}",
            "time_diff": "{}",
            "rsrp": "{}",
            "rsrq": "{}",
        }

        @property
        def time_diff(self):
            return self._time_diff * 0.001

        @property
        def rsrp(self):
            return self._rsrp * -1

    class tdf_struct_bt_addr_le(TdfStructBase):
        """Bluetooth address type (bt_addr_le_t)"""

        _fields_ = [
            ("type", ctypes.c_uint8),
            ("_val", 6 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "type": "",
            "val": "",
        }
        _display_fmt_ = {
            "type": "{}",
            "val": "0x{:012x}",
        }

        @property
        def val(self):
            return int.from_bytes(self._val, byteorder="little")

    class tdf_struct_eui48(TdfStructBase):
        """IEEE EUI-48 address"""

        _fields_ = [
            ("_val", 6 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "val": "",
        }
        _display_fmt_ = {
            "val": "0x{:012x}",
        }

        @property
        def val(self):
            return int.from_bytes(self._val, byteorder="little")

    class tdf_struct_wifi_network_params(TdfStructBase):
        """WiFi network parameters"""

        _fields_ = [
            ("_bssid", 6 * ctypes.c_uint8),
            ("band", ctypes.c_uint8),
            ("channel", ctypes.c_uint8),
            ("iface_mode", ctypes.c_uint8),
            ("link_mode", ctypes.c_uint8),
            ("security", ctypes.c_uint8),
            ("rssi", ctypes.c_int8),
            ("beacon_interval", ctypes.c_uint16),
            ("twt_capable", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "bssid": "",
            "band": "",
            "channel": "",
            "iface_mode": "",
            "link_mode": "",
            "security": "",
            "rssi": "",
            "beacon_interval": "",
            "twt_capable": "",
        }
        _display_fmt_ = {
            "bssid": "0x{:012x}",
            "band": "{}",
            "channel": "{}",
            "iface_mode": "{}",
            "link_mode": "{}",
            "security": "{}",
            "rssi": "{}",
            "beacon_interval": "{}",
            "twt_capable": "{}",
        }

        @property
        def bssid(self):
            return int.from_bytes(self._bssid, byteorder="big")


class readings:
    class announce(TdfReadingBase):
        """Common announcement packet"""

        ID = 1
        NAME = "ANNOUNCE"
        _fields_ = [
            ("application", ctypes.c_uint32),
            ("version", structs.tdf_struct_mcuboot_img_sem_ver),
            ("kv_crc", ctypes.c_uint32),
            ("blocks", ctypes.c_uint32),
            ("uptime", ctypes.c_uint32),
            ("reboots", ctypes.c_uint16),
            ("flags", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "application": "",
            "version": "",
            "kv_crc": "",
            "blocks": "",
            "uptime": "",
            "reboots": "",
            "flags": "",
        }
        _display_fmt_ = {
            "application": "0x{:08x}",
            "version": "{}",
            "kv_crc": "0x{:08x}",
            "blocks": "{}",
            "uptime": "{}",
            "reboots": "{}",
            "flags": "0x{:02x}",
        }

    class battery_state(TdfReadingBase):
        """General battery state"""

        ID = 2
        NAME = "BATTERY_STATE"
        _fields_ = [
            ("voltage_mv", ctypes.c_uint32),
            ("current_ua", ctypes.c_int32),
            ("soc", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "voltage_mv": "mV",
            "current_ua": "uA",
            "soc": "%",
        }
        _display_fmt_ = {
            "voltage_mv": "{}",
            "current_ua": "{}",
            "soc": "{}",
        }

    class ambient_temp_pres_hum(TdfReadingBase):
        """Ambient temperature, pressure & humidity"""

        ID = 3
        NAME = "AMBIENT_TEMP_PRES_HUM"
        _fields_ = [
            ("_temperature", ctypes.c_int32),
            ("_pressure", ctypes.c_uint32),
            ("_humidity", ctypes.c_uint16),
        ]
        _pack_ = 1
        _postfix_ = {
            "temperature": "deg",
            "pressure": "kPA",
            "humidity": "%",
        }
        _display_fmt_ = {
            "temperature": "{:.3f}",
            "pressure": "{:.3f}",
            "humidity": "{:.2f}",
        }

        @property
        def temperature(self):
            return self._temperature * 0.001

        @property
        def pressure(self):
            return self._pressure * 0.001

        @property
        def humidity(self):
            return self._humidity * 0.01

    class ambient_temperature(TdfReadingBase):
        """Ambient temperature"""

        ID = 4
        NAME = "AMBIENT_TEMPERATURE"
        _fields_ = [
            ("_temperature", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "temperature": "deg",
        }
        _display_fmt_ = {
            "temperature": "{:.3f}",
        }

        @property
        def temperature(self):
            return self._temperature * 0.001

    class time_sync(TdfReadingBase):
        """Time synchronised to new source"""

        ID = 5
        NAME = "TIME_SYNC"
        _fields_ = [
            ("source", ctypes.c_uint8),
            ("_shift", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "source": "",
            "shift": "us",
        }
        _display_fmt_ = {
            "source": "{}",
            "shift": "{}",
        }

        @property
        def shift(self):
            return self._shift * 1e-06

    class reboot_info(TdfReadingBase):
        """Information pertaining to the previous reboot"""

        ID = 6
        NAME = "REBOOT_INFO"
        _fields_ = [
            ("reason", ctypes.c_uint8),
            ("hardware_flags", ctypes.c_uint32),
            ("count", ctypes.c_uint32),
            ("uptime", ctypes.c_uint32),
            ("param_1", ctypes.c_uint32),
            ("param_2", ctypes.c_uint32),
            ("thread", 8 * ctypes.c_char),
        ]
        _pack_ = 1
        _postfix_ = {
            "reason": "",
            "hardware_flags": "",
            "count": "",
            "uptime": "",
            "param_1": "",
            "param_2": "",
            "thread": "",
        }
        _display_fmt_ = {
            "reason": "{}",
            "hardware_flags": "0x{:08x}",
            "count": "{}",
            "uptime": "{}",
            "param_1": "0x{:08x}",
            "param_2": "0x{:08x}",
            "thread": "{}",
        }

    class acc_2g(TdfReadingBase):
        """Accelerometer +-2G"""

        ID = 10
        NAME = "ACC_2G"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class acc_4g(TdfReadingBase):
        """Accelerometer +-4G"""

        ID = 11
        NAME = "ACC_4G"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class acc_8g(TdfReadingBase):
        """Accelerometer +-8G"""

        ID = 12
        NAME = "ACC_8G"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class acc_16g(TdfReadingBase):
        """Accelerometer +-16G"""

        ID = 13
        NAME = "ACC_16G"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gyr_125dps(TdfReadingBase):
        """Gyroscope +-125 DPS"""

        ID = 14
        NAME = "GYR_125DPS"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gyr_250dps(TdfReadingBase):
        """Gyroscope +-250 DPS"""

        ID = 15
        NAME = "GYR_250DPS"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gyr_500dps(TdfReadingBase):
        """Gyroscope +-500 DPS"""

        ID = 16
        NAME = "GYR_500DPS"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gyr_1000dps(TdfReadingBase):
        """Gyroscope +-1000 DPS"""

        ID = 17
        NAME = "GYR_1000DPS"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gyr_2000dps(TdfReadingBase):
        """Gyroscope +-2000 DPS"""

        ID = 18
        NAME = "GYR_2000DPS"
        _fields_ = [
            ("sample", structs.tdf_struct_xyz_16bit),
        ]
        _pack_ = 1
        _postfix_ = {
            "sample": "",
        }
        _display_fmt_ = {
            "sample": "{}",
        }

    class gcs_wgs84_llha(TdfReadingBase):
        """Geo-location (WGS-84) + accuracy"""

        ID = 19
        NAME = "GCS_WGS84_LLHA"
        _fields_ = [
            ("location", structs.tdf_struct_gcs_location),
            ("_h_acc", ctypes.c_int32),
            ("_v_acc", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "location": "",
            "h_acc": "m",
            "v_acc": "m",
        }
        _display_fmt_ = {
            "location": "{}",
            "h_acc": "{:.3f}",
            "v_acc": "{:.3f}",
        }

        @property
        def h_acc(self):
            return self._h_acc * 0.001

        @property
        def v_acc(self):
            return self._v_acc * 0.001

    class ubx_nav_pvt(TdfReadingBase):
        """u-blox GNSS NAV-PVT message"""

        ID = 20
        NAME = "UBX_NAV_PVT"
        _fields_ = [
            ("itow", ctypes.c_uint32),
            ("year", ctypes.c_uint16),
            ("month", ctypes.c_uint8),
            ("day", ctypes.c_uint8),
            ("hour", ctypes.c_uint8),
            ("min", ctypes.c_uint8),
            ("sec", ctypes.c_uint8),
            ("valid", ctypes.c_uint8),
            ("t_acc", ctypes.c_uint32),
            ("nano", ctypes.c_int32),
            ("fix_type", ctypes.c_uint8),
            ("flags", ctypes.c_uint8),
            ("flags2", ctypes.c_uint8),
            ("num_sv", ctypes.c_uint8),
            ("_lon", ctypes.c_int32),
            ("_lat", ctypes.c_int32),
            ("_height", ctypes.c_int32),
            ("_h_msl", ctypes.c_int32),
            ("_h_acc", ctypes.c_uint32),
            ("_v_acc", ctypes.c_uint32),
            ("_vel_n", ctypes.c_int32),
            ("_vel_e", ctypes.c_int32),
            ("_vel_d", ctypes.c_int32),
            ("_g_speed", ctypes.c_int32),
            ("_head_mot", ctypes.c_int32),
            ("_s_acc", ctypes.c_uint32),
            ("_head_acc", ctypes.c_uint32),
            ("_p_dop", ctypes.c_uint16),
            ("flags3", ctypes.c_uint16),
            ("reserved0", 4 * ctypes.c_uint8),
            ("_head_veh", ctypes.c_int32),
            ("_mag_dec", ctypes.c_int16),
            ("_mag_acc", ctypes.c_uint16),
        ]
        _pack_ = 1
        _postfix_ = {
            "itow": "",
            "year": "",
            "month": "",
            "day": "",
            "hour": "",
            "min": "",
            "sec": "",
            "valid": "",
            "t_acc": "ns",
            "nano": "ns",
            "fix_type": "",
            "flags": "",
            "flags2": "",
            "num_sv": "",
            "lon": "deg",
            "lat": "deg",
            "height": "m",
            "h_msl": "m",
            "h_acc": "m",
            "v_acc": "m",
            "vel_n": "m/s",
            "vel_e": "m/s",
            "vel_d": "m/s",
            "g_speed": "m/s",
            "head_mot": "deg",
            "s_acc": "m/s",
            "head_acc": "deg",
            "p_dop": "",
            "flags3": "",
            "reserved0": "",
            "head_veh": "deg",
            "mag_dec": "deg",
            "mag_acc": "deg",
        }
        _display_fmt_ = {
            "itow": "{}",
            "year": "{}",
            "month": "{}",
            "day": "{}",
            "hour": "{}",
            "min": "{}",
            "sec": "{}",
            "valid": "0x{:02x}",
            "t_acc": "{}",
            "nano": "{}",
            "fix_type": "{}",
            "flags": "0x{:02x}",
            "flags2": "0x{:02x}",
            "num_sv": "{}",
            "lon": "{}",
            "lat": "{}",
            "height": "{}",
            "h_msl": "{}",
            "h_acc": "{}",
            "v_acc": "{}",
            "vel_n": "{}",
            "vel_e": "{}",
            "vel_d": "{}",
            "g_speed": "{}",
            "head_mot": "{}",
            "s_acc": "{}",
            "head_acc": "{}",
            "p_dop": "{}",
            "flags3": "0x{:04x}",
            "reserved0": "{}",
            "head_veh": "{}",
            "mag_dec": "{}",
            "mag_acc": "{}",
        }

        @property
        def lon(self):
            return self._lon * 1e-07

        @property
        def lat(self):
            return self._lat * 1e-07

        @property
        def height(self):
            return self._height * 0.001

        @property
        def h_msl(self):
            return self._h_msl * 0.001

        @property
        def h_acc(self):
            return self._h_acc * 0.001

        @property
        def v_acc(self):
            return self._v_acc * 0.001

        @property
        def vel_n(self):
            return self._vel_n * 0.001

        @property
        def vel_e(self):
            return self._vel_e * 0.001

        @property
        def vel_d(self):
            return self._vel_d * 0.001

        @property
        def g_speed(self):
            return self._g_speed * 0.001

        @property
        def head_mot(self):
            return self._head_mot * 1e-05

        @property
        def s_acc(self):
            return self._s_acc * 0.001

        @property
        def head_acc(self):
            return self._head_acc * 1e-05

        @property
        def p_dop(self):
            return self._p_dop * 0.01

        @property
        def head_veh(self):
            return self._head_veh * 1e-05

        @property
        def mag_dec(self):
            return self._mag_dec * 0.01

        @property
        def mag_acc(self):
            return self._mag_acc * 0.01

    class lte_conn_status(TdfReadingBase):
        """Information on service cell and registration status"""

        ID = 21
        NAME = "LTE_CONN_STATUS"
        _fields_ = [
            ("cell", structs.tdf_struct_lte_cell_id_global),
            ("earfcn", ctypes.c_uint32),
            ("status", ctypes.c_uint8),
            ("tech", ctypes.c_uint8),
            ("_rsrp", ctypes.c_uint8),
            ("rsrq", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "cell": "",
            "earfcn": "",
            "status": "",
            "tech": "",
            "rsrp": "dBm",
            "rsrq": "dB",
        }
        _display_fmt_ = {
            "cell": "{}",
            "earfcn": "{}",
            "status": "{}",
            "tech": "{}",
            "rsrp": "{}",
            "rsrq": "{}",
        }

        @property
        def rsrp(self):
            return self._rsrp * -1

    class globalstar_pkt(TdfReadingBase):
        """9 byte payload transmitted over the Globalstar Simplex network"""

        ID = 22
        NAME = "GLOBALSTAR_PKT"
        _fields_ = [
            ("payload", 9 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "payload": "",
        }
        _display_fmt_ = {
            "payload": "{}",
        }

    class acc_magnitude_std_dev(TdfReadingBase):
        """Accelerometer magnitude standard deviation over a window"""

        ID = 23
        NAME = "ACC_MAGNITUDE_STD_DEV"
        _fields_ = [
            ("count", ctypes.c_uint32),
            ("std_dev", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "count": "",
            "std_dev": "",
        }
        _display_fmt_ = {
            "count": "{}",
            "std_dev": "{}",
        }

    class activity_metric(TdfReadingBase):
        """Generic activity metric"""

        ID = 24
        NAME = "ACTIVITY_METRIC"
        _fields_ = [
            ("value", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "value": "",
        }
        _display_fmt_ = {
            "value": "{}",
        }

    class algorithm_output(TdfReadingBase):
        """Instantaneous algorithm output"""

        ID = 25
        NAME = "ALGORITHM_OUTPUT"
        _fields_ = [
            ("algorithm_id", ctypes.c_uint32),
            ("algorithm_version", ctypes.c_uint16),
            ("output", 0 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "algorithm_id": "",
            "algorithm_version": "",
            "output": "",
        }
        _display_fmt_ = {
            "algorithm_id": "0x{:08x}",
            "algorithm_version": "{}",
            "output": "{}",
        }

    class runtime_error(TdfReadingBase):
        """Runtime error logging"""

        ID = 26
        NAME = "RUNTIME_ERROR"
        _fields_ = [
            ("error_id", ctypes.c_uint32),
            ("error_ctx", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "error_id": "",
            "error_ctx": "",
        }
        _display_fmt_ = {
            "error_id": "{}",
            "error_ctx": "{}",
        }

    class charger_en_control(TdfReadingBase):
        """Battery charging enable state"""

        ID = 27
        NAME = "CHARGER_EN_CONTROL"
        _fields_ = [
            ("enabled", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "enabled": "",
        }
        _display_fmt_ = {
            "enabled": "{}",
        }

    class gnss_fix_info(TdfReadingBase):
        """Metadata about a GNSS location fix"""

        ID = 28
        NAME = "GNSS_FIX_INFO"
        _fields_ = [
            ("time_fix", ctypes.c_uint16),
            ("location_fix", ctypes.c_uint16),
            ("num_sv", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "time_fix": "",
            "location_fix": "",
            "num_sv": "",
        }
        _display_fmt_ = {
            "time_fix": "{}",
            "location_fix": "{}",
            "num_sv": "{}",
        }

    class bluetooth_connection(TdfReadingBase):
        """Bluetooth connection state change"""

        ID = 29
        NAME = "BLUETOOTH_CONNECTION"
        _fields_ = [
            ("address", structs.tdf_struct_bt_addr_le),
            ("connected", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "address": "",
            "connected": "",
        }
        _display_fmt_ = {
            "address": "{}",
            "connected": "{}",
        }

    class bluetooth_rssi(TdfReadingBase):
        """Received signal strength of Bluetooth device"""

        ID = 30
        NAME = "BLUETOOTH_RSSI"
        _fields_ = [
            ("address", structs.tdf_struct_bt_addr_le),
            ("rssi", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "address": "",
            "rssi": "dBm",
        }
        _display_fmt_ = {
            "address": "{}",
            "rssi": "{}",
        }

    class bluetooth_data_throughput(TdfReadingBase):
        """Data throughput of Bluetooth link"""

        ID = 31
        NAME = "BLUETOOTH_DATA_THROUGHPUT"
        _fields_ = [
            ("address", structs.tdf_struct_bt_addr_le),
            ("throughput", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "address": "",
            "throughput": "B/sec",
        }
        _display_fmt_ = {
            "address": "{}",
            "throughput": "{}",
        }

    class algorithm_class_histogram(TdfReadingBase):
        """Algorithm output class histogram over a time window"""

        ID = 32
        NAME = "ALGORITHM_CLASS_HISTOGRAM"
        _fields_ = [
            ("algorithm_id", ctypes.c_uint32),
            ("algorithm_version", ctypes.c_uint16),
            ("classes", 0 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "algorithm_id": "",
            "algorithm_version": "",
            "classes": "",
        }
        _display_fmt_ = {
            "algorithm_id": "0x{:08x}",
            "algorithm_version": "{}",
            "classes": "{}",
        }

    class algorithm_class_time_series(TdfReadingBase):
        """Algorithm output class time series vector"""

        ID = 33
        NAME = "ALGORITHM_CLASS_TIME_SERIES"
        _fields_ = [
            ("algorithm_id", ctypes.c_uint32),
            ("algorithm_version", ctypes.c_uint16),
            ("values", 0 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "algorithm_id": "",
            "algorithm_version": "",
            "values": "",
        }
        _display_fmt_ = {
            "algorithm_id": "0x{:08x}",
            "algorithm_version": "{}",
            "values": "{}",
        }

    class lte_tac_cells(TdfReadingBase):
        """Information on cells in a tracking area"""

        ID = 34
        NAME = "LTE_TAC_CELLS"
        _fields_ = [
            ("cell", structs.tdf_struct_lte_cell_id_global),
            ("earfcn", ctypes.c_uint32),
            ("_rsrp", ctypes.c_uint8),
            ("rsrq", ctypes.c_int8),
            ("neighbours", 0 * structs.tdf_struct_lte_cell_neighbour),
        ]
        _pack_ = 1
        _postfix_ = {
            "cell": "",
            "earfcn": "",
            "rsrp": "dBm",
            "rsrq": "dB",
            "neighbours": "",
        }
        _display_fmt_ = {
            "cell": "{}",
            "earfcn": "{}",
            "rsrp": "{}",
            "rsrq": "{}",
            "neighbours": "{}",
        }

        @property
        def rsrp(self):
            return self._rsrp * -1

    class wifi_ap_info(TdfReadingBase):
        """Wi-Fi access point information"""

        ID = 35
        NAME = "WIFI_AP_INFO"
        _fields_ = [
            ("bssid", structs.tdf_struct_eui48),
            ("channel", ctypes.c_uint8),
            ("rsrp", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "bssid": "",
            "channel": "",
            "rsrp": "",
        }
        _display_fmt_ = {
            "bssid": "{}",
            "channel": "{}",
            "rsrp": "{}",
        }

    class device_tilt(TdfReadingBase):
        """Tilt angle of the device"""

        ID = 36
        NAME = "DEVICE_TILT"
        _fields_ = [
            ("cosine", ctypes.c_float),
        ]
        _pack_ = 1
        _postfix_ = {
            "cosine": "",
        }
        _display_fmt_ = {
            "cosine": "{:.6f}",
        }

    class nrf9x_gnss_pvt(TdfReadingBase):
        """nRF9x GNSS PVT data frame"""

        ID = 37
        NAME = "NRF9X_GNSS_PVT"
        _fields_ = [
            ("_lat", ctypes.c_int32),
            ("_lon", ctypes.c_int32),
            ("_height", ctypes.c_int32),
            ("_h_acc", ctypes.c_uint32),
            ("_v_acc", ctypes.c_uint32),
            ("_h_speed", ctypes.c_int32),
            ("_h_speed_acc", ctypes.c_uint32),
            ("_v_speed", ctypes.c_int32),
            ("_v_speed_acc", ctypes.c_uint32),
            ("_head_mot", ctypes.c_int32),
            ("_head_acc", ctypes.c_uint32),
            ("year", ctypes.c_uint16),
            ("month", ctypes.c_uint8),
            ("day", ctypes.c_uint8),
            ("hour", ctypes.c_uint8),
            ("min", ctypes.c_uint8),
            ("sec", ctypes.c_uint8),
            ("ms", ctypes.c_uint16),
            ("_p_dop", ctypes.c_uint16),
            ("_h_dop", ctypes.c_uint16),
            ("_v_dop", ctypes.c_uint16),
            ("_t_dop", ctypes.c_uint16),
            ("flags", ctypes.c_uint8),
            ("num_sv", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "lat": "deg",
            "lon": "deg",
            "height": "m",
            "h_acc": "m",
            "v_acc": "m",
            "h_speed": "m/s",
            "h_speed_acc": "m/s",
            "v_speed": "m/s",
            "v_speed_acc": "m/s",
            "head_mot": "deg",
            "head_acc": "deg",
            "year": "",
            "month": "",
            "day": "",
            "hour": "",
            "min": "",
            "sec": "",
            "ms": "",
            "p_dop": "",
            "h_dop": "",
            "v_dop": "",
            "t_dop": "",
            "flags": "",
            "num_sv": "",
        }
        _display_fmt_ = {
            "lat": "{}",
            "lon": "{}",
            "height": "{}",
            "h_acc": "{}",
            "v_acc": "{}",
            "h_speed": "{}",
            "h_speed_acc": "{}",
            "v_speed": "{}",
            "v_speed_acc": "{}",
            "head_mot": "{}",
            "head_acc": "{}",
            "year": "{}",
            "month": "{}",
            "day": "{}",
            "hour": "{}",
            "min": "{}",
            "sec": "{}",
            "ms": "{}",
            "p_dop": "{}",
            "h_dop": "{}",
            "v_dop": "{}",
            "t_dop": "{}",
            "flags": "0x{:02x}",
            "num_sv": "{}",
        }

        @property
        def lat(self):
            return self._lat * 1e-07

        @property
        def lon(self):
            return self._lon * 1e-07

        @property
        def height(self):
            return self._height * 0.001

        @property
        def h_acc(self):
            return self._h_acc * 0.001

        @property
        def v_acc(self):
            return self._v_acc * 0.001

        @property
        def h_speed(self):
            return self._h_speed * 0.001

        @property
        def h_speed_acc(self):
            return self._h_speed_acc * 0.001

        @property
        def v_speed(self):
            return self._v_speed * 0.001

        @property
        def v_speed_acc(self):
            return self._v_speed_acc * 0.001

        @property
        def head_mot(self):
            return self._head_mot * 1e-05

        @property
        def head_acc(self):
            return self._head_acc * 1e-05

        @property
        def p_dop(self):
            return self._p_dop * 0.01

        @property
        def h_dop(self):
            return self._h_dop * 0.01

        @property
        def v_dop(self):
            return self._v_dop * 0.01

        @property
        def t_dop(self):
            return self._t_dop * 0.01

    class battery_charge_accumulated(TdfReadingBase):
        """Battery charge accumulated over time (+ve entering battery, -ve exiting battery)"""

        ID = 38
        NAME = "BATTERY_CHARGE_ACCUMULATED"
        _fields_ = [
            ("charge", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "charge": "uAs",
        }
        _display_fmt_ = {
            "charge": "{}",
        }

    class infuse_bluetooth_rssi(TdfReadingBase):
        """Received signal strength of Infuse-IoT Bluetooth device"""

        ID = 39
        NAME = "INFUSE_BLUETOOTH_RSSI"
        _fields_ = [
            ("infuse_id", ctypes.c_uint64),
            ("rssi", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "infuse_id": "",
            "rssi": "dBm",
        }
        _display_fmt_ = {
            "infuse_id": "{}",
            "rssi": "{}",
        }

    class adc_raw_8(TdfReadingBase):
        """Generic 8bit raw ADC reading"""

        ID = 40
        NAME = "ADC_RAW_8"
        _fields_ = [
            ("val", ctypes.c_int8),
        ]
        _pack_ = 1
        _postfix_ = {
            "val": "",
        }
        _display_fmt_ = {
            "val": "{}",
        }

    class adc_raw_16(TdfReadingBase):
        """Generic 16bit raw ADC reading"""

        ID = 41
        NAME = "ADC_RAW_16"
        _fields_ = [
            ("val", ctypes.c_int16),
        ]
        _pack_ = 1
        _postfix_ = {
            "val": "",
        }
        _display_fmt_ = {
            "val": "{}",
        }

    class adc_raw_32(TdfReadingBase):
        """Generic 32bit raw ADC reading"""

        ID = 42
        NAME = "ADC_RAW_32"
        _fields_ = [
            ("val", ctypes.c_int32),
        ]
        _pack_ = 1
        _postfix_ = {
            "val": "",
        }
        _display_fmt_ = {
            "val": "{}",
        }

    class annotation(TdfReadingBase):
        """Generic event annotation"""

        ID = 43
        NAME = "ANNOTATION"
        _fields_ = [
            ("timestamp", ctypes.c_uint32),
            ("event", 0 * ctypes.c_char),
        ]
        _pack_ = 1
        _postfix_ = {
            "timestamp": "",
            "event": "",
        }
        _display_fmt_ = {
            "timestamp": "{}",
            "event": "{}",
        }

    class lora_rx(TdfReadingBase):
        """Received LoRa packet"""

        ID = 44
        NAME = "LORA_RX"
        _fields_ = [
            ("snr", ctypes.c_int8),
            ("rssi", ctypes.c_int16),
            ("payload", 0 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "snr": "dB",
            "rssi": "dBm",
            "payload": "",
        }
        _display_fmt_ = {
            "snr": "{}",
            "rssi": "{}",
            "payload": "0x{:02x}",
        }

    class lora_tx(TdfReadingBase):
        """Transmitted LoRa packet"""

        ID = 45
        NAME = "LORA_TX"
        _fields_ = [
            ("payload", 0 * ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "payload": "",
        }
        _display_fmt_ = {
            "payload": "0x{:02x}",
        }

    class idx_array_freq(TdfReadingBase):
        """Sample frequency metadata for a TDF_DATA_FORMAT_IDX_ARRAY array"""

        ID = 46
        NAME = "IDX_ARRAY_FREQ"
        _fields_ = [
            ("tdf_id", ctypes.c_uint16),
            ("frequency", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "tdf_id": "",
            "frequency": "Hz",
        }
        _display_fmt_ = {
            "tdf_id": "{}",
            "frequency": "{}",
        }

    class idx_array_period(TdfReadingBase):
        """Sample frequency metadata for a TDF_DATA_FORMAT_IDX_ARRAY array"""

        ID = 47
        NAME = "IDX_ARRAY_PERIOD"
        _fields_ = [
            ("tdf_id", ctypes.c_uint16),
            ("period", ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "tdf_id": "",
            "period": "ns",
        }
        _display_fmt_ = {
            "tdf_id": "{}",
            "period": "{}",
        }

    class wifi_connected(TdfReadingBase):
        """WiFi network is now connected"""

        ID = 48
        NAME = "WIFI_CONNECTED"
        _fields_ = [
            ("network", structs.tdf_struct_wifi_network_params),
        ]
        _pack_ = 1
        _postfix_ = {
            "network": "",
        }
        _display_fmt_ = {
            "network": "{}",
        }

    class wifi_connection_failed(TdfReadingBase):
        """Failed to connect to a WiFi network"""

        ID = 49
        NAME = "WIFI_CONNECTION_FAILED"
        _fields_ = [
            ("reason", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "reason": "",
        }
        _display_fmt_ = {
            "reason": "{}",
        }

    class wifi_disconnected(TdfReadingBase):
        """Wi-Fi network is now disconnected"""

        ID = 50
        NAME = "WIFI_DISCONNECTED"
        _fields_ = [
            ("reason", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "reason": "",
        }
        _display_fmt_ = {
            "reason": "{}",
        }

    class network_scan_count(TdfReadingBase):
        """Counts associated with scanning Wi-Fi and LTE networks"""

        ID = 51
        NAME = "NETWORK_SCAN_COUNT"
        _fields_ = [
            ("num_wifi", ctypes.c_uint8),
            ("num_lte", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "num_wifi": "",
            "num_lte": "",
        }
        _display_fmt_ = {
            "num_wifi": "{}",
            "num_lte": "{}",
        }

    class exception_stack_frame(TdfReadingBase):
        """Generic exception stack frame"""

        ID = 52
        NAME = "EXCEPTION_STACK_FRAME"
        _fields_ = [
            ("frame", 0 * ctypes.c_uint32),
        ]
        _pack_ = 1
        _postfix_ = {
            "frame": "",
        }
        _display_fmt_ = {
            "frame": "0x{:08x}",
        }

    class battery_voltage(TdfReadingBase):
        """Battery voltage"""

        ID = 53
        NAME = "BATTERY_VOLTAGE"
        _fields_ = [
            ("voltage", ctypes.c_uint16),
        ]
        _pack_ = 1
        _postfix_ = {
            "voltage": "mV",
        }
        _display_fmt_ = {
            "voltage": "{}",
        }

    class battery_soc(TdfReadingBase):
        """Battery state of charge"""

        ID = 54
        NAME = "BATTERY_SOC"
        _fields_ = [
            ("soc", ctypes.c_uint8),
        ]
        _pack_ = 1
        _postfix_ = {
            "soc": "%",
        }
        _display_fmt_ = {
            "soc": "{}",
        }


id_type_mapping: dict[int, type[TdfReadingBase]] = {
    readings.announce.ID: readings.announce,
    readings.battery_state.ID: readings.battery_state,
    readings.ambient_temp_pres_hum.ID: readings.ambient_temp_pres_hum,
    readings.ambient_temperature.ID: readings.ambient_temperature,
    readings.time_sync.ID: readings.time_sync,
    readings.reboot_info.ID: readings.reboot_info,
    readings.acc_2g.ID: readings.acc_2g,
    readings.acc_4g.ID: readings.acc_4g,
    readings.acc_8g.ID: readings.acc_8g,
    readings.acc_16g.ID: readings.acc_16g,
    readings.gyr_125dps.ID: readings.gyr_125dps,
    readings.gyr_250dps.ID: readings.gyr_250dps,
    readings.gyr_500dps.ID: readings.gyr_500dps,
    readings.gyr_1000dps.ID: readings.gyr_1000dps,
    readings.gyr_2000dps.ID: readings.gyr_2000dps,
    readings.gcs_wgs84_llha.ID: readings.gcs_wgs84_llha,
    readings.ubx_nav_pvt.ID: readings.ubx_nav_pvt,
    readings.lte_conn_status.ID: readings.lte_conn_status,
    readings.globalstar_pkt.ID: readings.globalstar_pkt,
    readings.acc_magnitude_std_dev.ID: readings.acc_magnitude_std_dev,
    readings.activity_metric.ID: readings.activity_metric,
    readings.algorithm_output.ID: readings.algorithm_output,
    readings.runtime_error.ID: readings.runtime_error,
    readings.charger_en_control.ID: readings.charger_en_control,
    readings.gnss_fix_info.ID: readings.gnss_fix_info,
    readings.bluetooth_connection.ID: readings.bluetooth_connection,
    readings.bluetooth_rssi.ID: readings.bluetooth_rssi,
    readings.bluetooth_data_throughput.ID: readings.bluetooth_data_throughput,
    readings.algorithm_class_histogram.ID: readings.algorithm_class_histogram,
    readings.algorithm_class_time_series.ID: readings.algorithm_class_time_series,
    readings.lte_tac_cells.ID: readings.lte_tac_cells,
    readings.wifi_ap_info.ID: readings.wifi_ap_info,
    readings.device_tilt.ID: readings.device_tilt,
    readings.nrf9x_gnss_pvt.ID: readings.nrf9x_gnss_pvt,
    readings.battery_charge_accumulated.ID: readings.battery_charge_accumulated,
    readings.infuse_bluetooth_rssi.ID: readings.infuse_bluetooth_rssi,
    readings.adc_raw_8.ID: readings.adc_raw_8,
    readings.adc_raw_16.ID: readings.adc_raw_16,
    readings.adc_raw_32.ID: readings.adc_raw_32,
    readings.annotation.ID: readings.annotation,
    readings.lora_rx.ID: readings.lora_rx,
    readings.lora_tx.ID: readings.lora_tx,
    readings.idx_array_freq.ID: readings.idx_array_freq,
    readings.idx_array_period.ID: readings.idx_array_period,
    readings.wifi_connected.ID: readings.wifi_connected,
    readings.wifi_connection_failed.ID: readings.wifi_connection_failed,
    readings.wifi_disconnected.ID: readings.wifi_disconnected,
    readings.network_scan_count.ID: readings.network_scan_count,
    readings.exception_stack_frame.ID: readings.exception_stack_frame,
    readings.battery_voltage.ID: readings.battery_voltage,
    readings.battery_soc.ID: readings.battery_soc,
}

__all__ = [
    "structs",
    "readings",
    "id_type_mapping",
]
