#!/usr/bin/env python3
# mypy: ignore-errors

"""Autogenerated RPC definitions"""

import ctypes
import enum

from infuse_iot.util.ctypes import VLACompatLittleEndianStruct


class rpc_struct_mcuboot_img_sem_ver(VLACompatLittleEndianStruct):
    """MCUboot semantic versioning struct"""

    _fields_ = [
        ("major", ctypes.c_uint8),
        ("minor", ctypes.c_uint8),
        ("revision", ctypes.c_uint16),
        ("build_num", ctypes.c_uint32),
    ]
    _pack_ = 1


class rpc_struct_kv_store_value(VLACompatLittleEndianStruct):
    """KV store data value"""

    _fields_ = [
        ("id", ctypes.c_uint16),
        ("len", ctypes.c_int16),
    ]
    vla_field = ("data", 0 * ctypes.c_uint8)
    vla_counted_by = "len"
    _pack_ = 1


class rpc_struct_kv_store_crc(VLACompatLittleEndianStruct):
    """KV store data CRC"""

    _fields_ = [
        ("id", ctypes.c_uint16),
        ("crc", ctypes.c_uint32),
    ]
    _pack_ = 1


class rpc_struct_bt_addr_le(VLACompatLittleEndianStruct):
    """Bluetooth LE address"""

    _fields_ = [
        ("type", ctypes.c_uint8),
        ("val", 6 * ctypes.c_uint8),
    ]
    _pack_ = 1


class rpc_struct_ipv4_address(VLACompatLittleEndianStruct):
    """IPv4 address"""

    _fields_ = [
        ("addr", 4 * ctypes.c_uint8),
    ]
    _pack_ = 1


class rpc_struct_ipv6_address(VLACompatLittleEndianStruct):
    """IPv6 address"""

    _fields_ = [
        ("addr", 16 * ctypes.c_uint8),
    ]
    _pack_ = 1


class rpc_struct_network_state(VLACompatLittleEndianStruct):
    """Common network state"""

    _fields_ = [
        ("state", ctypes.c_uint8),
        ("if_flags", ctypes.c_uint32),
        ("l2_flags", ctypes.c_uint16),
        ("mtu", ctypes.c_uint16),
        ("ipv4", rpc_struct_ipv4_address),
        ("ipv6", rpc_struct_ipv6_address),
    ]
    _pack_ = 1


class rpc_struct_wifi_state(VLACompatLittleEndianStruct):
    """WiFi interface status"""

    _fields_ = [
        ("state", ctypes.c_uint8),
        ("ssid", 32 * ctypes.c_char),
        ("bssid", 6 * ctypes.c_uint8),
        ("band", ctypes.c_uint8),
        ("channel", ctypes.c_uint8),
        ("iface_mode", ctypes.c_uint8),
        ("link_mode", ctypes.c_uint8),
        ("security", ctypes.c_uint8),
        ("rssi", ctypes.c_int8),
        ("beacon_interval", ctypes.c_uint16),
        ("twt_capable", ctypes.c_uint8),
    ]
    _pack_ = 1


class rpc_struct_lte_state(VLACompatLittleEndianStruct):
    """LTE interface status"""

    _fields_ = [
        ("registration_state", ctypes.c_uint8),
        ("access_technology", ctypes.c_uint8),
        ("mcc", ctypes.c_uint16),
        ("mnc", ctypes.c_uint16),
        ("cell_id", ctypes.c_uint32),
        ("tac", ctypes.c_uint32),
        ("tau", ctypes.c_int32),
        ("earfcn", ctypes.c_uint16),
        ("band", ctypes.c_uint8),
        ("psm_active_time", ctypes.c_int16),
        ("edrx_interval", ctypes.c_float),
        ("edrx_paging_window", ctypes.c_float),
        ("rsrp", ctypes.c_int16),
        ("rsrq", ctypes.c_int8),
    ]
    _pack_ = 1


class rpc_struct_wifi_scan_result(VLACompatLittleEndianStruct):
    """WiFi interface status"""

    _fields_ = [
        ("band", ctypes.c_uint8),
        ("channel", ctypes.c_uint8),
        ("security", ctypes.c_uint8),
        ("rssi", ctypes.c_int8),
        ("bssid", 6 * ctypes.c_uint8),
        ("ssid_len", ctypes.c_uint8),
    ]
    vla_field = ("ssid", 0 * ctypes.c_char)
    vla_counted_by = "ssid_len"
    _pack_ = 1


class rpc_struct_xyz_s16(VLACompatLittleEndianStruct):
    """Signed 16 bit XYZ vector"""

    _fields_ = [
        ("x", ctypes.c_int16),
        ("y", ctypes.c_int16),
        ("z", ctypes.c_int16),
    ]
    _pack_ = 1


class rpc_struct_infuse_state(VLACompatLittleEndianStruct):
    """Single Infuse-IoT application state"""

    _fields_ = [
        ("state", ctypes.c_uint8),
        ("timeout", ctypes.c_uint16),
    ]
    _pack_ = 1


class rpc_struct_sockaddr(VLACompatLittleEndianStruct):
    """`struct sockaddr_in` or `struct sockaddr_in6` compatible address"""

    _fields_ = [
        ("sin_family", ctypes.c_uint8),
        ("sin_port", ctypes.c_uint16),
        ("sin_addr", 16 * ctypes.c_uint8),
        ("scope_id", ctypes.c_uint8),
    ]
    _pack_ = 1


class rpc_struct_heap_info(VLACompatLittleEndianStruct):
    """struct k_heap information"""

    _fields_ = [
        ("addr", ctypes.c_uint32),
        ("free_bytes", ctypes.c_uint32),
        ("allocated_bytes", ctypes.c_uint32),
        ("max_allocated_bytes", ctypes.c_uint32),
    ]
    _pack_ = 1


class rpc_enum_bt_le_addr_type(enum.IntEnum):
    """Bluetooth LE address type"""

    PUBLIC = 0
    RANDOM = 1


class rpc_enum_file_action(enum.IntEnum):
    """Actions to take upon receiving a file"""

    DISCARD = 0
    APP_IMG = 1
    BT_CTLR_IMG = 2
    APP_CPATCH = 11
    BT_CTLR_CPATCH = 12
    NRF91_MODEM_DIFF = 20
    FILE_FOR_COPY = 30


class rpc_enum_infuse_bt_characteristic(enum.IntEnum):
    """Infuse-IoT Bluetooth characteristics (Bitmask)"""

    COMMAND = 1
    DATA = 2
    LOGGING = 4


class rpc_enum_data_logger(enum.IntEnum):
    """Data Logger identifier"""

    FLASH_ONBOARD = 1
    FLASH_REMOVABLE = 2
    UDP = 3


class rpc_enum_zperf_data_source(enum.IntEnum):
    """Source for zperf data upload"""

    CONSTANT = 0
    RANDOM = 1
    FLASH_ONBOARD = 2
    FLASH_REMOVABLE = 3
    ENCRYPT = 128


class RPCDefinitionBase:
    NAME: str
    HELP: str
    DESCRIPTION: str
    COMMAND_ID: int


class reboot(RPCDefinitionBase):
    """Reboot the device after a delay"""

    NAME = "reboot"
    HELP = "Reboot the device after a delay"
    DESCRIPTION = "Reboot the device after a delay"
    COMMAND_ID = 1

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("delay_ms", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("delay_ms", ctypes.c_uint32),
        ]
        _pack_ = 1


class fault(RPCDefinitionBase):
    """Immediately trigger an exception on the device"""

    NAME = "fault"
    HELP = "Immediately trigger an exception on the device"
    DESCRIPTION = "Immediately trigger an exception on the device"
    COMMAND_ID = 2

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("fault", ctypes.c_uint8),
            ("zero", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class time_get(RPCDefinitionBase):
    """Get the current time knowledge of the device"""

    NAME = "time_get"
    HELP = "Get the current time knowledge of the device"
    DESCRIPTION = "Get the current time knowledge of the device"
    COMMAND_ID = 3

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("time_source", ctypes.c_uint8),
            ("epoch_time", ctypes.c_uint64),
            ("sync_age", ctypes.c_uint32),
        ]
        _pack_ = 1


class time_set(RPCDefinitionBase):
    """Set the current time of the device"""

    NAME = "time_set"
    HELP = "Set the current time of the device"
    DESCRIPTION = "Set the current time of the device"
    COMMAND_ID = 4

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("epoch_time", ctypes.c_uint64),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class kv_write(RPCDefinitionBase):
    """Write values to the KV store"""

    NAME = "kv_write"
    HELP = "Write values to the KV store"
    DESCRIPTION = "Write values to the KV store"
    COMMAND_ID = 5

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("num", ctypes.c_uint8),
        ]
        vla_field = ("values", 0 * rpc_struct_kv_store_value)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("rc", 0 * ctypes.c_int16)
        _pack_ = 1


class kv_read(RPCDefinitionBase):
    """Read values from the KV store"""

    NAME = "kv_read"
    HELP = "Read values from the KV store"
    DESCRIPTION = "Read values from the KV store"
    COMMAND_ID = 6

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("num", ctypes.c_uint8),
        ]
        vla_field = ("keys", 0 * ctypes.c_uint16)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("values", 0 * rpc_struct_kv_store_value)
        _pack_ = 1


class kv_reflect_crcs(RPCDefinitionBase):
    """Read KV store CRC's"""

    NAME = "kv_reflect_crcs"
    HELP = "Read KV store CRC's"
    DESCRIPTION = "Read KV store CRC's"
    COMMAND_ID = 7

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("offset", ctypes.c_uint16),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("num", ctypes.c_uint16),
            ("remaining", ctypes.c_uint16),
        ]
        vla_field = ("crcs", 0 * rpc_struct_kv_store_crc)
        _pack_ = 1


class zbus_channel_state(RPCDefinitionBase):
    """Query current state of zbus channel"""

    NAME = "zbus_channel_state"
    HELP = "Query current state of zbus channel"
    DESCRIPTION = "Query current state of zbus channel"
    COMMAND_ID = 8

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("channel_id", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("publish_timestamp", ctypes.c_uint64),
            ("publish_count", ctypes.c_uint32),
            ("publish_period_avg_ms", ctypes.c_uint32),
        ]
        vla_field = ("data", 0 * ctypes.c_uint8)
        _pack_ = 1


class application_info(RPCDefinitionBase):
    """Query basic application versions and state"""

    NAME = "application_info"
    HELP = "Query basic application versions and state"
    DESCRIPTION = "Query basic application versions and state"
    COMMAND_ID = 9

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("application_id", ctypes.c_uint32),
            ("version", rpc_struct_mcuboot_img_sem_ver),
            ("network_id", ctypes.c_uint32),
            ("uptime", ctypes.c_uint32),
            ("reboots", ctypes.c_uint32),
            ("kv_crc", ctypes.c_uint32),
            ("data_blocks_internal", ctypes.c_uint32),
            ("data_blocks_external", ctypes.c_uint32),
        ]
        _pack_ = 1


class wifi_scan(RPCDefinitionBase):
    """Scan for WiFi networks"""

    NAME = "wifi_scan"
    HELP = "Scan for WiFi networks"
    DESCRIPTION = "Scan for WiFi networks"
    COMMAND_ID = 10

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("network_count", ctypes.c_uint8),
        ]
        vla_field = ("networks", 0 * rpc_struct_wifi_scan_result)
        _pack_ = 1


class wifi_state(RPCDefinitionBase):
    """Get current WiFi interface state"""

    NAME = "wifi_state"
    HELP = "Get current WiFi interface state"
    DESCRIPTION = "Get current WiFi interface state"
    COMMAND_ID = 11

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("common", rpc_struct_network_state),
            ("wifi", rpc_struct_wifi_state),
        ]
        _pack_ = 1


class last_reboot(RPCDefinitionBase):
    """Retrieve information pertaining to the previous reboot"""

    NAME = "last_reboot"
    HELP = "Retrieve information pertaining to the previous reboot"
    DESCRIPTION = "Retrieve information pertaining to the previous reboot"
    COMMAND_ID = 12

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("reason", ctypes.c_uint8),
            ("epoch_time_source", ctypes.c_uint8),
            ("epoch_time", ctypes.c_uint64),
            ("hardware_flags", ctypes.c_uint32),
            ("uptime", ctypes.c_uint32),
            ("param_1", ctypes.c_uint32),
            ("param_2", ctypes.c_uint32),
            ("thread", 8 * ctypes.c_char),
        ]
        vla_field = ("esf", 0 * ctypes.c_uint32)
        _pack_ = 1


class data_logger_state(RPCDefinitionBase):
    """Get state of a data logger"""

    NAME = "data_logger_state"
    HELP = "Get state of a data logger"
    DESCRIPTION = "Get state of a data logger"
    COMMAND_ID = 13

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("logger", ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("bytes_logged", ctypes.c_uint64),
            ("logical_blocks", ctypes.c_uint32),
            ("physical_blocks", ctypes.c_uint32),
            ("boot_block", ctypes.c_uint32),
            ("current_block", ctypes.c_uint32),
            ("earliest_block", ctypes.c_uint32),
            ("block_size", ctypes.c_uint16),
            ("block_overhead", ctypes.c_uint16),
            ("erase_unit", ctypes.c_uint16),
            ("uptime", ctypes.c_uint32),
        ]
        _pack_ = 1


class data_logger_read(RPCDefinitionBase):
    """Read data from data logger"""

    NAME = "data_logger_read"
    HELP = "Read data from data logger"
    DESCRIPTION = "Read data from data logger"
    COMMAND_ID = 14

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("logger", ctypes.c_uint8),
            ("start_block", ctypes.c_uint32),
            ("last_block", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("sent_len", ctypes.c_uint32),
            ("sent_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class mem_read(RPCDefinitionBase):
    """Read arbitrary memory (NO ADDRESS VALIDATION PERFORMED)"""

    NAME = "mem_read"
    HELP = "Read arbitrary memory (NO ADDRESS VALIDATION PERFORMED)"
    DESCRIPTION = "Read arbitrary memory (NO ADDRESS VALIDATION PERFORMED)"
    COMMAND_ID = 15

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("address", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("sent_len", ctypes.c_uint32),
            ("sent_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class infuse_states_query(RPCDefinitionBase):
    """Read current Infuse-IoT application states"""

    NAME = "infuse_states_query"
    HELP = "Read current Infuse-IoT application states"
    DESCRIPTION = "Read current Infuse-IoT application states"
    COMMAND_ID = 16

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("offset", ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("remaining", ctypes.c_uint8),
        ]
        vla_field = ("states", 0 * rpc_struct_infuse_state)
        _pack_ = 1


class infuse_states_update(RPCDefinitionBase):
    """Update Infuse-IoT application states"""

    NAME = "infuse_states_update"
    HELP = "Update Infuse-IoT application states"
    DESCRIPTION = "Update Infuse-IoT application states"
    COMMAND_ID = 17

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("num", ctypes.c_uint8),
        ]
        vla_field = ("states", 0 * rpc_struct_infuse_state)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class data_logger_erase(RPCDefinitionBase):
    """Erase all data from a data logger"""

    NAME = "data_logger_erase"
    HELP = "Erase all data from a data logger"
    DESCRIPTION = "Erase all data from a data logger"
    COMMAND_ID = 18

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("logger", ctypes.c_uint8),
            ("erase_empty", ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class heap_stats(RPCDefinitionBase):
    """Query stats of heaps"""

    NAME = "heap_stats"
    HELP = "Query stats of heaps"
    DESCRIPTION = "Query stats of heaps"
    COMMAND_ID = 19

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("stats", 0 * rpc_struct_heap_info)
        _pack_ = 1


class lte_at_cmd(RPCDefinitionBase):
    """Run AT command against LTE modem"""

    NAME = "lte_at_cmd"
    HELP = "Run AT command against LTE modem"
    DESCRIPTION = "Run AT command against LTE modem"
    COMMAND_ID = 20

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("cmd", 0 * ctypes.c_char)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("rsp", 0 * ctypes.c_char)
        _pack_ = 1


class lte_state(RPCDefinitionBase):
    """Get current LTE interface state"""

    NAME = "lte_state"
    HELP = "Get current LTE interface state"
    DESCRIPTION = "Get current LTE interface state"
    COMMAND_ID = 21

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("common", rpc_struct_network_state),
            ("lte", rpc_struct_lte_state),
        ]
        _pack_ = 1


class data_logger_read_available(RPCDefinitionBase):
    """Read data from data logger, with auto-updating start_block"""

    NAME = "data_logger_read_available"
    HELP = "Read data from data logger, with auto-updating start_block"
    DESCRIPTION = "Read data from data logger, with auto-updating start_block"
    COMMAND_ID = 22

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("logger", ctypes.c_uint8),
            ("start_block", ctypes.c_uint32),
            ("num_blocks", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("sent_len", ctypes.c_uint32),
            ("sent_crc", ctypes.c_uint32),
            ("current_block", ctypes.c_uint32),
            ("start_block_actual", ctypes.c_uint32),
            ("block_size", ctypes.c_uint16),
        ]
        _pack_ = 1


class coap_download(RPCDefinitionBase):
    """Download a file from a COAP server (Infuse-IoT DTLS protected)"""

    NAME = "coap_download"
    HELP = "Download a file from a COAP server (Infuse-IoT DTLS protected)"
    DESCRIPTION = "Download a file from a COAP server (Infuse-IoT DTLS protected)"
    COMMAND_ID = 30

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("server_address", 48 * ctypes.c_char),
            ("server_port", ctypes.c_uint16),
            ("block_timeout_ms", ctypes.c_uint16),
            ("action", ctypes.c_uint8),
            ("resource_len", ctypes.c_uint32),
            ("resource_crc", ctypes.c_uint32),
        ]
        vla_field = ("resource", 0 * ctypes.c_char)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("resource_len", ctypes.c_uint32),
            ("resource_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class zperf_upload(RPCDefinitionBase):
    """Network upload bandwidth testing using zperf/iperf"""

    NAME = "zperf_upload"
    HELP = "Network upload bandwidth testing using zperf/iperf"
    DESCRIPTION = "Network upload bandwidth testing using zperf/iperf"
    COMMAND_ID = 31

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer_address", rpc_struct_sockaddr),
            ("sock_type", ctypes.c_uint8),
            ("data_source", ctypes.c_uint8),
            ("duration_ms", ctypes.c_uint32),
            ("rate_kbps", ctypes.c_uint32),
            ("packet_size", ctypes.c_uint16),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("nb_packets_sent", ctypes.c_uint32),
            ("nb_packets_rcvd", ctypes.c_uint32),
            ("nb_packets_lost", ctypes.c_uint32),
            ("nb_packets_outorder", ctypes.c_uint32),
            ("total_len", ctypes.c_uint64),
            ("time_in_us", ctypes.c_uint64),
            ("jitter_in_us", ctypes.c_uint32),
            ("client_time_in_us", ctypes.c_uint64),
            ("packet_size", ctypes.c_uint32),
            ("nb_packets_errors", ctypes.c_uint32),
        ]
        _pack_ = 1


class file_write_basic(RPCDefinitionBase):
    """Write a file to the device"""

    NAME = "file_write_basic"
    HELP = "Write a file to the device"
    DESCRIPTION = "Write a file to the device"
    COMMAND_ID = 40

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("action", ctypes.c_uint8),
            ("file_crc", ctypes.c_uint32),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("recv_len", ctypes.c_uint32),
            ("recv_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class annotate(RPCDefinitionBase):
    """Write an annotation to the device"""

    NAME = "annotate"
    HELP = "Write an annotation to the device"
    DESCRIPTION = "Write an annotation to the device"
    COMMAND_ID = 41

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("logger", ctypes.c_uint8),
            ("timestamp", ctypes.c_uint32),
        ]
        vla_field = ("annotation", 0 * ctypes.c_char)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class bt_connect_infuse(RPCDefinitionBase):
    """Connect to an Infuse-IoT Bluetooth device"""

    NAME = "bt_connect_infuse"
    HELP = "Connect to an Infuse-IoT Bluetooth device"
    DESCRIPTION = "Connect to an Infuse-IoT Bluetooth device"
    COMMAND_ID = 50

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
            ("conn_timeout_ms", ctypes.c_uint16),
            ("subscribe", ctypes.c_uint8),
            ("inactivity_timeout_ms", ctypes.c_uint16),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
            ("cloud_public_key", 32 * ctypes.c_uint8),
            ("device_public_key", 32 * ctypes.c_uint8),
            ("network_id", ctypes.c_uint32),
        ]
        _pack_ = 1


class bt_disconnect(RPCDefinitionBase):
    """Disconnect from a Bluetooth device"""

    NAME = "bt_disconnect"
    HELP = "Disconnect from a Bluetooth device"
    DESCRIPTION = "Disconnect from a Bluetooth device"
    COMMAND_ID = 51

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class bt_file_copy_basic(RPCDefinitionBase):
    """Copy a local file to a remote device over Bluetooth"""

    NAME = "bt_file_copy_basic"
    HELP = "Copy a local file to a remote device over Bluetooth"
    DESCRIPTION = "Copy a local file to a remote device over Bluetooth"
    COMMAND_ID = 52

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
            ("action", ctypes.c_uint8),
            ("file_idx", ctypes.c_uint8),
            ("file_len", ctypes.c_uint32),
            ("file_crc", ctypes.c_uint32),
            ("ack_period", ctypes.c_uint8),
            ("pipelining", ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class bt_file_copy_coap(RPCDefinitionBase):
    """Copy a file fetched from COAP to a remote device over Bluetooth"""

    NAME = "bt_file_copy_coap"
    HELP = "Copy a file fetched from COAP to a remote device over Bluetooth"
    DESCRIPTION = "Copy a file fetched from COAP to a remote device over Bluetooth"
    COMMAND_ID = 53

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
            ("conn_timeout_ms", ctypes.c_uint16),
            ("action", ctypes.c_uint8),
            ("file_idx", ctypes.c_uint8),
            ("ack_period", ctypes.c_uint8),
            ("pipelining", ctypes.c_uint8),
            ("server_address", 48 * ctypes.c_char),
            ("server_port", ctypes.c_uint16),
            ("block_timeout_ms", ctypes.c_uint16),
            ("resource_len", ctypes.c_uint32),
            ("resource_crc", ctypes.c_uint32),
        ]
        vla_field = ("resource", 0 * ctypes.c_char)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("resource_len", ctypes.c_uint32),
            ("resource_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class bt_mcumgr_reboot(RPCDefinitionBase):
    """Connect to a Bluetooth device and run the MCUMGR reboot command"""

    NAME = "bt_mcumgr_reboot"
    HELP = "Connect to a Bluetooth device and run the MCUMGR reboot command"
    DESCRIPTION = "Connect to a Bluetooth device and run the MCUMGR reboot command"
    COMMAND_ID = 54

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("peer", rpc_struct_bt_addr_le),
            ("conn_timeout_ms", ctypes.c_uint16),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class gravity_reference_update(RPCDefinitionBase):
    """Store the current accelerometer vector as the gravity reference"""

    NAME = "gravity_reference_update"
    HELP = "Store the current accelerometer vector as the gravity reference"
    DESCRIPTION = "Store the current accelerometer vector as the gravity reference"
    COMMAND_ID = 60

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("max_variance", ctypes.c_uint16),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("reference", rpc_struct_xyz_s16),
            ("variance", rpc_struct_xyz_s16),
            ("num_samples", ctypes.c_uint16),
            ("sample_period_us", ctypes.c_uint32),
        ]
        _pack_ = 1


class security_state(RPCDefinitionBase):
    """Query current security state and validate identity"""

    NAME = "security_state"
    HELP = "Query current security state and validate identity"
    DESCRIPTION = "Query current security state and validate identity"
    COMMAND_ID = 30000

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("challenge", 16 * ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("cloud_public_key", 32 * ctypes.c_uint8),
            ("device_public_key", 32 * ctypes.c_uint8),
            ("network_id", ctypes.c_uint32),
            ("challenge_response_type", ctypes.c_uint8),
        ]
        vla_field = ("challenge_response", 0 * ctypes.c_uint8)
        _pack_ = 1


class data_sender(RPCDefinitionBase):
    """Send multiple INFUSE_RPC_DATA packets"""

    NAME = "data_sender"
    HELP = "Send multiple INFUSE_RPC_DATA packets"
    DESCRIPTION = "Send multiple INFUSE_RPC_DATA packets"
    COMMAND_ID = 32765

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        _pack_ = 1


class data_receiver(RPCDefinitionBase):
    """Receive multiple INFUSE_RPC_DATA packets"""

    NAME = "data_receiver"
    HELP = "Receive multiple INFUSE_RPC_DATA packets"
    DESCRIPTION = "Receive multiple INFUSE_RPC_DATA packets"
    COMMAND_ID = 32766

    class request(VLACompatLittleEndianStruct):
        _fields_ = [
            ("unaligned_input", ctypes.c_uint8),
        ]
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = [
            ("recv_len", ctypes.c_uint32),
            ("recv_crc", ctypes.c_uint32),
        ]
        _pack_ = 1


class echo(RPCDefinitionBase):
    """Echo any input data in the response"""

    NAME = "echo"
    HELP = "Echo any input data in the response"
    DESCRIPTION = "Echo any input data in the response"
    COMMAND_ID = 32767

    class request(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("array", 0 * ctypes.c_uint8)
        _pack_ = 1

    class response(VLACompatLittleEndianStruct):
        _fields_ = []
        vla_field = ("array", 0 * ctypes.c_uint8)
        _pack_ = 1


id_type_mapping: dict[int, type[RPCDefinitionBase]] = {
    reboot.COMMAND_ID: reboot,
    fault.COMMAND_ID: fault,
    time_get.COMMAND_ID: time_get,
    time_set.COMMAND_ID: time_set,
    kv_write.COMMAND_ID: kv_write,
    kv_read.COMMAND_ID: kv_read,
    kv_reflect_crcs.COMMAND_ID: kv_reflect_crcs,
    zbus_channel_state.COMMAND_ID: zbus_channel_state,
    application_info.COMMAND_ID: application_info,
    wifi_scan.COMMAND_ID: wifi_scan,
    wifi_state.COMMAND_ID: wifi_state,
    last_reboot.COMMAND_ID: last_reboot,
    data_logger_state.COMMAND_ID: data_logger_state,
    data_logger_read.COMMAND_ID: data_logger_read,
    mem_read.COMMAND_ID: mem_read,
    infuse_states_query.COMMAND_ID: infuse_states_query,
    infuse_states_update.COMMAND_ID: infuse_states_update,
    data_logger_erase.COMMAND_ID: data_logger_erase,
    heap_stats.COMMAND_ID: heap_stats,
    lte_at_cmd.COMMAND_ID: lte_at_cmd,
    lte_state.COMMAND_ID: lte_state,
    data_logger_read_available.COMMAND_ID: data_logger_read_available,
    coap_download.COMMAND_ID: coap_download,
    zperf_upload.COMMAND_ID: zperf_upload,
    file_write_basic.COMMAND_ID: file_write_basic,
    annotate.COMMAND_ID: annotate,
    bt_connect_infuse.COMMAND_ID: bt_connect_infuse,
    bt_disconnect.COMMAND_ID: bt_disconnect,
    bt_file_copy_basic.COMMAND_ID: bt_file_copy_basic,
    bt_file_copy_coap.COMMAND_ID: bt_file_copy_coap,
    bt_mcumgr_reboot.COMMAND_ID: bt_mcumgr_reboot,
    gravity_reference_update.COMMAND_ID: gravity_reference_update,
    security_state.COMMAND_ID: security_state,
    data_sender.COMMAND_ID: data_sender,
    data_receiver.COMMAND_ID: data_receiver,
    echo.COMMAND_ID: echo,
}

__all__ = [
    "id_type_mapping",
    "rpc_struct_mcuboot_img_sem_ver",
    "rpc_struct_kv_store_value",
    "rpc_struct_kv_store_crc",
    "rpc_struct_bt_addr_le",
    "rpc_struct_ipv4_address",
    "rpc_struct_ipv6_address",
    "rpc_struct_network_state",
    "rpc_struct_wifi_state",
    "rpc_struct_lte_state",
    "rpc_struct_wifi_scan_result",
    "rpc_struct_xyz_s16",
    "rpc_struct_infuse_state",
    "rpc_struct_sockaddr",
    "rpc_struct_heap_info",
    "rpc_enum_bt_le_addr_type",
    "rpc_enum_file_action",
    "rpc_enum_infuse_bt_characteristic",
    "rpc_enum_data_logger",
    "rpc_enum_zperf_data_source",
    "reboot",
    "fault",
    "time_get",
    "time_set",
    "kv_write",
    "kv_read",
    "kv_reflect_crcs",
    "zbus_channel_state",
    "application_info",
    "wifi_scan",
    "wifi_state",
    "last_reboot",
    "data_logger_state",
    "data_logger_read",
    "mem_read",
    "infuse_states_query",
    "infuse_states_update",
    "data_logger_erase",
    "heap_stats",
    "lte_at_cmd",
    "lte_state",
    "data_logger_read_available",
    "coap_download",
    "zperf_upload",
    "file_write_basic",
    "annotate",
    "bt_connect_infuse",
    "bt_disconnect",
    "bt_file_copy_basic",
    "bt_file_copy_coap",
    "bt_mcumgr_reboot",
    "gravity_reference_update",
    "security_state",
    "data_sender",
    "data_receiver",
    "echo",
]
