#!/usr/bin/env python3
# mypy: ignore-errors

"""Autogenerated KV store definitions"""

import ctypes

from infuse_iot.util.ctypes import VLACompatLittleEndianStruct


class structs:
    class gcs_location(VLACompatLittleEndianStruct):
        """Geographic Co-ordinate System location"""

        _fields_ = [
            ("latitude", ctypes.c_int32),
            ("longitude", ctypes.c_int32),
            ("height", ctypes.c_int32),
        ]
        _pack_ = 1

    class bt_addr_le(VLACompatLittleEndianStruct):
        """Bluetooth address type (bt_addr_le_t)"""

        _fields_ = [
            ("type", ctypes.c_uint8),
            ("val", 6 * ctypes.c_uint8),
        ]
        _pack_ = 1

    class kv_string(VLACompatLittleEndianStruct):
        """String type"""

        _fields_ = [
            ("value_num", ctypes.c_uint8),
        ]
        vla_field = ("value", 0 * ctypes.c_char)
        _pack_ = 1

        def __str__(self) -> str:
            return bytes(self.value).decode("utf-8")

    class kv_mcuboot_img_sem_ver(VLACompatLittleEndianStruct):
        """MCUboot semantic versioning struct"""

        _fields_ = [
            ("major", ctypes.c_uint8),
            ("minor", ctypes.c_uint8),
            ("revision", ctypes.c_uint16),
            ("build_num", ctypes.c_uint32),
        ]
        _pack_ = 1

    class kv_range_u8(VLACompatLittleEndianStruct):
        """Generic range structure"""

        _fields_ = [
            ("lower", ctypes.c_uint8),
            ("upper", ctypes.c_uint8),
        ]
        _pack_ = 1

    class kv_utc_hms(VLACompatLittleEndianStruct):
        """UTC Hour-Minute-Second"""

        _fields_ = [
            ("hour", ctypes.c_uint8),
            ("minute", ctypes.c_uint8),
            ("second", ctypes.c_uint8),
        ]
        _pack_ = 1


class slots:
    class reboots(VLACompatLittleEndianStruct):
        """Number of times device has rebooted"""

        NAME = "REBOOTS"
        BASE_ID = 0
        RANGE = 1
        _fields_ = [
            ("count", ctypes.c_uint32),
        ]
        _pack_ = 1

    class bluetooth_addr(VLACompatLittleEndianStruct):
        """Bluetooth advertising address"""

        NAME = "BLUETOOTH_ADDR"
        BASE_ID = 1
        RANGE = 1
        _fields_ = [
            ("address", structs.bt_addr_le),
        ]
        _pack_ = 1

    class exfat_disk_info(VLACompatLittleEndianStruct):
        """exFAT disk information"""

        NAME = "EXFAT_DISK_INFO"
        BASE_ID = 2
        RANGE = 1
        _fields_ = [
            ("block_count", ctypes.c_uint32),
            ("block_size", ctypes.c_uint32),
        ]
        _pack_ = 1

    class bluetooth_ctlr_version(VLACompatLittleEndianStruct):
        """External Bluetooth controller version"""

        NAME = "BLUETOOTH_CTLR_VERSION"
        BASE_ID = 3
        RANGE = 1
        _fields_ = [
            ("application", ctypes.c_uint32),
            ("version", structs.kv_mcuboot_img_sem_ver),
        ]
        _pack_ = 1

    class device_name(VLACompatLittleEndianStruct):
        """Personalised name for the device"""

        NAME = "DEVICE_NAME"
        BASE_ID = 4
        RANGE = 1
        _fields_ = []
        vla_field = ("name", structs.kv_string)
        _pack_ = 1

    class infuse_application_id(VLACompatLittleEndianStruct):
        """CONFIG_INFUSE_APPLICATION_ID, store will be reset if the values don't match"""

        NAME = "INFUSE_APPLICATION_ID"
        BASE_ID = 5
        RANGE = 1
        _fields_ = [
            ("application_id", ctypes.c_uint32),
        ]
        _pack_ = 1

    class fixed_location(VLACompatLittleEndianStruct):
        """Fixed global location of the device"""

        NAME = "FIXED_LOCATION"
        BASE_ID = 10
        RANGE = 1
        _fields_ = [
            ("location", structs.gcs_location),
        ]
        _pack_ = 1

    class wifi_ssid(VLACompatLittleEndianStruct):
        """WiFi network name"""

        NAME = "WIFI_SSID"
        BASE_ID = 20
        RANGE = 1
        _fields_ = []
        vla_field = ("ssid", structs.kv_string)
        _pack_ = 1

    class wifi_psk(VLACompatLittleEndianStruct):
        """WiFi network password"""

        NAME = "WIFI_PSK"
        BASE_ID = 21
        RANGE = 1
        _fields_ = []
        vla_field = ("psk", structs.kv_string)
        _pack_ = 1

    class wifi_channels(VLACompatLittleEndianStruct):
        """WiFi band and channel configuration"""

        NAME = "WIFI_CHANNELS"
        BASE_ID = 22
        RANGE = 1
        _fields_ = [
            ("band", ctypes.c_uint8),
        ]
        vla_field = ("channels", 0 * ctypes.c_uint8)
        _pack_ = 1

    class ntp_server_url(VLACompatLittleEndianStruct):
        """URL of the NTP server to use for time synchronisation"""

        NAME = "NTP_SERVER_URL"
        BASE_ID = 30
        RANGE = 1
        _fields_ = []
        vla_field = ("url", structs.kv_string)
        _pack_ = 1

    class epacket_udp_url(VLACompatLittleEndianStruct):
        """ePacket UDP server hostname"""

        NAME = "EPACKET_UDP_URL"
        BASE_ID = 31
        RANGE = 1
        _fields_ = []
        vla_field = ("server", structs.kv_string)
        _pack_ = 1

    class epacket_udp_port(VLACompatLittleEndianStruct):
        """ePacket UDP server port"""

        NAME = "EPACKET_UDP_PORT"
        BASE_ID = 32
        RANGE = 1
        _fields_ = [
            ("port", ctypes.c_uint32),
        ]
        _pack_ = 1

    class lte_modem_model(VLACompatLittleEndianStruct):
        """Modem model as returned by AT+CGMM"""

        NAME = "LTE_MODEM_MODEL"
        BASE_ID = 40
        RANGE = 1
        _fields_ = []
        vla_field = ("model", structs.kv_string)
        _pack_ = 1

    class lte_modem_firmware_revision(VLACompatLittleEndianStruct):
        """Modem firmware revision as returned by AT+CGMR"""

        NAME = "LTE_MODEM_FIRMWARE_REVISION"
        BASE_ID = 41
        RANGE = 1
        _fields_ = []
        vla_field = ("revision", structs.kv_string)
        _pack_ = 1

    class lte_modem_esn(VLACompatLittleEndianStruct):
        """'Electronic Serial Number' as returned by AT+CGSN=0"""

        NAME = "LTE_MODEM_ESN"
        BASE_ID = 42
        RANGE = 1
        _fields_ = []
        vla_field = ("esn", structs.kv_string)
        _pack_ = 1

    class lte_modem_imei(VLACompatLittleEndianStruct):
        """'International Modem Equiment Identifier' as returned by AT+CGSN=1"""

        NAME = "LTE_MODEM_IMEI"
        BASE_ID = 43
        RANGE = 1
        _fields_ = [
            ("imei", ctypes.c_uint64),
        ]
        _pack_ = 1

    class lte_sim_uicc(VLACompatLittleEndianStruct):
        """SIM Universal Identifier (https://www.itu.int/en/ITU-T/inr/forms/Pages/iin.aspx)"""

        NAME = "LTE_SIM_UICC"
        BASE_ID = 44
        RANGE = 1
        _fields_ = []
        vla_field = ("uicc", structs.kv_string)
        _pack_ = 1

    class lte_pdp_config(VLACompatLittleEndianStruct):
        """Packet Data Protocol (PDP) default context configuration"""

        NAME = "LTE_PDP_CONFIG"
        BASE_ID = 45
        RANGE = 1
        _fields_ = [
            ("family", ctypes.c_uint8),
        ]
        vla_field = ("apn", structs.kv_string)
        _pack_ = 1

    class lte_networking_modes(VLACompatLittleEndianStruct):
        """Enabled LTE networking modes and preferences"""

        NAME = "LTE_NETWORKING_MODES"
        BASE_ID = 46
        RANGE = 1
        _fields_ = [
            ("modes", ctypes.c_uint8),
            ("prefer", ctypes.c_uint8),
        ]
        _pack_ = 1

    class lte_sim_imsi(VLACompatLittleEndianStruct):
        """'International Modem Subscriber Identity' as returned by AT+CIMI"""

        NAME = "LTE_SIM_IMSI"
        BASE_ID = 47
        RANGE = 1
        _fields_ = [
            ("imsi", ctypes.c_uint64),
        ]
        _pack_ = 1

    class bluetooth_peer(VLACompatLittleEndianStruct):
        """Bluetooth peer device"""

        NAME = "BLUETOOTH_PEER"
        BASE_ID = 50
        RANGE = 1
        _fields_ = [
            ("address", structs.bt_addr_le),
        ]
        _pack_ = 1

    class lora_config(VLACompatLittleEndianStruct):
        """LoRa modem configuration"""

        NAME = "LORA_CONFIG"
        BASE_ID = 51
        RANGE = 1
        _fields_ = [
            ("frequency", ctypes.c_uint32),
            ("bandwidth", ctypes.c_uint8),
            ("spreading_factor", ctypes.c_uint8),
            ("coding_rate", ctypes.c_uint8),
            ("preamble_len", ctypes.c_uint16),
            ("tx_power", ctypes.c_int8),
            ("sync_word", ctypes.c_uint8),
        ]
        _pack_ = 1

    class bluetooth_throughput_limit(VLACompatLittleEndianStruct):
        """Request connected Bluetooth peers to limit throughtput"""

        NAME = "BLUETOOTH_THROUGHPUT_LIMIT"
        BASE_ID = 52
        RANGE = 1
        _fields_ = [
            ("limit_kbps", ctypes.c_uint16),
        ]
        _pack_ = 1

    class led_disable_daily_time_range(VLACompatLittleEndianStruct):
        """Disable LEDs between two UTC times daily"""

        NAME = "LED_DISABLE_DAILY_TIME_RANGE"
        BASE_ID = 53
        RANGE = 1
        _fields_ = [
            ("disable_start", structs.kv_utc_hms),
            ("disable_end", structs.kv_utc_hms),
        ]
        _pack_ = 1

    class gravity_reference(VLACompatLittleEndianStruct):
        """Reference gravity vector for tilt calculations"""

        NAME = "GRAVITY_REFERENCE"
        BASE_ID = 60
        RANGE = 1
        _fields_ = [
            ("x", ctypes.c_int16),
            ("y", ctypes.c_int16),
            ("z", ctypes.c_int16),
        ]
        _pack_ = 1

    class geofence(VLACompatLittleEndianStruct):
        """Array of points defining a closed polygon"""

        NAME = "GEOFENCE"
        BASE_ID = 100
        RANGE = 16
        _fields_ = [
            ("points_num", ctypes.c_uint8),
        ]
        vla_field = ("points", 0 * structs.gcs_location)
        _pack_ = 1

    class task_schedules_default_id(VLACompatLittleEndianStruct):
        """Unique identifier for default schedule set"""

        NAME = "TASK_SCHEDULES_DEFAULT_ID"
        BASE_ID = 1000
        RANGE = 1
        _fields_ = [
            ("set_id", ctypes.c_uint32),
        ]
        _pack_ = 1

    class task_schedules(VLACompatLittleEndianStruct):
        """Task runner task schedule definition (@ref task_schedule)"""

        NAME = "TASK_SCHEDULES"
        BASE_ID = 1001
        RANGE = 32
        _fields_ = [
            ("task_id", ctypes.c_uint8),
            ("validity", ctypes.c_uint8),
            ("periodicity_type", ctypes.c_uint8),
            ("timeout_s", ctypes.c_uint32),
            ("battery_start", structs.kv_range_u8),
            ("battery_terminate", structs.kv_range_u8),
            ("periodicity", ctypes.c_uint32),
        ]
        vla_field = ("_remainder", 0 * ctypes.c_uint8)
        _pack_ = 1

    class secure_storage_reserved(VLACompatLittleEndianStruct):
        """Keys reserved for secure storage (do not enable)"""

        NAME = "SECURE_STORAGE_RESERVED"
        BASE_ID = 30000
        RANGE = 10
        _fields_ = [
            ("data_num", ctypes.c_uint8),
        ]
        vla_field = ("data", 0 * ctypes.c_uint8)
        _pack_ = 1

    ID_MAPPING = {
        0: reboots,
        1: bluetooth_addr,
        2: exfat_disk_info,
        3: bluetooth_ctlr_version,
        4: device_name,
        5: infuse_application_id,
        10: fixed_location,
        20: wifi_ssid,
        21: wifi_psk,
        22: wifi_channels,
        30: ntp_server_url,
        31: epacket_udp_url,
        32: epacket_udp_port,
        40: lte_modem_model,
        41: lte_modem_firmware_revision,
        42: lte_modem_esn,
        43: lte_modem_imei,
        44: lte_sim_uicc,
        45: lte_pdp_config,
        46: lte_networking_modes,
        47: lte_sim_imsi,
        50: bluetooth_peer,
        51: lora_config,
        52: bluetooth_throughput_limit,
        53: led_disable_daily_time_range,
        60: gravity_reference,
        100: geofence,
        101: geofence,
        102: geofence,
        103: geofence,
        104: geofence,
        105: geofence,
        106: geofence,
        107: geofence,
        108: geofence,
        109: geofence,
        110: geofence,
        111: geofence,
        112: geofence,
        113: geofence,
        114: geofence,
        115: geofence,
        1000: task_schedules_default_id,
        1001: task_schedules,
        1002: task_schedules,
        1003: task_schedules,
        1004: task_schedules,
        1005: task_schedules,
        1006: task_schedules,
        1007: task_schedules,
        1008: task_schedules,
        1009: task_schedules,
        1010: task_schedules,
        1011: task_schedules,
        1012: task_schedules,
        1013: task_schedules,
        1014: task_schedules,
        1015: task_schedules,
        1016: task_schedules,
        1017: task_schedules,
        1018: task_schedules,
        1019: task_schedules,
        1020: task_schedules,
        1021: task_schedules,
        1022: task_schedules,
        1023: task_schedules,
        1024: task_schedules,
        1025: task_schedules,
        1026: task_schedules,
        1027: task_schedules,
        1028: task_schedules,
        1029: task_schedules,
        1030: task_schedules,
        1031: task_schedules,
        1032: task_schedules,
        30000: secure_storage_reserved,
        30001: secure_storage_reserved,
        30002: secure_storage_reserved,
        30003: secure_storage_reserved,
        30004: secure_storage_reserved,
        30005: secure_storage_reserved,
        30006: secure_storage_reserved,
        30007: secure_storage_reserved,
        30008: secure_storage_reserved,
        30009: secure_storage_reserved,
    }


__all__ = [
    "structs",
    "slots",
]
