"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const authorizer_1 = require("./authorizer");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Route class that creates the Route for API Gateway WebSocket API
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketRoute);
            }
            throw error;
        }
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = props.authorizer ?? new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this, // scope under the API if it's not imported
        });
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            apiKeyRequired: props.apiKeyRequired,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
            routeResponseSelectionExpression: props.returnResponse ? '$default' : undefined,
        });
        this.routeId = route.ref;
        if (props.returnResponse) {
            new aws_apigatewayv2_1.CfnRouteResponse(this, 'Response', {
                apiId: props.webSocketApi.apiId,
                routeId: route.ref,
                routeResponseKey: '$default',
            });
        }
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRoute", version: "2.102.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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