"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = exports.WebSocketApiKeySelectionExpression = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const route_1 = require("./route");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * Represents the currently available API Key Selection Expressions
 */
class WebSocketApiKeySelectionExpression {
    /**
     * @param customApiKeySelector The expression used by API Gateway
     */
    constructor(customApiKeySelector) {
        this.customApiKeySelector = customApiKeySelector;
    }
}
exports.WebSocketApiKeySelectionExpression = WebSocketApiKeySelectionExpression;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApiKeySelectionExpression[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApiKeySelectionExpression", version: "2.102.1-alpha.0" };
/**
 * The API will extract the key value from the `x-api-key` header in the user request.
 */
WebSocketApiKeySelectionExpression.HEADER_X_API_KEY = new WebSocketApiKeySelectionExpression('$request.header.x-api-key');
/**
  * The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map,
  * returned by the Lambda Authorizer.
  * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
  */
WebSocketApiKeySelectionExpression.AUTHORIZER_USAGE_IDENTIFIER_KEY = new WebSocketApiKeySelectionExpression('$context.authorizer.usageIdentifierKey');
/**
 * Create a new API Gateway WebSocket API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    /**
     * Import an existing WebSocket API into this CDK app.
     */
    static fromWebSocketApiAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketApiAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketApiAttributes);
            }
            throw error;
        }
        class Import extends base_1.ApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.webSocketId;
                this.websocketApiId = attrs.webSocketId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported WebSocketApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketApi);
            }
            throw error;
        }
        this.webSocketApiName = props?.apiName ?? id;
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            apiKeySelectionExpression: props?.apiKeySelectionExpression?.customApiKeySelector,
            protocolType: 'WEBSOCKET',
            description: props?.description,
            routeSelectionExpression: props?.routeSelectionExpression ?? '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props?.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props?.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props?.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * Add a new route
     */
    addRoute(routeKey, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRoute);
            }
            throw error;
        }
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManageConnections(identity) {
        const arn = core_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/*/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_b = JSII_RTTI_SYMBOL_1;
WebSocketApi[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi", version: "2.102.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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