"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterMapping = exports.MappingValue = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
;
/**
 * Represents a Mapping Value.
 */
class MappingValue {
    /**
     * Creates a header mapping value.
     */
    static requestHeader(name) { return new MappingValue(`$request.header.${name}`); }
    /**
     * Creates a query string mapping value.
     */
    static requestQueryString(name) { return new MappingValue(`$request.querystring.${name}`); }
    /**
     * Creates a request body mapping value.
     */
    static requestBody(name) { return new MappingValue(`$request.body.${name}`); }
    /**
     * Creates a request path mapping value.
     */
    static requestPath() { return new MappingValue('$request.path'); }
    /**
     * Creates a request path parameter mapping value.
     */
    static requestPathParam(name) { return new MappingValue(`$request.path.${name}`); }
    /**
     * Creates a context variable mapping value.
     */
    static contextVariable(variableName) { return new MappingValue(`$context.${variableName}`); }
    /**
     * Creates a stage variable mapping value.
     */
    static stageVariable(variableName) { return new MappingValue(`$stageVariables.${variableName}`); }
    /**
     * Creates a custom mapping value.
     */
    static custom(value) { return new MappingValue(value); }
    constructor(value) {
        this.value = value;
    }
}
exports.MappingValue = MappingValue;
_a = JSII_RTTI_SYMBOL_1;
MappingValue[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.MappingValue", version: "2.102.1-alpha.0" };
/**
* Creates an empty mapping value.
*/
MappingValue.NONE = new MappingValue('');
/**
 * Represents a Parameter Mapping.
 */
class ParameterMapping {
    /**
     * Creates a mapping from an object.
     */
    static fromObject(obj) {
        const mapping = new ParameterMapping();
        for (const [k, m] of Object.entries(obj)) {
            mapping.custom(k, m.value);
        }
        return mapping;
    }
    constructor() {
        this.mappings = {};
    }
    /**
     * Creates a mapping to append a header.
     */
    appendHeader(name, value) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.appendHeader);
            }
            throw error;
        }
        this.mappings[`append:header.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to overwrite a header.
     */
    overwriteHeader(name, value) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwriteHeader);
            }
            throw error;
        }
        this.mappings[`overwrite:header.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to remove a header.
     */
    removeHeader(name) {
        this.mappings[`remove:header.${name}`] = '';
        return this;
    }
    /**
     * Creates a mapping to append a query string.
     */
    appendQueryString(name, value) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.appendQueryString);
            }
            throw error;
        }
        this.mappings[`append:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to overwrite a querystring.
     */
    overwriteQueryString(name, value) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwriteQueryString);
            }
            throw error;
        }
        this.mappings[`overwrite:querystring.${name}`] = value.value;
        return this;
    }
    /**
     * Creates a mapping to remove a querystring.
     */
    removeQueryString(name) {
        this.mappings[`remove:querystring.${name}`] = '';
        return this;
    }
    /**
     * Creates a mapping to overwrite a path.
     */
    overwritePath(value) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_MappingValue(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.overwritePath);
            }
            throw error;
        }
        this.mappings['overwrite:path'] = value.value;
        return this;
    }
    /**
     * Creates a custom mapping.
     */
    custom(key, value) {
        this.mappings[key] = value;
        return this;
    }
}
exports.ParameterMapping = ParameterMapping;
_b = JSII_RTTI_SYMBOL_1;
ParameterMapping[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ParameterMapping", version: "2.102.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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