"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.IntegrationCredentials = exports.HttpIntegrationSubtype = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is an HTTP proxy.
     *
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
    /**
     * Integration type is an AWS proxy.
     *
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(HttpIntegrationType || (exports.HttpIntegrationType = HttpIntegrationType = {}));
/**
 * Supported integration subtypes
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 */
var HttpIntegrationSubtype;
(function (HttpIntegrationSubtype) {
    /**
     * EventBridge PutEvents integration
     */
    HttpIntegrationSubtype["EVENTBRIDGE_PUT_EVENTS"] = "EventBridge-PutEvents";
    /**
     * SQS SendMessage integration
     */
    HttpIntegrationSubtype["SQS_SEND_MESSAGE"] = "SQS-SendMessage";
    /**
     * SQS ReceiveMessage integration,
     */
    HttpIntegrationSubtype["SQS_RECEIVE_MESSAGE"] = "SQS-ReceiveMessage";
    /**
     * SQS DeleteMessage integration,
     */
    HttpIntegrationSubtype["SQS_DELETE_MESSAGE"] = "SQS-DeleteMessage";
    /**
     * SQS PurgeQueue integration
     */
    HttpIntegrationSubtype["SQS_PURGE_QUEUE"] = "SQS-PurgeQueue";
    /**
     * AppConfig GetConfiguration integration
     */
    HttpIntegrationSubtype["APPCONFIG_GET_CONFIGURATION"] = "AppConfig-GetConfiguration";
    /**
     * Kinesis PutRecord integration
     */
    HttpIntegrationSubtype["KINESIS_PUT_RECORD"] = "Kinesis-PutRecord";
    /**
     * Step Functions StartExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_EXECUTION"] = "StepFunctions-StartExecution";
    /**
     * Step Functions StartSyncExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_SYNC_EXECUTION"] = "StepFunctions-StartSyncExecution";
    /**
     * Step Functions StopExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_STOP_EXECUTION"] = "StepFunctions-StopExecution";
})(HttpIntegrationSubtype || (exports.HttpIntegrationSubtype = HttpIntegrationSubtype = {}));
/**
 * Credentials used for AWS Service integrations.
 */
class IntegrationCredentials {
    /**
     * Use the specified role for integration requests
     */
    static fromRole(role) {
        return { credentialsArn: role.roleArn };
    }
    /** Use the calling user's identity to call the integration */
    static useCallerIdentity() {
        return { credentialsArn: `arn:${core_1.Aws.PARTITION}:iam::*:user/*` };
    }
}
exports.IntegrationCredentials = IntegrationCredentials;
_a = JSII_RTTI_SYMBOL_1;
IntegrationCredentials[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.IntegrationCredentials", version: "2.102.1-alpha.0" };
/**
 * Supported connection types
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    /**
     * For private connections between API Gateway and resources in a VPC
     */
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    /**
     * For connections through public routable internet
     */
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType || (exports.HttpConnectionType = HttpConnectionType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
    constructor(version) {
        this.version = version;
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_b = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.PayloadFormatVersion", version: "2.102.1-alpha.0" };
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpIntegration);
            }
            throw error;
        }
        if (!props.integrationSubtype && !props.integrationUri) {
            throw new Error('Either `integrationSubtype` or `integrationUri` must be specified.');
        }
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationSubtype: props.integrationSubtype,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: props.payloadFormatVersion?.version,
            requestParameters: props.parameterMapping?.mappings,
            credentialsArn: props.credentials?.credentialsArn,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpIntegration", version: "2.102.1-alpha.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class HttpRouteIntegration {
    /**
     * Initialize an integration for a route on http api.
     * @param id id of the underlying `HttpIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationSubtype: config.subtype,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
                credentials: config.credentials,
            });
        }
        this.completeBind(options);
        return { integrationId: this.integration.integrationId };
    }
    /**
     * Complete the binding of the integration to the route. In some cases, there is
     * some additional work to do, such as adding permissions for the API to access
     * the target. This work is necessary whether the integration has just been
     * created for this route or it is an existing one, previously created for other
     * routes. In most cases, however, concrete implementations do not need to
     * override this method.
     */
    completeBind(_options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteIntegrationBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.completeBind);
            }
            throw error;
        }
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_d = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_d] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteIntegration", version: "2.102.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZ3JhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwyQ0FBaUQ7QUFJakQsbUVBQThEO0FBWTlEOztHQUVHO0FBQ0gsSUFBWSxtQkF1Qlg7QUF2QkQsV0FBWSxtQkFBbUI7SUFDN0I7Ozs7Ozs7O09BUUc7SUFDSCxnREFBeUIsQ0FBQTtJQUV6Qjs7Ozs7Ozs7O09BU0c7SUFDSCw4Q0FBdUIsQ0FBQTtBQUN6QixDQUFDLEVBdkJXLG1CQUFtQixtQ0FBbkIsbUJBQW1CLFFBdUI5QjtBQUVEOzs7R0FHRztBQUNILElBQVksc0JBeUNYO0FBekNELFdBQVksc0JBQXNCO0lBQ2hDOztPQUVHO0lBQ0gsMEVBQWdELENBQUE7SUFDaEQ7O09BRUc7SUFDSCw4REFBb0MsQ0FBQTtJQUNwQzs7T0FFRztJQUNILG9FQUEwQyxDQUFBO0lBQzFDOztPQUVHO0lBQ0gsa0VBQXdDLENBQUE7SUFDeEM7O09BRUc7SUFDSCw0REFBa0MsQ0FBQTtJQUNsQzs7T0FFRztJQUNILG9GQUEwRCxDQUFBO0lBQzFEOztPQUVHO0lBQ0gsa0VBQXdDLENBQUE7SUFDeEM7O09BRUc7SUFDSCx3RkFBOEQsQ0FBQTtJQUM5RDs7T0FFRztJQUNILGlHQUF1RSxDQUFBO0lBQ3ZFOztPQUVHO0lBQ0gsc0ZBQTRELENBQUE7QUFDOUQsQ0FBQyxFQXpDVyxzQkFBc0Isc0NBQXRCLHNCQUFzQixRQXlDakM7QUFFRDs7R0FFRztBQUNILE1BQXNCLHNCQUFzQjtJQUMxQzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBVztRQUNoQyxPQUFPLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztLQUN6QztJQUVELDhEQUE4RDtJQUN2RCxNQUFNLENBQUMsaUJBQWlCO1FBQzdCLE9BQU8sRUFBRSxjQUFjLEVBQUUsT0FBTyxVQUFHLENBQUMsU0FBUyxnQkFBZ0IsRUFBRSxDQUFDO0tBQ2pFOztBQVhILHdEQWlCQzs7O0FBRUQ7O0dBRUc7QUFDSCxJQUFZLGtCQVNYO0FBVEQsV0FBWSxrQkFBa0I7SUFDNUI7O09BRUc7SUFDSCwyQ0FBcUIsQ0FBQTtJQUNyQjs7T0FFRztJQUNILDJDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFUVyxrQkFBa0Isa0NBQWxCLGtCQUFrQixRQVM3QjtBQUVEOzs7R0FHRztBQUNILE1BQWEsb0JBQW9CO0lBTS9COzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsT0FBZTtRQUNsQyxPQUFPLElBQUksb0JBQW9CLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDMUM7SUFLRCxZQUFvQixPQUFlO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0tBQ3hCOztBQW5CSCxvREFvQkM7OztBQW5CQyxrQkFBa0I7QUFDSyxnQ0FBVyxHQUFHLElBQUksb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDckUsa0JBQWtCO0FBQ0ssZ0NBQVcsR0FBRyxJQUFJLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO0FBbUd2RTs7O0dBR0c7QUFDSCxNQUFhLGVBQWdCLFNBQVEsZUFBUTtJQUszQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7Ozs7OzsrQ0FOUixlQUFlOzs7O1FBUXhCLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFO1lBQ3RELE1BQU0sSUFBSSxLQUFLLENBQUMsb0VBQW9FLENBQUMsQ0FBQztTQUN2RjtRQUVELE1BQU0sS0FBSyxHQUFHLElBQUksaUNBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2pELEtBQUssRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUs7WUFDMUIsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQy9CLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixFQUFFLE9BQU87WUFDekQsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQixFQUFFLFFBQVE7WUFDbkQsY0FBYyxFQUFFLEtBQUssQ0FBQyxXQUFXLEVBQUUsY0FBYztTQUNsRCxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRTtZQUMxQixLQUFLLENBQUMsU0FBUyxHQUFHO2dCQUNoQixrQkFBa0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO2FBQzNDLENBQUM7U0FDSDtRQUVELElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUMvQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7S0FDOUI7O0FBakNILDBDQWtDQzs7O0FBbUJEOztHQUVHO0FBQ0gsTUFBc0Isb0JBQW9CO0lBR3hDOzs7T0FHRztJQUNILFlBQTZCLEVBQVU7UUFBVixPQUFFLEdBQUYsRUFBRSxDQUFRO0tBQUk7SUFFM0M7OztPQUdHO0lBQ0ksWUFBWSxDQUFDLE9BQXdDO1FBQzFELElBQUksSUFBSSxDQUFDLFdBQVcsSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDOUYsTUFBTSxJQUFJLEtBQUssQ0FBQywrREFBK0QsQ0FBQyxDQUFDO1NBQ2xGO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDckIsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUVsQyxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksZUFBZSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEVBQUUsRUFBRTtnQkFDN0QsT0FBTyxFQUFFLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTztnQkFDOUIsZUFBZSxFQUFFLE1BQU0sQ0FBQyxJQUFJO2dCQUM1QixrQkFBa0IsRUFBRSxNQUFNLENBQUMsT0FBTztnQkFDbEMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxHQUFHO2dCQUMxQixNQUFNLEVBQUUsTUFBTSxDQUFDLE1BQU07Z0JBQ3JCLFlBQVksRUFBRSxNQUFNLENBQUMsWUFBWTtnQkFDakMsY0FBYyxFQUFFLE1BQU0sQ0FBQyxjQUFjO2dCQUNyQyxvQkFBb0IsRUFBRSxNQUFNLENBQUMsb0JBQW9CO2dCQUNqRCxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsZ0JBQWdCO2dCQUN6QyxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsZ0JBQWdCO2dCQUN6QyxXQUFXLEVBQUUsTUFBTSxDQUFDLFdBQVc7YUFDaEMsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzNCLE9BQU8sRUFBRSxhQUFhLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUMxRDtJQUVEOzs7Ozs7O09BT0c7SUFDTyxZQUFZLENBQUMsUUFBeUM7Ozs7Ozs7Ozs7S0FFL0Q7O0FBakRILG9EQXVEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBBd3MsIFJlc291cmNlIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElIdHRwQXBpIH0gZnJvbSAnLi9hcGknO1xuaW1wb3J0IHsgSHR0cE1ldGhvZCwgSUh0dHBSb3V0ZSB9IGZyb20gJy4vcm91dGUnO1xuaW1wb3J0IHsgQ2ZuSW50ZWdyYXRpb24gfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBpZ2F0ZXdheXYyJztcbmltcG9ydCB7IElJbnRlZ3JhdGlvbiB9IGZyb20gJy4uL2NvbW1vbic7XG5pbXBvcnQgeyBQYXJhbWV0ZXJNYXBwaW5nIH0gZnJvbSAnLi4vcGFyYW1ldGVyLW1hcHBpbmcnO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gSW50ZWdyYXRpb24gZm9yIGFuIEhUVFAgQVBJLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElIdHRwSW50ZWdyYXRpb24gZXh0ZW5kcyBJSW50ZWdyYXRpb24ge1xuICAvKiogVGhlIEhUVFAgQVBJIGFzc29jaWF0ZWQgd2l0aCB0aGlzIGludGVncmF0aW9uICovXG4gIHJlYWRvbmx5IGh0dHBBcGk6IElIdHRwQXBpO1xufVxuXG4vKipcbiAqIFN1cHBvcnRlZCBpbnRlZ3JhdGlvbiB0eXBlc1xuICovXG5leHBvcnQgZW51bSBIdHRwSW50ZWdyYXRpb25UeXBlIHtcbiAgLyoqXG4gICAqIEludGVncmF0aW9uIHR5cGUgaXMgYW4gSFRUUCBwcm94eS5cbiAgICpcbiAgICogRm9yIGludGVncmF0aW5nIHRoZSByb3V0ZSBvciBtZXRob2QgcmVxdWVzdCB3aXRoIGFuIEhUVFAgZW5kcG9pbnQsIHdpdGggdGhlXG4gICAqIGNsaWVudCByZXF1ZXN0IHBhc3NlZCB0aHJvdWdoIGFzLWlzLiBUaGlzIGlzIGFsc28gcmVmZXJyZWQgdG8gYXMgSFRUUCBwcm94eVxuICAgKiBpbnRlZ3JhdGlvbi4gRm9yIEhUVFAgQVBJIHByaXZhdGUgaW50ZWdyYXRpb25zLCB1c2UgYW4gSFRUUF9QUk9YWSBpbnRlZ3JhdGlvbi5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaHR0cC1hcGktZGV2ZWxvcC1pbnRlZ3JhdGlvbnMtaHR0cC5odG1sXG4gICAqL1xuICBIVFRQX1BST1hZID0gJ0hUVFBfUFJPWFknLFxuXG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiB0eXBlIGlzIGFuIEFXUyBwcm94eS5cbiAgICpcbiAgICogRm9yIGludGVncmF0aW5nIHRoZSByb3V0ZSBvciBtZXRob2QgcmVxdWVzdCB3aXRoIGEgTGFtYmRhIGZ1bmN0aW9uIG9yIG90aGVyXG4gICAqIEFXUyBzZXJ2aWNlIGFjdGlvbi4gVGhpcyBpbnRlZ3JhdGlvbiBpcyBhbHNvIHJlZmVycmVkIHRvIGFzIGEgTGFtYmRhIHByb3h5XG4gICAqIGludGVncmF0aW9uLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1kZXZlbG9wLWludGVncmF0aW9ucy1hd3Mtc2VydmljZXMuaHRtbFxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1kZXZlbG9wLWludGVncmF0aW9ucy1sYW1iZGEuaHRtbFxuICAgKi9cbiAgQVdTX1BST1hZID0gJ0FXU19QUk9YWScsXG59XG5cbi8qKlxuICogU3VwcG9ydGVkIGludGVncmF0aW9uIHN1YnR5cGVzXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1kZXZlbG9wLWludGVncmF0aW9ucy1hd3Mtc2VydmljZXMtcmVmZXJlbmNlLmh0bWxcbiAqL1xuZXhwb3J0IGVudW0gSHR0cEludGVncmF0aW9uU3VidHlwZSB7XG4gIC8qKlxuICAgKiBFdmVudEJyaWRnZSBQdXRFdmVudHMgaW50ZWdyYXRpb25cbiAgICovXG4gIEVWRU5UQlJJREdFX1BVVF9FVkVOVFMgPSAnRXZlbnRCcmlkZ2UtUHV0RXZlbnRzJyxcbiAgLyoqXG4gICAqIFNRUyBTZW5kTWVzc2FnZSBpbnRlZ3JhdGlvblxuICAgKi9cbiAgU1FTX1NFTkRfTUVTU0FHRSA9ICdTUVMtU2VuZE1lc3NhZ2UnLFxuICAvKipcbiAgICogU1FTIFJlY2VpdmVNZXNzYWdlIGludGVncmF0aW9uLFxuICAgKi9cbiAgU1FTX1JFQ0VJVkVfTUVTU0FHRSA9ICdTUVMtUmVjZWl2ZU1lc3NhZ2UnLFxuICAvKipcbiAgICogU1FTIERlbGV0ZU1lc3NhZ2UgaW50ZWdyYXRpb24sXG4gICAqL1xuICBTUVNfREVMRVRFX01FU1NBR0UgPSAnU1FTLURlbGV0ZU1lc3NhZ2UnLFxuICAvKipcbiAgICogU1FTIFB1cmdlUXVldWUgaW50ZWdyYXRpb25cbiAgICovXG4gIFNRU19QVVJHRV9RVUVVRSA9ICdTUVMtUHVyZ2VRdWV1ZScsXG4gIC8qKlxuICAgKiBBcHBDb25maWcgR2V0Q29uZmlndXJhdGlvbiBpbnRlZ3JhdGlvblxuICAgKi9cbiAgQVBQQ09ORklHX0dFVF9DT05GSUdVUkFUSU9OID0gJ0FwcENvbmZpZy1HZXRDb25maWd1cmF0aW9uJyxcbiAgLyoqXG4gICAqIEtpbmVzaXMgUHV0UmVjb3JkIGludGVncmF0aW9uXG4gICAqL1xuICBLSU5FU0lTX1BVVF9SRUNPUkQgPSAnS2luZXNpcy1QdXRSZWNvcmQnLFxuICAvKipcbiAgICogU3RlcCBGdW5jdGlvbnMgU3RhcnRFeGVjdXRpb24gaW50ZWdyYXRpb25cbiAgICovXG4gIFNURVBGVU5DVElPTlNfU1RBUlRfRVhFQ1VUSU9OID0gJ1N0ZXBGdW5jdGlvbnMtU3RhcnRFeGVjdXRpb24nLFxuICAvKipcbiAgICogU3RlcCBGdW5jdGlvbnMgU3RhcnRTeW5jRXhlY3V0aW9uIGludGVncmF0aW9uXG4gICAqL1xuICBTVEVQRlVOQ1RJT05TX1NUQVJUX1NZTkNfRVhFQ1VUSU9OID0gJ1N0ZXBGdW5jdGlvbnMtU3RhcnRTeW5jRXhlY3V0aW9uJyxcbiAgLyoqXG4gICAqIFN0ZXAgRnVuY3Rpb25zIFN0b3BFeGVjdXRpb24gaW50ZWdyYXRpb25cbiAgICovXG4gIFNURVBGVU5DVElPTlNfU1RPUF9FWEVDVVRJT04gPSAnU3RlcEZ1bmN0aW9ucy1TdG9wRXhlY3V0aW9uJyxcbn1cblxuLyoqXG4gKiBDcmVkZW50aWFscyB1c2VkIGZvciBBV1MgU2VydmljZSBpbnRlZ3JhdGlvbnMuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBJbnRlZ3JhdGlvbkNyZWRlbnRpYWxzIHtcbiAgLyoqXG4gICAqIFVzZSB0aGUgc3BlY2lmaWVkIHJvbGUgZm9yIGludGVncmF0aW9uIHJlcXVlc3RzXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Sb2xlKHJvbGU6IElSb2xlKTogSW50ZWdyYXRpb25DcmVkZW50aWFscyB7XG4gICAgcmV0dXJuIHsgY3JlZGVudGlhbHNBcm46IHJvbGUucm9sZUFybiB9O1xuICB9XG5cbiAgLyoqIFVzZSB0aGUgY2FsbGluZyB1c2VyJ3MgaWRlbnRpdHkgdG8gY2FsbCB0aGUgaW50ZWdyYXRpb24gKi9cbiAgcHVibGljIHN0YXRpYyB1c2VDYWxsZXJJZGVudGl0eSgpOiBJbnRlZ3JhdGlvbkNyZWRlbnRpYWxzIHtcbiAgICByZXR1cm4geyBjcmVkZW50aWFsc0FybjogYGFybjoke0F3cy5QQVJUSVRJT059OmlhbTo6Kjp1c2VyLypgIH07XG4gIH1cblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgY3JlZGVudGlhbHNcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBjcmVkZW50aWFsc0Fybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIFN1cHBvcnRlZCBjb25uZWN0aW9uIHR5cGVzXG4gKi9cbmV4cG9ydCBlbnVtIEh0dHBDb25uZWN0aW9uVHlwZSB7XG4gIC8qKlxuICAgKiBGb3IgcHJpdmF0ZSBjb25uZWN0aW9ucyBiZXR3ZWVuIEFQSSBHYXRld2F5IGFuZCByZXNvdXJjZXMgaW4gYSBWUENcbiAgICovXG4gIFZQQ19MSU5LID0gJ1ZQQ19MSU5LJyxcbiAgLyoqXG4gICAqIEZvciBjb25uZWN0aW9ucyB0aHJvdWdoIHB1YmxpYyByb3V0YWJsZSBpbnRlcm5ldFxuICAgKi9cbiAgSU5URVJORVQgPSAnSU5URVJORVQnLFxufVxuXG4vKipcbiAqIFBheWxvYWQgZm9ybWF0IHZlcnNpb24gZm9yIGxhbWJkYSBwcm94eSBpbnRlZ3JhdGlvblxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaHR0cC1hcGktZGV2ZWxvcC1pbnRlZ3JhdGlvbnMtbGFtYmRhLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIFBheWxvYWRGb3JtYXRWZXJzaW9uIHtcbiAgLyoqIFZlcnNpb24gMS4wICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVkVSU0lPTl8xXzAgPSBuZXcgUGF5bG9hZEZvcm1hdFZlcnNpb24oJzEuMCcpO1xuICAvKiogVmVyc2lvbiAyLjAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBWRVJTSU9OXzJfMCA9IG5ldyBQYXlsb2FkRm9ybWF0VmVyc2lvbignMi4wJyk7XG5cbiAgLyoqXG4gICAqIEEgY3VzdG9tIHBheWxvYWQgdmVyc2lvbi5cbiAgICogVHlwaWNhbGx5IHVzZWQgaWYgdGhlcmUgaXMgYSB2ZXJzaW9uIG51bWJlciB0aGF0IHRoZSBDREsgZG9lc24ndCBzdXBwb3J0IHlldFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjdXN0b20odmVyc2lvbjogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBQYXlsb2FkRm9ybWF0VmVyc2lvbih2ZXJzaW9uKTtcbiAgfVxuXG4gIC8qKiB2ZXJzaW9uIGFzIGEgc3RyaW5nICovXG4gIHB1YmxpYyByZWFkb25seSB2ZXJzaW9uOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcih2ZXJzaW9uOiBzdHJpbmcpIHtcbiAgICB0aGlzLnZlcnNpb24gPSB2ZXJzaW9uO1xuICB9XG59XG5cbi8qKlxuICogVGhlIGludGVncmF0aW9uIHByb3BlcnRpZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwSW50ZWdyYXRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgSFRUUCBBUEkgdG8gd2hpY2ggdGhpcyBpbnRlZ3JhdGlvbiBzaG91bGQgYmUgYm91bmQuXG4gICAqL1xuICByZWFkb25seSBodHRwQXBpOiBJSHR0cEFwaTtcblxuICAvKipcbiAgICogSW50ZWdyYXRpb24gdHlwZVxuICAgKi9cbiAgcmVhZG9ubHkgaW50ZWdyYXRpb25UeXBlOiBIdHRwSW50ZWdyYXRpb25UeXBlO1xuXG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiBzdWJ0eXBlLlxuICAgKlxuICAgKiBVc2VkIGZvciBBV1MgU2VydmljZSBpbnRlZ3JhdGlvbnMsIHNwZWNpZmllcyB0aGUgdGFyZ2V0IG9mIHRoZSBpbnRlZ3JhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lLCByZXF1aXJlZCBpZiBubyBgaW50ZWdyYXRpb25VcmlgIGlzIGRlZmluZWQuXG4gICAqL1xuICByZWFkb25seSBpbnRlZ3JhdGlvblN1YnR5cGU/OiBIdHRwSW50ZWdyYXRpb25TdWJ0eXBlO1xuXG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiBVUkkuXG4gICAqIFRoaXMgd2lsbCBiZSB0aGUgZnVuY3Rpb24gQVJOIGluIHRoZSBjYXNlIG9mIGBIdHRwSW50ZWdyYXRpb25UeXBlLkFXU19QUk9YWWAsXG4gICAqIG9yIEhUVFAgVVJMIGluIHRoZSBjYXNlIG9mIGBIdHRwSW50ZWdyYXRpb25UeXBlLkhUVFBfUFJPWFlgLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmUsIHJlcXVpcmVkIGlmIG5vIGBpbnRlZ3JhdGlvblN1YnR5cGVgIGlzIGRlZmluZWQuXG4gICAqL1xuICByZWFkb25seSBpbnRlZ3JhdGlvblVyaT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEhUVFAgbWV0aG9kIHRvIHVzZSB3aGVuIGNhbGxpbmcgdGhlIHVuZGVybHlpbmcgSFRUUCBwcm94eVxuICAgKiBAZGVmYXVsdCAtIG5vbmUuIHJlcXVpcmVkIGlmIHRoZSBpbnRlZ3JhdGlvbiB0eXBlIGlzIGBIdHRwSW50ZWdyYXRpb25UeXBlLkhUVFBfUFJPWFlgLlxuICAgKi9cbiAgcmVhZG9ubHkgbWV0aG9kPzogSHR0cE1ldGhvZDtcblxuICAvKipcbiAgICogVGhlIElEIG9mIHRoZSBWUEMgbGluayBmb3IgYSBwcml2YXRlIGludGVncmF0aW9uLiBTdXBwb3J0ZWQgb25seSBmb3IgSFRUUCBBUElzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHVuZGVmaW5lZFxuICAgKi9cbiAgcmVhZG9ubHkgY29ubmVjdGlvbklkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgdHlwZSBvZiB0aGUgbmV0d29yayBjb25uZWN0aW9uIHRvIHRoZSBpbnRlZ3JhdGlvbiBlbmRwb2ludFxuICAgKlxuICAgKiBAZGVmYXVsdCBIdHRwQ29ubmVjdGlvblR5cGUuSU5URVJORVRcbiAgICovXG4gIHJlYWRvbmx5IGNvbm5lY3Rpb25UeXBlPzogSHR0cENvbm5lY3Rpb25UeXBlO1xuXG4gIC8qKlxuICAgKiBUaGUgdmVyc2lvbiBvZiB0aGUgcGF5bG9hZCBmb3JtYXRcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaHR0cC1hcGktZGV2ZWxvcC1pbnRlZ3JhdGlvbnMtbGFtYmRhLmh0bWxcbiAgICogQGRlZmF1bHQgLSBkZWZhdWx0cyB0byBsYXRlc3QgaW4gdGhlIGNhc2Ugb2YgSHR0cEludGVncmF0aW9uVHlwZS5BV1NfUFJPWFlgLCBpcnJlbGV2YW50IG90aGVyd2lzZS5cbiAgICovXG4gIHJlYWRvbmx5IHBheWxvYWRGb3JtYXRWZXJzaW9uPzogUGF5bG9hZEZvcm1hdFZlcnNpb247XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB0aGUgVExTIGNvbmZpZ3VyYXRpb24gZm9yIGEgcHJpdmF0ZSBpbnRlZ3JhdGlvblxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWFwaWdhdGV3YXl2Mi1pbnRlZ3JhdGlvbi10bHNjb25maWcuaHRtbFxuICAgKiBAZGVmYXVsdCB1bmRlZmluZWQgcHJpdmF0ZSBpbnRlZ3JhdGlvbiB0cmFmZmljIHdpbGwgdXNlIEhUVFAgcHJvdG9jb2xcbiAgICovXG4gIHJlYWRvbmx5IHNlY3VyZVNlcnZlck5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyBob3cgdG8gdHJhbnNmb3JtIEhUVFAgcmVxdWVzdHMgYmVmb3JlIHNlbmRpbmcgdGhlbSB0byB0aGUgYmFja2VuZFxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1wYXJhbWV0ZXItbWFwcGluZy5odG1sXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZCByZXF1ZXN0cyBhcmUgc2VudCB0byB0aGUgYmFja2VuZCB1bm1vZGlmaWVkXG4gICAqL1xuICByZWFkb25seSBwYXJhbWV0ZXJNYXBwaW5nPzogUGFyYW1ldGVyTWFwcGluZztcblxuICAvKipcbiAgICogVGhlIGNyZWRlbnRpYWxzIHdpdGggd2hpY2ggdG8gaW52b2tlIHRoZSBpbnRlZ3JhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBjcmVkZW50aWFscywgdXNlIHJlc291cmNlLWJhc2VkIHBlcm1pc3Npb25zIG9uIHN1cHBvcnRlZCBBV1Mgc2VydmljZXNcbiAgICovXG4gIHJlYWRvbmx5IGNyZWRlbnRpYWxzPzogSW50ZWdyYXRpb25DcmVkZW50aWFscztcbn1cblxuLyoqXG4gKiBUaGUgaW50ZWdyYXRpb24gZm9yIGFuIEFQSSByb3V0ZS5cbiAqIEByZXNvdXJjZSBBV1M6OkFwaUdhdGV3YXlWMjo6SW50ZWdyYXRpb25cbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBJbnRlZ3JhdGlvbiBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUh0dHBJbnRlZ3JhdGlvbiB7XG4gIHB1YmxpYyByZWFkb25seSBpbnRlZ3JhdGlvbklkOiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IGh0dHBBcGk6IElIdHRwQXBpO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBIdHRwSW50ZWdyYXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBpZiAoIXByb3BzLmludGVncmF0aW9uU3VidHlwZSAmJiAhcHJvcHMuaW50ZWdyYXRpb25VcmkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignRWl0aGVyIGBpbnRlZ3JhdGlvblN1YnR5cGVgIG9yIGBpbnRlZ3JhdGlvblVyaWAgbXVzdCBiZSBzcGVjaWZpZWQuJyk7XG4gICAgfVxuXG4gICAgY29uc3QgaW50ZWcgPSBuZXcgQ2ZuSW50ZWdyYXRpb24odGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgYXBpSWQ6IHByb3BzLmh0dHBBcGkuYXBpSWQsXG4gICAgICBpbnRlZ3JhdGlvblR5cGU6IHByb3BzLmludGVncmF0aW9uVHlwZSxcbiAgICAgIGludGVncmF0aW9uU3VidHlwZTogcHJvcHMuaW50ZWdyYXRpb25TdWJ0eXBlLFxuICAgICAgaW50ZWdyYXRpb25Vcmk6IHByb3BzLmludGVncmF0aW9uVXJpLFxuICAgICAgaW50ZWdyYXRpb25NZXRob2Q6IHByb3BzLm1ldGhvZCxcbiAgICAgIGNvbm5lY3Rpb25JZDogcHJvcHMuY29ubmVjdGlvbklkLFxuICAgICAgY29ubmVjdGlvblR5cGU6IHByb3BzLmNvbm5lY3Rpb25UeXBlLFxuICAgICAgcGF5bG9hZEZvcm1hdFZlcnNpb246IHByb3BzLnBheWxvYWRGb3JtYXRWZXJzaW9uPy52ZXJzaW9uLFxuICAgICAgcmVxdWVzdFBhcmFtZXRlcnM6IHByb3BzLnBhcmFtZXRlck1hcHBpbmc/Lm1hcHBpbmdzLFxuICAgICAgY3JlZGVudGlhbHNBcm46IHByb3BzLmNyZWRlbnRpYWxzPy5jcmVkZW50aWFsc0FybixcbiAgICB9KTtcblxuICAgIGlmIChwcm9wcy5zZWN1cmVTZXJ2ZXJOYW1lKSB7XG4gICAgICBpbnRlZy50bHNDb25maWcgPSB7XG4gICAgICAgIHNlcnZlck5hbWVUb1ZlcmlmeTogcHJvcHMuc2VjdXJlU2VydmVyTmFtZSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgdGhpcy5pbnRlZ3JhdGlvbklkID0gaW50ZWcucmVmO1xuICAgIHRoaXMuaHR0cEFwaSA9IHByb3BzLmh0dHBBcGk7XG4gIH1cbn1cblxuLyoqXG4gKiBPcHRpb25zIHRvIHRoZSBIdHRwUm91dGVJbnRlZ3JhdGlvbiBkdXJpbmcgaXRzIGJpbmQgb3BlcmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIHJvdXRlIHRvIHdoaWNoIHRoaXMgaXMgYmVpbmcgYm91bmQuXG4gICAqL1xuICByZWFkb25seSByb3V0ZTogSUh0dHBSb3V0ZTtcblxuICAvKipcbiAgICogVGhlIGN1cnJlbnQgc2NvcGUgaW4gd2hpY2ggdGhlIGJpbmQgaXMgb2NjdXJyaW5nLlxuICAgKiBJZiB0aGUgYEh0dHBSb3V0ZUludGVncmF0aW9uYCBiZWluZyBib3VuZCBjcmVhdGVzIGFkZGl0aW9uYWwgY29uc3RydWN0cyxcbiAgICogdGhpcyB3aWxsIGJlIHVzZWQgYXMgdGhlaXIgcGFyZW50IHNjb3BlLlxuICAgKi9cbiAgcmVhZG9ubHkgc2NvcGU6IENvbnN0cnVjdDtcbn1cblxuLyoqXG4gKiBUaGUgaW50ZXJmYWNlIHRoYXQgdmFyaW91cyByb3V0ZSBpbnRlZ3JhdGlvbiBjbGFzc2VzIHdpbGwgaW5oZXJpdC5cbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEh0dHBSb3V0ZUludGVncmF0aW9uIHtcbiAgcHJpdmF0ZSBpbnRlZ3JhdGlvbj86IEh0dHBJbnRlZ3JhdGlvbjtcblxuICAvKipcbiAgICogSW5pdGlhbGl6ZSBhbiBpbnRlZ3JhdGlvbiBmb3IgYSByb3V0ZSBvbiBodHRwIGFwaS5cbiAgICogQHBhcmFtIGlkIGlkIG9mIHRoZSB1bmRlcmx5aW5nIGBIdHRwSW50ZWdyYXRpb25gIGNvbnN0cnVjdC5cbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgaWQ6IHN0cmluZykge31cblxuICAvKipcbiAgICogSW50ZXJuYWwgbWV0aG9kIGNhbGxlZCB3aGVuIGJpbmRpbmcgdGhpcyBpbnRlZ3JhdGlvbiB0byB0aGUgcm91dGUuXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF9iaW5kVG9Sb3V0ZShvcHRpb25zOiBIdHRwUm91dGVJbnRlZ3JhdGlvbkJpbmRPcHRpb25zKTogeyByZWFkb25seSBpbnRlZ3JhdGlvbklkOiBzdHJpbmcgfSB7XG4gICAgaWYgKHRoaXMuaW50ZWdyYXRpb24gJiYgdGhpcy5pbnRlZ3JhdGlvbi5odHRwQXBpLm5vZGUuYWRkciAhPT0gb3B0aW9ucy5yb3V0ZS5odHRwQXBpLm5vZGUuYWRkcikge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdBIHNpbmdsZSBpbnRlZ3JhdGlvbiBjYW5ub3QgYmUgYXNzb2NpYXRlZCB3aXRoIG11bHRpcGxlIEFQSXMuJyk7XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLmludGVncmF0aW9uKSB7XG4gICAgICBjb25zdCBjb25maWcgPSB0aGlzLmJpbmQob3B0aW9ucyk7XG5cbiAgICAgIHRoaXMuaW50ZWdyYXRpb24gPSBuZXcgSHR0cEludGVncmF0aW9uKG9wdGlvbnMuc2NvcGUsIHRoaXMuaWQsIHtcbiAgICAgICAgaHR0cEFwaTogb3B0aW9ucy5yb3V0ZS5odHRwQXBpLFxuICAgICAgICBpbnRlZ3JhdGlvblR5cGU6IGNvbmZpZy50eXBlLFxuICAgICAgICBpbnRlZ3JhdGlvblN1YnR5cGU6IGNvbmZpZy5zdWJ0eXBlLFxuICAgICAgICBpbnRlZ3JhdGlvblVyaTogY29uZmlnLnVyaSxcbiAgICAgICAgbWV0aG9kOiBjb25maWcubWV0aG9kLFxuICAgICAgICBjb25uZWN0aW9uSWQ6IGNvbmZpZy5jb25uZWN0aW9uSWQsXG4gICAgICAgIGNvbm5lY3Rpb25UeXBlOiBjb25maWcuY29ubmVjdGlvblR5cGUsXG4gICAgICAgIHBheWxvYWRGb3JtYXRWZXJzaW9uOiBjb25maWcucGF5bG9hZEZvcm1hdFZlcnNpb24sXG4gICAgICAgIHNlY3VyZVNlcnZlck5hbWU6IGNvbmZpZy5zZWN1cmVTZXJ2ZXJOYW1lLFxuICAgICAgICBwYXJhbWV0ZXJNYXBwaW5nOiBjb25maWcucGFyYW1ldGVyTWFwcGluZyxcbiAgICAgICAgY3JlZGVudGlhbHM6IGNvbmZpZy5jcmVkZW50aWFscyxcbiAgICAgIH0pO1xuICAgIH1cbiAgICB0aGlzLmNvbXBsZXRlQmluZChvcHRpb25zKTtcbiAgICByZXR1cm4geyBpbnRlZ3JhdGlvbklkOiB0aGlzLmludGVncmF0aW9uLmludGVncmF0aW9uSWQgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb21wbGV0ZSB0aGUgYmluZGluZyBvZiB0aGUgaW50ZWdyYXRpb24gdG8gdGhlIHJvdXRlLiBJbiBzb21lIGNhc2VzLCB0aGVyZSBpc1xuICAgKiBzb21lIGFkZGl0aW9uYWwgd29yayB0byBkbywgc3VjaCBhcyBhZGRpbmcgcGVybWlzc2lvbnMgZm9yIHRoZSBBUEkgdG8gYWNjZXNzXG4gICAqIHRoZSB0YXJnZXQuIFRoaXMgd29yayBpcyBuZWNlc3Nhcnkgd2hldGhlciB0aGUgaW50ZWdyYXRpb24gaGFzIGp1c3QgYmVlblxuICAgKiBjcmVhdGVkIGZvciB0aGlzIHJvdXRlIG9yIGl0IGlzIGFuIGV4aXN0aW5nIG9uZSwgcHJldmlvdXNseSBjcmVhdGVkIGZvciBvdGhlclxuICAgKiByb3V0ZXMuIEluIG1vc3QgY2FzZXMsIGhvd2V2ZXIsIGNvbmNyZXRlIGltcGxlbWVudGF0aW9ucyBkbyBub3QgbmVlZCB0b1xuICAgKiBvdmVycmlkZSB0aGlzIG1ldGhvZC5cbiAgICovXG4gIHByb3RlY3RlZCBjb21wbGV0ZUJpbmQoX29wdGlvbnM6IEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMpOiB2b2lkIHtcbiAgICAvLyBuby1vcCBieSBkZWZhdWx0XG4gIH1cblxuICAvKipcbiAgICogQmluZCB0aGlzIGludGVncmF0aW9uIHRvIHRoZSByb3V0ZS5cbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKG9wdGlvbnM6IEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMpOiBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZztcbn1cblxuLyoqXG4gKiBDb25maWcgcmV0dXJuZWQgYmFjayBhcyBhIHJlc3VsdCBvZiB0aGUgYmluZC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyB7XG4gIC8qKlxuICAgKiBJbnRlZ3JhdGlvbiB0eXBlLlxuICAgKi9cbiAgcmVhZG9ubHkgdHlwZTogSHR0cEludGVncmF0aW9uVHlwZTtcblxuICAvKipcbiAgICogSW50ZWdyYXRpb24gc3VidHlwZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lLCByZXF1aXJlZCBpZiBubyBgaW50ZWdyYXRpb25VcmlgIGlzIGRlZmluZWQuXG4gICAqL1xuICByZWFkb25seSBzdWJ0eXBlPzogSHR0cEludGVncmF0aW9uU3VidHlwZTtcblxuICAvKipcbiAgICogSW50ZWdyYXRpb24gVVJJXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZSwgcmVxdWlyZWQgaWYgbm8gYGludGVncmF0aW9uU3VidHlwZWAgaXMgZGVmaW5lZC5cbiAgICovXG4gIHJlYWRvbmx5IHVyaT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEhUVFAgbWV0aG9kIHRoYXQgbXVzdCBiZSB1c2VkIHRvIGludm9rZSB0aGUgdW5kZXJseWluZyBwcm94eS5cbiAgICogUmVxdWlyZWQgZm9yIGBIdHRwSW50ZWdyYXRpb25UeXBlLkhUVFBfUFJPWFlgXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBtZXRob2Q/OiBIdHRwTWV0aG9kO1xuXG4gIC8qKlxuICAgKiBUaGUgSUQgb2YgdGhlIFZQQyBsaW5rIGZvciBhIHByaXZhdGUgaW50ZWdyYXRpb24uIFN1cHBvcnRlZCBvbmx5IGZvciBIVFRQIEFQSXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBjb25uZWN0aW9uSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIHRoZSBuZXR3b3JrIGNvbm5lY3Rpb24gdG8gdGhlIGludGVncmF0aW9uIGVuZHBvaW50XG4gICAqXG4gICAqIEBkZWZhdWx0IEh0dHBDb25uZWN0aW9uVHlwZS5JTlRFUk5FVFxuICAgKi9cbiAgcmVhZG9ubHkgY29ubmVjdGlvblR5cGU/OiBIdHRwQ29ubmVjdGlvblR5cGU7XG5cbiAgLyoqXG4gICAqIFBheWxvYWQgZm9ybWF0IHZlcnNpb24gaW4gdGhlIGNhc2Ugb2YgbGFtYmRhIHByb3h5IGludGVncmF0aW9uXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwaWdhdGV3YXkvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2h0dHAtYXBpLWRldmVsb3AtaW50ZWdyYXRpb25zLWxhbWJkYS5odG1sXG4gICAqIEBkZWZhdWx0IC0gdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBwYXlsb2FkRm9ybWF0VmVyc2lvbjogUGF5bG9hZEZvcm1hdFZlcnNpb247XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB0aGUgc2VydmVyIG5hbWUgdG8gdmVyaWZpZWQgYnkgSFRUUFMgd2hlbiBjYWxsaW5nIHRoZSBiYWNrZW5kIGludGVncmF0aW9uXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYXBpZ2F0ZXdheXYyLWludGVncmF0aW9uLXRsc2NvbmZpZy5odG1sXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZCBwcml2YXRlIGludGVncmF0aW9uIHRyYWZmaWMgd2lsbCB1c2UgSFRUUCBwcm90b2NvbFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJlU2VydmVyTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgKiBTcGVjaWZpZXMgaG93IHRvIHRyYW5zZm9ybSBIVFRQIHJlcXVlc3RzIGJlZm9yZSBzZW5kaW5nIHRoZW0gdG8gdGhlIGJhY2tlbmRcbiAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1wYXJhbWV0ZXItbWFwcGluZy5odG1sXG4gICogQGRlZmF1bHQgdW5kZWZpbmVkIHJlcXVlc3RzIGFyZSBzZW50IHRvIHRoZSBiYWNrZW5kIHVubW9kaWZpZWRcbiAgKi9cbiAgcmVhZG9ubHkgcGFyYW1ldGVyTWFwcGluZz86IFBhcmFtZXRlck1hcHBpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBjcmVkZW50aWFscyB3aXRoIHdoaWNoIHRvIGludm9rZSB0aGUgaW50ZWdyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gY3JlZGVudGlhbHMsIHVzZSByZXNvdXJjZS1iYXNlZCBwZXJtaXNzaW9ucyBvbiBzdXBwb3J0ZWQgQVdTIHNlcnZpY2VzXG4gICAqL1xuICByZWFkb25seSBjcmVkZW50aWFscz86IEludGVncmF0aW9uQ3JlZGVudGlhbHM7XG59XG4iXX0=