"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * Supported CORS HTTP methods
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    /** HTTP ANY */
    CorsHttpMethod["ANY"] = "*";
    /** HTTP DELETE */
    CorsHttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    CorsHttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    CorsHttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    CorsHttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    CorsHttpMethod["POST"] = "POST";
    /** HTTP PUT */
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod || (exports.CorsHttpMethod = CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
}
/**
 * Create a new API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    /**
     * Import an existing HTTP API into this CDK app.
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpApiAttributes);
            }
            throw error;
        }
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApi);
            }
            throw error;
        }
        this.httpApiName = props?.apiName ?? id;
        this.disableExecuteApiEndpoint = props?.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props?.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge?.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props?.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props?.defaultAuthorizer;
        this.defaultAuthorizationScopes = props?.defaultAuthorizationScopes;
        if (props?.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if (props?.createDefaultStage === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props?.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props?.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if (props?.createDefaultStage === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * Get the default endpoint for this API.
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * Get the URL to the default stage of this API.
     * Returns `undefined` if `createDefaultStage` is unset.
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * Add a new stage.
     */
    addStage(id, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * Add multiple routes that uses the same configuration. The routes all go to the same path, but for different
     * methods.
     */
    addRoutes(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_AddRoutesOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRoutes);
            }
            throw error;
        }
        const methods = options.methods ?? [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            const authorizationScopes = options.authorizationScopes ?? this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: options.authorizer ?? this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpApi", version: "2.102.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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