"""A setuptools based setup module.
See:
https://packaging.python.org/guides/distributing-packages-using-setuptools/
https://github.com/pypa/sampleproject
"""

from os import path

from setuptools import setup, find_packages

with open(path.join(path.abspath(path.dirname(__file__)), 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    name='Quandoo',
    version='1.3.6',
    description="A SDK for interacting with the Quandoo API, it is a work in progress",
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/fraser-langton/Quandoo',
    author='Fraser Langton',
    author_email='fraserbasil@gmail.com',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    keywords='quandoo api',
    packages=find_packages(exclude=['contrib', 'docs', 'tests', 'test']),
    python_requires='>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, <4',
    install_requires=['requests', 'tzlocal', 'python-dotenv'],
)
