import React from "react";
import DropdownItem from "../../elements/DropdownItem";
import Select from "../../elements/Select";
import Row from "../../spacing/Row";
const CSVDownloadConfigSection = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement("p", { className: 'text-header-3' }, "Sheet to Export"),
            React.createElement(Select, { width: 'medium', value: props.dfNames[props.selectedSheetIndex], onChange: (dfName) => {
                    // Note: If there are duplicated sheet names, then this only lets you select the first one
                    // We need to add SheetID
                    const dfNameIndex = props.dfNames.indexOf(dfName);
                    props.setUIState(prevUIState => {
                        return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: dfNameIndex, exportConfiguration: { exportType: 'csv' } });
                    });
                } }, ...props.dfNames.map((dfName, idx) => {
                return (React.createElement(DropdownItem, { key: idx, title: dfName }));
            }))),
        React.createElement(Row, { justify: 'space-around' },
            React.createElement("p", { className: 'ma-25px text-align-center' }, "CSV exports will not reflect any formatting changes made in Mito."))));
};
export default CSVDownloadConfigSection;
//# sourceMappingURL=CSVDownloadConfigSection.js.map