import React from 'react';
/**
 *
 * A wrapper around divs to displayed centered in the grid
 *
 * @param props - the children you want to display in the center of the grid
 */
const GridDataEmptyContainer = (props) => {
    return (React.createElement("div", { className: 'endo-grid-empty-container' },
        React.createElement("div", { className: 'endo-grid-empty-text-container' }, props.children)));
};
const EmptyGridMessages = (props) => {
    return (React.createElement(React.Fragment, null,
        props.sheetData === undefined &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "You have not imported any data into Mito yet."),
                React.createElement("p", { className: 'text-body-1' }, "Pass a dataframe to the mitosheet.sheet call, or use the Import button in the toolbar above.")),
        props.sheetData !== undefined && props.sheetData.numRows === 0 && props.sheetData.numColumns === 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No data in dataframe.")),
        props.sheetData !== undefined && props.sheetData.numRows > 0 && props.sheetData.numColumns === 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No columns in dataframe.")),
        props.sheetData !== undefined && props.sheetData.numRows === 0 && props.sheetData.numColumns > 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No rows in dataframe."))));
};
export default EmptyGridMessages;
//# sourceMappingURL=EmptyGridMessages.js.map