# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_type.ipynb.

# %% auto 0
__all__ = ['T', 'P', 'VArgs', 'Tuples', 'ArgsKind', 'KwdsKind', 'BoundReturn', 'DecoReturn', 'FoundArguments', 'FoundArgument',
           'OptionsDict', 'BoundSignatureOptions', 'MethodOptions', 'AnnotationSignatureOptions',
           'CallableSignatureOptions', 'BoundReturnFormat', 'BindOptions', 'BindScopes']

# %% ../nbs/00_type.ipynb 6
from inspect import (Signature, BoundArguments, _ParameterKind as ParamKind)

# %% ../nbs/00_type.ipynb 8
from typing import (
    Any, ParamSpec, Callable, TypeVar, TypeAlias, Literal, OrderedDict, Union,
    Type, TypedDict
)

# %% ../nbs/00_type.ipynb 10
#| export


# %% ../nbs/00_type.ipynb 12
#| export


# %% ../nbs/00_type.ipynb 14
#| export


# %% ../nbs/00_type.ipynb 16
T = TypeVar('T')
P = ParamSpec('P')

# %% ../nbs/00_type.ipynb 18
VArgs: TypeAlias = tuple[T, ...]
'''Variadic arguments, i.e. `*args`.''';

Tuples: TypeAlias = tuple[tuple, ...]
'''Tuple of tuples.''';

ArgsKind: TypeAlias = Literal[ParamKind.POSITIONAL_ONLY, ParamKind.POSITIONAL_OR_KEYWORD]
'''Valid `ParameterKind` for variadic arguments that are to be moved from 
`*args` (i.e. `ParameterKind.VAR_POSITIONAL`) to another positional part of the signature.''';

KwdsKind: TypeAlias = Literal[ParamKind.KEYWORD_ONLY, ParamKind.POSITIONAL_OR_KEYWORD]
'''Valid `ParameterKind` for variadic arguments that are to be moved from 
`**kwargs` (i.e. `ParameterKind.VAR_KEYWORD`) to another keyword part of the signature.''';

# %% ../nbs/00_type.ipynb 20
BoundReturn: TypeAlias = Union[
    None, # ReturnFormat.none
    tuple[None, None], # ReturnFormat.nones
    BoundArguments, # ReturnFormat.bound
    tuple[BoundArguments, None], # ReturnFormat.boundnone
    tuple[tuple, dict], # ReturnFormat.original
    OrderedDict[str, Any], # ReturnFormat.arguments
    tuple,# ReturnFormat.args
    dict, # ReturnFormat.kwargs
]
'''The various possible return types of `ReturnFormat.format(...)`.''';

DecoReturn: TypeAlias = Union[None, Callable, Any, TypeError]
'''The various possible return types of our `DecoratedReturn.format(...)`.''';

# %% ../nbs/00_type.ipynb 22
class FoundArgument(TypedDict):
    '''Includes the name (`key`), index (`idx`) and value (`val`) of a found variadic argument.'''
    key: str; idx: int; val: Any;
    
FoundArguments: TypeAlias = tuple[FoundArgument, ...]

# %% ../nbs/00_type.ipynb 25
def _is_kw_in_annots(keyword: str, mangled: str, annotations: dict, unmangled_annots: dict) -> bool:
    k_in_unmg = keyword in unmangled_annots # key is in the unmangled keywords
    k_in_anns = keyword in annotations  # key is a mangled keyword
    m_in_anns = mangled in annotations  # if the mangled keyword is in the annotations
    return any((k_in_unmg, k_in_anns, m_in_anns))

# %% ../nbs/00_type.ipynb 26
@classmethod
def get_typed_dict_options(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T:
    '''Get the keywords arguments as specified in a `TypedDict`.
    
    Parameters
    ----------
    __pop_keyword : bool, default: True
        Whether to remove the keyword from the `kwargs` dictionary, by default True
        
    __defaults : T, optional
        The default values for the `TypedDict`, by default None
        
    kwargs : dict
        The keyword arguments to be added to the `TypedDict`
        
    Returns
    -------
    T
        The `TypedDict` with the keyword arguments added
    '''
    res = __defaults or {}
    prv, ann = (f'_{cls.__name__}', cls.__annotations__)
    unm = {a.split(prv)[-1] for a in ann} # unmangled annotation names
    itm = list(kwargs.items())
    for k, v in itm:
        m = f'{prv}{k}' # mangled keyword name
        if _is_kw_in_annots(k, m, ann, unm):
            key = k.split(prv)[-1]
            res[key] = v # add the key and value to the result
            if __pop_keyword: kwargs.pop(k, None)
            continue
    return res

# %% ../nbs/00_type.ipynb 27
@classmethod
def prune_type_dict_keywords(cls: Type[T], **kwargs) -> T:
    '''Remove specified keywords from a dictionary that match the annotations of a `TypedDict`.
    
    This method is useful for cleaning up a dictionary by removing keys that are 
    defined in a `TypedDict`'s annotations, ensuring that only relevant keywords 
    are retained or processed further.

    Parameters
    ----------
    kwargs : dict
        A dictionary of keywords that may or may not correspond to the `TypedDict`'s annotations.

    Returns
    -------
    T
        A dictionary containing only those keywords that do not match the annotations
        of the `TypedDict`.
    '''
    keys = set()
    prv, ann = (f'_{cls.__name__}', cls.__annotations__)
    unm = {a.split(prv)[-1] for a in ann}
    for k in kwargs:
        m = f'{prv}{k}' # mangled keyword name
        if _is_kw_in_annots(k, m, ann, unm):
            keys.add(k)
    return dict(((k, v) for k, v in kwargs.items() if k not in keys))
    

# %% ../nbs/00_type.ipynb 29
class OptionsDict(TypedDict):
    '''A base class for creating options dictionaries.
    
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords

# %% ../nbs/00_type.ipynb 31
class BoundSignatureOptions(OptionsDict):
    '''Options for updating a `Signature` from `BoundArguments`, chiefly for whether or not
    to include variadic arguments and/or keyword arguments in the signature explicitly rather 
    than just as `*args` and `**kwargs`.
    
    Parameters
    ----------
    __args : bool
        Whether or not to include variadic arguments in the signature explicitly.
        
    __kwds : bool
        Whether or not to include keyword arguments in the signature explicitly.
        
    __args_kind : ArgsKind, default: `ParamKind.POSITIONAL_OR_KEYWORD`
        The kind of variadic arguments to include in the signature.
        
    __kwds_kind : KwdsKind, default: `ParamKind.KEYWORD_ONLY`
        The kind of keyword arguments to include in the signature.
    
    __zero_idx: bool, default: False
        Whether or not to start from zero when adding dynamic argument names 
        into the signature.
        
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    __args: bool = False
    __kwds: bool = False
    __args_kind: ArgsKind = ParamKind.POSITIONAL_OR_KEYWORD
    __kwds_kind: KwdsKind = ParamKind.KEYWORD_ONLY
    __zero_idx: bool = False
    
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords

# %% ../nbs/00_type.ipynb 33
class MethodOptions(OptionsDict):
    '''Options for updating a `Signature` from a method, chiefly for whether or not
    to include `cls` or the `self` argument in the signature explicitly.
    
    Parameters
    ----------
    __drop_cls : bool, default: False
        Whether or not to drop the `cls` argument from the signature.
        
    __drop_self : bool, default: False
        Whether or not to drop the `self` argument from the signature.
        
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    __drop_cls: bool
    __drop_self: bool
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords
    
class AnnotationSignatureOptions(OptionsDict):
    '''Options for updating a `Signature` from annotations, chiefly for whether or not
    to ensure every parameter has a default value even if that value is `None`.
    
    Parameters
    ----------
    __force_defaults : bool, default: False
        Whether or not to ensure every parameter has a default value.
    '''
    __force_defaults: bool
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords
    
class CallableSignatureOptions(AnnotationSignatureOptions):
    '''Options for updating a `Signature` from a callable, chiefly for whether or not
    to ensure every parameter has a default value even if that value is `None`, in
    addition a way to pass in a default signature.
    
    Parameters
    ----------
    __signature: Signature, optional
        A default signature to use if the callable has no signature.
        
    __force_defaults : bool, default: False
        Whether or not to ensure every parameter has a default value.
        
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    __signature: Signature | None
    __force_defaults: bool
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords

# %% ../nbs/00_type.ipynb 35
class BoundReturnFormat(OptionsDict):
    '''Options for formatting the return value of a `BoundSignature`.
    
    Parameters
    ----------
    __format : ReturnFormat, default: `ReturnFormat.argskwargs`
    __locals_if_empty : bool, default: False
        Whether or not to include the local values of *args / **kwargs 
        if `bound.args` / `bound.kwargs` values are empty.
    '''
    __format: 'ReturnFormat'
    __locals_if_empty: bool
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords

# %% ../nbs/00_type.ipynb 37
class BindOptions(CallableSignatureOptions, MethodOptions, BoundReturnFormat, OptionsDict):
    '''Options for binding `*args` and `**kwargs` to a callable (`fn`).
    
    Parameters
    ----------
    fn: Callable
        The callable to bind `*args` and `**kwargs` to.
    
    *args: P.args
        The variadic arguments to bind to `fn`.
            
    __earg: VArgs, default: ()
        Additional variadic arguments to bind to `fn`. Useful for when used with
        a decorator or different scopes. Note, these will take precedence over `*args`.

    __ekws: dict, default: {}
        Additional keyword arguments to bind to `fn`. Useful for when used with
        a decorator or different scopes. Note, these will take precedence over `**kwargs`.
        
    __oarg: VArgs, default: ()
        The original / outer variadic arguments, if any, to bind to `fn`.
        
    __okws: dict, default: {}
        The original / outer keyword arguments, if any, to bind to `fn`.
        
    __signature: Signature, optional
        A default signature to use if the callable has no signature or is a built-in function.
        
    __force_defaults : bool, default: False
        Whether or not to ensure every parameter has a default value when constructing the signature.
        
    __resolution_order: ResolutionOrder, default: `ResolutionOrder.InnerExtraOuter`
        The order of resolution for the two sets of variadic arguments i.e.
            ResolutionOrder.outer: `(args, varg)`, or 
            ResolutionOrder.inner: `(varg, args)`.
        
    __overwrite_scope: bool, default: True
        Whether or not to overwrite the variadic arguments of one scope with the 
        arguments of another. By default this is true, as this is the expected
        behaviour of positional / optional (position or keyword) arguments.
        Note that in either case, the variadic arguments will be extended to
        match the length of the longest set of variadic arguments e.g. 
        if `a = (a1, a2, a3)` and `b = (b1, b2, b3, b4, b5)`, then the 
        variadic arguments will be `(a1, a2, a3, b4, b5,)`
        
    __drop_cls : bool, default: False
        Whether or not to drop the `cls` argument from the signature.
        
    __drop_self : bool, default: False
        Whether or not to drop the `self` argument from the signature.
        
    __keep_overwritten : bool, default: False
        Whether or not to include overwritten arguments in the signature.
        
    __format : ReturnFormat, default: `ReturnFormat.argskwargs`
        The format to return the bound signature in.
        
    __locals_if_empty : bool, default: False
        Whether or not to include the local values of *args / **kwargs 
        if `bound.args` / `bound.kwargs` values are empty.
    
    **kwargs: P.kwargs
        The keyword arguments to bind to `fn`.
        
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    fn: Callable
    __earg: VArgs
    __ekws: dict
    __oarg: VArgs | None
    __okws: dict | None
    __signature: Signature | None
    __force_defaults: bool
    __resolution_order: 'ResolutionOrder'
    __overwrite_scope: bool  
    __drop_cls: bool
    __drop_self: bool
    __keep_overwritten: bool
    __format: 'BoundFormat'
    __locals_if_empty: bool
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords
    

# %% ../nbs/00_type.ipynb 39
class BindScopes(BindOptions):
    '''Options for binding `*args` and `**kwargs` to a callable (`fn`).
    
    Parameters
    ----------
    fn: Callable
        The callable to bind `*args` and `**kwargs` to.
    
    *inner_args: P.args
    
    extra_args: VArgs, default: ()
    
    extra_kwds: dict, default: {}
    
    outer_args: VArgs, default: ()
    
    outer_kwds: dict, default: {}
    
    **inner_kwds: P.kwargs | BindOptions
        
    Methods
    -------
    opts(cls: Type[T], __pop_keyword: bool = True, __defaults: T | None = None, **kwargs) -> T
        Get the keywords arguments as specified in this `TypedDict`.
        
    prune(cls: Type[T], **kwargs) -> T
        Remove any keywords from the `kwargs` that are in the `TypedDict`.
    '''
    fn: Callable
    extra_args: VArgs
    extra_kwds: dict
    outer_args: VArgs
    outer_kwds: dict
    __signature: Signature | None
    __force_defaults: bool
    __drop_cls: bool
    __drop_self: bool
    __keep_overwritten: bool
    __format: 'BoundFormat'
    __locals_if_empty: bool
    __resolution_order: 'ResolutionOrder'
    __overwrite_scope: bool    
    opts = get_typed_dict_options
    prune = prune_type_dict_keywords
    
