# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_sigs.ipynb.

# %% auto 0
__all__ = ['in_lookup', 'put_var_in_signature', 'signature_from_annotations', 'signature_from_callable', 'get_signature_defaults',
           'signature_from_bound']

# %% ../nbs/05_sigs.ipynb 6
from inspect import (signature, Signature, BoundArguments, Parameter, get_annotations, _ParameterKind as ParamKind)

# %% ../nbs/05_sigs.ipynb 8
from typing import (Callable,)

# %% ../nbs/05_sigs.ipynb 10
#| export


# %% ../nbs/05_sigs.ipynb 12
#| export


# %% ../nbs/05_sigs.ipynb 14
from .type import (AnnotationSignatureOptions, CallableSignatureOptions, ArgsKind, KwdsKind, P, T)
from sigr.grds import (
    isnone, notnone, istype, issig, notempty, isvarg, isvkws, isparam,
    isdict, isoptional, ispsa, ispsk, isenum as _isenum
)
from .cons import (ARGS_KIND, KWDS_KIND, _ARGS, _KWDS, __NAME__, RETURN, ARGS, KWARGS)
from .util import (parameter_defaults, hasvarg, hasvkws, sort_parameters, get_option, init_enum)

# %% ../nbs/05_sigs.ipynb 17
def in_lookup(key: str, ann: T, lookup: dict = {}) -> tuple[T, bool]:
    val = lookup.get(key, None)
    
    # handle ambigious bool values
    try: flag = bool(val)
    except: flag = False
    
    if notnone(val) and flag == True: 
        return val, flag
    
    for use in (val, ann):
        # check if val / ann in keys
        if not flag:
            try: 
                if use in lookup: return lookup.get(use), True
            except: ...
            
        # check if val / ann in values
        if not flag:
            try: 
                vals = list(lookup.values() if isdict(lookup) else lookup)
                if use in vals: return vals[vals.index(use)], True
            except: ...
            
    # check if anns in an instance of flag
    if not flag:
        try: 
            if ann == val: return val, True
        except: ...
        
    # check if val / ann in an instance of val
    if not flag:
        try: 
            if isinstance(ann, val): return val, True
        except: ...
            
    return val, flag

# %% ../nbs/05_sigs.ipynb 21
def put_var_in_signature(
    __signature: Signature,
    __varpos: bool = True,
    __varkws: bool = True,
    __idealorder: list | None = None
) -> Signature:
    sig = __signature
    prms = list(sig.parameters.values())
    ret = sig.return_annotation
    prms = put_var_in_parameters(prms, __varpos, __varkws, __idealorder)
    sig = Signature(prms, return_annotation=ret)
    return sig

# %% ../nbs/05_sigs.ipynb 23
def signature_from_annotations(
    __dct: T,
    *, 
    __force_defaults: bool = False, 
    __varpos: bool = True,
    __varkws: bool = True,
    __return_annot: type | None = None,
    __rescue_values: dict | None = dict(),
    __ignore_values: dict | None = dict(),
    __use_optionals: bool = True,
    **kwargs: P.kwargs
) -> Signature:
    '''Generate a function signature based on annotations and optionally specified defaults.
    
    Parameters
    ----------
    fn : Callable
        The function to analyze.
        
    __force_defaults : bool, default: False
        Whether or not to force defaults, which includes setting `None` 
        for optional parameters.
        
    __varpos: bool, default: True
        Whether or not to include `*args` if not found in the annotations.

    __varkws: bool: default True
        Whether or not to include `**kwargs` if not found in the annotations.
        
    __return_annot: type, optional
        The type for the return value, which might not be specified in the 
        extracted annotaitons.
        
    __rescue_values: dict, optional
        The type or default value ot use if the attempt to initiate a default
        value from the type annotation fails.
        
    __ignore_values: dict, optional
        The parameter name or types to ignore when attempting to initiate a
        default value from the type annotation.
        
    __use_optionals : bool, default: True
        Whether or not to include optional parameters in the signature.
        
    **kwargs : P.kwargs
        Additional options to control the signature generation. These can include
        specific default values for some or all of the annotated parameters.
    
    Returns
    -------
    Signature
        A `Signature` object representing the generated signature for the function.
        
    See Also
    --------
    sigr.signature_from_annotations : Generate a function signature based on annotations.
    '''
    __return = kwargs.get('__return_annot', __return_annot)
    __ignore = kwargs.get('__ignore_values', __ignore_values or {})
    __rescue = kwargs.get('__rescue_values', __rescue_values or {})
    __useopt = kwargs.get('__use_optionals', __use_optionals)
    __force_defaults = kwargs.get('__force_defaults', __force_defaults)
    
    if not isdict(__ignore): {getattr(v, __NAME__, v): v for v in __ignore}
    if not isdict(__rescue): {getattr(v, __NAME__, v): v for v in __rescue}
    
    
    anns = get_annotations(__dct)
    return_annotation = __return or anns.pop(RETURN, __return if notnone(__return) else None)
    kwds, prms = list(anns.keys()), list()
    
    for kwd, ann in zip(kwds, anns.values()):
        opt = get_option(ann)
        isopt = isoptional(ann)
        useopt = isopt and __useopt
        isenum = _isenum(opt if useopt else ann)
        
        val = kwargs.get(kwd, None)
        err = False
        
        typ = opt if useopt else ann
        ign, ignore_ok = in_lookup(kwd, typ, __ignore)
        res, rescue_ok = in_lookup(kwd, typ, __rescue)
     
        if isnone(val) and (istype(ann) or isopt) and not ignore_ok:
            try: # try to instantiate the annotation 
                val = ann()
            except: # if it fails, set the default value to None
                err = True
                val = None
                
            if useopt: # Optional paramter, use the first not None type to try and initalize an default value
                try: # try to instantiate the annotation 
                    err = False
                    val = opt()
                except: # if it fails, set the default value to None
                    err = True
                    val = None
                    
            # Maybe we failed gracefully, but that was because we were working with
            # an enum type, so try a special init stragety
            if isenum and isnone(val): 
                try:
                    err = False 
                    val = init_enum(opt if isopt else ann)
                except: 
                    err = True
                    val = None
        
        
        if rescue_ok and isnone(val):
            val = res
        
        pkind = Parameter.POSITIONAL_OR_KEYWORD
        
        # if not isopt and isnone(val):
        #     pkind = Parameter.POSITIONAL_ONLY
        
        # if isopt and isnone(val):
        #     pkind = Parameter.KEYWORD_ONLY
            
        
        # variadic_args need `P.args` like type annotation to get here
        if kwd == ARGS and __varpos and (ispsa(ann) or isnone(ann)): 
            pkind = Parameter.VAR_POSITIONAL
            
        # variadic_kwargs need `P.kwargs` like type annotation to get here
        if kwd == KWARGS and __varkws and (ispsk(ann) or isnone(ann)): 
            pkind = Parameter.VAR_KEYWORD
        
        prm = Parameter(kwd, kind=pkind, annotation=ann)
        
        
        # booleans
        optnone = isopt and isnone(val) # None is ok if it is an Optional value
        badkind = (pkind in (Parameter.VAR_POSITIONAL,) ) # can't have defaults
        goodval = notnone(val) or not err # we have a default value or there was no error in trying to initiate the annotation
        if (            
            (goodval or (__force_defaults and isnone(val))) or  # we are going to force the default value   
            optnone and not badkind
        ):  
            prm = prm.replace(default=val)
            
        prms.append(prm)
        
    prms = put_var_in_parameters(prms, __varpos, __varkws, __idealorder=kwds)
    sig = Signature(prms, return_annotation=return_annotation)
    return sig

# %% ../nbs/05_sigs.ipynb 25
def signature_from_callable(
    fn: Callable, *,
    __signature: Signature | None = None,
    __force_defaults: bool = False,
    __varpos: bool = True,
    __varkws: bool = True,
    **kwargs: CallableSignatureOptions
) -> Signature:
    '''Generate a function signature from a callable, with options to enforce defaults.
    
    Parameters
    ----------
    fn : Callable
        The callable to generate a signature for.
        
    __signature : Signature, optional
        A pre-existing signature to use instead of generating a new one.
        
    __force_defaults : bool, default: False
        Force the inclusion of default values in the generated signature.
        
    **kwargs : CallableSignatureOptions
        Additional options that can influence signature generation.
    
    Returns
    -------
    Signature
        A `Signature` object for the callable.
    
    Notes
    -----
    This function first attempts to retrieve the signature of the callable directly.
    If that fails (e.g., for built-in functions), it falls back to generating a
    signature based on annotations or provided defaults.
    
    Examples
    --------
    >>> def example_func(a, b=2):
    ...     return a + b
    >>> signature_from_callable(example_func)
    <Signature (a, b=2)>
    '''
    __signature = kwargs.get('__signature', __signature)
    __force_defaults = kwargs.get('__force_defaults', __force_defaults)
    __varpos = kwargs.get('__varpos', __varpos)
    __varkws = kwargs.get('__varkws', __varkws)
    try: return signature(fn); # Try to get the signature of the function
    except ValueError: ...     # Handle built-in functions
    if issig(__signature): 
        return __signature     # Use default signature if provided
    try: 
        return signature_from_annotations(
        fn, 
        __force_defaults=__force_defaults, 
        __varpos=__varpos, 
        __varkws=__varkws, 
        **kwargs
    )
    except: 
        return put_var_in_signature(Signature([]), __varpos, __varkws)

# %% ../nbs/05_sigs.ipynb 27
def get_signature_defaults(
    fn: Callable, 
    *, 
    __signature: Signature | None = None, 
    __force_defaults: bool = False,
    __drop_nones: bool = True,
    __varpos: bool = True,
    __varkws: bool = True,
    **kwargs: CallableSignatureOptions
) -> dict:
    '''
    Retrieve the default values from a function's signature, with customization options.
    
    Parameters
    ----------
    fn : Callable
        The function to analyze.
        
    __signature : Signature, optional
        A specific signature to use, bypassing automatic generation.
        
    __force_defaults : bool, default: False
        If True, ensures all parameters are included, even if they have no defaults.

    __drop_nones : bool, default: True
        If True, parameters with a default value of None are omitted from the result.
        
    **kwargs : CallableSignatureOptions
        Additional options for default value handling and signature customization.
    
    Returns
    -------
    dict
        A dictionary mapping parameter names to their default values.
    '''
    __varpos = kwargs.get('__varpos', __varpos)
    __varkws = kwargs.get('__varkws', __varkws)
    sig = signature_from_callable(
        fn, __signature=__signature, __force_defaults=__force_defaults, 
        __varpos=__varpos, __varkws=__varkws, **kwargs
    )
    # get the defaults from the signature
    defaults = parameter_defaults(sig)
    
    # update the defaults with the kwargs
    defaults.update({k:v for k,v in kwargs.items() if k in defaults})
    if not __drop_nones: defaults = {k:v for k,v in defaults.items() if not isnone(v)}
    return defaults

# %% ../nbs/05_sigs.ipynb 29
def signature_from_bound(
    bound: BoundArguments, 
    __args: bool = False,
    __kwds: bool = False,
    __args_kind: ArgsKind = ParamKind.POSITIONAL_OR_KEYWORD,
    __kwds_kind: KwdsKind = ParamKind.KEYWORD_ONLY,
    __zero_idx: bool = False
) -> Signature:
    '''Constructs a function signature from bound arguments with customization options.
    
    Parameters
    ----------
    bound : BoundArguments
        The bound arguments object from which to construct the signature.
        
    __args : bool, default: False
        Include positional arguments in the signature.
        
    __kwds : bool, default: False
        Include keyword arguments in the signature.
        
    __args_kind : ArgsKind, default: ParamKind.POSITIONAL_OR_KEYWORD
        The kind of parameter to use for positional arguments.
        
    __kwds_kind : KwdsKind, default: ParamKind.KEYWORD_ONLY
        The kind of parameter to use for keyword arguments.
        
    __zero_idx : bool, default: False
        Start indexing positional arguments from zero.
    
    Returns
    -------
    Signature
        The constructed signature that reflects the binding of arguments.
    '''
    if __args_kind not in ARGS_KIND: __args_kind = ParamKind.POSITIONAL_OR_KEYWORD
    if __kwds_kind not in KWDS_KIND: __kwds_kind = ParamKind.KEYWORD_ONLY
        
    params: dict[str, Parameter] = {}
    argidx, kwsidx = -1, -1
    for i, (a, p) in enumerate(bound.signature.parameters.items()):
        val = bound.arguments.get(a, p)
        
        if p.kind in (Parameter.VAR_POSITIONAL, Parameter.VAR_KEYWORD): 
            params[a] = p.replace()
            if isvarg(p): argidx = i
            if isvkws(p): kwsidx = i
            continue

        if isparam(val): 
            if notempty(val.default): 
                val = val.default
            else: 
                val = None
            
        p = p.replace(default=val, annotation=type(val))
        params[a] = p
        
    args: dict[str, Parameter] = {}
    for a, v in enumerate(bound.arguments.get('args', tuple())):
        kind = 'optional' if __args_kind == ParamKind.POSITIONAL_OR_KEYWORD else 'positional'
        name = f'{kind}_{a + (0 if __zero_idx else 1)}'
        p = Parameter(name=name, kind=__args_kind, default=v, annotation=type(v))
        args[a] = p
        
    kwargs: dict[str, Parameter] = {}
    for a, v in bound.arguments.get('kwargs', dict()).items():
        p = Parameter(name=a, kind=__kwds_kind, default=v, annotation=type(v))
        kwargs[a] = p
       
    result: dict[str, Parameter] = params.copy()
    hasarg = argidx > -1 and __args
    haskws = kwsidx > -1 and __kwds
    if hasarg or haskws:
        result = {}
        for i, (a, p) in enumerate(params.items()):
            if i == argidx and __args:
                for k, v in args.items():
                    result[k] = v
            if i == kwsidx and __kwds:
                for k, v in kwargs.items():
                    result[k] = v
            result[a] = p
           
    bsig = bound.signature.replace(parameters=result.values())
    return bsig
