# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_grds.ipynb.

# %% auto 0
__all__ = ['issig', 'isnone', 'isbool', 'isdict', 'isenum', 'istype', 'istuple', 'isparam', 'isempty', 'notnone', 'notempty',
           'isvpos', 'isvpok', 'isvarg', 'isvkws', 'isvkwo', 'ispsa', 'ispsk', 'isemptyparam', 'iscallattr',
           'isoptional']

# %% ../nbs/03_grds.ipynb 6
from inspect import (Signature, Parameter, _empty)
from enum import EnumMeta

# %% ../nbs/03_grds.ipynb 8
from types import NoneType
from typing import (Any, TypeGuard, Callable, ParamSpecArgs, ParamSpecKwargs, get_args, _UnionGenericAlias)

# %% ../nbs/03_grds.ipynb 10
#| export


# %% ../nbs/03_grds.ipynb 12
#| export


# %% ../nbs/03_grds.ipynb 14
from .type import T

# %% ../nbs/03_grds.ipynb 16
def issig(x) -> TypeGuard[Signature]:
    '''Check if `x` is a `Signature`'''
    return isinstance(x, Signature)

def isnone(x) -> TypeGuard[None]:
    '''Check if `x` is `None`'''
    return x is None

def isbool(x) -> TypeGuard[bool]:
    '''Check if `x` is a `bool`'''
    return isinstance(x, bool)

def isdict(x) -> TypeGuard[dict]:
    '''Check if `x` is a `dict`'''
    return isinstance(x, dict)

def isenum(x) -> TypeGuard[EnumMeta]:
    "Check if `x` is an `Enum` type"
    return isinstance(x, EnumMeta)

def istype(x) -> TypeGuard[type]:
    '''Check if `x` is a `type`'''
    return isinstance(x, type)

def istuple(x) -> TypeGuard[tuple]:
    '''Check if `x` is a `tuple`'''
    return isinstance(x, tuple)

def isparam(x) -> TypeGuard[Parameter]:
    '''Check if `x` is a `Parameter`'''
    return isinstance(x, Parameter)

def isempty(x) -> TypeGuard[_empty]:
    '''Check if `x` is a `Parameter._empty`'''
    return x is _empty or (isparam(x) and x.default is _empty)

def notnone(x) -> TypeGuard[Any]:
    '''Check if `x` is not `None`'''
    return not isnone(x)

def notempty(x) -> TypeGuard[Any]:
    '''Check if `x` is not `Parameter._empty`'''
    return not isempty(x)

def isvpos(x) -> TypeGuard[Parameter.POSITIONAL_ONLY]:
    '''Check if `x` is a parameter of `Parameter.POSITIONAL_ONLY` kind.'''
    return isparam(x) and x.kind == Parameter.POSITIONAL_ONLY

def isvpok(x) -> TypeGuard[Parameter.POSITIONAL_OR_KEYWORD]:
    '''Check if `x` is a parameter of `Parameter.POSITIONAL_OR_KEYWORD` kind.'''
    return isparam(x) and x.kind == Parameter.POSITIONAL_OR_KEYWORD

def isvarg(x) -> TypeGuard[Parameter.VAR_POSITIONAL]:
    '''Check if `x` is a parameter of `Parameter.VAR_POSITIONAL` kind.'''
    return isparam(x) and x.kind == Parameter.VAR_POSITIONAL

def isvkws(x) -> TypeGuard[Parameter.VAR_KEYWORD]:
    '''Check if `x` is a parameter of `Parameter.VAR_KEYWORD` kind.'''
    return isparam(x) and x.kind == Parameter.VAR_KEYWORD

def isvkwo(x) -> TypeGuard[Parameter.KEYWORD_ONLY]:
    '''Check if `x` is a parameter of `Parameter.KEYWORD_ONLY` kind.'''
    return isparam(x) and x.kind == Parameter.KEYWORD_ONLY

def ispsa(x) -> TypeGuard[ParamSpecArgs]:
    '''Check if `x` is an instance of `ParamSpecArgs` i.e. `P.args`'''
    return isinstance(x, ParamSpecArgs)

def ispsk(x) -> TypeGuard[ParamSpecKwargs]:
    '''Check if `x` is an instance of `ParamSpecKwargs` i.e. `P.kwargs`'''
    return isinstance(x, ParamSpecKwargs)

def isemptyparam(x) -> TypeGuard[Parameter]:
    '''Check if `x` is a `Parameter` and that it's default value is `Parameter._empty`'''
    return isparam(x) and isempty(x.default)

def iscallattr(obj, attr: str) -> TypeGuard[Callable]: 
    return callable(getattr(obj, attr, None))

def isoptional(x) -> TypeGuard[T | None]:
    "Check if `x` is an optional type"
    isname = getattr(x, '__name__', None) == 'Optional'
    isgenr = isinstance(x, _UnionGenericAlias)
    args = get_args(x)
    isnone = False if not len(args) else args[-1] == NoneType
    return isname and isgenr and isnone
