# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/07_deco.ipynb.

# %% auto 0
__all__ = ['setsignature', 'setsig', 'setpartial', 'bindsome', 'callwith', 'decowith']

# %% ../nbs/07_deco.ipynb 6
from inspect import (currentframe, getargvalues)
from functools import wraps
# from deprecated import deprecated

# %% ../nbs/07_deco.ipynb 8
from typing import (Any, Callable,)

# %% ../nbs/07_deco.ipynb 10
#| export


# %% ../nbs/07_deco.ipynb 12
#| export


# %% ../nbs/07_deco.ipynb 14
from .type import (P, BoundSignatureOptions, DecoReturn, BindOptions, BindScopes)
from .enum import (ResolutionOrder, BoundFormat, DecoratedFormat, Direction)
from .cons import (_BSO, _BSO_DEFAULTS)
from .util import (join, decorated_format, resolve_args, resolve_kwargs)
from .sigs import (signature_from_bound, )
from .bnds import (bind, bind_scopes)

# %% ../nbs/07_deco.ipynb 16
def setsignature(
    fn: Callable | None = None, 
    /,
    *args: P.args,
    
    # BoundSignatureOptions
    __bso: BoundSignatureOptions | None = _BSO,
    __bso_defaults: BoundSignatureOptions | None = _BSO_DEFAULTS,
    
    # DecoratedFormat
    __return: DecoratedFormat = DecoratedFormat.decorated,
    
    # BindOptions
    __resolution_order: ResolutionOrder = ResolutionOrder.InnerExtraOuter,
    ____print: bool = False,
    **kwargs: P.kwargs
) -> DecoReturn:
    '''Dynamically sets the signature of a function based on provided arguments and binding options.

    Parameters
    ----------
    fn : Callable | None, optional
        The function to decorate and modify its signature. If None, a decorator is returned.
        
    *args : P.args
        Positional arguments for the function.
        
    __bso : BoundSignatureOptions, optional
        Options for how the signature should be bound.
        
    __bso_defaults : BoundSignatureOptions, optional
        Default binding options.
        
    __return : DecoratedFormat, default: DecoratedFormat.decorated
        Format of the returned decorator.
        
    __resolution_order : ResolutionOrder, default: ResolutionOrder.InnerExtraOuter
        Specifies the order of resolution for binding arguments.
        
    **kwargs : P.kwargs
        Keyword arguments for the function.

    Returns
    -------
    DecoReturn
        A decorated function with the newly set signature or a decorator capable of setting the signature.

    '''
    # Step: configure the signature options
    __bso: BoundSignatureOptions = __bso or {}
    __bso.update(BoundSignatureOptions.opts(__pop_keyword=True, __defaults=__bso_defaults, **kwargs))
    
    # Step: configure outer-scope arguments and keywords passed in from  the `setsignature` function call. 
    oarg, okws = args, kwargs
    okws = BoundSignatureOptions.prune(**okws)
    
    obnd: BindOptions = BindOptions.opts(**okws)
    okws: dict = BindOptions.prune(**okws)
    ofnc = fn
    if ____print: print('Outer Scope (arg, kws, bnd)', oarg, okws, obnd, sep='\n')
    
    # Step: decorate the function
    def decorator(fn: Callable) -> Callable[P, Any]:
        ifnc = fn
        func = ofnc or ifnc
        
        # Step: configure the binding parameters
        bkws = dict(__oarg=oarg, __okws=okws, __resolution_order=__resolution_order)
        bkws = BindOptions.opts(**obnd, **bkws)
        bkws.update(dict(__format=BoundFormat.bound,))
        
        # Step: bind the function with the outer arguments and keywords    
        bnd = bind(func, **bkws)
        if ____print: print('Decorator Scope (bkws, bnd)', bkws, bnd, sep='\n')
        
        # Step: create the signature from the bound arguments
        bsig = signature_from_bound(bnd, **__bso)
    
        # Step: create the wrapper function
        @wraps(func)
        def wrapper(*args, **kwargs):
            # Step: bind the inner arguments and keywords
            iarg, ikws = args, kwargs
            
            ibnd = BindOptions.opts(**ikws)
            ikws = BindOptions.prune(**ikws)
            
            bkws = dict(__oarg=oarg, __okws=okws, __resolution_order=__resolution_order)
            bkws = BindOptions.opts(**obnd, **bkws)
            
            ovarg, ivarg = obnd.get('__earg', ()), ibnd.get('__earg', ())
            ovkws, ivkws = obnd.get('__ekws', {}), ibnd.get('__ekws', {})
            
            earg = resolve_args(ovarg, ivarg, None, __resolution_order)
            ekws = resolve_kwargs(ovkws, ivkws, None, __resolution_order, Direction.rl)
            edct = dict(__earg=earg, __ekws=ekws)
            
            bkws = BindOptions.opts(**{**bkws, **ibnd, **edct})
            bkws.update(dict(__format=BoundFormat.argskwargs,))
            
            
            if ____print: print('Inner Scope Arguments (iarg, oarg, earg)', iarg, oarg, earg, sep='\n')
            if ____print: print('Inner Scope Keywords (ikws, okws, ekws)', ikws, okws, ekws, sep='\n')
            if ____print: print('Inner Scope BoundKeywords', bkws, sep='\n')
            ba, bk = bind(func, *iarg, **bkws, **ikws)
            
            return func(*ba, **bk)
        
        name = getattr(ifnc, '__name__', getattr(ofnc, '__name__', ''))
        qual = getattr(ifnc, '__qualname__', getattr(ofnc, '__qualname__', ''))
        
        setattr(wrapper, '__signature__', bsig)
        setattr(wrapper, '__name__', name)
        setattr(wrapper, '__qualname__', qual)
        return wrapper
    return decorated_format(decorator, fn, *args, __format=__return, **kwargs)

# %% ../nbs/07_deco.ipynb 18
@wraps(setsignature)
def setsig(*args, **kwargs):
    '''A convenience wrapper around `setsignature` for easier usage.

    Parameters
    ----------
    *args : P.args
        Positional arguments to be passed to `setsignature`.
        
    **kwargs : P.kwargs
        Keyword arguments to be passed to `setsignature`.

    Returns
    -------
    Callable
        A callable returned from `setsignature`, either a decorated function or a decorator.

    Notes
    -----
    This function serves as a shortcut to `setsignature`, providing a simpler interface for common use cases.
    '''
    return setsignature(*args, **kwargs)

# %% ../nbs/07_deco.ipynb 42
def setpartial(fn: Callable | None = None, /, *args: P.args, **kwargs: P.kwargs) -> Callable[P, Any]:
    '''Creates a partial function application that also sets the signature based on provided arguments.

    Parameters
    ----------
    fn : Callable | None, optional
        The function to partially apply arguments to. If None, a decorator is returned.
        
    *args : P.args
        Positional arguments to partially apply.
        
    **kwargs : P.kwargs
        Keyword arguments to partially apply.

    Returns
    -------
    Callable
        A partially applied function with its signature dynamically set.
    '''
    __return: DecoratedFormat = DecoratedFormat.decorator
    __resolution_order: ResolutionOrder = ResolutionOrder.InnerExtraOuter
    kwargs.update(__return=__return, __resolution_order=__resolution_order)
    return setsignature(fn, *args, **kwargs)

# %% ../nbs/07_deco.ipynb 44
@wraps(setpartial)
def bindsome(*args, **kwargs) -> Callable[P, Any]:
    '''A convenience wrapper around `setpartial` for easier usage.

    Parameters
    ----------
    *args : P.args
        Positional arguments to be passed to `setpartial`.
    **kwargs : P.kwargs
        Keyword arguments to be passed to `setpartial`.

    Returns
    -------
    Callable
        A callable returned from `setpartial`, a partially applied function with a set signature.
    '''
    return setpartial(*args, **kwargs)

# %% ../nbs/07_deco.ipynb 49
def _callwith(
    fn: Callable | None = None, /, *args: P.args, 
    __return: DecoratedFormat = DecoratedFormat.called,
    __resolution_order: ResolutionOrder = ResolutionOrder.ExtraInnerOuter,
    **kwargs: P.kwargs
) -> Callable[P, Any]:
    kwargs.update(__return=__return, __resolution_order=__resolution_order)
    return setsignature(fn, *args, **kwargs)

# %% ../nbs/07_deco.ipynb 50
def callwith(fn: Callable | None = None, /, *args: P.args, **kwargs: P.kwargs) -> Callable[P, Any]:
   return _callwith(fn, *args, **kwargs)

# %% ../nbs/07_deco.ipynb 55
def _decowith(
    fn: Callable | None = None, /, *args: P.args, 
    __return: DecoratedFormat = DecoratedFormat.decorator,
    __resolution_order: ResolutionOrder = ResolutionOrder.InnerExtraOuter,
    **kwargs: P.kwargs
) -> Callable[P, Any]:    
    kwargs.update(__return=__return, __resolution_order=__resolution_order)
    return setsignature(fn, *args, **kwargs)

# %% ../nbs/07_deco.ipynb 56
def decowith(fn: Callable | None = None, /, *args: P.args, **kwargs: P.kwargs) -> Callable[P, Any]:
    return _decowith(fn, *args, **kwargs)
