# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_bnds.ipynb.

# %% auto 0
__all__ = ['bind_safe', 'bind_scopes_explicitly', 'bind_scopes', 'bind']

# %% ../nbs/06_bnds.ipynb 6
from inspect import (Signature, BoundArguments)
from functools import partial

# %% ../nbs/06_bnds.ipynb 8
from typing import (Callable)

# %% ../nbs/06_bnds.ipynb 10
#| export


# %% ../nbs/06_bnds.ipynb 12
#| export


# %% ../nbs/06_bnds.ipynb 14
from .type import (P, VArgs, BoundReturn, FoundArgument, BindOptions, BindScopes)
from .enum import (BoundFormat, ResolutionOrder)
from .cons import _extra_args, _extra_kwds, _outer_args, _outer_kwds, _bind_opts
from sigr.util import (
    unbound_args, bind_unbound_args, handle_bound_methods, handle_bound_variadic, 
    unbound_kwargs, bind_unbound_kwargs, bound_arguments_format,
    resolve_args, resolve_kwargs, get_mangled_keywords, overload_keyword
)
from .sigs import (signature_from_callable, )

# %% ../nbs/06_bnds.ipynb 17
def bind_safe(
    fn: Callable, 
    *args: P.args, 
    __earg: VArgs = (),
    __ekws: dict = {},
    __oarg: VArgs | None = (),
    __okws: dict | None = {},
    __signature: Signature | None = None, 
    __force_defaults: bool = False,
    __resolution_order: ResolutionOrder = ResolutionOrder.InnerExtraOuter,
    __overwrite_scope: bool = True,
    __drop_cls: bool = True,
    __drop_self: bool = True,
    __keep_overwritten: bool = False,
    __format: BoundFormat = BoundFormat.argskwargs,
    __locals_if_empty: bool = False,
    **kwargs: P.kwargs,
) -> BoundReturn:
    '''
    Bind arguments to the parameters of a callable with enhanced flexibility.

    This function extends the capabilities of the standard binding process to
    support scenarios including partial bindings, default handling, method
    signatures, argument resolution orders, and more.

    Parameters
    ----------
    fn : Callable
        The target function to bind arguments to.
        
    *args : P.args
        Positional arguments to bind to `fn`.
        
    __earg : VArgs, optional
        Additional variadic positional arguments.
        
    __ekws : dict, optional
        Additional variadic keyword arguments.
        
    __oarg : VArgs, optional
        Outer scope positional arguments.
        
    __okws : dict, optional
        Outer scope keyword arguments.
        
    __signature : Signature, optional
        An explicit `Signature` object to use instead of introspecting `fn`.
        
    __force_defaults : bool, default: False
        Force the use of default values for unbound parameters.
        
    __drop_cls : bool, default: True
        Drop the `cls` parameter if `fn` is a class method.
        
    __drop_self : bool, default: True
        Drop the `self` parameter if `fn` is an instance method.
        
    __include_overwritten_args : bool, default: False
        Include arguments that were overwritten by keyword arguments.
        
    __format : BoundFormat, default: BoundFormat.argskwargs
        The format to return the bound arguments in.
        
    __locals_if_empty : bool, default: False
        Use local variables for missing arguments if true.
        
    __resolution_order : ResolutionOrder, default: ResolutionOrder.InnerExtraOuter
        The order to resolve conflicting arguments.
        
    __overwrite_scope : bool, default: True
        Overwrite arguments with those from a different scope if true.
        
    **kwargs : P.kwargs
        Keyword arguments to bind to `fn`.

    Returns
    -------
    BoundReturn
        The result of the binding process, formatted according to `__format`.
        
    See Also
    --------
    bind_scopes : A function that wraps around `bind` for handling arguments
                  across different scopes.
    '''
    # get the predefined arguments and keyword arguments from the positional arguments
    __earg, __ekws = __earg or (), __ekws or {}
    # print('bind_safe (__earg, __ekws, __oarg, __okws)', __earg, __ekws, __oarg, __okws, sep='\n')
    
    
    # get the predefined signature from the keyword arguments
    vsig = __ekws.pop('__signature', None)
    
    sig = signature_from_callable(fn, __signature=(__signature or vsig), __force_defaults=__force_defaults, **kwargs)
    
    # Bind the arguments to the function's parameters    
    bound: BoundArguments = sig.bind_partial()
    bound.apply_defaults()
    # Get the conventional names for variadic arguments and keyword arguments 
    # from the signature if it was defined that way i.e. function has something 
    # other than `*args` and `**kwargs`
    carg, ckws = bound.arguments.get('args', ()), bound.arguments.get('kwargs', dict())
    
    # bind this functions called variadic arguments with the names of the
    # parameters in the signature. if the additional variadic arguments are 
    # not empty, then overwrite the values of the original parameters
    vals = resolve_args(__oarg, args, __earg, __resolution_order, __overwrite=__overwrite_scope)
    
    
    # keep track of the found parameters and their values
    used, rest = unbound_args(bound, vals)
    bound = bind_unbound_args(bound, used, rest)
    
    # bind this functions called keyword arguments and the additional variadic 
    # keyword arguments to the parameters
    vkwds = resolve_kwargs(__okws, kwargs, __ekws, __resolution_order)
    
    bound.arguments.update(vkwds)
    
    # find which *args were overwritten by the keywords
    overw: tuple[FoundArgument, ...] = tuple(p for p in used if p['key'] in vkwds)
    # remove the `cls` and `self` paramters if the function is a method
    bound = handle_bound_methods(bound, __function=fn, __drop_cls=__drop_cls, __drop_self=__drop_self)
    # if the original variadic arguments are not a tuple, restore the original
    bound = handle_bound_variadic(bound, fallback_args=carg, fallback_kwds=ckws)
    unbnd = unbound_kwargs(bound)
    if __keep_overwritten: unbnd = dict(**unbnd, __overwritten=overw)
    bound = bind_unbound_kwargs(bound, unbnd)
    return bound_arguments_format(bound, *args, __format=__format, __locals_if_empty=__locals_if_empty, **kwargs)

# %% ../nbs/06_bnds.ipynb 20
ol_extra_args = overload_keyword('extra_args', *_extra_args)
ol_extra_kwds = overload_keyword('extra_kwds', *_extra_kwds)
ol_outer_args = overload_keyword('outer_args', *_outer_args)
ol_outer_kwds = overload_keyword('outer_kwds', *_outer_kwds)

ol_earg = overload_keyword('earg', *_extra_args)
ol_ekws = overload_keyword('ekws', *_extra_kwds)
ol_oarg = overload_keyword('oarg', *_outer_args)
ol_okws = overload_keyword('okws', *_outer_kwds)


ol_varg = overload_keyword('varg', *_extra_args)
ol_vkws = overload_keyword('vkws', *_extra_kwds)

ol_opts = overload_keyword('__opts', *_bind_opts)

# %% ../nbs/06_bnds.ipynb 25
@ol_extra_args
@ol_extra_kwds
@ol_outer_args
@ol_outer_kwds
def _bind_scopes_explicitly(
    fn: Callable, 
    *inner_args: P.args, 
    extra_args: VArgs = (),
    extra_kwds: dict = {},
    outer_args: VArgs | None = (),
    outer_kwds: dict | None = {},
    **inner_kwds: P.kwargs,
) -> BoundReturn:
    options, inner_kwds = get_mangled_keywords(**inner_kwds)
    earg, ekws = options.pop('__earg', extra_args), options.pop('__ekws', extra_kwds)
    oarg, okws = options.pop('__oarg', outer_args), options.pop('__okws', outer_kwds)
    scopes = dict(__earg=earg, __ekws=ekws, __oarg=oarg, __okws=okws)
    return bind_safe(fn, *inner_args, **scopes, **options, **inner_kwds)

# %% ../nbs/06_bnds.ipynb 26
def bind_scopes_explicitly(
    fn: Callable, 
    *inner_args: P.args, 
    extra_args: VArgs = (),
    extra_kwds: dict = {},
    outer_args: VArgs | None = (),
    outer_kwds: dict | None = {},
    **inner_kwds: P.kwargs,
) -> BoundReturn:
    '''
    Bind arguments to the parameters of a callable with enhanced flexibility.

    This function extends the capabilities of the standard binding process to
    support scenarios including partial bindings, default handling, method
    signatures, argument resolution orders, and more.

    Parameters
    ----------
    fn : Callable
        The target function to bind arguments to.
        
    *inner_args : P.args
        Inner scope positional arguments to bind to `fn`.
        
    extra_args : VArgs, optional
        Extra variadic positional arguments to bind to `fn`.
        
    extra_kwds : dict, optional
        Extra variadic keyword arguments to bind to `fn`.
        
    outer_args : VArgs, optional
        Outer scope positional arguments to bind to `fn`.
        
    outer_kwds : dict, optional
        Outer scope keyword arguments to bind to `fn`.
        
    **inner_kwds : P.kwargs | BindOptions
        Inner scope keyword arguments to bind to `fn`.

    Returns
    -------
    BoundReturn
        The result of the binding process, formatted according to `__format`.
    '''
    pn = partial(_bind_scopes_explicitly, fn, extra_args=extra_args, extra_kwds=extra_kwds, outer_args=outer_args, outer_kwds=outer_kwds)
    return pn(*inner_args, **inner_kwds)

# %% ../nbs/06_bnds.ipynb 29
@ol_earg
@ol_ekws
@ol_oarg
@ol_okws
def _bind_scopes(
    fn: Callable, 
    *iarg: P.args, 
    earg: VArgs = (),
    ekws: dict = {},
    oarg: VArgs | None = (),
    okws: dict | None = {},
    **ikws: P.kwargs,
) -> BoundReturn:
    opts, ikws = get_mangled_keywords(**ikws)
    earg, ekws = opts.pop('__earg', earg), opts.pop('__ekws', ekws)
    oarg, okws = opts.pop('__oarg', oarg), opts.pop('__okws', okws)
    scopes = dict(__earg=earg, __ekws=ekws, __oarg=oarg, __okws=okws)
    # print('bind_scopes (scopes, opts, kwds)', scopes, opts, ikws, sep='\n')
    return bind_safe(fn, *iarg, **opts, **scopes, **ikws)

# %% ../nbs/06_bnds.ipynb 30
def bind_scopes(
    fn: Callable, 
    *iarg: P.args, 
    earg: VArgs = (),
    ekws: dict = {},
    oarg: VArgs | None = (),
    okws: dict | None = {},
    **ikws: P.kwargs,
) -> BoundReturn:
    pn = partial(_bind_scopes, fn, earg=earg, ekws=ekws, oarg=oarg, okws=okws)
    return pn(*iarg, **ikws)

# %% ../nbs/06_bnds.ipynb 33
@ol_varg
@ol_vkws
@ol_oarg
@ol_okws
@ol_opts
def _bind(
    fn: Callable, 
    *args: P.args, 
    varg: VArgs = (),
    vkws: dict = {},
    __opts: dict | None = {},
    **kwargs: P.kwargs,
) -> BoundReturn:
    opts, kwds = get_mangled_keywords(**kwargs, **(__opts or {}))
    earg, ekws = opts.pop('__earg', varg), opts.pop('__ekws', vkws)
    oarg, okws = opts.pop('__oarg', ()), opts.pop('__okws', {})
    scopes = dict(earg=earg, ekws=ekws, oarg=oarg, okws=okws)
    # print('bind (scopes, opts, kwds)', scopes, opts, kwds, sep='\n')
    return bind_scopes(fn, *args, **scopes, **opts, **kwds)

# %% ../nbs/06_bnds.ipynb 34
def bind(
    fn: Callable, 
    *args: P.args, 
    varg: VArgs = (), 
    vkws: dict = {}, 
    __opts: dict | None = {}, 
    **kwargs: P.kwargs
) -> BoundReturn:
    pn = partial(_bind, fn, varg=varg, vkws=vkws, __opts=__opts)
    return pn(*args, **kwargs)
