# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/08_attr.ipynb.

# %% auto 0
__all__ = ['callattr', 'attrfunc', 'applyfns']

# %% ../nbs/08_attr.ipynb 6
from inspect import (currentframe, getargvalues)
from functools import wraps
# from deprecated import deprecated

# %% ../nbs/08_attr.ipynb 8
from typing import (Any, Callable, Sequence, TypeGuard)

# %% ../nbs/08_attr.ipynb 10
#| export


# %% ../nbs/08_attr.ipynb 12
#| export


# %% ../nbs/08_attr.ipynb 14
from .type import (P, VArgs)
from .grds import isnone, iscallattr
from .util import passthrough
from .deco import callwith, decowith, setsignature
from .enum import DecoratedFormat, ResolutionOrder

# %% ../nbs/08_attr.ipynb 17
def callattr(obj, attr: str, *args: P.args, **kwargs: P.kwargs): 
    try:
        if not iscallattr(obj, attr): return obj
        if isnone(f := getattr(obj, attr, None)): return obj
        return callwith(f, *args, **kwargs)
    except Exception: return obj

# %% ../nbs/08_attr.ipynb 19
def attrfunc(attr: str, *args: P.args, **kwargs: P.kwargs):
    def decorator(fn: Callable):
        name = fn.__name__ if callable(fn) and isnone(attr) else attr
        @wraps(fn, assigned=('__doc__', '__name__', '__qualname__'))
        def wrapper(x, *args, **kwargs): 
            return callattr(x, name, *args, **kwargs)
        return wrapper
    return decorator

# %% ../nbs/08_attr.ipynb 25
def applyfns(x, funcs: Sequence[Callable], *args: P.args, check: Callable[P, TypeGuard[Any]] | None = None, **kwargs: P.kwargs):   
    for f in funcs: 
        if callable(check) and callwith(check, x, *args, **kwargs): break
        x = callwith(f, x, *args, **kwargs)
    return x
