# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-10-11 08:06
from __future__ import unicode_literals

from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='MBillsTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transaction_id', models.CharField(max_length=255)),
                ('amount', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=20)),
                ('currency', models.CharField(default='EUR', max_length=255)),
                ('purpose', models.CharField(max_length=255)),
                ('payment_reference', models.CharField(blank=True, max_length=255, null=True)),
                ('capture', models.BooleanField(default=True)),
                ('order_id', models.CharField(blank=True, max_length=255, null=True)),
                ('channel_id', models.CharField(blank=True, max_length=255, null=True)),
                ('payment_token_number', models.CharField(max_length=255)),
                ('status', models.CharField(choices=[(-5, 'Failed'), (-4, 'Recurring Cancelled'), (-3, 'Insufficient Funds'), (-2, 'Timed Out'), (-1, 'Rejected'), (0, 'Accepted'), (1, 'Pending'), (2, 'Authorized'), (3, 'Paid'), (4, 'Voided')], default=0, max_length=255)),
                ('transaction_type', models.CharField(default='T', max_length=255)),
                ('settled_amount', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=20)),
                ('fees', models.DecimalField(decimal_places=2, default=Decimal('0'), max_digits=20)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'MBills Transaction',
            },
        ),
    ]
