/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;

public class BaseStoreClassRegister
implements StoreClassRegister {
    private Map<Class<?>, Byte> classToByteMap = new HashMap();
    private Map<Byte, Class<?>> byteToClassMap = new HashMap();

    protected boolean isClassRecognized(Class<?> clazz) {
        return this.classToByteMap.containsKey(clazz);
    }

    protected void registerClass(Class<?> clazz, byte id) {
        Byte objId = id;
        this.classToByteMap.put(clazz, objId);
        this.byteToClassMap.put(objId, clazz);
    }

    @Override
    public void storeIdentifierForClass(StoreWriter storeWriter, Class<?> clazz) {
        if (!this.classToByteMap.containsKey(clazz)) {
            throw new OsmosisRuntimeException("The class " + clazz + " is not supported by this store class register.");
        }
        byte id = this.classToByteMap.get(clazz);
        storeWriter.writeByte(id);
    }

    @Override
    public Class<?> getClassFromIdentifier(StoreReader storeReader) {
        byte classId = storeReader.readByte();
        Byte idObj = classId;
        if (!this.byteToClassMap.containsKey(idObj)) {
            throw new OsmosisRuntimeException("Byte " + classId + " is not a recognised class identifier, the data stream may be corrupt.");
        }
        return this.byteToClassMap.get(idObj);
    }
}

