/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import org.openstreetmap.osmosis.core.store.IndexedObjectStore;
import org.openstreetmap.osmosis.core.store.IndexedObjectStoreReader;
import org.openstreetmap.osmosis.core.store.NoSuchIndexElementException;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.CompactPersistentNodeLocation;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocation;
import org.openstreetmap.osmosis.pgsimple.common.NodeLocationStore;

public class CompactPersistentNodeLocationStore
implements NodeLocationStore {
    private IndexedObjectStore<CompactPersistentNodeLocation> nodeLocations = new IndexedObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(CompactPersistentNodeLocation.class), "nodeLocation");
    private IndexedObjectStoreReader<CompactPersistentNodeLocation> nodeLocationsReader;

    @Override
    public void addLocation(long nodeId, NodeLocation nodeLocation) {
        this.nodeLocations.add(nodeId, (Storeable)new CompactPersistentNodeLocation(nodeLocation));
    }

    @Override
    public NodeLocation getNodeLocation(long nodeId) {
        if (this.nodeLocationsReader == null) {
            this.nodeLocations.complete();
            this.nodeLocationsReader = this.nodeLocations.createReader();
        }
        try {
            return ((CompactPersistentNodeLocation)this.nodeLocationsReader.get(nodeId)).getNodeLocation();
        }
        catch (NoSuchIndexElementException e) {
            return new NodeLocation();
        }
    }

    public void close() {
        if (this.nodeLocationsReader != null) {
            this.nodeLocationsReader.close();
        }
        this.nodeLocations.close();
    }
}

