/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;
import java.util.List;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final double maxLatitude;
    public final double maxLongitude;
    public final double minLatitude;
    public final double minLongitude;

    public static BoundingBox fromString(String boundingBoxString) {
        double[] coordinates = LatLongUtils.parseCoordinateString(boundingBoxString, 4);
        return new BoundingBox(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
    }

    public BoundingBox(double minLatitude, double minLongitude, double maxLatitude, double maxLongitude) {
        LatLongUtils.validateLatitude(minLatitude);
        LatLongUtils.validateLongitude(minLongitude);
        LatLongUtils.validateLatitude(maxLatitude);
        LatLongUtils.validateLongitude(maxLongitude);
        if (minLatitude > maxLatitude) {
            throw new IllegalArgumentException("invalid latitude range: " + minLatitude + ' ' + maxLatitude);
        }
        if (minLongitude > maxLongitude) {
            throw new IllegalArgumentException("invalid longitude range: " + minLongitude + ' ' + maxLongitude);
        }
        this.minLatitude = minLatitude;
        this.minLongitude = minLongitude;
        this.maxLatitude = maxLatitude;
        this.maxLongitude = maxLongitude;
    }

    public BoundingBox(List<LatLong> latLongs) {
        double minLatitude = Double.POSITIVE_INFINITY;
        double minLongitude = Double.POSITIVE_INFINITY;
        double maxLatitude = Double.NEGATIVE_INFINITY;
        double maxLongitude = Double.NEGATIVE_INFINITY;
        for (LatLong latLong : latLongs) {
            double latitude = latLong.latitude;
            double longitude = latLong.longitude;
            minLatitude = Math.min(minLatitude, latitude);
            minLongitude = Math.min(minLongitude, longitude);
            maxLatitude = Math.max(maxLatitude, latitude);
            maxLongitude = Math.max(maxLongitude, longitude);
        }
        this.minLatitude = minLatitude;
        this.minLongitude = minLongitude;
        this.maxLatitude = maxLatitude;
        this.maxLongitude = maxLongitude;
    }

    public boolean contains(double latitude, double longitude) {
        return this.minLatitude <= latitude && this.maxLatitude >= latitude && this.minLongitude <= longitude && this.maxLongitude >= longitude;
    }

    public boolean contains(LatLong latLong) {
        return this.contains(latLong.latitude, latLong.longitude);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this.maxLatitude) != Double.doubleToLongBits(other.maxLatitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLongitude) != Double.doubleToLongBits(other.maxLongitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLatitude) != Double.doubleToLongBits(other.minLatitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLongitude) == Double.doubleToLongBits(other.minLongitude);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        return new BoundingBox(Math.min(this.minLatitude, boundingBox.minLatitude), Math.min(this.minLongitude, boundingBox.minLongitude), Math.max(this.maxLatitude, boundingBox.maxLatitude), Math.max(this.maxLongitude, boundingBox.maxLongitude));
    }

    public BoundingBox extendCoordinates(double latitude, double longitude) {
        if (this.contains(latitude, longitude)) {
            return this;
        }
        double minLat = Math.max(-85.05112877980659, Math.min(this.minLatitude, latitude));
        double minLon = Math.max(-180.0, Math.min(this.minLongitude, longitude));
        double maxLat = Math.min(85.05112877980659, Math.max(this.maxLatitude, latitude));
        double maxLon = Math.min(180.0, Math.max(this.maxLongitude, longitude));
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendCoordinates(LatLong latLong) {
        return this.extendCoordinates(latLong.latitude, latLong.longitude);
    }

    public BoundingBox extendDegrees(double verticalExpansion, double horizontalExpansion) {
        if (verticalExpansion == 0.0 && horizontalExpansion == 0.0) {
            return this;
        }
        if (verticalExpansion < 0.0 || horizontalExpansion < 0.0) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
        }
        double minLat = Math.max(-85.05112877980659, this.minLatitude - verticalExpansion);
        double minLon = Math.max(-180.0, this.minLongitude - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.maxLatitude + verticalExpansion);
        double maxLon = Math.min(180.0, this.maxLongitude + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendMargin(float margin) {
        if (margin == 1.0f) {
            return this;
        }
        if (margin <= 0.0f) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative or zero values");
        }
        double verticalExpansion = (this.getLatitudeSpan() * (double)margin - this.getLatitudeSpan()) * 0.5;
        double horizontalExpansion = (this.getLongitudeSpan() * (double)margin - this.getLongitudeSpan()) * 0.5;
        double minLat = Math.max(-85.05112877980659, this.minLatitude - verticalExpansion);
        double minLon = Math.max(-180.0, this.minLongitude - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.maxLatitude + verticalExpansion);
        double maxLon = Math.min(180.0, this.maxLongitude + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public BoundingBox extendMeters(int meters) {
        if (meters == 0) {
            return this;
        }
        if (meters < 0) {
            throw new IllegalArgumentException("BoundingBox extend operation does not accept negative values");
        }
        double verticalExpansion = LatLongUtils.latitudeDistance(meters);
        double horizontalExpansion = LatLongUtils.longitudeDistance(meters, Math.max(Math.abs(this.minLatitude), Math.abs(this.maxLatitude)));
        double minLat = Math.max(-85.05112877980659, this.minLatitude - verticalExpansion);
        double minLon = Math.max(-180.0, this.minLongitude - horizontalExpansion);
        double maxLat = Math.min(85.05112877980659, this.maxLatitude + verticalExpansion);
        double maxLon = Math.min(180.0, this.maxLongitude + horizontalExpansion);
        return new BoundingBox(minLat, minLon, maxLat, maxLon);
    }

    public LatLong getCenterPoint() {
        double latitudeOffset = (this.maxLatitude - this.minLatitude) / 2.0;
        double longitudeOffset = (this.maxLongitude - this.minLongitude) / 2.0;
        return new LatLong(this.minLatitude + latitudeOffset, this.minLongitude + longitudeOffset);
    }

    public double getLatitudeSpan() {
        return this.maxLatitude - this.minLatitude;
    }

    public double getLongitudeSpan() {
        return this.maxLongitude - this.minLongitude;
    }

    public Rectangle getPositionRelativeToTile(Tile tile) {
        Point upperLeft = MercatorProjection.getPixelRelativeToTile(new LatLong(this.maxLatitude, this.minLongitude), tile);
        Point lowerRight = MercatorProjection.getPixelRelativeToTile(new LatLong(this.minLatitude, this.maxLongitude), tile);
        return new Rectangle(upperLeft.x, upperLeft.y, lowerRight.x, lowerRight.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean intersects(BoundingBox boundingBox) {
        if (this == boundingBox) {
            return true;
        }
        return this.maxLatitude >= boundingBox.minLatitude && this.maxLongitude >= boundingBox.minLongitude && this.minLatitude <= boundingBox.maxLatitude && this.minLongitude <= boundingBox.maxLongitude;
    }

    public boolean intersectsArea(LatLong[][] latLongs) {
        if (latLongs.length == 0 || latLongs[0].length == 0) {
            return false;
        }
        LatLong[][] latLongArray = latLongs;
        int n = latLongArray.length;
        for (int i = 0; i < n; ++i) {
            LatLong[] outer;
            for (LatLong latLong : outer = latLongArray[i]) {
                if (!this.contains(latLong)) continue;
                return true;
            }
        }
        double tmpMinLat = latLongs[0][0].latitude;
        double tmpMinLon = latLongs[0][0].longitude;
        double tmpMaxLat = latLongs[0][0].latitude;
        double tmpMaxLon = latLongs[0][0].longitude;
        LatLong[][] latLongArray2 = latLongs;
        int n2 = latLongArray2.length;
        for (int i = 0; i < n2; ++i) {
            LatLong[] outer;
            for (LatLong latLong : outer = latLongArray2[i]) {
                tmpMinLat = Math.min(tmpMinLat, latLong.latitude);
                tmpMaxLat = Math.max(tmpMaxLat, latLong.latitude);
                tmpMinLon = Math.min(tmpMinLon, latLong.longitude);
                tmpMaxLon = Math.max(tmpMaxLon, latLong.longitude);
            }
        }
        return this.intersects(new BoundingBox(tmpMinLat, tmpMinLon, tmpMaxLat, tmpMaxLon));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("minLatitude=");
        stringBuilder.append(this.minLatitude);
        stringBuilder.append(", minLongitude=");
        stringBuilder.append(this.minLongitude);
        stringBuilder.append(", maxLatitude=");
        stringBuilder.append(this.maxLatitude);
        stringBuilder.append(", maxLongitude=");
        stringBuilder.append(this.maxLongitude);
        return stringBuilder.toString();
    }
}

