/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;

public class StandardPathResolver
implements PathResolver {
    protected Log log = LogFactory.getLog(this.getClass());
    private Map<String, URL> urlMap = new HashMap<String, URL>();

    public void registerContext(Identity idt, URL url) {
        if (!(idt instanceof PluginDescriptor) && !(idt instanceof PluginFragment)) {
            throw new IllegalArgumentException("unsupported identity class " + idt.getClass().getName());
        }
        URL oldUrl = this.urlMap.put(idt.getId(), url);
        if (oldUrl != null) {
            this.log.warn("old context URL " + oldUrl + " has been replaced with new " + url + " for " + idt + " with key " + idt.getId());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("context URL " + url + " registered for " + idt + " with key " + idt.getId());
        }
    }

    public void unregisterContext(String id) {
        URL url = this.urlMap.remove(id);
        if (url == null) {
            this.log.warn("no context was registered with key " + id);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("context URL " + url + " un-registered for key " + id);
        }
    }

    public URL resolvePath(Identity identity, String path) {
        URL baseUrl;
        if (identity instanceof PluginDescriptor || identity instanceof PluginFragment) {
            baseUrl = this.getRegisteredContext(identity.getId());
        } else if (identity instanceof PluginElement) {
            PluginElement element = (PluginElement)identity;
            baseUrl = element.getDeclaringPluginFragment() != null ? this.getRegisteredContext(element.getDeclaringPluginFragment().getId()) : this.getRegisteredContext(element.getDeclaringPluginDescriptor().getId());
        } else {
            throw new IllegalArgumentException("unknown identity class " + identity.getClass().getName());
        }
        return this.resolvePath(baseUrl, path);
    }

    public URL getRegisteredContext(String id) {
        URL result = this.urlMap.get(id);
        if (result == null) {
            throw new IllegalArgumentException("unknown plug-in or plug-in fragment ID - " + id);
        }
        return result;
    }

    public boolean isContextRegistered(String id) {
        return this.urlMap.containsKey(id);
    }

    protected URL resolvePath(URL baseUrl, String path) {
        try {
            if ("".equals(path) || "/".equals(path)) {
                return this.maybeJarUrl(baseUrl);
            }
            return this.maybeJarUrl(new URL(this.maybeJarUrl(baseUrl), path));
        }
        catch (MalformedURLException mue) {
            this.log.error("can't create URL in context of " + baseUrl + " and path " + path, mue);
            throw new IllegalArgumentException("path " + path + " in context of " + baseUrl + " cause creation of malformed URL");
        }
    }

    protected URL maybeJarUrl(URL url) throws MalformedURLException {
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            return url;
        }
        File file = IoUtil.url2file(url);
        if (file == null || !file.isFile()) {
            return url;
        }
        String fileName = file.getName().toLowerCase(Locale.getDefault());
        if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
            return new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/");
        }
        return url;
    }

    public void configure(ExtendedProperties config) throws Exception {
    }
}

