/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlobDecoder;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlobDecoderListener;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfBlobResult;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.RawBlob;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.StreamSplitter;

public class PbfDecoder
implements Runnable {
    private StreamSplitter streamSplitter;
    private Executor executor;
    private int maxPendingBlobs;
    private Sink sink;
    private Lock lock;
    private Condition dataWaitCondition;
    private Queue<PbfBlobResult> blobResults;

    public PbfDecoder(StreamSplitter streamSplitter, Executor executor, int maxPendingBlobs, Sink sink) {
        this.streamSplitter = streamSplitter;
        this.executor = executor;
        this.maxPendingBlobs = maxPendingBlobs;
        this.sink = sink;
        this.lock = new ReentrantLock();
        this.dataWaitCondition = this.lock.newCondition();
        this.blobResults = new LinkedList<PbfBlobResult>();
    }

    private void waitForUpdate() {
        try {
            this.dataWaitCondition.await();
        }
        catch (InterruptedException e) {
            throw new OsmosisRuntimeException("Thread was interrupted.", (Throwable)e);
        }
    }

    private void signalUpdate() {
        this.dataWaitCondition.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResultsToSink(int targetQueueSize) {
        while (this.blobResults.size() > targetQueueSize) {
            PbfBlobResult blobResult = this.blobResults.remove();
            while (!blobResult.isComplete()) {
                this.waitForUpdate();
            }
            if (!blobResult.isSuccess()) {
                throw new OsmosisRuntimeException("A PBF decoding worker thread failed, aborting.");
            }
            this.lock.unlock();
            try {
                for (EntityContainer entity : blobResult.getEntities()) {
                    this.sink.process(entity);
                }
            }
            finally {
                this.lock.lock();
            }
        }
    }

    private void processBlobs() {
        while (this.streamSplitter.hasNext()) {
            RawBlob rawBlob = this.streamSplitter.next();
            final PbfBlobResult blobResult = new PbfBlobResult();
            this.blobResults.add(blobResult);
            PbfBlobDecoderListener decoderListener = new PbfBlobDecoderListener(){

                @Override
                public void error() {
                    PbfDecoder.this.lock.lock();
                    try {
                        blobResult.storeFailureResult();
                        PbfDecoder.this.signalUpdate();
                    }
                    finally {
                        PbfDecoder.this.lock.unlock();
                    }
                }

                @Override
                public void complete(List<EntityContainer> decodedEntities) {
                    PbfDecoder.this.lock.lock();
                    try {
                        blobResult.storeSuccessResult(decodedEntities);
                        PbfDecoder.this.signalUpdate();
                    }
                    finally {
                        PbfDecoder.this.lock.unlock();
                    }
                }
            };
            PbfBlobDecoder blobDecoder = new PbfBlobDecoder(rawBlob, decoderListener);
            this.executor.execute(blobDecoder);
            this.sendResultsToSink(this.maxPendingBlobs - 1);
        }
        this.sendResultsToSink(0);
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.processBlobs();
        }
        finally {
            this.lock.unlock();
        }
    }
}

