import { aws_ec2 as ec2, aws_ecs as ecs, aws_iam as iam, aws_stepfunctions as stepfunctions } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IRunnerProvider, RunnerProviderProps, RunnerRuntimeParameters } from './common';
export interface FargateRunnerProps extends RunnerProviderProps {
    /**
     * GitHub Actions label used for this provider.
     *
     * @default 'fargate'
     */
    readonly label?: string;
    /**
     * VPC to launch the runners in.
     *
     * @default default account VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Security Group to assign to the task.
     *
     * @default a new security group
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * Existing Fargate cluster to use.
     *
     * @default a new cluster
     */
    readonly cluster?: ecs.Cluster;
    /**
     * Assign public IP to the runner task.
     *
     * @default true
     */
    readonly assignPublicIp?: boolean;
    /**
     * The number of cpu units used by the task. For tasks using the Fargate launch type,
     * this field is required and you must use one of the following values,
     * which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *
     * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *
     * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *
     * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     *
     * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     *
     * @default 1024
     */
    readonly cpu?: number;
    /**
     * The amount (in MiB) of memory used by the task. For tasks using the Fargate launch type,
     * this field is required and you must use one of the following values, which determines your range of valid values for the cpu parameter:
     *
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     *
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     *
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     *
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     *
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     *
     * @default 2048
     */
    readonly memoryLimitMiB?: number;
    /**
     * The amount (in GiB) of ephemeral storage to be allocated to the task. The maximum supported value is 200 GiB.
     *
     * NOTE: This parameter is only supported for tasks hosted on AWS Fargate using platform version 1.4.0 or later.
     *
     * @default 20
     */
    readonly ephemeralStorageGiB?: number;
}
/**
 * GitHub Actions runner provider using Fargate to execute the actions.
 *
 * Creates a task definition with a single container that gets started for each job.
 */
export declare class FargateRunner extends Construct implements IRunnerProvider {
    readonly cluster: ecs.Cluster;
    readonly task: ecs.FargateTaskDefinition;
    readonly container: ecs.ContainerDefinition;
    readonly label: string;
    readonly vpc?: ec2.IVpc;
    readonly securityGroup?: ec2.ISecurityGroup;
    readonly assignPublicIp: boolean;
    readonly grantPrincipal: iam.IPrincipal;
    readonly connections: ec2.Connections;
    constructor(scope: Construct, id: string, props: FargateRunnerProps);
    getStepFunctionTask(parameters: RunnerRuntimeParameters): stepfunctions.IChainable;
}
//# sourceMappingURL=fargate.d.ts.map