
with Ada.Containers.Vectors;
with Ada.Exceptions;
with Ada.Unchecked_Deallocation;

with Langkit_Support.Diagnostics; use Langkit_Support.Diagnostics;
with Langkit_Support.Packrat;
with Langkit_Support.Slocs;       use Langkit_Support.Slocs;

pragma Warnings (Off, "referenced");
with Langkit_Support.Symbols; use Langkit_Support.Symbols;
pragma Warnings (On, "referenced");

with Langkit_Support.Text;        use Langkit_Support.Text;

with Librflxlang.Common;             use Librflxlang.Common;
use Librflxlang.Common.Precomputed_Symbols;

with Librflxlang.Implementation;     use Librflxlang.Implementation;

pragma Warnings (Off, "referenced");
with Librflxlang.Private_Converters; use Librflxlang.Private_Converters;
pragma Warnings (On, "referenced");



package body Librflxlang.Parsers is
   pragma Warnings (Off, "use clause");
   use all type Langkit_Support.Symbols.Symbol_Type;
   pragma Warnings (On, "use clause");

   --  Prepare packrat instantiations: one per enum type and onefor each kind
   --  of node (including lists). Likewise for bump ptr. allocators, except
   --  we need them only for non-abstract AST nodes.
   --
   --  In the Alloc instanciations, there are unchecked conversions to wrap
   --  System.Address values from a low-level allocator. All read/writes for
   --  the pointed values are made through values of the same access types
   --  (i.e. AST node access). Thus, strict aliasing issues should not arise
   --  for these.
   --
   --  See <https://gcc.gnu.org/onlinedocs/gnat_ugn/
   --       Optimization-and-Strict-Aliasing.html>.

   pragma Warnings (Off, "is not referenced");
   pragma Warnings (Off, "possible aliasing problem for type");
      package Bare_RFLX_Node_Memos is new Langkit_Support.Packrat
        (Bare_RFLX_Node, Token_Index);

      package Bare_AbstractID_Memos is new Langkit_Support.Packrat
        (Bare_AbstractID, Token_Index);

      package Bare_ID_Memos is new Langkit_Support.Packrat
        (Bare_ID, Token_Index);

         
         subtype Subtype_For_ID is
            Root_Node_Record (RFLX_ID);
         type Access_To_Subtype_For_ID is access all Subtype_For_ID;
         package Bare_ID_Alloc is new Alloc
           (Subtype_For_ID, Access_To_Subtype_For_ID);

         function Allocate_ID
           (Pool : Bump_Ptr_Pool) return Bare_ID;

         function Allocate_ID
           (Pool : Bump_Ptr_Pool) return Bare_ID
         is
            Result      : constant Access_To_Subtype_For_ID := Bare_ID_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_ID;
            return Bare_ID (Result);
         end Allocate_ID;

      package Bare_NullID_Memos is new Langkit_Support.Packrat
        (Bare_NullID, Token_Index);

         
         subtype Subtype_For_NullID is
            Root_Node_Record (RFLX_NullID);
         type Access_To_Subtype_For_NullID is access all Subtype_For_NullID;
         package Bare_NullID_Alloc is new Alloc
           (Subtype_For_NullID, Access_To_Subtype_For_NullID);

         function Allocate_NullID
           (Pool : Bump_Ptr_Pool) return Bare_NullID;

         function Allocate_NullID
           (Pool : Bump_Ptr_Pool) return Bare_NullID
         is
            Result      : constant Access_To_Subtype_For_NullID := Bare_NullID_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_NullID;
            return Bare_NullID (Result);
         end Allocate_NullID;

      package Bare_UnqualifiedID_Memos is new Langkit_Support.Packrat
        (Bare_UnqualifiedID, Token_Index);

         
         subtype Subtype_For_UnqualifiedID is
            Root_Node_Record (RFLX_UnqualifiedID);
         type Access_To_Subtype_For_UnqualifiedID is access all Subtype_For_UnqualifiedID;
         package Bare_UnqualifiedID_Alloc is new Alloc
           (Subtype_For_UnqualifiedID, Access_To_Subtype_For_UnqualifiedID);

         function Allocate_UnqualifiedID
           (Pool : Bump_Ptr_Pool) return Bare_UnqualifiedID;

         function Allocate_UnqualifiedID
           (Pool : Bump_Ptr_Pool) return Bare_UnqualifiedID
         is
            Result      : constant Access_To_Subtype_For_UnqualifiedID := Bare_UnqualifiedID_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_UnqualifiedID;
            return Bare_UnqualifiedID (Result);
         end Allocate_UnqualifiedID;

      package Bare_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Aspect, Token_Index);

         
         subtype Subtype_For_Aspect is
            Root_Node_Record (RFLX_Aspect);
         type Access_To_Subtype_For_Aspect is access all Subtype_For_Aspect;
         package Bare_Aspect_Alloc is new Alloc
           (Subtype_For_Aspect, Access_To_Subtype_For_Aspect);

         function Allocate_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Aspect;

         function Allocate_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Aspect
         is
            Result      : constant Access_To_Subtype_For_Aspect := Bare_Aspect_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Aspect;
            return Bare_Aspect (Result);
         end Allocate_Aspect;

      package Bare_Attr_Memos is new Langkit_Support.Packrat
        (Bare_Attr, Token_Index);

      package Bare_Attr_First_Memos is new Langkit_Support.Packrat
        (Bare_Attr_First, Token_Index);

         
         subtype Subtype_For_Attr_First is
            Root_Node_Record (RFLX_Attr_First);
         type Access_To_Subtype_For_Attr_First is access all Subtype_For_Attr_First;
         package Bare_Attr_First_Alloc is new Alloc
           (Subtype_For_Attr_First, Access_To_Subtype_For_Attr_First);

         function Allocate_Attr_First
           (Pool : Bump_Ptr_Pool) return Bare_Attr_First;

         function Allocate_Attr_First
           (Pool : Bump_Ptr_Pool) return Bare_Attr_First
         is
            Result      : constant Access_To_Subtype_For_Attr_First := Bare_Attr_First_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_First;
            return Bare_Attr_First (Result);
         end Allocate_Attr_First;

      package Bare_Attr_Has_Data_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Has_Data, Token_Index);

         
         subtype Subtype_For_Attr_Has_Data is
            Root_Node_Record (RFLX_Attr_Has_Data);
         type Access_To_Subtype_For_Attr_Has_Data is access all Subtype_For_Attr_Has_Data;
         package Bare_Attr_Has_Data_Alloc is new Alloc
           (Subtype_For_Attr_Has_Data, Access_To_Subtype_For_Attr_Has_Data);

         function Allocate_Attr_Has_Data
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Has_Data;

         function Allocate_Attr_Has_Data
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Has_Data
         is
            Result      : constant Access_To_Subtype_For_Attr_Has_Data := Bare_Attr_Has_Data_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Has_Data;
            return Bare_Attr_Has_Data (Result);
         end Allocate_Attr_Has_Data;

      package Bare_Attr_Head_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Head, Token_Index);

         
         subtype Subtype_For_Attr_Head is
            Root_Node_Record (RFLX_Attr_Head);
         type Access_To_Subtype_For_Attr_Head is access all Subtype_For_Attr_Head;
         package Bare_Attr_Head_Alloc is new Alloc
           (Subtype_For_Attr_Head, Access_To_Subtype_For_Attr_Head);

         function Allocate_Attr_Head
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Head;

         function Allocate_Attr_Head
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Head
         is
            Result      : constant Access_To_Subtype_For_Attr_Head := Bare_Attr_Head_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Head;
            return Bare_Attr_Head (Result);
         end Allocate_Attr_Head;

      package Bare_Attr_Last_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Last, Token_Index);

         
         subtype Subtype_For_Attr_Last is
            Root_Node_Record (RFLX_Attr_Last);
         type Access_To_Subtype_For_Attr_Last is access all Subtype_For_Attr_Last;
         package Bare_Attr_Last_Alloc is new Alloc
           (Subtype_For_Attr_Last, Access_To_Subtype_For_Attr_Last);

         function Allocate_Attr_Last
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Last;

         function Allocate_Attr_Last
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Last
         is
            Result      : constant Access_To_Subtype_For_Attr_Last := Bare_Attr_Last_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Last;
            return Bare_Attr_Last (Result);
         end Allocate_Attr_Last;

      package Bare_Attr_Opaque_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Opaque, Token_Index);

         
         subtype Subtype_For_Attr_Opaque is
            Root_Node_Record (RFLX_Attr_Opaque);
         type Access_To_Subtype_For_Attr_Opaque is access all Subtype_For_Attr_Opaque;
         package Bare_Attr_Opaque_Alloc is new Alloc
           (Subtype_For_Attr_Opaque, Access_To_Subtype_For_Attr_Opaque);

         function Allocate_Attr_Opaque
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Opaque;

         function Allocate_Attr_Opaque
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Opaque
         is
            Result      : constant Access_To_Subtype_For_Attr_Opaque := Bare_Attr_Opaque_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Opaque;
            return Bare_Attr_Opaque (Result);
         end Allocate_Attr_Opaque;

      package Bare_Attr_Present_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Present, Token_Index);

         
         subtype Subtype_For_Attr_Present is
            Root_Node_Record (RFLX_Attr_Present);
         type Access_To_Subtype_For_Attr_Present is access all Subtype_For_Attr_Present;
         package Bare_Attr_Present_Alloc is new Alloc
           (Subtype_For_Attr_Present, Access_To_Subtype_For_Attr_Present);

         function Allocate_Attr_Present
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Present;

         function Allocate_Attr_Present
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Present
         is
            Result      : constant Access_To_Subtype_For_Attr_Present := Bare_Attr_Present_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Present;
            return Bare_Attr_Present (Result);
         end Allocate_Attr_Present;

      package Bare_Attr_Size_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Size, Token_Index);

         
         subtype Subtype_For_Attr_Size is
            Root_Node_Record (RFLX_Attr_Size);
         type Access_To_Subtype_For_Attr_Size is access all Subtype_For_Attr_Size;
         package Bare_Attr_Size_Alloc is new Alloc
           (Subtype_For_Attr_Size, Access_To_Subtype_For_Attr_Size);

         function Allocate_Attr_Size
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Size;

         function Allocate_Attr_Size
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Size
         is
            Result      : constant Access_To_Subtype_For_Attr_Size := Bare_Attr_Size_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Size;
            return Bare_Attr_Size (Result);
         end Allocate_Attr_Size;

      package Bare_Attr_Valid_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Valid, Token_Index);

         
         subtype Subtype_For_Attr_Valid is
            Root_Node_Record (RFLX_Attr_Valid);
         type Access_To_Subtype_For_Attr_Valid is access all Subtype_For_Attr_Valid;
         package Bare_Attr_Valid_Alloc is new Alloc
           (Subtype_For_Attr_Valid, Access_To_Subtype_For_Attr_Valid);

         function Allocate_Attr_Valid
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid;

         function Allocate_Attr_Valid
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid
         is
            Result      : constant Access_To_Subtype_For_Attr_Valid := Bare_Attr_Valid_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Valid;
            return Bare_Attr_Valid (Result);
         end Allocate_Attr_Valid;

      package Bare_Attr_Valid_Checksum_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Valid_Checksum, Token_Index);

         
         subtype Subtype_For_Attr_Valid_Checksum is
            Root_Node_Record (RFLX_Attr_Valid_Checksum);
         type Access_To_Subtype_For_Attr_Valid_Checksum is access all Subtype_For_Attr_Valid_Checksum;
         package Bare_Attr_Valid_Checksum_Alloc is new Alloc
           (Subtype_For_Attr_Valid_Checksum, Access_To_Subtype_For_Attr_Valid_Checksum);

         function Allocate_Attr_Valid_Checksum
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid_Checksum;

         function Allocate_Attr_Valid_Checksum
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Valid_Checksum
         is
            Result      : constant Access_To_Subtype_For_Attr_Valid_Checksum := Bare_Attr_Valid_Checksum_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Valid_Checksum;
            return Bare_Attr_Valid_Checksum (Result);
         end Allocate_Attr_Valid_Checksum;

      package Bare_Attr_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt, Token_Index);

      package Bare_Attr_Stmt_Append_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Append, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Append is
            Root_Node_Record (RFLX_Attr_Stmt_Append);
         type Access_To_Subtype_For_Attr_Stmt_Append is access all Subtype_For_Attr_Stmt_Append;
         package Bare_Attr_Stmt_Append_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Append, Access_To_Subtype_For_Attr_Stmt_Append);

         function Allocate_Attr_Stmt_Append
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Append;

         function Allocate_Attr_Stmt_Append
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Append
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Append := Bare_Attr_Stmt_Append_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Stmt_Append;
            return Bare_Attr_Stmt_Append (Result);
         end Allocate_Attr_Stmt_Append;

      package Bare_Attr_Stmt_Extend_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Extend, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Extend is
            Root_Node_Record (RFLX_Attr_Stmt_Extend);
         type Access_To_Subtype_For_Attr_Stmt_Extend is access all Subtype_For_Attr_Stmt_Extend;
         package Bare_Attr_Stmt_Extend_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Extend, Access_To_Subtype_For_Attr_Stmt_Extend);

         function Allocate_Attr_Stmt_Extend
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Extend;

         function Allocate_Attr_Stmt_Extend
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Extend
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Extend := Bare_Attr_Stmt_Extend_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Stmt_Extend;
            return Bare_Attr_Stmt_Extend (Result);
         end Allocate_Attr_Stmt_Extend;

      package Bare_Attr_Stmt_Read_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Read, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Read is
            Root_Node_Record (RFLX_Attr_Stmt_Read);
         type Access_To_Subtype_For_Attr_Stmt_Read is access all Subtype_For_Attr_Stmt_Read;
         package Bare_Attr_Stmt_Read_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Read, Access_To_Subtype_For_Attr_Stmt_Read);

         function Allocate_Attr_Stmt_Read
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Read;

         function Allocate_Attr_Stmt_Read
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Read
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Read := Bare_Attr_Stmt_Read_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Stmt_Read;
            return Bare_Attr_Stmt_Read (Result);
         end Allocate_Attr_Stmt_Read;

      package Bare_Attr_Stmt_Write_Memos is new Langkit_Support.Packrat
        (Bare_Attr_Stmt_Write, Token_Index);

         
         subtype Subtype_For_Attr_Stmt_Write is
            Root_Node_Record (RFLX_Attr_Stmt_Write);
         type Access_To_Subtype_For_Attr_Stmt_Write is access all Subtype_For_Attr_Stmt_Write;
         package Bare_Attr_Stmt_Write_Alloc is new Alloc
           (Subtype_For_Attr_Stmt_Write, Access_To_Subtype_For_Attr_Stmt_Write);

         function Allocate_Attr_Stmt_Write
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Write;

         function Allocate_Attr_Stmt_Write
           (Pool : Bump_Ptr_Pool) return Bare_Attr_Stmt_Write
         is
            Result      : constant Access_To_Subtype_For_Attr_Stmt_Write := Bare_Attr_Stmt_Write_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attr_Stmt_Write;
            return Bare_Attr_Stmt_Write (Result);
         end Allocate_Attr_Stmt_Write;

      package Bare_Base_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Base_Aggregate, Token_Index);

      package Bare_Message_Aggregate_Associations_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Associations, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Associations is
            Root_Node_Record (RFLX_Message_Aggregate_Associations);
         type Access_To_Subtype_For_Message_Aggregate_Associations is access all Subtype_For_Message_Aggregate_Associations;
         package Bare_Message_Aggregate_Associations_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Associations, Access_To_Subtype_For_Message_Aggregate_Associations);

         function Allocate_Message_Aggregate_Associations
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Associations;

         function Allocate_Message_Aggregate_Associations
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Associations
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Associations := Bare_Message_Aggregate_Associations_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Aggregate_Associations;
            return Bare_Message_Aggregate_Associations (Result);
         end Allocate_Message_Aggregate_Associations;

      package Bare_Null_Message_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Aggregate, Token_Index);

         
         subtype Subtype_For_Null_Message_Aggregate is
            Root_Node_Record (RFLX_Null_Message_Aggregate);
         type Access_To_Subtype_For_Null_Message_Aggregate is access all Subtype_For_Null_Message_Aggregate;
         package Bare_Null_Message_Aggregate_Alloc is new Alloc
           (Subtype_For_Null_Message_Aggregate, Access_To_Subtype_For_Null_Message_Aggregate);

         function Allocate_Null_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Aggregate;

         function Allocate_Null_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Aggregate := Bare_Null_Message_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Null_Message_Aggregate;
            return Bare_Null_Message_Aggregate (Result);
         end Allocate_Null_Message_Aggregate;

      package Bare_Base_Checksum_Val_Memos is new Langkit_Support.Packrat
        (Bare_Base_Checksum_Val, Token_Index);

      package Bare_Checksum_Val_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Val, Token_Index);

         
         subtype Subtype_For_Checksum_Val is
            Root_Node_Record (RFLX_Checksum_Val);
         type Access_To_Subtype_For_Checksum_Val is access all Subtype_For_Checksum_Val;
         package Bare_Checksum_Val_Alloc is new Alloc
           (Subtype_For_Checksum_Val, Access_To_Subtype_For_Checksum_Val);

         function Allocate_Checksum_Val
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Val;

         function Allocate_Checksum_Val
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Val
         is
            Result      : constant Access_To_Subtype_For_Checksum_Val := Bare_Checksum_Val_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Checksum_Val;
            return Bare_Checksum_Val (Result);
         end Allocate_Checksum_Val;

      package Bare_Checksum_Value_Range_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Value_Range, Token_Index);

         
         subtype Subtype_For_Checksum_Value_Range is
            Root_Node_Record (RFLX_Checksum_Value_Range);
         type Access_To_Subtype_For_Checksum_Value_Range is access all Subtype_For_Checksum_Value_Range;
         package Bare_Checksum_Value_Range_Alloc is new Alloc
           (Subtype_For_Checksum_Value_Range, Access_To_Subtype_For_Checksum_Value_Range);

         function Allocate_Checksum_Value_Range
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Value_Range;

         function Allocate_Checksum_Value_Range
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Value_Range
         is
            Result      : constant Access_To_Subtype_For_Checksum_Value_Range := Bare_Checksum_Value_Range_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Checksum_Value_Range;
            return Bare_Checksum_Value_Range (Result);
         end Allocate_Checksum_Value_Range;

      package Bare_Base_State_Body_Memos is new Langkit_Support.Packrat
        (Bare_Base_State_Body, Token_Index);

      package Bare_Null_State_Body_Memos is new Langkit_Support.Packrat
        (Bare_Null_State_Body, Token_Index);

         
         subtype Subtype_For_Null_State_Body is
            Root_Node_Record (RFLX_Null_State_Body);
         type Access_To_Subtype_For_Null_State_Body is access all Subtype_For_Null_State_Body;
         package Bare_Null_State_Body_Alloc is new Alloc
           (Subtype_For_Null_State_Body, Access_To_Subtype_For_Null_State_Body);

         function Allocate_Null_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_Null_State_Body;

         function Allocate_Null_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_Null_State_Body
         is
            Result      : constant Access_To_Subtype_For_Null_State_Body := Bare_Null_State_Body_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Null_State_Body;
            return Bare_Null_State_Body (Result);
         end Allocate_Null_State_Body;

      package Bare_State_Body_Memos is new Langkit_Support.Packrat
        (Bare_State_Body, Token_Index);

         
         subtype Subtype_For_State_Body is
            Root_Node_Record (RFLX_State_Body);
         type Access_To_Subtype_For_State_Body is access all Subtype_For_State_Body;
         package Bare_State_Body_Alloc is new Alloc
           (Subtype_For_State_Body, Access_To_Subtype_For_State_Body);

         function Allocate_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_State_Body;

         function Allocate_State_Body
           (Pool : Bump_Ptr_Pool) return Bare_State_Body
         is
            Result      : constant Access_To_Subtype_For_State_Body := Bare_State_Body_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_State_Body;
            return Bare_State_Body (Result);
         end Allocate_State_Body;

      package Bare_Byte_Order_Type_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type, Token_Index);

      package Bare_Byte_Order_Type_Highorderfirst_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type_Highorderfirst, Token_Index);

         
         subtype Subtype_For_Byte_Order_Type_Highorderfirst is
            Root_Node_Record (RFLX_Byte_Order_Type_Highorderfirst);
         type Access_To_Subtype_For_Byte_Order_Type_Highorderfirst is access all Subtype_For_Byte_Order_Type_Highorderfirst;
         package Bare_Byte_Order_Type_Highorderfirst_Alloc is new Alloc
           (Subtype_For_Byte_Order_Type_Highorderfirst, Access_To_Subtype_For_Byte_Order_Type_Highorderfirst);

         function Allocate_Byte_Order_Type_Highorderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Highorderfirst;

         function Allocate_Byte_Order_Type_Highorderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Highorderfirst
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Type_Highorderfirst := Bare_Byte_Order_Type_Highorderfirst_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Byte_Order_Type_Highorderfirst;
            return Bare_Byte_Order_Type_Highorderfirst (Result);
         end Allocate_Byte_Order_Type_Highorderfirst;

      package Bare_Byte_Order_Type_Loworderfirst_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Type_Loworderfirst, Token_Index);

         
         subtype Subtype_For_Byte_Order_Type_Loworderfirst is
            Root_Node_Record (RFLX_Byte_Order_Type_Loworderfirst);
         type Access_To_Subtype_For_Byte_Order_Type_Loworderfirst is access all Subtype_For_Byte_Order_Type_Loworderfirst;
         package Bare_Byte_Order_Type_Loworderfirst_Alloc is new Alloc
           (Subtype_For_Byte_Order_Type_Loworderfirst, Access_To_Subtype_For_Byte_Order_Type_Loworderfirst);

         function Allocate_Byte_Order_Type_Loworderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Loworderfirst;

         function Allocate_Byte_Order_Type_Loworderfirst
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Type_Loworderfirst
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Type_Loworderfirst := Bare_Byte_Order_Type_Loworderfirst_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Byte_Order_Type_Loworderfirst;
            return Bare_Byte_Order_Type_Loworderfirst (Result);
         end Allocate_Byte_Order_Type_Loworderfirst;

      package Bare_Channel_Attribute_Memos is new Langkit_Support.Packrat
        (Bare_Channel_Attribute, Token_Index);

      package Bare_Readable_Memos is new Langkit_Support.Packrat
        (Bare_Readable, Token_Index);

         
         subtype Subtype_For_Readable is
            Root_Node_Record (RFLX_Readable);
         type Access_To_Subtype_For_Readable is access all Subtype_For_Readable;
         package Bare_Readable_Alloc is new Alloc
           (Subtype_For_Readable, Access_To_Subtype_For_Readable);

         function Allocate_Readable
           (Pool : Bump_Ptr_Pool) return Bare_Readable;

         function Allocate_Readable
           (Pool : Bump_Ptr_Pool) return Bare_Readable
         is
            Result      : constant Access_To_Subtype_For_Readable := Bare_Readable_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Readable;
            return Bare_Readable (Result);
         end Allocate_Readable;

      package Bare_Writable_Memos is new Langkit_Support.Packrat
        (Bare_Writable, Token_Index);

         
         subtype Subtype_For_Writable is
            Root_Node_Record (RFLX_Writable);
         type Access_To_Subtype_For_Writable is access all Subtype_For_Writable;
         package Bare_Writable_Alloc is new Alloc
           (Subtype_For_Writable, Access_To_Subtype_For_Writable);

         function Allocate_Writable
           (Pool : Bump_Ptr_Pool) return Bare_Writable;

         function Allocate_Writable
           (Pool : Bump_Ptr_Pool) return Bare_Writable
         is
            Result      : constant Access_To_Subtype_For_Writable := Bare_Writable_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Writable;
            return Bare_Writable (Result);
         end Allocate_Writable;

      package Bare_Checksum_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Assoc, Token_Index);

         
         subtype Subtype_For_Checksum_Assoc is
            Root_Node_Record (RFLX_Checksum_Assoc);
         type Access_To_Subtype_For_Checksum_Assoc is access all Subtype_For_Checksum_Assoc;
         package Bare_Checksum_Assoc_Alloc is new Alloc
           (Subtype_For_Checksum_Assoc, Access_To_Subtype_For_Checksum_Assoc);

         function Allocate_Checksum_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc;

         function Allocate_Checksum_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc
         is
            Result      : constant Access_To_Subtype_For_Checksum_Assoc := Bare_Checksum_Assoc_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Checksum_Assoc;
            return Bare_Checksum_Assoc (Result);
         end Allocate_Checksum_Assoc;

      package Bare_Declaration_Memos is new Langkit_Support.Packrat
        (Bare_Declaration, Token_Index);

      package Bare_Refinement_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Refinement_Decl, Token_Index);

         
         subtype Subtype_For_Refinement_Decl is
            Root_Node_Record (RFLX_Refinement_Decl);
         type Access_To_Subtype_For_Refinement_Decl is access all Subtype_For_Refinement_Decl;
         package Bare_Refinement_Decl_Alloc is new Alloc
           (Subtype_For_Refinement_Decl, Access_To_Subtype_For_Refinement_Decl);

         function Allocate_Refinement_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Refinement_Decl;

         function Allocate_Refinement_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Refinement_Decl
         is
            Result      : constant Access_To_Subtype_For_Refinement_Decl := Bare_Refinement_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Refinement_Decl;
            return Bare_Refinement_Decl (Result);
         end Allocate_Refinement_Decl;

      package Bare_Session_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Session_Decl, Token_Index);

         
         subtype Subtype_For_Session_Decl is
            Root_Node_Record (RFLX_Session_Decl);
         type Access_To_Subtype_For_Session_Decl is access all Subtype_For_Session_Decl;
         package Bare_Session_Decl_Alloc is new Alloc
           (Subtype_For_Session_Decl, Access_To_Subtype_For_Session_Decl);

         function Allocate_Session_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Session_Decl;

         function Allocate_Session_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Session_Decl
         is
            Result      : constant Access_To_Subtype_For_Session_Decl := Bare_Session_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Session_Decl;
            return Bare_Session_Decl (Result);
         end Allocate_Session_Decl;

      package Bare_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Type_Decl, Token_Index);

         
         subtype Subtype_For_Type_Decl is
            Root_Node_Record (RFLX_Type_Decl);
         type Access_To_Subtype_For_Type_Decl is access all Subtype_For_Type_Decl;
         package Bare_Type_Decl_Alloc is new Alloc
           (Subtype_For_Type_Decl, Access_To_Subtype_For_Type_Decl);

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl;

         function Allocate_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Type_Decl := Bare_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Type_Decl;
            return Bare_Type_Decl (Result);
         end Allocate_Type_Decl;

      package Bare_Description_Memos is new Langkit_Support.Packrat
        (Bare_Description, Token_Index);

         
         subtype Subtype_For_Description is
            Root_Node_Record (RFLX_Description);
         type Access_To_Subtype_For_Description is access all Subtype_For_Description;
         package Bare_Description_Alloc is new Alloc
           (Subtype_For_Description, Access_To_Subtype_For_Description);

         function Allocate_Description
           (Pool : Bump_Ptr_Pool) return Bare_Description;

         function Allocate_Description
           (Pool : Bump_Ptr_Pool) return Bare_Description
         is
            Result      : constant Access_To_Subtype_For_Description := Bare_Description_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Description;
            return Bare_Description (Result);
         end Allocate_Description;

      package Bare_Element_Value_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Element_Value_Assoc, Token_Index);

         
         subtype Subtype_For_Element_Value_Assoc is
            Root_Node_Record (RFLX_Element_Value_Assoc);
         type Access_To_Subtype_For_Element_Value_Assoc is access all Subtype_For_Element_Value_Assoc;
         package Bare_Element_Value_Assoc_Alloc is new Alloc
           (Subtype_For_Element_Value_Assoc, Access_To_Subtype_For_Element_Value_Assoc);

         function Allocate_Element_Value_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc;

         function Allocate_Element_Value_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc
         is
            Result      : constant Access_To_Subtype_For_Element_Value_Assoc := Bare_Element_Value_Assoc_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Element_Value_Assoc;
            return Bare_Element_Value_Assoc (Result);
         end Allocate_Element_Value_Assoc;

      package Bare_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Expr, Token_Index);

      package Bare_Attribute_Memos is new Langkit_Support.Packrat
        (Bare_Attribute, Token_Index);

         
         subtype Subtype_For_Attribute is
            Root_Node_Record (RFLX_Attribute);
         type Access_To_Subtype_For_Attribute is access all Subtype_For_Attribute;
         package Bare_Attribute_Alloc is new Alloc
           (Subtype_For_Attribute, Access_To_Subtype_For_Attribute);

         function Allocate_Attribute
           (Pool : Bump_Ptr_Pool) return Bare_Attribute;

         function Allocate_Attribute
           (Pool : Bump_Ptr_Pool) return Bare_Attribute
         is
            Result      : constant Access_To_Subtype_For_Attribute := Bare_Attribute_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attribute;
            return Bare_Attribute (Result);
         end Allocate_Attribute;

      package Bare_Bin_Op_Memos is new Langkit_Support.Packrat
        (Bare_Bin_Op, Token_Index);

         
         subtype Subtype_For_Bin_Op is
            Root_Node_Record (RFLX_Bin_Op);
         type Access_To_Subtype_For_Bin_Op is access all Subtype_For_Bin_Op;
         package Bare_Bin_Op_Alloc is new Alloc
           (Subtype_For_Bin_Op, Access_To_Subtype_For_Bin_Op);

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op;

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op
         is
            Result      : constant Access_To_Subtype_For_Bin_Op := Bare_Bin_Op_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Bin_Op;
            return Bare_Bin_Op (Result);
         end Allocate_Bin_Op;

      package Bare_Binding_Memos is new Langkit_Support.Packrat
        (Bare_Binding, Token_Index);

         
         subtype Subtype_For_Binding is
            Root_Node_Record (RFLX_Binding);
         type Access_To_Subtype_For_Binding is access all Subtype_For_Binding;
         package Bare_Binding_Alloc is new Alloc
           (Subtype_For_Binding, Access_To_Subtype_For_Binding);

         function Allocate_Binding
           (Pool : Bump_Ptr_Pool) return Bare_Binding;

         function Allocate_Binding
           (Pool : Bump_Ptr_Pool) return Bare_Binding
         is
            Result      : constant Access_To_Subtype_For_Binding := Bare_Binding_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Binding;
            return Bare_Binding (Result);
         end Allocate_Binding;

      package Bare_Call_Memos is new Langkit_Support.Packrat
        (Bare_Call, Token_Index);

         
         subtype Subtype_For_Call is
            Root_Node_Record (RFLX_Call);
         type Access_To_Subtype_For_Call is access all Subtype_For_Call;
         package Bare_Call_Alloc is new Alloc
           (Subtype_For_Call, Access_To_Subtype_For_Call);

         function Allocate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Call;

         function Allocate_Call
           (Pool : Bump_Ptr_Pool) return Bare_Call
         is
            Result      : constant Access_To_Subtype_For_Call := Bare_Call_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Call;
            return Bare_Call (Result);
         end Allocate_Call;

      package Bare_Case_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expression, Token_Index);

         
         subtype Subtype_For_Case_Expression is
            Root_Node_Record (RFLX_Case_Expression);
         type Access_To_Subtype_For_Case_Expression is access all Subtype_For_Case_Expression;
         package Bare_Case_Expression_Alloc is new Alloc
           (Subtype_For_Case_Expression, Access_To_Subtype_For_Case_Expression);

         function Allocate_Case_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expression;

         function Allocate_Case_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expression
         is
            Result      : constant Access_To_Subtype_For_Case_Expression := Bare_Case_Expression_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Case_Expression;
            return Bare_Case_Expression (Result);
         end Allocate_Case_Expression;

      package Bare_Choice_Memos is new Langkit_Support.Packrat
        (Bare_Choice, Token_Index);

         
         subtype Subtype_For_Choice is
            Root_Node_Record (RFLX_Choice);
         type Access_To_Subtype_For_Choice is access all Subtype_For_Choice;
         package Bare_Choice_Alloc is new Alloc
           (Subtype_For_Choice, Access_To_Subtype_For_Choice);

         function Allocate_Choice
           (Pool : Bump_Ptr_Pool) return Bare_Choice;

         function Allocate_Choice
           (Pool : Bump_Ptr_Pool) return Bare_Choice
         is
            Result      : constant Access_To_Subtype_For_Choice := Bare_Choice_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Choice;
            return Bare_Choice (Result);
         end Allocate_Choice;

      package Bare_Comprehension_Memos is new Langkit_Support.Packrat
        (Bare_Comprehension, Token_Index);

         
         subtype Subtype_For_Comprehension is
            Root_Node_Record (RFLX_Comprehension);
         type Access_To_Subtype_For_Comprehension is access all Subtype_For_Comprehension;
         package Bare_Comprehension_Alloc is new Alloc
           (Subtype_For_Comprehension, Access_To_Subtype_For_Comprehension);

         function Allocate_Comprehension
           (Pool : Bump_Ptr_Pool) return Bare_Comprehension;

         function Allocate_Comprehension
           (Pool : Bump_Ptr_Pool) return Bare_Comprehension
         is
            Result      : constant Access_To_Subtype_For_Comprehension := Bare_Comprehension_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Comprehension;
            return Bare_Comprehension (Result);
         end Allocate_Comprehension;

      package Bare_Context_Item_Memos is new Langkit_Support.Packrat
        (Bare_Context_Item, Token_Index);

         
         subtype Subtype_For_Context_Item is
            Root_Node_Record (RFLX_Context_Item);
         type Access_To_Subtype_For_Context_Item is access all Subtype_For_Context_Item;
         package Bare_Context_Item_Alloc is new Alloc
           (Subtype_For_Context_Item, Access_To_Subtype_For_Context_Item);

         function Allocate_Context_Item
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item;

         function Allocate_Context_Item
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item
         is
            Result      : constant Access_To_Subtype_For_Context_Item := Bare_Context_Item_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Context_Item;
            return Bare_Context_Item (Result);
         end Allocate_Context_Item;

      package Bare_Conversion_Memos is new Langkit_Support.Packrat
        (Bare_Conversion, Token_Index);

         
         subtype Subtype_For_Conversion is
            Root_Node_Record (RFLX_Conversion);
         type Access_To_Subtype_For_Conversion is access all Subtype_For_Conversion;
         package Bare_Conversion_Alloc is new Alloc
           (Subtype_For_Conversion, Access_To_Subtype_For_Conversion);

         function Allocate_Conversion
           (Pool : Bump_Ptr_Pool) return Bare_Conversion;

         function Allocate_Conversion
           (Pool : Bump_Ptr_Pool) return Bare_Conversion
         is
            Result      : constant Access_To_Subtype_For_Conversion := Bare_Conversion_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Conversion;
            return Bare_Conversion (Result);
         end Allocate_Conversion;

      package Bare_Message_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate, Token_Index);

         
         subtype Subtype_For_Message_Aggregate is
            Root_Node_Record (RFLX_Message_Aggregate);
         type Access_To_Subtype_For_Message_Aggregate is access all Subtype_For_Message_Aggregate;
         package Bare_Message_Aggregate_Alloc is new Alloc
           (Subtype_For_Message_Aggregate, Access_To_Subtype_For_Message_Aggregate);

         function Allocate_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate;

         function Allocate_Message_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate := Bare_Message_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Aggregate;
            return Bare_Message_Aggregate (Result);
         end Allocate_Message_Aggregate;

      package Bare_Negation_Memos is new Langkit_Support.Packrat
        (Bare_Negation, Token_Index);

         
         subtype Subtype_For_Negation is
            Root_Node_Record (RFLX_Negation);
         type Access_To_Subtype_For_Negation is access all Subtype_For_Negation;
         package Bare_Negation_Alloc is new Alloc
           (Subtype_For_Negation, Access_To_Subtype_For_Negation);

         function Allocate_Negation
           (Pool : Bump_Ptr_Pool) return Bare_Negation;

         function Allocate_Negation
           (Pool : Bump_Ptr_Pool) return Bare_Negation
         is
            Result      : constant Access_To_Subtype_For_Negation := Bare_Negation_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Negation;
            return Bare_Negation (Result);
         end Allocate_Negation;

      package Bare_Numeric_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Numeric_Literal, Token_Index);

         
         subtype Subtype_For_Numeric_Literal is
            Root_Node_Record (RFLX_Numeric_Literal);
         type Access_To_Subtype_For_Numeric_Literal is access all Subtype_For_Numeric_Literal;
         package Bare_Numeric_Literal_Alloc is new Alloc
           (Subtype_For_Numeric_Literal, Access_To_Subtype_For_Numeric_Literal);

         function Allocate_Numeric_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal;

         function Allocate_Numeric_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal
         is
            Result      : constant Access_To_Subtype_For_Numeric_Literal := Bare_Numeric_Literal_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Numeric_Literal;
            return Bare_Numeric_Literal (Result);
         end Allocate_Numeric_Literal;

      package Bare_Paren_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Paren_Expression, Token_Index);

         
         subtype Subtype_For_Paren_Expression is
            Root_Node_Record (RFLX_Paren_Expression);
         type Access_To_Subtype_For_Paren_Expression is access all Subtype_For_Paren_Expression;
         package Bare_Paren_Expression_Alloc is new Alloc
           (Subtype_For_Paren_Expression, Access_To_Subtype_For_Paren_Expression);

         function Allocate_Paren_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expression;

         function Allocate_Paren_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expression
         is
            Result      : constant Access_To_Subtype_For_Paren_Expression := Bare_Paren_Expression_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Paren_Expression;
            return Bare_Paren_Expression (Result);
         end Allocate_Paren_Expression;

      package Bare_Quantified_Expression_Memos is new Langkit_Support.Packrat
        (Bare_Quantified_Expression, Token_Index);

         
         subtype Subtype_For_Quantified_Expression is
            Root_Node_Record (RFLX_Quantified_Expression);
         type Access_To_Subtype_For_Quantified_Expression is access all Subtype_For_Quantified_Expression;
         package Bare_Quantified_Expression_Alloc is new Alloc
           (Subtype_For_Quantified_Expression, Access_To_Subtype_For_Quantified_Expression);

         function Allocate_Quantified_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expression;

         function Allocate_Quantified_Expression
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expression
         is
            Result      : constant Access_To_Subtype_For_Quantified_Expression := Bare_Quantified_Expression_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Quantified_Expression;
            return Bare_Quantified_Expression (Result);
         end Allocate_Quantified_Expression;

      package Bare_Select_Node_Memos is new Langkit_Support.Packrat
        (Bare_Select_Node, Token_Index);

         
         subtype Subtype_For_Select_Node is
            Root_Node_Record (RFLX_Select_Node);
         type Access_To_Subtype_For_Select_Node is access all Subtype_For_Select_Node;
         package Bare_Select_Node_Alloc is new Alloc
           (Subtype_For_Select_Node, Access_To_Subtype_For_Select_Node);

         function Allocate_Select_Node
           (Pool : Bump_Ptr_Pool) return Bare_Select_Node;

         function Allocate_Select_Node
           (Pool : Bump_Ptr_Pool) return Bare_Select_Node
         is
            Result      : constant Access_To_Subtype_For_Select_Node := Bare_Select_Node_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Select_Node;
            return Bare_Select_Node (Result);
         end Allocate_Select_Node;

      package Bare_Sequence_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Literal, Token_Index);

      package Bare_Concatenation_Memos is new Langkit_Support.Packrat
        (Bare_Concatenation, Token_Index);

         
         subtype Subtype_For_Concatenation is
            Root_Node_Record (RFLX_Concatenation);
         type Access_To_Subtype_For_Concatenation is access all Subtype_For_Concatenation;
         package Bare_Concatenation_Alloc is new Alloc
           (Subtype_For_Concatenation, Access_To_Subtype_For_Concatenation);

         function Allocate_Concatenation
           (Pool : Bump_Ptr_Pool) return Bare_Concatenation;

         function Allocate_Concatenation
           (Pool : Bump_Ptr_Pool) return Bare_Concatenation
         is
            Result      : constant Access_To_Subtype_For_Concatenation := Bare_Concatenation_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Concatenation;
            return Bare_Concatenation (Result);
         end Allocate_Concatenation;

      package Bare_Sequence_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Aggregate, Token_Index);

         
         subtype Subtype_For_Sequence_Aggregate is
            Root_Node_Record (RFLX_Sequence_Aggregate);
         type Access_To_Subtype_For_Sequence_Aggregate is access all Subtype_For_Sequence_Aggregate;
         package Bare_Sequence_Aggregate_Alloc is new Alloc
           (Subtype_For_Sequence_Aggregate, Access_To_Subtype_For_Sequence_Aggregate);

         function Allocate_Sequence_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Aggregate;

         function Allocate_Sequence_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Sequence_Aggregate := Bare_Sequence_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Sequence_Aggregate;
            return Bare_Sequence_Aggregate (Result);
         end Allocate_Sequence_Aggregate;

      package Bare_String_Literal_Memos is new Langkit_Support.Packrat
        (Bare_String_Literal, Token_Index);

         
         subtype Subtype_For_String_Literal is
            Root_Node_Record (RFLX_String_Literal);
         type Access_To_Subtype_For_String_Literal is access all Subtype_For_String_Literal;
         package Bare_String_Literal_Alloc is new Alloc
           (Subtype_For_String_Literal, Access_To_Subtype_For_String_Literal);

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal;

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal
         is
            Result      : constant Access_To_Subtype_For_String_Literal := Bare_String_Literal_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_String_Literal;
            return Bare_String_Literal (Result);
         end Allocate_String_Literal;

      package Bare_Variable_Memos is new Langkit_Support.Packrat
        (Bare_Variable, Token_Index);

         
         subtype Subtype_For_Variable is
            Root_Node_Record (RFLX_Variable);
         type Access_To_Subtype_For_Variable is access all Subtype_For_Variable;
         package Bare_Variable_Alloc is new Alloc
           (Subtype_For_Variable, Access_To_Subtype_For_Variable);

         function Allocate_Variable
           (Pool : Bump_Ptr_Pool) return Bare_Variable;

         function Allocate_Variable
           (Pool : Bump_Ptr_Pool) return Bare_Variable
         is
            Result      : constant Access_To_Subtype_For_Variable := Bare_Variable_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Variable;
            return Bare_Variable (Result);
         end Allocate_Variable;

      package Bare_Formal_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Decl, Token_Index);

      package Bare_Formal_Channel_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Channel_Decl, Token_Index);

         
         subtype Subtype_For_Formal_Channel_Decl is
            Root_Node_Record (RFLX_Formal_Channel_Decl);
         type Access_To_Subtype_For_Formal_Channel_Decl is access all Subtype_For_Formal_Channel_Decl;
         package Bare_Formal_Channel_Decl_Alloc is new Alloc
           (Subtype_For_Formal_Channel_Decl, Access_To_Subtype_For_Formal_Channel_Decl);

         function Allocate_Formal_Channel_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Channel_Decl;

         function Allocate_Formal_Channel_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Channel_Decl
         is
            Result      : constant Access_To_Subtype_For_Formal_Channel_Decl := Bare_Formal_Channel_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Formal_Channel_Decl;
            return Bare_Formal_Channel_Decl (Result);
         end Allocate_Formal_Channel_Decl;

      package Bare_Formal_Function_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Function_Decl, Token_Index);

         
         subtype Subtype_For_Formal_Function_Decl is
            Root_Node_Record (RFLX_Formal_Function_Decl);
         type Access_To_Subtype_For_Formal_Function_Decl is access all Subtype_For_Formal_Function_Decl;
         package Bare_Formal_Function_Decl_Alloc is new Alloc
           (Subtype_For_Formal_Function_Decl, Access_To_Subtype_For_Formal_Function_Decl);

         function Allocate_Formal_Function_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Function_Decl;

         function Allocate_Formal_Function_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Function_Decl
         is
            Result      : constant Access_To_Subtype_For_Formal_Function_Decl := Bare_Formal_Function_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Formal_Function_Decl;
            return Bare_Formal_Function_Decl (Result);
         end Allocate_Formal_Function_Decl;

      package Bare_Local_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Local_Decl, Token_Index);

      package Bare_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Renaming_Decl is
            Root_Node_Record (RFLX_Renaming_Decl);
         type Access_To_Subtype_For_Renaming_Decl is access all Subtype_For_Renaming_Decl;
         package Bare_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Renaming_Decl, Access_To_Subtype_For_Renaming_Decl);

         function Allocate_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Decl;

         function Allocate_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Renaming_Decl := Bare_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Renaming_Decl;
            return Bare_Renaming_Decl (Result);
         end Allocate_Renaming_Decl;

      package Bare_Variable_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Variable_Decl, Token_Index);

         
         subtype Subtype_For_Variable_Decl is
            Root_Node_Record (RFLX_Variable_Decl);
         type Access_To_Subtype_For_Variable_Decl is access all Subtype_For_Variable_Decl;
         package Bare_Variable_Decl_Alloc is new Alloc
           (Subtype_For_Variable_Decl, Access_To_Subtype_For_Variable_Decl);

         function Allocate_Variable_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Variable_Decl;

         function Allocate_Variable_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Variable_Decl
         is
            Result      : constant Access_To_Subtype_For_Variable_Decl := Bare_Variable_Decl_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Variable_Decl;
            return Bare_Variable_Decl (Result);
         end Allocate_Variable_Decl;

      package Bare_Message_Aggregate_Association_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Association, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Association is
            Root_Node_Record (RFLX_Message_Aggregate_Association);
         type Access_To_Subtype_For_Message_Aggregate_Association is access all Subtype_For_Message_Aggregate_Association;
         package Bare_Message_Aggregate_Association_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Association, Access_To_Subtype_For_Message_Aggregate_Association);

         function Allocate_Message_Aggregate_Association
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association;

         function Allocate_Message_Aggregate_Association
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Association := Bare_Message_Aggregate_Association_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Aggregate_Association;
            return Bare_Message_Aggregate_Association (Result);
         end Allocate_Message_Aggregate_Association;

      package Bare_Message_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aspect, Token_Index);

      package Bare_Byte_Order_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Byte_Order_Aspect, Token_Index);

         
         subtype Subtype_For_Byte_Order_Aspect is
            Root_Node_Record (RFLX_Byte_Order_Aspect);
         type Access_To_Subtype_For_Byte_Order_Aspect is access all Subtype_For_Byte_Order_Aspect;
         package Bare_Byte_Order_Aspect_Alloc is new Alloc
           (Subtype_For_Byte_Order_Aspect, Access_To_Subtype_For_Byte_Order_Aspect);

         function Allocate_Byte_Order_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Aspect;

         function Allocate_Byte_Order_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Byte_Order_Aspect
         is
            Result      : constant Access_To_Subtype_For_Byte_Order_Aspect := Bare_Byte_Order_Aspect_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Byte_Order_Aspect;
            return Bare_Byte_Order_Aspect (Result);
         end Allocate_Byte_Order_Aspect;

      package Bare_Checksum_Aspect_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Aspect, Token_Index);

         
         subtype Subtype_For_Checksum_Aspect is
            Root_Node_Record (RFLX_Checksum_Aspect);
         type Access_To_Subtype_For_Checksum_Aspect is access all Subtype_For_Checksum_Aspect;
         package Bare_Checksum_Aspect_Alloc is new Alloc
           (Subtype_For_Checksum_Aspect, Access_To_Subtype_For_Checksum_Aspect);

         function Allocate_Checksum_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Aspect;

         function Allocate_Checksum_Aspect
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Aspect
         is
            Result      : constant Access_To_Subtype_For_Checksum_Aspect := Bare_Checksum_Aspect_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Checksum_Aspect;
            return Bare_Checksum_Aspect (Result);
         end Allocate_Checksum_Aspect;

      package Bare_Message_Field_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field, Token_Index);

         
         subtype Subtype_For_Message_Field is
            Root_Node_Record (RFLX_Message_Field);
         type Access_To_Subtype_For_Message_Field is access all Subtype_For_Message_Field;
         package Bare_Message_Field_Alloc is new Alloc
           (Subtype_For_Message_Field, Access_To_Subtype_For_Message_Field);

         function Allocate_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field;

         function Allocate_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field
         is
            Result      : constant Access_To_Subtype_For_Message_Field := Bare_Message_Field_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Field;
            return Bare_Message_Field (Result);
         end Allocate_Message_Field;

      package Bare_Message_Fields_Memos is new Langkit_Support.Packrat
        (Bare_Message_Fields, Token_Index);

         
         subtype Subtype_For_Message_Fields is
            Root_Node_Record (RFLX_Message_Fields);
         type Access_To_Subtype_For_Message_Fields is access all Subtype_For_Message_Fields;
         package Bare_Message_Fields_Alloc is new Alloc
           (Subtype_For_Message_Fields, Access_To_Subtype_For_Message_Fields);

         function Allocate_Message_Fields
           (Pool : Bump_Ptr_Pool) return Bare_Message_Fields;

         function Allocate_Message_Fields
           (Pool : Bump_Ptr_Pool) return Bare_Message_Fields
         is
            Result      : constant Access_To_Subtype_For_Message_Fields := Bare_Message_Fields_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Fields;
            return Bare_Message_Fields (Result);
         end Allocate_Message_Fields;

      package Bare_Null_Message_Field_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Field, Token_Index);

         
         subtype Subtype_For_Null_Message_Field is
            Root_Node_Record (RFLX_Null_Message_Field);
         type Access_To_Subtype_For_Null_Message_Field is access all Subtype_For_Null_Message_Field;
         package Bare_Null_Message_Field_Alloc is new Alloc
           (Subtype_For_Null_Message_Field, Access_To_Subtype_For_Null_Message_Field);

         function Allocate_Null_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Field;

         function Allocate_Null_Message_Field
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Field
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Field := Bare_Null_Message_Field_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Null_Message_Field;
            return Bare_Null_Message_Field (Result);
         end Allocate_Null_Message_Field;

      package Bare_Op_Memos is new Langkit_Support.Packrat
        (Bare_Op, Token_Index);

      package Bare_Op_Add_Memos is new Langkit_Support.Packrat
        (Bare_Op_Add, Token_Index);

         
         subtype Subtype_For_Op_Add is
            Root_Node_Record (RFLX_Op_Add);
         type Access_To_Subtype_For_Op_Add is access all Subtype_For_Op_Add;
         package Bare_Op_Add_Alloc is new Alloc
           (Subtype_For_Op_Add, Access_To_Subtype_For_Op_Add);

         function Allocate_Op_Add
           (Pool : Bump_Ptr_Pool) return Bare_Op_Add;

         function Allocate_Op_Add
           (Pool : Bump_Ptr_Pool) return Bare_Op_Add
         is
            Result      : constant Access_To_Subtype_For_Op_Add := Bare_Op_Add_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Add;
            return Bare_Op_Add (Result);
         end Allocate_Op_Add;

      package Bare_Op_And_Memos is new Langkit_Support.Packrat
        (Bare_Op_And, Token_Index);

         
         subtype Subtype_For_Op_And is
            Root_Node_Record (RFLX_Op_And);
         type Access_To_Subtype_For_Op_And is access all Subtype_For_Op_And;
         package Bare_Op_And_Alloc is new Alloc
           (Subtype_For_Op_And, Access_To_Subtype_For_Op_And);

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And;

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And
         is
            Result      : constant Access_To_Subtype_For_Op_And := Bare_Op_And_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_And;
            return Bare_Op_And (Result);
         end Allocate_Op_And;

      package Bare_Op_Div_Memos is new Langkit_Support.Packrat
        (Bare_Op_Div, Token_Index);

         
         subtype Subtype_For_Op_Div is
            Root_Node_Record (RFLX_Op_Div);
         type Access_To_Subtype_For_Op_Div is access all Subtype_For_Op_Div;
         package Bare_Op_Div_Alloc is new Alloc
           (Subtype_For_Op_Div, Access_To_Subtype_For_Op_Div);

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div;

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div
         is
            Result      : constant Access_To_Subtype_For_Op_Div := Bare_Op_Div_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Div;
            return Bare_Op_Div (Result);
         end Allocate_Op_Div;

      package Bare_Op_Eq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Eq, Token_Index);

         
         subtype Subtype_For_Op_Eq is
            Root_Node_Record (RFLX_Op_Eq);
         type Access_To_Subtype_For_Op_Eq is access all Subtype_For_Op_Eq;
         package Bare_Op_Eq_Alloc is new Alloc
           (Subtype_For_Op_Eq, Access_To_Subtype_For_Op_Eq);

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq;

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq
         is
            Result      : constant Access_To_Subtype_For_Op_Eq := Bare_Op_Eq_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Eq;
            return Bare_Op_Eq (Result);
         end Allocate_Op_Eq;

      package Bare_Op_Ge_Memos is new Langkit_Support.Packrat
        (Bare_Op_Ge, Token_Index);

         
         subtype Subtype_For_Op_Ge is
            Root_Node_Record (RFLX_Op_Ge);
         type Access_To_Subtype_For_Op_Ge is access all Subtype_For_Op_Ge;
         package Bare_Op_Ge_Alloc is new Alloc
           (Subtype_For_Op_Ge, Access_To_Subtype_For_Op_Ge);

         function Allocate_Op_Ge
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ge;

         function Allocate_Op_Ge
           (Pool : Bump_Ptr_Pool) return Bare_Op_Ge
         is
            Result      : constant Access_To_Subtype_For_Op_Ge := Bare_Op_Ge_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Ge;
            return Bare_Op_Ge (Result);
         end Allocate_Op_Ge;

      package Bare_Op_Gt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gt, Token_Index);

         
         subtype Subtype_For_Op_Gt is
            Root_Node_Record (RFLX_Op_Gt);
         type Access_To_Subtype_For_Op_Gt is access all Subtype_For_Op_Gt;
         package Bare_Op_Gt_Alloc is new Alloc
           (Subtype_For_Op_Gt, Access_To_Subtype_For_Op_Gt);

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt;

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt
         is
            Result      : constant Access_To_Subtype_For_Op_Gt := Bare_Op_Gt_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Gt;
            return Bare_Op_Gt (Result);
         end Allocate_Op_Gt;

      package Bare_Op_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_In, Token_Index);

         
         subtype Subtype_For_Op_In is
            Root_Node_Record (RFLX_Op_In);
         type Access_To_Subtype_For_Op_In is access all Subtype_For_Op_In;
         package Bare_Op_In_Alloc is new Alloc
           (Subtype_For_Op_In, Access_To_Subtype_For_Op_In);

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In;

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In
         is
            Result      : constant Access_To_Subtype_For_Op_In := Bare_Op_In_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_In;
            return Bare_Op_In (Result);
         end Allocate_Op_In;

      package Bare_Op_Le_Memos is new Langkit_Support.Packrat
        (Bare_Op_Le, Token_Index);

         
         subtype Subtype_For_Op_Le is
            Root_Node_Record (RFLX_Op_Le);
         type Access_To_Subtype_For_Op_Le is access all Subtype_For_Op_Le;
         package Bare_Op_Le_Alloc is new Alloc
           (Subtype_For_Op_Le, Access_To_Subtype_For_Op_Le);

         function Allocate_Op_Le
           (Pool : Bump_Ptr_Pool) return Bare_Op_Le;

         function Allocate_Op_Le
           (Pool : Bump_Ptr_Pool) return Bare_Op_Le
         is
            Result      : constant Access_To_Subtype_For_Op_Le := Bare_Op_Le_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Le;
            return Bare_Op_Le (Result);
         end Allocate_Op_Le;

      package Bare_Op_Lt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lt, Token_Index);

         
         subtype Subtype_For_Op_Lt is
            Root_Node_Record (RFLX_Op_Lt);
         type Access_To_Subtype_For_Op_Lt is access all Subtype_For_Op_Lt;
         package Bare_Op_Lt_Alloc is new Alloc
           (Subtype_For_Op_Lt, Access_To_Subtype_For_Op_Lt);

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt;

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt
         is
            Result      : constant Access_To_Subtype_For_Op_Lt := Bare_Op_Lt_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Lt;
            return Bare_Op_Lt (Result);
         end Allocate_Op_Lt;

      package Bare_Op_Mod_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mod, Token_Index);

         
         subtype Subtype_For_Op_Mod is
            Root_Node_Record (RFLX_Op_Mod);
         type Access_To_Subtype_For_Op_Mod is access all Subtype_For_Op_Mod;
         package Bare_Op_Mod_Alloc is new Alloc
           (Subtype_For_Op_Mod, Access_To_Subtype_For_Op_Mod);

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod;

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod
         is
            Result      : constant Access_To_Subtype_For_Op_Mod := Bare_Op_Mod_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Mod;
            return Bare_Op_Mod (Result);
         end Allocate_Op_Mod;

      package Bare_Op_Mul_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mul, Token_Index);

         
         subtype Subtype_For_Op_Mul is
            Root_Node_Record (RFLX_Op_Mul);
         type Access_To_Subtype_For_Op_Mul is access all Subtype_For_Op_Mul;
         package Bare_Op_Mul_Alloc is new Alloc
           (Subtype_For_Op_Mul, Access_To_Subtype_For_Op_Mul);

         function Allocate_Op_Mul
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mul;

         function Allocate_Op_Mul
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mul
         is
            Result      : constant Access_To_Subtype_For_Op_Mul := Bare_Op_Mul_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Mul;
            return Bare_Op_Mul (Result);
         end Allocate_Op_Mul;

      package Bare_Op_Neq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Neq, Token_Index);

         
         subtype Subtype_For_Op_Neq is
            Root_Node_Record (RFLX_Op_Neq);
         type Access_To_Subtype_For_Op_Neq is access all Subtype_For_Op_Neq;
         package Bare_Op_Neq_Alloc is new Alloc
           (Subtype_For_Op_Neq, Access_To_Subtype_For_Op_Neq);

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq;

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq
         is
            Result      : constant Access_To_Subtype_For_Op_Neq := Bare_Op_Neq_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Neq;
            return Bare_Op_Neq (Result);
         end Allocate_Op_Neq;

      package Bare_Op_Notin_Memos is new Langkit_Support.Packrat
        (Bare_Op_Notin, Token_Index);

         
         subtype Subtype_For_Op_Notin is
            Root_Node_Record (RFLX_Op_Notin);
         type Access_To_Subtype_For_Op_Notin is access all Subtype_For_Op_Notin;
         package Bare_Op_Notin_Alloc is new Alloc
           (Subtype_For_Op_Notin, Access_To_Subtype_For_Op_Notin);

         function Allocate_Op_Notin
           (Pool : Bump_Ptr_Pool) return Bare_Op_Notin;

         function Allocate_Op_Notin
           (Pool : Bump_Ptr_Pool) return Bare_Op_Notin
         is
            Result      : constant Access_To_Subtype_For_Op_Notin := Bare_Op_Notin_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Notin;
            return Bare_Op_Notin (Result);
         end Allocate_Op_Notin;

      package Bare_Op_Or_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or, Token_Index);

         
         subtype Subtype_For_Op_Or is
            Root_Node_Record (RFLX_Op_Or);
         type Access_To_Subtype_For_Op_Or is access all Subtype_For_Op_Or;
         package Bare_Op_Or_Alloc is new Alloc
           (Subtype_For_Op_Or, Access_To_Subtype_For_Op_Or);

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or;

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Or := Bare_Op_Or_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Or;
            return Bare_Op_Or (Result);
         end Allocate_Op_Or;

      package Bare_Op_Pow_Memos is new Langkit_Support.Packrat
        (Bare_Op_Pow, Token_Index);

         
         subtype Subtype_For_Op_Pow is
            Root_Node_Record (RFLX_Op_Pow);
         type Access_To_Subtype_For_Op_Pow is access all Subtype_For_Op_Pow;
         package Bare_Op_Pow_Alloc is new Alloc
           (Subtype_For_Op_Pow, Access_To_Subtype_For_Op_Pow);

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow;

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow
         is
            Result      : constant Access_To_Subtype_For_Op_Pow := Bare_Op_Pow_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Pow;
            return Bare_Op_Pow (Result);
         end Allocate_Op_Pow;

      package Bare_Op_Sub_Memos is new Langkit_Support.Packrat
        (Bare_Op_Sub, Token_Index);

         
         subtype Subtype_For_Op_Sub is
            Root_Node_Record (RFLX_Op_Sub);
         type Access_To_Subtype_For_Op_Sub is access all Subtype_For_Op_Sub;
         package Bare_Op_Sub_Alloc is new Alloc
           (Subtype_For_Op_Sub, Access_To_Subtype_For_Op_Sub);

         function Allocate_Op_Sub
           (Pool : Bump_Ptr_Pool) return Bare_Op_Sub;

         function Allocate_Op_Sub
           (Pool : Bump_Ptr_Pool) return Bare_Op_Sub
         is
            Result      : constant Access_To_Subtype_For_Op_Sub := Bare_Op_Sub_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Op_Sub;
            return Bare_Op_Sub (Result);
         end Allocate_Op_Sub;

      package Bare_Package_Node_Memos is new Langkit_Support.Packrat
        (Bare_Package_Node, Token_Index);

         
         subtype Subtype_For_Package_Node is
            Root_Node_Record (RFLX_Package_Node);
         type Access_To_Subtype_For_Package_Node is access all Subtype_For_Package_Node;
         package Bare_Package_Node_Alloc is new Alloc
           (Subtype_For_Package_Node, Access_To_Subtype_For_Package_Node);

         function Allocate_Package_Node
           (Pool : Bump_Ptr_Pool) return Bare_Package_Node;

         function Allocate_Package_Node
           (Pool : Bump_Ptr_Pool) return Bare_Package_Node
         is
            Result      : constant Access_To_Subtype_For_Package_Node := Bare_Package_Node_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Package_Node;
            return Bare_Package_Node (Result);
         end Allocate_Package_Node;

      package Bare_Parameter_Memos is new Langkit_Support.Packrat
        (Bare_Parameter, Token_Index);

         
         subtype Subtype_For_Parameter is
            Root_Node_Record (RFLX_Parameter);
         type Access_To_Subtype_For_Parameter is access all Subtype_For_Parameter;
         package Bare_Parameter_Alloc is new Alloc
           (Subtype_For_Parameter, Access_To_Subtype_For_Parameter);

         function Allocate_Parameter
           (Pool : Bump_Ptr_Pool) return Bare_Parameter;

         function Allocate_Parameter
           (Pool : Bump_Ptr_Pool) return Bare_Parameter
         is
            Result      : constant Access_To_Subtype_For_Parameter := Bare_Parameter_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Parameter;
            return Bare_Parameter (Result);
         end Allocate_Parameter;

      package Bare_Parameters_Memos is new Langkit_Support.Packrat
        (Bare_Parameters, Token_Index);

         
         subtype Subtype_For_Parameters is
            Root_Node_Record (RFLX_Parameters);
         type Access_To_Subtype_For_Parameters is access all Subtype_For_Parameters;
         package Bare_Parameters_Alloc is new Alloc
           (Subtype_For_Parameters, Access_To_Subtype_For_Parameters);

         function Allocate_Parameters
           (Pool : Bump_Ptr_Pool) return Bare_Parameters;

         function Allocate_Parameters
           (Pool : Bump_Ptr_Pool) return Bare_Parameters
         is
            Result      : constant Access_To_Subtype_For_Parameters := Bare_Parameters_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Parameters;
            return Bare_Parameters (Result);
         end Allocate_Parameters;

      package Bare_Quantifier_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier, Token_Index);

      package Bare_Quantifier_All_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_All, Token_Index);

         
         subtype Subtype_For_Quantifier_All is
            Root_Node_Record (RFLX_Quantifier_All);
         type Access_To_Subtype_For_Quantifier_All is access all Subtype_For_Quantifier_All;
         package Bare_Quantifier_All_Alloc is new Alloc
           (Subtype_For_Quantifier_All, Access_To_Subtype_For_Quantifier_All);

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All;

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All
         is
            Result      : constant Access_To_Subtype_For_Quantifier_All := Bare_Quantifier_All_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Quantifier_All;
            return Bare_Quantifier_All (Result);
         end Allocate_Quantifier_All;

      package Bare_Quantifier_Some_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_Some, Token_Index);

         
         subtype Subtype_For_Quantifier_Some is
            Root_Node_Record (RFLX_Quantifier_Some);
         type Access_To_Subtype_For_Quantifier_Some is access all Subtype_For_Quantifier_Some;
         package Bare_Quantifier_Some_Alloc is new Alloc
           (Subtype_For_Quantifier_Some, Access_To_Subtype_For_Quantifier_Some);

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some;

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some
         is
            Result      : constant Access_To_Subtype_For_Quantifier_Some := Bare_Quantifier_Some_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Quantifier_Some;
            return Bare_Quantifier_Some (Result);
         end Allocate_Quantifier_Some;

      package Bare_RFLX_Node_Base_List_Memos is new Langkit_Support.Packrat
        (Bare_RFLX_Node_Base_List, Token_Index);

      package Bare_Aspect_List_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_List, Token_Index);

         
         subtype Subtype_For_Aspect_List is
            Root_Node_Record (RFLX_Aspect_List);
         type Access_To_Subtype_For_Aspect_List is access all Subtype_For_Aspect_List;
         package Bare_Aspect_List_Alloc is new Alloc
           (Subtype_For_Aspect_List, Access_To_Subtype_For_Aspect_List);

         function Allocate_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_List;

         function Allocate_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_List
         is
            Result      : constant Access_To_Subtype_For_Aspect_List := Bare_Aspect_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Aspect_List;
            return Bare_Aspect_List (Result);
         end Allocate_Aspect_List;

      package Bare_Base_Checksum_Val_List_Memos is new Langkit_Support.Packrat
        (Bare_Base_Checksum_Val_List, Token_Index);

         
         subtype Subtype_For_Base_Checksum_Val_List is
            Root_Node_Record (RFLX_Base_Checksum_Val_List);
         type Access_To_Subtype_For_Base_Checksum_Val_List is access all Subtype_For_Base_Checksum_Val_List;
         package Bare_Base_Checksum_Val_List_Alloc is new Alloc
           (Subtype_For_Base_Checksum_Val_List, Access_To_Subtype_For_Base_Checksum_Val_List);

         function Allocate_Base_Checksum_Val_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Checksum_Val_List;

         function Allocate_Base_Checksum_Val_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Checksum_Val_List
         is
            Result      : constant Access_To_Subtype_For_Base_Checksum_Val_List := Bare_Base_Checksum_Val_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Base_Checksum_Val_List;
            return Bare_Base_Checksum_Val_List (Result);
         end Allocate_Base_Checksum_Val_List;

      package Bare_Channel_Attribute_List_Memos is new Langkit_Support.Packrat
        (Bare_Channel_Attribute_List, Token_Index);

         
         subtype Subtype_For_Channel_Attribute_List is
            Root_Node_Record (RFLX_Channel_Attribute_List);
         type Access_To_Subtype_For_Channel_Attribute_List is access all Subtype_For_Channel_Attribute_List;
         package Bare_Channel_Attribute_List_Alloc is new Alloc
           (Subtype_For_Channel_Attribute_List, Access_To_Subtype_For_Channel_Attribute_List);

         function Allocate_Channel_Attribute_List
           (Pool : Bump_Ptr_Pool) return Bare_Channel_Attribute_List;

         function Allocate_Channel_Attribute_List
           (Pool : Bump_Ptr_Pool) return Bare_Channel_Attribute_List
         is
            Result      : constant Access_To_Subtype_For_Channel_Attribute_List := Bare_Channel_Attribute_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Channel_Attribute_List;
            return Bare_Channel_Attribute_List (Result);
         end Allocate_Channel_Attribute_List;

      package Bare_Checksum_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Checksum_Assoc_List, Token_Index);

         
         subtype Subtype_For_Checksum_Assoc_List is
            Root_Node_Record (RFLX_Checksum_Assoc_List);
         type Access_To_Subtype_For_Checksum_Assoc_List is access all Subtype_For_Checksum_Assoc_List;
         package Bare_Checksum_Assoc_List_Alloc is new Alloc
           (Subtype_For_Checksum_Assoc_List, Access_To_Subtype_For_Checksum_Assoc_List);

         function Allocate_Checksum_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc_List;

         function Allocate_Checksum_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Checksum_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Checksum_Assoc_List := Bare_Checksum_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Checksum_Assoc_List;
            return Bare_Checksum_Assoc_List (Result);
         end Allocate_Checksum_Assoc_List;

      package Bare_Choice_List_Memos is new Langkit_Support.Packrat
        (Bare_Choice_List, Token_Index);

         
         subtype Subtype_For_Choice_List is
            Root_Node_Record (RFLX_Choice_List);
         type Access_To_Subtype_For_Choice_List is access all Subtype_For_Choice_List;
         package Bare_Choice_List_Alloc is new Alloc
           (Subtype_For_Choice_List, Access_To_Subtype_For_Choice_List);

         function Allocate_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Choice_List;

         function Allocate_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Choice_List
         is
            Result      : constant Access_To_Subtype_For_Choice_List := Bare_Choice_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Choice_List;
            return Bare_Choice_List (Result);
         end Allocate_Choice_List;

      package Bare_Conditional_Transition_List_Memos is new Langkit_Support.Packrat
        (Bare_Conditional_Transition_List, Token_Index);

         
         subtype Subtype_For_Conditional_Transition_List is
            Root_Node_Record (RFLX_Conditional_Transition_List);
         type Access_To_Subtype_For_Conditional_Transition_List is access all Subtype_For_Conditional_Transition_List;
         package Bare_Conditional_Transition_List_Alloc is new Alloc
           (Subtype_For_Conditional_Transition_List, Access_To_Subtype_For_Conditional_Transition_List);

         function Allocate_Conditional_Transition_List
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition_List;

         function Allocate_Conditional_Transition_List
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition_List
         is
            Result      : constant Access_To_Subtype_For_Conditional_Transition_List := Bare_Conditional_Transition_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Conditional_Transition_List;
            return Bare_Conditional_Transition_List (Result);
         end Allocate_Conditional_Transition_List;

      package Bare_Context_Item_List_Memos is new Langkit_Support.Packrat
        (Bare_Context_Item_List, Token_Index);

         
         subtype Subtype_For_Context_Item_List is
            Root_Node_Record (RFLX_Context_Item_List);
         type Access_To_Subtype_For_Context_Item_List is access all Subtype_For_Context_Item_List;
         package Bare_Context_Item_List_Alloc is new Alloc
           (Subtype_For_Context_Item_List, Access_To_Subtype_For_Context_Item_List);

         function Allocate_Context_Item_List
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item_List;

         function Allocate_Context_Item_List
           (Pool : Bump_Ptr_Pool) return Bare_Context_Item_List
         is
            Result      : constant Access_To_Subtype_For_Context_Item_List := Bare_Context_Item_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Context_Item_List;
            return Bare_Context_Item_List (Result);
         end Allocate_Context_Item_List;

      package Bare_Declaration_List_Memos is new Langkit_Support.Packrat
        (Bare_Declaration_List, Token_Index);

         
         subtype Subtype_For_Declaration_List is
            Root_Node_Record (RFLX_Declaration_List);
         type Access_To_Subtype_For_Declaration_List is access all Subtype_For_Declaration_List;
         package Bare_Declaration_List_Alloc is new Alloc
           (Subtype_For_Declaration_List, Access_To_Subtype_For_Declaration_List);

         function Allocate_Declaration_List
           (Pool : Bump_Ptr_Pool) return Bare_Declaration_List;

         function Allocate_Declaration_List
           (Pool : Bump_Ptr_Pool) return Bare_Declaration_List
         is
            Result      : constant Access_To_Subtype_For_Declaration_List := Bare_Declaration_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Declaration_List;
            return Bare_Declaration_List (Result);
         end Allocate_Declaration_List;

      package Bare_Element_Value_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Element_Value_Assoc_List, Token_Index);

         
         subtype Subtype_For_Element_Value_Assoc_List is
            Root_Node_Record (RFLX_Element_Value_Assoc_List);
         type Access_To_Subtype_For_Element_Value_Assoc_List is access all Subtype_For_Element_Value_Assoc_List;
         package Bare_Element_Value_Assoc_List_Alloc is new Alloc
           (Subtype_For_Element_Value_Assoc_List, Access_To_Subtype_For_Element_Value_Assoc_List);

         function Allocate_Element_Value_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc_List;

         function Allocate_Element_Value_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Element_Value_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Element_Value_Assoc_List := Bare_Element_Value_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Element_Value_Assoc_List;
            return Bare_Element_Value_Assoc_List (Result);
         end Allocate_Element_Value_Assoc_List;

      package Bare_Expr_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_List, Token_Index);

         
         subtype Subtype_For_Expr_List is
            Root_Node_Record (RFLX_Expr_List);
         type Access_To_Subtype_For_Expr_List is access all Subtype_For_Expr_List;
         package Bare_Expr_List_Alloc is new Alloc
           (Subtype_For_Expr_List, Access_To_Subtype_For_Expr_List);

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List;

         function Allocate_Expr_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_List
         is
            Result      : constant Access_To_Subtype_For_Expr_List := Bare_Expr_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Expr_List;
            return Bare_Expr_List (Result);
         end Allocate_Expr_List;

      package Bare_Formal_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Decl_List, Token_Index);

         
         subtype Subtype_For_Formal_Decl_List is
            Root_Node_Record (RFLX_Formal_Decl_List);
         type Access_To_Subtype_For_Formal_Decl_List is access all Subtype_For_Formal_Decl_List;
         package Bare_Formal_Decl_List_Alloc is new Alloc
           (Subtype_For_Formal_Decl_List, Access_To_Subtype_For_Formal_Decl_List);

         function Allocate_Formal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Decl_List;

         function Allocate_Formal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Formal_Decl_List := Bare_Formal_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Formal_Decl_List;
            return Bare_Formal_Decl_List (Result);
         end Allocate_Formal_Decl_List;

      package Bare_Local_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Local_Decl_List, Token_Index);

         
         subtype Subtype_For_Local_Decl_List is
            Root_Node_Record (RFLX_Local_Decl_List);
         type Access_To_Subtype_For_Local_Decl_List is access all Subtype_For_Local_Decl_List;
         package Bare_Local_Decl_List_Alloc is new Alloc
           (Subtype_For_Local_Decl_List, Access_To_Subtype_For_Local_Decl_List);

         function Allocate_Local_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Local_Decl_List;

         function Allocate_Local_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Local_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Local_Decl_List := Bare_Local_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Local_Decl_List;
            return Bare_Local_Decl_List (Result);
         end Allocate_Local_Decl_List;

      package Bare_Message_Aggregate_Association_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aggregate_Association_List, Token_Index);

         
         subtype Subtype_For_Message_Aggregate_Association_List is
            Root_Node_Record (RFLX_Message_Aggregate_Association_List);
         type Access_To_Subtype_For_Message_Aggregate_Association_List is access all Subtype_For_Message_Aggregate_Association_List;
         package Bare_Message_Aggregate_Association_List_Alloc is new Alloc
           (Subtype_For_Message_Aggregate_Association_List, Access_To_Subtype_For_Message_Aggregate_Association_List);

         function Allocate_Message_Aggregate_Association_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association_List;

         function Allocate_Message_Aggregate_Association_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aggregate_Association_List
         is
            Result      : constant Access_To_Subtype_For_Message_Aggregate_Association_List := Bare_Message_Aggregate_Association_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Aggregate_Association_List;
            return Bare_Message_Aggregate_Association_List (Result);
         end Allocate_Message_Aggregate_Association_List;

      package Bare_Message_Aspect_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Aspect_List, Token_Index);

         
         subtype Subtype_For_Message_Aspect_List is
            Root_Node_Record (RFLX_Message_Aspect_List);
         type Access_To_Subtype_For_Message_Aspect_List is access all Subtype_For_Message_Aspect_List;
         package Bare_Message_Aspect_List_Alloc is new Alloc
           (Subtype_For_Message_Aspect_List, Access_To_Subtype_For_Message_Aspect_List);

         function Allocate_Message_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aspect_List;

         function Allocate_Message_Aspect_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Aspect_List
         is
            Result      : constant Access_To_Subtype_For_Message_Aspect_List := Bare_Message_Aspect_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Aspect_List;
            return Bare_Message_Aspect_List (Result);
         end Allocate_Message_Aspect_List;

      package Bare_Message_Field_List_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field_List, Token_Index);

         
         subtype Subtype_For_Message_Field_List is
            Root_Node_Record (RFLX_Message_Field_List);
         type Access_To_Subtype_For_Message_Field_List is access all Subtype_For_Message_Field_List;
         package Bare_Message_Field_List_Alloc is new Alloc
           (Subtype_For_Message_Field_List, Access_To_Subtype_For_Message_Field_List);

         function Allocate_Message_Field_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_List;

         function Allocate_Message_Field_List
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_List
         is
            Result      : constant Access_To_Subtype_For_Message_Field_List := Bare_Message_Field_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Field_List;
            return Bare_Message_Field_List (Result);
         end Allocate_Message_Field_List;

      package Bare_Numeric_Literal_List_Memos is new Langkit_Support.Packrat
        (Bare_Numeric_Literal_List, Token_Index);

         
         subtype Subtype_For_Numeric_Literal_List is
            Root_Node_Record (RFLX_Numeric_Literal_List);
         type Access_To_Subtype_For_Numeric_Literal_List is access all Subtype_For_Numeric_Literal_List;
         package Bare_Numeric_Literal_List_Alloc is new Alloc
           (Subtype_For_Numeric_Literal_List, Access_To_Subtype_For_Numeric_Literal_List);

         function Allocate_Numeric_Literal_List
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal_List;

         function Allocate_Numeric_Literal_List
           (Pool : Bump_Ptr_Pool) return Bare_Numeric_Literal_List
         is
            Result      : constant Access_To_Subtype_For_Numeric_Literal_List := Bare_Numeric_Literal_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Numeric_Literal_List;
            return Bare_Numeric_Literal_List (Result);
         end Allocate_Numeric_Literal_List;

      package Bare_Parameter_List_Memos is new Langkit_Support.Packrat
        (Bare_Parameter_List, Token_Index);

         
         subtype Subtype_For_Parameter_List is
            Root_Node_Record (RFLX_Parameter_List);
         type Access_To_Subtype_For_Parameter_List is access all Subtype_For_Parameter_List;
         package Bare_Parameter_List_Alloc is new Alloc
           (Subtype_For_Parameter_List, Access_To_Subtype_For_Parameter_List);

         function Allocate_Parameter_List
           (Pool : Bump_Ptr_Pool) return Bare_Parameter_List;

         function Allocate_Parameter_List
           (Pool : Bump_Ptr_Pool) return Bare_Parameter_List
         is
            Result      : constant Access_To_Subtype_For_Parameter_List := Bare_Parameter_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Parameter_List;
            return Bare_Parameter_List (Result);
         end Allocate_Parameter_List;

      package Bare_RFLX_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_RFLX_Node_List, Token_Index);

         
         subtype Subtype_For_RFLX_Node_List is
            Root_Node_Record (RFLX_RFLX_Node_List);
         type Access_To_Subtype_For_RFLX_Node_List is access all Subtype_For_RFLX_Node_List;
         package Bare_RFLX_Node_List_Alloc is new Alloc
           (Subtype_For_RFLX_Node_List, Access_To_Subtype_For_RFLX_Node_List);

         function Allocate_RFLX_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_RFLX_Node_List;

         function Allocate_RFLX_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_RFLX_Node_List
         is
            Result      : constant Access_To_Subtype_For_RFLX_Node_List := Bare_RFLX_Node_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_RFLX_Node_List;
            return Bare_RFLX_Node_List (Result);
         end Allocate_RFLX_Node_List;

      package Bare_State_List_Memos is new Langkit_Support.Packrat
        (Bare_State_List, Token_Index);

         
         subtype Subtype_For_State_List is
            Root_Node_Record (RFLX_State_List);
         type Access_To_Subtype_For_State_List is access all Subtype_For_State_List;
         package Bare_State_List_Alloc is new Alloc
           (Subtype_For_State_List, Access_To_Subtype_For_State_List);

         function Allocate_State_List
           (Pool : Bump_Ptr_Pool) return Bare_State_List;

         function Allocate_State_List
           (Pool : Bump_Ptr_Pool) return Bare_State_List
         is
            Result      : constant Access_To_Subtype_For_State_List := Bare_State_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_State_List;
            return Bare_State_List (Result);
         end Allocate_State_List;

      package Bare_Statement_List_Memos is new Langkit_Support.Packrat
        (Bare_Statement_List, Token_Index);

         
         subtype Subtype_For_Statement_List is
            Root_Node_Record (RFLX_Statement_List);
         type Access_To_Subtype_For_Statement_List is access all Subtype_For_Statement_List;
         package Bare_Statement_List_Alloc is new Alloc
           (Subtype_For_Statement_List, Access_To_Subtype_For_Statement_List);

         function Allocate_Statement_List
           (Pool : Bump_Ptr_Pool) return Bare_Statement_List;

         function Allocate_Statement_List
           (Pool : Bump_Ptr_Pool) return Bare_Statement_List
         is
            Result      : constant Access_To_Subtype_For_Statement_List := Bare_Statement_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Statement_List;
            return Bare_Statement_List (Result);
         end Allocate_Statement_List;

      package Bare_Term_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Term_Assoc_List, Token_Index);

         
         subtype Subtype_For_Term_Assoc_List is
            Root_Node_Record (RFLX_Term_Assoc_List);
         type Access_To_Subtype_For_Term_Assoc_List is access all Subtype_For_Term_Assoc_List;
         package Bare_Term_Assoc_List_Alloc is new Alloc
           (Subtype_For_Term_Assoc_List, Access_To_Subtype_For_Term_Assoc_List);

         function Allocate_Term_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc_List;

         function Allocate_Term_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Term_Assoc_List := Bare_Term_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Term_Assoc_List;
            return Bare_Term_Assoc_List (Result);
         end Allocate_Term_Assoc_List;

      package Bare_Then_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Then_Node_List, Token_Index);

         
         subtype Subtype_For_Then_Node_List is
            Root_Node_Record (RFLX_Then_Node_List);
         type Access_To_Subtype_For_Then_Node_List is access all Subtype_For_Then_Node_List;
         package Bare_Then_Node_List_Alloc is new Alloc
           (Subtype_For_Then_Node_List, Access_To_Subtype_For_Then_Node_List);

         function Allocate_Then_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node_List;

         function Allocate_Then_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node_List
         is
            Result      : constant Access_To_Subtype_For_Then_Node_List := Bare_Then_Node_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Then_Node_List;
            return Bare_Then_Node_List (Result);
         end Allocate_Then_Node_List;

      package Bare_Type_Argument_List_Memos is new Langkit_Support.Packrat
        (Bare_Type_Argument_List, Token_Index);

         
         subtype Subtype_For_Type_Argument_List is
            Root_Node_Record (RFLX_Type_Argument_List);
         type Access_To_Subtype_For_Type_Argument_List is access all Subtype_For_Type_Argument_List;
         package Bare_Type_Argument_List_Alloc is new Alloc
           (Subtype_For_Type_Argument_List, Access_To_Subtype_For_Type_Argument_List);

         function Allocate_Type_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument_List;

         function Allocate_Type_Argument_List
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument_List
         is
            Result      : constant Access_To_Subtype_For_Type_Argument_List := Bare_Type_Argument_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Type_Argument_List;
            return Bare_Type_Argument_List (Result);
         end Allocate_Type_Argument_List;

      package Bare_UnqualifiedID_List_Memos is new Langkit_Support.Packrat
        (Bare_UnqualifiedID_List, Token_Index);

         
         subtype Subtype_For_UnqualifiedID_List is
            Root_Node_Record (RFLX_UnqualifiedID_List);
         type Access_To_Subtype_For_UnqualifiedID_List is access all Subtype_For_UnqualifiedID_List;
         package Bare_UnqualifiedID_List_Alloc is new Alloc
           (Subtype_For_UnqualifiedID_List, Access_To_Subtype_For_UnqualifiedID_List);

         function Allocate_UnqualifiedID_List
           (Pool : Bump_Ptr_Pool) return Bare_UnqualifiedID_List;

         function Allocate_UnqualifiedID_List
           (Pool : Bump_Ptr_Pool) return Bare_UnqualifiedID_List
         is
            Result      : constant Access_To_Subtype_For_UnqualifiedID_List := Bare_UnqualifiedID_List_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_UnqualifiedID_List;
            return Bare_UnqualifiedID_List (Result);
         end Allocate_UnqualifiedID_List;

      package Bare_Session_Aspects_Memos is new Langkit_Support.Packrat
        (Bare_Session_Aspects, Token_Index);

         
         subtype Subtype_For_Session_Aspects is
            Root_Node_Record (RFLX_Session_Aspects);
         type Access_To_Subtype_For_Session_Aspects is access all Subtype_For_Session_Aspects;
         package Bare_Session_Aspects_Alloc is new Alloc
           (Subtype_For_Session_Aspects, Access_To_Subtype_For_Session_Aspects);

         function Allocate_Session_Aspects
           (Pool : Bump_Ptr_Pool) return Bare_Session_Aspects;

         function Allocate_Session_Aspects
           (Pool : Bump_Ptr_Pool) return Bare_Session_Aspects
         is
            Result      : constant Access_To_Subtype_For_Session_Aspects := Bare_Session_Aspects_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Session_Aspects;
            return Bare_Session_Aspects (Result);
         end Allocate_Session_Aspects;

      package Bare_Specification_Memos is new Langkit_Support.Packrat
        (Bare_Specification, Token_Index);

         
         subtype Subtype_For_Specification is
            Root_Node_Record (RFLX_Specification);
         type Access_To_Subtype_For_Specification is access all Subtype_For_Specification;
         package Bare_Specification_Alloc is new Alloc
           (Subtype_For_Specification, Access_To_Subtype_For_Specification);

         function Allocate_Specification
           (Pool : Bump_Ptr_Pool) return Bare_Specification;

         function Allocate_Specification
           (Pool : Bump_Ptr_Pool) return Bare_Specification
         is
            Result      : constant Access_To_Subtype_For_Specification := Bare_Specification_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Specification;
            return Bare_Specification (Result);
         end Allocate_Specification;

      package Bare_State_Memos is new Langkit_Support.Packrat
        (Bare_State, Token_Index);

         
         subtype Subtype_For_State is
            Root_Node_Record (RFLX_State);
         type Access_To_Subtype_For_State is access all Subtype_For_State;
         package Bare_State_Alloc is new Alloc
           (Subtype_For_State, Access_To_Subtype_For_State);

         function Allocate_State
           (Pool : Bump_Ptr_Pool) return Bare_State;

         function Allocate_State
           (Pool : Bump_Ptr_Pool) return Bare_State
         is
            Result      : constant Access_To_Subtype_For_State := Bare_State_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_State;
            return Bare_State (Result);
         end Allocate_State;

      package Bare_Statement_Memos is new Langkit_Support.Packrat
        (Bare_Statement, Token_Index);

      package Bare_Assignment_Memos is new Langkit_Support.Packrat
        (Bare_Assignment, Token_Index);

         
         subtype Subtype_For_Assignment is
            Root_Node_Record (RFLX_Assignment);
         type Access_To_Subtype_For_Assignment is access all Subtype_For_Assignment;
         package Bare_Assignment_Alloc is new Alloc
           (Subtype_For_Assignment, Access_To_Subtype_For_Assignment);

         function Allocate_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Assignment;

         function Allocate_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Assignment
         is
            Result      : constant Access_To_Subtype_For_Assignment := Bare_Assignment_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Assignment;
            return Bare_Assignment (Result);
         end Allocate_Assignment;

      package Bare_Attribute_Statement_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Statement, Token_Index);

         
         subtype Subtype_For_Attribute_Statement is
            Root_Node_Record (RFLX_Attribute_Statement);
         type Access_To_Subtype_For_Attribute_Statement is access all Subtype_For_Attribute_Statement;
         package Bare_Attribute_Statement_Alloc is new Alloc
           (Subtype_For_Attribute_Statement, Access_To_Subtype_For_Attribute_Statement);

         function Allocate_Attribute_Statement
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Statement;

         function Allocate_Attribute_Statement
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Statement
         is
            Result      : constant Access_To_Subtype_For_Attribute_Statement := Bare_Attribute_Statement_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Attribute_Statement;
            return Bare_Attribute_Statement (Result);
         end Allocate_Attribute_Statement;

      package Bare_Message_Field_Assignment_Memos is new Langkit_Support.Packrat
        (Bare_Message_Field_Assignment, Token_Index);

         
         subtype Subtype_For_Message_Field_Assignment is
            Root_Node_Record (RFLX_Message_Field_Assignment);
         type Access_To_Subtype_For_Message_Field_Assignment is access all Subtype_For_Message_Field_Assignment;
         package Bare_Message_Field_Assignment_Alloc is new Alloc
           (Subtype_For_Message_Field_Assignment, Access_To_Subtype_For_Message_Field_Assignment);

         function Allocate_Message_Field_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_Assignment;

         function Allocate_Message_Field_Assignment
           (Pool : Bump_Ptr_Pool) return Bare_Message_Field_Assignment
         is
            Result      : constant Access_To_Subtype_For_Message_Field_Assignment := Bare_Message_Field_Assignment_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Field_Assignment;
            return Bare_Message_Field_Assignment (Result);
         end Allocate_Message_Field_Assignment;

      package Bare_Reset_Memos is new Langkit_Support.Packrat
        (Bare_Reset, Token_Index);

         
         subtype Subtype_For_Reset is
            Root_Node_Record (RFLX_Reset);
         type Access_To_Subtype_For_Reset is access all Subtype_For_Reset;
         package Bare_Reset_Alloc is new Alloc
           (Subtype_For_Reset, Access_To_Subtype_For_Reset);

         function Allocate_Reset
           (Pool : Bump_Ptr_Pool) return Bare_Reset;

         function Allocate_Reset
           (Pool : Bump_Ptr_Pool) return Bare_Reset
         is
            Result      : constant Access_To_Subtype_For_Reset := Bare_Reset_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Reset;
            return Bare_Reset (Result);
         end Allocate_Reset;

      package Bare_Term_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Term_Assoc, Token_Index);

         
         subtype Subtype_For_Term_Assoc is
            Root_Node_Record (RFLX_Term_Assoc);
         type Access_To_Subtype_For_Term_Assoc is access all Subtype_For_Term_Assoc;
         package Bare_Term_Assoc_Alloc is new Alloc
           (Subtype_For_Term_Assoc, Access_To_Subtype_For_Term_Assoc);

         function Allocate_Term_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc;

         function Allocate_Term_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Term_Assoc
         is
            Result      : constant Access_To_Subtype_For_Term_Assoc := Bare_Term_Assoc_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Term_Assoc;
            return Bare_Term_Assoc (Result);
         end Allocate_Term_Assoc;

      package Bare_Then_Node_Memos is new Langkit_Support.Packrat
        (Bare_Then_Node, Token_Index);

         
         subtype Subtype_For_Then_Node is
            Root_Node_Record (RFLX_Then_Node);
         type Access_To_Subtype_For_Then_Node is access all Subtype_For_Then_Node;
         package Bare_Then_Node_Alloc is new Alloc
           (Subtype_For_Then_Node, Access_To_Subtype_For_Then_Node);

         function Allocate_Then_Node
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node;

         function Allocate_Then_Node
           (Pool : Bump_Ptr_Pool) return Bare_Then_Node
         is
            Result      : constant Access_To_Subtype_For_Then_Node := Bare_Then_Node_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Then_Node;
            return Bare_Then_Node (Result);
         end Allocate_Then_Node;

      package Bare_Transition_Memos is new Langkit_Support.Packrat
        (Bare_Transition, Token_Index);

         
         subtype Subtype_For_Transition is
            Root_Node_Record (RFLX_Transition);
         type Access_To_Subtype_For_Transition is access all Subtype_For_Transition;
         package Bare_Transition_Alloc is new Alloc
           (Subtype_For_Transition, Access_To_Subtype_For_Transition);

         function Allocate_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Transition;

         function Allocate_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Transition
         is
            Result      : constant Access_To_Subtype_For_Transition := Bare_Transition_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Transition;
            return Bare_Transition (Result);
         end Allocate_Transition;

      package Bare_Conditional_Transition_Memos is new Langkit_Support.Packrat
        (Bare_Conditional_Transition, Token_Index);

         
         subtype Subtype_For_Conditional_Transition is
            Root_Node_Record (RFLX_Conditional_Transition);
         type Access_To_Subtype_For_Conditional_Transition is access all Subtype_For_Conditional_Transition;
         package Bare_Conditional_Transition_Alloc is new Alloc
           (Subtype_For_Conditional_Transition, Access_To_Subtype_For_Conditional_Transition);

         function Allocate_Conditional_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition;

         function Allocate_Conditional_Transition
           (Pool : Bump_Ptr_Pool) return Bare_Conditional_Transition
         is
            Result      : constant Access_To_Subtype_For_Conditional_Transition := Bare_Conditional_Transition_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Conditional_Transition;
            return Bare_Conditional_Transition (Result);
         end Allocate_Conditional_Transition;

      package Bare_Type_Argument_Memos is new Langkit_Support.Packrat
        (Bare_Type_Argument, Token_Index);

         
         subtype Subtype_For_Type_Argument is
            Root_Node_Record (RFLX_Type_Argument);
         type Access_To_Subtype_For_Type_Argument is access all Subtype_For_Type_Argument;
         package Bare_Type_Argument_Alloc is new Alloc
           (Subtype_For_Type_Argument, Access_To_Subtype_For_Type_Argument);

         function Allocate_Type_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument;

         function Allocate_Type_Argument
           (Pool : Bump_Ptr_Pool) return Bare_Type_Argument
         is
            Result      : constant Access_To_Subtype_For_Type_Argument := Bare_Type_Argument_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Type_Argument;
            return Bare_Type_Argument (Result);
         end Allocate_Type_Argument;

      package Bare_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Def, Token_Index);

      package Bare_Abstract_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Message_Type_Def, Token_Index);

      package Bare_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Message_Type_Def, Token_Index);

         
         subtype Subtype_For_Message_Type_Def is
            Root_Node_Record (RFLX_Message_Type_Def);
         type Access_To_Subtype_For_Message_Type_Def is access all Subtype_For_Message_Type_Def;
         package Bare_Message_Type_Def_Alloc is new Alloc
           (Subtype_For_Message_Type_Def, Access_To_Subtype_For_Message_Type_Def);

         function Allocate_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Message_Type_Def;

         function Allocate_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Message_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Message_Type_Def := Bare_Message_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Message_Type_Def;
            return Bare_Message_Type_Def (Result);
         end Allocate_Message_Type_Def;

      package Bare_Null_Message_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Null_Message_Type_Def, Token_Index);

         
         subtype Subtype_For_Null_Message_Type_Def is
            Root_Node_Record (RFLX_Null_Message_Type_Def);
         type Access_To_Subtype_For_Null_Message_Type_Def is access all Subtype_For_Null_Message_Type_Def;
         package Bare_Null_Message_Type_Def_Alloc is new Alloc
           (Subtype_For_Null_Message_Type_Def, Access_To_Subtype_For_Null_Message_Type_Def);

         function Allocate_Null_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Type_Def;

         function Allocate_Null_Message_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Message_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Null_Message_Type_Def := Bare_Null_Message_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Null_Message_Type_Def;
            return Bare_Null_Message_Type_Def (Result);
         end Allocate_Null_Message_Type_Def;

      package Bare_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enumeration_Def, Token_Index);

      package Bare_Named_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Named_Enumeration_Def, Token_Index);

         
         subtype Subtype_For_Named_Enumeration_Def is
            Root_Node_Record (RFLX_Named_Enumeration_Def);
         type Access_To_Subtype_For_Named_Enumeration_Def is access all Subtype_For_Named_Enumeration_Def;
         package Bare_Named_Enumeration_Def_Alloc is new Alloc
           (Subtype_For_Named_Enumeration_Def, Access_To_Subtype_For_Named_Enumeration_Def);

         function Allocate_Named_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Named_Enumeration_Def;

         function Allocate_Named_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Named_Enumeration_Def
         is
            Result      : constant Access_To_Subtype_For_Named_Enumeration_Def := Bare_Named_Enumeration_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Named_Enumeration_Def;
            return Bare_Named_Enumeration_Def (Result);
         end Allocate_Named_Enumeration_Def;

      package Bare_Positional_Enumeration_Def_Memos is new Langkit_Support.Packrat
        (Bare_Positional_Enumeration_Def, Token_Index);

         
         subtype Subtype_For_Positional_Enumeration_Def is
            Root_Node_Record (RFLX_Positional_Enumeration_Def);
         type Access_To_Subtype_For_Positional_Enumeration_Def is access all Subtype_For_Positional_Enumeration_Def;
         package Bare_Positional_Enumeration_Def_Alloc is new Alloc
           (Subtype_For_Positional_Enumeration_Def, Access_To_Subtype_For_Positional_Enumeration_Def);

         function Allocate_Positional_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Positional_Enumeration_Def;

         function Allocate_Positional_Enumeration_Def
           (Pool : Bump_Ptr_Pool) return Bare_Positional_Enumeration_Def
         is
            Result      : constant Access_To_Subtype_For_Positional_Enumeration_Def := Bare_Positional_Enumeration_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Positional_Enumeration_Def;
            return Bare_Positional_Enumeration_Def (Result);
         end Allocate_Positional_Enumeration_Def;

      package Bare_Enumeration_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enumeration_Type_Def, Token_Index);

         
         subtype Subtype_For_Enumeration_Type_Def is
            Root_Node_Record (RFLX_Enumeration_Type_Def);
         type Access_To_Subtype_For_Enumeration_Type_Def is access all Subtype_For_Enumeration_Type_Def;
         package Bare_Enumeration_Type_Def_Alloc is new Alloc
           (Subtype_For_Enumeration_Type_Def, Access_To_Subtype_For_Enumeration_Type_Def);

         function Allocate_Enumeration_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enumeration_Type_Def;

         function Allocate_Enumeration_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enumeration_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Enumeration_Type_Def := Bare_Enumeration_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Enumeration_Type_Def;
            return Bare_Enumeration_Type_Def (Result);
         end Allocate_Enumeration_Type_Def;

      package Bare_Integer_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Integer_Type_Def, Token_Index);

      package Bare_Modular_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Modular_Type_Def, Token_Index);

         
         subtype Subtype_For_Modular_Type_Def is
            Root_Node_Record (RFLX_Modular_Type_Def);
         type Access_To_Subtype_For_Modular_Type_Def is access all Subtype_For_Modular_Type_Def;
         package Bare_Modular_Type_Def_Alloc is new Alloc
           (Subtype_For_Modular_Type_Def, Access_To_Subtype_For_Modular_Type_Def);

         function Allocate_Modular_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Modular_Type_Def;

         function Allocate_Modular_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Modular_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Modular_Type_Def := Bare_Modular_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Modular_Type_Def;
            return Bare_Modular_Type_Def (Result);
         end Allocate_Modular_Type_Def;

      package Bare_Range_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Range_Type_Def, Token_Index);

         
         subtype Subtype_For_Range_Type_Def is
            Root_Node_Record (RFLX_Range_Type_Def);
         type Access_To_Subtype_For_Range_Type_Def is access all Subtype_For_Range_Type_Def;
         package Bare_Range_Type_Def_Alloc is new Alloc
           (Subtype_For_Range_Type_Def, Access_To_Subtype_For_Range_Type_Def);

         function Allocate_Range_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Range_Type_Def;

         function Allocate_Range_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Range_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Range_Type_Def := Bare_Range_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Range_Type_Def;
            return Bare_Range_Type_Def (Result);
         end Allocate_Range_Type_Def;

      package Bare_Sequence_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Sequence_Type_Def, Token_Index);

         
         subtype Subtype_For_Sequence_Type_Def is
            Root_Node_Record (RFLX_Sequence_Type_Def);
         type Access_To_Subtype_For_Sequence_Type_Def is access all Subtype_For_Sequence_Type_Def;
         package Bare_Sequence_Type_Def_Alloc is new Alloc
           (Subtype_For_Sequence_Type_Def, Access_To_Subtype_For_Sequence_Type_Def);

         function Allocate_Sequence_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Type_Def;

         function Allocate_Sequence_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Sequence_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Sequence_Type_Def := Bare_Sequence_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Sequence_Type_Def;
            return Bare_Sequence_Type_Def (Result);
         end Allocate_Sequence_Type_Def;

      package Bare_Type_Derivation_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Derivation_Def, Token_Index);

         
         subtype Subtype_For_Type_Derivation_Def is
            Root_Node_Record (RFLX_Type_Derivation_Def);
         type Access_To_Subtype_For_Type_Derivation_Def is access all Subtype_For_Type_Derivation_Def;
         package Bare_Type_Derivation_Def_Alloc is new Alloc
           (Subtype_For_Type_Derivation_Def, Access_To_Subtype_For_Type_Derivation_Def);

         function Allocate_Type_Derivation_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Derivation_Def;

         function Allocate_Type_Derivation_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Derivation_Def
         is
            Result      : constant Access_To_Subtype_For_Type_Derivation_Def := Bare_Type_Derivation_Def_Alloc.Alloc (Pool);
            Result_Kind : RFLX_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := RFLX_Type_Derivation_Def;
            return Bare_Type_Derivation_Def (Result);
         end Allocate_Type_Derivation_Def;

   pragma Warnings (On, "is not referenced");
   pragma Warnings (On, "possible aliasing problem for type");

   procedure Initialize_List
     (Self   : Bare_RFLX_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural);
   --  Helper for parsers, to initialize the list of children in a freshly
   --  allocated list node.

   type Dontskip_Parser_Function is access function
     (Parser : in out Parser_Type;
      Pos    : Token_Index)
      return Bare_RFLX_Node;

   package Dont_Skip_Fn_Vectors
   is new Ada.Containers.Vectors (Natural, Dontskip_Parser_Function);

   type Free_Parse_List_Record;
   type Free_Parse_List is access all Free_Parse_List_Record;
   --  Cache of temporary lists of AST nodes used in List parsers

   type Free_Parse_List_Record is record
      Nodes : Bare_RFLX_Node_Vectors.Vector;
      Next  : Free_Parse_List;
   end record;

   type Parser_Private_Part_Type is record
      Parse_Lists : Free_Parse_List;

      
      Action_Or_Parse_0_Memo : Bare_Statement_Memos.Memo_Type;
      
      Aspect_Transform_Parse_0_Memo : Bare_Aspect_Memos.Memo_Type;
      
      Assignment_Statement_Transform_Parse_0_Memo : Bare_Assignment_Memos.Memo_Type;
      
      Attribute_Statement_Or_Parse_0_Memo : Bare_Statement_Memos.Memo_Type;
      
      Basic_Declaration_Or_Parse_0_Memo : Bare_Declaration_Memos.Memo_Type;
      
      Basic_Declarations_Extract_Parse_0_Memo : Bare_Declaration_List_Memos.Memo_Type;
      
      Byte_Order_Aspect_Transform_Parse_2_Memo : Bare_Byte_Order_Aspect_Memos.Memo_Type;
      
      Call_Transform_Parse_0_Memo : Bare_Call_Memos.Memo_Type;
      
      Channel_Declaration_Transform_Parse_2_Memo : Bare_Formal_Channel_Decl_Memos.Memo_Type;
      
      Checksum_Aspect_Transform_Parse_0_Memo : Bare_Checksum_Aspect_Memos.Memo_Type;
      
      Checksum_Association_Transform_Parse_1_Memo : Bare_Checksum_Assoc_Memos.Memo_Type;
      
      Comprehension_Transform_Parse_0_Memo : Bare_Comprehension_Memos.Memo_Type;
      
      Concatenation_Or_Parse_2_Memo : Bare_Sequence_Literal_Memos.Memo_Type;
      
      Conditional_Transition_Transform_Parse_0_Memo : Bare_Conditional_Transition_Memos.Memo_Type;
      
      Context_Clause_List_Parse_0_Memo : Bare_Context_Item_List_Memos.Memo_Type;
      
      Context_Item_Transform_Parse_0_Memo : Bare_Context_Item_Memos.Memo_Type;
      
      Conversion_Transform_Parse_0_Memo : Bare_Conversion_Memos.Memo_Type;
      
      Declaration_Or_Parse_0_Memo : Bare_Local_Decl_Memos.Memo_Type;
      
      Description_Aspect_Transform_Parse_0_Memo : Bare_Description_Memos.Memo_Type;
      
      Element_Value_Association_Transform_Parse_0_Memo : Bare_Element_Value_Assoc_Memos.Memo_Type;
      
      Enumeration_Aspects_List_Parse_0_Memo : Bare_Aspect_List_Memos.Memo_Type;
      
      Enumeration_Type_Definition_Transform_Parse_0_Memo : Bare_Enumeration_Type_Def_Memos.Memo_Type;
      
      Expression_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Case_Expression_Transform_Parse_0_Memo : Bare_Case_Expression_Memos.Memo_Type;
      
      Extended_Choice_List_List_Parse_0_Memo : Bare_RFLX_Node_List_Memos.Memo_Type;
      
      Extended_Choices_Transform_Parse_0_Memo : Bare_Choice_Memos.Memo_Type;
      
      Extended_Expression_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Factor_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_If_Condition_Extract_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Paren_Expression_Transform_Parse_0_Memo : Bare_Paren_Expression_Memos.Memo_Type;
      
      Extended_Primary_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Relation_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Simple_Expr_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Suffix_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Term_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Extended_Unop_Term_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Factor_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Formal_Function_Declaration_Transform_Parse_0_Memo : Bare_Formal_Function_Decl_Memos.Memo_Type;
      
      If_Condition_Extract_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Integer_Type_Definition_Or_Parse_0_Memo : Bare_Integer_Type_Def_Memos.Memo_Type;
      
      List_Attribute_Transform_Parse_4_Memo : Bare_Attribute_Statement_Memos.Memo_Type;
      
      Main_Rule_Opt_Parse_0_Memo : Bare_Specification_Memos.Memo_Type;
      
      Message_Aggregate_Association_List_Transform_Parse_0_Memo : Bare_Message_Aggregate_Associations_Memos.Memo_Type;
      
      Message_Aggregate_Association_Transform_Parse_0_Memo : Bare_Message_Aggregate_Association_Memos.Memo_Type;
      
      Message_Aggregate_Transform_Parse_0_Memo : Bare_Message_Aggregate_Memos.Memo_Type;
      
      Message_Aspect_List_List_Parse_0_Memo : Bare_Message_Aspect_List_Memos.Memo_Type;
      
      Message_Field_Assignment_Statement_Transform_Parse_0_Memo : Bare_Message_Field_Assignment_Memos.Memo_Type;
      
      Message_Field_List_Transform_Parse_0_Memo : Bare_Message_Fields_Memos.Memo_Type;
      
      Message_Field_Transform_Parse_0_Memo : Bare_Message_Field_Memos.Memo_Type;
      
      Message_Type_Definition_Or_Parse_0_Memo : Bare_Abstract_Message_Type_Def_Memos.Memo_Type;
      
      Modular_Type_Definition_Transform_Parse_0_Memo : Bare_Modular_Type_Def_Memos.Memo_Type;
      
      Named_Enumeration_Transform_Parse_0_Memo : Bare_Named_Enumeration_Def_Memos.Memo_Type;
      
      Null_Message_Aggregate_Transform_Parse_0_Memo : Bare_Null_Message_Aggregate_Memos.Memo_Type;
      
      Null_Message_Field_Transform_Parse_0_Memo : Bare_Null_Message_Field_Memos.Memo_Type;
      
      Null_State_Body_Transform_Parse_0_Memo : Bare_Null_State_Body_Memos.Memo_Type;
      
      Numeric_Literal_Transform_Parse_0_Memo : Bare_Numeric_Literal_Memos.Memo_Type;
      
      Package_Declaration_Transform_Parse_0_Memo : Bare_Package_Node_Memos.Memo_Type;
      
      Parameter_List_Transform_Parse_0_Memo : Bare_Parameters_Memos.Memo_Type;
      
      Parameter_Transform_Parse_0_Memo : Bare_Parameter_Memos.Memo_Type;
      
      Paren_Expression_Transform_Parse_0_Memo : Bare_Paren_Expression_Memos.Memo_Type;
      
      Positional_Enumeration_Transform_Parse_0_Memo : Bare_Positional_Enumeration_Def_Memos.Memo_Type;
      
      Primary_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Qualified_Identifier_Transform_Parse_0_Memo : Bare_ID_Memos.Memo_Type;
      
      Quantified_Expression_Transform_Parse_2_Memo : Bare_Quantified_Expression_Memos.Memo_Type;
      
      Range_Type_Definition_Transform_Parse_0_Memo : Bare_Range_Type_Def_Memos.Memo_Type;
      
      Relation_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Renaming_Declaration_Transform_Parse_0_Memo : Bare_Renaming_Decl_Memos.Memo_Type;
      
      Reset_Transform_Parse_0_Memo : Bare_Reset_Memos.Memo_Type;
      
      Sequence_Aggregate_Transform_Parse_0_Memo : Bare_Sequence_Aggregate_Memos.Memo_Type;
      
      Sequence_Type_Definition_Transform_Parse_0_Memo : Bare_Sequence_Type_Def_Memos.Memo_Type;
      
      Session_Aspects_Transform_Parse_0_Memo : Bare_Session_Aspects_Memos.Memo_Type;
      
      Session_Declaration_Transform_Parse_0_Memo : Bare_Session_Decl_Memos.Memo_Type;
      
      Session_Parameter_Or_Parse_0_Memo : Bare_Formal_Decl_Memos.Memo_Type;
      
      Simple_Expr_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Specification_Transform_Parse_0_Memo : Bare_Specification_Memos.Memo_Type;
      
      State_Body_Transform_Parse_0_Memo : Bare_State_Body_Memos.Memo_Type;
      
      State_Transform_Parse_0_Memo : Bare_State_Memos.Memo_Type;
      
      String_Literal_Transform_Parse_0_Memo : Bare_String_Literal_Memos.Memo_Type;
      
      Suffix_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Term_Or_Parse_1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Then_Transform_Parse_1_Memo : Bare_Then_Node_Memos.Memo_Type;
      
      Transition_Transform_Parse_0_Memo : Bare_Transition_Memos.Memo_Type;
      
      Type_Argument_Transform_Parse_0_Memo : Bare_Type_Argument_Memos.Memo_Type;
      
      Type_Declaration_Transform_Parse_0_Memo : Bare_Type_Decl_Memos.Memo_Type;
      
      Type_Derivation_Definition_Transform_Parse_0_Memo : Bare_Type_Derivation_Def_Memos.Memo_Type;
      
      Type_Refinement_Transform_Parse_0_Memo : Bare_Refinement_Decl_Memos.Memo_Type;
      
      Unop_Term_Or_Parse_0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Unqualified_Identifier_Transform_Parse_0_Memo : Bare_UnqualifiedID_Memos.Memo_Type;
      
      Value_Range_Transform_Parse_0_Memo : Bare_Checksum_Value_Range_Memos.Memo_Type;
      
      Variable_Declaration_Transform_Parse_0_Memo : Bare_Variable_Decl_Memos.Memo_Type;
      
      Variable_Transform_Parse_0_Memo : Bare_Variable_Memos.Memo_Type;

      Dont_Skip : Dont_Skip_Fn_Vectors.Vector;
   end record;

   
function Unqualified_Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_UnqualifiedID;

   
function Numeric_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Numeric_Literal;

   
function Sequence_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Aggregate;

   
function String_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal;

   
function Concatenation_Or_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Literal;

   
function Quantified_Expression_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expression;

   
function Comprehension_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Comprehension;

   
function Call_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call;

   
function Qualified_Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_ID;

   
function Conversion_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conversion;

   
function Null_Message_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Aggregate;

   
function Message_Aggregate_Association_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Association;

   
function Message_Aggregate_Association_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Associations;

   
function Message_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate;

   
function Variable_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable;

   
function Extended_Paren_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression;

   
function Extended_Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_RFLX_Node_List;

   
function Extended_Choices_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Choice;

   
function Extended_Case_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expression;

   
function Extended_Primary_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Suffix_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Factor_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Unop_Term_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Simple_Expr_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Extended_Expression_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Assignment_Statement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assignment;

   
function Message_Field_Assignment_Statement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field_Assignment;

   
function List_Attribute_Transform_Parse_4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Attribute_Statement;

   
function Reset_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Reset;

   
function Attribute_Statement_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement;

   
function Action_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement;

   
function Paren_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression;

   
function Primary_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Suffix_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Factor_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Unop_Term_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Simple_Expr_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Expression_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect;

   
function Parameter_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameter;

   
function Parameter_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameters;

   
function Element_Value_Association_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Element_Value_Assoc;

   
function Named_Enumeration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Named_Enumeration_Def;

   
function Positional_Enumeration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Positional_Enumeration_Def;

   
function Enumeration_Aspects_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_List;

   
function Enumeration_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enumeration_Type_Def;

   
function Range_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Type_Def;

   
function Modular_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Modular_Type_Def;

   
function Integer_Type_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Type_Def;

   
function If_Condition_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Then_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Then_Node;

   
function Null_Message_Field_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Field;

   
function Type_Argument_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Argument;

   
function Message_Field_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field;

   
function Message_Field_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Fields;

   
function Value_Range_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Value_Range;

   
function Checksum_Association_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Assoc;

   
function Checksum_Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Aspect;

   
function Byte_Order_Aspect_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Byte_Order_Aspect;

   
function Message_Aspect_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aspect_List;

   
function Message_Type_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Message_Type_Def;

   
function Type_Derivation_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Derivation_Def;

   
function Sequence_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Type_Def;

   
function Type_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Decl;

   
function Type_Refinement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Refinement_Decl;

   
function Formal_Function_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Function_Decl;

   
function Channel_Declaration_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Channel_Decl;

   
function Session_Parameter_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Decl;

   
function Session_Aspects_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Aspects;

   
function Renaming_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Decl;

   
function Variable_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable_Decl;

   
function Declaration_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Local_Decl;

   
function Description_Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Description;

   
function Null_State_Body_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_State_Body;

   
function Extended_If_Condition_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Conditional_Transition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conditional_Transition;

   
function Transition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Transition;

   
function State_Body_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State_Body;

   
function State_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State;

   
function Session_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Decl;

   
function Basic_Declaration_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration;

   
function Basic_Declarations_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration_List;

   
function Context_Item_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item;

   
function Context_Clause_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item_List;

   
function Package_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Node;

   
function Specification_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification;

   
function Main_Rule_Opt_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification;


   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True);
   --  Helper for the user parsing function, to be called after a low-level
   --  parsing function. Check_Complete has the same semantics as in Parse. If
   --  the parsing failed (Parser.Current_Pos = No_Token_Index), append
   --  corresponding diagnostics to Parser.Diagnostics, do nothing instead.

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type);
   --  Add a diagnostic for the last fail position of the parser

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List;
   --  Get a free parse list, or allocate one if there is no free parse list in
   --  Parser. When done with the result, the caller must invoke
   --  Release_Parse_List.

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List);
   --  Release a parse list, putting it in Parsers' free list. Set List to
   --  null.

   procedure Enter_Call (Parser : Parser_Type; Call_Depth : access Natural);
   procedure Exit_Call (Parser : Parser_Type; Call_Depth : Natural);
   --  Shortcuts to forward Parser's context to the eponym procedures in
   --  the Implementation package.

   ---------------------
   -- Initialize_List --
   ---------------------

   procedure Initialize_List
     (Self   : Bare_RFLX_Node_Base_List;
      Parser : Parser_Type;
      Count  : Natural) is
   begin
      Self.Count := Count;
      Self.Nodes := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, 0);
   end Initialize_List;

   -----------------
   -- Init_Parser --
   -----------------

   procedure Init_Parser
     (Input       : Internal_Lexer_Input;
      With_Trivia : Boolean;
      Unit        : access Implementation.Analysis_Unit_Type;
      TDH         : Token_Data_Handler_Access;
      Parser      : in out Parser_Type) is
   begin
      Reset (Parser);
      Extract_Tokens
        (Input, With_Trivia, Unit.Context.File_Reader, TDH.all,
         Parser.Diagnostics);
      Parser.Unit := Unit;
      Parser.TDH := TDH;
   end Init_Parser;

   ------------------------------
   -- Add_Last_Fail_Diagnostic --
   ------------------------------

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type)
   is
      Last_Token : Stored_Token_Data renames
         Get_Token (Parser.TDH.all, Parser.Last_Fail.Pos);
      D : constant Diagnostic :=
        (if Parser.Last_Fail.Kind = Token_Fail then
          Create (Sloc_Range (Parser.TDH.all, Last_Token), To_Text
            ("Expected "
             & Token_Error_Image (Parser.Last_Fail.Expected_Token_Id)
             & ", got "
             & Token_Error_Image (Parser.Last_Fail.Found_Token_Id)))
         else
           Create (Sloc_Range (Parser.TDH.all, Last_Token),
                   To_Text (Parser.Last_Fail.Custom_Message.all)));
   begin
      Parser.Diagnostics.Append (D);
   end Add_Last_Fail_Diagnostic;

   ---------------------------
   -- Process_Parsing_Error --
   ---------------------------

   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True) is
   begin

      if Parser.Current_Pos = No_Token_Index then
         Add_Last_Fail_Diagnostic (Parser);
      elsif Check_Complete
        and then Parser.Current_Pos /= Last_Token (Parser.TDH.all)
      then
         --  If the fail pos is the current position of the parser or after,
         --  it means that the longest parse is the correct result, and that we
         --  have some garbage afterwards.
         if Parser.Current_Pos >= Parser.Last_Fail.Pos then
            declare
               First_Garbage_Token : Stored_Token_Data renames
                  Get_Token (Parser.TDH.all, Parser.Current_Pos);
            begin
               Append
                 (Parser.Diagnostics,
                  Sloc_Range (Parser.TDH.all, First_Garbage_Token),
                  To_Text
                    ("End of input expected, got """
                     & Token_Kind_Name
                         (To_Token_Kind (First_Garbage_Token.Kind))
                     & """"));
            end;

         --  Else, the last fail pos is further down the line, and we want to
         --  have the diagnostic of what exactly failed.
         else
            Add_Last_Fail_Diagnostic (Parser);
         end if;
      end if;

   end Process_Parsing_Error;

   -----------
   -- Parse --
   -----------

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule) return Parsed_Node
   is
      Result : Bare_RFLX_Node;
   begin
      case Rule is
         when Main_Rule_Rule =>
            Result := Main_Rule_Opt_Parse_0
              (Parser, First_Token_Index);
         when Unqualified_Identifier_Rule =>
            Result := Unqualified_Identifier_Transform_Parse_0
              (Parser, First_Token_Index);
         when Qualified_Identifier_Rule =>
            Result := Qualified_Identifier_Transform_Parse_0
              (Parser, First_Token_Index);
         when Numeric_Literal_Rule =>
            Result := Numeric_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Variable_Rule =>
            Result := Variable_Transform_Parse_0
              (Parser, First_Token_Index);
         when Sequence_Aggregate_Rule =>
            Result := Sequence_Aggregate_Transform_Parse_0
              (Parser, First_Token_Index);
         when String_Literal_Rule =>
            Result := String_Literal_Transform_Parse_0
              (Parser, First_Token_Index);
         when Concatenation_Rule =>
            Result := Concatenation_Or_Parse_2
              (Parser, First_Token_Index);
         when Primary_Rule =>
            Result := Primary_Or_Parse_0
              (Parser, First_Token_Index);
         when Paren_Expression_Rule =>
            Result := Paren_Expression_Transform_Parse_0
              (Parser, First_Token_Index);
         when Suffix_Rule =>
            Result := Suffix_Or_Parse_1
              (Parser, First_Token_Index);
         when Factor_Rule =>
            Result := Factor_Or_Parse_0
              (Parser, First_Token_Index);
         when Term_Rule =>
            Result := Term_Or_Parse_1
              (Parser, First_Token_Index);
         when Unop_Term_Rule =>
            Result := Unop_Term_Or_Parse_0
              (Parser, First_Token_Index);
         when Simple_Expr_Rule =>
            Result := Simple_Expr_Or_Parse_1
              (Parser, First_Token_Index);
         when Relation_Rule =>
            Result := Relation_Or_Parse_1
              (Parser, First_Token_Index);
         when Expression_Rule =>
            Result := Expression_Or_Parse_1
              (Parser, First_Token_Index);
         when Quantified_Expression_Rule =>
            Result := Quantified_Expression_Transform_Parse_2
              (Parser, First_Token_Index);
         when Comprehension_Rule =>
            Result := Comprehension_Transform_Parse_0
              (Parser, First_Token_Index);
         when Call_Rule =>
            Result := Call_Transform_Parse_0
              (Parser, First_Token_Index);
         when Conversion_Rule =>
            Result := Conversion_Transform_Parse_0
              (Parser, First_Token_Index);
         when Null_Message_Aggregate_Rule =>
            Result := Null_Message_Aggregate_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Aggregate_Association_Rule =>
            Result := Message_Aggregate_Association_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Aggregate_Association_List_Rule =>
            Result := Message_Aggregate_Association_List_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Aggregate_Rule =>
            Result := Message_Aggregate_Transform_Parse_0
              (Parser, First_Token_Index);
         when Extended_Primary_Rule =>
            Result := Extended_Primary_Or_Parse_0
              (Parser, First_Token_Index);
         when Extended_Paren_Expression_Rule =>
            Result := Extended_Paren_Expression_Transform_Parse_0
              (Parser, First_Token_Index);
         when Extended_Choice_List_Rule =>
            Result := Extended_Choice_List_List_Parse_0
              (Parser, First_Token_Index);
         when Extended_Choices_Rule =>
            Result := Extended_Choices_Transform_Parse_0
              (Parser, First_Token_Index);
         when Extended_Case_Expression_Rule =>
            Result := Extended_Case_Expression_Transform_Parse_0
              (Parser, First_Token_Index);
         when Extended_Suffix_Rule =>
            Result := Extended_Suffix_Or_Parse_1
              (Parser, First_Token_Index);
         when Extended_Factor_Rule =>
            Result := Extended_Factor_Or_Parse_1
              (Parser, First_Token_Index);
         when Extended_Term_Rule =>
            Result := Extended_Term_Or_Parse_1
              (Parser, First_Token_Index);
         when Extended_Unop_Term_Rule =>
            Result := Extended_Unop_Term_Or_Parse_0
              (Parser, First_Token_Index);
         when Extended_Simple_Expr_Rule =>
            Result := Extended_Simple_Expr_Or_Parse_1
              (Parser, First_Token_Index);
         when Extended_Relation_Rule =>
            Result := Extended_Relation_Or_Parse_1
              (Parser, First_Token_Index);
         when Extended_Expression_Rule =>
            Result := Extended_Expression_Or_Parse_1
              (Parser, First_Token_Index);
         when Aspect_Rule =>
            Result := Aspect_Transform_Parse_0
              (Parser, First_Token_Index);
         when Range_Type_Definition_Rule =>
            Result := Range_Type_Definition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Modular_Type_Definition_Rule =>
            Result := Modular_Type_Definition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Integer_Type_Definition_Rule =>
            Result := Integer_Type_Definition_Or_Parse_0
              (Parser, First_Token_Index);
         when If_Condition_Rule =>
            Result := If_Condition_Extract_Parse_0
              (Parser, First_Token_Index);
         when Extended_If_Condition_Rule =>
            Result := Extended_If_Condition_Extract_Parse_0
              (Parser, First_Token_Index);
         when Then_Rule =>
            Result := Then_Transform_Parse_1
              (Parser, First_Token_Index);
         when Type_Argument_Rule =>
            Result := Type_Argument_Transform_Parse_0
              (Parser, First_Token_Index);
         when Null_Message_Field_Rule =>
            Result := Null_Message_Field_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Field_Rule =>
            Result := Message_Field_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Field_List_Rule =>
            Result := Message_Field_List_Transform_Parse_0
              (Parser, First_Token_Index);
         when Value_Range_Rule =>
            Result := Value_Range_Transform_Parse_0
              (Parser, First_Token_Index);
         when Checksum_Association_Rule =>
            Result := Checksum_Association_Transform_Parse_1
              (Parser, First_Token_Index);
         when Checksum_Aspect_Rule =>
            Result := Checksum_Aspect_Transform_Parse_0
              (Parser, First_Token_Index);
         when Byte_Order_Aspect_Rule =>
            Result := Byte_Order_Aspect_Transform_Parse_2
              (Parser, First_Token_Index);
         when Message_Aspect_List_Rule =>
            Result := Message_Aspect_List_List_Parse_0
              (Parser, First_Token_Index);
         when Message_Type_Definition_Rule =>
            Result := Message_Type_Definition_Or_Parse_0
              (Parser, First_Token_Index);
         when Positional_Enumeration_Rule =>
            Result := Positional_Enumeration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Element_Value_Association_Rule =>
            Result := Element_Value_Association_Transform_Parse_0
              (Parser, First_Token_Index);
         when Named_Enumeration_Rule =>
            Result := Named_Enumeration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Enumeration_Aspects_Rule =>
            Result := Enumeration_Aspects_List_Parse_0
              (Parser, First_Token_Index);
         when Enumeration_Type_Definition_Rule =>
            Result := Enumeration_Type_Definition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Derivation_Definition_Rule =>
            Result := Type_Derivation_Definition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Sequence_Type_Definition_Rule =>
            Result := Sequence_Type_Definition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Declaration_Rule =>
            Result := Type_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Type_Refinement_Rule =>
            Result := Type_Refinement_Transform_Parse_0
              (Parser, First_Token_Index);
         when Parameter_Rule =>
            Result := Parameter_Transform_Parse_0
              (Parser, First_Token_Index);
         when Parameter_List_Rule =>
            Result := Parameter_List_Transform_Parse_0
              (Parser, First_Token_Index);
         when Formal_Function_Declaration_Rule =>
            Result := Formal_Function_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Channel_Declaration_Rule =>
            Result := Channel_Declaration_Transform_Parse_2
              (Parser, First_Token_Index);
         when Session_Parameter_Rule =>
            Result := Session_Parameter_Or_Parse_0
              (Parser, First_Token_Index);
         when Session_Aspects_Rule =>
            Result := Session_Aspects_Transform_Parse_0
              (Parser, First_Token_Index);
         when Renaming_Declaration_Rule =>
            Result := Renaming_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Variable_Declaration_Rule =>
            Result := Variable_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Declaration_Rule =>
            Result := Declaration_Or_Parse_0
              (Parser, First_Token_Index);
         when Description_Aspect_Rule =>
            Result := Description_Aspect_Transform_Parse_0
              (Parser, First_Token_Index);
         when Null_State_Body_Rule =>
            Result := Null_State_Body_Transform_Parse_0
              (Parser, First_Token_Index);
         when Assignment_Statement_Rule =>
            Result := Assignment_Statement_Transform_Parse_0
              (Parser, First_Token_Index);
         when Message_Field_Assignment_Statement_Rule =>
            Result := Message_Field_Assignment_Statement_Transform_Parse_0
              (Parser, First_Token_Index);
         when List_Attribute_Rule =>
            Result := List_Attribute_Transform_Parse_4
              (Parser, First_Token_Index);
         when Reset_Rule =>
            Result := Reset_Transform_Parse_0
              (Parser, First_Token_Index);
         when Attribute_Statement_Rule =>
            Result := Attribute_Statement_Or_Parse_0
              (Parser, First_Token_Index);
         when Action_Rule =>
            Result := Action_Or_Parse_0
              (Parser, First_Token_Index);
         when Conditional_Transition_Rule =>
            Result := Conditional_Transition_Transform_Parse_0
              (Parser, First_Token_Index);
         when Transition_Rule =>
            Result := Transition_Transform_Parse_0
              (Parser, First_Token_Index);
         when State_Body_Rule =>
            Result := State_Body_Transform_Parse_0
              (Parser, First_Token_Index);
         when State_Rule =>
            Result := State_Transform_Parse_0
              (Parser, First_Token_Index);
         when Session_Declaration_Rule =>
            Result := Session_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Basic_Declaration_Rule =>
            Result := Basic_Declaration_Or_Parse_0
              (Parser, First_Token_Index);
         when Basic_Declarations_Rule =>
            Result := Basic_Declarations_Extract_Parse_0
              (Parser, First_Token_Index);
         when Package_Declaration_Rule =>
            Result := Package_Declaration_Transform_Parse_0
              (Parser, First_Token_Index);
         when Context_Item_Rule =>
            Result := Context_Item_Transform_Parse_0
              (Parser, First_Token_Index);
         when Context_Clause_Rule =>
            Result := Context_Clause_List_Parse_0
              (Parser, First_Token_Index);
         when Specification_Rule =>
            Result := Specification_Transform_Parse_0
              (Parser, First_Token_Index);
      end case;
      Process_Parsing_Error (Parser, Check_Complete);
      Set_Parents (Result, null);
      return Parsed_Node (Result);
   exception
      when Exc : Property_Error =>
         Append
           (Parser.Diagnostics,
            No_Source_Location_Range,
            To_Text ("Error during parsing: "
                     & Ada.Exceptions.Exception_Message (Exc)));
         return Parsed_Node (No_Bare_RFLX_Node);
   end Parse;

   


function Unqualified_Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_UnqualifiedID
is
   use Bare_UnqualifiedID_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_1 :
            Token_Index
               := No_Token_Index;
      Token_Pos_1 :
            Token_Index
               := No_Token_Index;
      Token_Res_1 :
            Token_Index
               := No_Token_Index;
      Token_Pos_2 :
            Token_Index
               := No_Token_Index;
      Token_Res_2 :
            Token_Index
               := No_Token_Index;
      Token_Pos_3 :
            Token_Index
               := No_Token_Index;
      Token_Res_3 :
            Token_Index
               := No_Token_Index;
      Token_Pos_4 :
            Token_Index
               := No_Token_Index;
      Token_Res_4 :
            Token_Index
               := No_Token_Index;
      Token_Pos_5 :
            Token_Index
               := No_Token_Index;
      Token_Res_5 :
            Token_Index
               := No_Token_Index;
      Token_Pos_6 :
            Token_Index
               := No_Token_Index;
      Token_Res_6 :
            Token_Index
               := No_Token_Index;
      Token_Pos_7 :
            Token_Index
               := No_Token_Index;
      Token_Res_7 :
            Token_Index
               := No_Token_Index;
      Token_Pos_8 :
            Token_Index
               := No_Token_Index;
      Token_Res_8 :
            Token_Index
               := No_Token_Index;
      Token_Pos_9 :
            Token_Index
               := No_Token_Index;
      Token_Res_9 :
            Token_Index
               := No_Token_Index;
      Token_Pos_10 :
            Token_Index
               := No_Token_Index;
      Token_Res_10 :
            Token_Index
               := No_Token_Index;
      Token_Pos_11 :
            Token_Index
               := No_Token_Index;
      Token_Res_11 :
            Token_Index
               := No_Token_Index;
      Token_Pos_12 :
            Token_Index
               := No_Token_Index;
      Token_Res_12 :
            Token_Index
               := No_Token_Index;
      Token_Pos_13 :
            Token_Index
               := No_Token_Index;
      Token_Res_13 :
            Token_Index
               := No_Token_Index;
      Token_Pos_14 :
            Token_Index
               := No_Token_Index;
      Token_Res_14 :
            Token_Index
               := No_Token_Index;
      Token_Pos_15 :
            Token_Index
               := No_Token_Index;
      Token_Res_15 :
            Token_Index
               := No_Token_Index;
      Token_Pos_16 :
            Token_Index
               := No_Token_Index;
      Token_Res_16 :
            Token_Index
               := No_Token_Index;
      Token_Pos_17 :
            Token_Index
               := No_Token_Index;
      Token_Res_17 :
            Token_Index
               := No_Token_Index;
      Token_Pos_18 :
            Token_Index
               := No_Token_Index;
      Token_Res_18 :
            Token_Index
               := No_Token_Index;
      Token_Pos_19 :
            Token_Index
               := No_Token_Index;
      Token_Res_19 :
            Token_Index
               := No_Token_Index;
      Token_Pos_20 :
            Token_Index
               := No_Token_Index;
      Token_Res_20 :
            Token_Index
               := No_Token_Index;
      Token_Pos_21 :
            Token_Index
               := No_Token_Index;
      Token_Res_21 :
            Token_Index
               := No_Token_Index;
      Token_Pos_22 :
            Token_Index
               := No_Token_Index;
      Token_Res_22 :
            Token_Index
               := No_Token_Index;
      Token_Pos_23 :
            Token_Index
               := No_Token_Index;
      Token_Res_23 :
            Token_Index
               := No_Token_Index;
      Token_Pos_24 :
            Token_Index
               := No_Token_Index;
      Token_Res_24 :
            Token_Index
               := No_Token_Index;
      Token_Pos_25 :
            Token_Index
               := No_Token_Index;
      Token_Res_25 :
            Token_Index
               := No_Token_Index;
      Token_Pos_26 :
            Token_Index
               := No_Token_Index;
      Token_Res_26 :
            Token_Index
               := No_Token_Index;
      Token_Pos_27 :
            Token_Index
               := No_Token_Index;
      Token_Res_27 :
            Token_Index
               := No_Token_Index;
      Token_Pos_28 :
            Token_Index
               := No_Token_Index;
      Token_Res_28 :
            Token_Index
               := No_Token_Index;
      Token_Pos_29 :
            Token_Index
               := No_Token_Index;
      Token_Res_29 :
            Token_Index
               := No_Token_Index;
      Token_Pos_30 :
            Token_Index
               := No_Token_Index;
      Token_Res_30 :
            Token_Index
               := No_Token_Index;
      Token_Pos_31 :
            Token_Index
               := No_Token_Index;
      Token_Res_31 :
            Token_Index
               := No_Token_Index;
      Token_Pos_32 :
            Token_Index
               := No_Token_Index;
      Token_Res_32 :
            Token_Index
               := No_Token_Index;
      Token_Pos_33 :
            Token_Index
               := No_Token_Index;
      Token_Res_33 :
            Token_Index
               := No_Token_Index;
      Token_Pos_34 :
            Token_Index
               := No_Token_Index;
      Token_Res_34 :
            Token_Index
               := No_Token_Index;
      Token_Pos_35 :
            Token_Index
               := No_Token_Index;
      Token_Res_35 :
            Token_Index
               := No_Token_Index;
      Token_Pos_36 :
            Token_Index
               := No_Token_Index;
      Token_Res_36 :
            Token_Index
               := No_Token_Index;
      Token_Pos_37 :
            Token_Index
               := No_Token_Index;
      Token_Res_37 :
            Token_Index
               := No_Token_Index;
      Token_Pos_38 :
            Token_Index
               := No_Token_Index;
      Token_Res_38 :
            Token_Index
               := No_Token_Index;
      Token_Pos_39 :
            Token_Index
               := No_Token_Index;
      Token_Res_39 :
            Token_Index
               := No_Token_Index;
      Token_Pos_40 :
            Token_Index
               := No_Token_Index;
      Token_Res_40 :
            Token_Index
               := No_Token_Index;
      Token_Pos_41 :
            Token_Index
               := No_Token_Index;
      Token_Res_41 :
            Token_Index
               := No_Token_Index;
      Token_Pos_42 :
            Token_Index
               := No_Token_Index;
      Token_Res_42 :
            Token_Index
               := No_Token_Index;
      Token_Pos_43 :
            Token_Index
               := No_Token_Index;
      Token_Res_43 :
            Token_Index
               := No_Token_Index;
      Token_Pos_44 :
            Token_Index
               := No_Token_Index;
      Token_Res_44 :
            Token_Index
               := No_Token_Index;
      Token_Pos_45 :
            Token_Index
               := No_Token_Index;
      Token_Res_45 :
            Token_Index
               := No_Token_Index;
      Token_Pos_46 :
            Token_Index
               := No_Token_Index;
      Token_Res_46 :
            Token_Index
               := No_Token_Index;
      Token_Pos_47 :
            Token_Index
               := No_Token_Index;
      Token_Res_47 :
            Token_Index
               := No_Token_Index;
      Token_Pos_48 :
            Token_Index
               := No_Token_Index;
      Token_Res_48 :
            Token_Index
               := No_Token_Index;
      Token_Pos_49 :
            Token_Index
               := No_Token_Index;
      Token_Res_49 :
            Token_Index
               := No_Token_Index;
      Token_Pos_50 :
            Token_Index
               := No_Token_Index;
      Token_Res_50 :
            Token_Index
               := No_Token_Index;
      Token_Pos_51 :
            Token_Index
               := No_Token_Index;
      Token_Res_51 :
            Token_Index
               := No_Token_Index;
      Token_Pos_52 :
            Token_Index
               := No_Token_Index;
      Token_Res_52 :
            Token_Index
               := No_Token_Index;
      Token_Pos_53 :
            Token_Index
               := No_Token_Index;
      Token_Res_53 :
            Token_Index
               := No_Token_Index;
      Token_Pos_54 :
            Token_Index
               := No_Token_Index;
      Token_Res_54 :
            Token_Index
               := No_Token_Index;
      Or_Pos_1 :
            Token_Index
               := No_Token_Index;
      Or_Res_1 :
            Token_Index
               := No_Token_Index;
      Transform_Res_1 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Unqualified_Identifier_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_1 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_1;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_1;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_1 := Pos;



--  Start or_code

Or_Pos_1 := No_Token_Index;
Or_Res_1 := No_Token_Index;
    
--  Start tok_code

Token_Res_1 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_1));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Package)
   then
       Token_Pos_1 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Package,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_1 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_1 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_1;
        Or_Res_1 := Token_Res_1;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_2 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_2));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_2 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_2 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_2 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_2;
        Or_Res_1 := Token_Res_2;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_3 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_3));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_If)
   then
       Token_Pos_3 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_3 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_3 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_3;
        Or_Res_1 := Token_Res_3;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_4 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_4));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_End)
   then
       Token_Pos_4 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_4 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_4 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_4;
        Or_Res_1 := Token_Res_4;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_5 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_5));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_5 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_5 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_5 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_5;
        Or_Res_1 := Token_Res_5;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_6 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_6));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Type)
   then
       Token_Pos_6 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Type,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_6 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_6 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_6;
        Or_Res_1 := Token_Res_6;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_7 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_7));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Range)
   then
       Token_Pos_7 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_7 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_7 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_7;
        Or_Res_1 := Token_Res_7;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_8 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_8));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_8 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_8 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_8 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_8;
        Or_Res_1 := Token_Res_8;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_9 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_9));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mod)
   then
       Token_Pos_9 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_9 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_9 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_9;
        Or_Res_1 := Token_Res_9;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_10 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_10));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Message)
   then
       Token_Pos_10 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_10 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_10 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_10;
        Or_Res_1 := Token_Res_10;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_11 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_11));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Then)
   then
       Token_Pos_11 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_11 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_11 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_11;
        Or_Res_1 := Token_Res_11;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_12 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_12));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sequence)
   then
       Token_Pos_12 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Sequence,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_12 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_12 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_12;
        Or_Res_1 := Token_Res_12;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_13 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_13));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Of)
   then
       Token_Pos_13 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_13 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_13 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_13;
        Or_Res_1 := Token_Res_13;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_14 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_14));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_In)
   then
       Token_Pos_14 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_14 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_14 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_14;
        Or_Res_1 := Token_Res_14;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_15 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_15));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Not)
   then
       Token_Pos_15 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_15 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_15 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_15;
        Or_Res_1 := Token_Res_15;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_16 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_16));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_New)
   then
       Token_Pos_16 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_16 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_16 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_16;
        Or_Res_1 := Token_Res_16;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_17 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_17));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_For)
   then
       Token_Pos_17 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_17 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_17 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_17;
        Or_Res_1 := Token_Res_17;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_18 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_18));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_When)
   then
       Token_Pos_18 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_18 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_18 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_18;
        Or_Res_1 := Token_Res_18;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_19 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_19));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Where)
   then
       Token_Pos_19 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Where,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_19 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_19 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_19;
        Or_Res_1 := Token_Res_19;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_20 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_20));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Use)
   then
       Token_Pos_20 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_20 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_20 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_20;
        Or_Res_1 := Token_Res_20;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_21 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_21));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_All)
   then
       Token_Pos_21 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_21 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_21 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_21;
        Or_Res_1 := Token_Res_21;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_22 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_22));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Some)
   then
       Token_Pos_22 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Some,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_22 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_22 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_22;
        Or_Res_1 := Token_Res_22;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_23 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_23));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Generic)
   then
       Token_Pos_23 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Generic,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_23 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_23 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_23;
        Or_Res_1 := Token_Res_23;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_24 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_24));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Session)
   then
       Token_Pos_24 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Session,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_24 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_24 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_24;
        Or_Res_1 := Token_Res_24;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_25 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_25));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Begin)
   then
       Token_Pos_25 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_25 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_25 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_25;
        Or_Res_1 := Token_Res_25;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_26 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_26));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Return)
   then
       Token_Pos_26 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Return,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_26 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_26 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_26;
        Or_Res_1 := Token_Res_26;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_27 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_27));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Function)
   then
       Token_Pos_27 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Function,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_27 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_27 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_27;
        Or_Res_1 := Token_Res_27;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_28 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_28));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_State)
   then
       Token_Pos_28 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_State,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_28 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_28 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_28;
        Or_Res_1 := Token_Res_28;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_29 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_29));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Transition)
   then
       Token_Pos_29 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Transition,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_29 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_29 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_29;
        Or_Res_1 := Token_Res_29;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_30 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_30));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Goto)
   then
       Token_Pos_30 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_30 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_30 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_30;
        Or_Res_1 := Token_Res_30;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_31 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_31));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Exception)
   then
       Token_Pos_31 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Exception,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_31 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_31 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_31;
        Or_Res_1 := Token_Res_31;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_32 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_32));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Renames)
   then
       Token_Pos_32 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Renames,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_32 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_32 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_32;
        Or_Res_1 := Token_Res_32;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_33 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_33));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Channel)
   then
       Token_Pos_33 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Channel,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_33 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_33 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_33;
        Or_Res_1 := Token_Res_33;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_34 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_34));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Readable)
   then
       Token_Pos_34 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Readable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_34 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_34 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_34;
        Or_Res_1 := Token_Res_34;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_35 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_35));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Writable)
   then
       Token_Pos_35 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Writable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_35 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_35 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_35;
        Or_Res_1 := Token_Res_35;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_36 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_36));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Desc)
   then
       Token_Pos_36 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Desc,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_36 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_36 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_36;
        Or_Res_1 := Token_Res_36;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_37 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_37));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Append)
   then
       Token_Pos_37 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Append,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_37 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_37 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_37;
        Or_Res_1 := Token_Res_37;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_38 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_38));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Extend)
   then
       Token_Pos_38 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Extend,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_38 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_38 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_38;
        Or_Res_1 := Token_Res_38;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_39 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_39));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Read)
   then
       Token_Pos_39 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Read,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_39 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_39 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_39;
        Or_Res_1 := Token_Res_39;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_40 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_40));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Write)
   then
       Token_Pos_40 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Write,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_40 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_40 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_40;
        Or_Res_1 := Token_Res_40;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_41 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_41));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Reset)
   then
       Token_Pos_41 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Reset,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_41 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_41 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_41;
        Or_Res_1 := Token_Res_41;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_42 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_42));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Checksum)
   then
       Token_Pos_42 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_42 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_42 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_42;
        Or_Res_1 := Token_Res_42;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_43 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_43));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Valid_Checksum)
   then
       Token_Pos_43 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_43 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_43 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_43;
        Or_Res_1 := Token_Res_43;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_44 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_44));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Has_Data)
   then
       Token_Pos_44 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Has_Data,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_44 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_44 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_44;
        Or_Res_1 := Token_Res_44;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_45 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_45));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Head)
   then
       Token_Pos_45 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Head,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_45 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_45 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_45;
        Or_Res_1 := Token_Res_45;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_46 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_46));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Opaque)
   then
       Token_Pos_46 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Opaque,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_46 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_46 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_46;
        Or_Res_1 := Token_Res_46;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_47 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_47));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Present)
   then
       Token_Pos_47 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Present,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_47 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_47 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_47;
        Or_Res_1 := Token_Res_47;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_48 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_48));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Valid)
   then
       Token_Pos_48 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Valid,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_48 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_48 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_48;
        Or_Res_1 := Token_Res_48;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_49 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_49));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Initial)
   then
       Token_Pos_49 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Initial,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_49 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_49 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_49;
        Or_Res_1 := Token_Res_49;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_50 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_50));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Final)
   then
       Token_Pos_50 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Final,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_50 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_50 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_50;
        Or_Res_1 := Token_Res_50;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_51 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_51));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_And)
   then
       Token_Pos_51 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_51 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_51 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_51;
        Or_Res_1 := Token_Res_51;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_52 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_52));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Or)
   then
       Token_Pos_52 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_52 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_52 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_52;
        Or_Res_1 := Token_Res_52;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_53 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_53));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Case)
   then
       Token_Pos_53 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_53 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_53 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_53;
        Or_Res_1 := Token_Res_53;
        goto Exit_Or_1;
    end if;
    
--  Start tok_code

Token_Res_54 := Row_Pos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_54));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Unqualified_Identifier)
   then
       Token_Pos_54 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_1,
             Expected_Token_Id => RFLX_Unqualified_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_54 := Row_Pos_1 + 1;
   end if;
end;

--  End tok_code

    if Token_Pos_54 /= No_Token_Index then
        Or_Pos_1 := Token_Pos_54;
        Or_Res_1 := Token_Res_54;
        goto Exit_Or_1;
    end if;
<<Exit_Or_1>>

--  End or_code



if Or_Pos_1 /= No_Token_Index then

   Row_Pos_1 := Or_Pos_1;

else
   Row_Pos_1 := No_Token_Index;
   goto Exit_Row_1_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_1_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_1 /= No_Token_Index then

   Transform_Res_1 := Allocate_UnqualifiedID (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_1,
      Kind => RFLX_UnqualifiedID,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_1 = Pos
                            then No_Token_Index
                            else Row_Pos_1 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Unqualified_Identifier_Transform_Parse_0_Memo,
      Row_Pos_1 /= No_Token_Index,
      Transform_Res_1,
      Pos,
      Row_Pos_1);


   Parser.Current_Pos := Row_Pos_1;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_1;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Unqualified_Identifier_Transform_Parse_0;

   


function Numeric_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Numeric_Literal
is
   use Bare_Numeric_Literal_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_39 :
            Token_Index
               := No_Token_Index;
      Token_Pos_91 :
            Token_Index
               := No_Token_Index;
      Token_Res_91 :
            Token_Index
               := No_Token_Index;
      Transform_Res_39 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Numeric_Literal_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_39 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_39;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_39;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_39 := Pos;



--  Start tok_code

Token_Res_91 := Row_Pos_39;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_91));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Numeral)
   then
       Token_Pos_91 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_39 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_39,
             Expected_Token_Id => RFLX_Numeral,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_91 := Row_Pos_39 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_91 /= No_Token_Index then

   Row_Pos_39 := Token_Pos_91;

else
   Row_Pos_39 := No_Token_Index;
   goto Exit_Row_39_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_39_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_39 /= No_Token_Index then

   Transform_Res_39 := Allocate_Numeric_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_39,
      Kind => RFLX_Numeric_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_39 = Pos
                            then No_Token_Index
                            else Row_Pos_39 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Numeric_Literal_Transform_Parse_0_Memo,
      Row_Pos_39 /= No_Token_Index,
      Transform_Res_39,
      Pos,
      Row_Pos_39);


   Parser.Current_Pos := Row_Pos_39;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_39;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Numeric_Literal_Transform_Parse_0;

   


function Sequence_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Aggregate
is
   use Bare_Sequence_Aggregate_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_38 :
            Token_Index
               := No_Token_Index;
      Token_Pos_88 :
            Token_Index
               := No_Token_Index;
      Token_Res_88 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_1 :
            Token_Index
               := No_Token_Index;
      Tmp_List_1 :
            Free_Parse_List;
      Defer_Pos_45 :
            Token_Index
               := No_Token_Index;
      Defer_Res_45 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;
      Token_Pos_89 :
            Token_Index
               := No_Token_Index;
      Token_Res_89 :
            Token_Index
               := No_Token_Index;
      List_Pos_1 :
            Token_Index
               := No_Token_Index;
      List_Res_1 :
            Bare_Numeric_Literal_List
               := No_Bare_RFLX_Node;
      Token_Pos_90 :
            Token_Index
               := No_Token_Index;
      Token_Res_90 :
            Token_Index
               := No_Token_Index;
      Transform_Res_38 :
            Bare_Sequence_Aggregate
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Sequence_Aggregate_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_38 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_38;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_38;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_38 := Pos;



--  Start tok_code

Token_Res_88 := Row_Pos_38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_88));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Brack)
   then
       Token_Pos_88 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_38,
             Expected_Token_Id => RFLX_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_88 := Row_Pos_38 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_88 /= No_Token_Index then

   Row_Pos_38 := Token_Pos_88;

else
   Row_Pos_38 := No_Token_Index;
   goto Exit_Row_38_0;

end if;


--  Start list_code

    List_Pos_1 := Row_Pos_38;



Lst_Cpos_1 := Row_Pos_38;
Tmp_List_1 := Get_Parse_List (Parser);

loop
   
Defer_Res_45 :=
   Numeric_Literal_Transform_Parse_0 (Parser, Lst_Cpos_1);
Defer_Pos_45 := Parser.Current_Pos;


   exit when Defer_Pos_45 = No_Token_Index;

   List_Pos_1 := Defer_Pos_45;
   Lst_Cpos_1 := List_Pos_1;

   Tmp_List_1.Nodes.Append (Defer_Res_45);

      
--  Start tok_code

Token_Res_89 := Lst_Cpos_1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_89));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_89 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_1,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_89 := Lst_Cpos_1 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_89 /= No_Token_Index then
          Lst_Cpos_1 := Token_Pos_89;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_1.Nodes.Length;
begin
   List_Res_1 :=
      Allocate_Numeric_Literal_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_38;
      Token_End := (if Lst_Cpos_1 = Row_Pos_38
                    then Row_Pos_38
                    else Lst_Cpos_1 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_38, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_1,
      Kind              => RFLX_Numeric_Literal_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_1,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_1.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_1.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_1);

--  End list_code



if List_Pos_1 /= No_Token_Index then

   Row_Pos_38 := List_Pos_1;

else
   Row_Pos_38 := No_Token_Index;
   goto Exit_Row_38_0;

end if;


--  Start tok_code

Token_Res_90 := Row_Pos_38;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_90));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Brack)
   then
       Token_Pos_90 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_38 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_38,
             Expected_Token_Id => RFLX_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_90 := Row_Pos_38 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_90 /= No_Token_Index then

   Row_Pos_38 := Token_Pos_90;

else
   Row_Pos_38 := No_Token_Index;
   goto Exit_Row_38_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_38_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_38 /= No_Token_Index then

   Transform_Res_38 := Allocate_Sequence_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_38,
      Kind => RFLX_Sequence_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_38 = Pos
                            then No_Token_Index
                            else Row_Pos_38 - 1));

      Initialize_Fields_For_Sequence_Aggregate
        (Self => Transform_Res_38, Sequence_Aggregate_F_Values => List_Res_1);

         if List_Res_1 /= null and then Is_Incomplete (List_Res_1) then
            Transform_Res_38.Last_Attempted_Child := 0;
         elsif List_Res_1 /= null and then not Is_Ghost (List_Res_1) then
            Transform_Res_38.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Sequence_Aggregate_Transform_Parse_0_Memo,
      Row_Pos_38 /= No_Token_Index,
      Transform_Res_38,
      Pos,
      Row_Pos_38);


   Parser.Current_Pos := Row_Pos_38;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_38;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Sequence_Aggregate_Transform_Parse_0;

   


function String_Literal_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal
is
   use Bare_String_Literal_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_40 :
            Token_Index
               := No_Token_Index;
      Token_Pos_92 :
            Token_Index
               := No_Token_Index;
      Token_Res_92 :
            Token_Index
               := No_Token_Index;
      Transform_Res_40 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.String_Literal_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_40 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_40;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_40;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_40 := Pos;



--  Start tok_code

Token_Res_92 := Row_Pos_40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_92));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_String_Literal)
   then
       Token_Pos_92 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_40,
             Expected_Token_Id => RFLX_String_Literal,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_92 := Row_Pos_40 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_92 /= No_Token_Index then

   Row_Pos_40 := Token_Pos_92;

else
   Row_Pos_40 := No_Token_Index;
   goto Exit_Row_40_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_40_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_40 /= No_Token_Index then

   Transform_Res_40 := Allocate_String_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_40,
      Kind => RFLX_String_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_40 = Pos
                            then No_Token_Index
                            else Row_Pos_40 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.String_Literal_Transform_Parse_0_Memo,
      Row_Pos_40 /= No_Token_Index,
      Transform_Res_40,
      Pos,
      Row_Pos_40);


   Parser.Current_Pos := Row_Pos_40;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_40;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end String_Literal_Transform_Parse_0;

   


function Concatenation_Or_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Literal
is
   use Bare_Sequence_Literal_Memos;

   Call_Depth : aliased Natural;

      Nobt_7 :
            Boolean
               := False;
      Row_Pos_37 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_40 :
            Token_Index
               := No_Token_Index;
      Defer_Res_40 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;
      Token_Pos_87 :
            Token_Index
               := No_Token_Index;
      Token_Res_87 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_41 :
            Token_Index
               := No_Token_Index;
      Defer_Res_41 :
            Bare_Sequence_Aggregate
               := No_Bare_RFLX_Node;
      Defer_Pos_42 :
            Token_Index
               := No_Token_Index;
      Defer_Res_42 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;
      Or_Pos_16 :
            Token_Index
               := No_Token_Index;
      Or_Res_16 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;
      Row_Progress_7 :
            Integer
               := 0;
      Transform_Res_37 :
            Bare_Concatenation
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_7 :
            Boolean
               := False;
      Defer_Pos_43 :
            Token_Index
               := No_Token_Index;
      Defer_Res_43 :
            Bare_Sequence_Aggregate
               := No_Bare_RFLX_Node;
      Defer_Pos_44 :
            Token_Index
               := No_Token_Index;
      Defer_Res_44 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;
      Or_Pos_17 :
            Token_Index
               := No_Token_Index;
      Or_Res_17 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;
      Or_Pos_18 :
            Token_Index
               := No_Token_Index;
      Or_Res_18 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Sequence_Literal := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Concatenation_Or_Parse_2_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_18 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_18;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_18;
   end if;

       Set (Parser.Private_Part.Concatenation_Or_Parse_2_Memo, False, Or_Res_18, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_7 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_18 := No_Token_Index;
Or_Res_18 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_37 := Pos;



Defer_Res_40 :=
   Concatenation_Or_Parse_2 (Parser, Row_Pos_37);
Defer_Pos_40 := Parser.Current_Pos;


Row_Progress_7 := 1;

if Defer_Pos_40 /= No_Token_Index then

   Row_Pos_37 := Defer_Pos_40;

else
   Row_Pos_37 := No_Token_Index;
   goto Exit_Row_37_0;

end if;


--  Start tok_code

Token_Res_87 := Row_Pos_37;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_87));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Ampersand)
   then
       Token_Pos_87 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_37 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_37,
             Expected_Token_Id => RFLX_Ampersand,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_87 := Row_Pos_37 + 1;
   end if;
end;

--  End tok_code


Row_Progress_7 := 2;

if Token_Pos_87 /= No_Token_Index then

   Row_Pos_37 := Token_Pos_87;

else
   Row_Pos_37 := No_Token_Index;
   goto Exit_Row_37_0;

end if;

Nobt_7 := True;

Row_Progress_7 := 3;

if Row_Pos_37 /= No_Token_Index then

   Row_Pos_37 := Row_Pos_37;

else
   Row_Pos_37 := No_Token_Index;
   goto Exit_Row_37_0;

end if;


--  Start or_code

Or_Pos_16 := No_Token_Index;
Or_Res_16 := No_Bare_RFLX_Node;
    
Defer_Res_41 :=
   Sequence_Aggregate_Transform_Parse_0 (Parser, Row_Pos_37);
Defer_Pos_41 := Parser.Current_Pos;

    if Defer_Pos_41 /= No_Token_Index then
        Or_Pos_16 := Defer_Pos_41;
        Or_Res_16 := Defer_Res_41;
        goto Exit_Or_17;
    end if;
    
Defer_Res_42 :=
   String_Literal_Transform_Parse_0 (Parser, Row_Pos_37);
Defer_Pos_42 := Parser.Current_Pos;

    if Defer_Pos_42 /= No_Token_Index then
        Or_Pos_16 := Defer_Pos_42;
        Or_Res_16 := Defer_Res_42;
        goto Exit_Or_17;
    end if;
<<Exit_Or_17>>

--  End or_code


Row_Progress_7 := 4;

if Or_Pos_16 /= No_Token_Index then

   Row_Pos_37 := Or_Pos_16;

else
   Row_Pos_37 := No_Token_Index;
   goto Exit_Row_37_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_37_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_37 = No_Token_Index and then Nobt_7 then
   Row_Pos_37 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_7 := True;
end if;

if Row_Pos_37 /= No_Token_Index then

   Transform_Res_37 := Allocate_Concatenation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_37,
      Kind => RFLX_Concatenation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_37 = Pos
                            then No_Token_Index
                            else Row_Pos_37 - 1));

      Initialize_Fields_For_Concatenation
        (Self => Transform_Res_37, Concatenation_F_Left => Defer_Res_40, Concatenation_F_Right => Or_Res_16);

         if Defer_Res_40 /= null and then Is_Incomplete (Defer_Res_40) then
            Transform_Res_37.Last_Attempted_Child := 0;
         elsif Defer_Res_40 /= null and then not Is_Ghost (Defer_Res_40) then
            Transform_Res_37.Last_Attempted_Child := -1;
         end if;
         if Or_Res_16 /= null and then Is_Incomplete (Or_Res_16) then
            Transform_Res_37.Last_Attempted_Child := 0;
         elsif Or_Res_16 /= null and then not Is_Ghost (Or_Res_16) then
            Transform_Res_37.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_7 then
      Transform_Res_37.Last_Attempted_Child :=
         Row_Progress_7;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <concatenation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_37 /= No_Token_Index then
        Or_Pos_18 := Row_Pos_37;
        Or_Res_18 := Transform_Res_37;
        goto Exit_Or_16;
    end if;
    
--  Start or_code

Or_Pos_17 := No_Token_Index;
Or_Res_17 := No_Bare_RFLX_Node;
    
Defer_Res_43 :=
   Sequence_Aggregate_Transform_Parse_0 (Parser, Pos);
Defer_Pos_43 := Parser.Current_Pos;

    if Defer_Pos_43 /= No_Token_Index then
        Or_Pos_17 := Defer_Pos_43;
        Or_Res_17 := Defer_Res_43;
        goto Exit_Or_18;
    end if;
    
Defer_Res_44 :=
   String_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_44 := Parser.Current_Pos;

    if Defer_Pos_44 /= No_Token_Index then
        Or_Pos_17 := Defer_Pos_44;
        Or_Res_17 := Defer_Res_44;
        goto Exit_Or_18;
    end if;
<<Exit_Or_18>>

--  End or_code

    if Or_Pos_17 /= No_Token_Index then
        Or_Pos_18 := Or_Pos_17;
        Or_Res_18 := Or_Res_17;
        goto Exit_Or_16;
    end if;
<<Exit_Or_16>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_18 > Mem_Pos then
         Mem_Pos := Or_Pos_18;
         Mem_Res := Or_Res_18;
         Set
           (Parser.Private_Part.Concatenation_Or_Parse_2_Memo,
            Or_Pos_18 /= No_Token_Index,
            Or_Res_18,
            Pos,
            Or_Pos_18);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_18 := Mem_Res;
         Or_Pos_18 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Concatenation_Or_Parse_2_Memo,
      Or_Pos_18 /= No_Token_Index,
      Or_Res_18,
      Pos,
      Or_Pos_18);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_18;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_18;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Concatenation_Or_Parse_2;

   


function Quantified_Expression_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expression
is
   use Bare_Quantified_Expression_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_41 :
            Token_Index
               := No_Token_Index;
      Token_Pos_93 :
            Token_Index
               := No_Token_Index;
      Token_Res_93 :
            Token_Index
               := No_Token_Index;
      Row_Pos_42 :
            Token_Index
               := No_Token_Index;
      Token_Pos_94 :
            Token_Index
               := No_Token_Index;
      Token_Res_94 :
            Token_Index
               := No_Token_Index;
      Transform_Res_41 :
            Bare_Quantifier_All
               := No_Bare_RFLX_Node;
      Row_Pos_43 :
            Token_Index
               := No_Token_Index;
      Token_Pos_95 :
            Token_Index
               := No_Token_Index;
      Token_Res_95 :
            Token_Index
               := No_Token_Index;
      Transform_Res_42 :
            Bare_Quantifier_Some
               := No_Bare_RFLX_Node;
      Or_Pos_19 :
            Token_Index
               := No_Token_Index;
      Or_Res_19 :
            Bare_Quantifier
               := No_Bare_RFLX_Node;
      Defer_Pos_46 :
            Token_Index
               := No_Token_Index;
      Defer_Res_46 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_96 :
            Token_Index
               := No_Token_Index;
      Token_Res_96 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_47 :
            Token_Index
               := No_Token_Index;
      Defer_Res_47 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_97 :
            Token_Index
               := No_Token_Index;
      Token_Res_97 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_48 :
            Token_Index
               := No_Token_Index;
      Defer_Res_48 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_43 :
            Bare_Quantified_Expression
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Quantified_Expression_Transform_Parse_2_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_43 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_43;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_43;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_41 := Pos;



--  Start tok_code

Token_Res_93 := Row_Pos_41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_93));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_For)
   then
       Token_Pos_93 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_41,
             Expected_Token_Id => RFLX_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_93 := Row_Pos_41 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_93 /= No_Token_Index then

   Row_Pos_41 := Token_Pos_93;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


--  Start or_code

Or_Pos_19 := No_Token_Index;
Or_Res_19 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_42 := Row_Pos_41;



--  Start tok_code

Token_Res_94 := Row_Pos_42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_94));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_All)
   then
       Token_Pos_94 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_42,
             Expected_Token_Id => RFLX_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_94 := Row_Pos_42 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_94 /= No_Token_Index then

   Row_Pos_42 := Token_Pos_94;

else
   Row_Pos_42 := No_Token_Index;
   goto Exit_Row_42_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_42_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_42 /= No_Token_Index then

   Transform_Res_41 := Allocate_Quantifier_All (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_41,
      Kind => RFLX_Quantifier_All,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_41,
      Token_End_Index   => (if Row_Pos_42 = Row_Pos_41
                            then No_Token_Index
                            else Row_Pos_42 - 1));




end if;

--  End transform_code

    if Row_Pos_42 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_42;
        Or_Res_19 := Transform_Res_41;
        goto Exit_Or_19;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_43 := Row_Pos_41;



--  Start tok_code

Token_Res_95 := Row_Pos_43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_95));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Some)
   then
       Token_Pos_95 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_43,
             Expected_Token_Id => RFLX_Some,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_95 := Row_Pos_43 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_95 /= No_Token_Index then

   Row_Pos_43 := Token_Pos_95;

else
   Row_Pos_43 := No_Token_Index;
   goto Exit_Row_43_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_43_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_43 /= No_Token_Index then

   Transform_Res_42 := Allocate_Quantifier_Some (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_42,
      Kind => RFLX_Quantifier_Some,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_41,
      Token_End_Index   => (if Row_Pos_43 = Row_Pos_41
                            then No_Token_Index
                            else Row_Pos_43 - 1));




end if;

--  End transform_code

    if Row_Pos_43 /= No_Token_Index then
        Or_Pos_19 := Row_Pos_43;
        Or_Res_19 := Transform_Res_42;
        goto Exit_Or_19;
    end if;
<<Exit_Or_19>>

--  End or_code



if Or_Pos_19 /= No_Token_Index then

   Row_Pos_41 := Or_Pos_19;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


Defer_Res_46 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_41);
Defer_Pos_46 := Parser.Current_Pos;



if Defer_Pos_46 /= No_Token_Index then

   Row_Pos_41 := Defer_Pos_46;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


--  Start tok_code

Token_Res_96 := Row_Pos_41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_96));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_In)
   then
       Token_Pos_96 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_41,
             Expected_Token_Id => RFLX_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_96 := Row_Pos_41 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_96 /= No_Token_Index then

   Row_Pos_41 := Token_Pos_96;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


Defer_Res_47 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_41);
Defer_Pos_47 := Parser.Current_Pos;



if Defer_Pos_47 /= No_Token_Index then

   Row_Pos_41 := Defer_Pos_47;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


--  Start tok_code

Token_Res_97 := Row_Pos_41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_97));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_97 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_41,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_97 := Row_Pos_41 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_97 /= No_Token_Index then

   Row_Pos_41 := Token_Pos_97;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;


Defer_Res_48 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_41);
Defer_Pos_48 := Parser.Current_Pos;



if Defer_Pos_48 /= No_Token_Index then

   Row_Pos_41 := Defer_Pos_48;

else
   Row_Pos_41 := No_Token_Index;
   goto Exit_Row_41_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_41_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_41 /= No_Token_Index then

   Transform_Res_43 := Allocate_Quantified_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_43,
      Kind => RFLX_Quantified_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_41 = Pos
                            then No_Token_Index
                            else Row_Pos_41 - 1));

      Initialize_Fields_For_Quantified_Expression
        (Self => Transform_Res_43, Quantified_Expression_F_Operation => Or_Res_19, Quantified_Expression_F_Parameter_Identifier => Defer_Res_46, Quantified_Expression_F_Iterable => Defer_Res_47, Quantified_Expression_F_Predicate => Defer_Res_48);

         if Or_Res_19 /= null and then Is_Incomplete (Or_Res_19) then
            Transform_Res_43.Last_Attempted_Child := 0;
         elsif Or_Res_19 /= null and then not Is_Ghost (Or_Res_19) then
            Transform_Res_43.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_46 /= null and then Is_Incomplete (Defer_Res_46) then
            Transform_Res_43.Last_Attempted_Child := 0;
         elsif Defer_Res_46 /= null and then not Is_Ghost (Defer_Res_46) then
            Transform_Res_43.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_47 /= null and then Is_Incomplete (Defer_Res_47) then
            Transform_Res_43.Last_Attempted_Child := 0;
         elsif Defer_Res_47 /= null and then not Is_Ghost (Defer_Res_47) then
            Transform_Res_43.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_48 /= null and then Is_Incomplete (Defer_Res_48) then
            Transform_Res_43.Last_Attempted_Child := 0;
         elsif Defer_Res_48 /= null and then not Is_Ghost (Defer_Res_48) then
            Transform_Res_43.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Quantified_Expression_Transform_Parse_2_Memo,
      Row_Pos_41 /= No_Token_Index,
      Transform_Res_43,
      Pos,
      Row_Pos_41);


   Parser.Current_Pos := Row_Pos_41;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_43;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Quantified_Expression_Transform_Parse_2;

   


function Comprehension_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Comprehension
is
   use Bare_Comprehension_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_44 :
            Token_Index
               := No_Token_Index;
      Token_Pos_98 :
            Token_Index
               := No_Token_Index;
      Token_Res_98 :
            Token_Index
               := No_Token_Index;
      Token_Pos_99 :
            Token_Index
               := No_Token_Index;
      Token_Res_99 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_49 :
            Token_Index
               := No_Token_Index;
      Defer_Res_49 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_100 :
            Token_Index
               := No_Token_Index;
      Token_Res_100 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_50 :
            Token_Index
               := No_Token_Index;
      Defer_Res_50 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_45 :
            Token_Index
               := No_Token_Index;
      Token_Pos_101 :
            Token_Index
               := No_Token_Index;
      Token_Res_101 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_51 :
            Token_Index
               := No_Token_Index;
      Defer_Res_51 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_102 :
            Token_Index
               := No_Token_Index;
      Token_Res_102 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_52 :
            Token_Index
               := No_Token_Index;
      Defer_Res_52 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_103 :
            Token_Index
               := No_Token_Index;
      Token_Res_103 :
            Token_Index
               := No_Token_Index;
      Transform_Res_44 :
            Bare_Comprehension
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Comprehension_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_44 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_44;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_44;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_44 := Pos;



--  Start tok_code

Token_Res_98 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_98));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Brack)
   then
       Token_Pos_98 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => RFLX_L_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_98 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_98 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_98;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


--  Start tok_code

Token_Res_99 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_99));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_For)
   then
       Token_Pos_99 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => RFLX_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_99 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_99 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_99;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


Defer_Res_49 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_44);
Defer_Pos_49 := Parser.Current_Pos;



if Defer_Pos_49 /= No_Token_Index then

   Row_Pos_44 := Defer_Pos_49;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


--  Start tok_code

Token_Res_100 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_100));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_In)
   then
       Token_Pos_100 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => RFLX_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_100 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_100 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_100;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


Defer_Res_50 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_44);
Defer_Pos_50 := Parser.Current_Pos;



if Defer_Pos_50 /= No_Token_Index then

   Row_Pos_44 := Defer_Pos_50;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_45 := Row_Pos_44;



--  Start tok_code

Token_Res_101 := Row_Pos_45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_101));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_If)
   then
       Token_Pos_101 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_45,
             Expected_Token_Id => RFLX_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_101 := Row_Pos_45 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_101 /= No_Token_Index then

   Row_Pos_45 := Token_Pos_101;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_45_0;

end if;


Defer_Res_51 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_45);
Defer_Pos_51 := Parser.Current_Pos;



if Defer_Pos_51 /= No_Token_Index then

   Row_Pos_45 := Defer_Pos_51;

else
   Row_Pos_45 := No_Token_Index;
   goto Exit_Row_45_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_45_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_45 = No_Token_Index then

        Defer_Res_51 := No_Bare_RFLX_Node;


    Row_Pos_45 := Row_Pos_44;


end if;

--  End opt_code



if Row_Pos_45 /= No_Token_Index then

   Row_Pos_44 := Row_Pos_45;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


--  Start tok_code

Token_Res_102 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_102));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_102 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_102 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_102 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_102;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


Defer_Res_52 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_44);
Defer_Pos_52 := Parser.Current_Pos;



if Defer_Pos_52 /= No_Token_Index then

   Row_Pos_44 := Defer_Pos_52;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;


--  Start tok_code

Token_Res_103 := Row_Pos_44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_103));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Brack)
   then
       Token_Pos_103 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_44,
             Expected_Token_Id => RFLX_R_Brack,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_103 := Row_Pos_44 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_103 /= No_Token_Index then

   Row_Pos_44 := Token_Pos_103;

else
   Row_Pos_44 := No_Token_Index;
   goto Exit_Row_44_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_44_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_44 /= No_Token_Index then

   Transform_Res_44 := Allocate_Comprehension (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_44,
      Kind => RFLX_Comprehension,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_44 = Pos
                            then No_Token_Index
                            else Row_Pos_44 - 1));

      Initialize_Fields_For_Comprehension
        (Self => Transform_Res_44, Comprehension_F_Iterator => Defer_Res_49, Comprehension_F_Sequence => Defer_Res_50, Comprehension_F_Condition => Defer_Res_51, Comprehension_F_Selector => Defer_Res_52);

         if Defer_Res_49 /= null and then Is_Incomplete (Defer_Res_49) then
            Transform_Res_44.Last_Attempted_Child := 0;
         elsif Defer_Res_49 /= null and then not Is_Ghost (Defer_Res_49) then
            Transform_Res_44.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_50 /= null and then Is_Incomplete (Defer_Res_50) then
            Transform_Res_44.Last_Attempted_Child := 0;
         elsif Defer_Res_50 /= null and then not Is_Ghost (Defer_Res_50) then
            Transform_Res_44.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_51 /= null and then Is_Incomplete (Defer_Res_51) then
            Transform_Res_44.Last_Attempted_Child := 0;
         elsif Defer_Res_51 /= null and then not Is_Ghost (Defer_Res_51) then
            Transform_Res_44.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_52 /= null and then Is_Incomplete (Defer_Res_52) then
            Transform_Res_44.Last_Attempted_Child := 0;
         elsif Defer_Res_52 /= null and then not Is_Ghost (Defer_Res_52) then
            Transform_Res_44.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Comprehension_Transform_Parse_0_Memo,
      Row_Pos_44 /= No_Token_Index,
      Transform_Res_44,
      Pos,
      Row_Pos_44);


   Parser.Current_Pos := Row_Pos_44;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_44;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Comprehension_Transform_Parse_0;

   


function Call_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call
is
   use Bare_Call_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_46 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_53 :
            Token_Index
               := No_Token_Index;
      Defer_Res_53 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_104 :
            Token_Index
               := No_Token_Index;
      Token_Res_104 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_2 :
            Token_Index
               := No_Token_Index;
      Tmp_List_2 :
            Free_Parse_List;
      Defer_Pos_54 :
            Token_Index
               := No_Token_Index;
      Defer_Res_54 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_105 :
            Token_Index
               := No_Token_Index;
      Token_Res_105 :
            Token_Index
               := No_Token_Index;
      List_Pos_2 :
            Token_Index
               := No_Token_Index;
      List_Res_2 :
            Bare_Expr_List
               := No_Bare_RFLX_Node;
      Token_Pos_106 :
            Token_Index
               := No_Token_Index;
      Token_Res_106 :
            Token_Index
               := No_Token_Index;
      Transform_Res_45 :
            Bare_Call
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Call_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_45 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_45;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_45;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_46 := Pos;



Defer_Res_53 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_46);
Defer_Pos_53 := Parser.Current_Pos;



if Defer_Pos_53 /= No_Token_Index then

   Row_Pos_46 := Defer_Pos_53;

else
   Row_Pos_46 := No_Token_Index;
   goto Exit_Row_46_0;

end if;


--  Start tok_code

Token_Res_104 := Row_Pos_46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_104));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_104 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_46,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_104 := Row_Pos_46 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_104 /= No_Token_Index then

   Row_Pos_46 := Token_Pos_104;

else
   Row_Pos_46 := No_Token_Index;
   goto Exit_Row_46_0;

end if;


--  Start list_code

    List_Pos_2 := No_Token_Index;



Lst_Cpos_2 := Row_Pos_46;
Tmp_List_2 := Get_Parse_List (Parser);

loop
   
Defer_Res_54 :=
   Extended_Expression_Or_Parse_1 (Parser, Lst_Cpos_2);
Defer_Pos_54 := Parser.Current_Pos;


   exit when Defer_Pos_54 = No_Token_Index;

   List_Pos_2 := Defer_Pos_54;
   Lst_Cpos_2 := List_Pos_2;

   Tmp_List_2.Nodes.Append (Defer_Res_54);

      
--  Start tok_code

Token_Res_105 := Lst_Cpos_2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_105));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_105 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_2,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_105 := Lst_Cpos_2 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_105 /= No_Token_Index then
          Lst_Cpos_2 := Token_Pos_105;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_2.Nodes.Length;
begin
   List_Res_2 :=
      Allocate_Expr_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_46;
      Token_End := (if Lst_Cpos_2 = Row_Pos_46
                    then Row_Pos_46
                    else Lst_Cpos_2 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_46, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_2,
      Kind              => RFLX_Expr_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_2,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_2.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_2.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_2);

--  End list_code



if List_Pos_2 /= No_Token_Index then

   Row_Pos_46 := List_Pos_2;

else
   Row_Pos_46 := No_Token_Index;
   goto Exit_Row_46_0;

end if;


--  Start tok_code

Token_Res_106 := Row_Pos_46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_106));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_106 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_46,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_106 := Row_Pos_46 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_106 /= No_Token_Index then

   Row_Pos_46 := Token_Pos_106;

else
   Row_Pos_46 := No_Token_Index;
   goto Exit_Row_46_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_46_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_46 /= No_Token_Index then

   Transform_Res_45 := Allocate_Call (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_45,
      Kind => RFLX_Call,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_46 = Pos
                            then No_Token_Index
                            else Row_Pos_46 - 1));

      Initialize_Fields_For_Call
        (Self => Transform_Res_45, Call_F_Identifier => Defer_Res_53, Call_F_Arguments => List_Res_2);

         if Defer_Res_53 /= null and then Is_Incomplete (Defer_Res_53) then
            Transform_Res_45.Last_Attempted_Child := 0;
         elsif Defer_Res_53 /= null and then not Is_Ghost (Defer_Res_53) then
            Transform_Res_45.Last_Attempted_Child := -1;
         end if;
         if List_Res_2 /= null and then Is_Incomplete (List_Res_2) then
            Transform_Res_45.Last_Attempted_Child := 0;
         elsif List_Res_2 /= null and then not Is_Ghost (List_Res_2) then
            Transform_Res_45.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Call_Transform_Parse_0_Memo,
      Row_Pos_46 /= No_Token_Index,
      Transform_Res_45,
      Pos,
      Row_Pos_46);


   Parser.Current_Pos := Row_Pos_46;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_45;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Call_Transform_Parse_0;

   


function Qualified_Identifier_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_ID
is
   use Bare_ID_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_48 :
            Token_Index
               := No_Token_Index;
      Row_Pos_49 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_57 :
            Token_Index
               := No_Token_Index;
      Defer_Res_57 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_109 :
            Token_Index
               := No_Token_Index;
      Token_Res_109 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_58 :
            Token_Index
               := No_Token_Index;
      Defer_Res_58 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Transform_Res_47 :
            Bare_ID
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Qualified_Identifier_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_47 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_47;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_47;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_48 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_49 := Row_Pos_48;



Defer_Res_57 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_49);
Defer_Pos_57 := Parser.Current_Pos;



if Defer_Pos_57 /= No_Token_Index then

   Row_Pos_49 := Defer_Pos_57;

else
   Row_Pos_49 := No_Token_Index;
   goto Exit_Row_49_0;

end if;


--  Start tok_code

Token_Res_109 := Row_Pos_49;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_109));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Double_Colon)
   then
       Token_Pos_109 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_49 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_49,
             Expected_Token_Id => RFLX_Double_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_109 := Row_Pos_49 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_109 /= No_Token_Index then

   Row_Pos_49 := Token_Pos_109;

else
   Row_Pos_49 := No_Token_Index;
   goto Exit_Row_49_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_49_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_49 = No_Token_Index then

        Defer_Res_57 := No_Bare_RFLX_Node;


    Row_Pos_49 := Row_Pos_48;


end if;

--  End opt_code



if Row_Pos_49 /= No_Token_Index then

   Row_Pos_48 := Row_Pos_49;

else
   Row_Pos_48 := No_Token_Index;
   goto Exit_Row_48_0;

end if;


Defer_Res_58 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_48);
Defer_Pos_58 := Parser.Current_Pos;



if Defer_Pos_58 /= No_Token_Index then

   Row_Pos_48 := Defer_Pos_58;

else
   Row_Pos_48 := No_Token_Index;
   goto Exit_Row_48_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_48_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_48 /= No_Token_Index then

   Transform_Res_47 := Allocate_ID (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_47,
      Kind => RFLX_ID,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_48 = Pos
                            then No_Token_Index
                            else Row_Pos_48 - 1));

      Initialize_Fields_For_ID
        (Self => Transform_Res_47, ID_F_Package => Defer_Res_57, ID_F_Name => Defer_Res_58);

         if Defer_Res_57 /= null and then Is_Incomplete (Defer_Res_57) then
            Transform_Res_47.Last_Attempted_Child := 0;
         elsif Defer_Res_57 /= null and then not Is_Ghost (Defer_Res_57) then
            Transform_Res_47.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_58 /= null and then Is_Incomplete (Defer_Res_58) then
            Transform_Res_47.Last_Attempted_Child := 0;
         elsif Defer_Res_58 /= null and then not Is_Ghost (Defer_Res_58) then
            Transform_Res_47.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Qualified_Identifier_Transform_Parse_0_Memo,
      Row_Pos_48 /= No_Token_Index,
      Transform_Res_47,
      Pos,
      Row_Pos_48);


   Parser.Current_Pos := Row_Pos_48;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_47;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Qualified_Identifier_Transform_Parse_0;

   


function Conversion_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conversion
is
   use Bare_Conversion_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_47 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_55 :
            Token_Index
               := No_Token_Index;
      Defer_Res_55 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Token_Pos_107 :
            Token_Index
               := No_Token_Index;
      Token_Res_107 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_56 :
            Token_Index
               := No_Token_Index;
      Defer_Res_56 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_108 :
            Token_Index
               := No_Token_Index;
      Token_Res_108 :
            Token_Index
               := No_Token_Index;
      Transform_Res_46 :
            Bare_Conversion
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Conversion_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_46 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_46;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_46;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_47 := Pos;



Defer_Res_55 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_47);
Defer_Pos_55 := Parser.Current_Pos;



if Defer_Pos_55 /= No_Token_Index then

   Row_Pos_47 := Defer_Pos_55;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_47_0;

end if;


--  Start tok_code

Token_Res_107 := Row_Pos_47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_107));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_107 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_47,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_107 := Row_Pos_47 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_107 /= No_Token_Index then

   Row_Pos_47 := Token_Pos_107;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_47_0;

end if;


Defer_Res_56 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_47);
Defer_Pos_56 := Parser.Current_Pos;



if Defer_Pos_56 /= No_Token_Index then

   Row_Pos_47 := Defer_Pos_56;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_47_0;

end if;


--  Start tok_code

Token_Res_108 := Row_Pos_47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_108));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_108 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_47,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_108 := Row_Pos_47 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_108 /= No_Token_Index then

   Row_Pos_47 := Token_Pos_108;

else
   Row_Pos_47 := No_Token_Index;
   goto Exit_Row_47_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_47_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_47 /= No_Token_Index then

   Transform_Res_46 := Allocate_Conversion (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_46,
      Kind => RFLX_Conversion,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_47 = Pos
                            then No_Token_Index
                            else Row_Pos_47 - 1));

      Initialize_Fields_For_Conversion
        (Self => Transform_Res_46, Conversion_F_Target_Identifier => Defer_Res_55, Conversion_F_Argument => Defer_Res_56);

         if Defer_Res_55 /= null and then Is_Incomplete (Defer_Res_55) then
            Transform_Res_46.Last_Attempted_Child := 0;
         elsif Defer_Res_55 /= null and then not Is_Ghost (Defer_Res_55) then
            Transform_Res_46.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_56 /= null and then Is_Incomplete (Defer_Res_56) then
            Transform_Res_46.Last_Attempted_Child := 0;
         elsif Defer_Res_56 /= null and then not Is_Ghost (Defer_Res_56) then
            Transform_Res_46.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Conversion_Transform_Parse_0_Memo,
      Row_Pos_47 /= No_Token_Index,
      Transform_Res_46,
      Pos,
      Row_Pos_47);


   Parser.Current_Pos := Row_Pos_47;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_46;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Conversion_Transform_Parse_0;

   


function Null_Message_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Aggregate
is
   use Bare_Null_Message_Aggregate_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_51 :
            Token_Index
               := No_Token_Index;
      Token_Pos_113 :
            Token_Index
               := No_Token_Index;
      Token_Res_113 :
            Token_Index
               := No_Token_Index;
      Token_Pos_114 :
            Token_Index
               := No_Token_Index;
      Token_Res_114 :
            Token_Index
               := No_Token_Index;
      Transform_Res_49 :
            Bare_Null_Message_Aggregate
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_49 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_49;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_49;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_51 := Pos;



--  Start tok_code

Token_Res_113 := Row_Pos_51;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_113));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_113 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_51 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_51,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_113 := Row_Pos_51 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_113 /= No_Token_Index then

   Row_Pos_51 := Token_Pos_113;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_51_0;

end if;


--  Start tok_code

Token_Res_114 := Row_Pos_51;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_114));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Message)
   then
       Token_Pos_114 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_51 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_51,
             Expected_Token_Id => RFLX_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_114 := Row_Pos_51 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_114 /= No_Token_Index then

   Row_Pos_51 := Token_Pos_114;

else
   Row_Pos_51 := No_Token_Index;
   goto Exit_Row_51_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_51_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_51 /= No_Token_Index then

   Transform_Res_49 := Allocate_Null_Message_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_49,
      Kind => RFLX_Null_Message_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_51 = Pos
                            then No_Token_Index
                            else Row_Pos_51 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse_0_Memo,
      Row_Pos_51 /= No_Token_Index,
      Transform_Res_49,
      Pos,
      Row_Pos_51);


   Parser.Current_Pos := Row_Pos_51;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_49;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Null_Message_Aggregate_Transform_Parse_0;

   


function Message_Aggregate_Association_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Association
is
   use Bare_Message_Aggregate_Association_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_53 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_63 :
            Token_Index
               := No_Token_Index;
      Defer_Res_63 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_116 :
            Token_Index
               := No_Token_Index;
      Token_Res_116 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_64 :
            Token_Index
               := No_Token_Index;
      Defer_Res_64 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_51 :
            Bare_Message_Aggregate_Association
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_51 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_51;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_51;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_53 := Pos;



Defer_Res_63 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_53);
Defer_Pos_63 := Parser.Current_Pos;



if Defer_Pos_63 /= No_Token_Index then

   Row_Pos_53 := Defer_Pos_63;

else
   Row_Pos_53 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


--  Start tok_code

Token_Res_116 := Row_Pos_53;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_116));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_116 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_53 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_53,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_116 := Row_Pos_53 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_116 /= No_Token_Index then

   Row_Pos_53 := Token_Pos_116;

else
   Row_Pos_53 := No_Token_Index;
   goto Exit_Row_53_0;

end if;


Defer_Res_64 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_53);
Defer_Pos_64 := Parser.Current_Pos;



if Defer_Pos_64 /= No_Token_Index then

   Row_Pos_53 := Defer_Pos_64;

else
   Row_Pos_53 := No_Token_Index;
   goto Exit_Row_53_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_53_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_53 /= No_Token_Index then

   Transform_Res_51 := Allocate_Message_Aggregate_Association (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_51,
      Kind => RFLX_Message_Aggregate_Association,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_53 = Pos
                            then No_Token_Index
                            else Row_Pos_53 - 1));

      Initialize_Fields_For_Message_Aggregate_Association
        (Self => Transform_Res_51, Message_Aggregate_Association_F_Identifier => Defer_Res_63, Message_Aggregate_Association_F_Expression => Defer_Res_64);

         if Defer_Res_63 /= null and then Is_Incomplete (Defer_Res_63) then
            Transform_Res_51.Last_Attempted_Child := 0;
         elsif Defer_Res_63 /= null and then not Is_Ghost (Defer_Res_63) then
            Transform_Res_51.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_64 /= null and then Is_Incomplete (Defer_Res_64) then
            Transform_Res_51.Last_Attempted_Child := 0;
         elsif Defer_Res_64 /= null and then not Is_Ghost (Defer_Res_64) then
            Transform_Res_51.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse_0_Memo,
      Row_Pos_53 /= No_Token_Index,
      Transform_Res_51,
      Pos,
      Row_Pos_53);


   Parser.Current_Pos := Row_Pos_53;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_51;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Aggregate_Association_Transform_Parse_0;

   


function Message_Aggregate_Association_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate_Associations
is
   use Bare_Message_Aggregate_Associations_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_52 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_3 :
            Token_Index
               := No_Token_Index;
      Tmp_List_3 :
            Free_Parse_List;
      Defer_Pos_62 :
            Token_Index
               := No_Token_Index;
      Defer_Res_62 :
            Bare_Message_Aggregate_Association
               := No_Bare_RFLX_Node;
      Token_Pos_115 :
            Token_Index
               := No_Token_Index;
      Token_Res_115 :
            Token_Index
               := No_Token_Index;
      List_Pos_3 :
            Token_Index
               := No_Token_Index;
      List_Res_3 :
            Bare_Message_Aggregate_Association_List
               := No_Bare_RFLX_Node;
      Transform_Res_50 :
            Bare_Message_Aggregate_Associations
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_50 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_50;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_50;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_52 := Pos;



--  Start list_code

    List_Pos_3 := No_Token_Index;



Lst_Cpos_3 := Row_Pos_52;
Tmp_List_3 := Get_Parse_List (Parser);

loop
   
Defer_Res_62 :=
   Message_Aggregate_Association_Transform_Parse_0 (Parser, Lst_Cpos_3);
Defer_Pos_62 := Parser.Current_Pos;


   exit when Defer_Pos_62 = No_Token_Index;

   List_Pos_3 := Defer_Pos_62;
   Lst_Cpos_3 := List_Pos_3;

   Tmp_List_3.Nodes.Append (Defer_Res_62);

      
--  Start tok_code

Token_Res_115 := Lst_Cpos_3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_115));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_115 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_3,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_115 := Lst_Cpos_3 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_115 /= No_Token_Index then
          Lst_Cpos_3 := Token_Pos_115;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_3.Nodes.Length;
begin
   List_Res_3 :=
      Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_52;
      Token_End := (if Lst_Cpos_3 = Row_Pos_52
                    then Row_Pos_52
                    else Lst_Cpos_3 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_52, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_3,
      Kind              => RFLX_Message_Aggregate_Association_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_3,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_3.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_3.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_3);

--  End list_code



if List_Pos_3 /= No_Token_Index then

   Row_Pos_52 := List_Pos_3;

else
   Row_Pos_52 := No_Token_Index;
   goto Exit_Row_52_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_52_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_52 /= No_Token_Index then

   Transform_Res_50 := Allocate_Message_Aggregate_Associations (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_50,
      Kind => RFLX_Message_Aggregate_Associations,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_52 = Pos
                            then No_Token_Index
                            else Row_Pos_52 - 1));

      Initialize_Fields_For_Message_Aggregate_Associations
        (Self => Transform_Res_50, Message_Aggregate_Associations_F_Associations => List_Res_3);

         if List_Res_3 /= null and then Is_Incomplete (List_Res_3) then
            Transform_Res_50.Last_Attempted_Child := 0;
         elsif List_Res_3 /= null and then not Is_Ghost (List_Res_3) then
            Transform_Res_50.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse_0_Memo,
      Row_Pos_52 /= No_Token_Index,
      Transform_Res_50,
      Pos,
      Row_Pos_52);


   Parser.Current_Pos := Row_Pos_52;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_50;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Aggregate_Association_List_Transform_Parse_0;

   


function Message_Aggregate_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aggregate
is
   use Bare_Message_Aggregate_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_50 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_59 :
            Token_Index
               := No_Token_Index;
      Defer_Res_59 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Token_Pos_110 :
            Token_Index
               := No_Token_Index;
      Token_Res_110 :
            Token_Index
               := No_Token_Index;
      Token_Pos_111 :
            Token_Index
               := No_Token_Index;
      Token_Res_111 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_60 :
            Token_Index
               := No_Token_Index;
      Defer_Res_60 :
            Bare_Null_Message_Aggregate
               := No_Bare_RFLX_Node;
      Defer_Pos_61 :
            Token_Index
               := No_Token_Index;
      Defer_Res_61 :
            Bare_Message_Aggregate_Associations
               := No_Bare_RFLX_Node;
      Or_Pos_20 :
            Token_Index
               := No_Token_Index;
      Or_Res_20 :
            Bare_Base_Aggregate
               := No_Bare_RFLX_Node;
      Token_Pos_112 :
            Token_Index
               := No_Token_Index;
      Token_Res_112 :
            Token_Index
               := No_Token_Index;
      Transform_Res_48 :
            Bare_Message_Aggregate
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aggregate_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_48 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_48;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_48;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_50 := Pos;



Defer_Res_59 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_50);
Defer_Pos_59 := Parser.Current_Pos;



if Defer_Pos_59 /= No_Token_Index then

   Row_Pos_50 := Defer_Pos_59;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_50_0;

end if;


--  Start tok_code

Token_Res_110 := Row_Pos_50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_110));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Tick)
   then
       Token_Pos_110 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_50,
             Expected_Token_Id => RFLX_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_110 := Row_Pos_50 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_110 /= No_Token_Index then

   Row_Pos_50 := Token_Pos_110;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_50_0;

end if;


--  Start tok_code

Token_Res_111 := Row_Pos_50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_111));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_111 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_50,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_111 := Row_Pos_50 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_111 /= No_Token_Index then

   Row_Pos_50 := Token_Pos_111;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_50_0;

end if;


--  Start or_code

Or_Pos_20 := No_Token_Index;
Or_Res_20 := No_Bare_RFLX_Node;
    
Defer_Res_60 :=
   Null_Message_Aggregate_Transform_Parse_0 (Parser, Row_Pos_50);
Defer_Pos_60 := Parser.Current_Pos;

    if Defer_Pos_60 /= No_Token_Index then
        Or_Pos_20 := Defer_Pos_60;
        Or_Res_20 := Defer_Res_60;
        goto Exit_Or_20;
    end if;
    
Defer_Res_61 :=
   Message_Aggregate_Association_List_Transform_Parse_0 (Parser, Row_Pos_50);
Defer_Pos_61 := Parser.Current_Pos;

    if Defer_Pos_61 /= No_Token_Index then
        Or_Pos_20 := Defer_Pos_61;
        Or_Res_20 := Defer_Res_61;
        goto Exit_Or_20;
    end if;
<<Exit_Or_20>>

--  End or_code



if Or_Pos_20 /= No_Token_Index then

   Row_Pos_50 := Or_Pos_20;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_50_0;

end if;


--  Start tok_code

Token_Res_112 := Row_Pos_50;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_112));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_112 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_50 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_50,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_112 := Row_Pos_50 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_112 /= No_Token_Index then

   Row_Pos_50 := Token_Pos_112;

else
   Row_Pos_50 := No_Token_Index;
   goto Exit_Row_50_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_50_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_50 /= No_Token_Index then

   Transform_Res_48 := Allocate_Message_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_48,
      Kind => RFLX_Message_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_50 = Pos
                            then No_Token_Index
                            else Row_Pos_50 - 1));

      Initialize_Fields_For_Message_Aggregate
        (Self => Transform_Res_48, Message_Aggregate_F_Identifier => Defer_Res_59, Message_Aggregate_F_Values => Or_Res_20);

         if Defer_Res_59 /= null and then Is_Incomplete (Defer_Res_59) then
            Transform_Res_48.Last_Attempted_Child := 0;
         elsif Defer_Res_59 /= null and then not Is_Ghost (Defer_Res_59) then
            Transform_Res_48.Last_Attempted_Child := -1;
         end if;
         if Or_Res_20 /= null and then Is_Incomplete (Or_Res_20) then
            Transform_Res_48.Last_Attempted_Child := 0;
         elsif Or_Res_20 /= null and then not Is_Ghost (Or_Res_20) then
            Transform_Res_48.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aggregate_Transform_Parse_0_Memo,
      Row_Pos_50 /= No_Token_Index,
      Transform_Res_48,
      Pos,
      Row_Pos_50);


   Parser.Current_Pos := Row_Pos_50;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_48;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Aggregate_Transform_Parse_0;

   


function Variable_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable
is
   use Bare_Variable_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_54 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_65 :
            Token_Index
               := No_Token_Index;
      Defer_Res_65 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Transform_Res_52 :
            Bare_Variable
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Variable_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_52 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_52;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_52;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_54 := Pos;



Defer_Res_65 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_54);
Defer_Pos_65 := Parser.Current_Pos;



if Defer_Pos_65 /= No_Token_Index then

   Row_Pos_54 := Defer_Pos_65;

else
   Row_Pos_54 := No_Token_Index;
   goto Exit_Row_54_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_54_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_54 /= No_Token_Index then

   Transform_Res_52 := Allocate_Variable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_52,
      Kind => RFLX_Variable,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_54 = Pos
                            then No_Token_Index
                            else Row_Pos_54 - 1));

      Initialize_Fields_For_Variable
        (Self => Transform_Res_52, Variable_F_Identifier => Defer_Res_65);

         if Defer_Res_65 /= null and then Is_Incomplete (Defer_Res_65) then
            Transform_Res_52.Last_Attempted_Child := 0;
         elsif Defer_Res_65 /= null and then not Is_Ghost (Defer_Res_65) then
            Transform_Res_52.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Variable_Transform_Parse_0_Memo,
      Row_Pos_54 /= No_Token_Index,
      Transform_Res_52,
      Pos,
      Row_Pos_54);


   Parser.Current_Pos := Row_Pos_54;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_52;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Variable_Transform_Parse_0;

   


function Extended_Paren_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression
is
   use Bare_Paren_Expression_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_55 :
            Token_Index
               := No_Token_Index;
      Token_Pos_117 :
            Token_Index
               := No_Token_Index;
      Token_Res_117 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_66 :
            Token_Index
               := No_Token_Index;
      Defer_Res_66 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_118 :
            Token_Index
               := No_Token_Index;
      Token_Res_118 :
            Token_Index
               := No_Token_Index;
      Transform_Res_53 :
            Bare_Paren_Expression
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_53 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_53;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_53;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_55 := Pos;



--  Start tok_code

Token_Res_117 := Row_Pos_55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_117));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_117 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_55,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_117 := Row_Pos_55 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_117 /= No_Token_Index then

   Row_Pos_55 := Token_Pos_117;

else
   Row_Pos_55 := No_Token_Index;
   goto Exit_Row_55_0;

end if;


Defer_Res_66 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_55);
Defer_Pos_66 := Parser.Current_Pos;



if Defer_Pos_66 /= No_Token_Index then

   Row_Pos_55 := Defer_Pos_66;

else
   Row_Pos_55 := No_Token_Index;
   goto Exit_Row_55_0;

end if;


--  Start tok_code

Token_Res_118 := Row_Pos_55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_118));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_118 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_55,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_118 := Row_Pos_55 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_118 /= No_Token_Index then

   Row_Pos_55 := Token_Pos_118;

else
   Row_Pos_55 := No_Token_Index;
   goto Exit_Row_55_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_55_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_55 /= No_Token_Index then

   Transform_Res_53 := Allocate_Paren_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_53,
      Kind => RFLX_Paren_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_55 = Pos
                            then No_Token_Index
                            else Row_Pos_55 - 1));

      Initialize_Fields_For_Paren_Expression
        (Self => Transform_Res_53, Paren_Expression_F_Data => Defer_Res_66);

         if Defer_Res_66 /= null and then Is_Incomplete (Defer_Res_66) then
            Transform_Res_53.Last_Attempted_Child := 0;
         elsif Defer_Res_66 /= null and then not Is_Ghost (Defer_Res_66) then
            Transform_Res_53.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse_0_Memo,
      Row_Pos_55 /= No_Token_Index,
      Transform_Res_53,
      Pos,
      Row_Pos_55);


   Parser.Current_Pos := Row_Pos_55;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_53;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Paren_Expression_Transform_Parse_0;

   


function Extended_Choice_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_RFLX_Node_List
is
   use Bare_RFLX_Node_List_Memos;

   Call_Depth : aliased Natural;

      Lst_Cpos_5 :
            Token_Index
               := No_Token_Index;
      Tmp_List_5 :
            Free_Parse_List;
      Defer_Pos_71 :
            Token_Index
               := No_Token_Index;
      Defer_Res_71 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Defer_Pos_72 :
            Token_Index
               := No_Token_Index;
      Defer_Res_72 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;
      Or_Pos_21 :
            Token_Index
               := No_Token_Index;
      Or_Res_21 :
            Bare_RFLX_Node
               := No_Bare_RFLX_Node;
      Token_Pos_126 :
            Token_Index
               := No_Token_Index;
      Token_Res_126 :
            Token_Index
               := No_Token_Index;
      List_Pos_5 :
            Token_Index
               := No_Token_Index;
      List_Res_5 :
            Bare_RFLX_Node_List
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Choice_List_List_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_5 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return List_Res_5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return List_Res_5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_5 := No_Token_Index;



Lst_Cpos_5 := Pos;
Tmp_List_5 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_21 := No_Token_Index;
Or_Res_21 := No_Bare_RFLX_Node;
    
Defer_Res_71 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Lst_Cpos_5);
Defer_Pos_71 := Parser.Current_Pos;

    if Defer_Pos_71 /= No_Token_Index then
        Or_Pos_21 := Defer_Pos_71;
        Or_Res_21 := Defer_Res_71;
        goto Exit_Or_21;
    end if;
    
Defer_Res_72 :=
   Numeric_Literal_Transform_Parse_0 (Parser, Lst_Cpos_5);
Defer_Pos_72 := Parser.Current_Pos;

    if Defer_Pos_72 /= No_Token_Index then
        Or_Pos_21 := Defer_Pos_72;
        Or_Res_21 := Defer_Res_72;
        goto Exit_Or_21;
    end if;
<<Exit_Or_21>>

--  End or_code


   exit when Or_Pos_21 = No_Token_Index;

   List_Pos_5 := Or_Pos_21;
   Lst_Cpos_5 := List_Pos_5;

   Tmp_List_5.Nodes.Append (Or_Res_21);

      
--  Start tok_code

Token_Res_126 := Lst_Cpos_5;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_126));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Pipe)
   then
       Token_Pos_126 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_5 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_5,
             Expected_Token_Id => RFLX_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_126 := Lst_Cpos_5 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_126 /= No_Token_Index then
          Lst_Cpos_5 := Token_Pos_126;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_5.Nodes.Length;
begin
   List_Res_5 :=
      Allocate_RFLX_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_5 = Pos
                    then Pos
                    else Lst_Cpos_5 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_5,
      Kind              => RFLX_RFLX_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_5,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_5.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_5.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_5);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Choice_List_List_Parse_0_Memo,
      List_Pos_5 /= No_Token_Index,
      List_Res_5,
      Pos,
      List_Pos_5);


   Parser.Current_Pos := List_Pos_5;

   Exit_Call (Parser, Call_Depth);
   return List_Res_5;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Choice_List_List_Parse_0;

   


function Extended_Choices_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Choice
is
   use Bare_Choice_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_57 :
            Token_Index
               := No_Token_Index;
      Token_Pos_124 :
            Token_Index
               := No_Token_Index;
      Token_Res_124 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_69 :
            Token_Index
               := No_Token_Index;
      Defer_Res_69 :
            Bare_RFLX_Node_List
               := No_Bare_RFLX_Node;
      Token_Pos_125 :
            Token_Index
               := No_Token_Index;
      Token_Res_125 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_70 :
            Token_Index
               := No_Token_Index;
      Defer_Res_70 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_55 :
            Bare_Choice
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Choices_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_55 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_55;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_55;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_57 := Pos;



--  Start tok_code

Token_Res_124 := Row_Pos_57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_124));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_When)
   then
       Token_Pos_124 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_57,
             Expected_Token_Id => RFLX_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_124 := Row_Pos_57 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_124 /= No_Token_Index then

   Row_Pos_57 := Token_Pos_124;

else
   Row_Pos_57 := No_Token_Index;
   goto Exit_Row_57_0;

end if;


Defer_Res_69 :=
   Extended_Choice_List_List_Parse_0 (Parser, Row_Pos_57);
Defer_Pos_69 := Parser.Current_Pos;



if Defer_Pos_69 /= No_Token_Index then

   Row_Pos_57 := Defer_Pos_69;

else
   Row_Pos_57 := No_Token_Index;
   goto Exit_Row_57_0;

end if;


--  Start tok_code

Token_Res_125 := Row_Pos_57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_125));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_125 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_57,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_125 := Row_Pos_57 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_125 /= No_Token_Index then

   Row_Pos_57 := Token_Pos_125;

else
   Row_Pos_57 := No_Token_Index;
   goto Exit_Row_57_0;

end if;


Defer_Res_70 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_57);
Defer_Pos_70 := Parser.Current_Pos;



if Defer_Pos_70 /= No_Token_Index then

   Row_Pos_57 := Defer_Pos_70;

else
   Row_Pos_57 := No_Token_Index;
   goto Exit_Row_57_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_57_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_57 /= No_Token_Index then

   Transform_Res_55 := Allocate_Choice (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_55,
      Kind => RFLX_Choice,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_57 = Pos
                            then No_Token_Index
                            else Row_Pos_57 - 1));

      Initialize_Fields_For_Choice
        (Self => Transform_Res_55, Choice_F_Selectors => Defer_Res_69, Choice_F_Expression => Defer_Res_70);

         if Defer_Res_69 /= null and then Is_Incomplete (Defer_Res_69) then
            Transform_Res_55.Last_Attempted_Child := 0;
         elsif Defer_Res_69 /= null and then not Is_Ghost (Defer_Res_69) then
            Transform_Res_55.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_70 /= null and then Is_Incomplete (Defer_Res_70) then
            Transform_Res_55.Last_Attempted_Child := 0;
         elsif Defer_Res_70 /= null and then not Is_Ghost (Defer_Res_70) then
            Transform_Res_55.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Choices_Transform_Parse_0_Memo,
      Row_Pos_57 /= No_Token_Index,
      Transform_Res_55,
      Pos,
      Row_Pos_57);


   Parser.Current_Pos := Row_Pos_57;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_55;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Choices_Transform_Parse_0;

   


function Extended_Case_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expression
is
   use Bare_Case_Expression_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_56 :
            Token_Index
               := No_Token_Index;
      Token_Pos_119 :
            Token_Index
               := No_Token_Index;
      Token_Res_119 :
            Token_Index
               := No_Token_Index;
      Token_Pos_120 :
            Token_Index
               := No_Token_Index;
      Token_Res_120 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_67 :
            Token_Index
               := No_Token_Index;
      Defer_Res_67 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_121 :
            Token_Index
               := No_Token_Index;
      Token_Res_121 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_4 :
            Token_Index
               := No_Token_Index;
      Tmp_List_4 :
            Free_Parse_List;
      Defer_Pos_68 :
            Token_Index
               := No_Token_Index;
      Defer_Res_68 :
            Bare_Choice
               := No_Bare_RFLX_Node;
      Token_Pos_122 :
            Token_Index
               := No_Token_Index;
      Token_Res_122 :
            Token_Index
               := No_Token_Index;
      List_Pos_4 :
            Token_Index
               := No_Token_Index;
      List_Res_4 :
            Bare_Choice_List
               := No_Bare_RFLX_Node;
      Token_Pos_123 :
            Token_Index
               := No_Token_Index;
      Token_Res_123 :
            Token_Index
               := No_Token_Index;
      Transform_Res_54 :
            Bare_Case_Expression
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Case_Expression_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_54 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_54;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_54;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_56 := Pos;



--  Start tok_code

Token_Res_119 := Row_Pos_56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_119));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_119 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_56,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_119 := Row_Pos_56 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_119 /= No_Token_Index then

   Row_Pos_56 := Token_Pos_119;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


--  Start tok_code

Token_Res_120 := Row_Pos_56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_120));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Case)
   then
       Token_Pos_120 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_56,
             Expected_Token_Id => RFLX_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_120 := Row_Pos_56 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_120 /= No_Token_Index then

   Row_Pos_56 := Token_Pos_120;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


Defer_Res_67 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_56);
Defer_Pos_67 := Parser.Current_Pos;



if Defer_Pos_67 /= No_Token_Index then

   Row_Pos_56 := Defer_Pos_67;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


--  Start tok_code

Token_Res_121 := Row_Pos_56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_121));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_121 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_56,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_121 := Row_Pos_56 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_121 /= No_Token_Index then

   Row_Pos_56 := Token_Pos_121;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


--  Start list_code

    List_Pos_4 := No_Token_Index;



Lst_Cpos_4 := Row_Pos_56;
Tmp_List_4 := Get_Parse_List (Parser);

loop
   
Defer_Res_68 :=
   Extended_Choices_Transform_Parse_0 (Parser, Lst_Cpos_4);
Defer_Pos_68 := Parser.Current_Pos;


   exit when Defer_Pos_68 = No_Token_Index;

   List_Pos_4 := Defer_Pos_68;
   Lst_Cpos_4 := List_Pos_4;

   Tmp_List_4.Nodes.Append (Defer_Res_68);

      
--  Start tok_code

Token_Res_122 := Lst_Cpos_4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_122));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_122 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_4,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_122 := Lst_Cpos_4 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_122 /= No_Token_Index then
          Lst_Cpos_4 := Token_Pos_122;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_4.Nodes.Length;
begin
   List_Res_4 :=
      Allocate_Choice_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_56;
      Token_End := (if Lst_Cpos_4 = Row_Pos_56
                    then Row_Pos_56
                    else Lst_Cpos_4 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_56, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_4,
      Kind              => RFLX_Choice_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_4,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_4.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_4.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_4);

--  End list_code



if List_Pos_4 /= No_Token_Index then

   Row_Pos_56 := List_Pos_4;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;


--  Start tok_code

Token_Res_123 := Row_Pos_56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_123));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_123 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_56,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_123 := Row_Pos_56 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_123 /= No_Token_Index then

   Row_Pos_56 := Token_Pos_123;

else
   Row_Pos_56 := No_Token_Index;
   goto Exit_Row_56_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_56_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_56 /= No_Token_Index then

   Transform_Res_54 := Allocate_Case_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_54,
      Kind => RFLX_Case_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_56 = Pos
                            then No_Token_Index
                            else Row_Pos_56 - 1));

      Initialize_Fields_For_Case_Expression
        (Self => Transform_Res_54, Case_Expression_F_Expression => Defer_Res_67, Case_Expression_F_Choices => List_Res_4);

         if Defer_Res_67 /= null and then Is_Incomplete (Defer_Res_67) then
            Transform_Res_54.Last_Attempted_Child := 0;
         elsif Defer_Res_67 /= null and then not Is_Ghost (Defer_Res_67) then
            Transform_Res_54.Last_Attempted_Child := -1;
         end if;
         if List_Res_4 /= null and then Is_Incomplete (List_Res_4) then
            Transform_Res_54.Last_Attempted_Child := 0;
         elsif List_Res_4 /= null and then not Is_Ghost (List_Res_4) then
            Transform_Res_54.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Case_Expression_Transform_Parse_0_Memo,
      Row_Pos_56 /= No_Token_Index,
      Transform_Res_54,
      Pos,
      Row_Pos_56);


   Parser.Current_Pos := Row_Pos_56;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_54;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Case_Expression_Transform_Parse_0;

   


function Extended_Primary_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_29 :
            Token_Index
               := No_Token_Index;
      Defer_Res_29 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_30 :
            Token_Index
               := No_Token_Index;
      Defer_Res_30 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_31 :
            Token_Index
               := No_Token_Index;
      Defer_Res_31 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_32 :
            Token_Index
               := No_Token_Index;
      Defer_Res_32 :
            Bare_Quantified_Expression
               := No_Bare_RFLX_Node;
      Defer_Pos_33 :
            Token_Index
               := No_Token_Index;
      Defer_Res_33 :
            Bare_Comprehension
               := No_Bare_RFLX_Node;
      Defer_Pos_34 :
            Token_Index
               := No_Token_Index;
      Defer_Res_34 :
            Bare_Call
               := No_Bare_RFLX_Node;
      Defer_Pos_35 :
            Token_Index
               := No_Token_Index;
      Defer_Res_35 :
            Bare_Conversion
               := No_Bare_RFLX_Node;
      Defer_Pos_36 :
            Token_Index
               := No_Token_Index;
      Defer_Res_36 :
            Bare_Message_Aggregate
               := No_Bare_RFLX_Node;
      Defer_Pos_37 :
            Token_Index
               := No_Token_Index;
      Defer_Res_37 :
            Bare_Variable
               := No_Bare_RFLX_Node;
      Defer_Pos_38 :
            Token_Index
               := No_Token_Index;
      Defer_Res_38 :
            Bare_Paren_Expression
               := No_Bare_RFLX_Node;
      Defer_Pos_39 :
            Token_Index
               := No_Token_Index;
      Defer_Res_39 :
            Bare_Case_Expression
               := No_Bare_RFLX_Node;
      Or_Pos_15 :
            Token_Index
               := No_Token_Index;
      Or_Res_15 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Primary_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_15 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_15;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_15;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_15 := No_Token_Index;
Or_Res_15 := No_Bare_RFLX_Node;
    
Defer_Res_29 :=
   Concatenation_Or_Parse_2 (Parser, Pos);
Defer_Pos_29 := Parser.Current_Pos;

    if Defer_Pos_29 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_29;
        Or_Res_15 := Defer_Res_29;
        goto Exit_Or_15;
    end if;
    
Defer_Res_30 :=
   Numeric_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_30 := Parser.Current_Pos;

    if Defer_Pos_30 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_30;
        Or_Res_15 := Defer_Res_30;
        goto Exit_Or_15;
    end if;
    
Defer_Res_31 :=
   String_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_31 := Parser.Current_Pos;

    if Defer_Pos_31 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_31;
        Or_Res_15 := Defer_Res_31;
        goto Exit_Or_15;
    end if;
    
Defer_Res_32 :=
   Quantified_Expression_Transform_Parse_2 (Parser, Pos);
Defer_Pos_32 := Parser.Current_Pos;

    if Defer_Pos_32 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_32;
        Or_Res_15 := Defer_Res_32;
        goto Exit_Or_15;
    end if;
    
Defer_Res_33 :=
   Comprehension_Transform_Parse_0 (Parser, Pos);
Defer_Pos_33 := Parser.Current_Pos;

    if Defer_Pos_33 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_33;
        Or_Res_15 := Defer_Res_33;
        goto Exit_Or_15;
    end if;
    
Defer_Res_34 :=
   Call_Transform_Parse_0 (Parser, Pos);
Defer_Pos_34 := Parser.Current_Pos;

    if Defer_Pos_34 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_34;
        Or_Res_15 := Defer_Res_34;
        goto Exit_Or_15;
    end if;
    
Defer_Res_35 :=
   Conversion_Transform_Parse_0 (Parser, Pos);
Defer_Pos_35 := Parser.Current_Pos;

    if Defer_Pos_35 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_35;
        Or_Res_15 := Defer_Res_35;
        goto Exit_Or_15;
    end if;
    
Defer_Res_36 :=
   Message_Aggregate_Transform_Parse_0 (Parser, Pos);
Defer_Pos_36 := Parser.Current_Pos;

    if Defer_Pos_36 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_36;
        Or_Res_15 := Defer_Res_36;
        goto Exit_Or_15;
    end if;
    
Defer_Res_37 :=
   Variable_Transform_Parse_0 (Parser, Pos);
Defer_Pos_37 := Parser.Current_Pos;

    if Defer_Pos_37 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_37;
        Or_Res_15 := Defer_Res_37;
        goto Exit_Or_15;
    end if;
    
Defer_Res_38 :=
   Extended_Paren_Expression_Transform_Parse_0 (Parser, Pos);
Defer_Pos_38 := Parser.Current_Pos;

    if Defer_Pos_38 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_38;
        Or_Res_15 := Defer_Res_38;
        goto Exit_Or_15;
    end if;
    
Defer_Res_39 :=
   Extended_Case_Expression_Transform_Parse_0 (Parser, Pos);
Defer_Pos_39 := Parser.Current_Pos;

    if Defer_Pos_39 /= No_Token_Index then
        Or_Pos_15 := Defer_Pos_39;
        Or_Res_15 := Defer_Res_39;
        goto Exit_Or_15;
    end if;
<<Exit_Or_15>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Primary_Or_Parse_0_Memo,
      Or_Pos_15 /= No_Token_Index,
      Or_Res_15,
      Pos,
      Or_Pos_15);


   Parser.Current_Pos := Or_Pos_15;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_15;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Primary_Or_Parse_0;

   


function Extended_Suffix_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_6 :
            Boolean
               := False;
      Row_Pos_24 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_22 :
            Token_Index
               := No_Token_Index;
      Defer_Res_22 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_73 :
            Token_Index
               := No_Token_Index;
      Token_Res_73 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_23 :
            Token_Index
               := No_Token_Index;
      Defer_Res_23 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Row_Progress_6 :
            Integer
               := 0;
      Transform_Res_24 :
            Bare_Select_Node
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_6 :
            Boolean
               := False;
      Row_Pos_25 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_24 :
            Token_Index
               := No_Token_Index;
      Defer_Res_24 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_74 :
            Token_Index
               := No_Token_Index;
      Token_Res_74 :
            Token_Index
               := No_Token_Index;
      Row_Pos_26 :
            Token_Index
               := No_Token_Index;
      Token_Pos_75 :
            Token_Index
               := No_Token_Index;
      Token_Res_75 :
            Token_Index
               := No_Token_Index;
      Transform_Res_25 :
            Bare_Attr_First
               := No_Bare_RFLX_Node;
      Row_Pos_27 :
            Token_Index
               := No_Token_Index;
      Token_Pos_76 :
            Token_Index
               := No_Token_Index;
      Token_Res_76 :
            Token_Index
               := No_Token_Index;
      Transform_Res_26 :
            Bare_Attr_Size
               := No_Bare_RFLX_Node;
      Row_Pos_28 :
            Token_Index
               := No_Token_Index;
      Token_Pos_77 :
            Token_Index
               := No_Token_Index;
      Token_Res_77 :
            Token_Index
               := No_Token_Index;
      Transform_Res_27 :
            Bare_Attr_Last
               := No_Bare_RFLX_Node;
      Row_Pos_29 :
            Token_Index
               := No_Token_Index;
      Token_Pos_78 :
            Token_Index
               := No_Token_Index;
      Token_Res_78 :
            Token_Index
               := No_Token_Index;
      Transform_Res_28 :
            Bare_Attr_Valid_Checksum
               := No_Bare_RFLX_Node;
      Row_Pos_30 :
            Token_Index
               := No_Token_Index;
      Token_Pos_79 :
            Token_Index
               := No_Token_Index;
      Token_Res_79 :
            Token_Index
               := No_Token_Index;
      Transform_Res_29 :
            Bare_Attr_Has_Data
               := No_Bare_RFLX_Node;
      Row_Pos_31 :
            Token_Index
               := No_Token_Index;
      Token_Pos_80 :
            Token_Index
               := No_Token_Index;
      Token_Res_80 :
            Token_Index
               := No_Token_Index;
      Transform_Res_30 :
            Bare_Attr_Head
               := No_Bare_RFLX_Node;
      Row_Pos_32 :
            Token_Index
               := No_Token_Index;
      Token_Pos_81 :
            Token_Index
               := No_Token_Index;
      Token_Res_81 :
            Token_Index
               := No_Token_Index;
      Transform_Res_31 :
            Bare_Attr_Opaque
               := No_Bare_RFLX_Node;
      Row_Pos_33 :
            Token_Index
               := No_Token_Index;
      Token_Pos_82 :
            Token_Index
               := No_Token_Index;
      Token_Res_82 :
            Token_Index
               := No_Token_Index;
      Transform_Res_32 :
            Bare_Attr_Present
               := No_Bare_RFLX_Node;
      Row_Pos_34 :
            Token_Index
               := No_Token_Index;
      Token_Pos_83 :
            Token_Index
               := No_Token_Index;
      Token_Res_83 :
            Token_Index
               := No_Token_Index;
      Transform_Res_33 :
            Bare_Attr_Valid
               := No_Bare_RFLX_Node;
      Or_Pos_13 :
            Token_Index
               := No_Token_Index;
      Or_Res_13 :
            Bare_Attr
               := No_Bare_RFLX_Node;
      Transform_Res_34 :
            Bare_Attribute
               := No_Bare_RFLX_Node;
      Row_Pos_35 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_25 :
            Token_Index
               := No_Token_Index;
      Defer_Res_25 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_84 :
            Token_Index
               := No_Token_Index;
      Token_Res_84 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_0 :
            Token_Index
               := No_Token_Index;
      Tmp_List_0 :
            Free_Parse_List;
      Row_Pos_36 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_26 :
            Token_Index
               := No_Token_Index;
      Defer_Res_26 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_85 :
            Token_Index
               := No_Token_Index;
      Token_Res_85 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_27 :
            Token_Index
               := No_Token_Index;
      Defer_Res_27 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_35 :
            Bare_Term_Assoc
               := No_Bare_RFLX_Node;
      Token_Pos_86 :
            Token_Index
               := No_Token_Index;
      Token_Res_86 :
            Token_Index
               := No_Token_Index;
      List_Pos_0 :
            Token_Index
               := No_Token_Index;
      List_Res_0 :
            Bare_Term_Assoc_List
               := No_Bare_RFLX_Node;
      Transform_Res_36 :
            Bare_Binding
               := No_Bare_RFLX_Node;
      Defer_Pos_28 :
            Token_Index
               := No_Token_Index;
      Defer_Res_28 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_14 :
            Token_Index
               := No_Token_Index;
      Or_Res_14 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Suffix_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_14 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_14;
   end if;

       Set (Parser.Private_Part.Extended_Suffix_Or_Parse_1_Memo, False, Or_Res_14, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_6 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_14 := No_Token_Index;
Or_Res_14 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_24 := Pos;



Defer_Res_22 :=
   Extended_Suffix_Or_Parse_1 (Parser, Row_Pos_24);
Defer_Pos_22 := Parser.Current_Pos;


Row_Progress_6 := 1;

if Defer_Pos_22 /= No_Token_Index then

   Row_Pos_24 := Defer_Pos_22;

else
   Row_Pos_24 := No_Token_Index;
   goto Exit_Row_24_0;

end if;


--  Start tok_code

Token_Res_73 := Row_Pos_24;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_73));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Dot)
   then
       Token_Pos_73 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_24 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_24,
             Expected_Token_Id => RFLX_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_73 := Row_Pos_24 + 1;
   end if;
end;

--  End tok_code


Row_Progress_6 := 2;

if Token_Pos_73 /= No_Token_Index then

   Row_Pos_24 := Token_Pos_73;

else
   Row_Pos_24 := No_Token_Index;
   goto Exit_Row_24_0;

end if;

Nobt_6 := True;

Row_Progress_6 := 3;

if Row_Pos_24 /= No_Token_Index then

   Row_Pos_24 := Row_Pos_24;

else
   Row_Pos_24 := No_Token_Index;
   goto Exit_Row_24_0;

end if;


Defer_Res_23 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_24);
Defer_Pos_23 := Parser.Current_Pos;


Row_Progress_6 := 4;

if Defer_Pos_23 /= No_Token_Index then

   Row_Pos_24 := Defer_Pos_23;

else
   Row_Pos_24 := No_Token_Index;
   goto Exit_Row_24_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_24_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_24 = No_Token_Index and then Nobt_6 then
   Row_Pos_24 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_6 := True;
end if;

if Row_Pos_24 /= No_Token_Index then

   Transform_Res_24 := Allocate_Select_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_24,
      Kind => RFLX_Select_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_24 = Pos
                            then No_Token_Index
                            else Row_Pos_24 - 1));

      Initialize_Fields_For_Select_Node
        (Self => Transform_Res_24, Select_Node_F_Expression => Defer_Res_22, Select_Node_F_Selector => Defer_Res_23);

         if Defer_Res_22 /= null and then Is_Incomplete (Defer_Res_22) then
            Transform_Res_24.Last_Attempted_Child := 0;
         elsif Defer_Res_22 /= null and then not Is_Ghost (Defer_Res_22) then
            Transform_Res_24.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_23 /= null and then Is_Incomplete (Defer_Res_23) then
            Transform_Res_24.Last_Attempted_Child := 0;
         elsif Defer_Res_23 /= null and then not Is_Ghost (Defer_Res_23) then
            Transform_Res_24.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_6 then
      Transform_Res_24.Last_Attempted_Child :=
         Row_Progress_6;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_suffix>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_24 /= No_Token_Index then
        Or_Pos_14 := Row_Pos_24;
        Or_Res_14 := Transform_Res_24;
        goto Exit_Or_13;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_25 := Pos;



Defer_Res_24 :=
   Extended_Suffix_Or_Parse_1 (Parser, Row_Pos_25);
Defer_Pos_24 := Parser.Current_Pos;



if Defer_Pos_24 /= No_Token_Index then

   Row_Pos_25 := Defer_Pos_24;

else
   Row_Pos_25 := No_Token_Index;
   goto Exit_Row_25_0;

end if;


--  Start tok_code

Token_Res_74 := Row_Pos_25;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_74));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Tick)
   then
       Token_Pos_74 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_25 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_25,
             Expected_Token_Id => RFLX_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_74 := Row_Pos_25 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_74 /= No_Token_Index then

   Row_Pos_25 := Token_Pos_74;

else
   Row_Pos_25 := No_Token_Index;
   goto Exit_Row_25_0;

end if;


--  Start or_code

Or_Pos_13 := No_Token_Index;
Or_Res_13 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_26 := Row_Pos_25;



--  Start tok_code

Token_Res_75 := Row_Pos_26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_75));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_First)
   then
       Token_Pos_75 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_26,
             Expected_Token_Id => RFLX_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_75 := Row_Pos_26 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_75 /= No_Token_Index then

   Row_Pos_26 := Token_Pos_75;

else
   Row_Pos_26 := No_Token_Index;
   goto Exit_Row_26_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_26_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_26 /= No_Token_Index then

   Transform_Res_25 := Allocate_Attr_First (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_25,
      Kind => RFLX_Attr_First,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_26 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_26 - 1));




end if;

--  End transform_code

    if Row_Pos_26 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_26;
        Or_Res_13 := Transform_Res_25;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_27 := Row_Pos_25;



--  Start tok_code

Token_Res_76 := Row_Pos_27;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_76));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Size)
   then
       Token_Pos_76 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_27 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_27,
             Expected_Token_Id => RFLX_Size,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_76 := Row_Pos_27 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_76 /= No_Token_Index then

   Row_Pos_27 := Token_Pos_76;

else
   Row_Pos_27 := No_Token_Index;
   goto Exit_Row_27_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_27_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_27 /= No_Token_Index then

   Transform_Res_26 := Allocate_Attr_Size (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_26,
      Kind => RFLX_Attr_Size,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_27 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_27 - 1));




end if;

--  End transform_code

    if Row_Pos_27 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_27;
        Or_Res_13 := Transform_Res_26;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_28 := Row_Pos_25;



--  Start tok_code

Token_Res_77 := Row_Pos_28;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_77));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Last)
   then
       Token_Pos_77 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_28 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_28,
             Expected_Token_Id => RFLX_Last,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_77 := Row_Pos_28 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_77 /= No_Token_Index then

   Row_Pos_28 := Token_Pos_77;

else
   Row_Pos_28 := No_Token_Index;
   goto Exit_Row_28_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_28_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_28 /= No_Token_Index then

   Transform_Res_27 := Allocate_Attr_Last (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_27,
      Kind => RFLX_Attr_Last,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_28 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_28 - 1));




end if;

--  End transform_code

    if Row_Pos_28 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_28;
        Or_Res_13 := Transform_Res_27;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_29 := Row_Pos_25;



--  Start tok_code

Token_Res_78 := Row_Pos_29;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_78));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Valid_Checksum)
   then
       Token_Pos_78 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_29 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_29,
             Expected_Token_Id => RFLX_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_78 := Row_Pos_29 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_78 /= No_Token_Index then

   Row_Pos_29 := Token_Pos_78;

else
   Row_Pos_29 := No_Token_Index;
   goto Exit_Row_29_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_29_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_29 /= No_Token_Index then

   Transform_Res_28 := Allocate_Attr_Valid_Checksum (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_28,
      Kind => RFLX_Attr_Valid_Checksum,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_29 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_29 - 1));




end if;

--  End transform_code

    if Row_Pos_29 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_29;
        Or_Res_13 := Transform_Res_28;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_30 := Row_Pos_25;



--  Start tok_code

Token_Res_79 := Row_Pos_30;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_79));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Has_Data)
   then
       Token_Pos_79 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_30 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_30,
             Expected_Token_Id => RFLX_Has_Data,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_79 := Row_Pos_30 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_79 /= No_Token_Index then

   Row_Pos_30 := Token_Pos_79;

else
   Row_Pos_30 := No_Token_Index;
   goto Exit_Row_30_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_30_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_30 /= No_Token_Index then

   Transform_Res_29 := Allocate_Attr_Has_Data (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_29,
      Kind => RFLX_Attr_Has_Data,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_30 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_30 - 1));




end if;

--  End transform_code

    if Row_Pos_30 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_30;
        Or_Res_13 := Transform_Res_29;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_31 := Row_Pos_25;



--  Start tok_code

Token_Res_80 := Row_Pos_31;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_80));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Head)
   then
       Token_Pos_80 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_31 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_31,
             Expected_Token_Id => RFLX_Head,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_80 := Row_Pos_31 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_80 /= No_Token_Index then

   Row_Pos_31 := Token_Pos_80;

else
   Row_Pos_31 := No_Token_Index;
   goto Exit_Row_31_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_31_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_31 /= No_Token_Index then

   Transform_Res_30 := Allocate_Attr_Head (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_30,
      Kind => RFLX_Attr_Head,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_31 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_31 - 1));




end if;

--  End transform_code

    if Row_Pos_31 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_31;
        Or_Res_13 := Transform_Res_30;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_32 := Row_Pos_25;



--  Start tok_code

Token_Res_81 := Row_Pos_32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_81));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Opaque)
   then
       Token_Pos_81 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_32,
             Expected_Token_Id => RFLX_Opaque,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_81 := Row_Pos_32 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_81 /= No_Token_Index then

   Row_Pos_32 := Token_Pos_81;

else
   Row_Pos_32 := No_Token_Index;
   goto Exit_Row_32_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_32_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_32 /= No_Token_Index then

   Transform_Res_31 := Allocate_Attr_Opaque (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_31,
      Kind => RFLX_Attr_Opaque,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_32 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_32 - 1));




end if;

--  End transform_code

    if Row_Pos_32 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_32;
        Or_Res_13 := Transform_Res_31;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_33 := Row_Pos_25;



--  Start tok_code

Token_Res_82 := Row_Pos_33;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_82));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Present)
   then
       Token_Pos_82 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_33 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_33,
             Expected_Token_Id => RFLX_Present,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_82 := Row_Pos_33 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_82 /= No_Token_Index then

   Row_Pos_33 := Token_Pos_82;

else
   Row_Pos_33 := No_Token_Index;
   goto Exit_Row_33_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_33_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_33 /= No_Token_Index then

   Transform_Res_32 := Allocate_Attr_Present (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_32,
      Kind => RFLX_Attr_Present,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_33 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_33 - 1));




end if;

--  End transform_code

    if Row_Pos_33 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_33;
        Or_Res_13 := Transform_Res_32;
        goto Exit_Or_14;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_34 := Row_Pos_25;



--  Start tok_code

Token_Res_83 := Row_Pos_34;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_83));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Valid)
   then
       Token_Pos_83 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_34 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_34,
             Expected_Token_Id => RFLX_Valid,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_83 := Row_Pos_34 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_83 /= No_Token_Index then

   Row_Pos_34 := Token_Pos_83;

else
   Row_Pos_34 := No_Token_Index;
   goto Exit_Row_34_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_34_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_34 /= No_Token_Index then

   Transform_Res_33 := Allocate_Attr_Valid (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_33,
      Kind => RFLX_Attr_Valid,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_25,
      Token_End_Index   => (if Row_Pos_34 = Row_Pos_25
                            then No_Token_Index
                            else Row_Pos_34 - 1));




end if;

--  End transform_code

    if Row_Pos_34 /= No_Token_Index then
        Or_Pos_13 := Row_Pos_34;
        Or_Res_13 := Transform_Res_33;
        goto Exit_Or_14;
    end if;
<<Exit_Or_14>>

--  End or_code



if Or_Pos_13 /= No_Token_Index then

   Row_Pos_25 := Or_Pos_13;

else
   Row_Pos_25 := No_Token_Index;
   goto Exit_Row_25_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_25_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_25 /= No_Token_Index then

   Transform_Res_34 := Allocate_Attribute (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_34,
      Kind => RFLX_Attribute,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_25 = Pos
                            then No_Token_Index
                            else Row_Pos_25 - 1));

      Initialize_Fields_For_Attribute
        (Self => Transform_Res_34, Attribute_F_Expression => Defer_Res_24, Attribute_F_Kind => Or_Res_13);

         if Defer_Res_24 /= null and then Is_Incomplete (Defer_Res_24) then
            Transform_Res_34.Last_Attempted_Child := 0;
         elsif Defer_Res_24 /= null and then not Is_Ghost (Defer_Res_24) then
            Transform_Res_34.Last_Attempted_Child := -1;
         end if;
         if Or_Res_13 /= null and then Is_Incomplete (Or_Res_13) then
            Transform_Res_34.Last_Attempted_Child := 0;
         elsif Or_Res_13 /= null and then not Is_Ghost (Or_Res_13) then
            Transform_Res_34.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_25 /= No_Token_Index then
        Or_Pos_14 := Row_Pos_25;
        Or_Res_14 := Transform_Res_34;
        goto Exit_Or_13;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_35 := Pos;



Defer_Res_25 :=
   Extended_Suffix_Or_Parse_1 (Parser, Row_Pos_35);
Defer_Pos_25 := Parser.Current_Pos;



if Defer_Pos_25 /= No_Token_Index then

   Row_Pos_35 := Defer_Pos_25;

else
   Row_Pos_35 := No_Token_Index;
   goto Exit_Row_35_0;

end if;


--  Start tok_code

Token_Res_84 := Row_Pos_35;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_84));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Where)
   then
       Token_Pos_84 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_35 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_35,
             Expected_Token_Id => RFLX_Where,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_84 := Row_Pos_35 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_84 /= No_Token_Index then

   Row_Pos_35 := Token_Pos_84;

else
   Row_Pos_35 := No_Token_Index;
   goto Exit_Row_35_0;

end if;


--  Start list_code

    List_Pos_0 := No_Token_Index;



Lst_Cpos_0 := Row_Pos_35;
Tmp_List_0 := Get_Parse_List (Parser);

loop
   
--  Start transform_code


--  Start row_code

Row_Pos_36 := Lst_Cpos_0;



Defer_Res_26 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_36);
Defer_Pos_26 := Parser.Current_Pos;



if Defer_Pos_26 /= No_Token_Index then

   Row_Pos_36 := Defer_Pos_26;

else
   Row_Pos_36 := No_Token_Index;
   goto Exit_Row_36_0;

end if;


--  Start tok_code

Token_Res_85 := Row_Pos_36;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_85));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Eq)
   then
       Token_Pos_85 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_36 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_36,
             Expected_Token_Id => RFLX_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_85 := Row_Pos_36 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_85 /= No_Token_Index then

   Row_Pos_36 := Token_Pos_85;

else
   Row_Pos_36 := No_Token_Index;
   goto Exit_Row_36_0;

end if;


Defer_Res_27 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_36);
Defer_Pos_27 := Parser.Current_Pos;



if Defer_Pos_27 /= No_Token_Index then

   Row_Pos_36 := Defer_Pos_27;

else
   Row_Pos_36 := No_Token_Index;
   goto Exit_Row_36_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_36_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_36 /= No_Token_Index then

   Transform_Res_35 := Allocate_Term_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_35,
      Kind => RFLX_Term_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos_0,
      Token_End_Index   => (if Row_Pos_36 = Lst_Cpos_0
                            then No_Token_Index
                            else Row_Pos_36 - 1));

      Initialize_Fields_For_Term_Assoc
        (Self => Transform_Res_35, Term_Assoc_F_Identifier => Defer_Res_26, Term_Assoc_F_Expression => Defer_Res_27);

         if Defer_Res_26 /= null and then Is_Incomplete (Defer_Res_26) then
            Transform_Res_35.Last_Attempted_Child := 0;
         elsif Defer_Res_26 /= null and then not Is_Ghost (Defer_Res_26) then
            Transform_Res_35.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_27 /= null and then Is_Incomplete (Defer_Res_27) then
            Transform_Res_35.Last_Attempted_Child := 0;
         elsif Defer_Res_27 /= null and then not Is_Ghost (Defer_Res_27) then
            Transform_Res_35.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   exit when Row_Pos_36 = No_Token_Index;

   List_Pos_0 := Row_Pos_36;
   Lst_Cpos_0 := List_Pos_0;

   Tmp_List_0.Nodes.Append (Transform_Res_35);

      
--  Start tok_code

Token_Res_86 := Lst_Cpos_0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_86));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_86 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_0,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_86 := Lst_Cpos_0 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_86 /= No_Token_Index then
          Lst_Cpos_0 := Token_Pos_86;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_0.Nodes.Length;
begin
   List_Res_0 :=
      Allocate_Term_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_35;
      Token_End := (if Lst_Cpos_0 = Row_Pos_35
                    then Row_Pos_35
                    else Lst_Cpos_0 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_35, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_0,
      Kind              => RFLX_Term_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_0,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_0.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_0.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_0);

--  End list_code



if List_Pos_0 /= No_Token_Index then

   Row_Pos_35 := List_Pos_0;

else
   Row_Pos_35 := No_Token_Index;
   goto Exit_Row_35_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_35_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_35 /= No_Token_Index then

   Transform_Res_36 := Allocate_Binding (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_36,
      Kind => RFLX_Binding,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_35 = Pos
                            then No_Token_Index
                            else Row_Pos_35 - 1));

      Initialize_Fields_For_Binding
        (Self => Transform_Res_36, Binding_F_Expression => Defer_Res_25, Binding_F_Bindings => List_Res_0);

         if Defer_Res_25 /= null and then Is_Incomplete (Defer_Res_25) then
            Transform_Res_36.Last_Attempted_Child := 0;
         elsif Defer_Res_25 /= null and then not Is_Ghost (Defer_Res_25) then
            Transform_Res_36.Last_Attempted_Child := -1;
         end if;
         if List_Res_0 /= null and then Is_Incomplete (List_Res_0) then
            Transform_Res_36.Last_Attempted_Child := 0;
         elsif List_Res_0 /= null and then not Is_Ghost (List_Res_0) then
            Transform_Res_36.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_35 /= No_Token_Index then
        Or_Pos_14 := Row_Pos_35;
        Or_Res_14 := Transform_Res_36;
        goto Exit_Or_13;
    end if;
    
Defer_Res_28 :=
   Extended_Primary_Or_Parse_0 (Parser, Pos);
Defer_Pos_28 := Parser.Current_Pos;

    if Defer_Pos_28 /= No_Token_Index then
        Or_Pos_14 := Defer_Pos_28;
        Or_Res_14 := Defer_Res_28;
        goto Exit_Or_13;
    end if;
<<Exit_Or_13>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_14 > Mem_Pos then
         Mem_Pos := Or_Pos_14;
         Mem_Res := Or_Res_14;
         Set
           (Parser.Private_Part.Extended_Suffix_Or_Parse_1_Memo,
            Or_Pos_14 /= No_Token_Index,
            Or_Res_14,
            Pos,
            Or_Pos_14);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_14 := Mem_Res;
         Or_Pos_14 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Suffix_Or_Parse_1_Memo,
      Or_Pos_14 /= No_Token_Index,
      Or_Res_14,
      Pos,
      Or_Pos_14);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_14;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_14;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Suffix_Or_Parse_1;

   


function Extended_Factor_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_5 :
            Boolean
               := False;
      Row_Pos_22 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_19 :
            Token_Index
               := No_Token_Index;
      Defer_Res_19 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_23 :
            Token_Index
               := No_Token_Index;
      Token_Pos_72 :
            Token_Index
               := No_Token_Index;
      Token_Res_72 :
            Token_Index
               := No_Token_Index;
      Transform_Res_22 :
            Bare_Op_Pow
               := No_Bare_RFLX_Node;
      Or_Pos_11 :
            Token_Index
               := No_Token_Index;
      Or_Res_11 :
            Bare_Op_Pow
               := No_Bare_RFLX_Node;
      Defer_Pos_20 :
            Token_Index
               := No_Token_Index;
      Defer_Res_20 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_5 :
            Integer
               := 0;
      Transform_Res_23 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_5 :
            Boolean
               := False;
      Defer_Pos_21 :
            Token_Index
               := No_Token_Index;
      Defer_Res_21 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_12 :
            Token_Index
               := No_Token_Index;
      Or_Res_12 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Factor_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_12 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_12;
   end if;

       Set (Parser.Private_Part.Extended_Factor_Or_Parse_1_Memo, False, Or_Res_12, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_5 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_12 := No_Token_Index;
Or_Res_12 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_22 := Pos;



Defer_Res_19 :=
   Extended_Factor_Or_Parse_1 (Parser, Row_Pos_22);
Defer_Pos_19 := Parser.Current_Pos;


Row_Progress_5 := 1;

if Defer_Pos_19 /= No_Token_Index then

   Row_Pos_22 := Defer_Pos_19;

else
   Row_Pos_22 := No_Token_Index;
   goto Exit_Row_22_0;

end if;


--  Start or_code

Or_Pos_11 := No_Token_Index;
Or_Res_11 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_23 := Row_Pos_22;



--  Start tok_code

Token_Res_72 := Row_Pos_23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_72));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Exp)
   then
       Token_Pos_72 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_23,
             Expected_Token_Id => RFLX_Exp,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_72 := Row_Pos_23 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_72 /= No_Token_Index then

   Row_Pos_23 := Token_Pos_72;

else
   Row_Pos_23 := No_Token_Index;
   goto Exit_Row_23_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_23_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_23 /= No_Token_Index then

   Transform_Res_22 := Allocate_Op_Pow (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_22,
      Kind => RFLX_Op_Pow,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_22,
      Token_End_Index   => (if Row_Pos_23 = Row_Pos_22
                            then No_Token_Index
                            else Row_Pos_23 - 1));




end if;

--  End transform_code

    if Row_Pos_23 /= No_Token_Index then
        Or_Pos_11 := Row_Pos_23;
        Or_Res_11 := Transform_Res_22;
        goto Exit_Or_12;
    end if;
<<Exit_Or_12>>

--  End or_code


Row_Progress_5 := 2;

if Or_Pos_11 /= No_Token_Index then

   Row_Pos_22 := Or_Pos_11;

else
   Row_Pos_22 := No_Token_Index;
   goto Exit_Row_22_0;

end if;

Nobt_5 := True;

Row_Progress_5 := 3;

if Row_Pos_22 /= No_Token_Index then

   Row_Pos_22 := Row_Pos_22;

else
   Row_Pos_22 := No_Token_Index;
   goto Exit_Row_22_0;

end if;


Defer_Res_20 :=
   Extended_Suffix_Or_Parse_1 (Parser, Row_Pos_22);
Defer_Pos_20 := Parser.Current_Pos;


Row_Progress_5 := 4;

if Defer_Pos_20 /= No_Token_Index then

   Row_Pos_22 := Defer_Pos_20;

else
   Row_Pos_22 := No_Token_Index;
   goto Exit_Row_22_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_22_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_22 = No_Token_Index and then Nobt_5 then
   Row_Pos_22 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_5 := True;
end if;

if Row_Pos_22 /= No_Token_Index then

   Transform_Res_23 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_23,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_22 = Pos
                            then No_Token_Index
                            else Row_Pos_22 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_23, Bin_Op_F_Left => Defer_Res_19, Bin_Op_F_Op => Or_Res_11, Bin_Op_F_Right => Defer_Res_20);

         if Defer_Res_19 /= null and then Is_Incomplete (Defer_Res_19) then
            Transform_Res_23.Last_Attempted_Child := 0;
         elsif Defer_Res_19 /= null and then not Is_Ghost (Defer_Res_19) then
            Transform_Res_23.Last_Attempted_Child := -1;
         end if;
         if Or_Res_11 /= null and then Is_Incomplete (Or_Res_11) then
            Transform_Res_23.Last_Attempted_Child := 0;
         elsif Or_Res_11 /= null and then not Is_Ghost (Or_Res_11) then
            Transform_Res_23.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_20 /= null and then Is_Incomplete (Defer_Res_20) then
            Transform_Res_23.Last_Attempted_Child := 0;
         elsif Defer_Res_20 /= null and then not Is_Ghost (Defer_Res_20) then
            Transform_Res_23.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_5 then
      Transform_Res_23.Last_Attempted_Child :=
         Row_Progress_5;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_factor>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_22 /= No_Token_Index then
        Or_Pos_12 := Row_Pos_22;
        Or_Res_12 := Transform_Res_23;
        goto Exit_Or_11;
    end if;
    
Defer_Res_21 :=
   Extended_Suffix_Or_Parse_1 (Parser, Pos);
Defer_Pos_21 := Parser.Current_Pos;

    if Defer_Pos_21 /= No_Token_Index then
        Or_Pos_12 := Defer_Pos_21;
        Or_Res_12 := Defer_Res_21;
        goto Exit_Or_11;
    end if;
<<Exit_Or_11>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_12 > Mem_Pos then
         Mem_Pos := Or_Pos_12;
         Mem_Res := Or_Res_12;
         Set
           (Parser.Private_Part.Extended_Factor_Or_Parse_1_Memo,
            Or_Pos_12 /= No_Token_Index,
            Or_Res_12,
            Pos,
            Or_Pos_12);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_12 := Mem_Res;
         Or_Pos_12 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Factor_Or_Parse_1_Memo,
      Or_Pos_12 /= No_Token_Index,
      Or_Res_12,
      Pos,
      Or_Pos_12);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_12;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_12;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Factor_Or_Parse_1;

   


function Extended_Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_4 :
            Boolean
               := False;
      Row_Pos_18 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_16 :
            Token_Index
               := No_Token_Index;
      Defer_Res_16 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_19 :
            Token_Index
               := No_Token_Index;
      Token_Pos_69 :
            Token_Index
               := No_Token_Index;
      Token_Res_69 :
            Token_Index
               := No_Token_Index;
      Transform_Res_18 :
            Bare_Op_Mul
               := No_Bare_RFLX_Node;
      Row_Pos_20 :
            Token_Index
               := No_Token_Index;
      Token_Pos_70 :
            Token_Index
               := No_Token_Index;
      Token_Res_70 :
            Token_Index
               := No_Token_Index;
      Transform_Res_19 :
            Bare_Op_Div
               := No_Bare_RFLX_Node;
      Row_Pos_21 :
            Token_Index
               := No_Token_Index;
      Token_Pos_71 :
            Token_Index
               := No_Token_Index;
      Token_Res_71 :
            Token_Index
               := No_Token_Index;
      Transform_Res_20 :
            Bare_Op_Mod
               := No_Bare_RFLX_Node;
      Or_Pos_9 :
            Token_Index
               := No_Token_Index;
      Or_Res_9 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_17 :
            Token_Index
               := No_Token_Index;
      Defer_Res_17 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_4 :
            Integer
               := 0;
      Transform_Res_21 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_4 :
            Boolean
               := False;
      Defer_Pos_18 :
            Token_Index
               := No_Token_Index;
      Defer_Res_18 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_10 :
            Token_Index
               := No_Token_Index;
      Or_Res_10 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Term_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_10 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_10;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_10;
   end if;

       Set (Parser.Private_Part.Extended_Term_Or_Parse_1_Memo, False, Or_Res_10, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_4 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_10 := No_Token_Index;
Or_Res_10 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_18 := Pos;



Defer_Res_16 :=
   Extended_Term_Or_Parse_1 (Parser, Row_Pos_18);
Defer_Pos_16 := Parser.Current_Pos;


Row_Progress_4 := 1;

if Defer_Pos_16 /= No_Token_Index then

   Row_Pos_18 := Defer_Pos_16;

else
   Row_Pos_18 := No_Token_Index;
   goto Exit_Row_18_0;

end if;


--  Start or_code

Or_Pos_9 := No_Token_Index;
Or_Res_9 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_19 := Row_Pos_18;



--  Start tok_code

Token_Res_69 := Row_Pos_19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_69));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mul)
   then
       Token_Pos_69 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_19,
             Expected_Token_Id => RFLX_Mul,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_69 := Row_Pos_19 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_69 /= No_Token_Index then

   Row_Pos_19 := Token_Pos_69;

else
   Row_Pos_19 := No_Token_Index;
   goto Exit_Row_19_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_19_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_19 /= No_Token_Index then

   Transform_Res_18 := Allocate_Op_Mul (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_18,
      Kind => RFLX_Op_Mul,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_18,
      Token_End_Index   => (if Row_Pos_19 = Row_Pos_18
                            then No_Token_Index
                            else Row_Pos_19 - 1));




end if;

--  End transform_code

    if Row_Pos_19 /= No_Token_Index then
        Or_Pos_9 := Row_Pos_19;
        Or_Res_9 := Transform_Res_18;
        goto Exit_Or_10;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_20 := Row_Pos_18;



--  Start tok_code

Token_Res_70 := Row_Pos_20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_70));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Div)
   then
       Token_Pos_70 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_20,
             Expected_Token_Id => RFLX_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_70 := Row_Pos_20 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_70 /= No_Token_Index then

   Row_Pos_20 := Token_Pos_70;

else
   Row_Pos_20 := No_Token_Index;
   goto Exit_Row_20_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_20_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_20 /= No_Token_Index then

   Transform_Res_19 := Allocate_Op_Div (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_19,
      Kind => RFLX_Op_Div,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_18,
      Token_End_Index   => (if Row_Pos_20 = Row_Pos_18
                            then No_Token_Index
                            else Row_Pos_20 - 1));




end if;

--  End transform_code

    if Row_Pos_20 /= No_Token_Index then
        Or_Pos_9 := Row_Pos_20;
        Or_Res_9 := Transform_Res_19;
        goto Exit_Or_10;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_21 := Row_Pos_18;



--  Start tok_code

Token_Res_71 := Row_Pos_21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_71));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mod)
   then
       Token_Pos_71 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_21,
             Expected_Token_Id => RFLX_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_71 := Row_Pos_21 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_71 /= No_Token_Index then

   Row_Pos_21 := Token_Pos_71;

else
   Row_Pos_21 := No_Token_Index;
   goto Exit_Row_21_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_21_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_21 /= No_Token_Index then

   Transform_Res_20 := Allocate_Op_Mod (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_20,
      Kind => RFLX_Op_Mod,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_18,
      Token_End_Index   => (if Row_Pos_21 = Row_Pos_18
                            then No_Token_Index
                            else Row_Pos_21 - 1));




end if;

--  End transform_code

    if Row_Pos_21 /= No_Token_Index then
        Or_Pos_9 := Row_Pos_21;
        Or_Res_9 := Transform_Res_20;
        goto Exit_Or_10;
    end if;
<<Exit_Or_10>>

--  End or_code


Row_Progress_4 := 2;

if Or_Pos_9 /= No_Token_Index then

   Row_Pos_18 := Or_Pos_9;

else
   Row_Pos_18 := No_Token_Index;
   goto Exit_Row_18_0;

end if;

Nobt_4 := True;

Row_Progress_4 := 3;

if Row_Pos_18 /= No_Token_Index then

   Row_Pos_18 := Row_Pos_18;

else
   Row_Pos_18 := No_Token_Index;
   goto Exit_Row_18_0;

end if;


Defer_Res_17 :=
   Extended_Factor_Or_Parse_1 (Parser, Row_Pos_18);
Defer_Pos_17 := Parser.Current_Pos;


Row_Progress_4 := 4;

if Defer_Pos_17 /= No_Token_Index then

   Row_Pos_18 := Defer_Pos_17;

else
   Row_Pos_18 := No_Token_Index;
   goto Exit_Row_18_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_18_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_18 = No_Token_Index and then Nobt_4 then
   Row_Pos_18 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_4 := True;
end if;

if Row_Pos_18 /= No_Token_Index then

   Transform_Res_21 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_21,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_18 = Pos
                            then No_Token_Index
                            else Row_Pos_18 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_21, Bin_Op_F_Left => Defer_Res_16, Bin_Op_F_Op => Or_Res_9, Bin_Op_F_Right => Defer_Res_17);

         if Defer_Res_16 /= null and then Is_Incomplete (Defer_Res_16) then
            Transform_Res_21.Last_Attempted_Child := 0;
         elsif Defer_Res_16 /= null and then not Is_Ghost (Defer_Res_16) then
            Transform_Res_21.Last_Attempted_Child := -1;
         end if;
         if Or_Res_9 /= null and then Is_Incomplete (Or_Res_9) then
            Transform_Res_21.Last_Attempted_Child := 0;
         elsif Or_Res_9 /= null and then not Is_Ghost (Or_Res_9) then
            Transform_Res_21.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_17 /= null and then Is_Incomplete (Defer_Res_17) then
            Transform_Res_21.Last_Attempted_Child := 0;
         elsif Defer_Res_17 /= null and then not Is_Ghost (Defer_Res_17) then
            Transform_Res_21.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_4 then
      Transform_Res_21.Last_Attempted_Child :=
         Row_Progress_4;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_18 /= No_Token_Index then
        Or_Pos_10 := Row_Pos_18;
        Or_Res_10 := Transform_Res_21;
        goto Exit_Or_9;
    end if;
    
Defer_Res_18 :=
   Extended_Factor_Or_Parse_1 (Parser, Pos);
Defer_Pos_18 := Parser.Current_Pos;

    if Defer_Pos_18 /= No_Token_Index then
        Or_Pos_10 := Defer_Pos_18;
        Or_Res_10 := Defer_Res_18;
        goto Exit_Or_9;
    end if;
<<Exit_Or_9>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_10 > Mem_Pos then
         Mem_Pos := Or_Pos_10;
         Mem_Res := Or_Res_10;
         Set
           (Parser.Private_Part.Extended_Term_Or_Parse_1_Memo,
            Or_Pos_10 /= No_Token_Index,
            Or_Res_10,
            Pos,
            Or_Pos_10);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_10 := Mem_Res;
         Or_Pos_10 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Term_Or_Parse_1_Memo,
      Or_Pos_10 /= No_Token_Index,
      Or_Res_10,
      Pos,
      Or_Pos_10);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_10;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_10;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Term_Or_Parse_1;

   


function Extended_Unop_Term_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_3 :
            Boolean
               := False;
      Row_Pos_17 :
            Token_Index
               := No_Token_Index;
      Token_Pos_68 :
            Token_Index
               := No_Token_Index;
      Token_Res_68 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_14 :
            Token_Index
               := No_Token_Index;
      Defer_Res_14 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_3 :
            Integer
               := 0;
      Transform_Res_17 :
            Bare_Negation
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_3 :
            Boolean
               := False;
      Defer_Pos_15 :
            Token_Index
               := No_Token_Index;
      Defer_Res_15 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_8 :
            Token_Index
               := No_Token_Index;
      Or_Res_8 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_Unop_Term_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_8 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_8;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_8;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_8 := No_Token_Index;
Or_Res_8 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_17 := Pos;



--  Start tok_code

Token_Res_68 := Row_Pos_17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_68));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sub)
   then
       Token_Pos_68 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_17,
             Expected_Token_Id => RFLX_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_68 := Row_Pos_17 + 1;
   end if;
end;

--  End tok_code


Row_Progress_3 := 1;

if Token_Pos_68 /= No_Token_Index then

   Row_Pos_17 := Token_Pos_68;

else
   Row_Pos_17 := No_Token_Index;
   goto Exit_Row_17_0;

end if;

Nobt_3 := True;

Row_Progress_3 := 2;

if Row_Pos_17 /= No_Token_Index then

   Row_Pos_17 := Row_Pos_17;

else
   Row_Pos_17 := No_Token_Index;
   goto Exit_Row_17_0;

end if;


Defer_Res_14 :=
   Extended_Term_Or_Parse_1 (Parser, Row_Pos_17);
Defer_Pos_14 := Parser.Current_Pos;


Row_Progress_3 := 3;

if Defer_Pos_14 /= No_Token_Index then

   Row_Pos_17 := Defer_Pos_14;

else
   Row_Pos_17 := No_Token_Index;
   goto Exit_Row_17_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_17_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_17 = No_Token_Index and then Nobt_3 then
   Row_Pos_17 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_3 := True;
end if;

if Row_Pos_17 /= No_Token_Index then

   Transform_Res_17 := Allocate_Negation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_17,
      Kind => RFLX_Negation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_17 = Pos
                            then No_Token_Index
                            else Row_Pos_17 - 1));

      Initialize_Fields_For_Negation
        (Self => Transform_Res_17, Negation_F_Data => Defer_Res_14);

         if Defer_Res_14 /= null and then Is_Incomplete (Defer_Res_14) then
            Transform_Res_17.Last_Attempted_Child := 0;
         elsif Defer_Res_14 /= null and then not Is_Ghost (Defer_Res_14) then
            Transform_Res_17.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_3 then
      Transform_Res_17.Last_Attempted_Child :=
         Row_Progress_3;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_unop_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_17 /= No_Token_Index then
        Or_Pos_8 := Row_Pos_17;
        Or_Res_8 := Transform_Res_17;
        goto Exit_Or_8;
    end if;
    
Defer_Res_15 :=
   Extended_Term_Or_Parse_1 (Parser, Pos);
Defer_Pos_15 := Parser.Current_Pos;

    if Defer_Pos_15 /= No_Token_Index then
        Or_Pos_8 := Defer_Pos_15;
        Or_Res_8 := Defer_Res_15;
        goto Exit_Or_8;
    end if;
<<Exit_Or_8>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_Unop_Term_Or_Parse_0_Memo,
      Or_Pos_8 /= No_Token_Index,
      Or_Res_8,
      Pos,
      Or_Pos_8);


   Parser.Current_Pos := Or_Pos_8;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_8;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Unop_Term_Or_Parse_0;

   


function Extended_Simple_Expr_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_2 :
            Boolean
               := False;
      Row_Pos_14 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_11 :
            Token_Index
               := No_Token_Index;
      Defer_Res_11 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_15 :
            Token_Index
               := No_Token_Index;
      Token_Pos_66 :
            Token_Index
               := No_Token_Index;
      Token_Res_66 :
            Token_Index
               := No_Token_Index;
      Transform_Res_14 :
            Bare_Op_Add
               := No_Bare_RFLX_Node;
      Row_Pos_16 :
            Token_Index
               := No_Token_Index;
      Token_Pos_67 :
            Token_Index
               := No_Token_Index;
      Token_Res_67 :
            Token_Index
               := No_Token_Index;
      Transform_Res_15 :
            Bare_Op_Sub
               := No_Bare_RFLX_Node;
      Or_Pos_6 :
            Token_Index
               := No_Token_Index;
      Or_Res_6 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_12 :
            Token_Index
               := No_Token_Index;
      Defer_Res_12 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_2 :
            Integer
               := 0;
      Transform_Res_16 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_2 :
            Boolean
               := False;
      Defer_Pos_13 :
            Token_Index
               := No_Token_Index;
      Defer_Res_13 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_7 :
            Token_Index
               := No_Token_Index;
      Or_Res_7 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Simple_Expr_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_7 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_7;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_7;
   end if;

       Set (Parser.Private_Part.Extended_Simple_Expr_Or_Parse_1_Memo, False, Or_Res_7, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_2 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_7 := No_Token_Index;
Or_Res_7 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_14 := Pos;



Defer_Res_11 :=
   Extended_Simple_Expr_Or_Parse_1 (Parser, Row_Pos_14);
Defer_Pos_11 := Parser.Current_Pos;


Row_Progress_2 := 1;

if Defer_Pos_11 /= No_Token_Index then

   Row_Pos_14 := Defer_Pos_11;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_14_0;

end if;


--  Start or_code

Or_Pos_6 := No_Token_Index;
Or_Res_6 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_15 := Row_Pos_14;



--  Start tok_code

Token_Res_66 := Row_Pos_15;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_66));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Add)
   then
       Token_Pos_66 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_15 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_15,
             Expected_Token_Id => RFLX_Add,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_66 := Row_Pos_15 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_66 /= No_Token_Index then

   Row_Pos_15 := Token_Pos_66;

else
   Row_Pos_15 := No_Token_Index;
   goto Exit_Row_15_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_15_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_15 /= No_Token_Index then

   Transform_Res_14 := Allocate_Op_Add (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_14,
      Kind => RFLX_Op_Add,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_14,
      Token_End_Index   => (if Row_Pos_15 = Row_Pos_14
                            then No_Token_Index
                            else Row_Pos_15 - 1));




end if;

--  End transform_code

    if Row_Pos_15 /= No_Token_Index then
        Or_Pos_6 := Row_Pos_15;
        Or_Res_6 := Transform_Res_14;
        goto Exit_Or_7;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_16 := Row_Pos_14;



--  Start tok_code

Token_Res_67 := Row_Pos_16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_67));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sub)
   then
       Token_Pos_67 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_16,
             Expected_Token_Id => RFLX_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_67 := Row_Pos_16 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_67 /= No_Token_Index then

   Row_Pos_16 := Token_Pos_67;

else
   Row_Pos_16 := No_Token_Index;
   goto Exit_Row_16_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_16_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_16 /= No_Token_Index then

   Transform_Res_15 := Allocate_Op_Sub (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_15,
      Kind => RFLX_Op_Sub,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_14,
      Token_End_Index   => (if Row_Pos_16 = Row_Pos_14
                            then No_Token_Index
                            else Row_Pos_16 - 1));




end if;

--  End transform_code

    if Row_Pos_16 /= No_Token_Index then
        Or_Pos_6 := Row_Pos_16;
        Or_Res_6 := Transform_Res_15;
        goto Exit_Or_7;
    end if;
<<Exit_Or_7>>

--  End or_code


Row_Progress_2 := 2;

if Or_Pos_6 /= No_Token_Index then

   Row_Pos_14 := Or_Pos_6;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_14_0;

end if;

Nobt_2 := True;

Row_Progress_2 := 3;

if Row_Pos_14 /= No_Token_Index then

   Row_Pos_14 := Row_Pos_14;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_14_0;

end if;


Defer_Res_12 :=
   Extended_Unop_Term_Or_Parse_0 (Parser, Row_Pos_14);
Defer_Pos_12 := Parser.Current_Pos;


Row_Progress_2 := 4;

if Defer_Pos_12 /= No_Token_Index then

   Row_Pos_14 := Defer_Pos_12;

else
   Row_Pos_14 := No_Token_Index;
   goto Exit_Row_14_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_14_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_14 = No_Token_Index and then Nobt_2 then
   Row_Pos_14 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_2 := True;
end if;

if Row_Pos_14 /= No_Token_Index then

   Transform_Res_16 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_16,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_14 = Pos
                            then No_Token_Index
                            else Row_Pos_14 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_16, Bin_Op_F_Left => Defer_Res_11, Bin_Op_F_Op => Or_Res_6, Bin_Op_F_Right => Defer_Res_12);

         if Defer_Res_11 /= null and then Is_Incomplete (Defer_Res_11) then
            Transform_Res_16.Last_Attempted_Child := 0;
         elsif Defer_Res_11 /= null and then not Is_Ghost (Defer_Res_11) then
            Transform_Res_16.Last_Attempted_Child := -1;
         end if;
         if Or_Res_6 /= null and then Is_Incomplete (Or_Res_6) then
            Transform_Res_16.Last_Attempted_Child := 0;
         elsif Or_Res_6 /= null and then not Is_Ghost (Or_Res_6) then
            Transform_Res_16.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_12 /= null and then Is_Incomplete (Defer_Res_12) then
            Transform_Res_16.Last_Attempted_Child := 0;
         elsif Defer_Res_12 /= null and then not Is_Ghost (Defer_Res_12) then
            Transform_Res_16.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_2 then
      Transform_Res_16.Last_Attempted_Child :=
         Row_Progress_2;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_simple_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_14 /= No_Token_Index then
        Or_Pos_7 := Row_Pos_14;
        Or_Res_7 := Transform_Res_16;
        goto Exit_Or_6;
    end if;
    
Defer_Res_13 :=
   Extended_Unop_Term_Or_Parse_0 (Parser, Pos);
Defer_Pos_13 := Parser.Current_Pos;

    if Defer_Pos_13 /= No_Token_Index then
        Or_Pos_7 := Defer_Pos_13;
        Or_Res_7 := Defer_Res_13;
        goto Exit_Or_6;
    end if;
<<Exit_Or_6>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_7 > Mem_Pos then
         Mem_Pos := Or_Pos_7;
         Mem_Res := Or_Res_7;
         Set
           (Parser.Private_Part.Extended_Simple_Expr_Or_Parse_1_Memo,
            Or_Pos_7 /= No_Token_Index,
            Or_Res_7,
            Pos,
            Or_Pos_7);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_7 := Mem_Res;
         Or_Pos_7 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Simple_Expr_Or_Parse_1_Memo,
      Or_Pos_7 /= No_Token_Index,
      Or_Res_7,
      Pos,
      Or_Pos_7);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_7;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_7;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Simple_Expr_Or_Parse_1;

   


function Extended_Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_1 :
            Boolean
               := False;
      Row_Pos_5 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_8 :
            Token_Index
               := No_Token_Index;
      Defer_Res_8 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_6 :
            Token_Index
               := No_Token_Index;
      Token_Pos_57 :
            Token_Index
               := No_Token_Index;
      Token_Res_57 :
            Token_Index
               := No_Token_Index;
      Transform_Res_5 :
            Bare_Op_Eq
               := No_Bare_RFLX_Node;
      Row_Pos_7 :
            Token_Index
               := No_Token_Index;
      Token_Pos_58 :
            Token_Index
               := No_Token_Index;
      Token_Res_58 :
            Token_Index
               := No_Token_Index;
      Transform_Res_6 :
            Bare_Op_Neq
               := No_Bare_RFLX_Node;
      Row_Pos_8 :
            Token_Index
               := No_Token_Index;
      Token_Pos_59 :
            Token_Index
               := No_Token_Index;
      Token_Res_59 :
            Token_Index
               := No_Token_Index;
      Transform_Res_7 :
            Bare_Op_Le
               := No_Bare_RFLX_Node;
      Row_Pos_9 :
            Token_Index
               := No_Token_Index;
      Token_Pos_60 :
            Token_Index
               := No_Token_Index;
      Token_Res_60 :
            Token_Index
               := No_Token_Index;
      Transform_Res_8 :
            Bare_Op_Lt
               := No_Bare_RFLX_Node;
      Row_Pos_10 :
            Token_Index
               := No_Token_Index;
      Token_Pos_61 :
            Token_Index
               := No_Token_Index;
      Token_Res_61 :
            Token_Index
               := No_Token_Index;
      Transform_Res_9 :
            Bare_Op_Ge
               := No_Bare_RFLX_Node;
      Row_Pos_11 :
            Token_Index
               := No_Token_Index;
      Token_Pos_62 :
            Token_Index
               := No_Token_Index;
      Token_Res_62 :
            Token_Index
               := No_Token_Index;
      Transform_Res_10 :
            Bare_Op_Gt
               := No_Bare_RFLX_Node;
      Row_Pos_12 :
            Token_Index
               := No_Token_Index;
      Token_Pos_63 :
            Token_Index
               := No_Token_Index;
      Token_Res_63 :
            Token_Index
               := No_Token_Index;
      Transform_Res_11 :
            Bare_Op_In
               := No_Bare_RFLX_Node;
      Row_Pos_13 :
            Token_Index
               := No_Token_Index;
      Token_Pos_64 :
            Token_Index
               := No_Token_Index;
      Token_Res_64 :
            Token_Index
               := No_Token_Index;
      Token_Pos_65 :
            Token_Index
               := No_Token_Index;
      Token_Res_65 :
            Token_Index
               := No_Token_Index;
      Transform_Res_12 :
            Bare_Op_Notin
               := No_Bare_RFLX_Node;
      Or_Pos_4 :
            Token_Index
               := No_Token_Index;
      Or_Res_4 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_9 :
            Token_Index
               := No_Token_Index;
      Defer_Res_9 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_1 :
            Integer
               := 0;
      Transform_Res_13 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_1 :
            Boolean
               := False;
      Defer_Pos_10 :
            Token_Index
               := No_Token_Index;
      Defer_Res_10 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_5 :
            Token_Index
               := No_Token_Index;
      Or_Res_5 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Relation_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_5 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_5;
   end if;

       Set (Parser.Private_Part.Extended_Relation_Or_Parse_1_Memo, False, Or_Res_5, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_1 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_5 := No_Token_Index;
Or_Res_5 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_5 := Pos;



Defer_Res_8 :=
   Extended_Relation_Or_Parse_1 (Parser, Row_Pos_5);
Defer_Pos_8 := Parser.Current_Pos;


Row_Progress_1 := 1;

if Defer_Pos_8 /= No_Token_Index then

   Row_Pos_5 := Defer_Pos_8;

else
   Row_Pos_5 := No_Token_Index;
   goto Exit_Row_5_0;

end if;


--  Start or_code

Or_Pos_4 := No_Token_Index;
Or_Res_4 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_6 := Row_Pos_5;



--  Start tok_code

Token_Res_57 := Row_Pos_6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_57));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Eq)
   then
       Token_Pos_57 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_6,
             Expected_Token_Id => RFLX_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_57 := Row_Pos_6 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_57 /= No_Token_Index then

   Row_Pos_6 := Token_Pos_57;

else
   Row_Pos_6 := No_Token_Index;
   goto Exit_Row_6_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_6_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_6 /= No_Token_Index then

   Transform_Res_5 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_5,
      Kind => RFLX_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_6 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_6 - 1));




end if;

--  End transform_code

    if Row_Pos_6 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_6;
        Or_Res_4 := Transform_Res_5;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_7 := Row_Pos_5;



--  Start tok_code

Token_Res_58 := Row_Pos_7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_58));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Neq)
   then
       Token_Pos_58 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_7,
             Expected_Token_Id => RFLX_Neq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_58 := Row_Pos_7 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_58 /= No_Token_Index then

   Row_Pos_7 := Token_Pos_58;

else
   Row_Pos_7 := No_Token_Index;
   goto Exit_Row_7_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_7_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_7 /= No_Token_Index then

   Transform_Res_6 := Allocate_Op_Neq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_6,
      Kind => RFLX_Op_Neq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_7 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_7 - 1));




end if;

--  End transform_code

    if Row_Pos_7 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_7;
        Or_Res_4 := Transform_Res_6;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_8 := Row_Pos_5;



--  Start tok_code

Token_Res_59 := Row_Pos_8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_59));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Le)
   then
       Token_Pos_59 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_8,
             Expected_Token_Id => RFLX_Le,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_59 := Row_Pos_8 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_59 /= No_Token_Index then

   Row_Pos_8 := Token_Pos_59;

else
   Row_Pos_8 := No_Token_Index;
   goto Exit_Row_8_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_8_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_8 /= No_Token_Index then

   Transform_Res_7 := Allocate_Op_Le (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_7,
      Kind => RFLX_Op_Le,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_8 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_8 - 1));




end if;

--  End transform_code

    if Row_Pos_8 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_8;
        Or_Res_4 := Transform_Res_7;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_9 := Row_Pos_5;



--  Start tok_code

Token_Res_60 := Row_Pos_9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_60));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Lt)
   then
       Token_Pos_60 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_9,
             Expected_Token_Id => RFLX_Lt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_60 := Row_Pos_9 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_60 /= No_Token_Index then

   Row_Pos_9 := Token_Pos_60;

else
   Row_Pos_9 := No_Token_Index;
   goto Exit_Row_9_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_9_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_9 /= No_Token_Index then

   Transform_Res_8 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_8,
      Kind => RFLX_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_9 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_9 - 1));




end if;

--  End transform_code

    if Row_Pos_9 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_9;
        Or_Res_4 := Transform_Res_8;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_10 := Row_Pos_5;



--  Start tok_code

Token_Res_61 := Row_Pos_10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_61));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Ge)
   then
       Token_Pos_61 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_10,
             Expected_Token_Id => RFLX_Ge,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_61 := Row_Pos_10 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_61 /= No_Token_Index then

   Row_Pos_10 := Token_Pos_61;

else
   Row_Pos_10 := No_Token_Index;
   goto Exit_Row_10_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_10_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_10 /= No_Token_Index then

   Transform_Res_9 := Allocate_Op_Ge (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_9,
      Kind => RFLX_Op_Ge,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_10 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_10 - 1));




end if;

--  End transform_code

    if Row_Pos_10 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_10;
        Or_Res_4 := Transform_Res_9;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_11 := Row_Pos_5;



--  Start tok_code

Token_Res_62 := Row_Pos_11;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_62));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Gt)
   then
       Token_Pos_62 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_11 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_11,
             Expected_Token_Id => RFLX_Gt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_62 := Row_Pos_11 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_62 /= No_Token_Index then

   Row_Pos_11 := Token_Pos_62;

else
   Row_Pos_11 := No_Token_Index;
   goto Exit_Row_11_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_11_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_11 /= No_Token_Index then

   Transform_Res_10 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_10,
      Kind => RFLX_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_11 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_11 - 1));




end if;

--  End transform_code

    if Row_Pos_11 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_11;
        Or_Res_4 := Transform_Res_10;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_12 := Row_Pos_5;



--  Start tok_code

Token_Res_63 := Row_Pos_12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_63));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_In)
   then
       Token_Pos_63 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_12,
             Expected_Token_Id => RFLX_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_63 := Row_Pos_12 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_63 /= No_Token_Index then

   Row_Pos_12 := Token_Pos_63;

else
   Row_Pos_12 := No_Token_Index;
   goto Exit_Row_12_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_12_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_12 /= No_Token_Index then

   Transform_Res_11 := Allocate_Op_In (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_11,
      Kind => RFLX_Op_In,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_12 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_12 - 1));




end if;

--  End transform_code

    if Row_Pos_12 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_12;
        Or_Res_4 := Transform_Res_11;
        goto Exit_Or_5;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_13 := Row_Pos_5;



--  Start tok_code

Token_Res_64 := Row_Pos_13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_64));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Not)
   then
       Token_Pos_64 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_13,
             Expected_Token_Id => RFLX_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_64 := Row_Pos_13 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_64 /= No_Token_Index then

   Row_Pos_13 := Token_Pos_64;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_13_0;

end if;


--  Start tok_code

Token_Res_65 := Row_Pos_13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_65));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_In)
   then
       Token_Pos_65 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_13,
             Expected_Token_Id => RFLX_In,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_65 := Row_Pos_13 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_65 /= No_Token_Index then

   Row_Pos_13 := Token_Pos_65;

else
   Row_Pos_13 := No_Token_Index;
   goto Exit_Row_13_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_13_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_13 /= No_Token_Index then

   Transform_Res_12 := Allocate_Op_Notin (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_12,
      Kind => RFLX_Op_Notin,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_5,
      Token_End_Index   => (if Row_Pos_13 = Row_Pos_5
                            then No_Token_Index
                            else Row_Pos_13 - 1));




end if;

--  End transform_code

    if Row_Pos_13 /= No_Token_Index then
        Or_Pos_4 := Row_Pos_13;
        Or_Res_4 := Transform_Res_12;
        goto Exit_Or_5;
    end if;
<<Exit_Or_5>>

--  End or_code


Row_Progress_1 := 2;

if Or_Pos_4 /= No_Token_Index then

   Row_Pos_5 := Or_Pos_4;

else
   Row_Pos_5 := No_Token_Index;
   goto Exit_Row_5_0;

end if;

Nobt_1 := True;

Row_Progress_1 := 3;

if Row_Pos_5 /= No_Token_Index then

   Row_Pos_5 := Row_Pos_5;

else
   Row_Pos_5 := No_Token_Index;
   goto Exit_Row_5_0;

end if;


Defer_Res_9 :=
   Extended_Simple_Expr_Or_Parse_1 (Parser, Row_Pos_5);
Defer_Pos_9 := Parser.Current_Pos;


Row_Progress_1 := 4;

if Defer_Pos_9 /= No_Token_Index then

   Row_Pos_5 := Defer_Pos_9;

else
   Row_Pos_5 := No_Token_Index;
   goto Exit_Row_5_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_5_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_5 = No_Token_Index and then Nobt_1 then
   Row_Pos_5 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_1 := True;
end if;

if Row_Pos_5 /= No_Token_Index then

   Transform_Res_13 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_13,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_5 = Pos
                            then No_Token_Index
                            else Row_Pos_5 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_13, Bin_Op_F_Left => Defer_Res_8, Bin_Op_F_Op => Or_Res_4, Bin_Op_F_Right => Defer_Res_9);

         if Defer_Res_8 /= null and then Is_Incomplete (Defer_Res_8) then
            Transform_Res_13.Last_Attempted_Child := 0;
         elsif Defer_Res_8 /= null and then not Is_Ghost (Defer_Res_8) then
            Transform_Res_13.Last_Attempted_Child := -1;
         end if;
         if Or_Res_4 /= null and then Is_Incomplete (Or_Res_4) then
            Transform_Res_13.Last_Attempted_Child := 0;
         elsif Or_Res_4 /= null and then not Is_Ghost (Or_Res_4) then
            Transform_Res_13.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_9 /= null and then Is_Incomplete (Defer_Res_9) then
            Transform_Res_13.Last_Attempted_Child := 0;
         elsif Defer_Res_9 /= null and then not Is_Ghost (Defer_Res_9) then
            Transform_Res_13.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_1 then
      Transform_Res_13.Last_Attempted_Child :=
         Row_Progress_1;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_relation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_5 /= No_Token_Index then
        Or_Pos_5 := Row_Pos_5;
        Or_Res_5 := Transform_Res_13;
        goto Exit_Or_4;
    end if;
    
Defer_Res_10 :=
   Extended_Simple_Expr_Or_Parse_1 (Parser, Pos);
Defer_Pos_10 := Parser.Current_Pos;

    if Defer_Pos_10 /= No_Token_Index then
        Or_Pos_5 := Defer_Pos_10;
        Or_Res_5 := Defer_Res_10;
        goto Exit_Or_4;
    end if;
<<Exit_Or_4>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_5 > Mem_Pos then
         Mem_Pos := Or_Pos_5;
         Mem_Res := Or_Res_5;
         Set
           (Parser.Private_Part.Extended_Relation_Or_Parse_1_Memo,
            Or_Pos_5 /= No_Token_Index,
            Or_Res_5,
            Pos,
            Or_Pos_5);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_5 := Mem_Res;
         Or_Pos_5 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Relation_Or_Parse_1_Memo,
      Or_Pos_5 /= No_Token_Index,
      Or_Res_5,
      Pos,
      Or_Pos_5);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_5;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_5;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Relation_Or_Parse_1;

   


function Extended_Expression_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_0 :
            Boolean
               := False;
      Row_Pos_2 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_5 :
            Token_Index
               := No_Token_Index;
      Defer_Res_5 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_3 :
            Token_Index
               := No_Token_Index;
      Token_Pos_55 :
            Token_Index
               := No_Token_Index;
      Token_Res_55 :
            Token_Index
               := No_Token_Index;
      Transform_Res_2 :
            Bare_Op_And
               := No_Bare_RFLX_Node;
      Row_Pos_4 :
            Token_Index
               := No_Token_Index;
      Token_Pos_56 :
            Token_Index
               := No_Token_Index;
      Token_Res_56 :
            Token_Index
               := No_Token_Index;
      Transform_Res_3 :
            Bare_Op_Or
               := No_Bare_RFLX_Node;
      Or_Pos_2 :
            Token_Index
               := No_Token_Index;
      Or_Res_2 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_6 :
            Token_Index
               := No_Token_Index;
      Defer_Res_6 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_0 :
            Integer
               := 0;
      Transform_Res_4 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_0 :
            Boolean
               := False;
      Defer_Pos_7 :
            Token_Index
               := No_Token_Index;
      Defer_Res_7 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_3 :
            Token_Index
               := No_Token_Index;
      Or_Res_3 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Extended_Expression_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_3 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_3;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_3;
   end if;

       Set (Parser.Private_Part.Extended_Expression_Or_Parse_1_Memo, False, Or_Res_3, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_0 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_3 := No_Token_Index;
Or_Res_3 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_2 := Pos;



Defer_Res_5 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_2);
Defer_Pos_5 := Parser.Current_Pos;


Row_Progress_0 := 1;

if Defer_Pos_5 /= No_Token_Index then

   Row_Pos_2 := Defer_Pos_5;

else
   Row_Pos_2 := No_Token_Index;
   goto Exit_Row_2_0;

end if;


--  Start or_code

Or_Pos_2 := No_Token_Index;
Or_Res_2 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_3 := Row_Pos_2;



--  Start tok_code

Token_Res_55 := Row_Pos_3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_55));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_And)
   then
       Token_Pos_55 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_3,
             Expected_Token_Id => RFLX_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_55 := Row_Pos_3 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_55 /= No_Token_Index then

   Row_Pos_3 := Token_Pos_55;

else
   Row_Pos_3 := No_Token_Index;
   goto Exit_Row_3_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_3_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_3 /= No_Token_Index then

   Transform_Res_2 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_2,
      Kind => RFLX_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_2,
      Token_End_Index   => (if Row_Pos_3 = Row_Pos_2
                            then No_Token_Index
                            else Row_Pos_3 - 1));




end if;

--  End transform_code

    if Row_Pos_3 /= No_Token_Index then
        Or_Pos_2 := Row_Pos_3;
        Or_Res_2 := Transform_Res_2;
        goto Exit_Or_3;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_4 := Row_Pos_2;



--  Start tok_code

Token_Res_56 := Row_Pos_4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_56));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Or)
   then
       Token_Pos_56 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_4,
             Expected_Token_Id => RFLX_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_56 := Row_Pos_4 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_56 /= No_Token_Index then

   Row_Pos_4 := Token_Pos_56;

else
   Row_Pos_4 := No_Token_Index;
   goto Exit_Row_4_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_4_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_4 /= No_Token_Index then

   Transform_Res_3 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_3,
      Kind => RFLX_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_2,
      Token_End_Index   => (if Row_Pos_4 = Row_Pos_2
                            then No_Token_Index
                            else Row_Pos_4 - 1));




end if;

--  End transform_code

    if Row_Pos_4 /= No_Token_Index then
        Or_Pos_2 := Row_Pos_4;
        Or_Res_2 := Transform_Res_3;
        goto Exit_Or_3;
    end if;
<<Exit_Or_3>>

--  End or_code


Row_Progress_0 := 2;

if Or_Pos_2 /= No_Token_Index then

   Row_Pos_2 := Or_Pos_2;

else
   Row_Pos_2 := No_Token_Index;
   goto Exit_Row_2_0;

end if;

Nobt_0 := True;

Row_Progress_0 := 3;

if Row_Pos_2 /= No_Token_Index then

   Row_Pos_2 := Row_Pos_2;

else
   Row_Pos_2 := No_Token_Index;
   goto Exit_Row_2_0;

end if;


Defer_Res_6 :=
   Extended_Relation_Or_Parse_1 (Parser, Row_Pos_2);
Defer_Pos_6 := Parser.Current_Pos;


Row_Progress_0 := 4;

if Defer_Pos_6 /= No_Token_Index then

   Row_Pos_2 := Defer_Pos_6;

else
   Row_Pos_2 := No_Token_Index;
   goto Exit_Row_2_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_2_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_2 = No_Token_Index and then Nobt_0 then
   Row_Pos_2 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_0 := True;
end if;

if Row_Pos_2 /= No_Token_Index then

   Transform_Res_4 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_4,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_2 = Pos
                            then No_Token_Index
                            else Row_Pos_2 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_4, Bin_Op_F_Left => Defer_Res_5, Bin_Op_F_Op => Or_Res_2, Bin_Op_F_Right => Defer_Res_6);

         if Defer_Res_5 /= null and then Is_Incomplete (Defer_Res_5) then
            Transform_Res_4.Last_Attempted_Child := 0;
         elsif Defer_Res_5 /= null and then not Is_Ghost (Defer_Res_5) then
            Transform_Res_4.Last_Attempted_Child := -1;
         end if;
         if Or_Res_2 /= null and then Is_Incomplete (Or_Res_2) then
            Transform_Res_4.Last_Attempted_Child := 0;
         elsif Or_Res_2 /= null and then not Is_Ghost (Or_Res_2) then
            Transform_Res_4.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_6 /= null and then Is_Incomplete (Defer_Res_6) then
            Transform_Res_4.Last_Attempted_Child := 0;
         elsif Defer_Res_6 /= null and then not Is_Ghost (Defer_Res_6) then
            Transform_Res_4.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_0 then
      Transform_Res_4.Last_Attempted_Child :=
         Row_Progress_0;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <extended_expression>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_2 /= No_Token_Index then
        Or_Pos_3 := Row_Pos_2;
        Or_Res_3 := Transform_Res_4;
        goto Exit_Or_2;
    end if;
    
Defer_Res_7 :=
   Extended_Relation_Or_Parse_1 (Parser, Pos);
Defer_Pos_7 := Parser.Current_Pos;

    if Defer_Pos_7 /= No_Token_Index then
        Or_Pos_3 := Defer_Pos_7;
        Or_Res_3 := Defer_Res_7;
        goto Exit_Or_2;
    end if;
<<Exit_Or_2>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_3 > Mem_Pos then
         Mem_Pos := Or_Pos_3;
         Mem_Res := Or_Res_3;
         Set
           (Parser.Private_Part.Extended_Expression_Or_Parse_1_Memo,
            Or_Pos_3 /= No_Token_Index,
            Or_Res_3,
            Pos,
            Or_Pos_3);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_3 := Mem_Res;
         Or_Pos_3 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Extended_Expression_Or_Parse_1_Memo,
      Or_Pos_3 /= No_Token_Index,
      Or_Res_3,
      Pos,
      Or_Pos_3);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_3;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_3;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_Expression_Or_Parse_1;

   


function Assignment_Statement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assignment
is
   use Bare_Assignment_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_0 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_3 :
            Token_Index
               := No_Token_Index;
      Defer_Res_3 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_0 :
            Token_Index
               := No_Token_Index;
      Token_Res_0 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_4 :
            Token_Index
               := No_Token_Index;
      Defer_Res_4 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_0 :
            Bare_Assignment
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Assignment_Statement_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_0 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_0 := Pos;



Defer_Res_3 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_0);
Defer_Pos_3 := Parser.Current_Pos;



if Defer_Pos_3 /= No_Token_Index then

   Row_Pos_0 := Defer_Pos_3;

else
   Row_Pos_0 := No_Token_Index;
   goto Exit_Row_0_0;

end if;


--  Start tok_code

Token_Res_0 := Row_Pos_0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_0));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Assignment)
   then
       Token_Pos_0 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_0,
             Expected_Token_Id => RFLX_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_0 := Row_Pos_0 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_0 /= No_Token_Index then

   Row_Pos_0 := Token_Pos_0;

else
   Row_Pos_0 := No_Token_Index;
   goto Exit_Row_0_0;

end if;


Defer_Res_4 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_0);
Defer_Pos_4 := Parser.Current_Pos;



if Defer_Pos_4 /= No_Token_Index then

   Row_Pos_0 := Defer_Pos_4;

else
   Row_Pos_0 := No_Token_Index;
   goto Exit_Row_0_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_0_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_0 /= No_Token_Index then

   Transform_Res_0 := Allocate_Assignment (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_0,
      Kind => RFLX_Assignment,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_0 = Pos
                            then No_Token_Index
                            else Row_Pos_0 - 1));

      Initialize_Fields_For_Assignment
        (Self => Transform_Res_0, Assignment_F_Identifier => Defer_Res_3, Assignment_F_Expression => Defer_Res_4);

         if Defer_Res_3 /= null and then Is_Incomplete (Defer_Res_3) then
            Transform_Res_0.Last_Attempted_Child := 0;
         elsif Defer_Res_3 /= null and then not Is_Ghost (Defer_Res_3) then
            Transform_Res_0.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_4 /= null and then Is_Incomplete (Defer_Res_4) then
            Transform_Res_0.Last_Attempted_Child := 0;
         elsif Defer_Res_4 /= null and then not Is_Ghost (Defer_Res_4) then
            Transform_Res_0.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Assignment_Statement_Transform_Parse_0_Memo,
      Row_Pos_0 /= No_Token_Index,
      Transform_Res_0,
      Pos,
      Row_Pos_0);


   Parser.Current_Pos := Row_Pos_0;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_0;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Assignment_Statement_Transform_Parse_0;

   


function Message_Field_Assignment_Statement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field_Assignment
is
   use Bare_Message_Field_Assignment_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_58 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_73 :
            Token_Index
               := No_Token_Index;
      Defer_Res_73 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_127 :
            Token_Index
               := No_Token_Index;
      Token_Res_127 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_74 :
            Token_Index
               := No_Token_Index;
      Defer_Res_74 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_128 :
            Token_Index
               := No_Token_Index;
      Token_Res_128 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_75 :
            Token_Index
               := No_Token_Index;
      Defer_Res_75 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_56 :
            Bare_Message_Field_Assignment
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_56 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_56;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_56;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_58 := Pos;



Defer_Res_73 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_58);
Defer_Pos_73 := Parser.Current_Pos;



if Defer_Pos_73 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_73;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_58_0;

end if;


--  Start tok_code

Token_Res_127 := Row_Pos_58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_127));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Dot)
   then
       Token_Pos_127 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_58,
             Expected_Token_Id => RFLX_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_127 := Row_Pos_58 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_127 /= No_Token_Index then

   Row_Pos_58 := Token_Pos_127;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_58_0;

end if;


Defer_Res_74 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_58);
Defer_Pos_74 := Parser.Current_Pos;



if Defer_Pos_74 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_74;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_58_0;

end if;


--  Start tok_code

Token_Res_128 := Row_Pos_58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_128));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Assignment)
   then
       Token_Pos_128 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_58,
             Expected_Token_Id => RFLX_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_128 := Row_Pos_58 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_128 /= No_Token_Index then

   Row_Pos_58 := Token_Pos_128;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_58_0;

end if;


Defer_Res_75 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_58);
Defer_Pos_75 := Parser.Current_Pos;



if Defer_Pos_75 /= No_Token_Index then

   Row_Pos_58 := Defer_Pos_75;

else
   Row_Pos_58 := No_Token_Index;
   goto Exit_Row_58_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_58_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_58 /= No_Token_Index then

   Transform_Res_56 := Allocate_Message_Field_Assignment (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_56,
      Kind => RFLX_Message_Field_Assignment,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_58 = Pos
                            then No_Token_Index
                            else Row_Pos_58 - 1));

      Initialize_Fields_For_Message_Field_Assignment
        (Self => Transform_Res_56, Message_Field_Assignment_F_Message => Defer_Res_73, Message_Field_Assignment_F_Field => Defer_Res_74, Message_Field_Assignment_F_Expression => Defer_Res_75);

         if Defer_Res_73 /= null and then Is_Incomplete (Defer_Res_73) then
            Transform_Res_56.Last_Attempted_Child := 0;
         elsif Defer_Res_73 /= null and then not Is_Ghost (Defer_Res_73) then
            Transform_Res_56.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_74 /= null and then Is_Incomplete (Defer_Res_74) then
            Transform_Res_56.Last_Attempted_Child := 0;
         elsif Defer_Res_74 /= null and then not Is_Ghost (Defer_Res_74) then
            Transform_Res_56.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_75 /= null and then Is_Incomplete (Defer_Res_75) then
            Transform_Res_56.Last_Attempted_Child := 0;
         elsif Defer_Res_75 /= null and then not Is_Ghost (Defer_Res_75) then
            Transform_Res_56.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse_0_Memo,
      Row_Pos_58 /= No_Token_Index,
      Transform_Res_56,
      Pos,
      Row_Pos_58);


   Parser.Current_Pos := Row_Pos_58;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_56;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Field_Assignment_Statement_Transform_Parse_0;

   


function List_Attribute_Transform_Parse_4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Attribute_Statement
is
   use Bare_Attribute_Statement_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_59 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_78 :
            Token_Index
               := No_Token_Index;
      Defer_Res_78 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_129 :
            Token_Index
               := No_Token_Index;
      Token_Res_129 :
            Token_Index
               := No_Token_Index;
      Row_Pos_60 :
            Token_Index
               := No_Token_Index;
      Token_Pos_130 :
            Token_Index
               := No_Token_Index;
      Token_Res_130 :
            Token_Index
               := No_Token_Index;
      Transform_Res_57 :
            Bare_Attr_Stmt_Append
               := No_Bare_RFLX_Node;
      Row_Pos_61 :
            Token_Index
               := No_Token_Index;
      Token_Pos_131 :
            Token_Index
               := No_Token_Index;
      Token_Res_131 :
            Token_Index
               := No_Token_Index;
      Transform_Res_58 :
            Bare_Attr_Stmt_Extend
               := No_Bare_RFLX_Node;
      Row_Pos_62 :
            Token_Index
               := No_Token_Index;
      Token_Pos_132 :
            Token_Index
               := No_Token_Index;
      Token_Res_132 :
            Token_Index
               := No_Token_Index;
      Transform_Res_59 :
            Bare_Attr_Stmt_Read
               := No_Bare_RFLX_Node;
      Row_Pos_63 :
            Token_Index
               := No_Token_Index;
      Token_Pos_133 :
            Token_Index
               := No_Token_Index;
      Token_Res_133 :
            Token_Index
               := No_Token_Index;
      Transform_Res_60 :
            Bare_Attr_Stmt_Write
               := No_Bare_RFLX_Node;
      Or_Pos_23 :
            Token_Index
               := No_Token_Index;
      Or_Res_23 :
            Bare_Attr_Stmt
               := No_Bare_RFLX_Node;
      Token_Pos_134 :
            Token_Index
               := No_Token_Index;
      Token_Res_134 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_79 :
            Token_Index
               := No_Token_Index;
      Defer_Res_79 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_135 :
            Token_Index
               := No_Token_Index;
      Token_Res_135 :
            Token_Index
               := No_Token_Index;
      Transform_Res_61 :
            Bare_Attribute_Statement
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.List_Attribute_Transform_Parse_4_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_61 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_61;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_61;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_59 := Pos;



Defer_Res_78 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_59);
Defer_Pos_78 := Parser.Current_Pos;



if Defer_Pos_78 /= No_Token_Index then

   Row_Pos_59 := Defer_Pos_78;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


--  Start tok_code

Token_Res_129 := Row_Pos_59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_129));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Tick)
   then
       Token_Pos_129 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_59,
             Expected_Token_Id => RFLX_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_129 := Row_Pos_59 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_129 /= No_Token_Index then

   Row_Pos_59 := Token_Pos_129;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


--  Start or_code

Or_Pos_23 := No_Token_Index;
Or_Res_23 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_60 := Row_Pos_59;



--  Start tok_code

Token_Res_130 := Row_Pos_60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_130));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Append)
   then
       Token_Pos_130 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_60,
             Expected_Token_Id => RFLX_Append,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_130 := Row_Pos_60 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_130 /= No_Token_Index then

   Row_Pos_60 := Token_Pos_130;

else
   Row_Pos_60 := No_Token_Index;
   goto Exit_Row_60_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_60_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_60 /= No_Token_Index then

   Transform_Res_57 := Allocate_Attr_Stmt_Append (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_57,
      Kind => RFLX_Attr_Stmt_Append,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_59,
      Token_End_Index   => (if Row_Pos_60 = Row_Pos_59
                            then No_Token_Index
                            else Row_Pos_60 - 1));




end if;

--  End transform_code

    if Row_Pos_60 /= No_Token_Index then
        Or_Pos_23 := Row_Pos_60;
        Or_Res_23 := Transform_Res_57;
        goto Exit_Or_23;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_61 := Row_Pos_59;



--  Start tok_code

Token_Res_131 := Row_Pos_61;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_131));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Extend)
   then
       Token_Pos_131 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_61 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_61,
             Expected_Token_Id => RFLX_Extend,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_131 := Row_Pos_61 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_131 /= No_Token_Index then

   Row_Pos_61 := Token_Pos_131;

else
   Row_Pos_61 := No_Token_Index;
   goto Exit_Row_61_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_61_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_61 /= No_Token_Index then

   Transform_Res_58 := Allocate_Attr_Stmt_Extend (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_58,
      Kind => RFLX_Attr_Stmt_Extend,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_59,
      Token_End_Index   => (if Row_Pos_61 = Row_Pos_59
                            then No_Token_Index
                            else Row_Pos_61 - 1));




end if;

--  End transform_code

    if Row_Pos_61 /= No_Token_Index then
        Or_Pos_23 := Row_Pos_61;
        Or_Res_23 := Transform_Res_58;
        goto Exit_Or_23;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_62 := Row_Pos_59;



--  Start tok_code

Token_Res_132 := Row_Pos_62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_132));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Read)
   then
       Token_Pos_132 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_62,
             Expected_Token_Id => RFLX_Read,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_132 := Row_Pos_62 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_132 /= No_Token_Index then

   Row_Pos_62 := Token_Pos_132;

else
   Row_Pos_62 := No_Token_Index;
   goto Exit_Row_62_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_62_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_62 /= No_Token_Index then

   Transform_Res_59 := Allocate_Attr_Stmt_Read (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_59,
      Kind => RFLX_Attr_Stmt_Read,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_59,
      Token_End_Index   => (if Row_Pos_62 = Row_Pos_59
                            then No_Token_Index
                            else Row_Pos_62 - 1));




end if;

--  End transform_code

    if Row_Pos_62 /= No_Token_Index then
        Or_Pos_23 := Row_Pos_62;
        Or_Res_23 := Transform_Res_59;
        goto Exit_Or_23;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_63 := Row_Pos_59;



--  Start tok_code

Token_Res_133 := Row_Pos_63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_133));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Write)
   then
       Token_Pos_133 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_63,
             Expected_Token_Id => RFLX_Write,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_133 := Row_Pos_63 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_133 /= No_Token_Index then

   Row_Pos_63 := Token_Pos_133;

else
   Row_Pos_63 := No_Token_Index;
   goto Exit_Row_63_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_63_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_63 /= No_Token_Index then

   Transform_Res_60 := Allocate_Attr_Stmt_Write (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_60,
      Kind => RFLX_Attr_Stmt_Write,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_59,
      Token_End_Index   => (if Row_Pos_63 = Row_Pos_59
                            then No_Token_Index
                            else Row_Pos_63 - 1));




end if;

--  End transform_code

    if Row_Pos_63 /= No_Token_Index then
        Or_Pos_23 := Row_Pos_63;
        Or_Res_23 := Transform_Res_60;
        goto Exit_Or_23;
    end if;
<<Exit_Or_23>>

--  End or_code



if Or_Pos_23 /= No_Token_Index then

   Row_Pos_59 := Or_Pos_23;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


--  Start tok_code

Token_Res_134 := Row_Pos_59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_134));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_134 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_59,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_134 := Row_Pos_59 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_134 /= No_Token_Index then

   Row_Pos_59 := Token_Pos_134;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


Defer_Res_79 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_59);
Defer_Pos_79 := Parser.Current_Pos;



if Defer_Pos_79 /= No_Token_Index then

   Row_Pos_59 := Defer_Pos_79;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;


--  Start tok_code

Token_Res_135 := Row_Pos_59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_135));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_135 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_59,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_135 := Row_Pos_59 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_135 /= No_Token_Index then

   Row_Pos_59 := Token_Pos_135;

else
   Row_Pos_59 := No_Token_Index;
   goto Exit_Row_59_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_59_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_59 /= No_Token_Index then

   Transform_Res_61 := Allocate_Attribute_Statement (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_61,
      Kind => RFLX_Attribute_Statement,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_59 = Pos
                            then No_Token_Index
                            else Row_Pos_59 - 1));

      Initialize_Fields_For_Attribute_Statement
        (Self => Transform_Res_61, Attribute_Statement_F_Identifier => Defer_Res_78, Attribute_Statement_F_Attr => Or_Res_23, Attribute_Statement_F_Expression => Defer_Res_79);

         if Defer_Res_78 /= null and then Is_Incomplete (Defer_Res_78) then
            Transform_Res_61.Last_Attempted_Child := 0;
         elsif Defer_Res_78 /= null and then not Is_Ghost (Defer_Res_78) then
            Transform_Res_61.Last_Attempted_Child := -1;
         end if;
         if Or_Res_23 /= null and then Is_Incomplete (Or_Res_23) then
            Transform_Res_61.Last_Attempted_Child := 0;
         elsif Or_Res_23 /= null and then not Is_Ghost (Or_Res_23) then
            Transform_Res_61.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_79 /= null and then Is_Incomplete (Defer_Res_79) then
            Transform_Res_61.Last_Attempted_Child := 0;
         elsif Defer_Res_79 /= null and then not Is_Ghost (Defer_Res_79) then
            Transform_Res_61.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.List_Attribute_Transform_Parse_4_Memo,
      Row_Pos_59 /= No_Token_Index,
      Transform_Res_61,
      Pos,
      Row_Pos_59);


   Parser.Current_Pos := Row_Pos_59;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_61;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end List_Attribute_Transform_Parse_4;

   


function Reset_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Reset
is
   use Bare_Reset_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_64 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_80 :
            Token_Index
               := No_Token_Index;
      Defer_Res_80 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_136 :
            Token_Index
               := No_Token_Index;
      Token_Res_136 :
            Token_Index
               := No_Token_Index;
      Token_Pos_137 :
            Token_Index
               := No_Token_Index;
      Token_Res_137 :
            Token_Index
               := No_Token_Index;
      Row_Pos_65 :
            Token_Index
               := No_Token_Index;
      Token_Pos_138 :
            Token_Index
               := No_Token_Index;
      Token_Res_138 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_6 :
            Token_Index
               := No_Token_Index;
      Tmp_List_6 :
            Free_Parse_List;
      Defer_Pos_81 :
            Token_Index
               := No_Token_Index;
      Defer_Res_81 :
            Bare_Message_Aggregate_Association
               := No_Bare_RFLX_Node;
      Token_Pos_139 :
            Token_Index
               := No_Token_Index;
      Token_Res_139 :
            Token_Index
               := No_Token_Index;
      List_Pos_6 :
            Token_Index
               := No_Token_Index;
      List_Res_6 :
            Bare_Message_Aggregate_Association_List
               := No_Bare_RFLX_Node;
      Token_Pos_140 :
            Token_Index
               := No_Token_Index;
      Token_Res_140 :
            Token_Index
               := No_Token_Index;
      Transform_Res_62 :
            Bare_Reset
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Reset_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_62 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_62;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_62;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_64 := Pos;



Defer_Res_80 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_64);
Defer_Pos_80 := Parser.Current_Pos;



if Defer_Pos_80 /= No_Token_Index then

   Row_Pos_64 := Defer_Pos_80;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_64_0;

end if;


--  Start tok_code

Token_Res_136 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_136));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Tick)
   then
       Token_Pos_136 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => RFLX_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_136 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_136 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_136;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_64_0;

end if;


--  Start tok_code

Token_Res_137 := Row_Pos_64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_137));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Reset)
   then
       Token_Pos_137 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_64,
             Expected_Token_Id => RFLX_Reset,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_137 := Row_Pos_64 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_137 /= No_Token_Index then

   Row_Pos_64 := Token_Pos_137;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_64_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_65 := Row_Pos_64;



--  Start tok_code

Token_Res_138 := Row_Pos_65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_138));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_138 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_65,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_138 := Row_Pos_65 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_138 /= No_Token_Index then

   Row_Pos_65 := Token_Pos_138;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_65_0;

end if;


--  Start list_code

    List_Pos_6 := No_Token_Index;



Lst_Cpos_6 := Row_Pos_65;
Tmp_List_6 := Get_Parse_List (Parser);

loop
   
Defer_Res_81 :=
   Message_Aggregate_Association_Transform_Parse_0 (Parser, Lst_Cpos_6);
Defer_Pos_81 := Parser.Current_Pos;


   exit when Defer_Pos_81 = No_Token_Index;

   List_Pos_6 := Defer_Pos_81;
   Lst_Cpos_6 := List_Pos_6;

   Tmp_List_6.Nodes.Append (Defer_Res_81);

      
--  Start tok_code

Token_Res_139 := Lst_Cpos_6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_139));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_139 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_6,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_139 := Lst_Cpos_6 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_139 /= No_Token_Index then
          Lst_Cpos_6 := Token_Pos_139;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_6.Nodes.Length;
begin
   List_Res_6 :=
      Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_65;
      Token_End := (if Lst_Cpos_6 = Row_Pos_65
                    then Row_Pos_65
                    else Lst_Cpos_6 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_65, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_6,
      Kind              => RFLX_Message_Aggregate_Association_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_6,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_6.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_6.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_6);

--  End list_code



if List_Pos_6 /= No_Token_Index then

   Row_Pos_65 := List_Pos_6;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_65_0;

end if;


--  Start tok_code

Token_Res_140 := Row_Pos_65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_140));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_140 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_65,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_140 := Row_Pos_65 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_140 /= No_Token_Index then

   Row_Pos_65 := Token_Pos_140;

else
   Row_Pos_65 := No_Token_Index;
   goto Exit_Row_65_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_65_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_65 = No_Token_Index then

        List_Res_6 :=
           Allocate_Message_Aggregate_Association_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_6,
            Kind              => RFLX_Message_Aggregate_Association_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_64 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_6,
            Parser => Parser,
            Count  => 0);


    Row_Pos_65 := Row_Pos_64;


end if;

--  End opt_code



if Row_Pos_65 /= No_Token_Index then

   Row_Pos_64 := Row_Pos_65;

else
   Row_Pos_64 := No_Token_Index;
   goto Exit_Row_64_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_64_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_64 /= No_Token_Index then

   Transform_Res_62 := Allocate_Reset (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_62,
      Kind => RFLX_Reset,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_64 = Pos
                            then No_Token_Index
                            else Row_Pos_64 - 1));

      Initialize_Fields_For_Reset
        (Self => Transform_Res_62, Reset_F_Identifier => Defer_Res_80, Reset_F_Associations => List_Res_6);

         if Defer_Res_80 /= null and then Is_Incomplete (Defer_Res_80) then
            Transform_Res_62.Last_Attempted_Child := 0;
         elsif Defer_Res_80 /= null and then not Is_Ghost (Defer_Res_80) then
            Transform_Res_62.Last_Attempted_Child := -1;
         end if;
         if List_Res_6 /= null and then Is_Incomplete (List_Res_6) then
            Transform_Res_62.Last_Attempted_Child := 0;
         elsif List_Res_6 /= null and then not Is_Ghost (List_Res_6) then
            Transform_Res_62.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Reset_Transform_Parse_0_Memo,
      Row_Pos_64 /= No_Token_Index,
      Transform_Res_62,
      Pos,
      Row_Pos_64);


   Parser.Current_Pos := Row_Pos_64;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_62;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Reset_Transform_Parse_0;

   


function Attribute_Statement_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement
is
   use Bare_Statement_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_76 :
            Token_Index
               := No_Token_Index;
      Defer_Res_76 :
            Bare_Attribute_Statement
               := No_Bare_RFLX_Node;
      Defer_Pos_77 :
            Token_Index
               := No_Token_Index;
      Defer_Res_77 :
            Bare_Reset
               := No_Bare_RFLX_Node;
      Or_Pos_22 :
            Token_Index
               := No_Token_Index;
      Or_Res_22 :
            Bare_Statement
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Attribute_Statement_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_22 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_22;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_22;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_22 := No_Token_Index;
Or_Res_22 := No_Bare_RFLX_Node;
    
Defer_Res_76 :=
   List_Attribute_Transform_Parse_4 (Parser, Pos);
Defer_Pos_76 := Parser.Current_Pos;

    if Defer_Pos_76 /= No_Token_Index then
        Or_Pos_22 := Defer_Pos_76;
        Or_Res_22 := Defer_Res_76;
        goto Exit_Or_22;
    end if;
    
Defer_Res_77 :=
   Reset_Transform_Parse_0 (Parser, Pos);
Defer_Pos_77 := Parser.Current_Pos;

    if Defer_Pos_77 /= No_Token_Index then
        Or_Pos_22 := Defer_Pos_77;
        Or_Res_22 := Defer_Res_77;
        goto Exit_Or_22;
    end if;
<<Exit_Or_22>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Attribute_Statement_Or_Parse_0_Memo,
      Or_Pos_22 /= No_Token_Index,
      Or_Res_22,
      Pos,
      Or_Pos_22);


   Parser.Current_Pos := Or_Pos_22;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_22;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Attribute_Statement_Or_Parse_0;

   


function Action_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Statement
is
   use Bare_Statement_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_0 :
            Token_Index
               := No_Token_Index;
      Defer_Res_0 :
            Bare_Assignment
               := No_Bare_RFLX_Node;
      Defer_Pos_1 :
            Token_Index
               := No_Token_Index;
      Defer_Res_1 :
            Bare_Message_Field_Assignment
               := No_Bare_RFLX_Node;
      Defer_Pos_2 :
            Token_Index
               := No_Token_Index;
      Defer_Res_2 :
            Bare_Statement
               := No_Bare_RFLX_Node;
      Or_Pos_0 :
            Token_Index
               := No_Token_Index;
      Or_Res_0 :
            Bare_Statement
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Action_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_0 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_0 := No_Token_Index;
Or_Res_0 := No_Bare_RFLX_Node;
    
Defer_Res_0 :=
   Assignment_Statement_Transform_Parse_0 (Parser, Pos);
Defer_Pos_0 := Parser.Current_Pos;

    if Defer_Pos_0 /= No_Token_Index then
        Or_Pos_0 := Defer_Pos_0;
        Or_Res_0 := Defer_Res_0;
        goto Exit_Or_0;
    end if;
    
Defer_Res_1 :=
   Message_Field_Assignment_Statement_Transform_Parse_0 (Parser, Pos);
Defer_Pos_1 := Parser.Current_Pos;

    if Defer_Pos_1 /= No_Token_Index then
        Or_Pos_0 := Defer_Pos_1;
        Or_Res_0 := Defer_Res_1;
        goto Exit_Or_0;
    end if;
    
Defer_Res_2 :=
   Attribute_Statement_Or_Parse_0 (Parser, Pos);
Defer_Pos_2 := Parser.Current_Pos;

    if Defer_Pos_2 /= No_Token_Index then
        Or_Pos_0 := Defer_Pos_2;
        Or_Res_0 := Defer_Res_2;
        goto Exit_Or_0;
    end if;
<<Exit_Or_0>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Action_Or_Parse_0_Memo,
      Or_Pos_0 /= No_Token_Index,
      Or_Res_0,
      Pos,
      Or_Pos_0);


   Parser.Current_Pos := Or_Pos_0;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_0;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Action_Or_Parse_0;

   


function Paren_Expression_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expression
is
   use Bare_Paren_Expression_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_88 :
            Token_Index
               := No_Token_Index;
      Token_Pos_157 :
            Token_Index
               := No_Token_Index;
      Token_Res_157 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_106 :
            Token_Index
               := No_Token_Index;
      Defer_Res_106 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_158 :
            Token_Index
               := No_Token_Index;
      Token_Res_158 :
            Token_Index
               := No_Token_Index;
      Transform_Res_84 :
            Bare_Paren_Expression
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Paren_Expression_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_84 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_84;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_84;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_88 := Pos;



--  Start tok_code

Token_Res_157 := Row_Pos_88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_157));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_157 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_88,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_157 := Row_Pos_88 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_157 /= No_Token_Index then

   Row_Pos_88 := Token_Pos_157;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_87_0;

end if;


Defer_Res_106 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_88);
Defer_Pos_106 := Parser.Current_Pos;



if Defer_Pos_106 /= No_Token_Index then

   Row_Pos_88 := Defer_Pos_106;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_87_0;

end if;


--  Start tok_code

Token_Res_158 := Row_Pos_88;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_158));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_158 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_88 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_88,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_158 := Row_Pos_88 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_158 /= No_Token_Index then

   Row_Pos_88 := Token_Pos_158;

else
   Row_Pos_88 := No_Token_Index;
   goto Exit_Row_87_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_87_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_88 /= No_Token_Index then

   Transform_Res_84 := Allocate_Paren_Expression (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_84,
      Kind => RFLX_Paren_Expression,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_88 = Pos
                            then No_Token_Index
                            else Row_Pos_88 - 1));

      Initialize_Fields_For_Paren_Expression
        (Self => Transform_Res_84, Paren_Expression_F_Data => Defer_Res_106);

         if Defer_Res_106 /= null and then Is_Incomplete (Defer_Res_106) then
            Transform_Res_84.Last_Attempted_Child := 0;
         elsif Defer_Res_106 /= null and then not Is_Ghost (Defer_Res_106) then
            Transform_Res_84.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Paren_Expression_Transform_Parse_0_Memo,
      Row_Pos_88 /= No_Token_Index,
      Transform_Res_84,
      Pos,
      Row_Pos_88);


   Parser.Current_Pos := Row_Pos_88;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_84;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Paren_Expression_Transform_Parse_0;

   


function Primary_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_101 :
            Token_Index
               := No_Token_Index;
      Defer_Res_101 :
            Bare_Sequence_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_102 :
            Token_Index
               := No_Token_Index;
      Defer_Res_102 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_103 :
            Token_Index
               := No_Token_Index;
      Defer_Res_103 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;
      Defer_Pos_104 :
            Token_Index
               := No_Token_Index;
      Defer_Res_104 :
            Bare_Variable
               := No_Bare_RFLX_Node;
      Defer_Pos_105 :
            Token_Index
               := No_Token_Index;
      Defer_Res_105 :
            Bare_Paren_Expression
               := No_Bare_RFLX_Node;
      Or_Pos_34 :
            Token_Index
               := No_Token_Index;
      Or_Res_34 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Primary_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_34 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_34;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_34;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_34 := No_Token_Index;
Or_Res_34 := No_Bare_RFLX_Node;
    
Defer_Res_101 :=
   Concatenation_Or_Parse_2 (Parser, Pos);
Defer_Pos_101 := Parser.Current_Pos;

    if Defer_Pos_101 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_101;
        Or_Res_34 := Defer_Res_101;
        goto Exit_Or_34;
    end if;
    
Defer_Res_102 :=
   Numeric_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_102 := Parser.Current_Pos;

    if Defer_Pos_102 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_102;
        Or_Res_34 := Defer_Res_102;
        goto Exit_Or_34;
    end if;
    
Defer_Res_103 :=
   String_Literal_Transform_Parse_0 (Parser, Pos);
Defer_Pos_103 := Parser.Current_Pos;

    if Defer_Pos_103 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_103;
        Or_Res_34 := Defer_Res_103;
        goto Exit_Or_34;
    end if;
    
Defer_Res_104 :=
   Variable_Transform_Parse_0 (Parser, Pos);
Defer_Pos_104 := Parser.Current_Pos;

    if Defer_Pos_104 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_104;
        Or_Res_34 := Defer_Res_104;
        goto Exit_Or_34;
    end if;
    
Defer_Res_105 :=
   Paren_Expression_Transform_Parse_0 (Parser, Pos);
Defer_Pos_105 := Parser.Current_Pos;

    if Defer_Pos_105 /= No_Token_Index then
        Or_Pos_34 := Defer_Pos_105;
        Or_Res_34 := Defer_Res_105;
        goto Exit_Or_34;
    end if;
<<Exit_Or_34>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Primary_Or_Parse_0_Memo,
      Or_Pos_34 /= No_Token_Index,
      Or_Res_34,
      Pos,
      Or_Pos_34);


   Parser.Current_Pos := Or_Pos_34;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_34;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Primary_Or_Parse_0;

   


function Suffix_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_89 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_107 :
            Token_Index
               := No_Token_Index;
      Defer_Res_107 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_159 :
            Token_Index
               := No_Token_Index;
      Token_Res_159 :
            Token_Index
               := No_Token_Index;
      Row_Pos_90 :
            Token_Index
               := No_Token_Index;
      Token_Pos_160 :
            Token_Index
               := No_Token_Index;
      Token_Res_160 :
            Token_Index
               := No_Token_Index;
      Transform_Res_85 :
            Bare_Attr_First
               := No_Bare_RFLX_Node;
      Row_Pos_91 :
            Token_Index
               := No_Token_Index;
      Token_Pos_161 :
            Token_Index
               := No_Token_Index;
      Token_Res_161 :
            Token_Index
               := No_Token_Index;
      Transform_Res_86 :
            Bare_Attr_Size
               := No_Bare_RFLX_Node;
      Row_Pos_92 :
            Token_Index
               := No_Token_Index;
      Token_Pos_162 :
            Token_Index
               := No_Token_Index;
      Token_Res_162 :
            Token_Index
               := No_Token_Index;
      Transform_Res_87 :
            Bare_Attr_Last
               := No_Bare_RFLX_Node;
      Row_Pos_93 :
            Token_Index
               := No_Token_Index;
      Token_Pos_163 :
            Token_Index
               := No_Token_Index;
      Token_Res_163 :
            Token_Index
               := No_Token_Index;
      Transform_Res_88 :
            Bare_Attr_Valid_Checksum
               := No_Bare_RFLX_Node;
      Or_Pos_35 :
            Token_Index
               := No_Token_Index;
      Or_Res_35 :
            Bare_Attr
               := No_Bare_RFLX_Node;
      Transform_Res_89 :
            Bare_Attribute
               := No_Bare_RFLX_Node;
      Defer_Pos_108 :
            Token_Index
               := No_Token_Index;
      Defer_Res_108 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_36 :
            Token_Index
               := No_Token_Index;
      Or_Res_36 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Suffix_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_36 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_36;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_36;
   end if;

       Set (Parser.Private_Part.Suffix_Or_Parse_1_Memo, False, Or_Res_36, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_36 := No_Token_Index;
Or_Res_36 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_89 := Pos;



Defer_Res_107 :=
   Suffix_Or_Parse_1 (Parser, Row_Pos_89);
Defer_Pos_107 := Parser.Current_Pos;



if Defer_Pos_107 /= No_Token_Index then

   Row_Pos_89 := Defer_Pos_107;

else
   Row_Pos_89 := No_Token_Index;
   goto Exit_Row_89_0;

end if;


--  Start tok_code

Token_Res_159 := Row_Pos_89;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_159));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Tick)
   then
       Token_Pos_159 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_89 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_89,
             Expected_Token_Id => RFLX_Tick,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_159 := Row_Pos_89 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_159 /= No_Token_Index then

   Row_Pos_89 := Token_Pos_159;

else
   Row_Pos_89 := No_Token_Index;
   goto Exit_Row_89_0;

end if;


--  Start or_code

Or_Pos_35 := No_Token_Index;
Or_Res_35 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_90 := Row_Pos_89;



--  Start tok_code

Token_Res_160 := Row_Pos_90;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_160));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_First)
   then
       Token_Pos_160 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_90 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_90,
             Expected_Token_Id => RFLX_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_160 := Row_Pos_90 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_160 /= No_Token_Index then

   Row_Pos_90 := Token_Pos_160;

else
   Row_Pos_90 := No_Token_Index;
   goto Exit_Row_90_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_90_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_90 /= No_Token_Index then

   Transform_Res_85 := Allocate_Attr_First (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_85,
      Kind => RFLX_Attr_First,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_89,
      Token_End_Index   => (if Row_Pos_90 = Row_Pos_89
                            then No_Token_Index
                            else Row_Pos_90 - 1));




end if;

--  End transform_code

    if Row_Pos_90 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_90;
        Or_Res_35 := Transform_Res_85;
        goto Exit_Or_36;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_91 := Row_Pos_89;



--  Start tok_code

Token_Res_161 := Row_Pos_91;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_161));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Size)
   then
       Token_Pos_161 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_91 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_91,
             Expected_Token_Id => RFLX_Size,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_161 := Row_Pos_91 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_161 /= No_Token_Index then

   Row_Pos_91 := Token_Pos_161;

else
   Row_Pos_91 := No_Token_Index;
   goto Exit_Row_91_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_91_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_91 /= No_Token_Index then

   Transform_Res_86 := Allocate_Attr_Size (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_86,
      Kind => RFLX_Attr_Size,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_89,
      Token_End_Index   => (if Row_Pos_91 = Row_Pos_89
                            then No_Token_Index
                            else Row_Pos_91 - 1));




end if;

--  End transform_code

    if Row_Pos_91 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_91;
        Or_Res_35 := Transform_Res_86;
        goto Exit_Or_36;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_92 := Row_Pos_89;



--  Start tok_code

Token_Res_162 := Row_Pos_92;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_162));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Last)
   then
       Token_Pos_162 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_92 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_92,
             Expected_Token_Id => RFLX_Last,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_162 := Row_Pos_92 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_162 /= No_Token_Index then

   Row_Pos_92 := Token_Pos_162;

else
   Row_Pos_92 := No_Token_Index;
   goto Exit_Row_92_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_92_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_92 /= No_Token_Index then

   Transform_Res_87 := Allocate_Attr_Last (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_87,
      Kind => RFLX_Attr_Last,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_89,
      Token_End_Index   => (if Row_Pos_92 = Row_Pos_89
                            then No_Token_Index
                            else Row_Pos_92 - 1));




end if;

--  End transform_code

    if Row_Pos_92 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_92;
        Or_Res_35 := Transform_Res_87;
        goto Exit_Or_36;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_93 := Row_Pos_89;



--  Start tok_code

Token_Res_163 := Row_Pos_93;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_163));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Valid_Checksum)
   then
       Token_Pos_163 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_93 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_93,
             Expected_Token_Id => RFLX_Valid_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_163 := Row_Pos_93 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_163 /= No_Token_Index then

   Row_Pos_93 := Token_Pos_163;

else
   Row_Pos_93 := No_Token_Index;
   goto Exit_Row_93_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_93_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_93 /= No_Token_Index then

   Transform_Res_88 := Allocate_Attr_Valid_Checksum (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_88,
      Kind => RFLX_Attr_Valid_Checksum,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_89,
      Token_End_Index   => (if Row_Pos_93 = Row_Pos_89
                            then No_Token_Index
                            else Row_Pos_93 - 1));




end if;

--  End transform_code

    if Row_Pos_93 /= No_Token_Index then
        Or_Pos_35 := Row_Pos_93;
        Or_Res_35 := Transform_Res_88;
        goto Exit_Or_36;
    end if;
<<Exit_Or_36>>

--  End or_code



if Or_Pos_35 /= No_Token_Index then

   Row_Pos_89 := Or_Pos_35;

else
   Row_Pos_89 := No_Token_Index;
   goto Exit_Row_89_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_89_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_89 /= No_Token_Index then

   Transform_Res_89 := Allocate_Attribute (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_89,
      Kind => RFLX_Attribute,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_89 = Pos
                            then No_Token_Index
                            else Row_Pos_89 - 1));

      Initialize_Fields_For_Attribute
        (Self => Transform_Res_89, Attribute_F_Expression => Defer_Res_107, Attribute_F_Kind => Or_Res_35);

         if Defer_Res_107 /= null and then Is_Incomplete (Defer_Res_107) then
            Transform_Res_89.Last_Attempted_Child := 0;
         elsif Defer_Res_107 /= null and then not Is_Ghost (Defer_Res_107) then
            Transform_Res_89.Last_Attempted_Child := -1;
         end if;
         if Or_Res_35 /= null and then Is_Incomplete (Or_Res_35) then
            Transform_Res_89.Last_Attempted_Child := 0;
         elsif Or_Res_35 /= null and then not Is_Ghost (Or_Res_35) then
            Transform_Res_89.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_89 /= No_Token_Index then
        Or_Pos_36 := Row_Pos_89;
        Or_Res_36 := Transform_Res_89;
        goto Exit_Or_35;
    end if;
    
Defer_Res_108 :=
   Primary_Or_Parse_0 (Parser, Pos);
Defer_Pos_108 := Parser.Current_Pos;

    if Defer_Pos_108 /= No_Token_Index then
        Or_Pos_36 := Defer_Pos_108;
        Or_Res_36 := Defer_Res_108;
        goto Exit_Or_35;
    end if;
<<Exit_Or_35>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_36 > Mem_Pos then
         Mem_Pos := Or_Pos_36;
         Mem_Res := Or_Res_36;
         Set
           (Parser.Private_Part.Suffix_Or_Parse_1_Memo,
            Or_Pos_36 /= No_Token_Index,
            Or_Res_36,
            Pos,
            Or_Pos_36);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_36 := Mem_Res;
         Or_Pos_36 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Suffix_Or_Parse_1_Memo,
      Or_Pos_36 /= No_Token_Index,
      Or_Res_36,
      Pos,
      Or_Pos_36);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_36;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_36;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Suffix_Or_Parse_1;

   


function Factor_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_13 :
            Boolean
               := False;
      Row_Pos_86 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_98 :
            Token_Index
               := No_Token_Index;
      Defer_Res_98 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_87 :
            Token_Index
               := No_Token_Index;
      Token_Pos_156 :
            Token_Index
               := No_Token_Index;
      Token_Res_156 :
            Token_Index
               := No_Token_Index;
      Transform_Res_82 :
            Bare_Op_Pow
               := No_Bare_RFLX_Node;
      Defer_Pos_99 :
            Token_Index
               := No_Token_Index;
      Defer_Res_99 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_13 :
            Integer
               := 0;
      Transform_Res_83 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_13 :
            Boolean
               := False;
      Defer_Pos_100 :
            Token_Index
               := No_Token_Index;
      Defer_Res_100 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_33 :
            Token_Index
               := No_Token_Index;
      Or_Res_33 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Factor_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_33 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_33;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_33;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_33 := No_Token_Index;
Or_Res_33 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_86 := Pos;



Defer_Res_98 :=
   Primary_Or_Parse_0 (Parser, Row_Pos_86);
Defer_Pos_98 := Parser.Current_Pos;


Row_Progress_13 := 1;

if Defer_Pos_98 /= No_Token_Index then

   Row_Pos_86 := Defer_Pos_98;

else
   Row_Pos_86 := No_Token_Index;
   goto Exit_Row_86_0;

end if;


--  Start transform_code


--  Start row_code

Row_Pos_87 := Row_Pos_86;



--  Start tok_code

Token_Res_156 := Row_Pos_87;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_156));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Exp)
   then
       Token_Pos_156 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_87 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_87,
             Expected_Token_Id => RFLX_Exp,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_156 := Row_Pos_87 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_156 /= No_Token_Index then

   Row_Pos_87 := Token_Pos_156;

else
   Row_Pos_87 := No_Token_Index;
   goto Exit_Row_88_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_88_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_87 /= No_Token_Index then

   Transform_Res_82 := Allocate_Op_Pow (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_82,
      Kind => RFLX_Op_Pow,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_86,
      Token_End_Index   => (if Row_Pos_87 = Row_Pos_86
                            then No_Token_Index
                            else Row_Pos_87 - 1));




end if;

--  End transform_code


Row_Progress_13 := 2;

if Row_Pos_87 /= No_Token_Index then

   Row_Pos_86 := Row_Pos_87;

else
   Row_Pos_86 := No_Token_Index;
   goto Exit_Row_86_0;

end if;

Nobt_13 := True;

Row_Progress_13 := 3;

if Row_Pos_86 /= No_Token_Index then

   Row_Pos_86 := Row_Pos_86;

else
   Row_Pos_86 := No_Token_Index;
   goto Exit_Row_86_0;

end if;


Defer_Res_99 :=
   Primary_Or_Parse_0 (Parser, Row_Pos_86);
Defer_Pos_99 := Parser.Current_Pos;


Row_Progress_13 := 4;

if Defer_Pos_99 /= No_Token_Index then

   Row_Pos_86 := Defer_Pos_99;

else
   Row_Pos_86 := No_Token_Index;
   goto Exit_Row_86_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_86_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_86 = No_Token_Index and then Nobt_13 then
   Row_Pos_86 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_13 := True;
end if;

if Row_Pos_86 /= No_Token_Index then

   Transform_Res_83 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_83,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_86 = Pos
                            then No_Token_Index
                            else Row_Pos_86 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_83, Bin_Op_F_Left => Defer_Res_98, Bin_Op_F_Op => Transform_Res_82, Bin_Op_F_Right => Defer_Res_99);

         if Defer_Res_98 /= null and then Is_Incomplete (Defer_Res_98) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Defer_Res_98 /= null and then not Is_Ghost (Defer_Res_98) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;
         if Transform_Res_82 /= null and then Is_Incomplete (Transform_Res_82) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Transform_Res_82 /= null and then not Is_Ghost (Transform_Res_82) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_99 /= null and then Is_Incomplete (Defer_Res_99) then
            Transform_Res_83.Last_Attempted_Child := 0;
         elsif Defer_Res_99 /= null and then not Is_Ghost (Defer_Res_99) then
            Transform_Res_83.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_13 then
      Transform_Res_83.Last_Attempted_Child :=
         Row_Progress_13;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <factor>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_86 /= No_Token_Index then
        Or_Pos_33 := Row_Pos_86;
        Or_Res_33 := Transform_Res_83;
        goto Exit_Or_33;
    end if;
    
Defer_Res_100 :=
   Suffix_Or_Parse_1 (Parser, Pos);
Defer_Pos_100 := Parser.Current_Pos;

    if Defer_Pos_100 /= No_Token_Index then
        Or_Pos_33 := Defer_Pos_100;
        Or_Res_33 := Defer_Res_100;
        goto Exit_Or_33;
    end if;
<<Exit_Or_33>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Factor_Or_Parse_0_Memo,
      Or_Pos_33 /= No_Token_Index,
      Or_Res_33,
      Pos,
      Or_Pos_33);


   Parser.Current_Pos := Or_Pos_33;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_33;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Factor_Or_Parse_0;

   


function Term_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_12 :
            Boolean
               := False;
      Row_Pos_82 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_95 :
            Token_Index
               := No_Token_Index;
      Defer_Res_95 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_83 :
            Token_Index
               := No_Token_Index;
      Token_Pos_153 :
            Token_Index
               := No_Token_Index;
      Token_Res_153 :
            Token_Index
               := No_Token_Index;
      Transform_Res_78 :
            Bare_Op_Mul
               := No_Bare_RFLX_Node;
      Row_Pos_84 :
            Token_Index
               := No_Token_Index;
      Token_Pos_154 :
            Token_Index
               := No_Token_Index;
      Token_Res_154 :
            Token_Index
               := No_Token_Index;
      Transform_Res_79 :
            Bare_Op_Div
               := No_Bare_RFLX_Node;
      Row_Pos_85 :
            Token_Index
               := No_Token_Index;
      Token_Pos_155 :
            Token_Index
               := No_Token_Index;
      Token_Res_155 :
            Token_Index
               := No_Token_Index;
      Transform_Res_80 :
            Bare_Op_Mod
               := No_Bare_RFLX_Node;
      Or_Pos_31 :
            Token_Index
               := No_Token_Index;
      Or_Res_31 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_96 :
            Token_Index
               := No_Token_Index;
      Defer_Res_96 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_12 :
            Integer
               := 0;
      Transform_Res_81 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_12 :
            Boolean
               := False;
      Defer_Pos_97 :
            Token_Index
               := No_Token_Index;
      Defer_Res_97 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_32 :
            Token_Index
               := No_Token_Index;
      Or_Res_32 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Term_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_32 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_32;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_32;
   end if;

       Set (Parser.Private_Part.Term_Or_Parse_1_Memo, False, Or_Res_32, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_12 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_32 := No_Token_Index;
Or_Res_32 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_82 := Pos;



Defer_Res_95 :=
   Term_Or_Parse_1 (Parser, Row_Pos_82);
Defer_Pos_95 := Parser.Current_Pos;


Row_Progress_12 := 1;

if Defer_Pos_95 /= No_Token_Index then

   Row_Pos_82 := Defer_Pos_95;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_82_0;

end if;


--  Start or_code

Or_Pos_31 := No_Token_Index;
Or_Res_31 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_83 := Row_Pos_82;



--  Start tok_code

Token_Res_153 := Row_Pos_83;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_153));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mul)
   then
       Token_Pos_153 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_83 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_83,
             Expected_Token_Id => RFLX_Mul,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_153 := Row_Pos_83 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_153 /= No_Token_Index then

   Row_Pos_83 := Token_Pos_153;

else
   Row_Pos_83 := No_Token_Index;
   goto Exit_Row_83_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_83_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_83 /= No_Token_Index then

   Transform_Res_78 := Allocate_Op_Mul (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_78,
      Kind => RFLX_Op_Mul,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_82,
      Token_End_Index   => (if Row_Pos_83 = Row_Pos_82
                            then No_Token_Index
                            else Row_Pos_83 - 1));




end if;

--  End transform_code

    if Row_Pos_83 /= No_Token_Index then
        Or_Pos_31 := Row_Pos_83;
        Or_Res_31 := Transform_Res_78;
        goto Exit_Or_32;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_84 := Row_Pos_82;



--  Start tok_code

Token_Res_154 := Row_Pos_84;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_154));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Div)
   then
       Token_Pos_154 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_84 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_84,
             Expected_Token_Id => RFLX_Div,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_154 := Row_Pos_84 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_154 /= No_Token_Index then

   Row_Pos_84 := Token_Pos_154;

else
   Row_Pos_84 := No_Token_Index;
   goto Exit_Row_84_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_84_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_84 /= No_Token_Index then

   Transform_Res_79 := Allocate_Op_Div (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_79,
      Kind => RFLX_Op_Div,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_82,
      Token_End_Index   => (if Row_Pos_84 = Row_Pos_82
                            then No_Token_Index
                            else Row_Pos_84 - 1));




end if;

--  End transform_code

    if Row_Pos_84 /= No_Token_Index then
        Or_Pos_31 := Row_Pos_84;
        Or_Res_31 := Transform_Res_79;
        goto Exit_Or_32;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_85 := Row_Pos_82;



--  Start tok_code

Token_Res_155 := Row_Pos_85;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_155));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mod)
   then
       Token_Pos_155 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_85 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_85,
             Expected_Token_Id => RFLX_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_155 := Row_Pos_85 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_155 /= No_Token_Index then

   Row_Pos_85 := Token_Pos_155;

else
   Row_Pos_85 := No_Token_Index;
   goto Exit_Row_85_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_85_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_85 /= No_Token_Index then

   Transform_Res_80 := Allocate_Op_Mod (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_80,
      Kind => RFLX_Op_Mod,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_82,
      Token_End_Index   => (if Row_Pos_85 = Row_Pos_82
                            then No_Token_Index
                            else Row_Pos_85 - 1));




end if;

--  End transform_code

    if Row_Pos_85 /= No_Token_Index then
        Or_Pos_31 := Row_Pos_85;
        Or_Res_31 := Transform_Res_80;
        goto Exit_Or_32;
    end if;
<<Exit_Or_32>>

--  End or_code


Row_Progress_12 := 2;

if Or_Pos_31 /= No_Token_Index then

   Row_Pos_82 := Or_Pos_31;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_82_0;

end if;

Nobt_12 := True;

Row_Progress_12 := 3;

if Row_Pos_82 /= No_Token_Index then

   Row_Pos_82 := Row_Pos_82;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_82_0;

end if;


Defer_Res_96 :=
   Factor_Or_Parse_0 (Parser, Row_Pos_82);
Defer_Pos_96 := Parser.Current_Pos;


Row_Progress_12 := 4;

if Defer_Pos_96 /= No_Token_Index then

   Row_Pos_82 := Defer_Pos_96;

else
   Row_Pos_82 := No_Token_Index;
   goto Exit_Row_82_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_82_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_82 = No_Token_Index and then Nobt_12 then
   Row_Pos_82 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_12 := True;
end if;

if Row_Pos_82 /= No_Token_Index then

   Transform_Res_81 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_81,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_82 = Pos
                            then No_Token_Index
                            else Row_Pos_82 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_81, Bin_Op_F_Left => Defer_Res_95, Bin_Op_F_Op => Or_Res_31, Bin_Op_F_Right => Defer_Res_96);

         if Defer_Res_95 /= null and then Is_Incomplete (Defer_Res_95) then
            Transform_Res_81.Last_Attempted_Child := 0;
         elsif Defer_Res_95 /= null and then not Is_Ghost (Defer_Res_95) then
            Transform_Res_81.Last_Attempted_Child := -1;
         end if;
         if Or_Res_31 /= null and then Is_Incomplete (Or_Res_31) then
            Transform_Res_81.Last_Attempted_Child := 0;
         elsif Or_Res_31 /= null and then not Is_Ghost (Or_Res_31) then
            Transform_Res_81.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_96 /= null and then Is_Incomplete (Defer_Res_96) then
            Transform_Res_81.Last_Attempted_Child := 0;
         elsif Defer_Res_96 /= null and then not Is_Ghost (Defer_Res_96) then
            Transform_Res_81.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_12 then
      Transform_Res_81.Last_Attempted_Child :=
         Row_Progress_12;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_82 /= No_Token_Index then
        Or_Pos_32 := Row_Pos_82;
        Or_Res_32 := Transform_Res_81;
        goto Exit_Or_31;
    end if;
    
Defer_Res_97 :=
   Factor_Or_Parse_0 (Parser, Pos);
Defer_Pos_97 := Parser.Current_Pos;

    if Defer_Pos_97 /= No_Token_Index then
        Or_Pos_32 := Defer_Pos_97;
        Or_Res_32 := Defer_Res_97;
        goto Exit_Or_31;
    end if;
<<Exit_Or_31>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_32 > Mem_Pos then
         Mem_Pos := Or_Pos_32;
         Mem_Res := Or_Res_32;
         Set
           (Parser.Private_Part.Term_Or_Parse_1_Memo,
            Or_Pos_32 /= No_Token_Index,
            Or_Res_32,
            Pos,
            Or_Pos_32);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_32 := Mem_Res;
         Or_Pos_32 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Term_Or_Parse_1_Memo,
      Or_Pos_32 /= No_Token_Index,
      Or_Res_32,
      Pos,
      Or_Pos_32);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_32;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_32;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Term_Or_Parse_1;

   


function Unop_Term_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_11 :
            Boolean
               := False;
      Row_Pos_81 :
            Token_Index
               := No_Token_Index;
      Token_Pos_152 :
            Token_Index
               := No_Token_Index;
      Token_Res_152 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_93 :
            Token_Index
               := No_Token_Index;
      Defer_Res_93 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_11 :
            Integer
               := 0;
      Transform_Res_77 :
            Bare_Negation
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_11 :
            Boolean
               := False;
      Defer_Pos_94 :
            Token_Index
               := No_Token_Index;
      Defer_Res_94 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_30 :
            Token_Index
               := No_Token_Index;
      Or_Res_30 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Unop_Term_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_30 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_30;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_30;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_30 := No_Token_Index;
Or_Res_30 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_81 := Pos;



--  Start tok_code

Token_Res_152 := Row_Pos_81;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_152));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sub)
   then
       Token_Pos_152 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_81 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_81,
             Expected_Token_Id => RFLX_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_152 := Row_Pos_81 + 1;
   end if;
end;

--  End tok_code


Row_Progress_11 := 1;

if Token_Pos_152 /= No_Token_Index then

   Row_Pos_81 := Token_Pos_152;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_81_0;

end if;

Nobt_11 := True;

Row_Progress_11 := 2;

if Row_Pos_81 /= No_Token_Index then

   Row_Pos_81 := Row_Pos_81;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_81_0;

end if;


Defer_Res_93 :=
   Term_Or_Parse_1 (Parser, Row_Pos_81);
Defer_Pos_93 := Parser.Current_Pos;


Row_Progress_11 := 3;

if Defer_Pos_93 /= No_Token_Index then

   Row_Pos_81 := Defer_Pos_93;

else
   Row_Pos_81 := No_Token_Index;
   goto Exit_Row_81_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_81_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_81 = No_Token_Index and then Nobt_11 then
   Row_Pos_81 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_11 := True;
end if;

if Row_Pos_81 /= No_Token_Index then

   Transform_Res_77 := Allocate_Negation (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_77,
      Kind => RFLX_Negation,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_81 = Pos
                            then No_Token_Index
                            else Row_Pos_81 - 1));

      Initialize_Fields_For_Negation
        (Self => Transform_Res_77, Negation_F_Data => Defer_Res_93);

         if Defer_Res_93 /= null and then Is_Incomplete (Defer_Res_93) then
            Transform_Res_77.Last_Attempted_Child := 0;
         elsif Defer_Res_93 /= null and then not Is_Ghost (Defer_Res_93) then
            Transform_Res_77.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_11 then
      Transform_Res_77.Last_Attempted_Child :=
         Row_Progress_11;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <unop_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_81 /= No_Token_Index then
        Or_Pos_30 := Row_Pos_81;
        Or_Res_30 := Transform_Res_77;
        goto Exit_Or_30;
    end if;
    
Defer_Res_94 :=
   Term_Or_Parse_1 (Parser, Pos);
Defer_Pos_94 := Parser.Current_Pos;

    if Defer_Pos_94 /= No_Token_Index then
        Or_Pos_30 := Defer_Pos_94;
        Or_Res_30 := Defer_Res_94;
        goto Exit_Or_30;
    end if;
<<Exit_Or_30>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Unop_Term_Or_Parse_0_Memo,
      Or_Pos_30 /= No_Token_Index,
      Or_Res_30,
      Pos,
      Or_Pos_30);


   Parser.Current_Pos := Or_Pos_30;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_30;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Unop_Term_Or_Parse_0;

   


function Simple_Expr_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_10 :
            Boolean
               := False;
      Row_Pos_78 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_90 :
            Token_Index
               := No_Token_Index;
      Defer_Res_90 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_79 :
            Token_Index
               := No_Token_Index;
      Token_Pos_150 :
            Token_Index
               := No_Token_Index;
      Token_Res_150 :
            Token_Index
               := No_Token_Index;
      Transform_Res_74 :
            Bare_Op_Add
               := No_Bare_RFLX_Node;
      Row_Pos_80 :
            Token_Index
               := No_Token_Index;
      Token_Pos_151 :
            Token_Index
               := No_Token_Index;
      Token_Res_151 :
            Token_Index
               := No_Token_Index;
      Transform_Res_75 :
            Bare_Op_Sub
               := No_Bare_RFLX_Node;
      Or_Pos_28 :
            Token_Index
               := No_Token_Index;
      Or_Res_28 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_91 :
            Token_Index
               := No_Token_Index;
      Defer_Res_91 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_10 :
            Integer
               := 0;
      Transform_Res_76 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_10 :
            Boolean
               := False;
      Defer_Pos_92 :
            Token_Index
               := No_Token_Index;
      Defer_Res_92 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_29 :
            Token_Index
               := No_Token_Index;
      Or_Res_29 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Simple_Expr_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_29 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_29;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_29;
   end if;

       Set (Parser.Private_Part.Simple_Expr_Or_Parse_1_Memo, False, Or_Res_29, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_10 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_29 := No_Token_Index;
Or_Res_29 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_78 := Pos;



Defer_Res_90 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_78);
Defer_Pos_90 := Parser.Current_Pos;


Row_Progress_10 := 1;

if Defer_Pos_90 /= No_Token_Index then

   Row_Pos_78 := Defer_Pos_90;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_78_0;

end if;


--  Start or_code

Or_Pos_28 := No_Token_Index;
Or_Res_28 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_79 := Row_Pos_78;



--  Start tok_code

Token_Res_150 := Row_Pos_79;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_150));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Add)
   then
       Token_Pos_150 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_79 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_79,
             Expected_Token_Id => RFLX_Add,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_150 := Row_Pos_79 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_150 /= No_Token_Index then

   Row_Pos_79 := Token_Pos_150;

else
   Row_Pos_79 := No_Token_Index;
   goto Exit_Row_79_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_79_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_79 /= No_Token_Index then

   Transform_Res_74 := Allocate_Op_Add (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_74,
      Kind => RFLX_Op_Add,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_78,
      Token_End_Index   => (if Row_Pos_79 = Row_Pos_78
                            then No_Token_Index
                            else Row_Pos_79 - 1));




end if;

--  End transform_code

    if Row_Pos_79 /= No_Token_Index then
        Or_Pos_28 := Row_Pos_79;
        Or_Res_28 := Transform_Res_74;
        goto Exit_Or_29;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_80 := Row_Pos_78;



--  Start tok_code

Token_Res_151 := Row_Pos_80;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_151));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sub)
   then
       Token_Pos_151 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_80 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_80,
             Expected_Token_Id => RFLX_Sub,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_151 := Row_Pos_80 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_151 /= No_Token_Index then

   Row_Pos_80 := Token_Pos_151;

else
   Row_Pos_80 := No_Token_Index;
   goto Exit_Row_80_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_80_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_80 /= No_Token_Index then

   Transform_Res_75 := Allocate_Op_Sub (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_75,
      Kind => RFLX_Op_Sub,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_78,
      Token_End_Index   => (if Row_Pos_80 = Row_Pos_78
                            then No_Token_Index
                            else Row_Pos_80 - 1));




end if;

--  End transform_code

    if Row_Pos_80 /= No_Token_Index then
        Or_Pos_28 := Row_Pos_80;
        Or_Res_28 := Transform_Res_75;
        goto Exit_Or_29;
    end if;
<<Exit_Or_29>>

--  End or_code


Row_Progress_10 := 2;

if Or_Pos_28 /= No_Token_Index then

   Row_Pos_78 := Or_Pos_28;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_78_0;

end if;

Nobt_10 := True;

Row_Progress_10 := 3;

if Row_Pos_78 /= No_Token_Index then

   Row_Pos_78 := Row_Pos_78;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_78_0;

end if;


Defer_Res_91 :=
   Unop_Term_Or_Parse_0 (Parser, Row_Pos_78);
Defer_Pos_91 := Parser.Current_Pos;


Row_Progress_10 := 4;

if Defer_Pos_91 /= No_Token_Index then

   Row_Pos_78 := Defer_Pos_91;

else
   Row_Pos_78 := No_Token_Index;
   goto Exit_Row_78_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_78_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_78 = No_Token_Index and then Nobt_10 then
   Row_Pos_78 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_10 := True;
end if;

if Row_Pos_78 /= No_Token_Index then

   Transform_Res_76 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_76,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_78 = Pos
                            then No_Token_Index
                            else Row_Pos_78 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_76, Bin_Op_F_Left => Defer_Res_90, Bin_Op_F_Op => Or_Res_28, Bin_Op_F_Right => Defer_Res_91);

         if Defer_Res_90 /= null and then Is_Incomplete (Defer_Res_90) then
            Transform_Res_76.Last_Attempted_Child := 0;
         elsif Defer_Res_90 /= null and then not Is_Ghost (Defer_Res_90) then
            Transform_Res_76.Last_Attempted_Child := -1;
         end if;
         if Or_Res_28 /= null and then Is_Incomplete (Or_Res_28) then
            Transform_Res_76.Last_Attempted_Child := 0;
         elsif Or_Res_28 /= null and then not Is_Ghost (Or_Res_28) then
            Transform_Res_76.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_91 /= null and then Is_Incomplete (Defer_Res_91) then
            Transform_Res_76.Last_Attempted_Child := 0;
         elsif Defer_Res_91 /= null and then not Is_Ghost (Defer_Res_91) then
            Transform_Res_76.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_10 then
      Transform_Res_76.Last_Attempted_Child :=
         Row_Progress_10;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <simple_expr>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_78 /= No_Token_Index then
        Or_Pos_29 := Row_Pos_78;
        Or_Res_29 := Transform_Res_76;
        goto Exit_Or_28;
    end if;
    
Defer_Res_92 :=
   Unop_Term_Or_Parse_0 (Parser, Pos);
Defer_Pos_92 := Parser.Current_Pos;

    if Defer_Pos_92 /= No_Token_Index then
        Or_Pos_29 := Defer_Pos_92;
        Or_Res_29 := Defer_Res_92;
        goto Exit_Or_28;
    end if;
<<Exit_Or_28>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_29 > Mem_Pos then
         Mem_Pos := Or_Pos_29;
         Mem_Res := Or_Res_29;
         Set
           (Parser.Private_Part.Simple_Expr_Or_Parse_1_Memo,
            Or_Pos_29 /= No_Token_Index,
            Or_Res_29,
            Pos,
            Or_Pos_29);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_29 := Mem_Res;
         Or_Pos_29 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Simple_Expr_Or_Parse_1_Memo,
      Or_Pos_29 /= No_Token_Index,
      Or_Res_29,
      Pos,
      Or_Pos_29);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_29;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_29;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Simple_Expr_Or_Parse_1;

   


function Relation_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_9 :
            Boolean
               := False;
      Row_Pos_71 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_87 :
            Token_Index
               := No_Token_Index;
      Defer_Res_87 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_72 :
            Token_Index
               := No_Token_Index;
      Token_Pos_144 :
            Token_Index
               := No_Token_Index;
      Token_Res_144 :
            Token_Index
               := No_Token_Index;
      Transform_Res_67 :
            Bare_Op_Eq
               := No_Bare_RFLX_Node;
      Row_Pos_73 :
            Token_Index
               := No_Token_Index;
      Token_Pos_145 :
            Token_Index
               := No_Token_Index;
      Token_Res_145 :
            Token_Index
               := No_Token_Index;
      Transform_Res_68 :
            Bare_Op_Neq
               := No_Bare_RFLX_Node;
      Row_Pos_74 :
            Token_Index
               := No_Token_Index;
      Token_Pos_146 :
            Token_Index
               := No_Token_Index;
      Token_Res_146 :
            Token_Index
               := No_Token_Index;
      Transform_Res_69 :
            Bare_Op_Le
               := No_Bare_RFLX_Node;
      Row_Pos_75 :
            Token_Index
               := No_Token_Index;
      Token_Pos_147 :
            Token_Index
               := No_Token_Index;
      Token_Res_147 :
            Token_Index
               := No_Token_Index;
      Transform_Res_70 :
            Bare_Op_Lt
               := No_Bare_RFLX_Node;
      Row_Pos_76 :
            Token_Index
               := No_Token_Index;
      Token_Pos_148 :
            Token_Index
               := No_Token_Index;
      Token_Res_148 :
            Token_Index
               := No_Token_Index;
      Transform_Res_71 :
            Bare_Op_Ge
               := No_Bare_RFLX_Node;
      Row_Pos_77 :
            Token_Index
               := No_Token_Index;
      Token_Pos_149 :
            Token_Index
               := No_Token_Index;
      Token_Res_149 :
            Token_Index
               := No_Token_Index;
      Transform_Res_72 :
            Bare_Op_Gt
               := No_Bare_RFLX_Node;
      Or_Pos_26 :
            Token_Index
               := No_Token_Index;
      Or_Res_26 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_88 :
            Token_Index
               := No_Token_Index;
      Defer_Res_88 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_9 :
            Integer
               := 0;
      Transform_Res_73 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_9 :
            Boolean
               := False;
      Defer_Pos_89 :
            Token_Index
               := No_Token_Index;
      Defer_Res_89 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_27 :
            Token_Index
               := No_Token_Index;
      Or_Res_27 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Relation_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_27 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_27;
   end if;

       Set (Parser.Private_Part.Relation_Or_Parse_1_Memo, False, Or_Res_27, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_9 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_27 := No_Token_Index;
Or_Res_27 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_71 := Pos;



Defer_Res_87 :=
   Relation_Or_Parse_1 (Parser, Row_Pos_71);
Defer_Pos_87 := Parser.Current_Pos;


Row_Progress_9 := 1;

if Defer_Pos_87 /= No_Token_Index then

   Row_Pos_71 := Defer_Pos_87;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_71_0;

end if;


--  Start or_code

Or_Pos_26 := No_Token_Index;
Or_Res_26 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_72 := Row_Pos_71;



--  Start tok_code

Token_Res_144 := Row_Pos_72;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_144));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Eq)
   then
       Token_Pos_144 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_72 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_72,
             Expected_Token_Id => RFLX_Eq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_144 := Row_Pos_72 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_144 /= No_Token_Index then

   Row_Pos_72 := Token_Pos_144;

else
   Row_Pos_72 := No_Token_Index;
   goto Exit_Row_72_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_72_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_72 /= No_Token_Index then

   Transform_Res_67 := Allocate_Op_Eq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_67,
      Kind => RFLX_Op_Eq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_72 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_72 - 1));




end if;

--  End transform_code

    if Row_Pos_72 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_72;
        Or_Res_26 := Transform_Res_67;
        goto Exit_Or_27;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_73 := Row_Pos_71;



--  Start tok_code

Token_Res_145 := Row_Pos_73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_145));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Neq)
   then
       Token_Pos_145 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_73,
             Expected_Token_Id => RFLX_Neq,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_145 := Row_Pos_73 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_145 /= No_Token_Index then

   Row_Pos_73 := Token_Pos_145;

else
   Row_Pos_73 := No_Token_Index;
   goto Exit_Row_73_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_73_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_73 /= No_Token_Index then

   Transform_Res_68 := Allocate_Op_Neq (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_68,
      Kind => RFLX_Op_Neq,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_73 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_73 - 1));




end if;

--  End transform_code

    if Row_Pos_73 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_73;
        Or_Res_26 := Transform_Res_68;
        goto Exit_Or_27;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_74 := Row_Pos_71;



--  Start tok_code

Token_Res_146 := Row_Pos_74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_146));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Le)
   then
       Token_Pos_146 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_74,
             Expected_Token_Id => RFLX_Le,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_146 := Row_Pos_74 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_146 /= No_Token_Index then

   Row_Pos_74 := Token_Pos_146;

else
   Row_Pos_74 := No_Token_Index;
   goto Exit_Row_74_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_74_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_74 /= No_Token_Index then

   Transform_Res_69 := Allocate_Op_Le (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_69,
      Kind => RFLX_Op_Le,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_74 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_74 - 1));




end if;

--  End transform_code

    if Row_Pos_74 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_74;
        Or_Res_26 := Transform_Res_69;
        goto Exit_Or_27;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_75 := Row_Pos_71;



--  Start tok_code

Token_Res_147 := Row_Pos_75;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_147));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Lt)
   then
       Token_Pos_147 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_75 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_75,
             Expected_Token_Id => RFLX_Lt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_147 := Row_Pos_75 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_147 /= No_Token_Index then

   Row_Pos_75 := Token_Pos_147;

else
   Row_Pos_75 := No_Token_Index;
   goto Exit_Row_75_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_75_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_75 /= No_Token_Index then

   Transform_Res_70 := Allocate_Op_Lt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_70,
      Kind => RFLX_Op_Lt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_75 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_75 - 1));




end if;

--  End transform_code

    if Row_Pos_75 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_75;
        Or_Res_26 := Transform_Res_70;
        goto Exit_Or_27;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_76 := Row_Pos_71;



--  Start tok_code

Token_Res_148 := Row_Pos_76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_148));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Ge)
   then
       Token_Pos_148 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_76,
             Expected_Token_Id => RFLX_Ge,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_148 := Row_Pos_76 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_148 /= No_Token_Index then

   Row_Pos_76 := Token_Pos_148;

else
   Row_Pos_76 := No_Token_Index;
   goto Exit_Row_76_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_76_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_76 /= No_Token_Index then

   Transform_Res_71 := Allocate_Op_Ge (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_71,
      Kind => RFLX_Op_Ge,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_76 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_76 - 1));




end if;

--  End transform_code

    if Row_Pos_76 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_76;
        Or_Res_26 := Transform_Res_71;
        goto Exit_Or_27;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_77 := Row_Pos_71;



--  Start tok_code

Token_Res_149 := Row_Pos_77;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_149));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Gt)
   then
       Token_Pos_149 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_77 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_77,
             Expected_Token_Id => RFLX_Gt,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_149 := Row_Pos_77 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_149 /= No_Token_Index then

   Row_Pos_77 := Token_Pos_149;

else
   Row_Pos_77 := No_Token_Index;
   goto Exit_Row_77_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_77_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_77 /= No_Token_Index then

   Transform_Res_72 := Allocate_Op_Gt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_72,
      Kind => RFLX_Op_Gt,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_71,
      Token_End_Index   => (if Row_Pos_77 = Row_Pos_71
                            then No_Token_Index
                            else Row_Pos_77 - 1));




end if;

--  End transform_code

    if Row_Pos_77 /= No_Token_Index then
        Or_Pos_26 := Row_Pos_77;
        Or_Res_26 := Transform_Res_72;
        goto Exit_Or_27;
    end if;
<<Exit_Or_27>>

--  End or_code


Row_Progress_9 := 2;

if Or_Pos_26 /= No_Token_Index then

   Row_Pos_71 := Or_Pos_26;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_71_0;

end if;

Nobt_9 := True;

Row_Progress_9 := 3;

if Row_Pos_71 /= No_Token_Index then

   Row_Pos_71 := Row_Pos_71;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_71_0;

end if;


Defer_Res_88 :=
   Simple_Expr_Or_Parse_1 (Parser, Row_Pos_71);
Defer_Pos_88 := Parser.Current_Pos;


Row_Progress_9 := 4;

if Defer_Pos_88 /= No_Token_Index then

   Row_Pos_71 := Defer_Pos_88;

else
   Row_Pos_71 := No_Token_Index;
   goto Exit_Row_71_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_71_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_71 = No_Token_Index and then Nobt_9 then
   Row_Pos_71 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_9 := True;
end if;

if Row_Pos_71 /= No_Token_Index then

   Transform_Res_73 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_73,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_71 = Pos
                            then No_Token_Index
                            else Row_Pos_71 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_73, Bin_Op_F_Left => Defer_Res_87, Bin_Op_F_Op => Or_Res_26, Bin_Op_F_Right => Defer_Res_88);

         if Defer_Res_87 /= null and then Is_Incomplete (Defer_Res_87) then
            Transform_Res_73.Last_Attempted_Child := 0;
         elsif Defer_Res_87 /= null and then not Is_Ghost (Defer_Res_87) then
            Transform_Res_73.Last_Attempted_Child := -1;
         end if;
         if Or_Res_26 /= null and then Is_Incomplete (Or_Res_26) then
            Transform_Res_73.Last_Attempted_Child := 0;
         elsif Or_Res_26 /= null and then not Is_Ghost (Or_Res_26) then
            Transform_Res_73.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_88 /= null and then Is_Incomplete (Defer_Res_88) then
            Transform_Res_73.Last_Attempted_Child := 0;
         elsif Defer_Res_88 /= null and then not Is_Ghost (Defer_Res_88) then
            Transform_Res_73.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_9 then
      Transform_Res_73.Last_Attempted_Child :=
         Row_Progress_9;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <relation>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_71 /= No_Token_Index then
        Or_Pos_27 := Row_Pos_71;
        Or_Res_27 := Transform_Res_73;
        goto Exit_Or_26;
    end if;
    
Defer_Res_89 :=
   Simple_Expr_Or_Parse_1 (Parser, Pos);
Defer_Pos_89 := Parser.Current_Pos;

    if Defer_Pos_89 /= No_Token_Index then
        Or_Pos_27 := Defer_Pos_89;
        Or_Res_27 := Defer_Res_89;
        goto Exit_Or_26;
    end if;
<<Exit_Or_26>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_27 > Mem_Pos then
         Mem_Pos := Or_Pos_27;
         Mem_Res := Or_Res_27;
         Set
           (Parser.Private_Part.Relation_Or_Parse_1_Memo,
            Or_Pos_27 /= No_Token_Index,
            Or_Res_27,
            Pos,
            Or_Pos_27);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_27 := Mem_Res;
         Or_Pos_27 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Relation_Or_Parse_1_Memo,
      Or_Pos_27 /= No_Token_Index,
      Or_Res_27,
      Pos,
      Or_Pos_27);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_27;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_27;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Relation_Or_Parse_1;

   


function Expression_Or_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Nobt_8 :
            Boolean
               := False;
      Row_Pos_68 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_84 :
            Token_Index
               := No_Token_Index;
      Defer_Res_84 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Pos_69 :
            Token_Index
               := No_Token_Index;
      Token_Pos_142 :
            Token_Index
               := No_Token_Index;
      Token_Res_142 :
            Token_Index
               := No_Token_Index;
      Transform_Res_64 :
            Bare_Op_And
               := No_Bare_RFLX_Node;
      Row_Pos_70 :
            Token_Index
               := No_Token_Index;
      Token_Pos_143 :
            Token_Index
               := No_Token_Index;
      Token_Res_143 :
            Token_Index
               := No_Token_Index;
      Transform_Res_65 :
            Bare_Op_Or
               := No_Bare_RFLX_Node;
      Or_Pos_24 :
            Token_Index
               := No_Token_Index;
      Or_Res_24 :
            Bare_Op
               := No_Bare_RFLX_Node;
      Defer_Pos_85 :
            Token_Index
               := No_Token_Index;
      Defer_Res_85 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Row_Progress_8 :
            Integer
               := 0;
      Transform_Res_66 :
            Bare_Bin_Op
               := No_Bare_RFLX_Node;
      Transform_Has_Failed_8 :
            Boolean
               := False;
      Defer_Pos_86 :
            Token_Index
               := No_Token_Index;
      Defer_Res_86 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Or_Pos_25 :
            Token_Index
               := No_Token_Index;
      Or_Res_25 :
            Bare_Expr
               := No_Bare_RFLX_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_RFLX_Node;

   M : Memo_Entry := Get (Parser.Private_Part.Expression_Or_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_25 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_25;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_25;
   end if;

       Set (Parser.Private_Part.Expression_Or_Parse_1_Memo, False, Or_Res_25, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt_8 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_25 := No_Token_Index;
Or_Res_25 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_68 := Pos;



Defer_Res_84 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_68);
Defer_Pos_84 := Parser.Current_Pos;


Row_Progress_8 := 1;

if Defer_Pos_84 /= No_Token_Index then

   Row_Pos_68 := Defer_Pos_84;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_68_0;

end if;


--  Start or_code

Or_Pos_24 := No_Token_Index;
Or_Res_24 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_69 := Row_Pos_68;



--  Start tok_code

Token_Res_142 := Row_Pos_69;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_142));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_And)
   then
       Token_Pos_142 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_69 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_69,
             Expected_Token_Id => RFLX_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_142 := Row_Pos_69 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_142 /= No_Token_Index then

   Row_Pos_69 := Token_Pos_142;

else
   Row_Pos_69 := No_Token_Index;
   goto Exit_Row_69_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_69_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_69 /= No_Token_Index then

   Transform_Res_64 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_64,
      Kind => RFLX_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_68,
      Token_End_Index   => (if Row_Pos_69 = Row_Pos_68
                            then No_Token_Index
                            else Row_Pos_69 - 1));




end if;

--  End transform_code

    if Row_Pos_69 /= No_Token_Index then
        Or_Pos_24 := Row_Pos_69;
        Or_Res_24 := Transform_Res_64;
        goto Exit_Or_25;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_70 := Row_Pos_68;



--  Start tok_code

Token_Res_143 := Row_Pos_70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_143));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Or)
   then
       Token_Pos_143 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_70,
             Expected_Token_Id => RFLX_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_143 := Row_Pos_70 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_143 /= No_Token_Index then

   Row_Pos_70 := Token_Pos_143;

else
   Row_Pos_70 := No_Token_Index;
   goto Exit_Row_70_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_70_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_70 /= No_Token_Index then

   Transform_Res_65 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_65,
      Kind => RFLX_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_68,
      Token_End_Index   => (if Row_Pos_70 = Row_Pos_68
                            then No_Token_Index
                            else Row_Pos_70 - 1));




end if;

--  End transform_code

    if Row_Pos_70 /= No_Token_Index then
        Or_Pos_24 := Row_Pos_70;
        Or_Res_24 := Transform_Res_65;
        goto Exit_Or_25;
    end if;
<<Exit_Or_25>>

--  End or_code


Row_Progress_8 := 2;

if Or_Pos_24 /= No_Token_Index then

   Row_Pos_68 := Or_Pos_24;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_68_0;

end if;

Nobt_8 := True;

Row_Progress_8 := 3;

if Row_Pos_68 /= No_Token_Index then

   Row_Pos_68 := Row_Pos_68;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_68_0;

end if;


Defer_Res_85 :=
   Relation_Or_Parse_1 (Parser, Row_Pos_68);
Defer_Pos_85 := Parser.Current_Pos;


Row_Progress_8 := 4;

if Defer_Pos_85 /= No_Token_Index then

   Row_Pos_68 := Defer_Pos_85;

else
   Row_Pos_68 := No_Token_Index;
   goto Exit_Row_68_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_68_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_68 = No_Token_Index and then Nobt_8 then
   Row_Pos_68 := Parser.Last_Fail.Pos;
   Transform_Has_Failed_8 := True;
end if;

if Row_Pos_68 /= No_Token_Index then

   Transform_Res_66 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_66,
      Kind => RFLX_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_68 = Pos
                            then No_Token_Index
                            else Row_Pos_68 - 1));

      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res_66, Bin_Op_F_Left => Defer_Res_84, Bin_Op_F_Op => Or_Res_24, Bin_Op_F_Right => Defer_Res_85);

         if Defer_Res_84 /= null and then Is_Incomplete (Defer_Res_84) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Defer_Res_84 /= null and then not Is_Ghost (Defer_Res_84) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;
         if Or_Res_24 /= null and then Is_Incomplete (Or_Res_24) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Or_Res_24 /= null and then not Is_Ghost (Or_Res_24) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_85 /= null and then Is_Incomplete (Defer_Res_85) then
            Transform_Res_66.Last_Attempted_Child := 0;
         elsif Defer_Res_85 /= null and then not Is_Ghost (Defer_Res_85) then
            Transform_Res_66.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed_8 then
      Transform_Res_66.Last_Attempted_Child :=
         Row_Progress_8;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <expression>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

end if;

--  End transform_code

    if Row_Pos_68 /= No_Token_Index then
        Or_Pos_25 := Row_Pos_68;
        Or_Res_25 := Transform_Res_66;
        goto Exit_Or_24;
    end if;
    
Defer_Res_86 :=
   Relation_Or_Parse_1 (Parser, Pos);
Defer_Pos_86 := Parser.Current_Pos;

    if Defer_Pos_86 /= No_Token_Index then
        Or_Pos_25 := Defer_Pos_86;
        Or_Res_25 := Defer_Res_86;
        goto Exit_Or_24;
    end if;
<<Exit_Or_24>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos_25 > Mem_Pos then
         Mem_Pos := Or_Pos_25;
         Mem_Res := Or_Res_25;
         Set
           (Parser.Private_Part.Expression_Or_Parse_1_Memo,
            Or_Pos_25 /= No_Token_Index,
            Or_Res_25,
            Pos,
            Or_Pos_25);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res_25 := Mem_Res;
         Or_Pos_25 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (Parser.Private_Part.Expression_Or_Parse_1_Memo,
      Or_Pos_25 /= No_Token_Index,
      Or_Res_25,
      Pos,
      Or_Pos_25);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos_25;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_25;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Expression_Or_Parse_1;

   


function Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect
is
   use Bare_Aspect_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_66 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_82 :
            Token_Index
               := No_Token_Index;
      Defer_Res_82 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Row_Pos_67 :
            Token_Index
               := No_Token_Index;
      Token_Pos_141 :
            Token_Index
               := No_Token_Index;
      Token_Res_141 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_83 :
            Token_Index
               := No_Token_Index;
      Defer_Res_83 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_63 :
            Bare_Aspect
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Aspect_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_63 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_63;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_63;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_66 := Pos;



Defer_Res_82 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_66);
Defer_Pos_82 := Parser.Current_Pos;



if Defer_Pos_82 /= No_Token_Index then

   Row_Pos_66 := Defer_Pos_82;

else
   Row_Pos_66 := No_Token_Index;
   goto Exit_Row_66_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_67 := Row_Pos_66;



--  Start tok_code

Token_Res_141 := Row_Pos_67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_141));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_141 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_67,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_141 := Row_Pos_67 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_141 /= No_Token_Index then

   Row_Pos_67 := Token_Pos_141;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_67_0;

end if;


Defer_Res_83 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_67);
Defer_Pos_83 := Parser.Current_Pos;



if Defer_Pos_83 /= No_Token_Index then

   Row_Pos_67 := Defer_Pos_83;

else
   Row_Pos_67 := No_Token_Index;
   goto Exit_Row_67_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_67_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_67 = No_Token_Index then

        Defer_Res_83 := No_Bare_RFLX_Node;


    Row_Pos_67 := Row_Pos_66;


end if;

--  End opt_code



if Row_Pos_67 /= No_Token_Index then

   Row_Pos_66 := Row_Pos_67;

else
   Row_Pos_66 := No_Token_Index;
   goto Exit_Row_66_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_66_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_66 /= No_Token_Index then

   Transform_Res_63 := Allocate_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_63,
      Kind => RFLX_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_66 = Pos
                            then No_Token_Index
                            else Row_Pos_66 - 1));

      Initialize_Fields_For_Aspect
        (Self => Transform_Res_63, Aspect_F_Identifier => Defer_Res_82, Aspect_F_Value => Defer_Res_83);

         if Defer_Res_82 /= null and then Is_Incomplete (Defer_Res_82) then
            Transform_Res_63.Last_Attempted_Child := 0;
         elsif Defer_Res_82 /= null and then not Is_Ghost (Defer_Res_82) then
            Transform_Res_63.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_83 /= null and then Is_Incomplete (Defer_Res_83) then
            Transform_Res_63.Last_Attempted_Child := 0;
         elsif Defer_Res_83 /= null and then not Is_Ghost (Defer_Res_83) then
            Transform_Res_63.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Aspect_Transform_Parse_0_Memo,
      Row_Pos_66 /= No_Token_Index,
      Transform_Res_63,
      Pos,
      Row_Pos_66);


   Parser.Current_Pos := Row_Pos_66;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_63;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Aspect_Transform_Parse_0;

   


function Parameter_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameter
is
   use Bare_Parameter_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_96 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_120 :
            Token_Index
               := No_Token_Index;
      Defer_Res_120 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_169 :
            Token_Index
               := No_Token_Index;
      Token_Res_169 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_121 :
            Token_Index
               := No_Token_Index;
      Defer_Res_121 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Transform_Res_92 :
            Bare_Parameter
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Parameter_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_92 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_92;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_92;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_96 := Pos;



Defer_Res_120 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_96);
Defer_Pos_120 := Parser.Current_Pos;



if Defer_Pos_120 /= No_Token_Index then

   Row_Pos_96 := Defer_Pos_120;

else
   Row_Pos_96 := No_Token_Index;
   goto Exit_Row_96_0;

end if;


--  Start tok_code

Token_Res_169 := Row_Pos_96;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_169));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Colon)
   then
       Token_Pos_169 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_96 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_96,
             Expected_Token_Id => RFLX_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_169 := Row_Pos_96 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_169 /= No_Token_Index then

   Row_Pos_96 := Token_Pos_169;

else
   Row_Pos_96 := No_Token_Index;
   goto Exit_Row_96_0;

end if;


Defer_Res_121 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_96);
Defer_Pos_121 := Parser.Current_Pos;



if Defer_Pos_121 /= No_Token_Index then

   Row_Pos_96 := Defer_Pos_121;

else
   Row_Pos_96 := No_Token_Index;
   goto Exit_Row_96_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_96_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_96 /= No_Token_Index then

   Transform_Res_92 := Allocate_Parameter (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_92,
      Kind => RFLX_Parameter,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_96 = Pos
                            then No_Token_Index
                            else Row_Pos_96 - 1));

      Initialize_Fields_For_Parameter
        (Self => Transform_Res_92, Parameter_F_Identifier => Defer_Res_120, Parameter_F_Type_Identifier => Defer_Res_121);

         if Defer_Res_120 /= null and then Is_Incomplete (Defer_Res_120) then
            Transform_Res_92.Last_Attempted_Child := 0;
         elsif Defer_Res_120 /= null and then not Is_Ghost (Defer_Res_120) then
            Transform_Res_92.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_121 /= null and then Is_Incomplete (Defer_Res_121) then
            Transform_Res_92.Last_Attempted_Child := 0;
         elsif Defer_Res_121 /= null and then not Is_Ghost (Defer_Res_121) then
            Transform_Res_92.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Parameter_Transform_Parse_0_Memo,
      Row_Pos_96 /= No_Token_Index,
      Transform_Res_92,
      Pos,
      Row_Pos_96);


   Parser.Current_Pos := Row_Pos_96;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_92;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Parameter_Transform_Parse_0;

   


function Parameter_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parameters
is
   use Bare_Parameters_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_95 :
            Token_Index
               := No_Token_Index;
      Token_Pos_166 :
            Token_Index
               := No_Token_Index;
      Token_Res_166 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_7 :
            Token_Index
               := No_Token_Index;
      Tmp_List_7 :
            Free_Parse_List;
      Defer_Pos_119 :
            Token_Index
               := No_Token_Index;
      Defer_Res_119 :
            Bare_Parameter
               := No_Bare_RFLX_Node;
      Token_Pos_167 :
            Token_Index
               := No_Token_Index;
      Token_Res_167 :
            Token_Index
               := No_Token_Index;
      List_Pos_7 :
            Token_Index
               := No_Token_Index;
      List_Res_7 :
            Bare_Parameter_List
               := No_Bare_RFLX_Node;
      Token_Pos_168 :
            Token_Index
               := No_Token_Index;
      Token_Res_168 :
            Token_Index
               := No_Token_Index;
      Transform_Res_91 :
            Bare_Parameters
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Parameter_List_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_91 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_91;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_91;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_95 := Pos;



--  Start tok_code

Token_Res_166 := Row_Pos_95;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_166));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_166 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_95 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_95,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_166 := Row_Pos_95 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_166 /= No_Token_Index then

   Row_Pos_95 := Token_Pos_166;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start list_code

    List_Pos_7 := No_Token_Index;



Lst_Cpos_7 := Row_Pos_95;
Tmp_List_7 := Get_Parse_List (Parser);

loop
   
Defer_Res_119 :=
   Parameter_Transform_Parse_0 (Parser, Lst_Cpos_7);
Defer_Pos_119 := Parser.Current_Pos;


   exit when Defer_Pos_119 = No_Token_Index;

   List_Pos_7 := Defer_Pos_119;
   Lst_Cpos_7 := List_Pos_7;

   Tmp_List_7.Nodes.Append (Defer_Res_119);

      
--  Start tok_code

Token_Res_167 := Lst_Cpos_7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_167));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_167 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_7,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_167 := Lst_Cpos_7 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_167 /= No_Token_Index then
          Lst_Cpos_7 := Token_Pos_167;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_7.Nodes.Length;
begin
   List_Res_7 :=
      Allocate_Parameter_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_95;
      Token_End := (if Lst_Cpos_7 = Row_Pos_95
                    then Row_Pos_95
                    else Lst_Cpos_7 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_95, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_7,
      Kind              => RFLX_Parameter_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_7,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_7.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_7.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_7);

--  End list_code



if List_Pos_7 /= No_Token_Index then

   Row_Pos_95 := List_Pos_7;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_95_0;

end if;


--  Start tok_code

Token_Res_168 := Row_Pos_95;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_168));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_168 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_95 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_95,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_168 := Row_Pos_95 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_168 /= No_Token_Index then

   Row_Pos_95 := Token_Pos_168;

else
   Row_Pos_95 := No_Token_Index;
   goto Exit_Row_95_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_95_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_95 /= No_Token_Index then

   Transform_Res_91 := Allocate_Parameters (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_91,
      Kind => RFLX_Parameters,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_95 = Pos
                            then No_Token_Index
                            else Row_Pos_95 - 1));

      Initialize_Fields_For_Parameters
        (Self => Transform_Res_91, Parameters_F_Parameters => List_Res_7);

         if List_Res_7 /= null and then Is_Incomplete (List_Res_7) then
            Transform_Res_91.Last_Attempted_Child := 0;
         elsif List_Res_7 /= null and then not Is_Ghost (List_Res_7) then
            Transform_Res_91.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Parameter_List_Transform_Parse_0_Memo,
      Row_Pos_95 /= No_Token_Index,
      Transform_Res_91,
      Pos,
      Row_Pos_95);


   Parser.Current_Pos := Row_Pos_95;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_91;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Parameter_List_Transform_Parse_0;

   


function Element_Value_Association_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Element_Value_Assoc
is
   use Bare_Element_Value_Assoc_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_99 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_126 :
            Token_Index
               := No_Token_Index;
      Defer_Res_126 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_174 :
            Token_Index
               := No_Token_Index;
      Token_Res_174 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_127 :
            Token_Index
               := No_Token_Index;
      Defer_Res_127 :
            Bare_Numeric_Literal
               := No_Bare_RFLX_Node;
      Transform_Res_95 :
            Bare_Element_Value_Assoc
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Element_Value_Association_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_95 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_95;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_95;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_99 := Pos;



Defer_Res_126 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_126 := Parser.Current_Pos;



if Defer_Pos_126 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_126;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_99_0;

end if;


--  Start tok_code

Token_Res_174 := Row_Pos_99;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_174));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_174 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_99 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_99,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_174 := Row_Pos_99 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_174 /= No_Token_Index then

   Row_Pos_99 := Token_Pos_174;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_99_0;

end if;


Defer_Res_127 :=
   Numeric_Literal_Transform_Parse_0 (Parser, Row_Pos_99);
Defer_Pos_127 := Parser.Current_Pos;



if Defer_Pos_127 /= No_Token_Index then

   Row_Pos_99 := Defer_Pos_127;

else
   Row_Pos_99 := No_Token_Index;
   goto Exit_Row_99_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_99_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_99 /= No_Token_Index then

   Transform_Res_95 := Allocate_Element_Value_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_95,
      Kind => RFLX_Element_Value_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_99 = Pos
                            then No_Token_Index
                            else Row_Pos_99 - 1));

      Initialize_Fields_For_Element_Value_Assoc
        (Self => Transform_Res_95, Element_Value_Assoc_F_Identifier => Defer_Res_126, Element_Value_Assoc_F_Literal => Defer_Res_127);

         if Defer_Res_126 /= null and then Is_Incomplete (Defer_Res_126) then
            Transform_Res_95.Last_Attempted_Child := 0;
         elsif Defer_Res_126 /= null and then not Is_Ghost (Defer_Res_126) then
            Transform_Res_95.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_127 /= null and then Is_Incomplete (Defer_Res_127) then
            Transform_Res_95.Last_Attempted_Child := 0;
         elsif Defer_Res_127 /= null and then not Is_Ghost (Defer_Res_127) then
            Transform_Res_95.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Element_Value_Association_Transform_Parse_0_Memo,
      Row_Pos_99 /= No_Token_Index,
      Transform_Res_95,
      Pos,
      Row_Pos_99);


   Parser.Current_Pos := Row_Pos_99;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_95;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Element_Value_Association_Transform_Parse_0;

   


function Named_Enumeration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Named_Enumeration_Def
is
   use Bare_Named_Enumeration_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_98 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_8 :
            Token_Index
               := No_Token_Index;
      Tmp_List_8 :
            Free_Parse_List;
      Defer_Pos_125 :
            Token_Index
               := No_Token_Index;
      Defer_Res_125 :
            Bare_Element_Value_Assoc
               := No_Bare_RFLX_Node;
      Token_Pos_173 :
            Token_Index
               := No_Token_Index;
      Token_Res_173 :
            Token_Index
               := No_Token_Index;
      List_Pos_8 :
            Token_Index
               := No_Token_Index;
      List_Res_8 :
            Bare_Element_Value_Assoc_List
               := No_Bare_RFLX_Node;
      Transform_Res_94 :
            Bare_Named_Enumeration_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Named_Enumeration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_94 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_94;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_94;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_98 := Pos;



--  Start list_code

    List_Pos_8 := No_Token_Index;



Lst_Cpos_8 := Row_Pos_98;
Tmp_List_8 := Get_Parse_List (Parser);

loop
   
Defer_Res_125 :=
   Element_Value_Association_Transform_Parse_0 (Parser, Lst_Cpos_8);
Defer_Pos_125 := Parser.Current_Pos;


   exit when Defer_Pos_125 = No_Token_Index;

   List_Pos_8 := Defer_Pos_125;
   Lst_Cpos_8 := List_Pos_8;

   Tmp_List_8.Nodes.Append (Defer_Res_125);

      
--  Start tok_code

Token_Res_173 := Lst_Cpos_8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_173));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_173 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_8,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_173 := Lst_Cpos_8 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_173 /= No_Token_Index then
          Lst_Cpos_8 := Token_Pos_173;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_8.Nodes.Length;
begin
   List_Res_8 :=
      Allocate_Element_Value_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_98;
      Token_End := (if Lst_Cpos_8 = Row_Pos_98
                    then Row_Pos_98
                    else Lst_Cpos_8 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_98, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_8,
      Kind              => RFLX_Element_Value_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_8,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_8.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_8.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_8);

--  End list_code



if List_Pos_8 /= No_Token_Index then

   Row_Pos_98 := List_Pos_8;

else
   Row_Pos_98 := No_Token_Index;
   goto Exit_Row_98_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_98_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_98 /= No_Token_Index then

   Transform_Res_94 := Allocate_Named_Enumeration_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_94,
      Kind => RFLX_Named_Enumeration_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_98 = Pos
                            then No_Token_Index
                            else Row_Pos_98 - 1));

      Initialize_Fields_For_Named_Enumeration_Def
        (Self => Transform_Res_94, Named_Enumeration_Def_F_Elements => List_Res_8);

         if List_Res_8 /= null and then Is_Incomplete (List_Res_8) then
            Transform_Res_94.Last_Attempted_Child := 0;
         elsif List_Res_8 /= null and then not Is_Ghost (List_Res_8) then
            Transform_Res_94.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Named_Enumeration_Transform_Parse_0_Memo,
      Row_Pos_98 /= No_Token_Index,
      Transform_Res_94,
      Pos,
      Row_Pos_98);


   Parser.Current_Pos := Row_Pos_98;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_94;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Named_Enumeration_Transform_Parse_0;

   


function Positional_Enumeration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Positional_Enumeration_Def
is
   use Bare_Positional_Enumeration_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_100 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_9 :
            Token_Index
               := No_Token_Index;
      Tmp_List_9 :
            Free_Parse_List;
      Defer_Pos_128 :
            Token_Index
               := No_Token_Index;
      Defer_Res_128 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_175 :
            Token_Index
               := No_Token_Index;
      Token_Res_175 :
            Token_Index
               := No_Token_Index;
      List_Pos_9 :
            Token_Index
               := No_Token_Index;
      List_Res_9 :
            Bare_UnqualifiedID_List
               := No_Bare_RFLX_Node;
      Transform_Res_96 :
            Bare_Positional_Enumeration_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Positional_Enumeration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_96 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_96;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_96;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_100 := Pos;



--  Start list_code

    List_Pos_9 := No_Token_Index;



Lst_Cpos_9 := Row_Pos_100;
Tmp_List_9 := Get_Parse_List (Parser);

loop
   
Defer_Res_128 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Lst_Cpos_9);
Defer_Pos_128 := Parser.Current_Pos;


   exit when Defer_Pos_128 = No_Token_Index;

   List_Pos_9 := Defer_Pos_128;
   Lst_Cpos_9 := List_Pos_9;

   Tmp_List_9.Nodes.Append (Defer_Res_128);

      
--  Start tok_code

Token_Res_175 := Lst_Cpos_9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_175));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_175 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_9,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_175 := Lst_Cpos_9 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_175 /= No_Token_Index then
          Lst_Cpos_9 := Token_Pos_175;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_9.Nodes.Length;
begin
   List_Res_9 :=
      Allocate_UnqualifiedID_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_100;
      Token_End := (if Lst_Cpos_9 = Row_Pos_100
                    then Row_Pos_100
                    else Lst_Cpos_9 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_100, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_9,
      Kind              => RFLX_UnqualifiedID_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_9,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_9.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_9.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_9);

--  End list_code



if List_Pos_9 /= No_Token_Index then

   Row_Pos_100 := List_Pos_9;

else
   Row_Pos_100 := No_Token_Index;
   goto Exit_Row_100_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_100_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_100 /= No_Token_Index then

   Transform_Res_96 := Allocate_Positional_Enumeration_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_96,
      Kind => RFLX_Positional_Enumeration_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_100 = Pos
                            then No_Token_Index
                            else Row_Pos_100 - 1));

      Initialize_Fields_For_Positional_Enumeration_Def
        (Self => Transform_Res_96, Positional_Enumeration_Def_F_Elements => List_Res_9);

         if List_Res_9 /= null and then Is_Incomplete (List_Res_9) then
            Transform_Res_96.Last_Attempted_Child := 0;
         elsif List_Res_9 /= null and then not Is_Ghost (List_Res_9) then
            Transform_Res_96.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Positional_Enumeration_Transform_Parse_0_Memo,
      Row_Pos_100 /= No_Token_Index,
      Transform_Res_96,
      Pos,
      Row_Pos_100);


   Parser.Current_Pos := Row_Pos_100;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_96;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Positional_Enumeration_Transform_Parse_0;

   


function Enumeration_Aspects_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_List
is
   use Bare_Aspect_List_Memos;

   Call_Depth : aliased Natural;

      Lst_Cpos_10 :
            Token_Index
               := No_Token_Index;
      Tmp_List_10 :
            Free_Parse_List;
      Defer_Pos_129 :
            Token_Index
               := No_Token_Index;
      Defer_Res_129 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Defer_Pos_130 :
            Token_Index
               := No_Token_Index;
      Defer_Res_130 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Or_Pos_40 :
            Token_Index
               := No_Token_Index;
      Or_Res_40 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Token_Pos_176 :
            Token_Index
               := No_Token_Index;
      Token_Res_176 :
            Token_Index
               := No_Token_Index;
      List_Pos_10 :
            Token_Index
               := No_Token_Index;
      List_Res_10 :
            Bare_Aspect_List
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Enumeration_Aspects_List_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_10 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return List_Res_10;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return List_Res_10;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_10 := No_Token_Index;



Lst_Cpos_10 := Pos;
Tmp_List_10 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_40 := No_Token_Index;
Or_Res_40 := No_Bare_RFLX_Node;
    
Defer_Res_129 :=
   Aspect_Transform_Parse_0 (Parser, Lst_Cpos_10);
Defer_Pos_129 := Parser.Current_Pos;

    if Defer_Pos_129 /= No_Token_Index then
        Or_Pos_40 := Defer_Pos_129;
        Or_Res_40 := Defer_Res_129;
        goto Exit_Or_40;
    end if;
    
Defer_Res_130 :=
   Aspect_Transform_Parse_0 (Parser, Lst_Cpos_10);
Defer_Pos_130 := Parser.Current_Pos;

    if Defer_Pos_130 /= No_Token_Index then
        Or_Pos_40 := Defer_Pos_130;
        Or_Res_40 := Defer_Res_130;
        goto Exit_Or_40;
    end if;
<<Exit_Or_40>>

--  End or_code


   exit when Or_Pos_40 = No_Token_Index;

   List_Pos_10 := Or_Pos_40;
   Lst_Cpos_10 := List_Pos_10;

   Tmp_List_10.Nodes.Append (Or_Res_40);

      
--  Start tok_code

Token_Res_176 := Lst_Cpos_10;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_176));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_176 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_10 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_10,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_176 := Lst_Cpos_10 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_176 /= No_Token_Index then
          Lst_Cpos_10 := Token_Pos_176;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_10.Nodes.Length;
begin
   List_Res_10 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_10 = Pos
                    then Pos
                    else Lst_Cpos_10 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_10,
      Kind              => RFLX_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_10,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_10.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_10.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_10);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Enumeration_Aspects_List_Parse_0_Memo,
      List_Pos_10 /= No_Token_Index,
      List_Res_10,
      Pos,
      List_Pos_10);


   Parser.Current_Pos := List_Pos_10;

   Exit_Call (Parser, Call_Depth);
   return List_Res_10;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Enumeration_Aspects_List_Parse_0;

   


function Enumeration_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enumeration_Type_Def
is
   use Bare_Enumeration_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_97 :
            Token_Index
               := No_Token_Index;
      Token_Pos_170 :
            Token_Index
               := No_Token_Index;
      Token_Res_170 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_122 :
            Token_Index
               := No_Token_Index;
      Defer_Res_122 :
            Bare_Named_Enumeration_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_123 :
            Token_Index
               := No_Token_Index;
      Defer_Res_123 :
            Bare_Positional_Enumeration_Def
               := No_Bare_RFLX_Node;
      Or_Pos_39 :
            Token_Index
               := No_Token_Index;
      Or_Res_39 :
            Bare_Enumeration_Def
               := No_Bare_RFLX_Node;
      Token_Pos_171 :
            Token_Index
               := No_Token_Index;
      Token_Res_171 :
            Token_Index
               := No_Token_Index;
      Token_Pos_172 :
            Token_Index
               := No_Token_Index;
      Token_Res_172 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_124 :
            Token_Index
               := No_Token_Index;
      Defer_Res_124 :
            Bare_Aspect_List
               := No_Bare_RFLX_Node;
      Transform_Res_93 :
            Bare_Enumeration_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_93 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_93;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_93;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_97 := Pos;



--  Start tok_code

Token_Res_170 := Row_Pos_97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_170));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_170 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_97,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_170 := Row_Pos_97 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_170 /= No_Token_Index then

   Row_Pos_97 := Token_Pos_170;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


--  Start or_code

Or_Pos_39 := No_Token_Index;
Or_Res_39 := No_Bare_RFLX_Node;
    
Defer_Res_122 :=
   Named_Enumeration_Transform_Parse_0 (Parser, Row_Pos_97);
Defer_Pos_122 := Parser.Current_Pos;

    if Defer_Pos_122 /= No_Token_Index then
        Or_Pos_39 := Defer_Pos_122;
        Or_Res_39 := Defer_Res_122;
        goto Exit_Or_39;
    end if;
    
Defer_Res_123 :=
   Positional_Enumeration_Transform_Parse_0 (Parser, Row_Pos_97);
Defer_Pos_123 := Parser.Current_Pos;

    if Defer_Pos_123 /= No_Token_Index then
        Or_Pos_39 := Defer_Pos_123;
        Or_Res_39 := Defer_Res_123;
        goto Exit_Or_39;
    end if;
<<Exit_Or_39>>

--  End or_code



if Or_Pos_39 /= No_Token_Index then

   Row_Pos_97 := Or_Pos_39;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


--  Start tok_code

Token_Res_171 := Row_Pos_97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_171));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_171 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_97,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_171 := Row_Pos_97 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_171 /= No_Token_Index then

   Row_Pos_97 := Token_Pos_171;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


--  Start tok_code

Token_Res_172 := Row_Pos_97;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_172));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_172 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_97 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_97,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_172 := Row_Pos_97 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_172 /= No_Token_Index then

   Row_Pos_97 := Token_Pos_172;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_97_0;

end if;


Defer_Res_124 :=
   Enumeration_Aspects_List_Parse_0 (Parser, Row_Pos_97);
Defer_Pos_124 := Parser.Current_Pos;



if Defer_Pos_124 /= No_Token_Index then

   Row_Pos_97 := Defer_Pos_124;

else
   Row_Pos_97 := No_Token_Index;
   goto Exit_Row_97_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_97_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_97 /= No_Token_Index then

   Transform_Res_93 := Allocate_Enumeration_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_93,
      Kind => RFLX_Enumeration_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_97 = Pos
                            then No_Token_Index
                            else Row_Pos_97 - 1));

      Initialize_Fields_For_Enumeration_Type_Def
        (Self => Transform_Res_93, Enumeration_Type_Def_F_Elements => Or_Res_39, Enumeration_Type_Def_F_Aspects => Defer_Res_124);

         if Or_Res_39 /= null and then Is_Incomplete (Or_Res_39) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Or_Res_39 /= null and then not Is_Ghost (Or_Res_39) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_124 /= null and then Is_Incomplete (Defer_Res_124) then
            Transform_Res_93.Last_Attempted_Child := 0;
         elsif Defer_Res_124 /= null and then not Is_Ghost (Defer_Res_124) then
            Transform_Res_93.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse_0_Memo,
      Row_Pos_97 /= No_Token_Index,
      Transform_Res_93,
      Pos,
      Row_Pos_97);


   Parser.Current_Pos := Row_Pos_97;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_93;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Enumeration_Type_Definition_Transform_Parse_0;

   


function Range_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Type_Def
is
   use Bare_Range_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_101 :
            Token_Index
               := No_Token_Index;
      Token_Pos_177 :
            Token_Index
               := No_Token_Index;
      Token_Res_177 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_133 :
            Token_Index
               := No_Token_Index;
      Defer_Res_133 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_178 :
            Token_Index
               := No_Token_Index;
      Token_Res_178 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_134 :
            Token_Index
               := No_Token_Index;
      Defer_Res_134 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_179 :
            Token_Index
               := No_Token_Index;
      Token_Res_179 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_135 :
            Token_Index
               := No_Token_Index;
      Defer_Res_135 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Transform_Res_97 :
            Bare_Range_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Range_Type_Definition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_97 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_97;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_97;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_101 := Pos;



--  Start tok_code

Token_Res_177 := Row_Pos_101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_177));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Range)
   then
       Token_Pos_177 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_101,
             Expected_Token_Id => RFLX_Range,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_177 := Row_Pos_101 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_177 /= No_Token_Index then

   Row_Pos_101 := Token_Pos_177;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


Defer_Res_133 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_101);
Defer_Pos_133 := Parser.Current_Pos;



if Defer_Pos_133 /= No_Token_Index then

   Row_Pos_101 := Defer_Pos_133;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


--  Start tok_code

Token_Res_178 := Row_Pos_101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_178));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Double_Dot)
   then
       Token_Pos_178 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_101,
             Expected_Token_Id => RFLX_Double_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_178 := Row_Pos_101 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_178 /= No_Token_Index then

   Row_Pos_101 := Token_Pos_178;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


Defer_Res_134 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_101);
Defer_Pos_134 := Parser.Current_Pos;



if Defer_Pos_134 /= No_Token_Index then

   Row_Pos_101 := Defer_Pos_134;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


--  Start tok_code

Token_Res_179 := Row_Pos_101;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_179));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_179 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_101 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_101,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_179 := Row_Pos_101 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_179 /= No_Token_Index then

   Row_Pos_101 := Token_Pos_179;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;


Defer_Res_135 :=
   Aspect_Transform_Parse_0 (Parser, Row_Pos_101);
Defer_Pos_135 := Parser.Current_Pos;



if Defer_Pos_135 /= No_Token_Index then

   Row_Pos_101 := Defer_Pos_135;

else
   Row_Pos_101 := No_Token_Index;
   goto Exit_Row_101_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_101_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_101 /= No_Token_Index then

   Transform_Res_97 := Allocate_Range_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_97,
      Kind => RFLX_Range_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_101 = Pos
                            then No_Token_Index
                            else Row_Pos_101 - 1));

      Initialize_Fields_For_Range_Type_Def
        (Self => Transform_Res_97, Range_Type_Def_F_First => Defer_Res_133, Range_Type_Def_F_Last => Defer_Res_134, Range_Type_Def_F_Size => Defer_Res_135);

         if Defer_Res_133 /= null and then Is_Incomplete (Defer_Res_133) then
            Transform_Res_97.Last_Attempted_Child := 0;
         elsif Defer_Res_133 /= null and then not Is_Ghost (Defer_Res_133) then
            Transform_Res_97.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_134 /= null and then Is_Incomplete (Defer_Res_134) then
            Transform_Res_97.Last_Attempted_Child := 0;
         elsif Defer_Res_134 /= null and then not Is_Ghost (Defer_Res_134) then
            Transform_Res_97.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_135 /= null and then Is_Incomplete (Defer_Res_135) then
            Transform_Res_97.Last_Attempted_Child := 0;
         elsif Defer_Res_135 /= null and then not Is_Ghost (Defer_Res_135) then
            Transform_Res_97.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Range_Type_Definition_Transform_Parse_0_Memo,
      Row_Pos_101 /= No_Token_Index,
      Transform_Res_97,
      Pos,
      Row_Pos_101);


   Parser.Current_Pos := Row_Pos_101;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_97;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Range_Type_Definition_Transform_Parse_0;

   


function Modular_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Modular_Type_Def
is
   use Bare_Modular_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_102 :
            Token_Index
               := No_Token_Index;
      Token_Pos_180 :
            Token_Index
               := No_Token_Index;
      Token_Res_180 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_136 :
            Token_Index
               := No_Token_Index;
      Defer_Res_136 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_98 :
            Bare_Modular_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Modular_Type_Definition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_98 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_98;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_98;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_102 := Pos;



--  Start tok_code

Token_Res_180 := Row_Pos_102;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_180));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Mod)
   then
       Token_Pos_180 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_102 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_102,
             Expected_Token_Id => RFLX_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_180 := Row_Pos_102 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_180 /= No_Token_Index then

   Row_Pos_102 := Token_Pos_180;

else
   Row_Pos_102 := No_Token_Index;
   goto Exit_Row_102_0;

end if;


Defer_Res_136 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_102);
Defer_Pos_136 := Parser.Current_Pos;



if Defer_Pos_136 /= No_Token_Index then

   Row_Pos_102 := Defer_Pos_136;

else
   Row_Pos_102 := No_Token_Index;
   goto Exit_Row_102_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_102_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_102 /= No_Token_Index then

   Transform_Res_98 := Allocate_Modular_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_98,
      Kind => RFLX_Modular_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_102 = Pos
                            then No_Token_Index
                            else Row_Pos_102 - 1));

      Initialize_Fields_For_Modular_Type_Def
        (Self => Transform_Res_98, Modular_Type_Def_F_Mod => Defer_Res_136);

         if Defer_Res_136 /= null and then Is_Incomplete (Defer_Res_136) then
            Transform_Res_98.Last_Attempted_Child := 0;
         elsif Defer_Res_136 /= null and then not Is_Ghost (Defer_Res_136) then
            Transform_Res_98.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Modular_Type_Definition_Transform_Parse_0_Memo,
      Row_Pos_102 /= No_Token_Index,
      Transform_Res_98,
      Pos,
      Row_Pos_102);


   Parser.Current_Pos := Row_Pos_102;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_98;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Modular_Type_Definition_Transform_Parse_0;

   


function Integer_Type_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Integer_Type_Def
is
   use Bare_Integer_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_131 :
            Token_Index
               := No_Token_Index;
      Defer_Res_131 :
            Bare_Range_Type_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_132 :
            Token_Index
               := No_Token_Index;
      Defer_Res_132 :
            Bare_Modular_Type_Def
               := No_Bare_RFLX_Node;
      Or_Pos_41 :
            Token_Index
               := No_Token_Index;
      Or_Res_41 :
            Bare_Integer_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Integer_Type_Definition_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_41 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_41;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_41;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_41 := No_Token_Index;
Or_Res_41 := No_Bare_RFLX_Node;
    
Defer_Res_131 :=
   Range_Type_Definition_Transform_Parse_0 (Parser, Pos);
Defer_Pos_131 := Parser.Current_Pos;

    if Defer_Pos_131 /= No_Token_Index then
        Or_Pos_41 := Defer_Pos_131;
        Or_Res_41 := Defer_Res_131;
        goto Exit_Or_41;
    end if;
    
Defer_Res_132 :=
   Modular_Type_Definition_Transform_Parse_0 (Parser, Pos);
Defer_Pos_132 := Parser.Current_Pos;

    if Defer_Pos_132 /= No_Token_Index then
        Or_Pos_41 := Defer_Pos_132;
        Or_Res_41 := Defer_Res_132;
        goto Exit_Or_41;
    end if;
<<Exit_Or_41>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Integer_Type_Definition_Or_Parse_0_Memo,
      Or_Pos_41 /= No_Token_Index,
      Or_Res_41,
      Pos,
      Or_Pos_41);


   Parser.Current_Pos := Or_Pos_41;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_41;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Integer_Type_Definition_Or_Parse_0;

   


function If_Condition_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_111 :
            Token_Index
               := No_Token_Index;
      Token_Pos_193 :
            Token_Index
               := No_Token_Index;
      Token_Res_193 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_145 :
            Token_Index
               := No_Token_Index;
      Defer_Res_145 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.If_Condition_Extract_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res_145 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_145;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_145;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos_111 := Pos;



--  Start tok_code

Token_Res_193 := Row_Pos_111;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_193));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_If)
   then
       Token_Pos_193 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_111 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_111,
             Expected_Token_Id => RFLX_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_193 := Row_Pos_111 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_193 /= No_Token_Index then

   Row_Pos_111 := Token_Pos_193;

else
   Row_Pos_111 := No_Token_Index;
   goto Exit_Row_109_0;

end if;


Defer_Res_145 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_111);
Defer_Pos_145 := Parser.Current_Pos;



if Defer_Pos_145 /= No_Token_Index then

   Row_Pos_111 := Defer_Pos_145;

else
   Row_Pos_111 := No_Token_Index;
   goto Exit_Row_109_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_109_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.If_Condition_Extract_Parse_0_Memo,
      Row_Pos_111 /= No_Token_Index,
      Defer_Res_145,
      Pos,
      Row_Pos_111);


   Parser.Current_Pos := Row_Pos_111;

   Exit_Call (Parser, Call_Depth);
   return Defer_Res_145;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end If_Condition_Extract_Parse_0;

   


function Then_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Then_Node
is
   use Bare_Then_Node_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_108 :
            Token_Index
               := No_Token_Index;
      Token_Pos_189 :
            Token_Index
               := No_Token_Index;
      Token_Res_189 :
            Token_Index
               := No_Token_Index;
      Row_Pos_109 :
            Token_Index
               := No_Token_Index;
      Token_Pos_190 :
            Token_Index
               := No_Token_Index;
      Token_Res_190 :
            Token_Index
               := No_Token_Index;
      Transform_Res_103 :
            Bare_NullID
               := No_Bare_RFLX_Node;
      Defer_Pos_142 :
            Token_Index
               := No_Token_Index;
      Defer_Res_142 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Or_Pos_43 :
            Token_Index
               := No_Token_Index;
      Or_Res_43 :
            Bare_AbstractID
               := No_Bare_RFLX_Node;
      Row_Pos_110 :
            Token_Index
               := No_Token_Index;
      Token_Pos_191 :
            Token_Index
               := No_Token_Index;
      Token_Res_191 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_12 :
            Token_Index
               := No_Token_Index;
      Tmp_List_12 :
            Free_Parse_List;
      Defer_Pos_143 :
            Token_Index
               := No_Token_Index;
      Defer_Res_143 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Token_Pos_192 :
            Token_Index
               := No_Token_Index;
      Token_Res_192 :
            Token_Index
               := No_Token_Index;
      List_Pos_12 :
            Token_Index
               := No_Token_Index;
      List_Res_12 :
            Bare_Aspect_List
               := No_Bare_RFLX_Node;
      Defer_Pos_144 :
            Token_Index
               := No_Token_Index;
      Defer_Res_144 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_104 :
            Bare_Then_Node
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Then_Transform_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_104 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_104;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_104;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_108 := Pos;



--  Start tok_code

Token_Res_189 := Row_Pos_108;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_189));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Then)
   then
       Token_Pos_189 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_108 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_108,
             Expected_Token_Id => RFLX_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_189 := Row_Pos_108 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_189 /= No_Token_Index then

   Row_Pos_108 := Token_Pos_189;

else
   Row_Pos_108 := No_Token_Index;
   goto Exit_Row_106_0;

end if;


--  Start or_code

Or_Pos_43 := No_Token_Index;
Or_Res_43 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_109 := Row_Pos_108;



--  Start tok_code

Token_Res_190 := Row_Pos_109;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_190));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_190 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_109 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_109,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_190 := Row_Pos_109 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_190 /= No_Token_Index then

   Row_Pos_109 := Token_Pos_190;

else
   Row_Pos_109 := No_Token_Index;
   goto Exit_Row_107_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_107_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_109 /= No_Token_Index then

   Transform_Res_103 := Allocate_NullID (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_103,
      Kind => RFLX_NullID,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_108,
      Token_End_Index   => (if Row_Pos_109 = Row_Pos_108
                            then No_Token_Index
                            else Row_Pos_109 - 1));




end if;

--  End transform_code

    if Row_Pos_109 /= No_Token_Index then
        Or_Pos_43 := Row_Pos_109;
        Or_Res_43 := Transform_Res_103;
        goto Exit_Or_43;
    end if;
    
Defer_Res_142 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_108);
Defer_Pos_142 := Parser.Current_Pos;

    if Defer_Pos_142 /= No_Token_Index then
        Or_Pos_43 := Defer_Pos_142;
        Or_Res_43 := Defer_Res_142;
        goto Exit_Or_43;
    end if;
<<Exit_Or_43>>

--  End or_code



if Or_Pos_43 /= No_Token_Index then

   Row_Pos_108 := Or_Pos_43;

else
   Row_Pos_108 := No_Token_Index;
   goto Exit_Row_106_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_110 := Row_Pos_108;



--  Start tok_code

Token_Res_191 := Row_Pos_110;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_191));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_191 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_110 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_110,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_191 := Row_Pos_110 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_191 /= No_Token_Index then

   Row_Pos_110 := Token_Pos_191;

else
   Row_Pos_110 := No_Token_Index;
   goto Exit_Row_108_0;

end if;


--  Start list_code

    List_Pos_12 := No_Token_Index;



Lst_Cpos_12 := Row_Pos_110;
Tmp_List_12 := Get_Parse_List (Parser);

loop
   
Defer_Res_143 :=
   Aspect_Transform_Parse_0 (Parser, Lst_Cpos_12);
Defer_Pos_143 := Parser.Current_Pos;


   exit when Defer_Pos_143 = No_Token_Index;

   List_Pos_12 := Defer_Pos_143;
   Lst_Cpos_12 := List_Pos_12;

   Tmp_List_12.Nodes.Append (Defer_Res_143);

      
--  Start tok_code

Token_Res_192 := Lst_Cpos_12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_192));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_192 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_12,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_192 := Lst_Cpos_12 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_192 /= No_Token_Index then
          Lst_Cpos_12 := Token_Pos_192;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_12.Nodes.Length;
begin
   List_Res_12 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_110;
      Token_End := (if Lst_Cpos_12 = Row_Pos_110
                    then Row_Pos_110
                    else Lst_Cpos_12 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_110, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_12,
      Kind              => RFLX_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_12,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_12.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_12.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_12);

--  End list_code



if List_Pos_12 /= No_Token_Index then

   Row_Pos_110 := List_Pos_12;

else
   Row_Pos_110 := No_Token_Index;
   goto Exit_Row_108_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_108_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_110 = No_Token_Index then

        List_Res_12 :=
           Allocate_Aspect_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_12,
            Kind              => RFLX_Aspect_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_108 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_12,
            Parser => Parser,
            Count  => 0);


    Row_Pos_110 := Row_Pos_108;


end if;

--  End opt_code



if Row_Pos_110 /= No_Token_Index then

   Row_Pos_108 := Row_Pos_110;

else
   Row_Pos_108 := No_Token_Index;
   goto Exit_Row_106_0;

end if;


--  Start opt_code




Defer_Res_144 :=
   If_Condition_Extract_Parse_0 (Parser, Row_Pos_108);
Defer_Pos_144 := Parser.Current_Pos;


if Defer_Pos_144 = No_Token_Index then

        Defer_Res_144 := No_Bare_RFLX_Node;


    Defer_Pos_144 := Row_Pos_108;


end if;

--  End opt_code



if Defer_Pos_144 /= No_Token_Index then

   Row_Pos_108 := Defer_Pos_144;

else
   Row_Pos_108 := No_Token_Index;
   goto Exit_Row_106_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_106_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_108 /= No_Token_Index then

   Transform_Res_104 := Allocate_Then_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_104,
      Kind => RFLX_Then_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_108 = Pos
                            then No_Token_Index
                            else Row_Pos_108 - 1));

      Initialize_Fields_For_Then_Node
        (Self => Transform_Res_104, Then_Node_F_Target => Or_Res_43, Then_Node_F_Aspects => List_Res_12, Then_Node_F_Condition => Defer_Res_144);

         if Or_Res_43 /= null and then Is_Incomplete (Or_Res_43) then
            Transform_Res_104.Last_Attempted_Child := 0;
         elsif Or_Res_43 /= null and then not Is_Ghost (Or_Res_43) then
            Transform_Res_104.Last_Attempted_Child := -1;
         end if;
         if List_Res_12 /= null and then Is_Incomplete (List_Res_12) then
            Transform_Res_104.Last_Attempted_Child := 0;
         elsif List_Res_12 /= null and then not Is_Ghost (List_Res_12) then
            Transform_Res_104.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_144 /= null and then Is_Incomplete (Defer_Res_144) then
            Transform_Res_104.Last_Attempted_Child := 0;
         elsif Defer_Res_144 /= null and then not Is_Ghost (Defer_Res_144) then
            Transform_Res_104.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Then_Transform_Parse_1_Memo,
      Row_Pos_108 /= No_Token_Index,
      Transform_Res_104,
      Pos,
      Row_Pos_108);


   Parser.Current_Pos := Row_Pos_108;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_104;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Then_Transform_Parse_1;

   


function Null_Message_Field_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Message_Field
is
   use Bare_Null_Message_Field_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_107 :
            Token_Index
               := No_Token_Index;
      Token_Pos_187 :
            Token_Index
               := No_Token_Index;
      Token_Res_187 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_141 :
            Token_Index
               := No_Token_Index;
      Defer_Res_141 :
            Bare_Then_Node
               := No_Bare_RFLX_Node;
      Token_Pos_188 :
            Token_Index
               := No_Token_Index;
      Token_Res_188 :
            Token_Index
               := No_Token_Index;
      Transform_Res_102 :
            Bare_Null_Message_Field
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Null_Message_Field_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_102 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_102;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_102;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_107 := Pos;



--  Start tok_code

Token_Res_187 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_187));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_187 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_187 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_187 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_187;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_105_0;

end if;


Defer_Res_141 :=
   Then_Transform_Parse_1 (Parser, Row_Pos_107);
Defer_Pos_141 := Parser.Current_Pos;



if Defer_Pos_141 /= No_Token_Index then

   Row_Pos_107 := Defer_Pos_141;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_105_0;

end if;


--  Start tok_code

Token_Res_188 := Row_Pos_107;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_188));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_188 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_107 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_107,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_188 := Row_Pos_107 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_188 /= No_Token_Index then

   Row_Pos_107 := Token_Pos_188;

else
   Row_Pos_107 := No_Token_Index;
   goto Exit_Row_105_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_105_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_107 /= No_Token_Index then

   Transform_Res_102 := Allocate_Null_Message_Field (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_102,
      Kind => RFLX_Null_Message_Field,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_107 = Pos
                            then No_Token_Index
                            else Row_Pos_107 - 1));

      Initialize_Fields_For_Null_Message_Field
        (Self => Transform_Res_102, Null_Message_Field_F_Then => Defer_Res_141);

         if Defer_Res_141 /= null and then Is_Incomplete (Defer_Res_141) then
            Transform_Res_102.Last_Attempted_Child := 0;
         elsif Defer_Res_141 /= null and then not Is_Ghost (Defer_Res_141) then
            Transform_Res_102.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_Message_Field_Transform_Parse_0_Memo,
      Row_Pos_107 /= No_Token_Index,
      Transform_Res_102,
      Pos,
      Row_Pos_107);


   Parser.Current_Pos := Row_Pos_107;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_102;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Null_Message_Field_Transform_Parse_0;

   


function Type_Argument_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Argument
is
   use Bare_Type_Argument_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_115 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_152 :
            Token_Index
               := No_Token_Index;
      Defer_Res_152 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_201 :
            Token_Index
               := No_Token_Index;
      Token_Res_201 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_153 :
            Token_Index
               := No_Token_Index;
      Defer_Res_153 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_106 :
            Bare_Type_Argument
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Argument_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_106 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_106;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_106;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_115 := Pos;



Defer_Res_152 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_115);
Defer_Pos_152 := Parser.Current_Pos;



if Defer_Pos_152 /= No_Token_Index then

   Row_Pos_115 := Defer_Pos_152;

else
   Row_Pos_115 := No_Token_Index;
   goto Exit_Row_112_0;

end if;


--  Start tok_code

Token_Res_201 := Row_Pos_115;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_201));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_201 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_115 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_115,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_201 := Row_Pos_115 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_201 /= No_Token_Index then

   Row_Pos_115 := Token_Pos_201;

else
   Row_Pos_115 := No_Token_Index;
   goto Exit_Row_112_0;

end if;


Defer_Res_153 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_115);
Defer_Pos_153 := Parser.Current_Pos;



if Defer_Pos_153 /= No_Token_Index then

   Row_Pos_115 := Defer_Pos_153;

else
   Row_Pos_115 := No_Token_Index;
   goto Exit_Row_112_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_112_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_115 /= No_Token_Index then

   Transform_Res_106 := Allocate_Type_Argument (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_106,
      Kind => RFLX_Type_Argument,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_115 = Pos
                            then No_Token_Index
                            else Row_Pos_115 - 1));

      Initialize_Fields_For_Type_Argument
        (Self => Transform_Res_106, Type_Argument_F_Identifier => Defer_Res_152, Type_Argument_F_Expression => Defer_Res_153);

         if Defer_Res_152 /= null and then Is_Incomplete (Defer_Res_152) then
            Transform_Res_106.Last_Attempted_Child := 0;
         elsif Defer_Res_152 /= null and then not Is_Ghost (Defer_Res_152) then
            Transform_Res_106.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_153 /= null and then Is_Incomplete (Defer_Res_153) then
            Transform_Res_106.Last_Attempted_Child := 0;
         elsif Defer_Res_153 /= null and then not Is_Ghost (Defer_Res_153) then
            Transform_Res_106.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Argument_Transform_Parse_0_Memo,
      Row_Pos_115 /= No_Token_Index,
      Transform_Res_106,
      Pos,
      Row_Pos_115);


   Parser.Current_Pos := Row_Pos_115;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_106;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Type_Argument_Transform_Parse_0;

   


function Message_Field_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Field
is
   use Bare_Message_Field_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_112 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_146 :
            Token_Index
               := No_Token_Index;
      Defer_Res_146 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_194 :
            Token_Index
               := No_Token_Index;
      Token_Res_194 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_147 :
            Token_Index
               := No_Token_Index;
      Defer_Res_147 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Row_Pos_113 :
            Token_Index
               := No_Token_Index;
      Token_Pos_195 :
            Token_Index
               := No_Token_Index;
      Token_Res_195 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_13 :
            Token_Index
               := No_Token_Index;
      Tmp_List_13 :
            Free_Parse_List;
      Defer_Pos_148 :
            Token_Index
               := No_Token_Index;
      Defer_Res_148 :
            Bare_Type_Argument
               := No_Bare_RFLX_Node;
      Token_Pos_196 :
            Token_Index
               := No_Token_Index;
      Token_Res_196 :
            Token_Index
               := No_Token_Index;
      List_Pos_13 :
            Token_Index
               := No_Token_Index;
      List_Res_13 :
            Bare_Type_Argument_List
               := No_Bare_RFLX_Node;
      Token_Pos_197 :
            Token_Index
               := No_Token_Index;
      Token_Res_197 :
            Token_Index
               := No_Token_Index;
      Row_Pos_114 :
            Token_Index
               := No_Token_Index;
      Token_Pos_198 :
            Token_Index
               := No_Token_Index;
      Token_Res_198 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_14 :
            Token_Index
               := No_Token_Index;
      Tmp_List_14 :
            Free_Parse_List;
      Defer_Pos_149 :
            Token_Index
               := No_Token_Index;
      Defer_Res_149 :
            Bare_Aspect
               := No_Bare_RFLX_Node;
      Token_Pos_199 :
            Token_Index
               := No_Token_Index;
      Token_Res_199 :
            Token_Index
               := No_Token_Index;
      List_Pos_14 :
            Token_Index
               := No_Token_Index;
      List_Res_14 :
            Bare_Aspect_List
               := No_Bare_RFLX_Node;
      Defer_Pos_150 :
            Token_Index
               := No_Token_Index;
      Defer_Res_150 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Lst_Cpos_15 :
            Token_Index
               := No_Token_Index;
      Tmp_List_15 :
            Free_Parse_List;
      Defer_Pos_151 :
            Token_Index
               := No_Token_Index;
      Defer_Res_151 :
            Bare_Then_Node
               := No_Bare_RFLX_Node;
      List_Pos_15 :
            Token_Index
               := No_Token_Index;
      List_Res_15 :
            Bare_Then_Node_List
               := No_Bare_RFLX_Node;
      Token_Pos_200 :
            Token_Index
               := No_Token_Index;
      Token_Res_200 :
            Token_Index
               := No_Token_Index;
      Transform_Res_105 :
            Bare_Message_Field
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_105 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_105;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_105;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_112 := Pos;



Defer_Res_146 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_112);
Defer_Pos_146 := Parser.Current_Pos;



if Defer_Pos_146 /= No_Token_Index then

   Row_Pos_112 := Defer_Pos_146;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start tok_code

Token_Res_194 := Row_Pos_112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_194));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Colon)
   then
       Token_Pos_194 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_112,
             Expected_Token_Id => RFLX_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_194 := Row_Pos_112 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_194 /= No_Token_Index then

   Row_Pos_112 := Token_Pos_194;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


Defer_Res_147 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_112);
Defer_Pos_147 := Parser.Current_Pos;



if Defer_Pos_147 /= No_Token_Index then

   Row_Pos_112 := Defer_Pos_147;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_113 := Row_Pos_112;



--  Start tok_code

Token_Res_195 := Row_Pos_113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_195));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_195 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_113,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_195 := Row_Pos_113 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_195 /= No_Token_Index then

   Row_Pos_113 := Token_Pos_195;

else
   Row_Pos_113 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


--  Start list_code

    List_Pos_13 := No_Token_Index;



Lst_Cpos_13 := Row_Pos_113;
Tmp_List_13 := Get_Parse_List (Parser);

loop
   
Defer_Res_148 :=
   Type_Argument_Transform_Parse_0 (Parser, Lst_Cpos_13);
Defer_Pos_148 := Parser.Current_Pos;


   exit when Defer_Pos_148 = No_Token_Index;

   List_Pos_13 := Defer_Pos_148;
   Lst_Cpos_13 := List_Pos_13;

   Tmp_List_13.Nodes.Append (Defer_Res_148);

      
--  Start tok_code

Token_Res_196 := Lst_Cpos_13;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_196));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_196 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_13 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_13,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_196 := Lst_Cpos_13 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_196 /= No_Token_Index then
          Lst_Cpos_13 := Token_Pos_196;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_13.Nodes.Length;
begin
   List_Res_13 :=
      Allocate_Type_Argument_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_113;
      Token_End := (if Lst_Cpos_13 = Row_Pos_113
                    then Row_Pos_113
                    else Lst_Cpos_13 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_113, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_13,
      Kind              => RFLX_Type_Argument_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_13,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_13.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_13.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_13);

--  End list_code



if List_Pos_13 /= No_Token_Index then

   Row_Pos_113 := List_Pos_13;

else
   Row_Pos_113 := No_Token_Index;
   goto Exit_Row_111_0;

end if;


--  Start tok_code

Token_Res_197 := Row_Pos_113;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_197));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_197 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_113 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_113,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_197 := Row_Pos_113 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_197 /= No_Token_Index then

   Row_Pos_113 := Token_Pos_197;

else
   Row_Pos_113 := No_Token_Index;
   goto Exit_Row_111_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_111_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_113 = No_Token_Index then

        List_Res_13 :=
           Allocate_Type_Argument_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_13,
            Kind              => RFLX_Type_Argument_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_112 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_13,
            Parser => Parser,
            Count  => 0);


    Row_Pos_113 := Row_Pos_112;


end if;

--  End opt_code



if Row_Pos_113 /= No_Token_Index then

   Row_Pos_112 := Row_Pos_113;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_114 := Row_Pos_112;



--  Start tok_code

Token_Res_198 := Row_Pos_114;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_198));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_198 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_114 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_114,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_198 := Row_Pos_114 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_198 /= No_Token_Index then

   Row_Pos_114 := Token_Pos_198;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_113_0;

end if;


--  Start list_code

    List_Pos_14 := No_Token_Index;



Lst_Cpos_14 := Row_Pos_114;
Tmp_List_14 := Get_Parse_List (Parser);

loop
   
Defer_Res_149 :=
   Aspect_Transform_Parse_0 (Parser, Lst_Cpos_14);
Defer_Pos_149 := Parser.Current_Pos;


   exit when Defer_Pos_149 = No_Token_Index;

   List_Pos_14 := Defer_Pos_149;
   Lst_Cpos_14 := List_Pos_14;

   Tmp_List_14.Nodes.Append (Defer_Res_149);

      
--  Start tok_code

Token_Res_199 := Lst_Cpos_14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_199));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_199 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_14,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_199 := Lst_Cpos_14 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_199 /= No_Token_Index then
          Lst_Cpos_14 := Token_Pos_199;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_14.Nodes.Length;
begin
   List_Res_14 :=
      Allocate_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_114;
      Token_End := (if Lst_Cpos_14 = Row_Pos_114
                    then Row_Pos_114
                    else Lst_Cpos_14 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_114, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_14,
      Kind              => RFLX_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_14,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_14.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_14.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_14);

--  End list_code



if List_Pos_14 /= No_Token_Index then

   Row_Pos_114 := List_Pos_14;

else
   Row_Pos_114 := No_Token_Index;
   goto Exit_Row_113_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_113_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_114 = No_Token_Index then

        List_Res_14 :=
           Allocate_Aspect_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_14,
            Kind              => RFLX_Aspect_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_112 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_14,
            Parser => Parser,
            Count  => 0);


    Row_Pos_114 := Row_Pos_112;


end if;

--  End opt_code



if Row_Pos_114 /= No_Token_Index then

   Row_Pos_112 := Row_Pos_114;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start opt_code




Defer_Res_150 :=
   If_Condition_Extract_Parse_0 (Parser, Row_Pos_112);
Defer_Pos_150 := Parser.Current_Pos;


if Defer_Pos_150 = No_Token_Index then

        Defer_Res_150 := No_Bare_RFLX_Node;


    Defer_Pos_150 := Row_Pos_112;


end if;

--  End opt_code



if Defer_Pos_150 /= No_Token_Index then

   Row_Pos_112 := Defer_Pos_150;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start list_code

    List_Pos_15 := Row_Pos_112;



Lst_Cpos_15 := Row_Pos_112;
Tmp_List_15 := Get_Parse_List (Parser);

loop
   
Defer_Res_151 :=
   Then_Transform_Parse_1 (Parser, Lst_Cpos_15);
Defer_Pos_151 := Parser.Current_Pos;


   exit when Defer_Pos_151 = No_Token_Index;

   List_Pos_15 := Defer_Pos_151;
   Lst_Cpos_15 := List_Pos_15;

   Tmp_List_15.Nodes.Append (Defer_Res_151);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_15.Nodes.Length;
begin
   List_Res_15 :=
      Allocate_Then_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_112;
      Token_End := (if Lst_Cpos_15 = Row_Pos_112
                    then Row_Pos_112
                    else Lst_Cpos_15 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_112, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_15,
      Kind              => RFLX_Then_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_15,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_15.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_15.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_15);

--  End list_code



if List_Pos_15 /= No_Token_Index then

   Row_Pos_112 := List_Pos_15;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;


--  Start tok_code

Token_Res_200 := Row_Pos_112;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_200));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_200 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_112 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_112,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_200 := Row_Pos_112 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_200 /= No_Token_Index then

   Row_Pos_112 := Token_Pos_200;

else
   Row_Pos_112 := No_Token_Index;
   goto Exit_Row_110_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_110_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_112 /= No_Token_Index then

   Transform_Res_105 := Allocate_Message_Field (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_105,
      Kind => RFLX_Message_Field,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_112 = Pos
                            then No_Token_Index
                            else Row_Pos_112 - 1));

      Initialize_Fields_For_Message_Field
        (Self => Transform_Res_105, Message_Field_F_Identifier => Defer_Res_146, Message_Field_F_Type_Identifier => Defer_Res_147, Message_Field_F_Type_Arguments => List_Res_13, Message_Field_F_Aspects => List_Res_14, Message_Field_F_Condition => Defer_Res_150, Message_Field_F_Thens => List_Res_15);

         if Defer_Res_146 /= null and then Is_Incomplete (Defer_Res_146) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif Defer_Res_146 /= null and then not Is_Ghost (Defer_Res_146) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_147 /= null and then Is_Incomplete (Defer_Res_147) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif Defer_Res_147 /= null and then not Is_Ghost (Defer_Res_147) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if List_Res_13 /= null and then Is_Incomplete (List_Res_13) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif List_Res_13 /= null and then not Is_Ghost (List_Res_13) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if List_Res_14 /= null and then Is_Incomplete (List_Res_14) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif List_Res_14 /= null and then not Is_Ghost (List_Res_14) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_150 /= null and then Is_Incomplete (Defer_Res_150) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif Defer_Res_150 /= null and then not Is_Ghost (Defer_Res_150) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;
         if List_Res_15 /= null and then Is_Incomplete (List_Res_15) then
            Transform_Res_105.Last_Attempted_Child := 0;
         elsif List_Res_15 /= null and then not Is_Ghost (List_Res_15) then
            Transform_Res_105.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_Transform_Parse_0_Memo,
      Row_Pos_112 /= No_Token_Index,
      Transform_Res_105,
      Pos,
      Row_Pos_112);


   Parser.Current_Pos := Row_Pos_112;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_105;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Field_Transform_Parse_0;

   


function Message_Field_List_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Fields
is
   use Bare_Message_Fields_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_106 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_139 :
            Token_Index
               := No_Token_Index;
      Defer_Res_139 :
            Bare_Null_Message_Field
               := No_Bare_RFLX_Node;
      Lst_Cpos_11 :
            Token_Index
               := No_Token_Index;
      Tmp_List_11 :
            Free_Parse_List;
      Defer_Pos_140 :
            Token_Index
               := No_Token_Index;
      Defer_Res_140 :
            Bare_Message_Field
               := No_Bare_RFLX_Node;
      List_Pos_11 :
            Token_Index
               := No_Token_Index;
      List_Res_11 :
            Bare_Message_Field_List
               := No_Bare_RFLX_Node;
      Transform_Res_101 :
            Bare_Message_Fields
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Field_List_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_101 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_101;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_101;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_106 := Pos;



--  Start opt_code




Defer_Res_139 :=
   Null_Message_Field_Transform_Parse_0 (Parser, Row_Pos_106);
Defer_Pos_139 := Parser.Current_Pos;


if Defer_Pos_139 = No_Token_Index then

        Defer_Res_139 := No_Bare_RFLX_Node;


    Defer_Pos_139 := Row_Pos_106;


end if;

--  End opt_code



if Defer_Pos_139 /= No_Token_Index then

   Row_Pos_106 := Defer_Pos_139;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_104_0;

end if;


--  Start list_code

    List_Pos_11 := No_Token_Index;



Lst_Cpos_11 := Row_Pos_106;
Tmp_List_11 := Get_Parse_List (Parser);

loop
   
Defer_Res_140 :=
   Message_Field_Transform_Parse_0 (Parser, Lst_Cpos_11);
Defer_Pos_140 := Parser.Current_Pos;


   exit when Defer_Pos_140 = No_Token_Index;

   List_Pos_11 := Defer_Pos_140;
   Lst_Cpos_11 := List_Pos_11;

   Tmp_List_11.Nodes.Append (Defer_Res_140);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_11.Nodes.Length;
begin
   List_Res_11 :=
      Allocate_Message_Field_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_106;
      Token_End := (if Lst_Cpos_11 = Row_Pos_106
                    then Row_Pos_106
                    else Lst_Cpos_11 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_106, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_11,
      Kind              => RFLX_Message_Field_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_11,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_11.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_11.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_11);

--  End list_code



if List_Pos_11 /= No_Token_Index then

   Row_Pos_106 := List_Pos_11;

else
   Row_Pos_106 := No_Token_Index;
   goto Exit_Row_104_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_104_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_106 /= No_Token_Index then

   Transform_Res_101 := Allocate_Message_Fields (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_101,
      Kind => RFLX_Message_Fields,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_106 = Pos
                            then No_Token_Index
                            else Row_Pos_106 - 1));

      Initialize_Fields_For_Message_Fields
        (Self => Transform_Res_101, Message_Fields_F_Initial_Field => Defer_Res_139, Message_Fields_F_Fields => List_Res_11);

         if Defer_Res_139 /= null and then Is_Incomplete (Defer_Res_139) then
            Transform_Res_101.Last_Attempted_Child := 0;
         elsif Defer_Res_139 /= null and then not Is_Ghost (Defer_Res_139) then
            Transform_Res_101.Last_Attempted_Child := -1;
         end if;
         if List_Res_11 /= null and then Is_Incomplete (List_Res_11) then
            Transform_Res_101.Last_Attempted_Child := 0;
         elsif List_Res_11 /= null and then not Is_Ghost (List_Res_11) then
            Transform_Res_101.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Field_List_Transform_Parse_0_Memo,
      Row_Pos_106 /= No_Token_Index,
      Transform_Res_101,
      Pos,
      Row_Pos_106);


   Parser.Current_Pos := Row_Pos_106;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_101;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Field_List_Transform_Parse_0;

   


function Value_Range_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Value_Range
is
   use Bare_Checksum_Value_Range_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_119 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_160 :
            Token_Index
               := No_Token_Index;
      Defer_Res_160 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Token_Pos_212 :
            Token_Index
               := No_Token_Index;
      Token_Res_212 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_161 :
            Token_Index
               := No_Token_Index;
      Defer_Res_161 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_110 :
            Bare_Checksum_Value_Range
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Value_Range_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_110 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_110;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_110;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_119 := Pos;



Defer_Res_160 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_119);
Defer_Pos_160 := Parser.Current_Pos;



if Defer_Pos_160 /= No_Token_Index then

   Row_Pos_119 := Defer_Pos_160;

else
   Row_Pos_119 := No_Token_Index;
   goto Exit_Row_117_0;

end if;


--  Start tok_code

Token_Res_212 := Row_Pos_119;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_212));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Double_Dot)
   then
       Token_Pos_212 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_119 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_119,
             Expected_Token_Id => RFLX_Double_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_212 := Row_Pos_119 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_212 /= No_Token_Index then

   Row_Pos_119 := Token_Pos_212;

else
   Row_Pos_119 := No_Token_Index;
   goto Exit_Row_117_0;

end if;


Defer_Res_161 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_119);
Defer_Pos_161 := Parser.Current_Pos;



if Defer_Pos_161 /= No_Token_Index then

   Row_Pos_119 := Defer_Pos_161;

else
   Row_Pos_119 := No_Token_Index;
   goto Exit_Row_117_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_117_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_119 /= No_Token_Index then

   Transform_Res_110 := Allocate_Checksum_Value_Range (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_110,
      Kind => RFLX_Checksum_Value_Range,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_119 = Pos
                            then No_Token_Index
                            else Row_Pos_119 - 1));

      Initialize_Fields_For_Checksum_Value_Range
        (Self => Transform_Res_110, Checksum_Value_Range_F_First => Defer_Res_160, Checksum_Value_Range_F_Last => Defer_Res_161);

         if Defer_Res_160 /= null and then Is_Incomplete (Defer_Res_160) then
            Transform_Res_110.Last_Attempted_Child := 0;
         elsif Defer_Res_160 /= null and then not Is_Ghost (Defer_Res_160) then
            Transform_Res_110.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_161 /= null and then Is_Incomplete (Defer_Res_161) then
            Transform_Res_110.Last_Attempted_Child := 0;
         elsif Defer_Res_161 /= null and then not Is_Ghost (Defer_Res_161) then
            Transform_Res_110.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Value_Range_Transform_Parse_0_Memo,
      Row_Pos_119 /= No_Token_Index,
      Transform_Res_110,
      Pos,
      Row_Pos_119);


   Parser.Current_Pos := Row_Pos_119;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_110;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Value_Range_Transform_Parse_0;

   


function Checksum_Association_Transform_Parse_1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Assoc
is
   use Bare_Checksum_Assoc_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_117 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_157 :
            Token_Index
               := No_Token_Index;
      Defer_Res_157 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_208 :
            Token_Index
               := No_Token_Index;
      Token_Res_208 :
            Token_Index
               := No_Token_Index;
      Token_Pos_209 :
            Token_Index
               := No_Token_Index;
      Token_Res_209 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_18 :
            Token_Index
               := No_Token_Index;
      Tmp_List_18 :
            Free_Parse_List;
      Defer_Pos_158 :
            Token_Index
               := No_Token_Index;
      Defer_Res_158 :
            Bare_Checksum_Value_Range
               := No_Bare_RFLX_Node;
      Row_Pos_118 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_159 :
            Token_Index
               := No_Token_Index;
      Defer_Res_159 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_108 :
            Bare_Checksum_Val
               := No_Bare_RFLX_Node;
      Or_Pos_45 :
            Token_Index
               := No_Token_Index;
      Or_Res_45 :
            Bare_Base_Checksum_Val
               := No_Bare_RFLX_Node;
      Token_Pos_210 :
            Token_Index
               := No_Token_Index;
      Token_Res_210 :
            Token_Index
               := No_Token_Index;
      List_Pos_18 :
            Token_Index
               := No_Token_Index;
      List_Res_18 :
            Bare_Base_Checksum_Val_List
               := No_Bare_RFLX_Node;
      Token_Pos_211 :
            Token_Index
               := No_Token_Index;
      Token_Res_211 :
            Token_Index
               := No_Token_Index;
      Transform_Res_109 :
            Bare_Checksum_Assoc
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Checksum_Association_Transform_Parse_1_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_109 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_109;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_109;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_117 := Pos;



Defer_Res_157 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_117);
Defer_Pos_157 := Parser.Current_Pos;



if Defer_Pos_157 /= No_Token_Index then

   Row_Pos_117 := Defer_Pos_157;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start tok_code

Token_Res_208 := Row_Pos_117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_208));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_208 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_117,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_208 := Row_Pos_117 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_208 /= No_Token_Index then

   Row_Pos_117 := Token_Pos_208;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start tok_code

Token_Res_209 := Row_Pos_117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_209));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_209 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_117,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_209 := Row_Pos_117 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_209 /= No_Token_Index then

   Row_Pos_117 := Token_Pos_209;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start list_code

    List_Pos_18 := No_Token_Index;



Lst_Cpos_18 := Row_Pos_117;
Tmp_List_18 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_45 := No_Token_Index;
Or_Res_45 := No_Bare_RFLX_Node;
    
Defer_Res_158 :=
   Value_Range_Transform_Parse_0 (Parser, Lst_Cpos_18);
Defer_Pos_158 := Parser.Current_Pos;

    if Defer_Pos_158 /= No_Token_Index then
        Or_Pos_45 := Defer_Pos_158;
        Or_Res_45 := Defer_Res_158;
        goto Exit_Or_45;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_118 := Lst_Cpos_18;



Defer_Res_159 :=
   Expression_Or_Parse_1 (Parser, Row_Pos_118);
Defer_Pos_159 := Parser.Current_Pos;



if Defer_Pos_159 /= No_Token_Index then

   Row_Pos_118 := Defer_Pos_159;

else
   Row_Pos_118 := No_Token_Index;
   goto Exit_Row_118_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_118_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_118 /= No_Token_Index then

   Transform_Res_108 := Allocate_Checksum_Val (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_108,
      Kind => RFLX_Checksum_Val,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos_18,
      Token_End_Index   => (if Row_Pos_118 = Lst_Cpos_18
                            then No_Token_Index
                            else Row_Pos_118 - 1));

      Initialize_Fields_For_Checksum_Val
        (Self => Transform_Res_108, Checksum_Val_F_Data => Defer_Res_159);

         if Defer_Res_159 /= null and then Is_Incomplete (Defer_Res_159) then
            Transform_Res_108.Last_Attempted_Child := 0;
         elsif Defer_Res_159 /= null and then not Is_Ghost (Defer_Res_159) then
            Transform_Res_108.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_118 /= No_Token_Index then
        Or_Pos_45 := Row_Pos_118;
        Or_Res_45 := Transform_Res_108;
        goto Exit_Or_45;
    end if;
<<Exit_Or_45>>

--  End or_code


   exit when Or_Pos_45 = No_Token_Index;

   List_Pos_18 := Or_Pos_45;
   Lst_Cpos_18 := List_Pos_18;

   Tmp_List_18.Nodes.Append (Or_Res_45);

      
--  Start tok_code

Token_Res_210 := Lst_Cpos_18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_210));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_210 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_18,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_210 := Lst_Cpos_18 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_210 /= No_Token_Index then
          Lst_Cpos_18 := Token_Pos_210;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_18.Nodes.Length;
begin
   List_Res_18 :=
      Allocate_Base_Checksum_Val_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_117;
      Token_End := (if Lst_Cpos_18 = Row_Pos_117
                    then Row_Pos_117
                    else Lst_Cpos_18 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_117, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_18,
      Kind              => RFLX_Base_Checksum_Val_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_18,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_18.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_18.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_18);

--  End list_code



if List_Pos_18 /= No_Token_Index then

   Row_Pos_117 := List_Pos_18;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_116_0;

end if;


--  Start tok_code

Token_Res_211 := Row_Pos_117;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_211));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_211 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_117 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_117,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_211 := Row_Pos_117 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_211 /= No_Token_Index then

   Row_Pos_117 := Token_Pos_211;

else
   Row_Pos_117 := No_Token_Index;
   goto Exit_Row_116_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_116_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_117 /= No_Token_Index then

   Transform_Res_109 := Allocate_Checksum_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_109,
      Kind => RFLX_Checksum_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_117 = Pos
                            then No_Token_Index
                            else Row_Pos_117 - 1));

      Initialize_Fields_For_Checksum_Assoc
        (Self => Transform_Res_109, Checksum_Assoc_F_Identifier => Defer_Res_157, Checksum_Assoc_F_Covered_Fields => List_Res_18);

         if Defer_Res_157 /= null and then Is_Incomplete (Defer_Res_157) then
            Transform_Res_109.Last_Attempted_Child := 0;
         elsif Defer_Res_157 /= null and then not Is_Ghost (Defer_Res_157) then
            Transform_Res_109.Last_Attempted_Child := -1;
         end if;
         if List_Res_18 /= null and then Is_Incomplete (List_Res_18) then
            Transform_Res_109.Last_Attempted_Child := 0;
         elsif List_Res_18 /= null and then not Is_Ghost (List_Res_18) then
            Transform_Res_109.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Checksum_Association_Transform_Parse_1_Memo,
      Row_Pos_117 /= No_Token_Index,
      Transform_Res_109,
      Pos,
      Row_Pos_117);


   Parser.Current_Pos := Row_Pos_117;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_109;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Checksum_Association_Transform_Parse_1;

   


function Checksum_Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Checksum_Aspect
is
   use Bare_Checksum_Aspect_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_116 :
            Token_Index
               := No_Token_Index;
      Token_Pos_203 :
            Token_Index
               := No_Token_Index;
      Token_Res_203 :
            Token_Index
               := No_Token_Index;
      Token_Pos_204 :
            Token_Index
               := No_Token_Index;
      Token_Res_204 :
            Token_Index
               := No_Token_Index;
      Token_Pos_205 :
            Token_Index
               := No_Token_Index;
      Token_Res_205 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_17 :
            Token_Index
               := No_Token_Index;
      Tmp_List_17 :
            Free_Parse_List;
      Defer_Pos_156 :
            Token_Index
               := No_Token_Index;
      Defer_Res_156 :
            Bare_Checksum_Assoc
               := No_Bare_RFLX_Node;
      Token_Pos_206 :
            Token_Index
               := No_Token_Index;
      Token_Res_206 :
            Token_Index
               := No_Token_Index;
      List_Pos_17 :
            Token_Index
               := No_Token_Index;
      List_Res_17 :
            Bare_Checksum_Assoc_List
               := No_Bare_RFLX_Node;
      Token_Pos_207 :
            Token_Index
               := No_Token_Index;
      Token_Res_207 :
            Token_Index
               := No_Token_Index;
      Transform_Res_107 :
            Bare_Checksum_Aspect
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Checksum_Aspect_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_107 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_107;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_107;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_116 := Pos;



--  Start tok_code

Token_Res_203 := Row_Pos_116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_203));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Checksum)
   then
       Token_Pos_203 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_116,
             Expected_Token_Id => RFLX_Checksum,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_203 := Row_Pos_116 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_203 /= No_Token_Index then

   Row_Pos_116 := Token_Pos_203;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_115_0;

end if;


--  Start tok_code

Token_Res_204 := Row_Pos_116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_204));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_204 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_116,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_204 := Row_Pos_116 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_204 /= No_Token_Index then

   Row_Pos_116 := Token_Pos_204;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_115_0;

end if;


--  Start tok_code

Token_Res_205 := Row_Pos_116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_205));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_205 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_116,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_205 := Row_Pos_116 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_205 /= No_Token_Index then

   Row_Pos_116 := Token_Pos_205;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_115_0;

end if;


--  Start list_code

    List_Pos_17 := No_Token_Index;



Lst_Cpos_17 := Row_Pos_116;
Tmp_List_17 := Get_Parse_List (Parser);

loop
   
Defer_Res_156 :=
   Checksum_Association_Transform_Parse_1 (Parser, Lst_Cpos_17);
Defer_Pos_156 := Parser.Current_Pos;


   exit when Defer_Pos_156 = No_Token_Index;

   List_Pos_17 := Defer_Pos_156;
   Lst_Cpos_17 := List_Pos_17;

   Tmp_List_17.Nodes.Append (Defer_Res_156);

      
--  Start tok_code

Token_Res_206 := Lst_Cpos_17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_206));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_206 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_17,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_206 := Lst_Cpos_17 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_206 /= No_Token_Index then
          Lst_Cpos_17 := Token_Pos_206;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_17.Nodes.Length;
begin
   List_Res_17 :=
      Allocate_Checksum_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_116;
      Token_End := (if Lst_Cpos_17 = Row_Pos_116
                    then Row_Pos_116
                    else Lst_Cpos_17 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_116, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_17,
      Kind              => RFLX_Checksum_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_17,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_17.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_17.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_17);

--  End list_code



if List_Pos_17 /= No_Token_Index then

   Row_Pos_116 := List_Pos_17;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_115_0;

end if;


--  Start tok_code

Token_Res_207 := Row_Pos_116;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_207));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_207 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_116 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_116,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_207 := Row_Pos_116 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_207 /= No_Token_Index then

   Row_Pos_116 := Token_Pos_207;

else
   Row_Pos_116 := No_Token_Index;
   goto Exit_Row_115_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_115_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_116 /= No_Token_Index then

   Transform_Res_107 := Allocate_Checksum_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_107,
      Kind => RFLX_Checksum_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_116 = Pos
                            then No_Token_Index
                            else Row_Pos_116 - 1));

      Initialize_Fields_For_Checksum_Aspect
        (Self => Transform_Res_107, Checksum_Aspect_F_Associations => List_Res_17);

         if List_Res_17 /= null and then Is_Incomplete (List_Res_17) then
            Transform_Res_107.Last_Attempted_Child := 0;
         elsif List_Res_17 /= null and then not Is_Ghost (List_Res_17) then
            Transform_Res_107.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Checksum_Aspect_Transform_Parse_0_Memo,
      Row_Pos_116 /= No_Token_Index,
      Transform_Res_107,
      Pos,
      Row_Pos_116);


   Parser.Current_Pos := Row_Pos_116;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_107;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Checksum_Aspect_Transform_Parse_0;

   


function Byte_Order_Aspect_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Byte_Order_Aspect
is
   use Bare_Byte_Order_Aspect_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_120 :
            Token_Index
               := No_Token_Index;
      Token_Pos_213 :
            Token_Index
               := No_Token_Index;
      Token_Res_213 :
            Token_Index
               := No_Token_Index;
      Token_Pos_214 :
            Token_Index
               := No_Token_Index;
      Token_Res_214 :
            Token_Index
               := No_Token_Index;
      Row_Pos_121 :
            Token_Index
               := No_Token_Index;
      Token_Pos_215 :
            Token_Index
               := No_Token_Index;
      Token_Res_215 :
            Token_Index
               := No_Token_Index;
      Transform_Res_111 :
            Bare_Byte_Order_Type_Highorderfirst
               := No_Bare_RFLX_Node;
      Row_Pos_122 :
            Token_Index
               := No_Token_Index;
      Token_Pos_216 :
            Token_Index
               := No_Token_Index;
      Token_Res_216 :
            Token_Index
               := No_Token_Index;
      Transform_Res_112 :
            Bare_Byte_Order_Type_Loworderfirst
               := No_Bare_RFLX_Node;
      Or_Pos_46 :
            Token_Index
               := No_Token_Index;
      Or_Res_46 :
            Bare_Byte_Order_Type
               := No_Bare_RFLX_Node;
      Transform_Res_113 :
            Bare_Byte_Order_Aspect
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse_2_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_113 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_113;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_113;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_120 := Pos;



--  Start tok_code

Token_Res_213 := Row_Pos_120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_213));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Byte_Order)
   then
       Token_Pos_213 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_120,
             Expected_Token_Id => RFLX_Byte_Order,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_213 := Row_Pos_120 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_213 /= No_Token_Index then

   Row_Pos_120 := Token_Pos_213;

else
   Row_Pos_120 := No_Token_Index;
   goto Exit_Row_119_0;

end if;


--  Start tok_code

Token_Res_214 := Row_Pos_120;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_214));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_214 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_120 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_120,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_214 := Row_Pos_120 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_214 /= No_Token_Index then

   Row_Pos_120 := Token_Pos_214;

else
   Row_Pos_120 := No_Token_Index;
   goto Exit_Row_119_0;

end if;


--  Start or_code

Or_Pos_46 := No_Token_Index;
Or_Res_46 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_121 := Row_Pos_120;



--  Start tok_code

Token_Res_215 := Row_Pos_121;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_215));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_High_Order_First)
   then
       Token_Pos_215 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_121 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_121,
             Expected_Token_Id => RFLX_High_Order_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_215 := Row_Pos_121 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_215 /= No_Token_Index then

   Row_Pos_121 := Token_Pos_215;

else
   Row_Pos_121 := No_Token_Index;
   goto Exit_Row_120_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_120_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_121 /= No_Token_Index then

   Transform_Res_111 := Allocate_Byte_Order_Type_Highorderfirst (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_111,
      Kind => RFLX_Byte_Order_Type_Highorderfirst,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_120,
      Token_End_Index   => (if Row_Pos_121 = Row_Pos_120
                            then No_Token_Index
                            else Row_Pos_121 - 1));




end if;

--  End transform_code

    if Row_Pos_121 /= No_Token_Index then
        Or_Pos_46 := Row_Pos_121;
        Or_Res_46 := Transform_Res_111;
        goto Exit_Or_46;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_122 := Row_Pos_120;



--  Start tok_code

Token_Res_216 := Row_Pos_122;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_216));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Low_Order_First)
   then
       Token_Pos_216 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_122 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_122,
             Expected_Token_Id => RFLX_Low_Order_First,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_216 := Row_Pos_122 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_216 /= No_Token_Index then

   Row_Pos_122 := Token_Pos_216;

else
   Row_Pos_122 := No_Token_Index;
   goto Exit_Row_121_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_121_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_122 /= No_Token_Index then

   Transform_Res_112 := Allocate_Byte_Order_Type_Loworderfirst (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_112,
      Kind => RFLX_Byte_Order_Type_Loworderfirst,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos_120,
      Token_End_Index   => (if Row_Pos_122 = Row_Pos_120
                            then No_Token_Index
                            else Row_Pos_122 - 1));




end if;

--  End transform_code

    if Row_Pos_122 /= No_Token_Index then
        Or_Pos_46 := Row_Pos_122;
        Or_Res_46 := Transform_Res_112;
        goto Exit_Or_46;
    end if;
<<Exit_Or_46>>

--  End or_code



if Or_Pos_46 /= No_Token_Index then

   Row_Pos_120 := Or_Pos_46;

else
   Row_Pos_120 := No_Token_Index;
   goto Exit_Row_119_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_119_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_120 /= No_Token_Index then

   Transform_Res_113 := Allocate_Byte_Order_Aspect (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_113,
      Kind => RFLX_Byte_Order_Aspect,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_120 = Pos
                            then No_Token_Index
                            else Row_Pos_120 - 1));

      Initialize_Fields_For_Byte_Order_Aspect
        (Self => Transform_Res_113, Byte_Order_Aspect_F_Byte_Order => Or_Res_46);

         if Or_Res_46 /= null and then Is_Incomplete (Or_Res_46) then
            Transform_Res_113.Last_Attempted_Child := 0;
         elsif Or_Res_46 /= null and then not Is_Ghost (Or_Res_46) then
            Transform_Res_113.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse_2_Memo,
      Row_Pos_120 /= No_Token_Index,
      Transform_Res_113,
      Pos,
      Row_Pos_120);


   Parser.Current_Pos := Row_Pos_120;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_113;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Byte_Order_Aspect_Transform_Parse_2;

   


function Message_Aspect_List_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Message_Aspect_List
is
   use Bare_Message_Aspect_List_Memos;

   Call_Depth : aliased Natural;

      Lst_Cpos_16 :
            Token_Index
               := No_Token_Index;
      Tmp_List_16 :
            Free_Parse_List;
      Defer_Pos_154 :
            Token_Index
               := No_Token_Index;
      Defer_Res_154 :
            Bare_Checksum_Aspect
               := No_Bare_RFLX_Node;
      Defer_Pos_155 :
            Token_Index
               := No_Token_Index;
      Defer_Res_155 :
            Bare_Byte_Order_Aspect
               := No_Bare_RFLX_Node;
      Or_Pos_44 :
            Token_Index
               := No_Token_Index;
      Or_Res_44 :
            Bare_Message_Aspect
               := No_Bare_RFLX_Node;
      Token_Pos_202 :
            Token_Index
               := No_Token_Index;
      Token_Res_202 :
            Token_Index
               := No_Token_Index;
      List_Pos_16 :
            Token_Index
               := No_Token_Index;
      List_Res_16 :
            Bare_Message_Aspect_List
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Aspect_List_List_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_16 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return List_Res_16;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return List_Res_16;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_16 := No_Token_Index;



Lst_Cpos_16 := Pos;
Tmp_List_16 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_44 := No_Token_Index;
Or_Res_44 := No_Bare_RFLX_Node;
    
Defer_Res_154 :=
   Checksum_Aspect_Transform_Parse_0 (Parser, Lst_Cpos_16);
Defer_Pos_154 := Parser.Current_Pos;

    if Defer_Pos_154 /= No_Token_Index then
        Or_Pos_44 := Defer_Pos_154;
        Or_Res_44 := Defer_Res_154;
        goto Exit_Or_44;
    end if;
    
Defer_Res_155 :=
   Byte_Order_Aspect_Transform_Parse_2 (Parser, Lst_Cpos_16);
Defer_Pos_155 := Parser.Current_Pos;

    if Defer_Pos_155 /= No_Token_Index then
        Or_Pos_44 := Defer_Pos_155;
        Or_Res_44 := Defer_Res_155;
        goto Exit_Or_44;
    end if;
<<Exit_Or_44>>

--  End or_code


   exit when Or_Pos_44 = No_Token_Index;

   List_Pos_16 := Or_Pos_44;
   Lst_Cpos_16 := List_Pos_16;

   Tmp_List_16.Nodes.Append (Or_Res_44);

      
--  Start tok_code

Token_Res_202 := Lst_Cpos_16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_202));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_202 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_16,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_202 := Lst_Cpos_16 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_202 /= No_Token_Index then
          Lst_Cpos_16 := Token_Pos_202;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_16.Nodes.Length;
begin
   List_Res_16 :=
      Allocate_Message_Aspect_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_16 = Pos
                    then Pos
                    else Lst_Cpos_16 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_16,
      Kind              => RFLX_Message_Aspect_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_16,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_16.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_16.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_16);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Aspect_List_List_Parse_0_Memo,
      List_Pos_16 /= No_Token_Index,
      List_Res_16,
      Pos,
      List_Pos_16);


   Parser.Current_Pos := List_Pos_16;

   Exit_Call (Parser, Call_Depth);
   return List_Res_16;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Aspect_List_List_Parse_0;

   


function Message_Type_Definition_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Message_Type_Def
is
   use Bare_Abstract_Message_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_103 :
            Token_Index
               := No_Token_Index;
      Token_Pos_181 :
            Token_Index
               := No_Token_Index;
      Token_Res_181 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_137 :
            Token_Index
               := No_Token_Index;
      Defer_Res_137 :
            Bare_Message_Fields
               := No_Bare_RFLX_Node;
      Token_Pos_182 :
            Token_Index
               := No_Token_Index;
      Token_Res_182 :
            Token_Index
               := No_Token_Index;
      Token_Pos_183 :
            Token_Index
               := No_Token_Index;
      Token_Res_183 :
            Token_Index
               := No_Token_Index;
      Row_Pos_104 :
            Token_Index
               := No_Token_Index;
      Token_Pos_184 :
            Token_Index
               := No_Token_Index;
      Token_Res_184 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_138 :
            Token_Index
               := No_Token_Index;
      Defer_Res_138 :
            Bare_Message_Aspect_List
               := No_Bare_RFLX_Node;
      Transform_Res_99 :
            Bare_Message_Type_Def
               := No_Bare_RFLX_Node;
      Row_Pos_105 :
            Token_Index
               := No_Token_Index;
      Token_Pos_185 :
            Token_Index
               := No_Token_Index;
      Token_Res_185 :
            Token_Index
               := No_Token_Index;
      Token_Pos_186 :
            Token_Index
               := No_Token_Index;
      Token_Res_186 :
            Token_Index
               := No_Token_Index;
      Transform_Res_100 :
            Bare_Null_Message_Type_Def
               := No_Bare_RFLX_Node;
      Or_Pos_42 :
            Token_Index
               := No_Token_Index;
      Or_Res_42 :
            Bare_Abstract_Message_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Message_Type_Definition_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_42 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_42;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_42;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_42 := No_Token_Index;
Or_Res_42 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_103 := Pos;



--  Start tok_code

Token_Res_181 := Row_Pos_103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_181));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Message)
   then
       Token_Pos_181 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_103,
             Expected_Token_Id => RFLX_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_181 := Row_Pos_103 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_181 /= No_Token_Index then

   Row_Pos_103 := Token_Pos_181;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_103_0;

end if;


Defer_Res_137 :=
   Message_Field_List_Transform_Parse_0 (Parser, Row_Pos_103);
Defer_Pos_137 := Parser.Current_Pos;



if Defer_Pos_137 /= No_Token_Index then

   Row_Pos_103 := Defer_Pos_137;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_103_0;

end if;


--  Start tok_code

Token_Res_182 := Row_Pos_103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_182));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_End)
   then
       Token_Pos_182 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_103,
             Expected_Token_Id => RFLX_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_182 := Row_Pos_103 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_182 /= No_Token_Index then

   Row_Pos_103 := Token_Pos_182;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_103_0;

end if;


--  Start tok_code

Token_Res_183 := Row_Pos_103;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_183));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Message)
   then
       Token_Pos_183 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_103 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_103,
             Expected_Token_Id => RFLX_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_183 := Row_Pos_103 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_183 /= No_Token_Index then

   Row_Pos_103 := Token_Pos_183;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_103_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_104 := Row_Pos_103;



--  Start tok_code

Token_Res_184 := Row_Pos_104;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_184));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_184 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_104 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_104,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_184 := Row_Pos_104 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_184 /= No_Token_Index then

   Row_Pos_104 := Token_Pos_184;

else
   Row_Pos_104 := No_Token_Index;
   goto Exit_Row_114_0;

end if;


Defer_Res_138 :=
   Message_Aspect_List_List_Parse_0 (Parser, Row_Pos_104);
Defer_Pos_138 := Parser.Current_Pos;



if Defer_Pos_138 /= No_Token_Index then

   Row_Pos_104 := Defer_Pos_138;

else
   Row_Pos_104 := No_Token_Index;
   goto Exit_Row_114_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_114_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_104 = No_Token_Index then

        Defer_Res_138 :=
           Allocate_Message_Aspect_List (Parser.Mem_Pool);
         Initialize
           (Self              => Defer_Res_138,
            Kind              => RFLX_Message_Aspect_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_103 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => Defer_Res_138,
            Parser => Parser,
            Count  => 0);


    Row_Pos_104 := Row_Pos_103;


end if;

--  End opt_code



if Row_Pos_104 /= No_Token_Index then

   Row_Pos_103 := Row_Pos_104;

else
   Row_Pos_103 := No_Token_Index;
   goto Exit_Row_103_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_103_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_103 /= No_Token_Index then

   Transform_Res_99 := Allocate_Message_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_99,
      Kind => RFLX_Message_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_103 = Pos
                            then No_Token_Index
                            else Row_Pos_103 - 1));

      Initialize_Fields_For_Message_Type_Def
        (Self => Transform_Res_99, Message_Type_Def_F_Message_Fields => Defer_Res_137, Message_Type_Def_F_Aspects => Defer_Res_138);

         if Defer_Res_137 /= null and then Is_Incomplete (Defer_Res_137) then
            Transform_Res_99.Last_Attempted_Child := 0;
         elsif Defer_Res_137 /= null and then not Is_Ghost (Defer_Res_137) then
            Transform_Res_99.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_138 /= null and then Is_Incomplete (Defer_Res_138) then
            Transform_Res_99.Last_Attempted_Child := 0;
         elsif Defer_Res_138 /= null and then not Is_Ghost (Defer_Res_138) then
            Transform_Res_99.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code

    if Row_Pos_103 /= No_Token_Index then
        Or_Pos_42 := Row_Pos_103;
        Or_Res_42 := Transform_Res_99;
        goto Exit_Or_42;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_105 := Pos;



--  Start tok_code

Token_Res_185 := Row_Pos_105;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_185));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_185 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_105 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_105,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_185 := Row_Pos_105 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_185 /= No_Token_Index then

   Row_Pos_105 := Token_Pos_185;

else
   Row_Pos_105 := No_Token_Index;
   goto Exit_Row_122_0;

end if;


--  Start tok_code

Token_Res_186 := Row_Pos_105;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_186));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Message)
   then
       Token_Pos_186 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_105 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_105,
             Expected_Token_Id => RFLX_Message,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_186 := Row_Pos_105 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_186 /= No_Token_Index then

   Row_Pos_105 := Token_Pos_186;

else
   Row_Pos_105 := No_Token_Index;
   goto Exit_Row_122_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_122_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_105 /= No_Token_Index then

   Transform_Res_100 := Allocate_Null_Message_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_100,
      Kind => RFLX_Null_Message_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_105 = Pos
                            then No_Token_Index
                            else Row_Pos_105 - 1));




end if;

--  End transform_code

    if Row_Pos_105 /= No_Token_Index then
        Or_Pos_42 := Row_Pos_105;
        Or_Res_42 := Transform_Res_100;
        goto Exit_Or_42;
    end if;
<<Exit_Or_42>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Message_Type_Definition_Or_Parse_0_Memo,
      Or_Pos_42 /= No_Token_Index,
      Or_Res_42,
      Pos,
      Or_Pos_42);


   Parser.Current_Pos := Or_Pos_42;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_42;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Message_Type_Definition_Or_Parse_0;

   


function Type_Derivation_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Derivation_Def
is
   use Bare_Type_Derivation_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_123 :
            Token_Index
               := No_Token_Index;
      Token_Pos_217 :
            Token_Index
               := No_Token_Index;
      Token_Res_217 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_162 :
            Token_Index
               := No_Token_Index;
      Defer_Res_162 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Transform_Res_114 :
            Bare_Type_Derivation_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_114 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_114;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_114;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_123 := Pos;



--  Start tok_code

Token_Res_217 := Row_Pos_123;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_217));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_New)
   then
       Token_Pos_217 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_123 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_123,
             Expected_Token_Id => RFLX_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_217 := Row_Pos_123 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_217 /= No_Token_Index then

   Row_Pos_123 := Token_Pos_217;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_123_0;

end if;


Defer_Res_162 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_123);
Defer_Pos_162 := Parser.Current_Pos;



if Defer_Pos_162 /= No_Token_Index then

   Row_Pos_123 := Defer_Pos_162;

else
   Row_Pos_123 := No_Token_Index;
   goto Exit_Row_123_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_123_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_123 /= No_Token_Index then

   Transform_Res_114 := Allocate_Type_Derivation_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_114,
      Kind => RFLX_Type_Derivation_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_123 = Pos
                            then No_Token_Index
                            else Row_Pos_123 - 1));

      Initialize_Fields_For_Type_Derivation_Def
        (Self => Transform_Res_114, Type_Derivation_Def_F_Base => Defer_Res_162);

         if Defer_Res_162 /= null and then Is_Incomplete (Defer_Res_162) then
            Transform_Res_114.Last_Attempted_Child := 0;
         elsif Defer_Res_162 /= null and then not Is_Ghost (Defer_Res_162) then
            Transform_Res_114.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse_0_Memo,
      Row_Pos_123 /= No_Token_Index,
      Transform_Res_114,
      Pos,
      Row_Pos_123);


   Parser.Current_Pos := Row_Pos_123;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_114;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Type_Derivation_Definition_Transform_Parse_0;

   


function Sequence_Type_Definition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Sequence_Type_Def
is
   use Bare_Sequence_Type_Def_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_124 :
            Token_Index
               := No_Token_Index;
      Token_Pos_218 :
            Token_Index
               := No_Token_Index;
      Token_Res_218 :
            Token_Index
               := No_Token_Index;
      Token_Pos_219 :
            Token_Index
               := No_Token_Index;
      Token_Res_219 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_163 :
            Token_Index
               := No_Token_Index;
      Defer_Res_163 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Transform_Res_115 :
            Bare_Sequence_Type_Def
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_115 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_115;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_115;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_124 := Pos;



--  Start tok_code

Token_Res_218 := Row_Pos_124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_218));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Sequence)
   then
       Token_Pos_218 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_124,
             Expected_Token_Id => RFLX_Sequence,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_218 := Row_Pos_124 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_218 /= No_Token_Index then

   Row_Pos_124 := Token_Pos_218;

else
   Row_Pos_124 := No_Token_Index;
   goto Exit_Row_124_0;

end if;


--  Start tok_code

Token_Res_219 := Row_Pos_124;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_219));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Of)
   then
       Token_Pos_219 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_124 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_124,
             Expected_Token_Id => RFLX_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_219 := Row_Pos_124 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_219 /= No_Token_Index then

   Row_Pos_124 := Token_Pos_219;

else
   Row_Pos_124 := No_Token_Index;
   goto Exit_Row_124_0;

end if;


Defer_Res_163 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_124);
Defer_Pos_163 := Parser.Current_Pos;



if Defer_Pos_163 /= No_Token_Index then

   Row_Pos_124 := Defer_Pos_163;

else
   Row_Pos_124 := No_Token_Index;
   goto Exit_Row_124_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_124_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_124 /= No_Token_Index then

   Transform_Res_115 := Allocate_Sequence_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_115,
      Kind => RFLX_Sequence_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_124 = Pos
                            then No_Token_Index
                            else Row_Pos_124 - 1));

      Initialize_Fields_For_Sequence_Type_Def
        (Self => Transform_Res_115, Sequence_Type_Def_F_Element_Type => Defer_Res_163);

         if Defer_Res_163 /= null and then Is_Incomplete (Defer_Res_163) then
            Transform_Res_115.Last_Attempted_Child := 0;
         elsif Defer_Res_163 /= null and then not Is_Ghost (Defer_Res_163) then
            Transform_Res_115.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse_0_Memo,
      Row_Pos_124 /= No_Token_Index,
      Transform_Res_115,
      Pos,
      Row_Pos_124);


   Parser.Current_Pos := Row_Pos_124;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_115;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Sequence_Type_Definition_Transform_Parse_0;

   


function Type_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Decl
is
   use Bare_Type_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_94 :
            Token_Index
               := No_Token_Index;
      Token_Pos_164 :
            Token_Index
               := No_Token_Index;
      Token_Res_164 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_112 :
            Token_Index
               := No_Token_Index;
      Defer_Res_112 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Defer_Pos_113 :
            Token_Index
               := No_Token_Index;
      Defer_Res_113 :
            Bare_Parameters
               := No_Bare_RFLX_Node;
      Token_Pos_165 :
            Token_Index
               := No_Token_Index;
      Token_Res_165 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_114 :
            Token_Index
               := No_Token_Index;
      Defer_Res_114 :
            Bare_Enumeration_Type_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_115 :
            Token_Index
               := No_Token_Index;
      Defer_Res_115 :
            Bare_Integer_Type_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_116 :
            Token_Index
               := No_Token_Index;
      Defer_Res_116 :
            Bare_Abstract_Message_Type_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_117 :
            Token_Index
               := No_Token_Index;
      Defer_Res_117 :
            Bare_Type_Derivation_Def
               := No_Bare_RFLX_Node;
      Defer_Pos_118 :
            Token_Index
               := No_Token_Index;
      Defer_Res_118 :
            Bare_Sequence_Type_Def
               := No_Bare_RFLX_Node;
      Or_Pos_38 :
            Token_Index
               := No_Token_Index;
      Or_Res_38 :
            Bare_Type_Def
               := No_Bare_RFLX_Node;
      Transform_Res_90 :
            Bare_Type_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_90 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_90;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_90;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_94 := Pos;



--  Start tok_code

Token_Res_164 := Row_Pos_94;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_164));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Type)
   then
       Token_Pos_164 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_94 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_94,
             Expected_Token_Id => RFLX_Type,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_164 := Row_Pos_94 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_164 /= No_Token_Index then

   Row_Pos_94 := Token_Pos_164;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


Defer_Res_112 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_112 := Parser.Current_Pos;



if Defer_Pos_112 /= No_Token_Index then

   Row_Pos_94 := Defer_Pos_112;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


--  Start opt_code




Defer_Res_113 :=
   Parameter_List_Transform_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_113 := Parser.Current_Pos;


if Defer_Pos_113 = No_Token_Index then

        Defer_Res_113 := No_Bare_RFLX_Node;


    Defer_Pos_113 := Row_Pos_94;


end if;

--  End opt_code



if Defer_Pos_113 /= No_Token_Index then

   Row_Pos_94 := Defer_Pos_113;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


--  Start tok_code

Token_Res_165 := Row_Pos_94;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_165));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_165 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_94 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_94,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_165 := Row_Pos_94 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_165 /= No_Token_Index then

   Row_Pos_94 := Token_Pos_165;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_94_0;

end if;


--  Start or_code

Or_Pos_38 := No_Token_Index;
Or_Res_38 := No_Bare_RFLX_Node;
    
Defer_Res_114 :=
   Enumeration_Type_Definition_Transform_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_114 := Parser.Current_Pos;

    if Defer_Pos_114 /= No_Token_Index then
        Or_Pos_38 := Defer_Pos_114;
        Or_Res_38 := Defer_Res_114;
        goto Exit_Or_38;
    end if;
    
Defer_Res_115 :=
   Integer_Type_Definition_Or_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_115 := Parser.Current_Pos;

    if Defer_Pos_115 /= No_Token_Index then
        Or_Pos_38 := Defer_Pos_115;
        Or_Res_38 := Defer_Res_115;
        goto Exit_Or_38;
    end if;
    
Defer_Res_116 :=
   Message_Type_Definition_Or_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_116 := Parser.Current_Pos;

    if Defer_Pos_116 /= No_Token_Index then
        Or_Pos_38 := Defer_Pos_116;
        Or_Res_38 := Defer_Res_116;
        goto Exit_Or_38;
    end if;
    
Defer_Res_117 :=
   Type_Derivation_Definition_Transform_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_117 := Parser.Current_Pos;

    if Defer_Pos_117 /= No_Token_Index then
        Or_Pos_38 := Defer_Pos_117;
        Or_Res_38 := Defer_Res_117;
        goto Exit_Or_38;
    end if;
    
Defer_Res_118 :=
   Sequence_Type_Definition_Transform_Parse_0 (Parser, Row_Pos_94);
Defer_Pos_118 := Parser.Current_Pos;

    if Defer_Pos_118 /= No_Token_Index then
        Or_Pos_38 := Defer_Pos_118;
        Or_Res_38 := Defer_Res_118;
        goto Exit_Or_38;
    end if;
<<Exit_Or_38>>

--  End or_code



if Or_Pos_38 /= No_Token_Index then

   Row_Pos_94 := Or_Pos_38;

else
   Row_Pos_94 := No_Token_Index;
   goto Exit_Row_94_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_94_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_94 /= No_Token_Index then

   Transform_Res_90 := Allocate_Type_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_90,
      Kind => RFLX_Type_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_94 = Pos
                            then No_Token_Index
                            else Row_Pos_94 - 1));

      Initialize_Fields_For_Type_Decl
        (Self => Transform_Res_90, Type_Decl_F_Identifier => Defer_Res_112, Type_Decl_F_Parameters => Defer_Res_113, Type_Decl_F_Definition => Or_Res_38);

         if Defer_Res_112 /= null and then Is_Incomplete (Defer_Res_112) then
            Transform_Res_90.Last_Attempted_Child := 0;
         elsif Defer_Res_112 /= null and then not Is_Ghost (Defer_Res_112) then
            Transform_Res_90.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_113 /= null and then Is_Incomplete (Defer_Res_113) then
            Transform_Res_90.Last_Attempted_Child := 0;
         elsif Defer_Res_113 /= null and then not Is_Ghost (Defer_Res_113) then
            Transform_Res_90.Last_Attempted_Child := -1;
         end if;
         if Or_Res_38 /= null and then Is_Incomplete (Or_Res_38) then
            Transform_Res_90.Last_Attempted_Child := 0;
         elsif Or_Res_38 /= null and then not Is_Ghost (Or_Res_38) then
            Transform_Res_90.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Declaration_Transform_Parse_0_Memo,
      Row_Pos_94 /= No_Token_Index,
      Transform_Res_90,
      Pos,
      Row_Pos_94);


   Parser.Current_Pos := Row_Pos_94;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_90;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Type_Declaration_Transform_Parse_0;

   


function Type_Refinement_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Refinement_Decl
is
   use Bare_Refinement_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_125 :
            Token_Index
               := No_Token_Index;
      Token_Pos_220 :
            Token_Index
               := No_Token_Index;
      Token_Res_220 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_164 :
            Token_Index
               := No_Token_Index;
      Defer_Res_164 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Token_Pos_221 :
            Token_Index
               := No_Token_Index;
      Token_Res_221 :
            Token_Index
               := No_Token_Index;
      Token_Pos_222 :
            Token_Index
               := No_Token_Index;
      Token_Res_222 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_165 :
            Token_Index
               := No_Token_Index;
      Defer_Res_165 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_223 :
            Token_Index
               := No_Token_Index;
      Token_Res_223 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_166 :
            Token_Index
               := No_Token_Index;
      Defer_Res_166 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Token_Pos_224 :
            Token_Index
               := No_Token_Index;
      Token_Res_224 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_167 :
            Token_Index
               := No_Token_Index;
      Defer_Res_167 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_116 :
            Bare_Refinement_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Type_Refinement_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_116 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_116;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_116;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_125 := Pos;



--  Start tok_code

Token_Res_220 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_220));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_For)
   then
       Token_Pos_220 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => RFLX_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_220 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_220 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_220;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


Defer_Res_164 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_125);
Defer_Pos_164 := Parser.Current_Pos;



if Defer_Pos_164 /= No_Token_Index then

   Row_Pos_125 := Defer_Pos_164;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start tok_code

Token_Res_221 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_221));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Use)
   then
       Token_Pos_221 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => RFLX_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_221 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_221 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_221;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start tok_code

Token_Res_222 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_222));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_L_Par)
   then
       Token_Pos_222 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => RFLX_L_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_222 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_222 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_222;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


Defer_Res_165 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_125);
Defer_Pos_165 := Parser.Current_Pos;



if Defer_Pos_165 /= No_Token_Index then

   Row_Pos_125 := Defer_Pos_165;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start tok_code

Token_Res_223 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_223));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_223 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_223 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_223 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_223;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


Defer_Res_166 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_125);
Defer_Pos_166 := Parser.Current_Pos;



if Defer_Pos_166 /= No_Token_Index then

   Row_Pos_125 := Defer_Pos_166;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start tok_code

Token_Res_224 := Row_Pos_125;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_224));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_R_Par)
   then
       Token_Pos_224 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_125 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_125,
             Expected_Token_Id => RFLX_R_Par,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_224 := Row_Pos_125 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_224 /= No_Token_Index then

   Row_Pos_125 := Token_Pos_224;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;


--  Start opt_code




Defer_Res_167 :=
   If_Condition_Extract_Parse_0 (Parser, Row_Pos_125);
Defer_Pos_167 := Parser.Current_Pos;


if Defer_Pos_167 = No_Token_Index then

        Defer_Res_167 := No_Bare_RFLX_Node;


    Defer_Pos_167 := Row_Pos_125;


end if;

--  End opt_code



if Defer_Pos_167 /= No_Token_Index then

   Row_Pos_125 := Defer_Pos_167;

else
   Row_Pos_125 := No_Token_Index;
   goto Exit_Row_125_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_125_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_125 /= No_Token_Index then

   Transform_Res_116 := Allocate_Refinement_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_116,
      Kind => RFLX_Refinement_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_125 = Pos
                            then No_Token_Index
                            else Row_Pos_125 - 1));

      Initialize_Fields_For_Refinement_Decl
        (Self => Transform_Res_116, Refinement_Decl_F_Pdu => Defer_Res_164, Refinement_Decl_F_Field => Defer_Res_165, Refinement_Decl_F_Sdu => Defer_Res_166, Refinement_Decl_F_Condition => Defer_Res_167);

         if Defer_Res_164 /= null and then Is_Incomplete (Defer_Res_164) then
            Transform_Res_116.Last_Attempted_Child := 0;
         elsif Defer_Res_164 /= null and then not Is_Ghost (Defer_Res_164) then
            Transform_Res_116.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_165 /= null and then Is_Incomplete (Defer_Res_165) then
            Transform_Res_116.Last_Attempted_Child := 0;
         elsif Defer_Res_165 /= null and then not Is_Ghost (Defer_Res_165) then
            Transform_Res_116.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_166 /= null and then Is_Incomplete (Defer_Res_166) then
            Transform_Res_116.Last_Attempted_Child := 0;
         elsif Defer_Res_166 /= null and then not Is_Ghost (Defer_Res_166) then
            Transform_Res_116.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_167 /= null and then Is_Incomplete (Defer_Res_167) then
            Transform_Res_116.Last_Attempted_Child := 0;
         elsif Defer_Res_167 /= null and then not Is_Ghost (Defer_Res_167) then
            Transform_Res_116.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Type_Refinement_Transform_Parse_0_Memo,
      Row_Pos_125 /= No_Token_Index,
      Transform_Res_116,
      Pos,
      Row_Pos_125);


   Parser.Current_Pos := Row_Pos_125;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_116;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Type_Refinement_Transform_Parse_0;

   


function Formal_Function_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Function_Decl
is
   use Bare_Formal_Function_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_130 :
            Token_Index
               := No_Token_Index;
      Token_Pos_236 :
            Token_Index
               := No_Token_Index;
      Token_Res_236 :
            Token_Index
               := No_Token_Index;
      Token_Pos_237 :
            Token_Index
               := No_Token_Index;
      Token_Res_237 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_176 :
            Token_Index
               := No_Token_Index;
      Defer_Res_176 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Defer_Pos_177 :
            Token_Index
               := No_Token_Index;
      Defer_Res_177 :
            Bare_Parameters
               := No_Bare_RFLX_Node;
      Token_Pos_238 :
            Token_Index
               := No_Token_Index;
      Token_Res_238 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_178 :
            Token_Index
               := No_Token_Index;
      Defer_Res_178 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Transform_Res_118 :
            Bare_Formal_Function_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_118 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_118;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_118;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_130 := Pos;



--  Start tok_code

Token_Res_236 := Row_Pos_130;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_236));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_236 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_130 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_130,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_236 := Row_Pos_130 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_236 /= No_Token_Index then

   Row_Pos_130 := Token_Pos_236;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;


--  Start tok_code

Token_Res_237 := Row_Pos_130;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_237));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Function)
   then
       Token_Pos_237 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_130 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_130,
             Expected_Token_Id => RFLX_Function,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_237 := Row_Pos_130 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_237 /= No_Token_Index then

   Row_Pos_130 := Token_Pos_237;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;


Defer_Res_176 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_130);
Defer_Pos_176 := Parser.Current_Pos;



if Defer_Pos_176 /= No_Token_Index then

   Row_Pos_130 := Defer_Pos_176;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;


--  Start opt_code




Defer_Res_177 :=
   Parameter_List_Transform_Parse_0 (Parser, Row_Pos_130);
Defer_Pos_177 := Parser.Current_Pos;


if Defer_Pos_177 = No_Token_Index then

        Defer_Res_177 := No_Bare_RFLX_Node;


    Defer_Pos_177 := Row_Pos_130;


end if;

--  End opt_code



if Defer_Pos_177 /= No_Token_Index then

   Row_Pos_130 := Defer_Pos_177;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;


--  Start tok_code

Token_Res_238 := Row_Pos_130;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_238));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Return)
   then
       Token_Pos_238 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_130 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_130,
             Expected_Token_Id => RFLX_Return,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_238 := Row_Pos_130 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_238 /= No_Token_Index then

   Row_Pos_130 := Token_Pos_238;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;


Defer_Res_178 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_130);
Defer_Pos_178 := Parser.Current_Pos;



if Defer_Pos_178 /= No_Token_Index then

   Row_Pos_130 := Defer_Pos_178;

else
   Row_Pos_130 := No_Token_Index;
   goto Exit_Row_128_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_128_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_130 /= No_Token_Index then

   Transform_Res_118 := Allocate_Formal_Function_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_118,
      Kind => RFLX_Formal_Function_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_130 = Pos
                            then No_Token_Index
                            else Row_Pos_130 - 1));

      Initialize_Fields_For_Formal_Function_Decl
        (Self => Transform_Res_118, Formal_Function_Decl_F_Identifier => Defer_Res_176, Formal_Function_Decl_F_Parameters => Defer_Res_177, Formal_Function_Decl_F_Return_Type_Identifier => Defer_Res_178);

         if Defer_Res_176 /= null and then Is_Incomplete (Defer_Res_176) then
            Transform_Res_118.Last_Attempted_Child := 0;
         elsif Defer_Res_176 /= null and then not Is_Ghost (Defer_Res_176) then
            Transform_Res_118.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_177 /= null and then Is_Incomplete (Defer_Res_177) then
            Transform_Res_118.Last_Attempted_Child := 0;
         elsif Defer_Res_177 /= null and then not Is_Ghost (Defer_Res_177) then
            Transform_Res_118.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_178 /= null and then Is_Incomplete (Defer_Res_178) then
            Transform_Res_118.Last_Attempted_Child := 0;
         elsif Defer_Res_178 /= null and then not Is_Ghost (Defer_Res_178) then
            Transform_Res_118.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse_0_Memo,
      Row_Pos_130 /= No_Token_Index,
      Transform_Res_118,
      Pos,
      Row_Pos_130);


   Parser.Current_Pos := Row_Pos_130;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_118;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Formal_Function_Declaration_Transform_Parse_0;

   


function Channel_Declaration_Transform_Parse_2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Channel_Decl
is
   use Bare_Formal_Channel_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_131 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_179 :
            Token_Index
               := No_Token_Index;
      Defer_Res_179 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_239 :
            Token_Index
               := No_Token_Index;
      Token_Res_239 :
            Token_Index
               := No_Token_Index;
      Token_Pos_240 :
            Token_Index
               := No_Token_Index;
      Token_Res_240 :
            Token_Index
               := No_Token_Index;
      Token_Pos_241 :
            Token_Index
               := No_Token_Index;
      Token_Res_241 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_22 :
            Token_Index
               := No_Token_Index;
      Tmp_List_22 :
            Free_Parse_List;
      Row_Pos_132 :
            Token_Index
               := No_Token_Index;
      Token_Pos_242 :
            Token_Index
               := No_Token_Index;
      Token_Res_242 :
            Token_Index
               := No_Token_Index;
      Transform_Res_119 :
            Bare_Readable
               := No_Bare_RFLX_Node;
      Row_Pos_133 :
            Token_Index
               := No_Token_Index;
      Token_Pos_243 :
            Token_Index
               := No_Token_Index;
      Token_Res_243 :
            Token_Index
               := No_Token_Index;
      Transform_Res_120 :
            Bare_Writable
               := No_Bare_RFLX_Node;
      Or_Pos_48 :
            Token_Index
               := No_Token_Index;
      Or_Res_48 :
            Bare_Channel_Attribute
               := No_Bare_RFLX_Node;
      Token_Pos_244 :
            Token_Index
               := No_Token_Index;
      Token_Res_244 :
            Token_Index
               := No_Token_Index;
      List_Pos_22 :
            Token_Index
               := No_Token_Index;
      List_Res_22 :
            Bare_Channel_Attribute_List
               := No_Bare_RFLX_Node;
      Transform_Res_121 :
            Bare_Formal_Channel_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Channel_Declaration_Transform_Parse_2_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_121 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_121;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_121;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_131 := Pos;



Defer_Res_179 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_131);
Defer_Pos_179 := Parser.Current_Pos;



if Defer_Pos_179 /= No_Token_Index then

   Row_Pos_131 := Defer_Pos_179;

else
   Row_Pos_131 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start tok_code

Token_Res_239 := Row_Pos_131;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_239));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Colon)
   then
       Token_Pos_239 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_131 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_131,
             Expected_Token_Id => RFLX_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_239 := Row_Pos_131 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_239 /= No_Token_Index then

   Row_Pos_131 := Token_Pos_239;

else
   Row_Pos_131 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start tok_code

Token_Res_240 := Row_Pos_131;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_240));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Channel)
   then
       Token_Pos_240 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_131 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_131,
             Expected_Token_Id => RFLX_Channel,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_240 := Row_Pos_131 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_240 /= No_Token_Index then

   Row_Pos_131 := Token_Pos_240;

else
   Row_Pos_131 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start tok_code

Token_Res_241 := Row_Pos_131;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_241));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_241 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_131 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_131,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_241 := Row_Pos_131 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_241 /= No_Token_Index then

   Row_Pos_131 := Token_Pos_241;

else
   Row_Pos_131 := No_Token_Index;
   goto Exit_Row_129_0;

end if;


--  Start list_code

    List_Pos_22 := No_Token_Index;



Lst_Cpos_22 := Row_Pos_131;
Tmp_List_22 := Get_Parse_List (Parser);

loop
   
--  Start or_code

Or_Pos_48 := No_Token_Index;
Or_Res_48 := No_Bare_RFLX_Node;
    
--  Start transform_code


--  Start row_code

Row_Pos_132 := Lst_Cpos_22;



--  Start tok_code

Token_Res_242 := Row_Pos_132;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_242));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Readable)
   then
       Token_Pos_242 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_132 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_132,
             Expected_Token_Id => RFLX_Readable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_242 := Row_Pos_132 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_242 /= No_Token_Index then

   Row_Pos_132 := Token_Pos_242;

else
   Row_Pos_132 := No_Token_Index;
   goto Exit_Row_130_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_130_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_132 /= No_Token_Index then

   Transform_Res_119 := Allocate_Readable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_119,
      Kind => RFLX_Readable,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos_22,
      Token_End_Index   => (if Row_Pos_132 = Lst_Cpos_22
                            then No_Token_Index
                            else Row_Pos_132 - 1));




end if;

--  End transform_code

    if Row_Pos_132 /= No_Token_Index then
        Or_Pos_48 := Row_Pos_132;
        Or_Res_48 := Transform_Res_119;
        goto Exit_Or_48;
    end if;
    
--  Start transform_code


--  Start row_code

Row_Pos_133 := Lst_Cpos_22;



--  Start tok_code

Token_Res_243 := Row_Pos_133;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_243));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Writable)
   then
       Token_Pos_243 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_133 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_133,
             Expected_Token_Id => RFLX_Writable,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_243 := Row_Pos_133 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_243 /= No_Token_Index then

   Row_Pos_133 := Token_Pos_243;

else
   Row_Pos_133 := No_Token_Index;
   goto Exit_Row_131_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_131_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_133 /= No_Token_Index then

   Transform_Res_120 := Allocate_Writable (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_120,
      Kind => RFLX_Writable,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos_22,
      Token_End_Index   => (if Row_Pos_133 = Lst_Cpos_22
                            then No_Token_Index
                            else Row_Pos_133 - 1));




end if;

--  End transform_code

    if Row_Pos_133 /= No_Token_Index then
        Or_Pos_48 := Row_Pos_133;
        Or_Res_48 := Transform_Res_120;
        goto Exit_Or_48;
    end if;
<<Exit_Or_48>>

--  End or_code


   exit when Or_Pos_48 = No_Token_Index;

   List_Pos_22 := Or_Pos_48;
   Lst_Cpos_22 := List_Pos_22;

   Tmp_List_22.Nodes.Append (Or_Res_48);

      
--  Start tok_code

Token_Res_244 := Lst_Cpos_22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_244));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_244 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_22,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_244 := Lst_Cpos_22 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_244 /= No_Token_Index then
          Lst_Cpos_22 := Token_Pos_244;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_22.Nodes.Length;
begin
   List_Res_22 :=
      Allocate_Channel_Attribute_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_131;
      Token_End := (if Lst_Cpos_22 = Row_Pos_131
                    then Row_Pos_131
                    else Lst_Cpos_22 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_131, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_22,
      Kind              => RFLX_Channel_Attribute_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_22,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_22.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_22.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_22);

--  End list_code



if List_Pos_22 /= No_Token_Index then

   Row_Pos_131 := List_Pos_22;

else
   Row_Pos_131 := No_Token_Index;
   goto Exit_Row_129_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_129_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_131 /= No_Token_Index then

   Transform_Res_121 := Allocate_Formal_Channel_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_121,
      Kind => RFLX_Formal_Channel_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_131 = Pos
                            then No_Token_Index
                            else Row_Pos_131 - 1));

      Initialize_Fields_For_Formal_Channel_Decl
        (Self => Transform_Res_121, Formal_Channel_Decl_F_Identifier => Defer_Res_179, Formal_Channel_Decl_F_Parameters => List_Res_22);

         if Defer_Res_179 /= null and then Is_Incomplete (Defer_Res_179) then
            Transform_Res_121.Last_Attempted_Child := 0;
         elsif Defer_Res_179 /= null and then not Is_Ghost (Defer_Res_179) then
            Transform_Res_121.Last_Attempted_Child := -1;
         end if;
         if List_Res_22 /= null and then Is_Incomplete (List_Res_22) then
            Transform_Res_121.Last_Attempted_Child := 0;
         elsif List_Res_22 /= null and then not Is_Ghost (List_Res_22) then
            Transform_Res_121.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Channel_Declaration_Transform_Parse_2_Memo,
      Row_Pos_131 /= No_Token_Index,
      Transform_Res_121,
      Pos,
      Row_Pos_131);


   Parser.Current_Pos := Row_Pos_131;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_121;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Channel_Declaration_Transform_Parse_2;

   


function Session_Parameter_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Decl
is
   use Bare_Formal_Decl_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_174 :
            Token_Index
               := No_Token_Index;
      Defer_Res_174 :
            Bare_Formal_Function_Decl
               := No_Bare_RFLX_Node;
      Defer_Pos_175 :
            Token_Index
               := No_Token_Index;
      Defer_Res_175 :
            Bare_Formal_Channel_Decl
               := No_Bare_RFLX_Node;
      Or_Pos_47 :
            Token_Index
               := No_Token_Index;
      Or_Res_47 :
            Bare_Formal_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Session_Parameter_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_47 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_47;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_47;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_47 := No_Token_Index;
Or_Res_47 := No_Bare_RFLX_Node;
    
Defer_Res_174 :=
   Formal_Function_Declaration_Transform_Parse_0 (Parser, Pos);
Defer_Pos_174 := Parser.Current_Pos;

    if Defer_Pos_174 /= No_Token_Index then
        Or_Pos_47 := Defer_Pos_174;
        Or_Res_47 := Defer_Res_174;
        goto Exit_Or_47;
    end if;
    
Defer_Res_175 :=
   Channel_Declaration_Transform_Parse_2 (Parser, Pos);
Defer_Pos_175 := Parser.Current_Pos;

    if Defer_Pos_175 /= No_Token_Index then
        Or_Pos_47 := Defer_Pos_175;
        Or_Res_47 := Defer_Res_175;
        goto Exit_Or_47;
    end if;
<<Exit_Or_47>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Session_Parameter_Or_Parse_0_Memo,
      Or_Pos_47 /= No_Token_Index,
      Or_Res_47,
      Pos,
      Or_Pos_47);


   Parser.Current_Pos := Or_Pos_47;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_47;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Session_Parameter_Or_Parse_0;

   


function Session_Aspects_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Aspects
is
   use Bare_Session_Aspects_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_134 :
            Token_Index
               := No_Token_Index;
      Token_Pos_245 :
            Token_Index
               := No_Token_Index;
      Token_Res_245 :
            Token_Index
               := No_Token_Index;
      Token_Pos_246 :
            Token_Index
               := No_Token_Index;
      Token_Res_246 :
            Token_Index
               := No_Token_Index;
      Token_Pos_247 :
            Token_Index
               := No_Token_Index;
      Token_Res_247 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_180 :
            Token_Index
               := No_Token_Index;
      Defer_Res_180 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_248 :
            Token_Index
               := No_Token_Index;
      Token_Res_248 :
            Token_Index
               := No_Token_Index;
      Token_Pos_249 :
            Token_Index
               := No_Token_Index;
      Token_Res_249 :
            Token_Index
               := No_Token_Index;
      Token_Pos_250 :
            Token_Index
               := No_Token_Index;
      Token_Res_250 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_181 :
            Token_Index
               := No_Token_Index;
      Defer_Res_181 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Transform_Res_122 :
            Bare_Session_Aspects
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Session_Aspects_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_122 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_122;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_122;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_134 := Pos;



--  Start tok_code

Token_Res_245 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_245));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_245 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_245 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_245 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_245;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_246 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_246));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Initial)
   then
       Token_Pos_246 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_Initial,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_246 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_246 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_246;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_247 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_247));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_247 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_247 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_247 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_247;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


Defer_Res_180 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_134);
Defer_Pos_180 := Parser.Current_Pos;



if Defer_Pos_180 /= No_Token_Index then

   Row_Pos_134 := Defer_Pos_180;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_248 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_248));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Comma)
   then
       Token_Pos_248 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_248 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_248 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_248;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_249 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_249));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Final)
   then
       Token_Pos_249 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_Final,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_249 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_249 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_249;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


--  Start tok_code

Token_Res_250 := Row_Pos_134;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_250));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_250 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_134 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_134,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_250 := Row_Pos_134 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_250 /= No_Token_Index then

   Row_Pos_134 := Token_Pos_250;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;


Defer_Res_181 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_134);
Defer_Pos_181 := Parser.Current_Pos;



if Defer_Pos_181 /= No_Token_Index then

   Row_Pos_134 := Defer_Pos_181;

else
   Row_Pos_134 := No_Token_Index;
   goto Exit_Row_132_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_132_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_134 /= No_Token_Index then

   Transform_Res_122 := Allocate_Session_Aspects (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_122,
      Kind => RFLX_Session_Aspects,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_134 = Pos
                            then No_Token_Index
                            else Row_Pos_134 - 1));

      Initialize_Fields_For_Session_Aspects
        (Self => Transform_Res_122, Session_Aspects_F_Initial => Defer_Res_180, Session_Aspects_F_Final => Defer_Res_181);

         if Defer_Res_180 /= null and then Is_Incomplete (Defer_Res_180) then
            Transform_Res_122.Last_Attempted_Child := 0;
         elsif Defer_Res_180 /= null and then not Is_Ghost (Defer_Res_180) then
            Transform_Res_122.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_181 /= null and then Is_Incomplete (Defer_Res_181) then
            Transform_Res_122.Last_Attempted_Child := 0;
         elsif Defer_Res_181 /= null and then not Is_Ghost (Defer_Res_181) then
            Transform_Res_122.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Session_Aspects_Transform_Parse_0_Memo,
      Row_Pos_134 /= No_Token_Index,
      Transform_Res_122,
      Pos,
      Row_Pos_134);


   Parser.Current_Pos := Row_Pos_134;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_122;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Session_Aspects_Transform_Parse_0;

   


function Renaming_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Decl
is
   use Bare_Renaming_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_135 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_184 :
            Token_Index
               := No_Token_Index;
      Defer_Res_184 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_251 :
            Token_Index
               := No_Token_Index;
      Token_Res_251 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_185 :
            Token_Index
               := No_Token_Index;
      Defer_Res_185 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Token_Pos_252 :
            Token_Index
               := No_Token_Index;
      Token_Res_252 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_186 :
            Token_Index
               := No_Token_Index;
      Defer_Res_186 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_123 :
            Bare_Renaming_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Renaming_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_123 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_123;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_123;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_135 := Pos;



Defer_Res_184 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_135);
Defer_Pos_184 := Parser.Current_Pos;



if Defer_Pos_184 /= No_Token_Index then

   Row_Pos_135 := Defer_Pos_184;

else
   Row_Pos_135 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_251 := Row_Pos_135;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_251));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Colon)
   then
       Token_Pos_251 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_135 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_135,
             Expected_Token_Id => RFLX_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_251 := Row_Pos_135 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_251 /= No_Token_Index then

   Row_Pos_135 := Token_Pos_251;

else
   Row_Pos_135 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


Defer_Res_185 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_135);
Defer_Pos_185 := Parser.Current_Pos;



if Defer_Pos_185 /= No_Token_Index then

   Row_Pos_135 := Defer_Pos_185;

else
   Row_Pos_135 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


--  Start tok_code

Token_Res_252 := Row_Pos_135;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_252));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Renames)
   then
       Token_Pos_252 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_135 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_135,
             Expected_Token_Id => RFLX_Renames,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_252 := Row_Pos_135 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_252 /= No_Token_Index then

   Row_Pos_135 := Token_Pos_252;

else
   Row_Pos_135 := No_Token_Index;
   goto Exit_Row_134_0;

end if;


Defer_Res_186 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_135);
Defer_Pos_186 := Parser.Current_Pos;



if Defer_Pos_186 /= No_Token_Index then

   Row_Pos_135 := Defer_Pos_186;

else
   Row_Pos_135 := No_Token_Index;
   goto Exit_Row_134_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_134_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_135 /= No_Token_Index then

   Transform_Res_123 := Allocate_Renaming_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_123,
      Kind => RFLX_Renaming_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_135 = Pos
                            then No_Token_Index
                            else Row_Pos_135 - 1));

      Initialize_Fields_For_Renaming_Decl
        (Self => Transform_Res_123, Renaming_Decl_F_Identifier => Defer_Res_184, Renaming_Decl_F_Type_Identifier => Defer_Res_185, Renaming_Decl_F_Expression => Defer_Res_186);

         if Defer_Res_184 /= null and then Is_Incomplete (Defer_Res_184) then
            Transform_Res_123.Last_Attempted_Child := 0;
         elsif Defer_Res_184 /= null and then not Is_Ghost (Defer_Res_184) then
            Transform_Res_123.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_185 /= null and then Is_Incomplete (Defer_Res_185) then
            Transform_Res_123.Last_Attempted_Child := 0;
         elsif Defer_Res_185 /= null and then not Is_Ghost (Defer_Res_185) then
            Transform_Res_123.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_186 /= null and then Is_Incomplete (Defer_Res_186) then
            Transform_Res_123.Last_Attempted_Child := 0;
         elsif Defer_Res_186 /= null and then not Is_Ghost (Defer_Res_186) then
            Transform_Res_123.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Renaming_Declaration_Transform_Parse_0_Memo,
      Row_Pos_135 /= No_Token_Index,
      Transform_Res_123,
      Pos,
      Row_Pos_135);


   Parser.Current_Pos := Row_Pos_135;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_123;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Renaming_Declaration_Transform_Parse_0;

   


function Variable_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variable_Decl
is
   use Bare_Variable_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_136 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_187 :
            Token_Index
               := No_Token_Index;
      Defer_Res_187 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_253 :
            Token_Index
               := No_Token_Index;
      Token_Res_253 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_188 :
            Token_Index
               := No_Token_Index;
      Defer_Res_188 :
            Bare_ID
               := No_Bare_RFLX_Node;
      Row_Pos_137 :
            Token_Index
               := No_Token_Index;
      Token_Pos_254 :
            Token_Index
               := No_Token_Index;
      Token_Res_254 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_189 :
            Token_Index
               := No_Token_Index;
      Defer_Res_189 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_124 :
            Bare_Variable_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Variable_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_124 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_124;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_124;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_136 := Pos;



Defer_Res_187 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_136);
Defer_Pos_187 := Parser.Current_Pos;



if Defer_Pos_187 /= No_Token_Index then

   Row_Pos_136 := Defer_Pos_187;

else
   Row_Pos_136 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


--  Start tok_code

Token_Res_253 := Row_Pos_136;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_253));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Colon)
   then
       Token_Pos_253 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_136 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_136,
             Expected_Token_Id => RFLX_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_253 := Row_Pos_136 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_253 /= No_Token_Index then

   Row_Pos_136 := Token_Pos_253;

else
   Row_Pos_136 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


Defer_Res_188 :=
   Qualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_136);
Defer_Pos_188 := Parser.Current_Pos;



if Defer_Pos_188 /= No_Token_Index then

   Row_Pos_136 := Defer_Pos_188;

else
   Row_Pos_136 := No_Token_Index;
   goto Exit_Row_135_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_137 := Row_Pos_136;



--  Start tok_code

Token_Res_254 := Row_Pos_137;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_254));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Assignment)
   then
       Token_Pos_254 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_137 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_137,
             Expected_Token_Id => RFLX_Assignment,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_254 := Row_Pos_137 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_254 /= No_Token_Index then

   Row_Pos_137 := Token_Pos_254;

else
   Row_Pos_137 := No_Token_Index;
   goto Exit_Row_136_0;

end if;


Defer_Res_189 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_137);
Defer_Pos_189 := Parser.Current_Pos;



if Defer_Pos_189 /= No_Token_Index then

   Row_Pos_137 := Defer_Pos_189;

else
   Row_Pos_137 := No_Token_Index;
   goto Exit_Row_136_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_136_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_137 = No_Token_Index then

        Defer_Res_189 := No_Bare_RFLX_Node;


    Row_Pos_137 := Row_Pos_136;


end if;

--  End opt_code



if Row_Pos_137 /= No_Token_Index then

   Row_Pos_136 := Row_Pos_137;

else
   Row_Pos_136 := No_Token_Index;
   goto Exit_Row_135_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_135_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_136 /= No_Token_Index then

   Transform_Res_124 := Allocate_Variable_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_124,
      Kind => RFLX_Variable_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_136 = Pos
                            then No_Token_Index
                            else Row_Pos_136 - 1));

      Initialize_Fields_For_Variable_Decl
        (Self => Transform_Res_124, Variable_Decl_F_Identifier => Defer_Res_187, Variable_Decl_F_Type_Identifier => Defer_Res_188, Variable_Decl_F_Initializer => Defer_Res_189);

         if Defer_Res_187 /= null and then Is_Incomplete (Defer_Res_187) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Defer_Res_187 /= null and then not Is_Ghost (Defer_Res_187) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_188 /= null and then Is_Incomplete (Defer_Res_188) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Defer_Res_188 /= null and then not Is_Ghost (Defer_Res_188) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_189 /= null and then Is_Incomplete (Defer_Res_189) then
            Transform_Res_124.Last_Attempted_Child := 0;
         elsif Defer_Res_189 /= null and then not Is_Ghost (Defer_Res_189) then
            Transform_Res_124.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Variable_Declaration_Transform_Parse_0_Memo,
      Row_Pos_136 /= No_Token_Index,
      Transform_Res_124,
      Pos,
      Row_Pos_136);


   Parser.Current_Pos := Row_Pos_136;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_124;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Variable_Declaration_Transform_Parse_0;

   


function Declaration_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Local_Decl
is
   use Bare_Local_Decl_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_182 :
            Token_Index
               := No_Token_Index;
      Defer_Res_182 :
            Bare_Renaming_Decl
               := No_Bare_RFLX_Node;
      Defer_Pos_183 :
            Token_Index
               := No_Token_Index;
      Defer_Res_183 :
            Bare_Variable_Decl
               := No_Bare_RFLX_Node;
      Or_Pos_49 :
            Token_Index
               := No_Token_Index;
      Or_Res_49 :
            Bare_Local_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Declaration_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_49 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_49;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_49;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_49 := No_Token_Index;
Or_Res_49 := No_Bare_RFLX_Node;
    
Defer_Res_182 :=
   Renaming_Declaration_Transform_Parse_0 (Parser, Pos);
Defer_Pos_182 := Parser.Current_Pos;

    if Defer_Pos_182 /= No_Token_Index then
        Or_Pos_49 := Defer_Pos_182;
        Or_Res_49 := Defer_Res_182;
        goto Exit_Or_49;
    end if;
    
Defer_Res_183 :=
   Variable_Declaration_Transform_Parse_0 (Parser, Pos);
Defer_Pos_183 := Parser.Current_Pos;

    if Defer_Pos_183 /= No_Token_Index then
        Or_Pos_49 := Defer_Pos_183;
        Or_Res_49 := Defer_Res_183;
        goto Exit_Or_49;
    end if;
<<Exit_Or_49>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Declaration_Or_Parse_0_Memo,
      Or_Pos_49 /= No_Token_Index,
      Or_Res_49,
      Pos,
      Or_Pos_49);


   Parser.Current_Pos := Or_Pos_49;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_49;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Declaration_Or_Parse_0;

   


function Description_Aspect_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Description
is
   use Bare_Description_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_140 :
            Token_Index
               := No_Token_Index;
      Token_Pos_258 :
            Token_Index
               := No_Token_Index;
      Token_Res_258 :
            Token_Index
               := No_Token_Index;
      Token_Pos_259 :
            Token_Index
               := No_Token_Index;
      Token_Res_259 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_194 :
            Token_Index
               := No_Token_Index;
      Defer_Res_194 :
            Bare_String_Literal
               := No_Bare_RFLX_Node;
      Transform_Res_126 :
            Bare_Description
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Description_Aspect_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_126 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_126;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_126;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_140 := Pos;



--  Start tok_code

Token_Res_258 := Row_Pos_140;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_258));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Desc)
   then
       Token_Pos_258 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_140 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_140,
             Expected_Token_Id => RFLX_Desc,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_258 := Row_Pos_140 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_258 /= No_Token_Index then

   Row_Pos_140 := Token_Pos_258;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_140_0;

end if;


--  Start tok_code

Token_Res_259 := Row_Pos_140;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_259));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Arrow)
   then
       Token_Pos_259 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_140 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_140,
             Expected_Token_Id => RFLX_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_259 := Row_Pos_140 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_259 /= No_Token_Index then

   Row_Pos_140 := Token_Pos_259;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_140_0;

end if;


Defer_Res_194 :=
   String_Literal_Transform_Parse_0 (Parser, Row_Pos_140);
Defer_Pos_194 := Parser.Current_Pos;



if Defer_Pos_194 /= No_Token_Index then

   Row_Pos_140 := Defer_Pos_194;

else
   Row_Pos_140 := No_Token_Index;
   goto Exit_Row_140_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_140_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_140 /= No_Token_Index then

   Transform_Res_126 := Allocate_Description (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_126,
      Kind => RFLX_Description,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_140 = Pos
                            then No_Token_Index
                            else Row_Pos_140 - 1));

      Initialize_Fields_For_Description
        (Self => Transform_Res_126, Description_F_Content => Defer_Res_194);

         if Defer_Res_194 /= null and then Is_Incomplete (Defer_Res_194) then
            Transform_Res_126.Last_Attempted_Child := 0;
         elsif Defer_Res_194 /= null and then not Is_Ghost (Defer_Res_194) then
            Transform_Res_126.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Description_Aspect_Transform_Parse_0_Memo,
      Row_Pos_140 /= No_Token_Index,
      Transform_Res_126,
      Pos,
      Row_Pos_140);


   Parser.Current_Pos := Row_Pos_140;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_126;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Description_Aspect_Transform_Parse_0;

   


function Null_State_Body_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_State_Body
is
   use Bare_Null_State_Body_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_141 :
            Token_Index
               := No_Token_Index;
      Token_Pos_260 :
            Token_Index
               := No_Token_Index;
      Token_Res_260 :
            Token_Index
               := No_Token_Index;
      Token_Pos_261 :
            Token_Index
               := No_Token_Index;
      Token_Res_261 :
            Token_Index
               := No_Token_Index;
      Transform_Res_127 :
            Bare_Null_State_Body
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Null_State_Body_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_127 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_127;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_127;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_141 := Pos;



--  Start tok_code

Token_Res_260 := Row_Pos_141;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_260));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Null)
   then
       Token_Pos_260 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_141 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_141,
             Expected_Token_Id => RFLX_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_260 := Row_Pos_141 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_260 /= No_Token_Index then

   Row_Pos_141 := Token_Pos_260;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_141_0;

end if;


--  Start tok_code

Token_Res_261 := Row_Pos_141;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_261));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_State)
   then
       Token_Pos_261 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_141 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_141,
             Expected_Token_Id => RFLX_State,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_261 := Row_Pos_141 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_261 /= No_Token_Index then

   Row_Pos_141 := Token_Pos_261;

else
   Row_Pos_141 := No_Token_Index;
   goto Exit_Row_141_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_141_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_141 /= No_Token_Index then

   Transform_Res_127 := Allocate_Null_State_Body (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_127,
      Kind => RFLX_Null_State_Body,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_141 = Pos
                            then No_Token_Index
                            else Row_Pos_141 - 1));




end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Null_State_Body_Transform_Parse_0_Memo,
      Row_Pos_141 /= No_Token_Index,
      Transform_Res_127,
      Pos,
      Row_Pos_141);


   Parser.Current_Pos := Row_Pos_141;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_127;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Null_State_Body_Transform_Parse_0;

   


function Extended_If_Condition_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_148 :
            Token_Index
               := No_Token_Index;
      Token_Pos_272 :
            Token_Index
               := No_Token_Index;
      Token_Res_272 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_204 :
            Token_Index
               := No_Token_Index;
      Defer_Res_204 :
            Bare_Expr
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Extended_If_Condition_Extract_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res_204 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_204;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_204;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos_148 := Pos;



--  Start tok_code

Token_Res_272 := Row_Pos_148;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_272));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_If)
   then
       Token_Pos_272 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_148 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_148,
             Expected_Token_Id => RFLX_If,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_272 := Row_Pos_148 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_272 /= No_Token_Index then

   Row_Pos_148 := Token_Pos_272;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_147_0;

end if;


Defer_Res_204 :=
   Extended_Expression_Or_Parse_1 (Parser, Row_Pos_148);
Defer_Pos_204 := Parser.Current_Pos;



if Defer_Pos_204 /= No_Token_Index then

   Row_Pos_148 := Defer_Pos_204;

else
   Row_Pos_148 := No_Token_Index;
   goto Exit_Row_147_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_147_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Extended_If_Condition_Extract_Parse_0_Memo,
      Row_Pos_148 /= No_Token_Index,
      Defer_Res_204,
      Pos,
      Row_Pos_148);


   Parser.Current_Pos := Row_Pos_148;

   Exit_Call (Parser, Call_Depth);
   return Defer_Res_204;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Extended_If_Condition_Extract_Parse_0;

   


function Conditional_Transition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Conditional_Transition
is
   use Bare_Conditional_Transition_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_146 :
            Token_Index
               := No_Token_Index;
      Token_Pos_270 :
            Token_Index
               := No_Token_Index;
      Token_Res_270 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_201 :
            Token_Index
               := No_Token_Index;
      Defer_Res_201 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Row_Pos_147 :
            Token_Index
               := No_Token_Index;
      Token_Pos_271 :
            Token_Index
               := No_Token_Index;
      Token_Res_271 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_202 :
            Token_Index
               := No_Token_Index;
      Defer_Res_202 :
            Bare_Description
               := No_Bare_RFLX_Node;
      Defer_Pos_203 :
            Token_Index
               := No_Token_Index;
      Defer_Res_203 :
            Bare_Expr
               := No_Bare_RFLX_Node;
      Transform_Res_129 :
            Bare_Conditional_Transition
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Conditional_Transition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_129 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_129;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_129;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_146 := Pos;



--  Start tok_code

Token_Res_270 := Row_Pos_146;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_270));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Goto)
   then
       Token_Pos_270 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_146 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_146,
             Expected_Token_Id => RFLX_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_270 := Row_Pos_146 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_270 /= No_Token_Index then

   Row_Pos_146 := Token_Pos_270;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_145_0;

end if;


Defer_Res_201 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_146);
Defer_Pos_201 := Parser.Current_Pos;



if Defer_Pos_201 /= No_Token_Index then

   Row_Pos_146 := Defer_Pos_201;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_145_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_147 := Row_Pos_146;



--  Start tok_code

Token_Res_271 := Row_Pos_147;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_271));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_271 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_147 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_147,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_271 := Row_Pos_147 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_271 /= No_Token_Index then

   Row_Pos_147 := Token_Pos_271;

else
   Row_Pos_147 := No_Token_Index;
   goto Exit_Row_146_0;

end if;


Defer_Res_202 :=
   Description_Aspect_Transform_Parse_0 (Parser, Row_Pos_147);
Defer_Pos_202 := Parser.Current_Pos;



if Defer_Pos_202 /= No_Token_Index then

   Row_Pos_147 := Defer_Pos_202;

else
   Row_Pos_147 := No_Token_Index;
   goto Exit_Row_146_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_146_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_147 = No_Token_Index then

        Defer_Res_202 := No_Bare_RFLX_Node;


    Row_Pos_147 := Row_Pos_146;


end if;

--  End opt_code



if Row_Pos_147 /= No_Token_Index then

   Row_Pos_146 := Row_Pos_147;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_145_0;

end if;


Defer_Res_203 :=
   Extended_If_Condition_Extract_Parse_0 (Parser, Row_Pos_146);
Defer_Pos_203 := Parser.Current_Pos;



if Defer_Pos_203 /= No_Token_Index then

   Row_Pos_146 := Defer_Pos_203;

else
   Row_Pos_146 := No_Token_Index;
   goto Exit_Row_145_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_145_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_146 /= No_Token_Index then

   Transform_Res_129 := Allocate_Conditional_Transition (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_129,
      Kind => RFLX_Conditional_Transition,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_146 = Pos
                            then No_Token_Index
                            else Row_Pos_146 - 1));

      Initialize_Fields_For_Conditional_Transition
        (Self => Transform_Res_129, Transition_F_Target => Defer_Res_201, Transition_F_Description => Defer_Res_202, Conditional_Transition_F_Condition => Defer_Res_203);

         if Defer_Res_201 /= null and then Is_Incomplete (Defer_Res_201) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_201 /= null and then not Is_Ghost (Defer_Res_201) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_202 /= null and then Is_Incomplete (Defer_Res_202) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_202 /= null and then not Is_Ghost (Defer_Res_202) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_203 /= null and then Is_Incomplete (Defer_Res_203) then
            Transform_Res_129.Last_Attempted_Child := 0;
         elsif Defer_Res_203 /= null and then not Is_Ghost (Defer_Res_203) then
            Transform_Res_129.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Conditional_Transition_Transform_Parse_0_Memo,
      Row_Pos_146 /= No_Token_Index,
      Transform_Res_129,
      Pos,
      Row_Pos_146);


   Parser.Current_Pos := Row_Pos_146;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_129;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Conditional_Transition_Transform_Parse_0;

   


function Transition_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Transition
is
   use Bare_Transition_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_149 :
            Token_Index
               := No_Token_Index;
      Token_Pos_273 :
            Token_Index
               := No_Token_Index;
      Token_Res_273 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_205 :
            Token_Index
               := No_Token_Index;
      Defer_Res_205 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Row_Pos_150 :
            Token_Index
               := No_Token_Index;
      Token_Pos_274 :
            Token_Index
               := No_Token_Index;
      Token_Res_274 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_206 :
            Token_Index
               := No_Token_Index;
      Defer_Res_206 :
            Bare_Description
               := No_Bare_RFLX_Node;
      Transform_Res_130 :
            Bare_Transition
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Transition_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_130 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_130;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_130;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_149 := Pos;



--  Start tok_code

Token_Res_273 := Row_Pos_149;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_273));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Goto)
   then
       Token_Pos_273 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_149 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_149,
             Expected_Token_Id => RFLX_Goto,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_273 := Row_Pos_149 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_273 /= No_Token_Index then

   Row_Pos_149 := Token_Pos_273;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_148_0;

end if;


Defer_Res_205 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_149);
Defer_Pos_205 := Parser.Current_Pos;



if Defer_Pos_205 /= No_Token_Index then

   Row_Pos_149 := Defer_Pos_205;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_148_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_150 := Row_Pos_149;



--  Start tok_code

Token_Res_274 := Row_Pos_150;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_274));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_274 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_150 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_150,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_274 := Row_Pos_150 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_274 /= No_Token_Index then

   Row_Pos_150 := Token_Pos_274;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_149_0;

end if;


Defer_Res_206 :=
   Description_Aspect_Transform_Parse_0 (Parser, Row_Pos_150);
Defer_Pos_206 := Parser.Current_Pos;



if Defer_Pos_206 /= No_Token_Index then

   Row_Pos_150 := Defer_Pos_206;

else
   Row_Pos_150 := No_Token_Index;
   goto Exit_Row_149_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_149_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_150 = No_Token_Index then

        Defer_Res_206 := No_Bare_RFLX_Node;


    Row_Pos_150 := Row_Pos_149;


end if;

--  End opt_code



if Row_Pos_150 /= No_Token_Index then

   Row_Pos_149 := Row_Pos_150;

else
   Row_Pos_149 := No_Token_Index;
   goto Exit_Row_148_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_148_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_149 /= No_Token_Index then

   Transform_Res_130 := Allocate_Transition (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_130,
      Kind => RFLX_Transition,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_149 = Pos
                            then No_Token_Index
                            else Row_Pos_149 - 1));

      Initialize_Fields_For_Transition
        (Self => Transform_Res_130, Transition_F_Target => Defer_Res_205, Transition_F_Description => Defer_Res_206);

         if Defer_Res_205 /= null and then Is_Incomplete (Defer_Res_205) then
            Transform_Res_130.Last_Attempted_Child := 0;
         elsif Defer_Res_205 /= null and then not Is_Ghost (Defer_Res_205) then
            Transform_Res_130.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_206 /= null and then Is_Incomplete (Defer_Res_206) then
            Transform_Res_130.Last_Attempted_Child := 0;
         elsif Defer_Res_206 /= null and then not Is_Ghost (Defer_Res_206) then
            Transform_Res_130.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Transition_Transform_Parse_0_Memo,
      Row_Pos_149 /= No_Token_Index,
      Transform_Res_130,
      Pos,
      Row_Pos_149);


   Parser.Current_Pos := Row_Pos_149;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_130;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Transition_Transform_Parse_0;

   


function State_Body_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State_Body
is
   use Bare_State_Body_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_142 :
            Token_Index
               := No_Token_Index;
      Row_Pos_143 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_23 :
            Token_Index
               := No_Token_Index;
      Tmp_List_23 :
            Free_Parse_List;
      Defer_Pos_195 :
            Token_Index
               := No_Token_Index;
      Defer_Res_195 :
            Bare_Local_Decl
               := No_Bare_RFLX_Node;
      Token_Pos_262 :
            Token_Index
               := No_Token_Index;
      Token_Res_262 :
            Token_Index
               := No_Token_Index;
      List_Pos_23 :
            Token_Index
               := No_Token_Index;
      List_Res_23 :
            Bare_Local_Decl_List
               := No_Bare_RFLX_Node;
      Token_Pos_263 :
            Token_Index
               := No_Token_Index;
      Token_Res_263 :
            Token_Index
               := No_Token_Index;
      Token_Pos_264 :
            Token_Index
               := No_Token_Index;
      Token_Res_264 :
            Token_Index
               := No_Token_Index;
      Row_Pos_144 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_24 :
            Token_Index
               := No_Token_Index;
      Tmp_List_24 :
            Free_Parse_List;
      Defer_Pos_196 :
            Token_Index
               := No_Token_Index;
      Defer_Res_196 :
            Bare_Statement
               := No_Bare_RFLX_Node;
      Token_Pos_265 :
            Token_Index
               := No_Token_Index;
      Token_Res_265 :
            Token_Index
               := No_Token_Index;
      List_Pos_24 :
            Token_Index
               := No_Token_Index;
      List_Res_24 :
            Bare_Statement_List
               := No_Bare_RFLX_Node;
      Token_Pos_266 :
            Token_Index
               := No_Token_Index;
      Token_Res_266 :
            Token_Index
               := No_Token_Index;
      Token_Pos_267 :
            Token_Index
               := No_Token_Index;
      Token_Res_267 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_25 :
            Token_Index
               := No_Token_Index;
      Tmp_List_25 :
            Free_Parse_List;
      Defer_Pos_197 :
            Token_Index
               := No_Token_Index;
      Defer_Res_197 :
            Bare_Conditional_Transition
               := No_Bare_RFLX_Node;
      List_Pos_25 :
            Token_Index
               := No_Token_Index;
      List_Res_25 :
            Bare_Conditional_Transition_List
               := No_Bare_RFLX_Node;
      Defer_Pos_198 :
            Token_Index
               := No_Token_Index;
      Defer_Res_198 :
            Bare_Transition
               := No_Bare_RFLX_Node;
      Row_Pos_145 :
            Token_Index
               := No_Token_Index;
      Token_Pos_268 :
            Token_Index
               := No_Token_Index;
      Token_Res_268 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_199 :
            Token_Index
               := No_Token_Index;
      Defer_Res_199 :
            Bare_Transition
               := No_Bare_RFLX_Node;
      Token_Pos_269 :
            Token_Index
               := No_Token_Index;
      Token_Res_269 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_200 :
            Token_Index
               := No_Token_Index;
      Defer_Res_200 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Transform_Res_128 :
            Bare_State_Body
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.State_Body_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_128 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_128;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_128;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_142 := Pos;



--  Start opt_code




--  Start row_code

Row_Pos_143 := Row_Pos_142;



--  Start list_code

    List_Pos_23 := No_Token_Index;



Lst_Cpos_23 := Row_Pos_143;
Tmp_List_23 := Get_Parse_List (Parser);

loop
   
Defer_Res_195 :=
   Declaration_Or_Parse_0 (Parser, Lst_Cpos_23);
Defer_Pos_195 := Parser.Current_Pos;


   exit when Defer_Pos_195 = No_Token_Index;

   List_Pos_23 := Defer_Pos_195;
   Lst_Cpos_23 := List_Pos_23;

   Tmp_List_23.Nodes.Append (Defer_Res_195);

      
--  Start tok_code

Token_Res_262 := Lst_Cpos_23;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_262));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_262 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_23 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_23,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_262 := Lst_Cpos_23 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_262 /= No_Token_Index then
          Lst_Cpos_23 := Token_Pos_262;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_23.Nodes.Length;
begin
   List_Res_23 :=
      Allocate_Local_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_143;
      Token_End := (if Lst_Cpos_23 = Row_Pos_143
                    then Row_Pos_143
                    else Lst_Cpos_23 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_143, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_23,
      Kind              => RFLX_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_23,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_23.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_23.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_23);

--  End list_code



if List_Pos_23 /= No_Token_Index then

   Row_Pos_143 := List_Pos_23;

else
   Row_Pos_143 := No_Token_Index;
   goto Exit_Row_143_0;

end if;


--  Start tok_code

Token_Res_263 := Row_Pos_143;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_263));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_263 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_143 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_143,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_263 := Row_Pos_143 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_263 /= No_Token_Index then

   Row_Pos_143 := Token_Pos_263;

else
   Row_Pos_143 := No_Token_Index;
   goto Exit_Row_143_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_143_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_143 = No_Token_Index then

        List_Res_23 :=
           Allocate_Local_Decl_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_23,
            Kind              => RFLX_Local_Decl_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_142 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_23,
            Parser => Parser,
            Count  => 0);


    Row_Pos_143 := Row_Pos_142;


end if;

--  End opt_code



if Row_Pos_143 /= No_Token_Index then

   Row_Pos_142 := Row_Pos_143;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start tok_code

Token_Res_264 := Row_Pos_142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_264));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Begin)
   then
       Token_Pos_264 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_142,
             Expected_Token_Id => RFLX_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_264 := Row_Pos_142 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_264 /= No_Token_Index then

   Row_Pos_142 := Token_Pos_264;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_144 := Row_Pos_142;



--  Start list_code

    List_Pos_24 := No_Token_Index;



Lst_Cpos_24 := Row_Pos_144;
Tmp_List_24 := Get_Parse_List (Parser);

loop
   
Defer_Res_196 :=
   Action_Or_Parse_0 (Parser, Lst_Cpos_24);
Defer_Pos_196 := Parser.Current_Pos;


   exit when Defer_Pos_196 = No_Token_Index;

   List_Pos_24 := Defer_Pos_196;
   Lst_Cpos_24 := List_Pos_24;

   Tmp_List_24.Nodes.Append (Defer_Res_196);

      
--  Start tok_code

Token_Res_265 := Lst_Cpos_24;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_265));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_265 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_24 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_24,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_265 := Lst_Cpos_24 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_265 /= No_Token_Index then
          Lst_Cpos_24 := Token_Pos_265;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_24.Nodes.Length;
begin
   List_Res_24 :=
      Allocate_Statement_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_144;
      Token_End := (if Lst_Cpos_24 = Row_Pos_144
                    then Row_Pos_144
                    else Lst_Cpos_24 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_144, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_24,
      Kind              => RFLX_Statement_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_24,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_24.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_24.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_24);

--  End list_code



if List_Pos_24 /= No_Token_Index then

   Row_Pos_144 := List_Pos_24;

else
   Row_Pos_144 := No_Token_Index;
   goto Exit_Row_144_0;

end if;


--  Start tok_code

Token_Res_266 := Row_Pos_144;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_266));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_266 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_144 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_144,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_266 := Row_Pos_144 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_266 /= No_Token_Index then

   Row_Pos_144 := Token_Pos_266;

else
   Row_Pos_144 := No_Token_Index;
   goto Exit_Row_144_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_144_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_144 = No_Token_Index then

        List_Res_24 :=
           Allocate_Statement_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_24,
            Kind              => RFLX_Statement_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_142 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_24,
            Parser => Parser,
            Count  => 0);


    Row_Pos_144 := Row_Pos_142;


end if;

--  End opt_code



if Row_Pos_144 /= No_Token_Index then

   Row_Pos_142 := Row_Pos_144;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start tok_code

Token_Res_267 := Row_Pos_142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_267));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Transition)
   then
       Token_Pos_267 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_142,
             Expected_Token_Id => RFLX_Transition,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_267 := Row_Pos_142 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_267 /= No_Token_Index then

   Row_Pos_142 := Token_Pos_267;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start list_code

    List_Pos_25 := Row_Pos_142;



Lst_Cpos_25 := Row_Pos_142;
Tmp_List_25 := Get_Parse_List (Parser);

loop
   
Defer_Res_197 :=
   Conditional_Transition_Transform_Parse_0 (Parser, Lst_Cpos_25);
Defer_Pos_197 := Parser.Current_Pos;


   exit when Defer_Pos_197 = No_Token_Index;

   List_Pos_25 := Defer_Pos_197;
   Lst_Cpos_25 := List_Pos_25;

   Tmp_List_25.Nodes.Append (Defer_Res_197);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_25.Nodes.Length;
begin
   List_Res_25 :=
      Allocate_Conditional_Transition_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_142;
      Token_End := (if Lst_Cpos_25 = Row_Pos_142
                    then Row_Pos_142
                    else Lst_Cpos_25 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_142, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_25,
      Kind              => RFLX_Conditional_Transition_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_25,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_25.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_25.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_25);

--  End list_code



if List_Pos_25 /= No_Token_Index then

   Row_Pos_142 := List_Pos_25;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


Defer_Res_198 :=
   Transition_Transform_Parse_0 (Parser, Row_Pos_142);
Defer_Pos_198 := Parser.Current_Pos;



if Defer_Pos_198 /= No_Token_Index then

   Row_Pos_142 := Defer_Pos_198;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_145 := Row_Pos_142;



--  Start tok_code

Token_Res_268 := Row_Pos_145;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_268));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Exception)
   then
       Token_Pos_268 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_145 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_145,
             Expected_Token_Id => RFLX_Exception,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_268 := Row_Pos_145 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_268 /= No_Token_Index then

   Row_Pos_145 := Token_Pos_268;

else
   Row_Pos_145 := No_Token_Index;
   goto Exit_Row_150_0;

end if;


Defer_Res_199 :=
   Transition_Transform_Parse_0 (Parser, Row_Pos_145);
Defer_Pos_199 := Parser.Current_Pos;



if Defer_Pos_199 /= No_Token_Index then

   Row_Pos_145 := Defer_Pos_199;

else
   Row_Pos_145 := No_Token_Index;
   goto Exit_Row_150_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_150_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_145 = No_Token_Index then

        Defer_Res_199 := No_Bare_RFLX_Node;


    Row_Pos_145 := Row_Pos_142;


end if;

--  End opt_code



if Row_Pos_145 /= No_Token_Index then

   Row_Pos_142 := Row_Pos_145;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


--  Start tok_code

Token_Res_269 := Row_Pos_142;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_269));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_End)
   then
       Token_Pos_269 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_142 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_142,
             Expected_Token_Id => RFLX_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_269 := Row_Pos_142 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_269 /= No_Token_Index then

   Row_Pos_142 := Token_Pos_269;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;


Defer_Res_200 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_142);
Defer_Pos_200 := Parser.Current_Pos;



if Defer_Pos_200 /= No_Token_Index then

   Row_Pos_142 := Defer_Pos_200;

else
   Row_Pos_142 := No_Token_Index;
   goto Exit_Row_142_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_142_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_142 /= No_Token_Index then

   Transform_Res_128 := Allocate_State_Body (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_128,
      Kind => RFLX_State_Body,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_142 = Pos
                            then No_Token_Index
                            else Row_Pos_142 - 1));

      Initialize_Fields_For_State_Body
        (Self => Transform_Res_128, State_Body_F_Declarations => List_Res_23, State_Body_F_Actions => List_Res_24, State_Body_F_Conditional_Transitions => List_Res_25, State_Body_F_Final_Transition => Defer_Res_198, State_Body_F_Exception_Transition => Defer_Res_199, State_Body_F_End_Identifier => Defer_Res_200);

         if List_Res_23 /= null and then Is_Incomplete (List_Res_23) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif List_Res_23 /= null and then not Is_Ghost (List_Res_23) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;
         if List_Res_24 /= null and then Is_Incomplete (List_Res_24) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif List_Res_24 /= null and then not Is_Ghost (List_Res_24) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;
         if List_Res_25 /= null and then Is_Incomplete (List_Res_25) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif List_Res_25 /= null and then not Is_Ghost (List_Res_25) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_198 /= null and then Is_Incomplete (Defer_Res_198) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif Defer_Res_198 /= null and then not Is_Ghost (Defer_Res_198) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_199 /= null and then Is_Incomplete (Defer_Res_199) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif Defer_Res_199 /= null and then not Is_Ghost (Defer_Res_199) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_200 /= null and then Is_Incomplete (Defer_Res_200) then
            Transform_Res_128.Last_Attempted_Child := 0;
         elsif Defer_Res_200 /= null and then not Is_Ghost (Defer_Res_200) then
            Transform_Res_128.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.State_Body_Transform_Parse_0_Memo,
      Row_Pos_142 /= No_Token_Index,
      Transform_Res_128,
      Pos,
      Row_Pos_142);


   Parser.Current_Pos := Row_Pos_142;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_128;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end State_Body_Transform_Parse_0;

   


function State_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_State
is
   use Bare_State_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_138 :
            Token_Index
               := No_Token_Index;
      Token_Pos_255 :
            Token_Index
               := No_Token_Index;
      Token_Res_255 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_190 :
            Token_Index
               := No_Token_Index;
      Defer_Res_190 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Row_Pos_139 :
            Token_Index
               := No_Token_Index;
      Token_Pos_256 :
            Token_Index
               := No_Token_Index;
      Token_Res_256 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_191 :
            Token_Index
               := No_Token_Index;
      Defer_Res_191 :
            Bare_Description
               := No_Bare_RFLX_Node;
      Token_Pos_257 :
            Token_Index
               := No_Token_Index;
      Token_Res_257 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_192 :
            Token_Index
               := No_Token_Index;
      Defer_Res_192 :
            Bare_Null_State_Body
               := No_Bare_RFLX_Node;
      Defer_Pos_193 :
            Token_Index
               := No_Token_Index;
      Defer_Res_193 :
            Bare_State_Body
               := No_Bare_RFLX_Node;
      Or_Pos_50 :
            Token_Index
               := No_Token_Index;
      Or_Res_50 :
            Bare_Base_State_Body
               := No_Bare_RFLX_Node;
      Transform_Res_125 :
            Bare_State
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.State_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_125 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_125;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_125;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_138 := Pos;



--  Start tok_code

Token_Res_255 := Row_Pos_138;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_255));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_State)
   then
       Token_Pos_255 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_138 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_138,
             Expected_Token_Id => RFLX_State,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_255 := Row_Pos_138 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_255 /= No_Token_Index then

   Row_Pos_138 := Token_Pos_255;

else
   Row_Pos_138 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


Defer_Res_190 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_138);
Defer_Pos_190 := Parser.Current_Pos;



if Defer_Pos_190 /= No_Token_Index then

   Row_Pos_138 := Defer_Pos_190;

else
   Row_Pos_138 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_139 := Row_Pos_138;



--  Start tok_code

Token_Res_256 := Row_Pos_139;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_256));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_256 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_139 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_139,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_256 := Row_Pos_139 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_256 /= No_Token_Index then

   Row_Pos_139 := Token_Pos_256;

else
   Row_Pos_139 := No_Token_Index;
   goto Exit_Row_139_0;

end if;


Defer_Res_191 :=
   Description_Aspect_Transform_Parse_0 (Parser, Row_Pos_139);
Defer_Pos_191 := Parser.Current_Pos;



if Defer_Pos_191 /= No_Token_Index then

   Row_Pos_139 := Defer_Pos_191;

else
   Row_Pos_139 := No_Token_Index;
   goto Exit_Row_139_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_139_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_139 = No_Token_Index then

        Defer_Res_191 := No_Bare_RFLX_Node;


    Row_Pos_139 := Row_Pos_138;


end if;

--  End opt_code



if Row_Pos_139 /= No_Token_Index then

   Row_Pos_138 := Row_Pos_139;

else
   Row_Pos_138 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


--  Start tok_code

Token_Res_257 := Row_Pos_138;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_257));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_257 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_138 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_138,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_257 := Row_Pos_138 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_257 /= No_Token_Index then

   Row_Pos_138 := Token_Pos_257;

else
   Row_Pos_138 := No_Token_Index;
   goto Exit_Row_138_0;

end if;


--  Start or_code

Or_Pos_50 := No_Token_Index;
Or_Res_50 := No_Bare_RFLX_Node;
    
Defer_Res_192 :=
   Null_State_Body_Transform_Parse_0 (Parser, Row_Pos_138);
Defer_Pos_192 := Parser.Current_Pos;

    if Defer_Pos_192 /= No_Token_Index then
        Or_Pos_50 := Defer_Pos_192;
        Or_Res_50 := Defer_Res_192;
        goto Exit_Or_50;
    end if;
    
Defer_Res_193 :=
   State_Body_Transform_Parse_0 (Parser, Row_Pos_138);
Defer_Pos_193 := Parser.Current_Pos;

    if Defer_Pos_193 /= No_Token_Index then
        Or_Pos_50 := Defer_Pos_193;
        Or_Res_50 := Defer_Res_193;
        goto Exit_Or_50;
    end if;
<<Exit_Or_50>>

--  End or_code



if Or_Pos_50 /= No_Token_Index then

   Row_Pos_138 := Or_Pos_50;

else
   Row_Pos_138 := No_Token_Index;
   goto Exit_Row_138_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_138_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_138 /= No_Token_Index then

   Transform_Res_125 := Allocate_State (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_125,
      Kind => RFLX_State,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_138 = Pos
                            then No_Token_Index
                            else Row_Pos_138 - 1));

      Initialize_Fields_For_State
        (Self => Transform_Res_125, State_F_Identifier => Defer_Res_190, State_F_Description => Defer_Res_191, State_F_Body => Or_Res_50);

         if Defer_Res_190 /= null and then Is_Incomplete (Defer_Res_190) then
            Transform_Res_125.Last_Attempted_Child := 0;
         elsif Defer_Res_190 /= null and then not Is_Ghost (Defer_Res_190) then
            Transform_Res_125.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_191 /= null and then Is_Incomplete (Defer_Res_191) then
            Transform_Res_125.Last_Attempted_Child := 0;
         elsif Defer_Res_191 /= null and then not Is_Ghost (Defer_Res_191) then
            Transform_Res_125.Last_Attempted_Child := -1;
         end if;
         if Or_Res_50 /= null and then Is_Incomplete (Or_Res_50) then
            Transform_Res_125.Last_Attempted_Child := 0;
         elsif Or_Res_50 /= null and then not Is_Ghost (Or_Res_50) then
            Transform_Res_125.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.State_Transform_Parse_0_Memo,
      Row_Pos_138 /= No_Token_Index,
      Transform_Res_125,
      Pos,
      Row_Pos_138);


   Parser.Current_Pos := Row_Pos_138;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_125;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end State_Transform_Parse_0;

   


function Session_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Session_Decl
is
   use Bare_Session_Decl_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_126 :
            Token_Index
               := No_Token_Index;
      Token_Pos_225 :
            Token_Index
               := No_Token_Index;
      Token_Res_225 :
            Token_Index
               := No_Token_Index;
      Row_Pos_127 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_19 :
            Token_Index
               := No_Token_Index;
      Tmp_List_19 :
            Free_Parse_List;
      Defer_Pos_168 :
            Token_Index
               := No_Token_Index;
      Defer_Res_168 :
            Bare_Formal_Decl
               := No_Bare_RFLX_Node;
      Token_Pos_226 :
            Token_Index
               := No_Token_Index;
      Token_Res_226 :
            Token_Index
               := No_Token_Index;
      List_Pos_19 :
            Token_Index
               := No_Token_Index;
      List_Res_19 :
            Bare_Formal_Decl_List
               := No_Bare_RFLX_Node;
      Token_Pos_227 :
            Token_Index
               := No_Token_Index;
      Token_Res_227 :
            Token_Index
               := No_Token_Index;
      Token_Pos_228 :
            Token_Index
               := No_Token_Index;
      Token_Res_228 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_169 :
            Token_Index
               := No_Token_Index;
      Defer_Res_169 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Defer_Pos_170 :
            Token_Index
               := No_Token_Index;
      Defer_Res_170 :
            Bare_Session_Aspects
               := No_Bare_RFLX_Node;
      Token_Pos_229 :
            Token_Index
               := No_Token_Index;
      Token_Res_229 :
            Token_Index
               := No_Token_Index;
      Row_Pos_128 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_20 :
            Token_Index
               := No_Token_Index;
      Tmp_List_20 :
            Free_Parse_List;
      Defer_Pos_171 :
            Token_Index
               := No_Token_Index;
      Defer_Res_171 :
            Bare_Local_Decl
               := No_Bare_RFLX_Node;
      Token_Pos_230 :
            Token_Index
               := No_Token_Index;
      Token_Res_230 :
            Token_Index
               := No_Token_Index;
      List_Pos_20 :
            Token_Index
               := No_Token_Index;
      List_Res_20 :
            Bare_Local_Decl_List
               := No_Bare_RFLX_Node;
      Token_Pos_231 :
            Token_Index
               := No_Token_Index;
      Token_Res_231 :
            Token_Index
               := No_Token_Index;
      Token_Pos_232 :
            Token_Index
               := No_Token_Index;
      Token_Res_232 :
            Token_Index
               := No_Token_Index;
      Row_Pos_129 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_21 :
            Token_Index
               := No_Token_Index;
      Tmp_List_21 :
            Free_Parse_List;
      Defer_Pos_172 :
            Token_Index
               := No_Token_Index;
      Defer_Res_172 :
            Bare_State
               := No_Bare_RFLX_Node;
      Token_Pos_233 :
            Token_Index
               := No_Token_Index;
      Token_Res_233 :
            Token_Index
               := No_Token_Index;
      List_Pos_21 :
            Token_Index
               := No_Token_Index;
      List_Res_21 :
            Bare_State_List
               := No_Bare_RFLX_Node;
      Token_Pos_234 :
            Token_Index
               := No_Token_Index;
      Token_Res_234 :
            Token_Index
               := No_Token_Index;
      Token_Pos_235 :
            Token_Index
               := No_Token_Index;
      Token_Res_235 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_173 :
            Token_Index
               := No_Token_Index;
      Defer_Res_173 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Transform_Res_117 :
            Bare_Session_Decl
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Session_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_117 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_117;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_117;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_126 := Pos;



--  Start tok_code

Token_Res_225 := Row_Pos_126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_225));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Generic)
   then
       Token_Pos_225 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_126,
             Expected_Token_Id => RFLX_Generic,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_225 := Row_Pos_126 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_225 /= No_Token_Index then

   Row_Pos_126 := Token_Pos_225;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_127 := Row_Pos_126;



--  Start list_code

    List_Pos_19 := No_Token_Index;



Lst_Cpos_19 := Row_Pos_127;
Tmp_List_19 := Get_Parse_List (Parser);

loop
   
Defer_Res_168 :=
   Session_Parameter_Or_Parse_0 (Parser, Lst_Cpos_19);
Defer_Pos_168 := Parser.Current_Pos;


   exit when Defer_Pos_168 = No_Token_Index;

   List_Pos_19 := Defer_Pos_168;
   Lst_Cpos_19 := List_Pos_19;

   Tmp_List_19.Nodes.Append (Defer_Res_168);

      
--  Start tok_code

Token_Res_226 := Lst_Cpos_19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_226));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_226 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_19,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_226 := Lst_Cpos_19 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_226 /= No_Token_Index then
          Lst_Cpos_19 := Token_Pos_226;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_19.Nodes.Length;
begin
   List_Res_19 :=
      Allocate_Formal_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_127;
      Token_End := (if Lst_Cpos_19 = Row_Pos_127
                    then Row_Pos_127
                    else Lst_Cpos_19 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_127, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_19,
      Kind              => RFLX_Formal_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_19,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_19.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_19.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_19);

--  End list_code



if List_Pos_19 /= No_Token_Index then

   Row_Pos_127 := List_Pos_19;

else
   Row_Pos_127 := No_Token_Index;
   goto Exit_Row_127_0;

end if;


--  Start tok_code

Token_Res_227 := Row_Pos_127;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_227));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_227 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_127 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_127,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_227 := Row_Pos_127 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_227 /= No_Token_Index then

   Row_Pos_127 := Token_Pos_227;

else
   Row_Pos_127 := No_Token_Index;
   goto Exit_Row_127_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_127_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_127 = No_Token_Index then

        List_Res_19 :=
           Allocate_Formal_Decl_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_19,
            Kind              => RFLX_Formal_Decl_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_126 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_19,
            Parser => Parser,
            Count  => 0);


    Row_Pos_127 := Row_Pos_126;


end if;

--  End opt_code



if Row_Pos_127 /= No_Token_Index then

   Row_Pos_126 := Row_Pos_127;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start tok_code

Token_Res_228 := Row_Pos_126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_228));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Session)
   then
       Token_Pos_228 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_126,
             Expected_Token_Id => RFLX_Session,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_228 := Row_Pos_126 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_228 /= No_Token_Index then

   Row_Pos_126 := Token_Pos_228;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


Defer_Res_169 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_126);
Defer_Pos_169 := Parser.Current_Pos;



if Defer_Pos_169 /= No_Token_Index then

   Row_Pos_126 := Defer_Pos_169;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


Defer_Res_170 :=
   Session_Aspects_Transform_Parse_0 (Parser, Row_Pos_126);
Defer_Pos_170 := Parser.Current_Pos;



if Defer_Pos_170 /= No_Token_Index then

   Row_Pos_126 := Defer_Pos_170;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start tok_code

Token_Res_229 := Row_Pos_126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_229));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_229 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_126,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_229 := Row_Pos_126 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_229 /= No_Token_Index then

   Row_Pos_126 := Token_Pos_229;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_128 := Row_Pos_126;



--  Start list_code

    List_Pos_20 := No_Token_Index;



Lst_Cpos_20 := Row_Pos_128;
Tmp_List_20 := Get_Parse_List (Parser);

loop
   
Defer_Res_171 :=
   Declaration_Or_Parse_0 (Parser, Lst_Cpos_20);
Defer_Pos_171 := Parser.Current_Pos;


   exit when Defer_Pos_171 = No_Token_Index;

   List_Pos_20 := Defer_Pos_171;
   Lst_Cpos_20 := List_Pos_20;

   Tmp_List_20.Nodes.Append (Defer_Res_171);

      
--  Start tok_code

Token_Res_230 := Lst_Cpos_20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_230));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_230 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_20,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_230 := Lst_Cpos_20 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_230 /= No_Token_Index then
          Lst_Cpos_20 := Token_Pos_230;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_20.Nodes.Length;
begin
   List_Res_20 :=
      Allocate_Local_Decl_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_128;
      Token_End := (if Lst_Cpos_20 = Row_Pos_128
                    then Row_Pos_128
                    else Lst_Cpos_20 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_128, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_20,
      Kind              => RFLX_Local_Decl_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_20,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_20.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_20.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_20);

--  End list_code



if List_Pos_20 /= No_Token_Index then

   Row_Pos_128 := List_Pos_20;

else
   Row_Pos_128 := No_Token_Index;
   goto Exit_Row_133_0;

end if;


--  Start tok_code

Token_Res_231 := Row_Pos_128;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_231));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_231 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_128 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_128,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_231 := Row_Pos_128 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_231 /= No_Token_Index then

   Row_Pos_128 := Token_Pos_231;

else
   Row_Pos_128 := No_Token_Index;
   goto Exit_Row_133_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_133_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_128 = No_Token_Index then

        List_Res_20 :=
           Allocate_Local_Decl_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_20,
            Kind              => RFLX_Local_Decl_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_126 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_20,
            Parser => Parser,
            Count  => 0);


    Row_Pos_128 := Row_Pos_126;


end if;

--  End opt_code



if Row_Pos_128 /= No_Token_Index then

   Row_Pos_126 := Row_Pos_128;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start tok_code

Token_Res_232 := Row_Pos_126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_232));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Begin)
   then
       Token_Pos_232 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_126,
             Expected_Token_Id => RFLX_Begin,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_232 := Row_Pos_126 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_232 /= No_Token_Index then

   Row_Pos_126 := Token_Pos_232;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start opt_code




--  Start row_code

Row_Pos_129 := Row_Pos_126;



--  Start list_code

    List_Pos_21 := No_Token_Index;



Lst_Cpos_21 := Row_Pos_129;
Tmp_List_21 := Get_Parse_List (Parser);

loop
   
Defer_Res_172 :=
   State_Transform_Parse_0 (Parser, Lst_Cpos_21);
Defer_Pos_172 := Parser.Current_Pos;


   exit when Defer_Pos_172 = No_Token_Index;

   List_Pos_21 := Defer_Pos_172;
   Lst_Cpos_21 := List_Pos_21;

   Tmp_List_21.Nodes.Append (Defer_Res_172);

      
--  Start tok_code

Token_Res_233 := Lst_Cpos_21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_233));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_233 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_21,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_233 := Lst_Cpos_21 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_233 /= No_Token_Index then
          Lst_Cpos_21 := Token_Pos_233;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_21.Nodes.Length;
begin
   List_Res_21 :=
      Allocate_State_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_129;
      Token_End := (if Lst_Cpos_21 = Row_Pos_129
                    then Row_Pos_129
                    else Lst_Cpos_21 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_129, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_21,
      Kind              => RFLX_State_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_21,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_21.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_21.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_21);

--  End list_code



if List_Pos_21 /= No_Token_Index then

   Row_Pos_129 := List_Pos_21;

else
   Row_Pos_129 := No_Token_Index;
   goto Exit_Row_137_0;

end if;


--  Start tok_code

Token_Res_234 := Row_Pos_129;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_234));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_234 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_129 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_129,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_234 := Row_Pos_129 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_234 /= No_Token_Index then

   Row_Pos_129 := Token_Pos_234;

else
   Row_Pos_129 := No_Token_Index;
   goto Exit_Row_137_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_137_0>>
pragma Warnings (On, "referenced");

--  End row_code


if Row_Pos_129 = No_Token_Index then

        List_Res_21 :=
           Allocate_State_List (Parser.Mem_Pool);
         Initialize
           (Self              => List_Res_21,
            Kind              => RFLX_State_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_126 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => List_Res_21,
            Parser => Parser,
            Count  => 0);


    Row_Pos_129 := Row_Pos_126;


end if;

--  End opt_code



if Row_Pos_129 /= No_Token_Index then

   Row_Pos_126 := Row_Pos_129;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


--  Start tok_code

Token_Res_235 := Row_Pos_126;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_235));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_End)
   then
       Token_Pos_235 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_126 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_126,
             Expected_Token_Id => RFLX_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_235 := Row_Pos_126 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_235 /= No_Token_Index then

   Row_Pos_126 := Token_Pos_235;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;


Defer_Res_173 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_126);
Defer_Pos_173 := Parser.Current_Pos;



if Defer_Pos_173 /= No_Token_Index then

   Row_Pos_126 := Defer_Pos_173;

else
   Row_Pos_126 := No_Token_Index;
   goto Exit_Row_126_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_126_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_126 /= No_Token_Index then

   Transform_Res_117 := Allocate_Session_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_117,
      Kind => RFLX_Session_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_126 = Pos
                            then No_Token_Index
                            else Row_Pos_126 - 1));

      Initialize_Fields_For_Session_Decl
        (Self => Transform_Res_117, Session_Decl_F_Parameters => List_Res_19, Session_Decl_F_Identifier => Defer_Res_169, Session_Decl_F_Aspects => Defer_Res_170, Session_Decl_F_Declarations => List_Res_20, Session_Decl_F_States => List_Res_21, Session_Decl_F_End_Identifier => Defer_Res_173);

         if List_Res_19 /= null and then Is_Incomplete (List_Res_19) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif List_Res_19 /= null and then not Is_Ghost (List_Res_19) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_169 /= null and then Is_Incomplete (Defer_Res_169) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif Defer_Res_169 /= null and then not Is_Ghost (Defer_Res_169) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_170 /= null and then Is_Incomplete (Defer_Res_170) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif Defer_Res_170 /= null and then not Is_Ghost (Defer_Res_170) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;
         if List_Res_20 /= null and then Is_Incomplete (List_Res_20) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif List_Res_20 /= null and then not Is_Ghost (List_Res_20) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;
         if List_Res_21 /= null and then Is_Incomplete (List_Res_21) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif List_Res_21 /= null and then not Is_Ghost (List_Res_21) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_173 /= null and then Is_Incomplete (Defer_Res_173) then
            Transform_Res_117.Last_Attempted_Child := 0;
         elsif Defer_Res_173 /= null and then not Is_Ghost (Defer_Res_173) then
            Transform_Res_117.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Session_Declaration_Transform_Parse_0_Memo,
      Row_Pos_126 /= No_Token_Index,
      Transform_Res_117,
      Pos,
      Row_Pos_126);


   Parser.Current_Pos := Row_Pos_126;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_117;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Session_Declaration_Transform_Parse_0;

   


function Basic_Declaration_Or_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration
is
   use Bare_Declaration_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_109 :
            Token_Index
               := No_Token_Index;
      Defer_Res_109 :
            Bare_Type_Decl
               := No_Bare_RFLX_Node;
      Defer_Pos_110 :
            Token_Index
               := No_Token_Index;
      Defer_Res_110 :
            Bare_Refinement_Decl
               := No_Bare_RFLX_Node;
      Defer_Pos_111 :
            Token_Index
               := No_Token_Index;
      Defer_Res_111 :
            Bare_Session_Decl
               := No_Bare_RFLX_Node;
      Or_Pos_37 :
            Token_Index
               := No_Token_Index;
      Or_Res_37 :
            Bare_Declaration
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Basic_Declaration_Or_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res_37 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_37;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Or_Res_37;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start or_code

Or_Pos_37 := No_Token_Index;
Or_Res_37 := No_Bare_RFLX_Node;
    
Defer_Res_109 :=
   Type_Declaration_Transform_Parse_0 (Parser, Pos);
Defer_Pos_109 := Parser.Current_Pos;

    if Defer_Pos_109 /= No_Token_Index then
        Or_Pos_37 := Defer_Pos_109;
        Or_Res_37 := Defer_Res_109;
        goto Exit_Or_37;
    end if;
    
Defer_Res_110 :=
   Type_Refinement_Transform_Parse_0 (Parser, Pos);
Defer_Pos_110 := Parser.Current_Pos;

    if Defer_Pos_110 /= No_Token_Index then
        Or_Pos_37 := Defer_Pos_110;
        Or_Res_37 := Defer_Res_110;
        goto Exit_Or_37;
    end if;
    
Defer_Res_111 :=
   Session_Declaration_Transform_Parse_0 (Parser, Pos);
Defer_Pos_111 := Parser.Current_Pos;

    if Defer_Pos_111 /= No_Token_Index then
        Or_Pos_37 := Defer_Pos_111;
        Or_Res_37 := Defer_Res_111;
        goto Exit_Or_37;
    end if;
<<Exit_Or_37>>

--  End or_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Basic_Declaration_Or_Parse_0_Memo,
      Or_Pos_37 /= No_Token_Index,
      Or_Res_37,
      Pos,
      Or_Pos_37);


   Parser.Current_Pos := Or_Pos_37;

   Exit_Call (Parser, Call_Depth);
   return Or_Res_37;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Basic_Declaration_Or_Parse_0;

   


function Basic_Declarations_Extract_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declaration_List
is
   use Bare_Declaration_List_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_151 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos_26 :
            Token_Index
               := No_Token_Index;
      Tmp_List_26 :
            Free_Parse_List;
      Defer_Pos_207 :
            Token_Index
               := No_Token_Index;
      Defer_Res_207 :
            Bare_Declaration
               := No_Bare_RFLX_Node;
      Token_Pos_275 :
            Token_Index
               := No_Token_Index;
      Token_Res_275 :
            Token_Index
               := No_Token_Index;
      List_Pos_26 :
            Token_Index
               := No_Token_Index;
      List_Res_26 :
            Bare_Declaration_List
               := No_Bare_RFLX_Node;
      Token_Pos_276 :
            Token_Index
               := No_Token_Index;
      Token_Res_276 :
            Token_Index
               := No_Token_Index;


   M : Memo_Entry := Get (Parser.Private_Part.Basic_Declarations_Extract_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_26 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return List_Res_26;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return List_Res_26;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start row_code

Row_Pos_151 := Pos;



--  Start list_code

    List_Pos_26 := No_Token_Index;



Lst_Cpos_26 := Row_Pos_151;
Tmp_List_26 := Get_Parse_List (Parser);

loop
   
Defer_Res_207 :=
   Basic_Declaration_Or_Parse_0 (Parser, Lst_Cpos_26);
Defer_Pos_207 := Parser.Current_Pos;


   exit when Defer_Pos_207 = No_Token_Index;

   List_Pos_26 := Defer_Pos_207;
   Lst_Cpos_26 := List_Pos_26;

   Tmp_List_26.Nodes.Append (Defer_Res_207);

      
--  Start tok_code

Token_Res_275 := Lst_Cpos_26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_275));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_275 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos_26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos_26,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_275 := Lst_Cpos_26 + 1;
   end if;
end;

--  End tok_code

      if Token_Pos_275 /= No_Token_Index then
          Lst_Cpos_26 := Token_Pos_275;
      else
         exit;
      end if;

end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_26.Nodes.Length;
begin
   List_Res_26 :=
      Allocate_Declaration_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos_151;
      Token_End := (if Lst_Cpos_26 = Row_Pos_151
                    then Row_Pos_151
                    else Lst_Cpos_26 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos_151, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_26,
      Kind              => RFLX_Declaration_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_26,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_26.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_26.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_26);

--  End list_code



if List_Pos_26 /= No_Token_Index then

   Row_Pos_151 := List_Pos_26;

else
   Row_Pos_151 := No_Token_Index;
   goto Exit_Row_151_0;

end if;


--  Start tok_code

Token_Res_276 := Row_Pos_151;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_276));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_276 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_151 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_151,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_276 := Row_Pos_151 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_276 /= No_Token_Index then

   Row_Pos_151 := Token_Pos_276;

else
   Row_Pos_151 := No_Token_Index;
   goto Exit_Row_151_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_151_0>>
pragma Warnings (On, "referenced");

--  End row_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Basic_Declarations_Extract_Parse_0_Memo,
      Row_Pos_151 /= No_Token_Index,
      List_Res_26,
      Pos,
      Row_Pos_151);


   Parser.Current_Pos := Row_Pos_151;

   Exit_Call (Parser, Call_Depth);
   return List_Res_26;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Basic_Declarations_Extract_Parse_0;

   


function Context_Item_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item
is
   use Bare_Context_Item_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_152 :
            Token_Index
               := No_Token_Index;
      Token_Pos_277 :
            Token_Index
               := No_Token_Index;
      Token_Res_277 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_209 :
            Token_Index
               := No_Token_Index;
      Defer_Res_209 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_278 :
            Token_Index
               := No_Token_Index;
      Token_Res_278 :
            Token_Index
               := No_Token_Index;
      Transform_Res_131 :
            Bare_Context_Item
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Context_Item_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_131 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_131;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_131;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_152 := Pos;



--  Start tok_code

Token_Res_277 := Row_Pos_152;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_277));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_With)
   then
       Token_Pos_277 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_152 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_152,
             Expected_Token_Id => RFLX_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_277 := Row_Pos_152 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_277 /= No_Token_Index then

   Row_Pos_152 := Token_Pos_277;

else
   Row_Pos_152 := No_Token_Index;
   goto Exit_Row_152_0;

end if;


Defer_Res_209 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_152);
Defer_Pos_209 := Parser.Current_Pos;



if Defer_Pos_209 /= No_Token_Index then

   Row_Pos_152 := Defer_Pos_209;

else
   Row_Pos_152 := No_Token_Index;
   goto Exit_Row_152_0;

end if;


--  Start tok_code

Token_Res_278 := Row_Pos_152;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_278));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_278 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_152 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_152,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_278 := Row_Pos_152 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_278 /= No_Token_Index then

   Row_Pos_152 := Token_Pos_278;

else
   Row_Pos_152 := No_Token_Index;
   goto Exit_Row_152_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_152_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_152 /= No_Token_Index then

   Transform_Res_131 := Allocate_Context_Item (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_131,
      Kind => RFLX_Context_Item,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_152 = Pos
                            then No_Token_Index
                            else Row_Pos_152 - 1));

      Initialize_Fields_For_Context_Item
        (Self => Transform_Res_131, Context_Item_F_Item => Defer_Res_209);

         if Defer_Res_209 /= null and then Is_Incomplete (Defer_Res_209) then
            Transform_Res_131.Last_Attempted_Child := 0;
         elsif Defer_Res_209 /= null and then not Is_Ghost (Defer_Res_209) then
            Transform_Res_131.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Context_Item_Transform_Parse_0_Memo,
      Row_Pos_152 /= No_Token_Index,
      Transform_Res_131,
      Pos,
      Row_Pos_152);


   Parser.Current_Pos := Row_Pos_152;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_131;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Context_Item_Transform_Parse_0;

   


function Context_Clause_List_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Context_Item_List
is
   use Bare_Context_Item_List_Memos;

   Call_Depth : aliased Natural;

      Lst_Cpos_27 :
            Token_Index
               := No_Token_Index;
      Tmp_List_27 :
            Free_Parse_List;
      Defer_Pos_208 :
            Token_Index
               := No_Token_Index;
      Defer_Res_208 :
            Bare_Context_Item
               := No_Bare_RFLX_Node;
      List_Pos_27 :
            Token_Index
               := No_Token_Index;
      List_Res_27 :
            Bare_Context_Item_List
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Context_Clause_List_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res_27 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return List_Res_27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return List_Res_27;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start list_code

    List_Pos_27 := Pos;



Lst_Cpos_27 := Pos;
Tmp_List_27 := Get_Parse_List (Parser);

loop
   
Defer_Res_208 :=
   Context_Item_Transform_Parse_0 (Parser, Lst_Cpos_27);
Defer_Pos_208 := Parser.Current_Pos;


   exit when Defer_Pos_208 = No_Token_Index;

   List_Pos_27 := Defer_Pos_208;
   Lst_Cpos_27 := List_Pos_27;

   Tmp_List_27.Nodes.Append (Defer_Res_208);


end loop;

declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List_27.Nodes.Length;
begin
   List_Res_27 :=
      Allocate_Context_Item_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos_27 = Pos
                    then Pos
                    else Lst_Cpos_27 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res_27,
      Kind              => RFLX_Context_Item_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res_27,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_RFLX_Node_Vectors.Vector renames
         Tmp_List_27.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res_27.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List_27);

--  End list_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Context_Clause_List_Parse_0_Memo,
      List_Pos_27 /= No_Token_Index,
      List_Res_27,
      Pos,
      List_Pos_27);


   Parser.Current_Pos := List_Pos_27;

   Exit_Call (Parser, Call_Depth);
   return List_Res_27;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Context_Clause_List_Parse_0;

   


function Package_Declaration_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Node
is
   use Bare_Package_Node_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_154 :
            Token_Index
               := No_Token_Index;
      Token_Pos_279 :
            Token_Index
               := No_Token_Index;
      Token_Res_279 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_213 :
            Token_Index
               := No_Token_Index;
      Defer_Res_213 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_280 :
            Token_Index
               := No_Token_Index;
      Token_Res_280 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_214 :
            Token_Index
               := No_Token_Index;
      Defer_Res_214 :
            Bare_Declaration_List
               := No_Bare_RFLX_Node;
      Token_Pos_281 :
            Token_Index
               := No_Token_Index;
      Token_Res_281 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_215 :
            Token_Index
               := No_Token_Index;
      Defer_Res_215 :
            Bare_UnqualifiedID
               := No_Bare_RFLX_Node;
      Token_Pos_282 :
            Token_Index
               := No_Token_Index;
      Token_Res_282 :
            Token_Index
               := No_Token_Index;
      Transform_Res_133 :
            Bare_Package_Node
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Package_Declaration_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_133 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_133;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_133;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_154 := Pos;



--  Start tok_code

Token_Res_279 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_279));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Package)
   then
       Token_Pos_279 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => RFLX_Package,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_279 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_279 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_279;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


Defer_Res_213 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_154);
Defer_Pos_213 := Parser.Current_Pos;



if Defer_Pos_213 /= No_Token_Index then

   Row_Pos_154 := Defer_Pos_213;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


--  Start tok_code

Token_Res_280 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_280));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Is)
   then
       Token_Pos_280 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => RFLX_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_280 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_280 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_280;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


--  Start opt_code




Defer_Res_214 :=
   Basic_Declarations_Extract_Parse_0 (Parser, Row_Pos_154);
Defer_Pos_214 := Parser.Current_Pos;


if Defer_Pos_214 = No_Token_Index then

        Defer_Res_214 :=
           Allocate_Declaration_List (Parser.Mem_Pool);
         Initialize
           (Self              => Defer_Res_214,
            Kind              => RFLX_Declaration_List,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos_154 - 1,
            Token_End_Index   => No_Token_Index);
         Initialize_List
           (Self   => Defer_Res_214,
            Parser => Parser,
            Count  => 0);


    Defer_Pos_214 := Row_Pos_154;


end if;

--  End opt_code



if Defer_Pos_214 /= No_Token_Index then

   Row_Pos_154 := Defer_Pos_214;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


--  Start tok_code

Token_Res_281 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_281));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_End)
   then
       Token_Pos_281 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => RFLX_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_281 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_281 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_281;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


Defer_Res_215 :=
   Unqualified_Identifier_Transform_Parse_0 (Parser, Row_Pos_154);
Defer_Pos_215 := Parser.Current_Pos;



if Defer_Pos_215 /= No_Token_Index then

   Row_Pos_154 := Defer_Pos_215;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;


--  Start tok_code

Token_Res_282 := Row_Pos_154;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res_282));
begin
   if
      T.Kind /= From_Token_Kind (RFLX_Semicolon)
   then
       Token_Pos_282 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos_154 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos_154,
             Expected_Token_Id => RFLX_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos_282 := Row_Pos_154 + 1;
   end if;
end;

--  End tok_code



if Token_Pos_282 /= No_Token_Index then

   Row_Pos_154 := Token_Pos_282;

else
   Row_Pos_154 := No_Token_Index;
   goto Exit_Row_154_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_154_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_154 /= No_Token_Index then

   Transform_Res_133 := Allocate_Package_Node (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_133,
      Kind => RFLX_Package_Node,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_154 = Pos
                            then No_Token_Index
                            else Row_Pos_154 - 1));

      Initialize_Fields_For_Package_Node
        (Self => Transform_Res_133, Package_Node_F_Identifier => Defer_Res_213, Package_Node_F_Declarations => Defer_Res_214, Package_Node_F_End_Identifier => Defer_Res_215);

         if Defer_Res_213 /= null and then Is_Incomplete (Defer_Res_213) then
            Transform_Res_133.Last_Attempted_Child := 0;
         elsif Defer_Res_213 /= null and then not Is_Ghost (Defer_Res_213) then
            Transform_Res_133.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_214 /= null and then Is_Incomplete (Defer_Res_214) then
            Transform_Res_133.Last_Attempted_Child := 0;
         elsif Defer_Res_214 /= null and then not Is_Ghost (Defer_Res_214) then
            Transform_Res_133.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_215 /= null and then Is_Incomplete (Defer_Res_215) then
            Transform_Res_133.Last_Attempted_Child := 0;
         elsif Defer_Res_215 /= null and then not Is_Ghost (Defer_Res_215) then
            Transform_Res_133.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Package_Declaration_Transform_Parse_0_Memo,
      Row_Pos_154 /= No_Token_Index,
      Transform_Res_133,
      Pos,
      Row_Pos_154);


   Parser.Current_Pos := Row_Pos_154;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_133;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Package_Declaration_Transform_Parse_0;

   


function Specification_Transform_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification
is
   use Bare_Specification_Memos;

   Call_Depth : aliased Natural;

      Row_Pos_153 :
            Token_Index
               := No_Token_Index;
      Defer_Pos_211 :
            Token_Index
               := No_Token_Index;
      Defer_Res_211 :
            Bare_Context_Item_List
               := No_Bare_RFLX_Node;
      Defer_Pos_212 :
            Token_Index
               := No_Token_Index;
      Defer_Res_212 :
            Bare_Package_Node
               := No_Bare_RFLX_Node;
      Transform_Res_132 :
            Bare_Specification
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Specification_Transform_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res_132 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_132;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Transform_Res_132;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start transform_code


--  Start row_code

Row_Pos_153 := Pos;



Defer_Res_211 :=
   Context_Clause_List_Parse_0 (Parser, Row_Pos_153);
Defer_Pos_211 := Parser.Current_Pos;



if Defer_Pos_211 /= No_Token_Index then

   Row_Pos_153 := Defer_Pos_211;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_153_0;

end if;


Defer_Res_212 :=
   Package_Declaration_Transform_Parse_0 (Parser, Row_Pos_153);
Defer_Pos_212 := Parser.Current_Pos;



if Defer_Pos_212 /= No_Token_Index then

   Row_Pos_153 := Defer_Pos_212;

else
   Row_Pos_153 := No_Token_Index;
   goto Exit_Row_153_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row_153_0>>
pragma Warnings (On, "referenced");

--  End row_code



if Row_Pos_153 /= No_Token_Index then

   Transform_Res_132 := Allocate_Specification (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res_132,
      Kind => RFLX_Specification,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos_153 = Pos
                            then No_Token_Index
                            else Row_Pos_153 - 1));

      Initialize_Fields_For_Specification
        (Self => Transform_Res_132, Specification_F_Context_Clause => Defer_Res_211, Specification_F_Package_Declaration => Defer_Res_212);

         if Defer_Res_211 /= null and then Is_Incomplete (Defer_Res_211) then
            Transform_Res_132.Last_Attempted_Child := 0;
         elsif Defer_Res_211 /= null and then not Is_Ghost (Defer_Res_211) then
            Transform_Res_132.Last_Attempted_Child := -1;
         end if;
         if Defer_Res_212 /= null and then Is_Incomplete (Defer_Res_212) then
            Transform_Res_132.Last_Attempted_Child := 0;
         elsif Defer_Res_212 /= null and then not Is_Ghost (Defer_Res_212) then
            Transform_Res_132.Last_Attempted_Child := -1;
         end if;


end if;

--  End transform_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Specification_Transform_Parse_0_Memo,
      Row_Pos_153 /= No_Token_Index,
      Transform_Res_132,
      Pos,
      Row_Pos_153);


   Parser.Current_Pos := Row_Pos_153;

   Exit_Call (Parser, Call_Depth);
   return Transform_Res_132;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Specification_Transform_Parse_0;

   


function Main_Rule_Opt_Parse_0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Specification
is
   use Bare_Specification_Memos;

   Call_Depth : aliased Natural;

      Defer_Pos_210 :
            Token_Index
               := No_Token_Index;
      Defer_Res_210 :
            Bare_Specification
               := No_Bare_RFLX_Node;


   M : Memo_Entry := Get (Parser.Private_Part.Main_Rule_Opt_Parse_0_Memo, Pos);

begin
   Enter_Call (Parser, Call_Depth'Access);

   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Defer_Res_210 := M.Instance;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_210;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      Exit_Call (Parser, Call_Depth);
      return Defer_Res_210;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  Start opt_code




Defer_Res_210 :=
   Specification_Transform_Parse_0 (Parser, Pos);
Defer_Pos_210 := Parser.Current_Pos;


if Defer_Pos_210 = No_Token_Index then

        Defer_Res_210 := No_Bare_RFLX_Node;


    Defer_Pos_210 := Pos;


end if;

--  End opt_code


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (Parser.Private_Part.Main_Rule_Opt_Parse_0_Memo,
      Defer_Pos_210 /= No_Token_Index,
      Defer_Res_210,
      Pos,
      Defer_Pos_210);


   Parser.Current_Pos := Defer_Pos_210;

   Exit_Call (Parser, Call_Depth);
   return Defer_Res_210;

exception
   when others =>
      Exit_Call (Parser, Call_Depth);
      raise;
end Main_Rule_Opt_Parse_0;


   -----------
   -- Reset --
   -----------

   procedure Reset (Parser : in out Parser_Type) is
      New_Parser : Parser_Type;
      --  We create this new parser instance to leverage creation of default
      --  values, so as to not repeat them.
   begin
      --  We just keep the private part, to not have to reallocate it
      New_Parser.Private_Part := Parser.Private_Part;

      --  And then reset everything else
      Parser := New_Parser;

      --  Reset the memo tables in the private part
         Bare_Statement_Memos.Clear
           (Parser.Private_Part.Action_Or_Parse_0_Memo);
         Bare_Aspect_Memos.Clear
           (Parser.Private_Part.Aspect_Transform_Parse_0_Memo);
         Bare_Assignment_Memos.Clear
           (Parser.Private_Part.Assignment_Statement_Transform_Parse_0_Memo);
         Bare_Statement_Memos.Clear
           (Parser.Private_Part.Attribute_Statement_Or_Parse_0_Memo);
         Bare_Declaration_Memos.Clear
           (Parser.Private_Part.Basic_Declaration_Or_Parse_0_Memo);
         Bare_Declaration_List_Memos.Clear
           (Parser.Private_Part.Basic_Declarations_Extract_Parse_0_Memo);
         Bare_Byte_Order_Aspect_Memos.Clear
           (Parser.Private_Part.Byte_Order_Aspect_Transform_Parse_2_Memo);
         Bare_Call_Memos.Clear
           (Parser.Private_Part.Call_Transform_Parse_0_Memo);
         Bare_Formal_Channel_Decl_Memos.Clear
           (Parser.Private_Part.Channel_Declaration_Transform_Parse_2_Memo);
         Bare_Checksum_Aspect_Memos.Clear
           (Parser.Private_Part.Checksum_Aspect_Transform_Parse_0_Memo);
         Bare_Checksum_Assoc_Memos.Clear
           (Parser.Private_Part.Checksum_Association_Transform_Parse_1_Memo);
         Bare_Comprehension_Memos.Clear
           (Parser.Private_Part.Comprehension_Transform_Parse_0_Memo);
         Bare_Sequence_Literal_Memos.Clear
           (Parser.Private_Part.Concatenation_Or_Parse_2_Memo);
         Bare_Conditional_Transition_Memos.Clear
           (Parser.Private_Part.Conditional_Transition_Transform_Parse_0_Memo);
         Bare_Context_Item_List_Memos.Clear
           (Parser.Private_Part.Context_Clause_List_Parse_0_Memo);
         Bare_Context_Item_Memos.Clear
           (Parser.Private_Part.Context_Item_Transform_Parse_0_Memo);
         Bare_Conversion_Memos.Clear
           (Parser.Private_Part.Conversion_Transform_Parse_0_Memo);
         Bare_Local_Decl_Memos.Clear
           (Parser.Private_Part.Declaration_Or_Parse_0_Memo);
         Bare_Description_Memos.Clear
           (Parser.Private_Part.Description_Aspect_Transform_Parse_0_Memo);
         Bare_Element_Value_Assoc_Memos.Clear
           (Parser.Private_Part.Element_Value_Association_Transform_Parse_0_Memo);
         Bare_Aspect_List_Memos.Clear
           (Parser.Private_Part.Enumeration_Aspects_List_Parse_0_Memo);
         Bare_Enumeration_Type_Def_Memos.Clear
           (Parser.Private_Part.Enumeration_Type_Definition_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Expression_Or_Parse_1_Memo);
         Bare_Case_Expression_Memos.Clear
           (Parser.Private_Part.Extended_Case_Expression_Transform_Parse_0_Memo);
         Bare_RFLX_Node_List_Memos.Clear
           (Parser.Private_Part.Extended_Choice_List_List_Parse_0_Memo);
         Bare_Choice_Memos.Clear
           (Parser.Private_Part.Extended_Choices_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Expression_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Factor_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_If_Condition_Extract_Parse_0_Memo);
         Bare_Paren_Expression_Memos.Clear
           (Parser.Private_Part.Extended_Paren_Expression_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Primary_Or_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Relation_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Simple_Expr_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Suffix_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Term_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Extended_Unop_Term_Or_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Factor_Or_Parse_0_Memo);
         Bare_Formal_Function_Decl_Memos.Clear
           (Parser.Private_Part.Formal_Function_Declaration_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.If_Condition_Extract_Parse_0_Memo);
         Bare_Integer_Type_Def_Memos.Clear
           (Parser.Private_Part.Integer_Type_Definition_Or_Parse_0_Memo);
         Bare_Attribute_Statement_Memos.Clear
           (Parser.Private_Part.List_Attribute_Transform_Parse_4_Memo);
         Bare_Specification_Memos.Clear
           (Parser.Private_Part.Main_Rule_Opt_Parse_0_Memo);
         Bare_Message_Aggregate_Associations_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Association_List_Transform_Parse_0_Memo);
         Bare_Message_Aggregate_Association_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Association_Transform_Parse_0_Memo);
         Bare_Message_Aggregate_Memos.Clear
           (Parser.Private_Part.Message_Aggregate_Transform_Parse_0_Memo);
         Bare_Message_Aspect_List_Memos.Clear
           (Parser.Private_Part.Message_Aspect_List_List_Parse_0_Memo);
         Bare_Message_Field_Assignment_Memos.Clear
           (Parser.Private_Part.Message_Field_Assignment_Statement_Transform_Parse_0_Memo);
         Bare_Message_Fields_Memos.Clear
           (Parser.Private_Part.Message_Field_List_Transform_Parse_0_Memo);
         Bare_Message_Field_Memos.Clear
           (Parser.Private_Part.Message_Field_Transform_Parse_0_Memo);
         Bare_Abstract_Message_Type_Def_Memos.Clear
           (Parser.Private_Part.Message_Type_Definition_Or_Parse_0_Memo);
         Bare_Modular_Type_Def_Memos.Clear
           (Parser.Private_Part.Modular_Type_Definition_Transform_Parse_0_Memo);
         Bare_Named_Enumeration_Def_Memos.Clear
           (Parser.Private_Part.Named_Enumeration_Transform_Parse_0_Memo);
         Bare_Null_Message_Aggregate_Memos.Clear
           (Parser.Private_Part.Null_Message_Aggregate_Transform_Parse_0_Memo);
         Bare_Null_Message_Field_Memos.Clear
           (Parser.Private_Part.Null_Message_Field_Transform_Parse_0_Memo);
         Bare_Null_State_Body_Memos.Clear
           (Parser.Private_Part.Null_State_Body_Transform_Parse_0_Memo);
         Bare_Numeric_Literal_Memos.Clear
           (Parser.Private_Part.Numeric_Literal_Transform_Parse_0_Memo);
         Bare_Package_Node_Memos.Clear
           (Parser.Private_Part.Package_Declaration_Transform_Parse_0_Memo);
         Bare_Parameters_Memos.Clear
           (Parser.Private_Part.Parameter_List_Transform_Parse_0_Memo);
         Bare_Parameter_Memos.Clear
           (Parser.Private_Part.Parameter_Transform_Parse_0_Memo);
         Bare_Paren_Expression_Memos.Clear
           (Parser.Private_Part.Paren_Expression_Transform_Parse_0_Memo);
         Bare_Positional_Enumeration_Def_Memos.Clear
           (Parser.Private_Part.Positional_Enumeration_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Primary_Or_Parse_0_Memo);
         Bare_ID_Memos.Clear
           (Parser.Private_Part.Qualified_Identifier_Transform_Parse_0_Memo);
         Bare_Quantified_Expression_Memos.Clear
           (Parser.Private_Part.Quantified_Expression_Transform_Parse_2_Memo);
         Bare_Range_Type_Def_Memos.Clear
           (Parser.Private_Part.Range_Type_Definition_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Relation_Or_Parse_1_Memo);
         Bare_Renaming_Decl_Memos.Clear
           (Parser.Private_Part.Renaming_Declaration_Transform_Parse_0_Memo);
         Bare_Reset_Memos.Clear
           (Parser.Private_Part.Reset_Transform_Parse_0_Memo);
         Bare_Sequence_Aggregate_Memos.Clear
           (Parser.Private_Part.Sequence_Aggregate_Transform_Parse_0_Memo);
         Bare_Sequence_Type_Def_Memos.Clear
           (Parser.Private_Part.Sequence_Type_Definition_Transform_Parse_0_Memo);
         Bare_Session_Aspects_Memos.Clear
           (Parser.Private_Part.Session_Aspects_Transform_Parse_0_Memo);
         Bare_Session_Decl_Memos.Clear
           (Parser.Private_Part.Session_Declaration_Transform_Parse_0_Memo);
         Bare_Formal_Decl_Memos.Clear
           (Parser.Private_Part.Session_Parameter_Or_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Simple_Expr_Or_Parse_1_Memo);
         Bare_Specification_Memos.Clear
           (Parser.Private_Part.Specification_Transform_Parse_0_Memo);
         Bare_State_Body_Memos.Clear
           (Parser.Private_Part.State_Body_Transform_Parse_0_Memo);
         Bare_State_Memos.Clear
           (Parser.Private_Part.State_Transform_Parse_0_Memo);
         Bare_String_Literal_Memos.Clear
           (Parser.Private_Part.String_Literal_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Suffix_Or_Parse_1_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Term_Or_Parse_1_Memo);
         Bare_Then_Node_Memos.Clear
           (Parser.Private_Part.Then_Transform_Parse_1_Memo);
         Bare_Transition_Memos.Clear
           (Parser.Private_Part.Transition_Transform_Parse_0_Memo);
         Bare_Type_Argument_Memos.Clear
           (Parser.Private_Part.Type_Argument_Transform_Parse_0_Memo);
         Bare_Type_Decl_Memos.Clear
           (Parser.Private_Part.Type_Declaration_Transform_Parse_0_Memo);
         Bare_Type_Derivation_Def_Memos.Clear
           (Parser.Private_Part.Type_Derivation_Definition_Transform_Parse_0_Memo);
         Bare_Refinement_Decl_Memos.Clear
           (Parser.Private_Part.Type_Refinement_Transform_Parse_0_Memo);
         Bare_Expr_Memos.Clear
           (Parser.Private_Part.Unop_Term_Or_Parse_0_Memo);
         Bare_UnqualifiedID_Memos.Clear
           (Parser.Private_Part.Unqualified_Identifier_Transform_Parse_0_Memo);
         Bare_Checksum_Value_Range_Memos.Clear
           (Parser.Private_Part.Value_Range_Transform_Parse_0_Memo);
         Bare_Variable_Decl_Memos.Clear
           (Parser.Private_Part.Variable_Declaration_Transform_Parse_0_Memo);
         Bare_Variable_Memos.Clear
           (Parser.Private_Part.Variable_Transform_Parse_0_Memo);
   end Reset;

   -------------
   -- Destroy --
   -------------

   procedure Destroy (Parser : in out Parser_Type) is
      procedure Free is new Ada.Unchecked_Deallocation
        (Parser_Private_Part_Type, Parser_Private_Part);
      procedure Free is new Ada.Unchecked_Deallocation
        (Free_Parse_List_Record, Free_Parse_List);

      Cur : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
   begin
      while Cur /= null loop
         declare
            Next : constant Free_Parse_List := Cur.Next;
         begin
            Cur.Nodes.Destroy;
            Free (Cur);
            Cur := Next;
         end;
      end loop;
      Free (Parser.Private_Part);
   end Destroy;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Parser : in out Parser_Type) is
   begin
      Parser.Private_Part := new Parser_Private_Part_Type'(others => <>);
   end Initialize;

   --------------------
   -- Get_Parse_List --
   --------------------

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List is
      Lists  : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
      Result : Free_Parse_List;
   begin
      if Lists = null then
         Result := new Free_Parse_List_Record;

      else
         Result := Lists;
         Lists := Lists.Next;
      end if;

      return Result;
   end Get_Parse_List;

   ------------------------
   -- Release_Parse_List --
   ------------------------

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List)
   is
      Lists  : Free_Parse_List renames Parser.Private_Part.Parse_Lists;
   begin
      List.Nodes.Clear;
      List.Next := Lists;
      Lists := List;
      List := null;
   end Release_Parse_List;

   ----------------
   -- Enter_Call --
   ----------------

   procedure Enter_Call (Parser : Parser_Type; Call_Depth : access Natural) is
   begin
      Enter_Call (Parser.Unit.Context, Call_Depth);
   end Enter_Call;

   ---------------
   -- Exit_Call --
   ---------------

   procedure Exit_Call (Parser : Parser_Type; Call_Depth : Natural) is
   begin
      Exit_Call (Parser.Unit.Context, Call_Depth);
   end Exit_Call;

end Librflxlang.Parsers;
