







with Ada.Containers;            use Ada.Containers;
with Ada.Strings.Unbounded;     use Ada.Strings.Unbounded;
pragma Warnings (Off, "is an internal GNAT unit");
with Ada.Strings.Unbounded.Aux; use Ada.Strings.Unbounded.Aux;
pragma Warnings (On, "is an internal GNAT unit");
with Ada.Unchecked_Conversion;

with GNATCOLL.Traces;

pragma Warnings (Off, "referenced");
with Langkit_Support.Adalog.Abstract_Relation;
use Langkit_Support.Adalog.Abstract_Relation;
with Langkit_Support.Adalog.Debug;
use Langkit_Support.Adalog.Debug;
with Langkit_Support.Adalog.Operations;
use Langkit_Support.Adalog.Operations;
with Langkit_Support.Adalog.Predicates;
use Langkit_Support.Adalog.Predicates;
with Langkit_Support.Adalog.Pure_Relations;
use Langkit_Support.Adalog.Pure_Relations;
with Langkit_Support.Symbols;      use Langkit_Support.Symbols;
pragma Warnings (On, "referenced");

with Langkit_Support.Lexical_Envs; use Langkit_Support.Lexical_Envs;
with Langkit_Support.Types;        use Langkit_Support.Types;

with Librflxlang.Common;
with Librflxlang.Private_Converters;
use Librflxlang.Private_Converters;
with Librflxlang.Public_Converters; use Librflxlang.Public_Converters;




package body Librflxlang.Analysis is

   use Librflxlang.Implementation;
   use AST_Envs;

      


      
      function To_Public_Text_Type
         (Value : Character_Type_Array_Access) return Text_Type;


      
      function To_Public_RFLX_Node_Array
         (Value : Internal_Entity_Array_Access) return RFLX_Node_Array;


      


      


      



      

      

      

      

      

      



   ----------------
   -- Do_Release --
   ----------------

   procedure Do_Release (Provider : in out Unit_Provider_Interface'Class) is
   begin
      Provider.Release;
   end Do_Release;

   ------------------------------------
   -- Create_Unit_Provider_Reference --
   ------------------------------------

   function Create_Unit_Provider_Reference
     (Provider : Unit_Provider_Interface'Class) return Unit_Provider_Reference
   is
   begin
      return Result : Unit_Provider_Reference do
         Result.Set (Provider);
      end return;
   end Create_Unit_Provider_Reference;

   --------------------
   -- Create_Context --
   --------------------

   function Create_Context
     (Charset       : String := Default_Charset;
      File_Reader   : File_Reader_Reference := No_File_Reader_Reference;
      Unit_Provider : Unit_Provider_Reference := No_Unit_Provider_Reference;
      With_Trivia   : Boolean := True;
      Tab_Stop      : Positive := 8)
      return Analysis_Context
   is
      use Unit_Provider_References;

      FR     : Internal_File_Reader_Access :=
         Wrap_Public_File_Reader (File_Reader);
      UP     : Internal_Unit_Provider_Access :=
         Wrap_Public_Provider (Unit_Provider);
      Result : Internal_Context := Create_Context
        (Charset, FR, UP, With_Trivia, Tab_Stop);
   begin
      --  Create_Context created ownership shares for itself, so don't forget
      --  to remove the shares on FR and UP.
      Dec_Ref (FR);
      Dec_Ref (UP);

      return Context : constant Analysis_Context := Wrap_Context (Result)
      do
         --  Result has one ownership share and the call to Wrap_Context
         --  creates a new one, so don't forget to dec-ref before returning.
         Dec_Ref (Result);
      end return;
   end Create_Context;

   --------------
   -- Has_Unit --
   --------------

   function Has_Unit
     (Context       : Analysis_Context'Class;
      Unit_Filename : String) return Boolean is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;
      return Has_Unit (Unwrap_Context (Context), Unit_Filename);
   end Has_Unit;

   -------------------
   -- Get_From_File --
   -------------------

   function Get_From_File
     (Context  : Analysis_Context'Class;
      Filename : String;
      Charset  : String := "";
      Reparse  : Boolean := False;
      Rule     : Grammar_Rule := Default_Grammar_Rule) return Analysis_Unit is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;
      return Wrap_Unit
        (Get_From_File (Unwrap_Context (Context), Filename, Charset,
                        Reparse, Rule));
   end Get_From_File;

   ---------------------
   -- Get_From_Buffer --
   ---------------------

   function Get_From_Buffer
     (Context  : Analysis_Context'Class;
      Filename : String;
      Charset  : String := "";
      Buffer   : String;
      Rule     : Grammar_Rule := Default_Grammar_Rule) return Analysis_Unit is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;
      return Wrap_Unit
        (Get_From_Buffer (Unwrap_Context (Context), Filename, Charset,
                          Buffer, Rule));
   end Get_From_Buffer;

   ---------------------
   -- Get_From_Buffer --
   ---------------------

   function Get_From_Buffer
     (Context  : Analysis_Context'Class;
      Filename : String;
      Charset  : String := "";
      Buffer   : Ada.Strings.Unbounded.Unbounded_String;
      Rule     : Grammar_Rule := Default_Grammar_Rule) return Analysis_Unit
   is
      Bytes       : Big_String_Access;
      Bytes_Count : Natural;
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;
      Get_String (Buffer, Bytes, Bytes_Count);
      return Wrap_Unit
        (Get_From_Buffer (Unwrap_Context (Context), Filename, Charset,
                          Bytes (1 .. Bytes_Count), Rule));
   end Get_From_Buffer;

   --------------------
   -- Get_With_Error --
   --------------------

   function Get_With_Error
     (Context  : Analysis_Context'Class;
      Filename : String;
      Error    : Text_Type;
      Charset  : String := "";
      Rule     : Grammar_Rule := Default_Grammar_Rule) return Analysis_Unit
   is
      Result : Internal_Unit;
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;
      Result := Implementation.Get_With_Error
        (Unwrap_Context (Context), Filename, Error, Charset, Rule);
      return Wrap_Unit (Result);
   end Get_With_Error;


   -------------------
   -- Unit_Provider --
   -------------------

   function Unit_Provider
     (Context : Analysis_Context'Class) return Unit_Provider_Reference
   is
      Provider : Internal_Unit_Provider_Access;
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;

      --  By design, Unit_Provider_Wrapper is supposed to be the only
      --  implementation of the Internal_Unit_Provider interface.
      Provider := Unit_Provider (Unwrap_Context (Context));
      if Provider.all not in Unit_Provider_Wrapper'Class then
         raise Program_Error;
      end if;

      return Unit_Provider_Wrapper (Provider.all).Internal;
   end Unit_Provider;

   ----------
   -- Hash --
   ----------

   function Hash (Context : Analysis_Context) return Ada.Containers.Hash_Type
   is
   begin
      return Hash (Unwrap_Context (Context));
   end Hash;

   ---------------------
   -- Has_With_Trivia --
   ---------------------

   function Has_With_Trivia (Context : Analysis_Context'Class) return Boolean
   is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;

      return Has_With_Trivia (Unwrap_Context (Context));
   end Has_With_Trivia;

   --------------------------------------------
   -- Discard_Errors_In_Populate_Lexical_Env --
   --------------------------------------------

   procedure Discard_Errors_In_Populate_Lexical_Env
     (Context : Analysis_Context'Class; Discard : Boolean) is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;

      Discard_Errors_In_Populate_Lexical_Env
        (Unwrap_Context (Context), Discard);
   end Discard_Errors_In_Populate_Lexical_Env;

   ----------------------------------
   -- Set_Logic_Resolution_Timeout --
   ----------------------------------

   procedure Set_Logic_Resolution_Timeout
     (Context : Analysis_Context'Class; Timeout : Natural) is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;

      Set_Logic_Resolution_Timeout (Unwrap_Context (Context), Timeout);
   end Set_Logic_Resolution_Timeout;

   --------------------------
   -- Disable_Lookup_Cache --
   --------------------------

   procedure Disable_Lookup_Cache (Disable : Boolean := True) is
   begin
      Activate_Lookup_Cache := not Disable;
   end Disable_Lookup_Cache;

   --------------------------
   -- Has_Rewriting_Handle --
   --------------------------

   function Has_Rewriting_Handle
     (Context : Analysis_Context'Class) return Boolean is
   begin
      if Context.Internal = null then
         raise Precondition_Failure with "null context argument";
      end if;

      return Has_Rewriting_Handle (Unwrap_Context (Context));
   end Has_Rewriting_Handle;

   ----------------------
   -- Get_Symbol_Table --
   ----------------------

   function Get_Symbol_Table
     (Context : Analysis_Context'Class) return Symbol_Table
   is
   begin
      return Context.Internal.Symbols;
   end Get_Symbol_Table;

   -------------
   -- Context --
   -------------

   function Context (Unit : Analysis_Unit'Class) return Analysis_Context is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Wrap_Context (Context (Unwrap_Unit (Unit)));
   end Context;

   ----------
   -- Hash --
   ----------

   function Hash (Unit : Analysis_Unit) return Ada.Containers.Hash_Type
   is
   begin
      return Hash (Unwrap_Unit (Unit));
   end Hash;

   -------------
   -- Reparse --
   -------------

   procedure Reparse (Unit : Analysis_Unit'Class; Charset : String := "") is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      Reparse (Unwrap_Unit (Unit), Charset);
   end Reparse;

   -------------
   -- Reparse --
   -------------

   procedure Reparse
     (Unit : Analysis_Unit'Class; Charset : String := ""; Buffer  : String) is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      Reparse (Unwrap_Unit (Unit), Charset, Buffer);
   end Reparse;

   --------------------------
   -- Populate_Lexical_Env --
   --------------------------

   procedure Populate_Lexical_Env (Unit : Analysis_Unit'Class) is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      Populate_Lexical_Env (Unwrap_Unit (Unit));
   end Populate_Lexical_Env;

   ------------------
   -- Get_Filename --
   ------------------

   function Get_Filename (Unit : Analysis_Unit'Class) return String is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Get_Filename (Unwrap_Unit (Unit));
   end Get_Filename;

   -----------------
   -- Get_Charset --
   -----------------

   function Get_Charset (Unit : Analysis_Unit'Class) return String is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Get_Charset (Unwrap_Unit (Unit));
   end Get_Charset;

   ---------------------
   -- Has_Diagnostics --
   ---------------------

   function Has_Diagnostics (Unit : Analysis_Unit'Class) return Boolean is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Has_Diagnostics (Unwrap_Unit (Unit));
   end Has_Diagnostics;

   -----------------
   -- Diagnostics --
   -----------------

   function Diagnostics (Unit : Analysis_Unit'Class) return Diagnostics_Array
   is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Implementation.Diagnostics (Unwrap_Unit (Unit));
   end Diagnostics;

   ---------------------------
   -- Format_GNU_Diagnostic --
   ---------------------------

   function Format_GNU_Diagnostic
     (Unit : Analysis_Unit'Class; D : Diagnostic) return String is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Format_GNU_Diagnostic (Unwrap_Unit (Unit), D);
   end Format_GNU_Diagnostic;

   ----------
   -- Root --
   ----------

   function Root (Unit : Analysis_Unit'Class) return RFLX_Node is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Wrap_Node (Root (Unwrap_Unit (Unit)));
   end Root;

   -----------------
   -- First_Token --
   -----------------

   function First_Token (Unit : Analysis_Unit'Class) return Token_Reference is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return First_Token (Unwrap_Unit (Unit));
   end First_Token;

   ----------------
   -- Last_Token --
   ----------------

   function Last_Token (Unit : Analysis_Unit'Class) return Token_Reference is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Last_Token (Unwrap_Unit (Unit));
   end Last_Token;

   -----------------
   -- Token_Count --
   -----------------

   function Token_Count (Unit : Analysis_Unit'Class) return Natural is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Token_Count (Unwrap_Unit (Unit));
   end Token_Count;

   ------------------
   -- Trivia_Count --
   ------------------

   function Trivia_Count (Unit : Analysis_Unit'Class) return Natural is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Trivia_Count (Unwrap_Unit (Unit));
   end Trivia_Count;

   ----------
   -- Text --
   ----------

   function Text (Unit : Analysis_Unit'Class) return Text_Type is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Implementation.Text (Unwrap_Unit (Unit));
   end Text;

   ------------------
   -- Lookup_Token --
   ------------------

   function Lookup_Token
     (Unit : Analysis_Unit'Class; Sloc : Source_Location)
      return Token_Reference is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Lookup_Token (Unwrap_Unit (Unit), Sloc);
   end Lookup_Token;

   --------------
   -- Get_Line --
   --------------

   function Get_Line
     (Unit : Analysis_Unit; Line_Number : Positive) return Text_Type is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      return Get_Line (Unwrap_Unit (Unit), Line_Number);
   end Get_Line;

   ----------------------
   -- Dump_Lexical_Env --
   ----------------------

   procedure Dump_Lexical_Env (Unit : Analysis_Unit'Class) is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      Dump_Lexical_Env (Unwrap_Unit (Unit));
   end Dump_Lexical_Env;

   ------------------------
   -- Trigger_Envs_Debug --
   ------------------------

   procedure Trigger_Envs_Debug (Is_Active : Boolean) is
   begin
      Langkit_Support.Lexical_Envs.Me.Set_Active (Is_Active);
   end Trigger_Envs_Debug;

   -----------
   -- Print --
   -----------

   procedure Print (Unit : Analysis_Unit'Class; Show_Slocs : Boolean := True)
   is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      Print (Unwrap_Unit (Unit), Show_Slocs);
   end Print;

   ---------------
   -- PP_Trivia --
   ---------------

   procedure PP_Trivia (Unit : Analysis_Unit'Class) is
   begin
      if Unit.Internal = null then
         raise Precondition_Failure with "null unit argument";
      end if;

      PP_Trivia (Unwrap_Unit (Unit));
   end PP_Trivia;

   -------------
   -- Is_Null --
   -------------

   function Is_Null (Node : RFLX_Node'Class) return Boolean is
     (Node.Internal.Node = null);

   -------------------
   -- Is_Token_Node --
   -------------------

   function Is_Token_Node (Node : RFLX_Node'Class) return Boolean
   is
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      return Is_Token_Node (Node.Internal.Node);
   end Is_Token_Node;

   ------------------
   -- Is_Synthetic --
   ------------------

   function Is_Synthetic (Node : RFLX_Node'Class) return Boolean
   is
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      return Is_Synthetic (Node.Internal.Node);
   end Is_Synthetic;

   ---------
   -- "=" --
   ---------

   function "=" (L, R : RFLX_Node'Class) return Boolean is
   begin
      Check_Safety_Net (L);
      Check_Safety_Net (R);
      return Compare_Entity (L.Internal, R.Internal);
   end "=";

   -----------
   -- Image --
   -----------

   function Image (Node : RFLX_Node'Class) return String is
   begin
      Check_Safety_Net (Node);
      return Image (Node.Internal);
   end Image;

   -----------------------
   -- Entity converters --
   -----------------------

      function As_RFLX_Node
        (Node : RFLX_Node'Class) return RFLX_Node
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_RFLX_Node;
         end if;

         Check_Safety_Net (Node);

         
         

            
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         

      end;
      function As_AbstractID
        (Node : RFLX_Node'Class) return AbstractID
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_AbstractID;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_AbstractID then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AbstractID";
         
            end if;
      end;
      function As_Type_Def
        (Node : RFLX_Node'Class) return Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Type_Def then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TypeDef";
         
            end if;
      end;
      function As_Abstract_Message_Type_Def
        (Node : RFLX_Node'Class) return Abstract_Message_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Abstract_Message_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Abstract_Message_Type_Def then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AbstractMessageTypeDef";
         
            end if;
      end;
      function As_Aspect
        (Node : RFLX_Node'Class) return Aspect
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Aspect;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Aspect_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Aspect";
         
            end if;
      end;
      function As_RFLX_Node_Base_List
        (Node : RFLX_Node'Class) return RFLX_Node_Base_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_RFLX_Node_Base_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_RFLX_Node_Base_List then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to RFLXNodeBaseList";
         
            end if;
      end;
      function As_Aspect_List
        (Node : RFLX_Node'Class) return Aspect_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Aspect_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Aspect_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Aspect.list";
         
            end if;
      end;
      function As_Statement
        (Node : RFLX_Node'Class) return Statement
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Statement;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Statement then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Statement";
         
            end if;
      end;
      function As_Assignment
        (Node : RFLX_Node'Class) return Assignment
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Assignment;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Assignment_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Assignment";
         
            end if;
      end;
      function As_Attr
        (Node : RFLX_Node'Class) return Attr
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr";
         
            end if;
      end;
      function As_Attr_First
        (Node : RFLX_Node'Class) return Attr_First
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_First;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_First_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.First";
         
            end if;
      end;
      function As_Attr_Has_Data
        (Node : RFLX_Node'Class) return Attr_Has_Data
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Has_Data;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Has_Data_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.HasData";
         
            end if;
      end;
      function As_Attr_Head
        (Node : RFLX_Node'Class) return Attr_Head
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Head;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Head_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Head";
         
            end if;
      end;
      function As_Attr_Last
        (Node : RFLX_Node'Class) return Attr_Last
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Last;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Last_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Last";
         
            end if;
      end;
      function As_Attr_Opaque
        (Node : RFLX_Node'Class) return Attr_Opaque
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Opaque;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Opaque_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Opaque";
         
            end if;
      end;
      function As_Attr_Present
        (Node : RFLX_Node'Class) return Attr_Present
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Present;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Present_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Present";
         
            end if;
      end;
      function As_Attr_Size
        (Node : RFLX_Node'Class) return Attr_Size
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Size;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Size_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Size";
         
            end if;
      end;
      function As_Attr_Stmt
        (Node : RFLX_Node'Class) return Attr_Stmt
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Stmt;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Stmt then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttrStmt";
         
            end if;
      end;
      function As_Attr_Stmt_Append
        (Node : RFLX_Node'Class) return Attr_Stmt_Append
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Stmt_Append;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Stmt_Append_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttrStmt.Append";
         
            end if;
      end;
      function As_Attr_Stmt_Extend
        (Node : RFLX_Node'Class) return Attr_Stmt_Extend
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Stmt_Extend;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Stmt_Extend_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttrStmt.Extend";
         
            end if;
      end;
      function As_Attr_Stmt_Read
        (Node : RFLX_Node'Class) return Attr_Stmt_Read
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Stmt_Read;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Stmt_Read_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttrStmt.Read";
         
            end if;
      end;
      function As_Attr_Stmt_Write
        (Node : RFLX_Node'Class) return Attr_Stmt_Write
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Stmt_Write;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Stmt_Write_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttrStmt.Write";
         
            end if;
      end;
      function As_Attr_Valid
        (Node : RFLX_Node'Class) return Attr_Valid
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Valid;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Valid_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.Valid";
         
            end if;
      end;
      function As_Attr_Valid_Checksum
        (Node : RFLX_Node'Class) return Attr_Valid_Checksum
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attr_Valid_Checksum;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attr_Valid_Checksum_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attr.ValidChecksum";
         
            end if;
      end;
      function As_Expr
        (Node : RFLX_Node'Class) return Expr
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Expr;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Expr then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Expr";
         
            end if;
      end;
      function As_Attribute
        (Node : RFLX_Node'Class) return Attribute
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attribute;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attribute_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Attribute";
         
            end if;
      end;
      function As_Attribute_Statement
        (Node : RFLX_Node'Class) return Attribute_Statement
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Attribute_Statement;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Attribute_Statement_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to AttributeStatement";
         
            end if;
      end;
      function As_Base_Aggregate
        (Node : RFLX_Node'Class) return Base_Aggregate
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Base_Aggregate;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Base_Aggregate then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to BaseAggregate";
         
            end if;
      end;
      function As_Base_Checksum_Val
        (Node : RFLX_Node'Class) return Base_Checksum_Val
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Base_Checksum_Val;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Base_Checksum_Val then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to BaseChecksumVal";
         
            end if;
      end;
      function As_Base_Checksum_Val_List
        (Node : RFLX_Node'Class) return Base_Checksum_Val_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Base_Checksum_Val_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Base_Checksum_Val_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to BaseChecksumVal.list";
         
            end if;
      end;
      function As_Base_State_Body
        (Node : RFLX_Node'Class) return Base_State_Body
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Base_State_Body;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Base_State_Body then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to BaseStateBody";
         
            end if;
      end;
      function As_Bin_Op
        (Node : RFLX_Node'Class) return Bin_Op
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Bin_Op;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Bin_Op_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to BinOp";
         
            end if;
      end;
      function As_Binding
        (Node : RFLX_Node'Class) return Binding
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Binding;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Binding_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Binding";
         
            end if;
      end;
      function As_Message_Aspect
        (Node : RFLX_Node'Class) return Message_Aspect
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aspect;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aspect then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAspect";
         
            end if;
      end;
      function As_Byte_Order_Aspect
        (Node : RFLX_Node'Class) return Byte_Order_Aspect
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Byte_Order_Aspect;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Byte_Order_Aspect_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ByteOrderAspect";
         
            end if;
      end;
      function As_Byte_Order_Type
        (Node : RFLX_Node'Class) return Byte_Order_Type
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Byte_Order_Type;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Byte_Order_Type then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ByteOrderType";
         
            end if;
      end;
      function As_Byte_Order_Type_Highorderfirst
        (Node : RFLX_Node'Class) return Byte_Order_Type_Highorderfirst
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Byte_Order_Type_Highorderfirst;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Byte_Order_Type_Highorderfirst_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ByteOrderType.Highorderfirst";
         
            end if;
      end;
      function As_Byte_Order_Type_Loworderfirst
        (Node : RFLX_Node'Class) return Byte_Order_Type_Loworderfirst
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Byte_Order_Type_Loworderfirst;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Byte_Order_Type_Loworderfirst_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ByteOrderType.Loworderfirst";
         
            end if;
      end;
      function As_Call
        (Node : RFLX_Node'Class) return Call
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Call;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Call_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Call";
         
            end if;
      end;
      function As_Case_Expression
        (Node : RFLX_Node'Class) return Case_Expression
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Case_Expression;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Case_Expression_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to CaseExpression";
         
            end if;
      end;
      function As_Channel_Attribute
        (Node : RFLX_Node'Class) return Channel_Attribute
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Channel_Attribute;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Channel_Attribute then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChannelAttribute";
         
            end if;
      end;
      function As_Channel_Attribute_List
        (Node : RFLX_Node'Class) return Channel_Attribute_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Channel_Attribute_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Channel_Attribute_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChannelAttribute.list";
         
            end if;
      end;
      function As_Checksum_Aspect
        (Node : RFLX_Node'Class) return Checksum_Aspect
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Checksum_Aspect;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Checksum_Aspect_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChecksumAspect";
         
            end if;
      end;
      function As_Checksum_Assoc
        (Node : RFLX_Node'Class) return Checksum_Assoc
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Checksum_Assoc;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Checksum_Assoc_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChecksumAssoc";
         
            end if;
      end;
      function As_Checksum_Assoc_List
        (Node : RFLX_Node'Class) return Checksum_Assoc_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Checksum_Assoc_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Checksum_Assoc_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChecksumAssoc.list";
         
            end if;
      end;
      function As_Checksum_Val
        (Node : RFLX_Node'Class) return Checksum_Val
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Checksum_Val;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Checksum_Val_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChecksumVal";
         
            end if;
      end;
      function As_Checksum_Value_Range
        (Node : RFLX_Node'Class) return Checksum_Value_Range
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Checksum_Value_Range;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Checksum_Value_Range_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ChecksumValueRange";
         
            end if;
      end;
      function As_Choice
        (Node : RFLX_Node'Class) return Choice
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Choice;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Choice_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Choice";
         
            end if;
      end;
      function As_Choice_List
        (Node : RFLX_Node'Class) return Choice_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Choice_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Choice_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Choice.list";
         
            end if;
      end;
      function As_Comprehension
        (Node : RFLX_Node'Class) return Comprehension
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Comprehension;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Comprehension_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Comprehension";
         
            end if;
      end;
      function As_Sequence_Literal
        (Node : RFLX_Node'Class) return Sequence_Literal
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Sequence_Literal;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Sequence_Literal then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to SequenceLiteral";
         
            end if;
      end;
      function As_Concatenation
        (Node : RFLX_Node'Class) return Concatenation
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Concatenation;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Concatenation_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Concatenation";
         
            end if;
      end;
      function As_Transition
        (Node : RFLX_Node'Class) return Transition
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Transition;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Transition_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Transition";
         
            end if;
      end;
      function As_Conditional_Transition
        (Node : RFLX_Node'Class) return Conditional_Transition
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Conditional_Transition;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Conditional_Transition_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ConditionalTransition";
         
            end if;
      end;
      function As_Conditional_Transition_List
        (Node : RFLX_Node'Class) return Conditional_Transition_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Conditional_Transition_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Conditional_Transition_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ConditionalTransition.list";
         
            end if;
      end;
      function As_Context_Item
        (Node : RFLX_Node'Class) return Context_Item
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Context_Item;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Context_Item_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ContextItem";
         
            end if;
      end;
      function As_Context_Item_List
        (Node : RFLX_Node'Class) return Context_Item_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Context_Item_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Context_Item_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ContextItem.list";
         
            end if;
      end;
      function As_Conversion
        (Node : RFLX_Node'Class) return Conversion
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Conversion;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Conversion_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Conversion";
         
            end if;
      end;
      function As_Declaration
        (Node : RFLX_Node'Class) return Declaration
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Declaration;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Declaration then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Declaration";
         
            end if;
      end;
      function As_Declaration_List
        (Node : RFLX_Node'Class) return Declaration_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Declaration_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Declaration_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Declaration.list";
         
            end if;
      end;
      function As_Description
        (Node : RFLX_Node'Class) return Description
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Description;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Description_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Description";
         
            end if;
      end;
      function As_Element_Value_Assoc
        (Node : RFLX_Node'Class) return Element_Value_Assoc
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Element_Value_Assoc;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Element_Value_Assoc_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ElementValueAssoc";
         
            end if;
      end;
      function As_Element_Value_Assoc_List
        (Node : RFLX_Node'Class) return Element_Value_Assoc_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Element_Value_Assoc_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Element_Value_Assoc_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ElementValueAssoc.list";
         
            end if;
      end;
      function As_Enumeration_Def
        (Node : RFLX_Node'Class) return Enumeration_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Enumeration_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Enumeration_Def then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to EnumerationDef";
         
            end if;
      end;
      function As_Enumeration_Type_Def
        (Node : RFLX_Node'Class) return Enumeration_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Enumeration_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Enumeration_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to EnumerationTypeDef";
         
            end if;
      end;
      function As_Expr_List
        (Node : RFLX_Node'Class) return Expr_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Expr_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Expr_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Expr.list";
         
            end if;
      end;
      function As_Formal_Decl
        (Node : RFLX_Node'Class) return Formal_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Formal_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Formal_Decl then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to FormalDecl";
         
            end if;
      end;
      function As_Formal_Channel_Decl
        (Node : RFLX_Node'Class) return Formal_Channel_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Formal_Channel_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Formal_Channel_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to FormalChannelDecl";
         
            end if;
      end;
      function As_Formal_Decl_List
        (Node : RFLX_Node'Class) return Formal_Decl_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Formal_Decl_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Formal_Decl_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to FormalDecl.list";
         
            end if;
      end;
      function As_Formal_Function_Decl
        (Node : RFLX_Node'Class) return Formal_Function_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Formal_Function_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Formal_Function_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to FormalFunctionDecl";
         
            end if;
      end;
      function As_ID
        (Node : RFLX_Node'Class) return ID
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_ID;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_ID_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ID";
         
            end if;
      end;
      function As_Integer_Type_Def
        (Node : RFLX_Node'Class) return Integer_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Integer_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Integer_Type_Def then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to IntegerTypeDef";
         
            end if;
      end;
      function As_Local_Decl
        (Node : RFLX_Node'Class) return Local_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Local_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Local_Decl then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to LocalDecl";
         
            end if;
      end;
      function As_Local_Decl_List
        (Node : RFLX_Node'Class) return Local_Decl_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Local_Decl_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Local_Decl_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to LocalDecl.list";
         
            end if;
      end;
      function As_Message_Aggregate
        (Node : RFLX_Node'Class) return Message_Aggregate
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aggregate;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aggregate_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAggregate";
         
            end if;
      end;
      function As_Message_Aggregate_Association
        (Node : RFLX_Node'Class) return Message_Aggregate_Association
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aggregate_Association;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aggregate_Association_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAggregateAssociation";
         
            end if;
      end;
      function As_Message_Aggregate_Association_List
        (Node : RFLX_Node'Class) return Message_Aggregate_Association_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aggregate_Association_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aggregate_Association_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAggregateAssociation.list";
         
            end if;
      end;
      function As_Message_Aggregate_Associations
        (Node : RFLX_Node'Class) return Message_Aggregate_Associations
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aggregate_Associations;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aggregate_Associations_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAggregateAssociations";
         
            end if;
      end;
      function As_Message_Aspect_List
        (Node : RFLX_Node'Class) return Message_Aspect_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Aspect_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Aspect_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageAspect.list";
         
            end if;
      end;
      function As_Message_Field
        (Node : RFLX_Node'Class) return Message_Field
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Field;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Field_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageField";
         
            end if;
      end;
      function As_Message_Field_Assignment
        (Node : RFLX_Node'Class) return Message_Field_Assignment
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Field_Assignment;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Field_Assignment_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageFieldAssignment";
         
            end if;
      end;
      function As_Message_Field_List
        (Node : RFLX_Node'Class) return Message_Field_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Field_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Field_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageField.list";
         
            end if;
      end;
      function As_Message_Fields
        (Node : RFLX_Node'Class) return Message_Fields
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Fields;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Fields_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageFields";
         
            end if;
      end;
      function As_Message_Type_Def
        (Node : RFLX_Node'Class) return Message_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Message_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Message_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to MessageTypeDef";
         
            end if;
      end;
      function As_Modular_Type_Def
        (Node : RFLX_Node'Class) return Modular_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Modular_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Modular_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ModularTypeDef";
         
            end if;
      end;
      function As_Named_Enumeration_Def
        (Node : RFLX_Node'Class) return Named_Enumeration_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Named_Enumeration_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Named_Enumeration_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NamedEnumerationDef";
         
            end if;
      end;
      function As_Negation
        (Node : RFLX_Node'Class) return Negation
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Negation;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Negation_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Negation";
         
            end if;
      end;
      function As_NullID
        (Node : RFLX_Node'Class) return NullID
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_NullID;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_NullID_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NullID";
         
            end if;
      end;
      function As_Null_Message_Aggregate
        (Node : RFLX_Node'Class) return Null_Message_Aggregate
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Null_Message_Aggregate;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Null_Message_Aggregate_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NullMessageAggregate";
         
            end if;
      end;
      function As_Null_Message_Field
        (Node : RFLX_Node'Class) return Null_Message_Field
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Null_Message_Field;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Null_Message_Field_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NullMessageField";
         
            end if;
      end;
      function As_Null_Message_Type_Def
        (Node : RFLX_Node'Class) return Null_Message_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Null_Message_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Null_Message_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NullMessageTypeDef";
         
            end if;
      end;
      function As_Null_State_Body
        (Node : RFLX_Node'Class) return Null_State_Body
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Null_State_Body;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Null_State_Body_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NullStateBody";
         
            end if;
      end;
      function As_Numeric_Literal
        (Node : RFLX_Node'Class) return Numeric_Literal
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Numeric_Literal;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Numeric_Literal_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NumericLiteral";
         
            end if;
      end;
      function As_Numeric_Literal_List
        (Node : RFLX_Node'Class) return Numeric_Literal_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Numeric_Literal_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Numeric_Literal_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to NumericLiteral.list";
         
            end if;
      end;
      function As_Op
        (Node : RFLX_Node'Class) return Op
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op";
         
            end if;
      end;
      function As_Op_Add
        (Node : RFLX_Node'Class) return Op_Add
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Add;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Add_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Add";
         
            end if;
      end;
      function As_Op_And
        (Node : RFLX_Node'Class) return Op_And
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_And;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_And_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.And";
         
            end if;
      end;
      function As_Op_Div
        (Node : RFLX_Node'Class) return Op_Div
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Div;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Div_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Div";
         
            end if;
      end;
      function As_Op_Eq
        (Node : RFLX_Node'Class) return Op_Eq
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Eq;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Eq_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Eq";
         
            end if;
      end;
      function As_Op_Ge
        (Node : RFLX_Node'Class) return Op_Ge
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Ge;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Ge_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Ge";
         
            end if;
      end;
      function As_Op_Gt
        (Node : RFLX_Node'Class) return Op_Gt
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Gt;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Gt_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Gt";
         
            end if;
      end;
      function As_Op_In
        (Node : RFLX_Node'Class) return Op_In
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_In;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_In_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.In";
         
            end if;
      end;
      function As_Op_Le
        (Node : RFLX_Node'Class) return Op_Le
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Le;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Le_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Le";
         
            end if;
      end;
      function As_Op_Lt
        (Node : RFLX_Node'Class) return Op_Lt
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Lt;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Lt_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Lt";
         
            end if;
      end;
      function As_Op_Mod
        (Node : RFLX_Node'Class) return Op_Mod
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Mod;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Mod_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Mod";
         
            end if;
      end;
      function As_Op_Mul
        (Node : RFLX_Node'Class) return Op_Mul
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Mul;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Mul_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Mul";
         
            end if;
      end;
      function As_Op_Neq
        (Node : RFLX_Node'Class) return Op_Neq
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Neq;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Neq_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Neq";
         
            end if;
      end;
      function As_Op_Notin
        (Node : RFLX_Node'Class) return Op_Notin
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Notin;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Notin_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Notin";
         
            end if;
      end;
      function As_Op_Or
        (Node : RFLX_Node'Class) return Op_Or
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Or;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Or_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Or";
         
            end if;
      end;
      function As_Op_Pow
        (Node : RFLX_Node'Class) return Op_Pow
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Pow;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Pow_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Pow";
         
            end if;
      end;
      function As_Op_Sub
        (Node : RFLX_Node'Class) return Op_Sub
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Op_Sub;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Op_Sub_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Op.Sub";
         
            end if;
      end;
      function As_Package_Node
        (Node : RFLX_Node'Class) return Package_Node
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Package_Node;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Package_Node_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Package";
         
            end if;
      end;
      function As_Parameter
        (Node : RFLX_Node'Class) return Parameter
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Parameter;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Parameter_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Parameter";
         
            end if;
      end;
      function As_Parameter_List
        (Node : RFLX_Node'Class) return Parameter_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Parameter_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Parameter_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Parameter.list";
         
            end if;
      end;
      function As_Parameters
        (Node : RFLX_Node'Class) return Parameters
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Parameters;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Parameters_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Parameters";
         
            end if;
      end;
      function As_Paren_Expression
        (Node : RFLX_Node'Class) return Paren_Expression
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Paren_Expression;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Paren_Expression_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to ParenExpression";
         
            end if;
      end;
      function As_Positional_Enumeration_Def
        (Node : RFLX_Node'Class) return Positional_Enumeration_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Positional_Enumeration_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Positional_Enumeration_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to PositionalEnumerationDef";
         
            end if;
      end;
      function As_Quantified_Expression
        (Node : RFLX_Node'Class) return Quantified_Expression
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Quantified_Expression;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Quantified_Expression_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to QuantifiedExpression";
         
            end if;
      end;
      function As_Quantifier
        (Node : RFLX_Node'Class) return Quantifier
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Quantifier;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Quantifier then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Quantifier";
         
            end if;
      end;
      function As_Quantifier_All
        (Node : RFLX_Node'Class) return Quantifier_All
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Quantifier_All;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Quantifier_All_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Quantifier.All";
         
            end if;
      end;
      function As_Quantifier_Some
        (Node : RFLX_Node'Class) return Quantifier_Some
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Quantifier_Some;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Quantifier_Some_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Quantifier.Some";
         
            end if;
      end;
      function As_RFLX_Node_List
        (Node : RFLX_Node'Class) return RFLX_Node_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_RFLX_Node_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_RFLX_Node_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to RFLXNode.list";
         
            end if;
      end;
      function As_Range_Type_Def
        (Node : RFLX_Node'Class) return Range_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Range_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Range_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to RangeTypeDef";
         
            end if;
      end;
      function As_Readable
        (Node : RFLX_Node'Class) return Readable
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Readable;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Readable_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Readable";
         
            end if;
      end;
      function As_Refinement_Decl
        (Node : RFLX_Node'Class) return Refinement_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Refinement_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Refinement_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to RefinementDecl";
         
            end if;
      end;
      function As_Renaming_Decl
        (Node : RFLX_Node'Class) return Renaming_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Renaming_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Renaming_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to RenamingDecl";
         
            end if;
      end;
      function As_Reset
        (Node : RFLX_Node'Class) return Reset
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Reset;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Reset_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Reset";
         
            end if;
      end;
      function As_Select_Node
        (Node : RFLX_Node'Class) return Select_Node
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Select_Node;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Select_Node_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Select";
         
            end if;
      end;
      function As_Sequence_Aggregate
        (Node : RFLX_Node'Class) return Sequence_Aggregate
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Sequence_Aggregate;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Sequence_Aggregate_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to SequenceAggregate";
         
            end if;
      end;
      function As_Sequence_Type_Def
        (Node : RFLX_Node'Class) return Sequence_Type_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Sequence_Type_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Sequence_Type_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to SequenceTypeDef";
         
            end if;
      end;
      function As_Session_Aspects
        (Node : RFLX_Node'Class) return Session_Aspects
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Session_Aspects;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Session_Aspects_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to SessionAspects";
         
            end if;
      end;
      function As_Session_Decl
        (Node : RFLX_Node'Class) return Session_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Session_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Session_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to SessionDecl";
         
            end if;
      end;
      function As_Specification
        (Node : RFLX_Node'Class) return Specification
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Specification;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Specification_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Specification";
         
            end if;
      end;
      function As_State
        (Node : RFLX_Node'Class) return State
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_State;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_State_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to State";
         
            end if;
      end;
      function As_State_Body
        (Node : RFLX_Node'Class) return State_Body
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_State_Body;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_State_Body_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to StateBody";
         
            end if;
      end;
      function As_State_List
        (Node : RFLX_Node'Class) return State_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_State_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_State_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to State.list";
         
            end if;
      end;
      function As_Statement_List
        (Node : RFLX_Node'Class) return Statement_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Statement_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Statement_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Statement.list";
         
            end if;
      end;
      function As_String_Literal
        (Node : RFLX_Node'Class) return String_Literal
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_String_Literal;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_String_Literal_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to StringLiteral";
         
            end if;
      end;
      function As_Term_Assoc
        (Node : RFLX_Node'Class) return Term_Assoc
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Term_Assoc;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Term_Assoc_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TermAssoc";
         
            end if;
      end;
      function As_Term_Assoc_List
        (Node : RFLX_Node'Class) return Term_Assoc_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Term_Assoc_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Term_Assoc_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TermAssoc.list";
         
            end if;
      end;
      function As_Then_Node
        (Node : RFLX_Node'Class) return Then_Node
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Then_Node;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Then_Node_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Then";
         
            end if;
      end;
      function As_Then_Node_List
        (Node : RFLX_Node'Class) return Then_Node_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Then_Node_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Then_Node_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Then.list";
         
            end if;
      end;
      function As_Type_Argument
        (Node : RFLX_Node'Class) return Type_Argument
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Type_Argument;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Type_Argument_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TypeArgument";
         
            end if;
      end;
      function As_Type_Argument_List
        (Node : RFLX_Node'Class) return Type_Argument_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Type_Argument_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Type_Argument_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TypeArgument.list";
         
            end if;
      end;
      function As_Type_Decl
        (Node : RFLX_Node'Class) return Type_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Type_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Type_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TypeDecl";
         
            end if;
      end;
      function As_Type_Derivation_Def
        (Node : RFLX_Node'Class) return Type_Derivation_Def
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Type_Derivation_Def;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Type_Derivation_Def_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to TypeDerivationDef";
         
            end if;
      end;
      function As_UnqualifiedID
        (Node : RFLX_Node'Class) return UnqualifiedID
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_UnqualifiedID;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_UnqualifiedID_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to UnqualifiedID";
         
            end if;
      end;
      function As_UnqualifiedID_List
        (Node : RFLX_Node'Class) return UnqualifiedID_List
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_UnqualifiedID_List;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_UnqualifiedID_List_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to UnqualifiedID.list";
         
            end if;
      end;
      function As_Variable
        (Node : RFLX_Node'Class) return Variable
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Variable;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Variable_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Variable";
         
            end if;
      end;
      function As_Variable_Decl
        (Node : RFLX_Node'Class) return Variable_Decl
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Variable_Decl;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Variable_Decl_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to VariableDecl";
         
            end if;
      end;
      function As_Writable
        (Node : RFLX_Node'Class) return Writable
      is
         N : constant Bare_RFLX_Node := Node.Internal.Node;
      begin
         if N = null then
            return No_Writable;
         end if;

         Check_Safety_Net (Node);

         
         

            if N.Kind in RFLX_Writable_Range then
               
            return (Internal   => (Node => N, Info => Node.Internal.Info),
                    Safety_Net => Node.Safety_Net);
         
            else
               
            raise Constraint_Error with
              "Librflxlang: invalid type conversion from "
              & Node.Kind_Name
              & " to Writable";
         
            end if;
      end;

   -----------------------
   -- Entity primitives --
   -----------------------

   ----------
   -- Hash --
   ----------

   function Hash
     (Node : RFLX_Node) return Ada.Containers.Hash_Type is
   begin
      Check_Safety_Net (Node);
      return Hash_Entity (Node.Internal);
   end Hash;

   ----------
   -- Kind --
   ----------

   function Kind (Node : RFLX_Node'Class) return RFLX_Node_Kind_Type
   is
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      return Node.Internal.Node.Kind;
   end Kind;

   ---------------
   -- Kind_Name --
   ---------------

   function Kind_Name (Node : RFLX_Node'Class) return String is
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      return Kind_Name (Node.Internal.Node);
   end Kind_Name;

      


      
      function To_Public_Text_Type
         (Value : Character_Type_Array_Access) return Text_Type is
      begin
         return Result : Text_Type (1 .. Value.N) do
            for I in Result'Range loop
               
               Result (I - Value.Items'First + Result'First)
                     := Value.Items (I)
               ;
            end loop;
         end return;
      end;


      
      function To_Public_RFLX_Node_Array
         (Value : Internal_Entity_Array_Access) return RFLX_Node_Array is
      begin
         return Result : RFLX_Node_Array (1 .. Value.N) do
            for I in Result'Range loop
               
               Result (I - Value.Items'First + Result'First)
                     := Wrap_Node (Value.Items (I).Node, Value.Items (I).Info)
               ;
            end loop;
         end return;
      end;


      


      


      









         
   function Parent
     (Node : RFLX_Node'Class) return RFLX_Node is
      


      Property_Result : Internal_Entity;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Parent
            (Bare_RFLX_Node (Node.Internal.Node), E_Info => Node.Internal.Info);

         return Wrap_Node (Property_Result.Node, Property_Result.Info);

   end;

         
   function Parents
     (Node : RFLX_Node'Class;
      With_Self : Boolean := True) return RFLX_Node_Array is
      


         Internal_Arg_With_Self : Boolean;
      Property_Result : Internal_Entity_Array_Access;

         procedure Free_Internal;
         --  Dec-ref all internal arguments and the property result, when
         --  applicable.

         -------------------
         -- Free_Internal --
         -------------------

         procedure Free_Internal is
         begin
               Dec_Ref (Property_Result);
         end Free_Internal;

   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);

         Internal_Arg_With_Self :=
            With_Self;

      
      Property_Result :=
         Librflxlang.Implementation.Parents
            (Bare_RFLX_Node (Node.Internal.Node), Internal_Arg_With_Self, E_Info => Node.Internal.Info);

         return Result : constant RFLX_Node_Array :=
            To_Public_RFLX_Node_Array (Property_Result)
         do
            Free_Internal;
         end return;

      exception
         when Property_Error =>
            Free_Internal;
            raise;
   end;

         
   function Children
     (Node : RFLX_Node'Class) return RFLX_Node_Array is
      


      Property_Result : Internal_Entity_Array_Access;

         procedure Free_Internal;
         --  Dec-ref all internal arguments and the property result, when
         --  applicable.

         -------------------
         -- Free_Internal --
         -------------------

         procedure Free_Internal is
         begin
               Dec_Ref (Property_Result);
         end Free_Internal;

   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Children
            (Bare_RFLX_Node (Node.Internal.Node), E_Info => Node.Internal.Info);

         return Result : constant RFLX_Node_Array :=
            To_Public_RFLX_Node_Array (Property_Result)
         do
            Free_Internal;
         end return;

      exception
         when Property_Error =>
            Free_Internal;
            raise;
   end;

         
   function Token_Start
     (Node : RFLX_Node'Class) return Token_Reference is
      


      Property_Result : Token_Reference;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Token_Start
            (Bare_RFLX_Node (Node.Internal.Node));

         return Property_Result;

   end;

         
   function Token_End
     (Node : RFLX_Node'Class) return Token_Reference is
      


      Property_Result : Token_Reference;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Token_End
            (Bare_RFLX_Node (Node.Internal.Node));

         return Property_Result;

   end;

         
   function Child_Index
     (Node : RFLX_Node'Class) return Integer is
      


      Property_Result : Integer;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Child_Index
            (Bare_RFLX_Node (Node.Internal.Node));

         return Property_Result;

   end;

         
   function Previous_Sibling
     (Node : RFLX_Node'Class) return RFLX_Node is
      


      Property_Result : Internal_Entity;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Previous_Sibling
            (Bare_RFLX_Node (Node.Internal.Node), E_Info => Node.Internal.Info);

         return Wrap_Node (Property_Result.Node, Property_Result.Info);

   end;

         
   function Next_Sibling
     (Node : RFLX_Node'Class) return RFLX_Node is
      


      Property_Result : Internal_Entity;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Next_Sibling
            (Bare_RFLX_Node (Node.Internal.Node), E_Info => Node.Internal.Info);

         return Wrap_Node (Property_Result.Node, Property_Result.Info);

   end;

         
   function Unit
     (Node : RFLX_Node'Class) return Analysis_Unit is
      


      Property_Result : Internal_Unit;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Unit
            (Bare_RFLX_Node (Node.Internal.Node));

         return Wrap_Unit (Property_Result);

   end;

         
   function Is_Ghost
     (Node : RFLX_Node'Class) return Boolean is
      


      Property_Result : Boolean;


   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Is_Ghost
            (Bare_RFLX_Node (Node.Internal.Node));

         return Property_Result;

   end;

         
   function Full_Sloc_Image
     (Node : RFLX_Node'Class) return Text_Type is
      


      Property_Result : Character_Type_Array_Access;

         procedure Free_Internal;
         --  Dec-ref all internal arguments and the property result, when
         --  applicable.

         -------------------
         -- Free_Internal --
         -------------------

         procedure Free_Internal is
         begin
               Dec_Ref (Property_Result);
         end Free_Internal;

   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);


      
      Property_Result :=
         Librflxlang.Implementation.Full_Sloc_Image
            (Bare_RFLX_Node (Node.Internal.Node));

         return Result : constant Text_Type :=
            To_Public_Text_Type (Property_Result)
         do
            Free_Internal;
         end return;

      exception
         when Property_Error =>
            Free_Internal;
            raise;
   end;




















         
   

   function F_Identifier
     (Node : Aspect'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Aspect_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Value
     (Node : Aspect'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Aspect_F_Value (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Value;










         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Aspect_List'Class; Index : Positive) return Aspect
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Aspect;
         end List_Child;

         

         function Aspect_List_First (Node : Aspect_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Aspect_List_Next
           (Node : Aspect_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Aspect_List_Has_Element
           (Node : Aspect_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Aspect_List_Element
           (Node : Aspect_List; Cursor : Positive) return Aspect'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Aspect'(Child.As_Aspect);
         end;











         
   

   function F_Identifier
     (Node : Assignment'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Assignment_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Expression
     (Node : Assignment'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Assignment_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;























































































         
   

   function F_Expression
     (Node : Attribute'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Attribute_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;


         
   

   function F_Kind
     (Node : Attribute'Class) return Attr
   is
      Result : Bare_Attr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Attribute_F_Kind (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Kind;

         function F_Kind
           (Node : Attribute'Class) return RFLX_Attr
         is (Attr'(Node.F_Kind).Kind);






         
   

   function F_Identifier
     (Node : Attribute_Statement'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Attribute_Statement_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Attr
     (Node : Attribute_Statement'Class) return Attr_Stmt
   is
      Result : Bare_Attr_Stmt;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Attribute_Statement_F_Attr (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Attr;

         function F_Attr
           (Node : Attribute_Statement'Class) return RFLX_Attr_Stmt
         is (Attr_Stmt'(Node.F_Attr).Kind);

         
   

   function F_Expression
     (Node : Attribute_Statement'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Attribute_Statement_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;















         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Base_Checksum_Val_List'Class; Index : Positive) return Base_Checksum_Val
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Base_Checksum_Val;
         end List_Child;

         

         function Base_Checksum_Val_List_First (Node : Base_Checksum_Val_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Base_Checksum_Val_List_Next
           (Node : Base_Checksum_Val_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Base_Checksum_Val_List_Has_Element
           (Node : Base_Checksum_Val_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Base_Checksum_Val_List_Element
           (Node : Base_Checksum_Val_List; Cursor : Positive) return Base_Checksum_Val'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Base_Checksum_Val'(Child.As_Base_Checksum_Val);
         end;











         
   

   function F_Left
     (Node : Bin_Op'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Bin_Op_F_Left (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Left;


         
   

   function F_Op
     (Node : Bin_Op'Class) return Op
   is
      Result : Bare_Op;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Bin_Op_F_Op (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Op;

         function F_Op
           (Node : Bin_Op'Class) return RFLX_Op
         is (Op'(Node.F_Op).Kind);

         
   

   function F_Right
     (Node : Bin_Op'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Bin_Op_F_Right (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Right;







         
   

   function F_Expression
     (Node : Binding'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Binding_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;


         
   

   function F_Bindings
     (Node : Binding'Class) return Term_Assoc_List
   is
      Result : Bare_Term_Assoc_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Binding_F_Bindings (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Bindings;












         
   

   function F_Byte_Order
     (Node : Byte_Order_Aspect'Class) return Byte_Order_Type
   is
      Result : Bare_Byte_Order_Type;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Byte_Order_Aspect_F_Byte_Order (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Byte_Order;

         function F_Byte_Order
           (Node : Byte_Order_Aspect'Class) return RFLX_Byte_Order_Type
         is (Byte_Order_Type'(Node.F_Byte_Order).Kind);





















         
   

   function F_Identifier
     (Node : Call'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Call_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Arguments
     (Node : Call'Class) return Expr_List
   is
      Result : Bare_Expr_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Call_F_Arguments (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Arguments;







         
   

   function F_Expression
     (Node : Case_Expression'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Case_Expression_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;


         
   

   function F_Choices
     (Node : Case_Expression'Class) return Choice_List
   is
      Result : Bare_Choice_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Case_Expression_F_Choices (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Choices;










         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Channel_Attribute_List'Class; Index : Positive) return Channel_Attribute
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Channel_Attribute;
         end List_Child;

         

         function Channel_Attribute_List_First (Node : Channel_Attribute_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Channel_Attribute_List_Next
           (Node : Channel_Attribute_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Channel_Attribute_List_Has_Element
           (Node : Channel_Attribute_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Channel_Attribute_List_Element
           (Node : Channel_Attribute_List; Cursor : Positive) return Channel_Attribute'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Channel_Attribute'(Child.As_Channel_Attribute);
         end;






         
   

   function F_Associations
     (Node : Checksum_Aspect'Class) return Checksum_Assoc_List
   is
      Result : Bare_Checksum_Assoc_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Aspect_F_Associations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Associations;







         
   

   function F_Identifier
     (Node : Checksum_Assoc'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Assoc_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Covered_Fields
     (Node : Checksum_Assoc'Class) return Base_Checksum_Val_List
   is
      Result : Bare_Base_Checksum_Val_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Assoc_F_Covered_Fields (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Covered_Fields;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Checksum_Assoc_List'Class; Index : Positive) return Checksum_Assoc
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Checksum_Assoc;
         end List_Child;

         

         function Checksum_Assoc_List_First (Node : Checksum_Assoc_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Checksum_Assoc_List_Next
           (Node : Checksum_Assoc_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Checksum_Assoc_List_Has_Element
           (Node : Checksum_Assoc_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Checksum_Assoc_List_Element
           (Node : Checksum_Assoc_List; Cursor : Positive) return Checksum_Assoc'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Checksum_Assoc'(Child.As_Checksum_Assoc);
         end;






         
   

   function F_Data
     (Node : Checksum_Val'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Val_F_Data (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Data;







         
   

   function F_First
     (Node : Checksum_Value_Range'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Value_Range_F_First (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_First;


         
   

   function F_Last
     (Node : Checksum_Value_Range'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Checksum_Value_Range_F_Last (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Last;







         
   

   function F_Selectors
     (Node : Choice'Class) return RFLX_Node_List
   is
      Result : Bare_RFLX_Node_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Choice_F_Selectors (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Selectors;


         
   

   function F_Expression
     (Node : Choice'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Choice_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Choice_List'Class; Index : Positive) return Choice
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Choice;
         end List_Child;

         

         function Choice_List_First (Node : Choice_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Choice_List_Next
           (Node : Choice_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Choice_List_Has_Element
           (Node : Choice_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Choice_List_Element
           (Node : Choice_List; Cursor : Positive) return Choice'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Choice'(Child.As_Choice);
         end;






         
   

   function F_Iterator
     (Node : Comprehension'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Comprehension_F_Iterator (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Iterator;


         
   

   function F_Sequence
     (Node : Comprehension'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Comprehension_F_Sequence (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Sequence;


         
   

   function F_Condition
     (Node : Comprehension'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Comprehension_F_Condition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Condition;


         
   

   function F_Selector
     (Node : Comprehension'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Comprehension_F_Selector (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Selector;












         
   

   function F_Left
     (Node : Concatenation'Class) return Sequence_Literal
   is
      Result : Bare_Sequence_Literal;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Concatenation_F_Left (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Left;


         
   

   function F_Right
     (Node : Concatenation'Class) return Sequence_Literal
   is
      Result : Bare_Sequence_Literal;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Concatenation_F_Right (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Right;







         
   

   function F_Target
     (Node : Transition'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Transition_F_Target (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Target;


         
   

   function F_Description
     (Node : Transition'Class) return Description
   is
      Result : Bare_Description;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Transition_F_Description (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Description;







         
   

   function F_Condition
     (Node : Conditional_Transition'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Conditional_Transition_F_Condition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Condition;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Conditional_Transition_List'Class; Index : Positive) return Conditional_Transition
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Conditional_Transition;
         end List_Child;

         

         function Conditional_Transition_List_First (Node : Conditional_Transition_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Conditional_Transition_List_Next
           (Node : Conditional_Transition_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Conditional_Transition_List_Has_Element
           (Node : Conditional_Transition_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Conditional_Transition_List_Element
           (Node : Conditional_Transition_List; Cursor : Positive) return Conditional_Transition'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Conditional_Transition'(Child.As_Conditional_Transition);
         end;






         
   

   function F_Item
     (Node : Context_Item'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Context_Item_F_Item (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Item;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Context_Item_List'Class; Index : Positive) return Context_Item
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Context_Item;
         end List_Child;

         

         function Context_Item_List_First (Node : Context_Item_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Context_Item_List_Next
           (Node : Context_Item_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Context_Item_List_Has_Element
           (Node : Context_Item_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Context_Item_List_Element
           (Node : Context_Item_List; Cursor : Positive) return Context_Item'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Context_Item'(Child.As_Context_Item);
         end;






         
   

   function F_Target_Identifier
     (Node : Conversion'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Conversion_F_Target_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Target_Identifier;


         
   

   function F_Argument
     (Node : Conversion'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Conversion_F_Argument (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Argument;










         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Declaration_List'Class; Index : Positive) return Declaration
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Declaration;
         end List_Child;

         

         function Declaration_List_First (Node : Declaration_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Declaration_List_Next
           (Node : Declaration_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Declaration_List_Has_Element
           (Node : Declaration_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Declaration_List_Element
           (Node : Declaration_List; Cursor : Positive) return Declaration'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Declaration'(Child.As_Declaration);
         end;






         
   

   function F_Content
     (Node : Description'Class) return String_Literal
   is
      Result : Bare_String_Literal;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Description_F_Content (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Content;







         
   

   function F_Identifier
     (Node : Element_Value_Assoc'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Element_Value_Assoc_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Literal
     (Node : Element_Value_Assoc'Class) return Numeric_Literal
   is
      Result : Bare_Numeric_Literal;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Element_Value_Assoc_F_Literal (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Literal;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Element_Value_Assoc_List'Class; Index : Positive) return Element_Value_Assoc
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Element_Value_Assoc;
         end List_Child;

         

         function Element_Value_Assoc_List_First (Node : Element_Value_Assoc_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Element_Value_Assoc_List_Next
           (Node : Element_Value_Assoc_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Element_Value_Assoc_List_Has_Element
           (Node : Element_Value_Assoc_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Element_Value_Assoc_List_Element
           (Node : Element_Value_Assoc_List; Cursor : Positive) return Element_Value_Assoc'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Element_Value_Assoc'(Child.As_Element_Value_Assoc);
         end;











         
   

   function F_Elements
     (Node : Enumeration_Type_Def'Class) return Enumeration_Def
   is
      Result : Bare_Enumeration_Def;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Enumeration_Type_Def_F_Elements (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Elements;


         
   

   function F_Aspects
     (Node : Enumeration_Type_Def'Class) return Aspect_List
   is
      Result : Bare_Aspect_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Enumeration_Type_Def_F_Aspects (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Aspects;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Expr_List'Class; Index : Positive) return Expr
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Expr;
         end List_Child;

         

         function Expr_List_First (Node : Expr_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Expr_List_Next
           (Node : Expr_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Expr_List_Has_Element
           (Node : Expr_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Expr_List_Element
           (Node : Expr_List; Cursor : Positive) return Expr'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Expr'(Child.As_Expr);
         end;











         
   

   function F_Identifier
     (Node : Formal_Channel_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Formal_Channel_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Parameters
     (Node : Formal_Channel_Decl'Class) return Channel_Attribute_List
   is
      Result : Bare_Channel_Attribute_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Formal_Channel_Decl_F_Parameters (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameters;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Formal_Decl_List'Class; Index : Positive) return Formal_Decl
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Formal_Decl;
         end List_Child;

         

         function Formal_Decl_List_First (Node : Formal_Decl_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Formal_Decl_List_Next
           (Node : Formal_Decl_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Formal_Decl_List_Has_Element
           (Node : Formal_Decl_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Formal_Decl_List_Element
           (Node : Formal_Decl_List; Cursor : Positive) return Formal_Decl'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Formal_Decl'(Child.As_Formal_Decl);
         end;






         
   

   function F_Identifier
     (Node : Formal_Function_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Formal_Function_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Parameters
     (Node : Formal_Function_Decl'Class) return Parameters
   is
      Result : Bare_Parameters;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Formal_Function_Decl_F_Parameters (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameters;


         
   

   function F_Return_Type_Identifier
     (Node : Formal_Function_Decl'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Formal_Function_Decl_F_Return_Type_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Return_Type_Identifier;







         
   

   function F_Package
     (Node : ID'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.ID_F_Package (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Package;


         
   

   function F_Name
     (Node : ID'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.ID_F_Name (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Name;















         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Local_Decl_List'Class; Index : Positive) return Local_Decl
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Local_Decl;
         end List_Child;

         

         function Local_Decl_List_First (Node : Local_Decl_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Local_Decl_List_Next
           (Node : Local_Decl_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Local_Decl_List_Has_Element
           (Node : Local_Decl_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Local_Decl_List_Element
           (Node : Local_Decl_List; Cursor : Positive) return Local_Decl'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Local_Decl'(Child.As_Local_Decl);
         end;






         
   

   function F_Identifier
     (Node : Message_Aggregate'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Aggregate_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Values
     (Node : Message_Aggregate'Class) return Base_Aggregate
   is
      Result : Bare_Base_Aggregate;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Aggregate_F_Values (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Values;







         
   

   function F_Identifier
     (Node : Message_Aggregate_Association'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Aggregate_Association_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Expression
     (Node : Message_Aggregate_Association'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Aggregate_Association_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Message_Aggregate_Association_List'Class; Index : Positive) return Message_Aggregate_Association
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Message_Aggregate_Association;
         end List_Child;

         

         function Message_Aggregate_Association_List_First (Node : Message_Aggregate_Association_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Message_Aggregate_Association_List_Next
           (Node : Message_Aggregate_Association_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Message_Aggregate_Association_List_Has_Element
           (Node : Message_Aggregate_Association_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Message_Aggregate_Association_List_Element
           (Node : Message_Aggregate_Association_List; Cursor : Positive) return Message_Aggregate_Association'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Message_Aggregate_Association'(Child.As_Message_Aggregate_Association);
         end;






         
   

   function F_Associations
     (Node : Message_Aggregate_Associations'Class) return Message_Aggregate_Association_List
   is
      Result : Bare_Message_Aggregate_Association_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Aggregate_Associations_F_Associations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Associations;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Message_Aspect_List'Class; Index : Positive) return Message_Aspect
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Message_Aspect;
         end List_Child;

         

         function Message_Aspect_List_First (Node : Message_Aspect_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Message_Aspect_List_Next
           (Node : Message_Aspect_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Message_Aspect_List_Has_Element
           (Node : Message_Aspect_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Message_Aspect_List_Element
           (Node : Message_Aspect_List; Cursor : Positive) return Message_Aspect'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Message_Aspect'(Child.As_Message_Aspect);
         end;






         
   

   function F_Identifier
     (Node : Message_Field'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Type_Identifier
     (Node : Message_Field'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Type_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Type_Identifier;


         
   

   function F_Type_Arguments
     (Node : Message_Field'Class) return Type_Argument_List
   is
      Result : Bare_Type_Argument_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Type_Arguments (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Type_Arguments;


         
   

   function F_Aspects
     (Node : Message_Field'Class) return Aspect_List
   is
      Result : Bare_Aspect_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Aspects (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Aspects;


         
   

   function F_Condition
     (Node : Message_Field'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Condition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Condition;


         
   

   function F_Thens
     (Node : Message_Field'Class) return Then_Node_List
   is
      Result : Bare_Then_Node_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_F_Thens (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Thens;







         
   

   function F_Message
     (Node : Message_Field_Assignment'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_Assignment_F_Message (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Message;


         
   

   function F_Field
     (Node : Message_Field_Assignment'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_Assignment_F_Field (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Field;


         
   

   function F_Expression
     (Node : Message_Field_Assignment'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Field_Assignment_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Message_Field_List'Class; Index : Positive) return Message_Field
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Message_Field;
         end List_Child;

         

         function Message_Field_List_First (Node : Message_Field_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Message_Field_List_Next
           (Node : Message_Field_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Message_Field_List_Has_Element
           (Node : Message_Field_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Message_Field_List_Element
           (Node : Message_Field_List; Cursor : Positive) return Message_Field'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Message_Field'(Child.As_Message_Field);
         end;






         
   

   function F_Initial_Field
     (Node : Message_Fields'Class) return Null_Message_Field
   is
      Result : Bare_Null_Message_Field;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Fields_F_Initial_Field (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Initial_Field;


         
   

   function F_Fields
     (Node : Message_Fields'Class) return Message_Field_List
   is
      Result : Bare_Message_Field_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Fields_F_Fields (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Fields;







         
   

   function F_Message_Fields
     (Node : Message_Type_Def'Class) return Message_Fields
   is
      Result : Bare_Message_Fields;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Type_Def_F_Message_Fields (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Message_Fields;


         
   

   function F_Aspects
     (Node : Message_Type_Def'Class) return Message_Aspect_List
   is
      Result : Bare_Message_Aspect_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Message_Type_Def_F_Aspects (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Aspects;







         
   

   function F_Mod
     (Node : Modular_Type_Def'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Modular_Type_Def_F_Mod (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Mod;







         
   

   function F_Elements
     (Node : Named_Enumeration_Def'Class) return Element_Value_Assoc_List
   is
      Result : Bare_Element_Value_Assoc_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Named_Enumeration_Def_F_Elements (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Elements;







         
   

   function F_Data
     (Node : Negation'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Negation_F_Data (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Data;

















         
   

   function F_Then
     (Node : Null_Message_Field'Class) return Then_Node
   is
      Result : Bare_Then_Node;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Null_Message_Field_F_Then (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Then;




















         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Numeric_Literal_List'Class; Index : Positive) return Numeric_Literal
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Numeric_Literal;
         end List_Child;

         

         function Numeric_Literal_List_First (Node : Numeric_Literal_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Numeric_Literal_List_Next
           (Node : Numeric_Literal_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Numeric_Literal_List_Has_Element
           (Node : Numeric_Literal_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Numeric_Literal_List_Element
           (Node : Numeric_Literal_List; Cursor : Positive) return Numeric_Literal'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Numeric_Literal'(Child.As_Numeric_Literal);
         end;



























































































         
   

   function F_Identifier
     (Node : Package_Node'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Package_Node_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Declarations
     (Node : Package_Node'Class) return Declaration_List
   is
      Result : Bare_Declaration_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Package_Node_F_Declarations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Declarations;


         
   

   function F_End_Identifier
     (Node : Package_Node'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Package_Node_F_End_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_End_Identifier;







         
   

   function F_Identifier
     (Node : Parameter'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Parameter_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Type_Identifier
     (Node : Parameter'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Parameter_F_Type_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Type_Identifier;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Parameter_List'Class; Index : Positive) return Parameter
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Parameter;
         end List_Child;

         

         function Parameter_List_First (Node : Parameter_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Parameter_List_Next
           (Node : Parameter_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Parameter_List_Has_Element
           (Node : Parameter_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Parameter_List_Element
           (Node : Parameter_List; Cursor : Positive) return Parameter'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Parameter'(Child.As_Parameter);
         end;






         
   

   function F_Parameters
     (Node : Parameters'Class) return Parameter_List
   is
      Result : Bare_Parameter_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Parameters_F_Parameters (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameters;







         
   

   function F_Data
     (Node : Paren_Expression'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Paren_Expression_F_Data (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Data;







         
   

   function F_Elements
     (Node : Positional_Enumeration_Def'Class) return UnqualifiedID_List
   is
      Result : Bare_UnqualifiedID_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Positional_Enumeration_Def_F_Elements (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Elements;







         
   

   function F_Operation
     (Node : Quantified_Expression'Class) return Quantifier
   is
      Result : Bare_Quantifier;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Quantified_Expression_F_Operation (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Operation;

         function F_Operation
           (Node : Quantified_Expression'Class) return RFLX_Quantifier
         is (Quantifier'(Node.F_Operation).Kind);

         
   

   function F_Parameter_Identifier
     (Node : Quantified_Expression'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Quantified_Expression_F_Parameter_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameter_Identifier;


         
   

   function F_Iterable
     (Node : Quantified_Expression'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Quantified_Expression_F_Iterable (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Iterable;


         
   

   function F_Predicate
     (Node : Quantified_Expression'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Quantified_Expression_F_Predicate (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Predicate;





















         

         function RFLX_Node_List_First (Node : RFLX_Node_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function RFLX_Node_List_Next
           (Node : RFLX_Node_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function RFLX_Node_List_Has_Element
           (Node : RFLX_Node_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function RFLX_Node_List_Element
           (Node : RFLX_Node_List; Cursor : Positive) return RFLX_Node'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return RFLX_Node'(Child.As_RFLX_Node);
         end;






         
   

   function F_First
     (Node : Range_Type_Def'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Range_Type_Def_F_First (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_First;


         
   

   function F_Last
     (Node : Range_Type_Def'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Range_Type_Def_F_Last (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Last;


         
   

   function F_Size
     (Node : Range_Type_Def'Class) return Aspect
   is
      Result : Bare_Aspect;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Range_Type_Def_F_Size (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Size;












         
   

   function F_Pdu
     (Node : Refinement_Decl'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Refinement_Decl_F_Pdu (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Pdu;


         
   

   function F_Field
     (Node : Refinement_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Refinement_Decl_F_Field (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Field;


         
   

   function F_Sdu
     (Node : Refinement_Decl'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Refinement_Decl_F_Sdu (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Sdu;


         
   

   function F_Condition
     (Node : Refinement_Decl'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Refinement_Decl_F_Condition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Condition;







         
   

   function F_Identifier
     (Node : Renaming_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Renaming_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Type_Identifier
     (Node : Renaming_Decl'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Renaming_Decl_F_Type_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Type_Identifier;


         
   

   function F_Expression
     (Node : Renaming_Decl'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Renaming_Decl_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;







         
   

   function F_Identifier
     (Node : Reset'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Reset_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Associations
     (Node : Reset'Class) return Message_Aggregate_Association_List
   is
      Result : Bare_Message_Aggregate_Association_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Reset_F_Associations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Associations;







         
   

   function F_Expression
     (Node : Select_Node'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Select_Node_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;


         
   

   function F_Selector
     (Node : Select_Node'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Select_Node_F_Selector (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Selector;







         
   

   function F_Values
     (Node : Sequence_Aggregate'Class) return Numeric_Literal_List
   is
      Result : Bare_Numeric_Literal_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Sequence_Aggregate_F_Values (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Values;







         
   

   function F_Element_Type
     (Node : Sequence_Type_Def'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Sequence_Type_Def_F_Element_Type (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Element_Type;







         
   

   function F_Initial
     (Node : Session_Aspects'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Aspects_F_Initial (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Initial;


         
   

   function F_Final
     (Node : Session_Aspects'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Aspects_F_Final (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Final;







         
   

   function F_Parameters
     (Node : Session_Decl'Class) return Formal_Decl_List
   is
      Result : Bare_Formal_Decl_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_Parameters (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameters;


         
   

   function F_Identifier
     (Node : Session_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Aspects
     (Node : Session_Decl'Class) return Session_Aspects
   is
      Result : Bare_Session_Aspects;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_Aspects (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Aspects;


         
   

   function F_Declarations
     (Node : Session_Decl'Class) return Local_Decl_List
   is
      Result : Bare_Local_Decl_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_Declarations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Declarations;


         
   

   function F_States
     (Node : Session_Decl'Class) return State_List
   is
      Result : Bare_State_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_States (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_States;


         
   

   function F_End_Identifier
     (Node : Session_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Session_Decl_F_End_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_End_Identifier;







         
   

   function F_Context_Clause
     (Node : Specification'Class) return Context_Item_List
   is
      Result : Bare_Context_Item_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Specification_F_Context_Clause (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Context_Clause;


         
   

   function F_Package_Declaration
     (Node : Specification'Class) return Package_Node
   is
      Result : Bare_Package_Node;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Specification_F_Package_Declaration (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Package_Declaration;







         
   

   function F_Identifier
     (Node : State'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Description
     (Node : State'Class) return Description
   is
      Result : Bare_Description;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_F_Description (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Description;


         
   

   function F_Body
     (Node : State'Class) return Base_State_Body
   is
      Result : Bare_Base_State_Body;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_F_Body (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Body;







         
   

   function F_Declarations
     (Node : State_Body'Class) return Local_Decl_List
   is
      Result : Bare_Local_Decl_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_Declarations (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Declarations;


         
   

   function F_Actions
     (Node : State_Body'Class) return Statement_List
   is
      Result : Bare_Statement_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_Actions (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Actions;


         
   

   function F_Conditional_Transitions
     (Node : State_Body'Class) return Conditional_Transition_List
   is
      Result : Bare_Conditional_Transition_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_Conditional_Transitions (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Conditional_Transitions;


         
   

   function F_Final_Transition
     (Node : State_Body'Class) return Transition
   is
      Result : Bare_Transition;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_Final_Transition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Final_Transition;


         
   

   function F_Exception_Transition
     (Node : State_Body'Class) return Transition
   is
      Result : Bare_Transition;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_Exception_Transition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Exception_Transition;


         
   

   function F_End_Identifier
     (Node : State_Body'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.State_Body_F_End_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_End_Identifier;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : State_List'Class; Index : Positive) return State
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_State;
         end List_Child;

         

         function State_List_First (Node : State_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function State_List_Next
           (Node : State_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function State_List_Has_Element
           (Node : State_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function State_List_Element
           (Node : State_List; Cursor : Positive) return State'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return State'(Child.As_State);
         end;




         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Statement_List'Class; Index : Positive) return Statement
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Statement;
         end List_Child;

         

         function Statement_List_First (Node : Statement_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Statement_List_Next
           (Node : Statement_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Statement_List_Has_Element
           (Node : Statement_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Statement_List_Element
           (Node : Statement_List; Cursor : Positive) return Statement'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Statement'(Child.As_Statement);
         end;











         
   

   function F_Identifier
     (Node : Term_Assoc'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Term_Assoc_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Expression
     (Node : Term_Assoc'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Term_Assoc_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Term_Assoc_List'Class; Index : Positive) return Term_Assoc
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Term_Assoc;
         end List_Child;

         

         function Term_Assoc_List_First (Node : Term_Assoc_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Term_Assoc_List_Next
           (Node : Term_Assoc_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Term_Assoc_List_Has_Element
           (Node : Term_Assoc_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Term_Assoc_List_Element
           (Node : Term_Assoc_List; Cursor : Positive) return Term_Assoc'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Term_Assoc'(Child.As_Term_Assoc);
         end;






         
   

   function F_Target
     (Node : Then_Node'Class) return AbstractID
   is
      Result : Bare_AbstractID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Then_Node_F_Target (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Target;


         
   

   function F_Aspects
     (Node : Then_Node'Class) return Aspect_List
   is
      Result : Bare_Aspect_List;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Then_Node_F_Aspects (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Aspects;


         
   

   function F_Condition
     (Node : Then_Node'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Then_Node_F_Condition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Condition;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Then_Node_List'Class; Index : Positive) return Then_Node
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Then_Node;
         end List_Child;

         

         function Then_Node_List_First (Node : Then_Node_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Then_Node_List_Next
           (Node : Then_Node_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Then_Node_List_Has_Element
           (Node : Then_Node_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Then_Node_List_Element
           (Node : Then_Node_List; Cursor : Positive) return Then_Node'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Then_Node'(Child.As_Then_Node);
         end;






         
   

   function F_Identifier
     (Node : Type_Argument'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Argument_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Expression
     (Node : Type_Argument'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Argument_F_Expression (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Expression;





         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : Type_Argument_List'Class; Index : Positive) return Type_Argument
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_Type_Argument;
         end List_Child;

         

         function Type_Argument_List_First (Node : Type_Argument_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function Type_Argument_List_Next
           (Node : Type_Argument_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function Type_Argument_List_Has_Element
           (Node : Type_Argument_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function Type_Argument_List_Element
           (Node : Type_Argument_List; Cursor : Positive) return Type_Argument'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return Type_Argument'(Child.As_Type_Argument);
         end;






         
   

   function F_Identifier
     (Node : Type_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Parameters
     (Node : Type_Decl'Class) return Parameters
   is
      Result : Bare_Parameters;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Decl_F_Parameters (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Parameters;


         
   

   function F_Definition
     (Node : Type_Decl'Class) return Type_Def
   is
      Result : Bare_Type_Def;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Decl_F_Definition (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Definition;







         
   

   function F_Base
     (Node : Type_Derivation_Def'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Type_Derivation_Def_F_Base (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Base;










         
         ----------------
         -- List_Child --
         ----------------

         function List_Child
           (Node : UnqualifiedID_List'Class; Index : Positive) return UnqualifiedID
         is
            Result : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Result := Node.Child (Index);
            return Result.As_UnqualifiedID;
         end List_Child;

         

         function UnqualifiedID_List_First (Node : UnqualifiedID_List) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return 1;
         end;

         function UnqualifiedID_List_Next
           (Node : UnqualifiedID_List; Cursor : Positive) return Positive is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor + 1;
         end;

         function UnqualifiedID_List_Has_Element
           (Node : UnqualifiedID_List; Cursor : Positive) return Boolean is
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            return Cursor in 1 .. Node.Children_Count;
         end;

         function UnqualifiedID_List_Element
           (Node : UnqualifiedID_List; Cursor : Positive) return UnqualifiedID'Class
         is
            Child : RFLX_Node;
         begin
            if Node.Internal.Node = null then
               raise Precondition_Failure with "null node argument";
            end if;

            Child := Node.Child (Cursor);
            return UnqualifiedID'(Child.As_UnqualifiedID);
         end;






         
   

   function F_Identifier
     (Node : Variable'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Variable_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;







         
   

   function F_Identifier
     (Node : Variable_Decl'Class) return UnqualifiedID
   is
      Result : Bare_UnqualifiedID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Variable_Decl_F_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Identifier;


         
   

   function F_Type_Identifier
     (Node : Variable_Decl'Class) return ID
   is
      Result : Bare_ID;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Variable_Decl_F_Type_Identifier (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Type_Identifier;


         
   

   function F_Initializer
     (Node : Variable_Decl'Class) return Expr
   is
      Result : Bare_Expr;
   begin
      if Node.Internal.Node = null then
         raise Precondition_Failure with "null node argument";
      end if;

      Check_Safety_Net (Node);
      Result := Implementation.Variable_Decl_F_Initializer (Node.Internal.Node);
         return (Internal   => (Result, Node.Internal.Info),
                 Safety_Net => Node.Safety_Net);
   end F_Initializer;










   --------------------
   -- Children_Count --
   --------------------

   function Children_Count
     (Node : RFLX_Node'Class) return Natural is
   begin
      Check_Safety_Net (Node);
      return Children_Count (Node.Internal.Node);
   end Children_Count;

   -----------------------
   -- First_Child_Index --
   -----------------------

   function First_Child_Index
     (Node : RFLX_Node'Class) return Natural is
   begin
      Check_Safety_Net (Node);
      return First_Child_Index (Node.Internal.Node);
   end First_Child_Index;

   ----------------------
   -- Last_Child_Index --
   ----------------------

   function Last_Child_Index
     (Node : RFLX_Node'Class) return Natural is
   begin
      Check_Safety_Net (Node);
      return Last_Child_Index (Node.Internal.Node);
   end Last_Child_Index;

   ---------------
   -- Get_Child --
   ---------------

   procedure Get_Child
     (Node            : RFLX_Node'Class;
      Index           : Positive;
      Index_In_Bounds : out Boolean;
      Result          : out RFLX_Node)
   is
      N : Bare_RFLX_Node;
   begin
      Check_Safety_Net (Node);
      Get_Child (Node.Internal.Node, Index, Index_In_Bounds, N);
      Result := Wrap_Node (N, Node.Internal.Info);
   end Get_Child;

   -----------
   -- Child --
   -----------

   function Child
     (Node  : RFLX_Node'Class;
      Index : Positive) return RFLX_Node
   is
   begin
      Check_Safety_Net (Node);
      return Wrap_Node (Child (Node.Internal.Node, Index), Node.Internal.Info);
   end Child;

   ----------------
   -- Sloc_Range --
   ----------------

   function Sloc_Range
     (Node : RFLX_Node'Class) return Source_Location_Range is
   begin
      Check_Safety_Net (Node);
      return Sloc_Range (Node.Internal.Node);
   end Sloc_Range;

   -------------
   -- Compare --
   -------------

   function Compare
     (Node : RFLX_Node'Class;
      Sloc : Source_Location) return Relative_Position is
   begin
      Check_Safety_Net (Node);
      return Compare (Node.Internal.Node, Sloc);
   end Compare;

   ------------
   -- Lookup --
   ------------

   function Lookup
     (Node : RFLX_Node'Class;
      Sloc : Source_Location) return RFLX_Node is
   begin
      Check_Safety_Net (Node);
      return Wrap_Node (Lookup (Node.Internal.Node, Sloc));
   end Lookup;

   ----------
   -- Text --
   ----------

   function Text (Node : RFLX_Node'Class) return Text_Type is
   begin
      Check_Safety_Net (Node);
      return Implementation.Text (Node.Internal.Node);
   end Text;

   -----------------
   -- Token_Range --
   -----------------

   function Token_Range
     (Node : RFLX_Node'Class) return Token_Iterator is
   begin
      Check_Safety_Net (Node);
      return Token_Iterator'(Node.As_RFLX_Node,
                             Node.Internal.Node.Token_End_Index);
   end Token_Range;

   -----------
   -- Print --
   -----------

   procedure Print
     (Node        : RFLX_Node'Class;
      Show_Slocs  : Boolean := True;
      Line_Prefix : String := "") is
   begin
      Check_Safety_Net (Node);
      Print (Node.Internal.Node, Show_Slocs, Line_Prefix);
   end Print;

   ---------------
   -- PP_Trivia --
   ---------------

   procedure PP_Trivia
     (Node : RFLX_Node'Class; Line_Prefix : String := "") is
   begin
      Check_Safety_Net (Node);
      PP_Trivia (Node.Internal.Node, Line_Prefix);
   end PP_Trivia;

   --------------
   -- Traverse --
   --------------

   function Traverse
     (Node  : RFLX_Node'Class;
      Visit : access function (Node : RFLX_Node'Class)
              return Visit_Status)
      return Visit_Status
   is
      Info : constant Internal_Entity_Info := Node.Internal.Info;

      -------------
      -- Wrapper --
      -------------

      function Wrapper (Node : Bare_RFLX_Node) return Visit_Status
      is
         Public_Node : constant RFLX_Node :=
           Wrap_Node (Bare_RFLX_Node (Node), Info);
      begin
         return Visit (Public_Node);
      end Wrapper;

   begin
      Check_Safety_Net (Node);
      return Traverse (Node.Internal.Node, Wrapper'Access);
   end Traverse;

   --------------
   -- Traverse --
   --------------

   procedure Traverse
     (Node  : RFLX_Node'Class;
      Visit : access function (Node : RFLX_Node'Class)
                               return Visit_Status)
   is
      Result_Status : Visit_Status;
      pragma Unreferenced (Result_Status);
   begin
      Result_Status := Traverse (Node, Visit);
   end Traverse;

   --------------------------------
   -- Assign_Names_To_Logic_Vars --
   --------------------------------

   procedure Assign_Names_To_Logic_Vars (Node : RFLX_Node'Class)
   is
   begin
      Check_Safety_Net (Node);
      Assign_Names_To_Logic_Vars (Node.Internal.Node);
   end Assign_Names_To_Logic_Vars;

   -------------------------
   -- Children_And_Trivia --
   -------------------------

   function Children_And_Trivia
     (Node : RFLX_Node'Class) return Children_Array
   is
   begin
      Check_Safety_Net (Node);
      declare
         Bare_Result : constant Bare_Children_Array :=
            Children_And_Trivia (Unwrap_Node (Node));
         Result      : Children_Array (Bare_Result'Range);
      begin
         for I in Bare_Result'Range loop
            declare
               BR : Bare_Child_Record renames Bare_Result (I);
               R  : Child_Record renames Result (I);
            begin
               case BR.Kind is
                  when Child =>
                     R := (Child, Wrap_Node (BR.Node));
                  when Trivia =>
                     R := (Trivia, BR.Trivia);
               end case;
            end;
         end loop;
         return Result;
      end;
   end Children_And_Trivia;

   -----------------
   -- First_Token --
   -----------------

   function First_Token (Self : Token_Iterator) return Token_Reference is
   begin
      Check_Safety_Net (Self.Node);
      return Token_Start (Self.Node);
   end First_Token;

   ----------------
   -- Next_Token --
   ----------------

   function Next_Token
     (Self : Token_Iterator; Tok : Token_Reference) return Token_Reference is
   begin
      Check_Safety_Net (Self.Node);
      return Next (Tok);
   end Next_Token;

   -----------------
   -- Has_Element --
   -----------------

   function Has_Element
     (Self : Token_Iterator; Tok : Token_Reference) return Boolean is
   begin
      Check_Safety_Net (Self.Node);
      return Get_Token_Index (Tok).Token <= Self.Last;
   end Has_Element;

   -------------
   -- Element --
   -------------

   function Element
     (Self : Token_Iterator; Tok : Token_Reference) return Token_Reference is
   begin
      Check_Safety_Net (Self.Node);
      return Tok;
   end Element;

   ----------------
   -- Initialize --
   ----------------

   overriding procedure Initialize (Context : in out Analysis_Context) is
   begin
      Context.Internal := null;
   end Initialize;

   ------------
   -- Adjust --
   ------------

   overriding procedure Adjust (Context : in out Analysis_Context) is
   begin
      Inc_Ref (Unwrap_Context (Context));
   end Adjust;

   --------------
   -- Finalize --
   --------------

   overriding procedure Finalize (Context : in out Analysis_Context) is
      Ctx : Internal_Context := Unwrap_Context (Context);
   begin
      Dec_Ref (Ctx);
      Context.Internal := null;
   end Finalize;

   ----------------------------------------------------
   -- Soft links for public/internal type converters --
   ----------------------------------------------------

   function Wrap_Context (Context : Internal_Context) return Analysis_Context;
   function Unwrap_Context
     (Context : Analysis_Context'Class) return Internal_Context;

   function Wrap_Unit (Unit : Internal_Unit) return Analysis_Unit;
   function Unwrap_Unit (Unit : Analysis_Unit'Class) return Internal_Unit;

   function Wrap_Node
     (Node : Bare_RFLX_Node;
      Info : Internal_Entity_Info := No_Entity_Info)
      return RFLX_Node;
   function Unwrap_Node
     (Node : RFLX_Node'Class) return Bare_RFLX_Node;
   function Unwrap_Entity
     (Entity : RFLX_Node'Class) return Internal_Entity;

   ------------------
   -- Wrap_Context --
   ------------------

   function Wrap_Context (Context : Internal_Context) return Analysis_Context
   is
   begin
      Inc_Ref (Context);
      return (Ada.Finalization.Controlled with
              Internal => Internal_Context_Access (Context));
   end Wrap_Context;

   --------------------
   -- Unwrap_Context --
   --------------------

   function Unwrap_Context
     (Context : Analysis_Context'Class) return Internal_Context
   is (Internal_Context (Context.Internal));

   ---------------
   -- Wrap_Unit --
   ---------------

   function Wrap_Unit (Unit : Internal_Unit) return Analysis_Unit
   is ((Internal => Internal_Unit_Access (Unit),
        Context  => Wrap_Context (Context (Unit))));

   -----------------
   -- Unwrap_Unit --
   -----------------

   function Unwrap_Unit (Unit : Analysis_Unit'Class) return Internal_Unit
   is (Internal_Unit (Unit.Internal));

   ----------------------
   -- Check_Safety_Net --
   ----------------------

   procedure Check_Safety_Net (Self : RFLX_Node'Class) is
      R  : Env_Rebindings renames Self.Internal.Info.Rebindings;
      SN : Node_Safety_Net renames Self.Safety_Net;
   begin
      if SN.Context = null then
         return;
      end if;

      --  Check that SN's context has not been released (see the Context_Pool)
      if
         SN.Context.Released
         or else SN.Context.Serial_Number /= SN.Context_Serial
      then
         raise Stale_Reference_Error with "context was released";

      --  Then check that the unit version is the same
      elsif SN.Unit.Unit_Version /= SN.Unit_Version then
         raise Stale_Reference_Error with "unit was reparsed";

      --  Then check that the R rebindings reference, if not-null, is not stale
      elsif R /= null and then R.Version /= SN.Rebindings_Version then
         raise Stale_Reference_Error with "related unit was reparsed";
      end if;
   end Check_Safety_Net;

   ---------------
   -- Wrap_Node --
   ---------------

   function Wrap_Node
     (Node : Bare_RFLX_Node;
      Info : Internal_Entity_Info := No_Entity_Info)
      return RFLX_Node is
   begin
      if Node = null then
         return No_RFLX_Node;
      end if;

      declare
         Unit               : constant Internal_Unit := Node.Unit;
         Context            : constant Internal_Context := Unit.Context;
         Rebindings_Version : constant Version_Number :=
           (if Info.Rebindings = null
            then 0
            else Info.Rebindings.Version);
      begin
         return ((Internal   => (Node, Info),
                  Safety_Net => (Context            => Context,
                                 Context_Serial     => Context.Serial_Number,
                                 Unit               => Unit,
                                 Unit_Version       => Unit.Unit_Version,
                                 Rebindings_Version => Rebindings_Version)));
      end;
   end;

   -----------------
   -- Unwrap_Node --
   -----------------

   function Unwrap_Node
     (Node : RFLX_Node'Class) return Bare_RFLX_Node
   is (Node.Internal.Node);

   -------------------
   -- Unwrap_Entity --
   -------------------

   function Unwrap_Entity
     (Entity : RFLX_Node'Class) return Internal_Entity
   is ((Entity.Internal));

   


begin
   Public_Converters.Wrap_Context := Wrap_Context'Access;
   Public_Converters.Unwrap_Context := Unwrap_Context'Access;
   Public_Converters.Wrap_Unit := Wrap_Unit'Access;
   Public_Converters.Unwrap_Unit := Unwrap_Unit'Access;
   Public_Converters.Wrap_Node := Wrap_Node'Access;
   Public_Converters.Unwrap_Node := Unwrap_Node'Access;
   Public_Converters.Unwrap_Entity := Unwrap_Entity'Access;
end Librflxlang.Analysis;
