# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['fastoad',
 'fastoad.cmd',
 'fastoad.cmd.resources',
 'fastoad.cmd.tests',
 'fastoad.cmd.tests.data.sellar_example',
 'fastoad.io',
 'fastoad.io.configuration',
 'fastoad.io.configuration.tests',
 'fastoad.io.configuration.tests.data.sellar_example',
 'fastoad.io.xml',
 'fastoad.io.xml.resources',
 'fastoad.io.xml.tests',
 'fastoad.models',
 'fastoad.models.aerodynamics',
 'fastoad.models.aerodynamics.components',
 'fastoad.models.aerodynamics.components.resources',
 'fastoad.models.aerodynamics.components.tests',
 'fastoad.models.aerodynamics.external',
 'fastoad.models.aerodynamics.external.xfoil',
 'fastoad.models.aerodynamics.external.xfoil.resources',
 'fastoad.models.aerodynamics.external.xfoil.tests',
 'fastoad.models.aerodynamics.external.xfoil.xfoil699',
 'fastoad.models.aerodynamics.tests',
 'fastoad.models.geometry',
 'fastoad.models.geometry.geom_components',
 'fastoad.models.geometry.geom_components.fuselage',
 'fastoad.models.geometry.geom_components.ht',
 'fastoad.models.geometry.geom_components.ht.components',
 'fastoad.models.geometry.geom_components.nacelle_pylons',
 'fastoad.models.geometry.geom_components.vt',
 'fastoad.models.geometry.geom_components.vt.components',
 'fastoad.models.geometry.geom_components.wing',
 'fastoad.models.geometry.geom_components.wing.components',
 'fastoad.models.geometry.profiles',
 'fastoad.models.geometry.resources',
 'fastoad.models.geometry.tests',
 'fastoad.models.handling_qualities',
 'fastoad.models.handling_qualities.tail_sizing',
 'fastoad.models.handling_qualities.tests',
 'fastoad.models.loops',
 'fastoad.models.loops.tests',
 'fastoad.models.performances',
 'fastoad.models.performances.tests',
 'fastoad.models.propulsion',
 'fastoad.models.propulsion.fuel_engine',
 'fastoad.models.propulsion.fuel_engine.rubber_engine',
 'fastoad.models.propulsion.fuel_engine.rubber_engine.tests',
 'fastoad.models.weight',
 'fastoad.models.weight.cg',
 'fastoad.models.weight.cg.cg_components',
 'fastoad.models.weight.cg.tests',
 'fastoad.models.weight.mass_breakdown',
 'fastoad.models.weight.mass_breakdown.a_airframe',
 'fastoad.models.weight.mass_breakdown.b_propulsion',
 'fastoad.models.weight.mass_breakdown.c_systems',
 'fastoad.models.weight.mass_breakdown.d_furniture',
 'fastoad.models.weight.mass_breakdown.e_crew',
 'fastoad.models.weight.mass_breakdown.tests',
 'fastoad.module_management',
 'fastoad.module_management.tests',
 'fastoad.module_management.tests.dummy_pelix_bundles',
 'fastoad.module_management.tests.sellar_example',
 'fastoad.notebooks',
 'fastoad.notebooks.tutorial',
 'fastoad.notebooks.tutorial.data',
 'fastoad.notebooks.tutorial.img',
 'fastoad.openmdao',
 'fastoad.openmdao.resources',
 'fastoad.openmdao.tests',
 'fastoad.openmdao.tests.sellar_example',
 'fastoad.utils',
 'fastoad.utils.physics',
 'fastoad.utils.physics.tests',
 'fastoad.utils.postprocessing',
 'fastoad.utils.postprocessing.tests',
 'fastoad.utils.postprocessing.tests.data.sellar_example',
 'fastoad.utils.resource_management',
 'fastoad.utils.tests']

package_data = \
{'': ['*'],
 'fastoad.cmd.tests': ['data/*'],
 'fastoad.io.configuration.tests': ['data/*'],
 'fastoad.io.xml.tests': ['data/*'],
 'fastoad.models.aerodynamics.components.tests': ['data/*'],
 'fastoad.models.aerodynamics.tests': ['data/*'],
 'fastoad.models.geometry.tests': ['data/*'],
 'fastoad.models.handling_qualities.tests': ['data/*'],
 'fastoad.models.weight.cg.tests': ['data/*'],
 'fastoad.models.weight.mass_breakdown.tests': ['data/*'],
 'fastoad.utils.postprocessing.tests': ['data/*']}

install_requires = \
['importlib_resources',
 'ipopo>=1,<2',
 'ipysheet',
 'ipywidgets',
 'jupyterlab',
 'lxml',
 'matplotlib',
 'numpy',
 'openmdao>=3,<4',
 'pandas>=1,<2',
 'plotly',
 'scipy',
 'tomlkit>=0.6.0,<0.7.0',
 'wop>=1.9.0,<2.0.0']

entry_points = \
{'console_scripts': ['fastoad = fastoad.cmd.fast:main']}

setup_kwargs = {
    'name': 'fast-oad',
    'version': '0.2.1b0',
    'description': 'FAST-OAD is a framework for performing rapid Overall Aircraft Design',
    'long_description': '![Tests](https://github.com/fast-aircraft-design/FAST-OAD/workflows/Tests/badge.svg)\n[![codecov](https://codecov.io/gh/fast-aircraft-design/FAST-OAD/branch/master/graph/badge.svg)](https://codecov.io/gh/fast-aircraft-design/FAST-OAD)\n[![Documentation Status](https://readthedocs.org/projects/fast-oad/badge/?version=latest)](https://fast-oad.readthedocs.io/en/latest/?badge=latest)\n[![Codacy Badge](https://app.codacy.com/project/badge/Grade/9691f1d1430c45cf9c94bc342b4c6122)](https://www.codacy.com/gh/fast-aircraft-design/FAST-OAD?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=fast-aircraft-design/FAST-OAD&amp;utm_campaign=Badge_Grade)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)\n\nFAST-OAD: Future Aircraft Sizing Tool - Overall Aircraft Design\n===============================================================\n\nFAST-OAD is a framework for performing rapid Overall Aircraft Design.\n\nIt proposes multi-disciplinary analysis and optimisation by relying on\nthe [OpenMDAO framework](https://openmdao.org/).\n\nFAST-OAD allows easy switching between models for a same discipline, and\nalso adding/removing disciplines to match the need of your study.\n\nCurrently, FAST-OAD is bundled with models for commercial transport\naircraft of years 1990-2000. Other models will come and you may create\nyour own models and use them instead of bundled ones.\n\nMore details can be found in the [official\ndocumentation](https://fast-oad.readthedocs.io/).\n\nInstall\n-------\n\n**Prerequisite**:FAST-OAD needs at least **Python 3.6.1** (usage of\n**Python 3.8.**\\* is discouraged on Windows: some additional features of\n FAST-OAD require Jupyter notebooks, which are for now\n [not\ncompatible with\nit](https://github.com/jupyterlab/jupyterlab/issues/6487)).\n\nIt is recommended (but not required) to install FAST-OAD in a virtual\nenvironment ([conda](https://docs.conda.io/en/latest/),\n[venv](https://docs.python.org/3.7/library/venv.html), ...)\n\nOnce Python is installed, FAST-OAD can be installed using pip.\n\n> **Note**: If your network uses a proxy, you may have to do [some\n> settings](https://pip.pypa.io/en/stable/user_guide/#using-a-proxy-server)\n> for pip to work correctly\n\nYou can install the latest version with this command:\n\n``` {.bash}\n$ pip install --upgrade fast-oad\n```\n',
    'author': 'Christophe DAVID',
    'author_email': 'christophe.david@onera.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fast-aircraft-design/FAST-OAD',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
