"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wordpress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_backup_1 = require("@aws-cdk/aws-backup");
const aws_certificatemanager_1 = require("@aws-cdk/aws-certificatemanager");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const application_1 = require("./application");
const database_1 = require("./database");
const efs_volume_1 = require("./efs-volume");
class Wordpress extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const staticContentDomainName = `static.${props.domainName}`;
        const subjectAlternativeNames = (_b = props.subjectAlternativeNames) !== null && _b !== void 0 ? _b : [];
        if (props.offloadStaticContent) {
            subjectAlternativeNames.push(staticContentDomainName);
        }
        const certificate = new aws_certificatemanager_1.DnsValidatedCertificate(this, 'Certificate', {
            domainName: props.domainName,
            hostedZone: props.domainZone,
            subjectAlternativeNames,
            region: 'us-east-1',
        });
        const vpc = (_c = props.vpc) !== null && _c !== void 0 ? _c : new aws_ec2_1.Vpc(this, 'Vpc', {
            maxAzs: 2,
        });
        this.volume = (_d = props.volume) !== null && _d !== void 0 ? _d : new efs_volume_1.EfsVolume(this, 'Volume', {
            vpc,
            removalPolicy: props.removalPolicy,
        });
        this.database = (_e = props.database) !== null && _e !== void 0 ? _e : new database_1.Database(this, 'Database', {
            vpc,
            removalPolicy: props.removalPolicy,
        });
        this.application = new application_1.Application(this, 'Application', {
            domainName: props.domainName,
            domainZone: props.domainZone,
            certificate,
            vpc,
            volume: this.volume,
            database: this.database,
            image: props.image,
            serviceName: props.serviceName,
            memoryLimitMiB: props.memoryLimitMiB,
            environment: props.environment,
            secrets: props.secrets,
            logDriver: props.logDriver,
            cloudFrontHashHeader: props.cloudFrontHashHeader,
            removalPolicy: props.removalPolicy,
        });
        this.database.allowDefaultPortFrom(this.application.service);
        this.volume.allowDefaultPortFrom(this.application.service);
        if (props.offloadStaticContent) {
            this.staticContentOffload = this.application.enableStaticContentOffload(staticContentDomainName, certificate);
        }
        if (props.backupPlan) {
            if (props.removalPolicy) {
                props.backupPlan.applyRemovalPolicy(props.removalPolicy);
            }
            props.backupPlan.addSelection('BackupPlanSelection', {
                resources: [aws_backup_1.BackupResource.fromConstruct(this)],
            });
        }
    }
}
exports.Wordpress = Wordpress;
_a = JSII_RTTI_SYMBOL_1;
Wordpress[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Wordpress", version: "1.48.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid29yZHByZXNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3dvcmRwcmVzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLG9EQUFpRTtBQUNqRSw0RUFBMEU7QUFDMUUsOENBQTZDO0FBRzdDLHdDQUF5RDtBQUV6RCwrQ0FBa0U7QUFDbEUseUNBQXNDO0FBQ3RDLDZDQUF5QztBQXFCekMsTUFBYSxTQUFVLFNBQVEsZ0JBQVM7SUFNdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFxQjs7UUFDN0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLHVCQUF1QixHQUFHLFVBQVUsS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBQzdELE1BQU0sdUJBQXVCLFNBQUcsS0FBSyxDQUFDLHVCQUF1QixtQ0FBSSxFQUFFLENBQUM7UUFDcEUsSUFBSSxLQUFLLENBQUMsb0JBQW9CLEVBQUU7WUFDOUIsdUJBQXVCLENBQUMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLENBQUM7U0FDdkQ7UUFFRCxNQUFNLFdBQVcsR0FBRyxJQUFJLGdEQUF1QixDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7WUFDbkUsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1Qix1QkFBdUI7WUFDdkIsTUFBTSxFQUFFLFdBQVc7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxHQUFHLFNBQ1AsS0FBSyxDQUFDLEdBQUcsbUNBQ1QsSUFBSSxhQUFHLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRTtZQUNuQixNQUFNLEVBQUUsQ0FBQztTQUNWLENBQUMsQ0FBQztRQUVMLElBQUksQ0FBQyxNQUFNLFNBQ1QsS0FBSyxDQUFDLE1BQU0sbUNBQ1osSUFBSSxzQkFBUyxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7WUFDNUIsR0FBRztZQUNILGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNuQyxDQUFDLENBQUM7UUFFTCxJQUFJLENBQUMsUUFBUSxTQUNYLEtBQUssQ0FBQyxRQUFRLG1DQUNkLElBQUksbUJBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdCLEdBQUc7WUFDSCxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7U0FDbkMsQ0FBQyxDQUFDO1FBRUwsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLHlCQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUN0RCxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLFdBQVc7WUFDWCxHQUFHO1lBQ0gsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixvQkFBb0IsRUFBRSxLQUFLLENBQUMsb0JBQW9CO1lBQ2hELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNuQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsUUFBUSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDN0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRTNELElBQUksS0FBSyxDQUFDLG9CQUFvQixFQUFFO1lBQzlCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLDBCQUEwQixDQUFDLHVCQUF1QixFQUFFLFdBQVcsQ0FBQyxDQUFDO1NBQy9HO1FBRUQsSUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO1lBQ3BCLElBQUksS0FBSyxDQUFDLGFBQWEsRUFBRTtnQkFDdkIsS0FBSyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7YUFDMUQ7WUFDRCxLQUFLLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxxQkFBcUIsRUFBRTtnQkFDbkQsU0FBUyxFQUFFLENBQUMsMkJBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDaEQsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDOztBQTFFSCw4QkEyRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBCYWNrdXBQbGFuLCBCYWNrdXBSZXNvdXJjZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1iYWNrdXAnO1xuaW1wb3J0IHsgRG5zVmFsaWRhdGVkQ2VydGlmaWNhdGUgfSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcbmltcG9ydCB7IElWcGMsIFZwYyB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0IHsgQ29udGFpbmVySW1hZ2UsIExvZ0RyaXZlciwgU2VjcmV0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWVjcyc7XG5pbXBvcnQgeyBJSG9zdGVkWm9uZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IENvbnN0cnVjdCwgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5pbXBvcnQgeyBBcHBsaWNhdGlvbiwgU3RhdGljQ29udGVudE9mZmxvYWQgfSBmcm9tICcuL2FwcGxpY2F0aW9uJztcbmltcG9ydCB7IERhdGFiYXNlIH0gZnJvbSAnLi9kYXRhYmFzZSc7XG5pbXBvcnQgeyBFZnNWb2x1bWUgfSBmcm9tICcuL2Vmcy12b2x1bWUnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFdvcmRwcmVzc1Byb3BzIHtcbiAgcmVhZG9ubHkgZG9tYWluTmFtZTogc3RyaW5nO1xuICByZWFkb25seSBkb21haW5ab25lOiBJSG9zdGVkWm9uZTtcbiAgcmVhZG9ubHkgc3ViamVjdEFsdGVybmF0aXZlTmFtZXM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgdnBjPzogSVZwYztcbiAgcmVhZG9ubHkgdm9sdW1lPzogRWZzVm9sdW1lO1xuICByZWFkb25seSBkYXRhYmFzZT86IERhdGFiYXNlO1xuICByZWFkb25seSBpbWFnZT86IENvbnRhaW5lckltYWdlO1xuICByZWFkb25seSBlbnZpcm9ubWVudD86IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG4gIHJlYWRvbmx5IHNlY3JldHM/OiBSZWNvcmQ8c3RyaW5nLCBTZWNyZXQ+O1xuICByZWFkb25seSBzZXJ2aWNlTmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgbWVtb3J5TGltaXRNaUI/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGxvZ0RyaXZlcj86IExvZ0RyaXZlcjtcbiAgcmVhZG9ubHkgYmFja3VwUGxhbj86IEJhY2t1cFBsYW47XG4gIHJlYWRvbmx5IGNsb3VkRnJvbnRIYXNoSGVhZGVyPzogc3RyaW5nO1xuICByZWFkb25seSBvZmZsb2FkU3RhdGljQ29udGVudD86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHJlbW92YWxQb2xpY3k/OiBSZW1vdmFsUG9saWN5O1xufVxuXG5leHBvcnQgY2xhc3MgV29yZHByZXNzIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGFwcGxpY2F0aW9uOiBBcHBsaWNhdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGRhdGFiYXNlOiBEYXRhYmFzZTtcbiAgcHVibGljIHJlYWRvbmx5IHZvbHVtZTogRWZzVm9sdW1lO1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhdGljQ29udGVudE9mZmxvYWQ/OiBTdGF0aWNDb250ZW50T2ZmbG9hZDtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogV29yZHByZXNzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3Qgc3RhdGljQ29udGVudERvbWFpbk5hbWUgPSBgc3RhdGljLiR7cHJvcHMuZG9tYWluTmFtZX1gO1xuICAgIGNvbnN0IHN1YmplY3RBbHRlcm5hdGl2ZU5hbWVzID0gcHJvcHMuc3ViamVjdEFsdGVybmF0aXZlTmFtZXMgPz8gW107XG4gICAgaWYgKHByb3BzLm9mZmxvYWRTdGF0aWNDb250ZW50KSB7XG4gICAgICBzdWJqZWN0QWx0ZXJuYXRpdmVOYW1lcy5wdXNoKHN0YXRpY0NvbnRlbnREb21haW5OYW1lKTtcbiAgICB9XG5cbiAgICBjb25zdCBjZXJ0aWZpY2F0ZSA9IG5ldyBEbnNWYWxpZGF0ZWRDZXJ0aWZpY2F0ZSh0aGlzLCAnQ2VydGlmaWNhdGUnLCB7XG4gICAgICBkb21haW5OYW1lOiBwcm9wcy5kb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZTogcHJvcHMuZG9tYWluWm9uZSxcbiAgICAgIHN1YmplY3RBbHRlcm5hdGl2ZU5hbWVzLFxuICAgICAgcmVnaW9uOiAndXMtZWFzdC0xJyxcbiAgICB9KTtcblxuICAgIGNvbnN0IHZwYyA9XG4gICAgICBwcm9wcy52cGMgPz9cbiAgICAgIG5ldyBWcGModGhpcywgJ1ZwYycsIHtcbiAgICAgICAgbWF4QXpzOiAyLFxuICAgICAgfSk7XG5cbiAgICB0aGlzLnZvbHVtZSA9XG4gICAgICBwcm9wcy52b2x1bWUgPz9cbiAgICAgIG5ldyBFZnNWb2x1bWUodGhpcywgJ1ZvbHVtZScsIHtcbiAgICAgICAgdnBjLFxuICAgICAgICByZW1vdmFsUG9saWN5OiBwcm9wcy5yZW1vdmFsUG9saWN5LFxuICAgICAgfSk7XG5cbiAgICB0aGlzLmRhdGFiYXNlID1cbiAgICAgIHByb3BzLmRhdGFiYXNlID8/XG4gICAgICBuZXcgRGF0YWJhc2UodGhpcywgJ0RhdGFiYXNlJywge1xuICAgICAgICB2cGMsXG4gICAgICAgIHJlbW92YWxQb2xpY3k6IHByb3BzLnJlbW92YWxQb2xpY3ksXG4gICAgICB9KTtcblxuICAgIHRoaXMuYXBwbGljYXRpb24gPSBuZXcgQXBwbGljYXRpb24odGhpcywgJ0FwcGxpY2F0aW9uJywge1xuICAgICAgZG9tYWluTmFtZTogcHJvcHMuZG9tYWluTmFtZSxcbiAgICAgIGRvbWFpblpvbmU6IHByb3BzLmRvbWFpblpvbmUsXG4gICAgICBjZXJ0aWZpY2F0ZSxcbiAgICAgIHZwYyxcbiAgICAgIHZvbHVtZTogdGhpcy52b2x1bWUsXG4gICAgICBkYXRhYmFzZTogdGhpcy5kYXRhYmFzZSxcbiAgICAgIGltYWdlOiBwcm9wcy5pbWFnZSxcbiAgICAgIHNlcnZpY2VOYW1lOiBwcm9wcy5zZXJ2aWNlTmFtZSxcbiAgICAgIG1lbW9yeUxpbWl0TWlCOiBwcm9wcy5tZW1vcnlMaW1pdE1pQixcbiAgICAgIGVudmlyb25tZW50OiBwcm9wcy5lbnZpcm9ubWVudCxcbiAgICAgIHNlY3JldHM6IHByb3BzLnNlY3JldHMsXG4gICAgICBsb2dEcml2ZXI6IHByb3BzLmxvZ0RyaXZlcixcbiAgICAgIGNsb3VkRnJvbnRIYXNoSGVhZGVyOiBwcm9wcy5jbG91ZEZyb250SGFzaEhlYWRlcixcbiAgICAgIHJlbW92YWxQb2xpY3k6IHByb3BzLnJlbW92YWxQb2xpY3ksXG4gICAgfSk7XG5cbiAgICB0aGlzLmRhdGFiYXNlLmFsbG93RGVmYXVsdFBvcnRGcm9tKHRoaXMuYXBwbGljYXRpb24uc2VydmljZSk7XG4gICAgdGhpcy52b2x1bWUuYWxsb3dEZWZhdWx0UG9ydEZyb20odGhpcy5hcHBsaWNhdGlvbi5zZXJ2aWNlKTtcblxuICAgIGlmIChwcm9wcy5vZmZsb2FkU3RhdGljQ29udGVudCkge1xuICAgICAgdGhpcy5zdGF0aWNDb250ZW50T2ZmbG9hZCA9IHRoaXMuYXBwbGljYXRpb24uZW5hYmxlU3RhdGljQ29udGVudE9mZmxvYWQoc3RhdGljQ29udGVudERvbWFpbk5hbWUsIGNlcnRpZmljYXRlKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMuYmFja3VwUGxhbikge1xuICAgICAgaWYgKHByb3BzLnJlbW92YWxQb2xpY3kpIHtcbiAgICAgICAgcHJvcHMuYmFja3VwUGxhbi5hcHBseVJlbW92YWxQb2xpY3kocHJvcHMucmVtb3ZhbFBvbGljeSk7XG4gICAgICB9XG4gICAgICBwcm9wcy5iYWNrdXBQbGFuLmFkZFNlbGVjdGlvbignQmFja3VwUGxhblNlbGVjdGlvbicsIHtcbiAgICAgICAgcmVzb3VyY2VzOiBbQmFja3VwUmVzb3VyY2UuZnJvbUNvbnN0cnVjdCh0aGlzKV0sXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==