import { BackupPlan } from '@aws-cdk/aws-backup';
import { IVpc } from '@aws-cdk/aws-ec2';
import { ContainerImage, LogDriver, Secret } from '@aws-cdk/aws-ecs';
import { IHostedZone } from '@aws-cdk/aws-route53';
import { Construct, RemovalPolicy } from '@aws-cdk/core';
import { Application, StaticContentOffload } from './application';
import { Database } from './database';
import { EfsVolume } from './efs-volume';
export interface WordpressProps {
    readonly domainName: string;
    readonly domainZone: IHostedZone;
    readonly subjectAlternativeNames?: string[];
    readonly vpc?: IVpc;
    readonly volume?: EfsVolume;
    readonly database?: Database;
    readonly image?: ContainerImage;
    readonly environment?: Record<string, string>;
    readonly secrets?: Record<string, Secret>;
    readonly serviceName?: string;
    readonly memoryLimitMiB?: number;
    readonly logDriver?: LogDriver;
    readonly backupPlan?: BackupPlan;
    readonly cloudFrontHashHeader?: string;
    readonly offloadStaticContent?: boolean;
    readonly removalPolicy?: RemovalPolicy;
}
export declare class Wordpress extends Construct {
    readonly application: Application;
    readonly database: Database;
    readonly volume: EfsVolume;
    readonly staticContentOffload?: StaticContentOffload;
    constructor(scope: Construct, id: string, props: WordpressProps);
}
