# Generated by Django 4.1.6 on 2023-02-20 12:41

from django.contrib.auth import get_user_model
from django.core.exceptions import FieldError
from django.db import migrations, models

from snitch.helpers import get_notification_model


def migrate_users_to_receiver(apps, schema_editor):
    """Gets the user field and uses it to complete the receiver."""
    Notification = get_notification_model()
    User = get_user_model()
    ContentType = apps.get_model("contenttypes", "contenttype")
    try:
        Notification.objects.filter(user__isnull=False).update(
            receiver_id=models.F("user__pk"),
            receiver_content_type=ContentType.objects.get_for_model(User),
        )
    except FieldError:
        ...


class Migration(migrations.Migration):
    dependencies = [
        ("snitch", "0005_notification_receiver_content_type_and_more"),
    ]

    operations = [
        migrations.RunPython(migrate_users_to_receiver),
    ]
