import { aws_eks, aws_route53 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface PrivateCAProps {
    readonly cluster: aws_eks.Cluster;
    readonly nodegroup: aws_eks.Nodegroup;
    readonly namespace: String;
    readonly cacertname: String;
    readonly dnsNames: String[];
    readonly hostedZoneName: string;
    readonly clusterIssuerName: String;
}
export declare class PrivateCA extends Construct {
    private_ca_arn: string;
    route53_zone: aws_route53.PrivateHostedZone;
    constructor(scope: Construct, id: string, props: PrivateCAProps);
}
