"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * (experimental) A VPC endpoint service.
 *
 * @experimental
 * @resource AWS::EC2::VPCEndpointService
 */
class VpcEndpointService extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = (_b = props.acceptanceRequired) !== null && _b !== void 0 ? _b : true;
        this.whitelistedPrincipals = (_c = props.whitelistedPrincipals) !== null && _c !== void 0 ? _c : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            ((_d = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _d !== void 0 ? _d : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
_a = JSII_RTTI_SYMBOL_1;
VpcEndpointService[_a] = { fqn: "@aws-cdk/aws-ec2.VpcEndpointService", version: "1.95.1" };
//# sourceMappingURL=data:application/json;base64,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