# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (18,4,4,6,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        160 63
        113 166
        20 130
        77 160
        26 122
        47 5
        130 73
        55 10
        75 162
        109 128
        83 5
        147 49
        103 80
        45 55
        43 35
        51 27
        28 73
        13 3
        122 176
        59 49
        8 5
        75 35
        68 17
        168 120
        143 140
        92 69
        30 168
        2 47
        28 69
        104 153
        80 102
        1 104
        18 60
        51 95
        136 150
        53 116
        164 4
        114 40
        40 119
        76 102
        42 65
        38 144
        98 76
        19 156
        138 67
        113 98
        105 145
        127 86
        110 147
        33 180
        6 138
        178 148
        82 14
        59 172
        177 110
        66 85
        121 50
        148 166
        29 100
        58 102
        79 27
        10 119
        43 166
        9 150
        134 70
        133 72
        9 57
        38 60
        61 23
        50 115
        11 157
        30 92
        74 179
        31 46
        123 17
        50 85
        61 15
        78 77
        127 128
        105 106
        74 71
        108 41
        26 13
        32 115
        108 65
        164 152
        57 69
        62 91
        80 176
        177 63
        164 35
        1 129
        2 120
        114 2
        133 68
        151 135
        56 36
        43 151
        118 167
        18 51
        146 153
        72 91
        134 141
        72 82
        39 29
        48 97
        6 85
        74 80
        39 15
        19 66
        121 164
        112 133
        111 172
        69 47
        137 57
        7 119
        44 117
        112 59
        96 14
        21 117
        41 138
        82 63
        102 3
        114 62
        163 139
        130 174
        53 156
        64 107
        24 137
        142 65
        11 160
        66 178
        42 127
        39 79
        130 168
        22 64
        23 64
        90 154
        108 88
        114 83
        75 179
        30 140
        28 150
        163 95
        66 116
        103 161
        63 172
        179 166
        0 11
        90 150
        7 93
        159 139
        87 17
        19 88
        11 84
        0 45
        120 101
        123 77
        29 170
        131 163
        171 115
        180 119
        133 155
        71 76
        126 17
        154 73
        12 143
        12 144
        7 90
        79 16
        70 138
        113 4
        6 159
        165 72
        44 94
        156 142
        96 34
        13 125
        132 116
        111 175
        81 89
        71 36
        62 101
        24 97
        100 131
        0 87
        23 79
        109 181
        169 67
        94 145
        176 34
        135 89
        21 131
        121 71
        20 140
        46 155
        42 105
        7 92
        141 135
        21 51
        24 10
        153 35
        21 15
        145 16
        128 136
        52 149
        111 161
        173 179
        162 129
        65 15
        125 49
        82 52
        46 78
        171 178
        141 32
        29 70
        117 142
        135 148
        14 68
        132 148
        134 139
        111 147
        142 86
        95 16
        87 125
        175 26
        25 176
        136 22
        104 147
        146 110
        175 25
        99 112
        12 42
        58 26
        137 5
        152 81
        3 129
        171 89
        31 48
        30 54
        106 37
        157 96
        33 55
        57 168
        8 149
        61 18
        98 152
        33 155
        180 47
        137 101
        99 91
        146 34
        159 53
        159 56
        136 60
        99 83
        156 163
        181 124
        31 120
        110 14
        12 109
        54 48
        81 116
        158 174
        78 84
        143 106
        34 3
        134 169
        107 124
        170 139
        32 173
        22 174
        141 56
        70 115
        38 28
        36 85
        93 54
        103 177
        62 97
        20 144
        1 161
        55 84
        113 58
        128 37
        124 37
        167 32
        98 132
        83 10
        54 158
        84 149
        153 122
        122 4
        158 154
        170 88
        46 165
        160 126
        131 169
        36 173
        40 48
        109 90
        118 129
        74 4
        144 61
        100 171
        161 58
        124 140
        123 155
        81 50
        112 8
        103 162
        19 100
        20 64
        121 167
        59 52
        60 107
        45 123
        9 93
        154 40
        93 24
        99 45
        77 91
        126 96
        0 172
        44 27
        1 43
        39 41
        108 145
        9 174
        118 151
        127 18
        22 106
        23 105
        94 86
        6 88
        86 95
        53 67
        31 180
        38 181
        49 68
        78 97
        177 25
        162 146
        178 173
        52 157
        170 16
        13 104
        175 87
        25 126
        75 167
        117 67
        157 125
        169 89
        165 101
        107 27
        37 94
        143 158
        152 151
        165 149
        73 2
        8 33
        92 181
        56 132
        44 41
        118 76
        """

        self.waters = """
        0.32219 0.818 0.58379
        0.67781 0.818 0.41621
        0.68865 0.5 0.78536
        0.0 0.0 0.44491
        0.18635 0.5 0.37596
        0.68865 0.81365 0.72597
        0.182 0.18635 0.17969
        0.182 0.81365 0.82031
        0.81365 0.818 0.67969
        0.5 0.0 0.84256
        0.31135 0.81365 0.72597
        0.19719 0.0 0.59357
        0.125 0.5 0.94376
        0.0 0.818 0.47245
        0.80281 0.307 0.54532
        0.875 0.5 0.05625
        0.5 0.125 0.07287
        0.125 0.5 0.57287
        0.625 0.67781 0.0
        0.375 0.5 0.1586
        0.818 0.32219 0.91621
        0.818 0.67781 0.08379
        0.5 0.125 0.92713
        0.625 0.32219 0.0
        0.375 0.0 0.74862
        0.32219 0.375 0.5
        0.19719 0.693 0.45468
        0.818 0.0 0.02755
        0.693 0.68865 0.86503
        0.693 0.31135 0.13497
        0.0 0.125 0.84394
        0.0 0.375 0.75138
        0.68865 0.18635 0.27403
        0.0 0.693 0.6924
        0.0 0.182 0.47245
        0.81365 0.5 0.37596
        0.31135 0.18635 0.27403
        0.182 0.0 0.97245
        0.818 0.67781 0.91621
        0.818 0.32219 0.08379
        0.31135 0.5 0.78536
        0.0 0.19719 0.09357
        0.25 0.5 0.0
        0.68865 0.693 0.36503
        0.0 0.0 0.0551
        0.31135 0.693 0.63497
        0.0 0.307 0.6924
        0.81365 0.68865 0.77403
        0.18635 0.31135 0.77403
        0.80281 0.693 0.54532
        0.0 0.375 0.24862
        0.693 0.80281 0.04532
        0.80281 0.0 0.59357
        0.182 0.81365 0.17969
        0.182 0.18635 0.82031
        0.18635 0.818 0.67969
        0.375 0.0 0.25138
        0.693 0.0 0.8076
        0.32219 0.818 0.41621
        0.67781 0.818 0.58379
        0.693 0.80281 0.95468
        0.75 0.5 0.0
        0.5 0.31135 0.71465
        0.5 0.125 0.55625
        0.693 0.19719 0.95468
        0.125 0.5 0.05625
        0.31135 0.5 0.21465
        0.0 0.875 0.15607
        0.875 0.5 0.57287
        0.818 0.81365 0.82031
        0.818 0.18635 0.17969
        0.18635 0.182 0.32031
        0.68865 0.307 0.63497
        0.625 0.5 0.84141
        0.31135 0.307 0.36503
        0.68865 0.307 0.36503
        0.125 0.0 0.34394
        0.31135 0.307 0.63497
        0.18635 0.182 0.67969
        0.693 0.19719 0.04532
        0.32219 0.182 0.41621
        0.0 0.625 0.24862
        0.67781 0.182 0.58379
        0.5 0.68865 0.71465
        0.125 0.0 0.65607
        0.18635 0.31135 0.22597
        0.307 0.80281 0.04532
        0.19719 0.693 0.54532
        0.307 0.31135 0.13497
        0.81365 0.68865 0.22597
        0.307 0.68865 0.86503
        0.5 0.375 0.6586
        0.0 0.875 0.84394
        0.307 0.0 0.8076
        0.182 0.0 0.02755
        0.5 0.875 0.07287
        0.0 0.182 0.52755
        0.31135 0.18635 0.72597
        0.18635 0.818 0.32031
        0.5 0.625 0.6586
        0.625 0.5 0.1586
        0.68865 0.18635 0.72597
        0.19719 0.0 0.40644
        0.5 0.125 0.44376
        0.80281 0.693 0.45468
        0.375 0.32219 0.0
        0.307 0.19719 0.95468
        0.818 0.0 0.97245
        0.182 0.32219 0.08379
        0.182 0.67781 0.91621
        0.67781 0.375 0.5
        0.5 0.75 0.5
        0.68865 0.693 0.63497
        0.31135 0.693 0.36503
        0.5 0.5 0.75
        0.81365 0.31135 0.22597
        0.18635 0.68865 0.22597
        0.0 0.80281 0.09357
        0.875 0.0 0.34394
        0.18635 0.68865 0.77403
        0.81365 0.31135 0.77403
        0.0 0.307 0.3076
        0.125 0.5 0.42713
        0.18635 0.5 0.62405
        0.0 0.0 0.94491
        0.0 0.818 0.52755
        0.19719 0.307 0.54532
        0.375 0.67781 0.0
        0.307 0.80281 0.95468
        0.80281 0.0 0.40644
        0.693 0.31135 0.86503
        0.693 0.68865 0.13497
        0.31135 0.81365 0.27403
        0.81365 0.5 0.62405
        0.693 0.0 0.1924
        0.68865 0.81365 0.27403
        0.5 0.875 0.92713
        0.625 0.0 0.74862
        0.0 0.125 0.15607
        0.5 0.0 0.15745
        0.0 0.19719 0.90644
        0.625 0.0 0.25138
        0.182 0.67781 0.08379
        0.182 0.32219 0.91621
        0.875 0.5 0.94376
        0.307 0.19719 0.04532
        0.80281 0.307 0.45468
        0.67781 0.625 0.5
        0.5 0.68865 0.28536
        0.875 0.0 0.65607
        0.5 0.81365 0.87596
        0.81365 0.818 0.32031
        0.0 0.693 0.3076
        0.875 0.5 0.42713
        0.375 0.5 0.84141
        0.0 0.5 0.65745
        0.307 0.68865 0.13497
        0.0 0.0 0.5551
        0.307 0.31135 0.86503
        0.307 0.0 0.1924
        0.32219 0.182 0.58379
        0.5 0.875 0.44376
        0.67781 0.182 0.41621
        0.5 0.81365 0.12405
        0.0 0.5 0.34256
        0.81365 0.182 0.67969
        0.5 0.625 0.34141
        0.81365 0.182 0.32031
        0.818 0.18635 0.82031
        0.818 0.81365 0.17969
        0.5 0.18635 0.12405
        0.68865 0.5 0.21465
        0.5 0.875 0.55625
        0.5 0.31135 0.28536
        0.5 0.18635 0.87596
        0.32219 0.625 0.5
        0.19719 0.307 0.45468
        0.5 0.25 0.5
        0.5 0.5 0.25
        0.5 0.375 0.34141
        0.0 0.625 0.75138
        0.0 0.80281 0.90644
        """

        self.coord = "relative"

        self.cages = """
        12 0.22799 0.0 0.11019
        14 0.28877 0.0 0.5
        12 -0.24539 -0.5 0.2953
        16 0.0 0.5 -0.15388
        12 0.0 -0.22799 0.61019
        16 0.0 0.0 0.25
        12 0.0 0.22799 0.61019
        12 0.0 -0.22799 -0.61019
        12 0.5 0.0 0.0
        12 0.22799 0.0 -0.11019
        14 0.0 -0.28877 0.0
        12 -0.22799 0.0 0.11019
        12 -0.5 0.24539 -0.2047
        16 0.0 0.0 0.75
        12 -0.5 -0.24539 -0.2047
        15 0.5 0.5 -0.5711
        14 0.0 0.28877 0.0
        16 -0.5 0.0 0.65388
        12 -0.24539 0.5 0.7047
        12 -0.5 -0.24539 0.2047
        15 0.5 0.5 0.0711
        12 -0.22799 0.0 -0.11019
        15 -0.5 0.5 -0.0711
        12 0.5 0.24539 0.2047
        16 0.0 0.5 0.15388
        12 0.24539 0.5 -0.7047
        14 -0.28877 0.0 0.5
        12 0.0 0.5 0.5
        12 0.24539 -0.5 0.7047
        16 0.5 0.0 -0.65388
        15 -0.5 0.5 0.5711
        12 0.0 0.22799 -0.61019
        """

        self.bondlen = 3

        self.cell = """
        13.461566776635882 13.461566776635882 51.46652347023254
        """

        self.density = 0.5832934360403821

        self.cell = cellvectors(a=13.461566776635882,
                                b=13.461566776635882,
                                c=51.46652347023254)
