# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (24,20,8,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        208 238
        205 216
        25 106
        47 235
        313 69
        266 23
        19 166
        133 117
        317 11
        35 256
        2 236
        9 299
        267 187
        58 40
        120 57
        293 203
        253 130
        81 292
        244 171
        143 56
        210 158
        26 212
        50 307
        75 131
        113 92
        237 165
        244 257
        18 180
        17 15
        153 233
        109 317
        39 318
        221 24
        101 23
        28 153
        255 259
        9 11
        169 49
        69 223
        59 125
        88 92
        171 65
        207 20
        226 285
        26 42
        159 269
        63 263
        256 306
        155 57
        244 272
        77 157
        86 76
        139 219
        183 290
        111 272
        10 222
        79 59
        175 188
        308 245
        183 220
        252 57
        136 129
        107 236
        164 169
        193 69
        296 137
        191 257
        22 233
        21 218
        224 121
        254 319
        270 213
        275 212
        47 282
        54 121
        267 2
        309 164
        301 45
        255 40
        272 252
        280 15
        17 204
        234 98
        243 305
        107 82
        194 53
        110 214
        2 300
        53 56
        308 15
        199 173
        281 294
        147 159
        181 303
        102 30
        91 205
        195 74
        265 237
        26 308
        221 161
        270 291
        102 304
        279 209
        285 316
        285 317
        240 238
        146 196
        219 165
        130 108
        87 158
        141 180
        318 161
        208 301
        116 13
        178 159
        257 84
        163 223
        289 3
        173 85
        250 209
        171 264
        191 154
        51 93
        199 79
        120 220
        109 300
        76 186
        156 229
        274 238
        68 151
        312 298
        144 155
        2 167
        202 74
        90 263
        138 97
        17 292
        132 307
        194 245
        138 227
        10 38
        296 126
        141 97
        204 311
        224 295
        36 276
        178 202
        258 61
        77 133
        43 94
        90 251
        198 5
        299 158
        54 84
        315 143
        21 74
        187 316
        144 42
        311 145
        51 161
        127 313
        37 103
        114 170
        274 45
        181 66
        100 301
        119 71
        23 56
        286 303
        55 241
        285 89
        306 294
        247 139
        0 96
        64 268
        296 36
        190 3
        33 85
        177 217
        193 238
        149 5
        179 106
        82 300
        90 41
        199 311
        250 11
        83 192
        108 30
        46 117
        58 52
        7 198
        194 226
        279 288
        99 115
        0 216
        125 297
        177 302
        7 216
        127 101
        18 14
        164 83
        30 233
        116 157
        80 71
        111 67
        182 144
        267 118
        4 189
        179 318
        202 58
        12 214
        247 63
        120 126
        278 283
        113 197
        175 127
        185 78
        99 170
        131 311
        260 287
        88 159
        3 220
        43 277
        25 294
        149 101
        229 186
        116 259
        295 52
        145 61
        181 36
        34 185
        237 293
        222 27
        274 313
        67 135
        147 235
        296 166
        92 105
        63 234
        49 115
        21 184
        253 213
        243 298
        31 129
        60 232
        266 55
        43 38
        33 183
        275 225
        302 142
        250 67
        168 278
        65 222
        279 176
        147 278
        73 61
        145 16
        100 122
        263 66
        73 229
        255 46
        172 101
        240 145
        39 246
        18 280
        125 312
        48 106
        104 34
        97 40
        77 112
        249 292
        128 293
        138 16
        287 282
        193 107
        313 20
        199 297
        68 165
        306 226
        286 60
        97 14
        132 63
        156 246
        241 36
        305 137
        138 259
        302 81
        73 51
        48 105
        247 224
        44 139
        174 309
        314 66
        120 276
        242 297
        95 260
        19 303
        226 196
        174 170
        247 237
        18 152
        78 31
        137 49
        179 281
        188 128
        283 248
        6 83
        98 31
        271 308
        254 233
        131 258
        160 209
        91 64
        45 98
        179 142
        177 27
        167 24
        309 115
        266 135
        317 62
        50 70
        305 241
        118 119
        172 37
        265 151
        249 142
        19 65
        164 162
        294 299
        203 268
        28 113
        104 121
        130 133
        288 235
        91 93
        251 192
        12 87
        122 215
        280 60
        100 74
        141 277
        33 314
        169 24
        173 17
        262 271
        177 71
        315 84
        268 251
        195 129
        168 99
        34 276
        32 54
        261 49
        206 210
        89 184
        98 8
        136 284
        124 41
        59 8
        305 80
        246 13
        88 146
        223 162
        163 140
        289 42
        32 151
        34 252
        12 288
        104 148
        142 119
        155 283
        150 166
        244 211
        82 62
        13 319
        277 251
        154 94
        174 112
        203 263
        256 67
        162 165
        193 61
        261 250
        264 273
        95 221
        93 258
        122 123
        286 314
        184 62
        171 197
        148 135
        248 89
        28 108
        254 304
        25 196
        73 39
        21 86
        315 228
        28 117
        110 40
        114 278
        276 290
        76 1
        178 255
        231 316
        239 158
        48 153
        107 123
        198 96
        43 64
        231 289
        262 280
        215 248
        68 176
        264 47
        75 297
        146 89
        32 103
        190 304
        150 217
        56 37
        249 48
        172 20
        113 269
        204 4
        265 149
        104 55
        33 79
        196 105
        260 133
        210 161
        25 1
        102 220
        149 55
        68 163
        292 245
        207 195
        206 273
        190 316
        92 271
        309 219
        156 259
        269 47
        124 208
        269 46
        260 192
        256 230
        253 102
        65 217
        310 103
        279 219
        125 127
        191 152
        221 83
        239 186
        96 203
        319 291
        231 53
        0 64
        87 72
        175 75
        31 42
        284 295
        218 1
        188 69
        5 293
        45 195
        205 131
        123 291
        81 230
        4 16
        225 310
        191 38
        287 46
        157 291
        242 80
        44 70
        267 254
        86 140
        154 54
        141 134
        124 157
        275 37
        182 252
        152 284
        211 152
        91 201
        232 108
        190 248
        235 160
        275 207
        85 30
        224 185
        231 312
        222 257
        225 186
        93 6
        290 66
        22 249
        14 189
        194 230
        187 109
        210 281
        87 176
        22 118
        189 15
        148 84
        200 150
        128 162
        134 314
        23 312
        284 78
        95 206
        10 303
        265 121
        253 126
        225 4
        160 168
        114 215
        240 79
        242 298
        12 282
        289 8
        86 207
        192 112
        228 27
        7 80
        143 230
        175 5
        136 14
        197 232
        9 140
        44 52
        217 273
        13 153
        216 27
        144 271
        185 234
        124 227
        72 94
        246 106
        35 273
        110 287
        7 75
        58 136
        130 166
        214 52
        188 258
        229 16
        201 72
        95 150
        111 160
        208 123
        228 29
        9 176
        117 116
        0 10
        200 24
        32 72
        118 242
        261 109
        200 137
        60 85
        173 22
        57 168
        228 81
        155 3
        156 1
        19 232
        209 115
        174 307
        39 236
        262 211
        270 215
        205 29
        204 29
        88 283
        132 41
        243 261
        105 245
        126 99
        214 94
        128 6
        286 180
        167 119
        310 29
        90 134
        239 51
        182 78
        182 211
        262 197
        148 272
        306 11
        35 281
        139 307
        169 300
        299 76
        100 50
        178 218
        35 302
        181 96
        172 151
        295 154
        274 59
        301 132
        70 202
        44 288
        135 143
        26 53
        70 147
        201 310
        270 304
        239 201
        200 71
        318 167
        129 212
        183 8
        163 20
        77 213
        111 264
        315 103
        140 62
        218 146
        236 319
        122 184
        110 277
        38 180
        198 241
        6 268
        170 213
        206 282
        290 234
        266 243
        114 50
        240 227
        227 134
        223 82
        212 189
        187 298
        41 112
        """

        self.waters = """
        0.19111 0.76277 0.51696
        0.92876 0.18621 0.11918
        0.36016 0.05963 0.985
        0.57271 0.34946 0.75516
        0.01949 0.18483 0.43229
        0.44956 0.85593 0.47788
        0.28117 0.81888 0.26226
        0.29314 0.90227 0.60239
        0.51949 0.31517 0.56771
        0.75898 0.95198 0.10694
        0.13278 0.69054 0.57162
        0.72155 0.96082 0.98194
        0.89776 0.71872 0.16108
        0.18389 0.27199 0.02241
        0.97223 0.37703 0.43415
        0.00016 0.27909 0.59858
        0.10224 0.21872 0.33893
        0.07777 0.1938 0.62139
        0.0064 0.45246 0.52272
        0.17836 0.61328 0.74518
        0.64943 0.06821 0.34879
        0.74521 0.22985 0.16564
        0.21883 0.18113 0.76226
        0.62911 0.01081 0.61759
        0.30332 0.86856 0.98763
        0.93963 0.13663 0.00898
        0.79279 0.2302 0.61123
        0.08969 0.85863 0.64885
        0.10786 0.4081 0.90902
        0.04824 0.00118 0.52193
        0.2714 0.36455 0.7788
        0.69668 0.36856 0.51237
        0.82735 0.85754 0.40815
        0.32514 0.36592 0.58308
        0.61953 0.6257 0.62787
        0.96657 0.89605 0.8837
        0.41908 0.67256 0.67849
        0.77845 0.03918 0.48194
        0.06037 0.63663 0.49102
        0.20686 0.09773 0.10239
        0.98717 0.46146 0.25424
        0.36703 0.49703 0.25817
        0.71498 0.31729 0.62614
        0.07124 0.68621 0.38083
        0.74093 0.59472 0.21047
        0.57777 0.3062 0.37862
        0.03838 0.48837 0.0693
        0.91516 0.62591 0.97646
        0.0604 0.21267 0.88685
        0.48051 0.81517 0.93229
        0.62099 0.47015 0.15684
        0.13879 0.95749 0.21199
        0.82261 0.57483 0.28891
        0.74636 0.14094 0.66782
        0.81611 0.77199 0.47759
        0.57124 0.8138 0.61918
        0.74103 0.04802 0.60694
        0.63879 0.54251 0.78801
        0.86121 0.45749 0.28801
        0.45915 0.23362 0.51689
        0.14943 0.43179 0.65122
        0.25907 0.09472 0.28954
        0.60786 0.0919 0.09099
        0.50419 0.55593 0.38279
        0.14975 0.76475 0.39286
        0.07866 0.68888 0.75474
        0.36685 0.55134 0.5219
        0.75975 0.84673 0.83398
        0.67836 0.88672 0.25482
        0.45252 0.05016 0.29715
        0.73208 0.50003 0.15403
        0.24093 0.90528 0.78954
        0.91908 0.82744 0.32151
        0.1774 0.07483 0.21109
        0.71883 0.31888 0.23774
        0.31948 0.99325 0.53485
        0.88645 0.10191 0.18979
        0.31328 0.49566 0.0741
        0.72859 0.48319 0.52903
        0.33415 0.26782 0.51467
        0.32261 0.92517 0.71109
        0.99107 0.00694 0.70806
        0.49581 0.05593 0.11721
        0.29813 0.7743 0.15392
        0.85874 0.79235 0.5896
        0.24026 0.34673 0.66602
        0.7714 0.13546 0.2212
        0.87954 0.82717 0.20035
        0.82185 0.36858 0.93015
        0.68389 0.22801 0.97759
        0.30946 0.54236 0.33296
        0.11953 0.8743 0.37213
        0.91031 0.35863 0.85116
        0.20023 0.91103 0.28941
        0.95433 0.71829 0.34337
        0.16586 0.73219 0.01467
        0.31611 0.72801 0.52241
        0.0508 0.40393 0.34406
        0.58485 0.3741 0.47646
        0.52777 0.62297 0.93415
        0.6047 0.35881 0.20131
        0.59697 0.98865 0.50737
        0.38645 0.39809 0.81022
        0.86685 0.94866 0.4781
        0.64975 0.73525 0.60714
        0.9415 0.24298 0.85383
        0.05045 0.14408 0.97788
        0.41031 0.14137 0.14885
        0.19054 0.45765 0.83296
        0.53838 0.01163 0.9307
        0.03221 0.58646 0.23261
        0.79813 0.7257 0.84609
        0.35058 0.56821 0.15122
        0.99581 0.44408 0.88279
        0.5867 0.46712 0.0416
        0.54086 0.73362 0.98311
        0.17266 0.35754 0.09185
        0.13315 0.44866 0.0219
        0.29978 0.08897 0.78941
        0.23208 0.99997 0.84598
        0.51284 0.53854 0.75424
        0.69111 0.73724 0.48304
        0.5604 0.28733 0.11315
        0.4415 0.25702 0.14617
        0.32164 0.38672 0.24518
        0.47223 0.12297 0.56586
        0.4492 0.59607 0.84406
        0.5064 0.04755 0.47729
        0.3953 0.85881 0.29869
        0.7736 0.32301 0.42662
        0.25898 0.54802 0.89306
        0.22859 0.01681 0.47098
        0.49107 0.49306 0.29195
        0.22155 0.53918 0.01806
        0.24103 0.45198 0.39306
        0.72861 0.86455 0.7212
        0.85199 0.41404 0.3957
        0.39776 0.78128 0.83893
        0.12047 0.32717 0.29966
        0.623 0.62756 0.24018
        0.69054 0.04236 0.16705
        0.12911 0.48919 0.38242
        0.12099 0.02985 0.84316
        0.80946 0.95765 0.66705
        0.75907 0.40528 0.71047
        0.21498 0.18271 0.37386
        0.80889 0.26277 0.98304
        0.77142 0.51681 0.02903
        0.75479 0.77015 0.66564
        0.56037 0.86337 0.50898
        0.20721 0.7302 0.88877
        0.71253 0.88492 0.374
        0.9133 0.53288 0.5416
        0.14126 0.29235 0.9104
        0.87678 0.686 0.43445
        0.6774 0.42517 0.78891
        0.04568 0.21829 0.15663
        0.28748 0.38492 0.12601
        0.9492 0.90393 0.15594
        0.86016 0.44038 0.015
        0.7264 0.67699 0.92662
        0.14801 0.91404 0.1043
        0.47195 0.86806 0.21062
        0.63298 0.99703 0.24183
        0.42223 0.8062 0.12139
        0.57866 0.81112 0.24527
        0.25364 0.64094 0.83219
        0.27142 0.98319 0.97098
        0.64801 0.58596 0.8957
        0.41516 0.8741 0.02354
        0.4936 0.54755 0.02272
        0.97195 0.63194 0.78939
        0.68672 0.99566 0.4259
        0.20188 0.2257 0.65392
        0.46657 0.60395 0.1163
        0.4133 0.96712 0.4584
        0.75364 0.85907 0.16782
        0.123 0.87244 0.75982
        0.88047 0.3743 0.12787
        0.0867 0.03288 0.9584
        0.09697 0.51135 0.49263
        0.32735 0.64246 0.59185
        0.76792 0.49997 0.65403
        0.43763 0.39919 0.61826
        0.64126 0.20765 0.0896
        0.63984 0.55963 0.515
        0.9678 0.08646 0.26739
        0.49424 0.09509 0.83823
        0.37901 0.97015 0.34316
        0.95915 0.26639 0.48311
        0.54568 0.28171 0.84337
        0.94956 0.64408 0.52212
        0.25975 0.65328 0.16602
        0.377 0.12756 0.25982
        0.82164 0.11328 0.75482
        0.70188 0.2743 0.34609
        0.86722 0.19054 0.92839
        0.00893 0.50694 0.79195
        0.37678 0.814 0.56555
        0.2736 0.17699 0.57339
        0.28503 0.81729 0.87386
        0.00577 0.90491 0.33823
        0.79978 0.41103 0.21059
        0.35874 0.70765 0.4104
        0.08485 0.12591 0.52354
        0.13984 0.94038 0.485
        0.04086 0.76639 0.01689
        0.74026 0.15328 0.33398
        0.42134 0.31112 0.25474
        0.66586 0.76782 0.98533
        0.02777 0.87703 0.06586
        0.87901 0.52985 0.65684
        0.83415 0.23219 0.48533
        0.40303 0.48865 0.99263
        0.92729 0.65055 0.25516
        0.55045 0.35593 0.02212
        0.17815 0.86858 0.56986
        0.10179 0.76483 0.8261
        0.85025 0.26475 0.10714
        0.60179 0.73518 0.1739
        0.4678 0.41354 0.73261
        0.2264 0.82301 0.07339
        0.05851 0.74298 0.64617
        0.50893 0.99306 0.20806
        0.67815 0.63142 0.43015
        0.93763 0.10081 0.38174
        0.78748 0.11508 0.874
        0.24636 0.35907 0.33219
        0.00419 0.94408 0.61721
        0.07271 0.15055 0.24484
        0.86703 0.00297 0.74183
        0.62047 0.17284 0.70035
        0.13298 0.50297 0.75817
        0.24521 0.27015 0.83437
        0.54824 0.49882 0.47807
        0.80332 0.63144 0.01237
        0.32185 0.13142 0.06986
        0.55851 0.75702 0.35383
        0.39821 0.23518 0.3261
        0.01284 0.96146 0.24576
        0.29279 0.2698 0.38877
        0.45433 0.78171 0.65663
        0.36121 0.04251 0.71199
        0.53221 0.91354 0.76739
        0.8953 0.64119 0.70131
        0.92134 0.18888 0.74527
        0.12322 0.186 0.06555
        0.58969 0.64137 0.35116
        0.62322 0.314 0.93445
        0.1047 0.14119 0.79869
        0.67486 0.86592 0.91692
        0.22861 0.63546 0.2788
        0.70023 0.58897 0.71059
        0.37089 0.51081 0.88242
        0.35025 0.23525 0.89286
        0.99424 0.40491 0.16177
        0.85058 0.93179 0.84879
        0.93961 0.71267 0.61315
        0.26792 3e-05 0.34598
        0.08092 0.32744 0.17849
        0.17486 0.63408 0.08308
        0.56237 0.89919 0.88174
        0.95252 0.44985 0.70285
        0.39215 0.5919 0.40902
        0.92223 0.6938 0.87862
        0.63278 0.80947 0.42839
        0.61356 0.89809 0.68979
        0.38047 0.1257 0.87213
        0.25479 0.72985 0.33437
        0.95176 0.50118 0.97807
        0.43963 0.36337 0.99102
        0.877 0.37244 0.74018
        0.78117 0.68113 0.73774
        0.99985 0.77909 0.90143
        0.50016 0.22091 0.40143
        0.82514 0.13408 0.41692
        0.50577 0.59509 0.66177
        0.11356 0.60191 0.31022
        0.68052 0.49325 0.96516
        0.70721 0.7698 0.11123
        0.03343 0.39605 0.6163
        0.9936 0.95246 0.97729
        0.98051 0.68483 0.06771
        0.70686 0.40227 0.89762
        0.81948 0.50675 0.46516
        0.67266 0.14246 0.90815
        0.18672 0.50434 0.5741
        0.06237 0.60081 0.11826
        0.78503 0.68271 0.12614
        0.60224 0.28128 0.66108
        0.46162 0.51163 0.5693
        0.36722 0.30947 0.07162
        0.02805 0.13194 0.71062
        0.43961 0.78733 0.38685
        0.90303 0.01135 0.00737
        0.79314 0.59773 0.39762
        0.37954 0.67284 0.79966
        0.35199 0.08596 0.6043
        0.48717 0.03854 0.74576
        0.87089 0.98919 0.11759
        0.45176 0.99882 0.02193
        0.52805 0.36806 0.28939
        0.04748 0.94985 0.79715
        0.21253 0.61508 0.62601
        0.42876 0.3138 0.88083
        0.42729 0.84946 0.74484
        0.81328 0.00434 0.9259
        0.54748 0.55016 0.20285
        0.89821 0.26483 0.6739
        0.49985 0.72091 0.09858
        0.96162 0.98837 0.4307
        0.19668 0.13144 0.48763
        0.5508 0.09607 0.65594
        0.53343 0.10395 0.3837
        0.27845 0.46082 0.51806
        0.89215 0.9081 0.59099
        0.58092 0.17256 0.82151
        0.63315 0.05134 0.9781
        0.18052 0.00675 0.03485
        0.30889 0.23724 0.01696
        """

        self.coord = "relative"

        self.cages = """
        14 0.57396 0.1799 0.24488
        14 -0.49412 -0.31951 -0.4891
        12 0.27685 0.38968 -0.05333
        14 0.17515 0.48232 0.20666
        15 0.17133 0.03357 0.65824
        14 -0.32485 0.01768 -0.20666
        15 -0.15229 0.8184 0.00445
        16 0.09008 0.76928 0.20675
        12 0.77685 0.11032 0.05333
        15 -0.34771 0.1816 -0.49555
        15 -0.17133 0.53357 -0.15824
        12 -0.13914 0.37474 -0.433
        15 -0.32867 0.46643 -0.65824
        12 -0.27685 -0.11032 0.55333
        14 0.49412 -0.81951 0.9891
        14 -0.57396 0.6799 0.25512
        14 0.2555 -0.23866 0.70316
        12 0.7201 0.35989 0.07108
        12 -0.77685 0.61032 0.44667
        12 0.13914 -0.12526 0.933
        14 0.41351 0.39688 0.42337
        14 0.00588 0.81951 0.4891
        14 -0.2555 0.26134 -0.20316
        14 0.08649 -0.39688 0.92337
        14 -0.07396 -0.1799 0.74488
        12 -0.2201 -0.35989 0.57108
        12 0.39775 -0.04853 0.86374
        12 -0.10225 0.54853 0.13626
        15 0.32867 -0.03357 1.15824
        14 -0.2445 0.73866 0.29684
        12 0.46584 -0.04571 0.61922
        12 0.0466 -0.42903 0.64753
        15 0.15229 0.3184 0.49555
        12 -0.39775 0.45147 -0.36374
        12 0.36086 0.12526 0.433
        16 0.40992 -0.76928 0.70675
        14 -0.00588 1.31951 0.0109
        12 -0.36086 0.62526 0.067
        14 -0.17515 0.98232 0.29334
        12 -0.03416 0.54571 0.38078
        12 0.4534 0.42903 0.14753
        12 0.2201 0.14011 -0.07108
        14 0.07396 0.3201 -0.24488
        12 -0.46584 0.45429 -0.11922
        14 0.2445 0.23866 0.20316
        12 -0.4534 0.92903 0.35247
        16 -0.40992 -0.26928 -0.20675
        12 -0.7201 0.85989 0.42892
        16 -0.09008 1.26928 0.29325
        14 -0.41351 0.89688 0.07663
        12 0.10225 0.04853 0.36374
        15 0.34771 -0.3184 0.99555
        12 0.03416 0.04571 0.11922
        14 -0.08649 0.10312 -0.42337
        14 0.32485 -0.48232 0.70666
        12 -0.0466 0.07097 -0.14753
        """

        self.bondlen = 3

        self.cell = """
        25.610527765228145 26.685332528187622 26.68240066618309
        """

        self.density = 0.5245243856482863

        self.cell = cellvectors(a=25.610527765228145,
                                b=26.685332528187622,
                                c=26.68240066618309)
