# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (40,12,24,4,)
"""
from genice2.cell import cellvectors
import genice2.lattices
desc = {"ref": {"SpaceFullerene": 'Sikiric 2010'},
        "usage": "No options available.",
        "brief": "A space fullerene."
        }


class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs = """
        110 177
        236 40
        69 404
        133 241
        204 73
        155 103
        187 205
        341 325
        74 361
        306 166
        19 269
        7 197
        12 43
        24 141
        431 308
        110 417
        139 294
        172 159
        204 300
        358 435
        209 108
        53 340
        69 445
        151 102
        214 385
        131 164
        433 414
        243 437
        172 322
        206 287
        86 4
        171 73
        191 134
        23 192
        422 181
        244 52
        260 230
        258 145
        236 415
        81 366
        371 137
        365 240
        203 37
        290 299
        199 164
        36 185
        374 112
        89 53
        90 2
        381 338
        438 176
        231 281
        308 45
        210 410
        403 177
        96 380
        326 153
        153 305
        100 134
        145 312
        251 171
        100 347
        71 443
        77 369
        96 436
        201 418
        395 227
        104 454
        132 311
        234 395
        128 39
        320 133
        360 344
        139 449
        211 317
        412 125
        353 352
        370 328
        188 245
        248 446
        406 1
        138 36
        183 333
        407 219
        70 395
        279 4
        194 144
        322 309
        56 64
        311 424
        449 411
        186 207
        411 423
        92 81
        77 313
        85 348
        10 391
        196 404
        8 407
        50 61
        8 215
        140 148
        35 119
        322 233
        49 193
        129 53
        446 3
        32 305
        20 411
        93 163
        142 448
        425 319
        230 135
        360 450
        324 234
        219 44
        51 57
        156 194
        156 192
        318 297
        386 264
        240 143
        129 177
        454 312
        267 402
        289 445
        79 163
        408 179
        146 428
        347 232
        167 63
        300 281
        388 95
        101 448
        253 272
        358 334
        191 343
        172 384
        70 455
        198 393
        66 269
        386 122
        86 14
        386 184
        390 304
        25 189
        296 18
        242 185
        259 212
        184 73
        58 310
        137 198
        394 193
        71 103
        420 278
        150 339
        390 275
        178 252
        110 288
        189 351
        186 346
        68 230
        265 326
        397 161
        11 122
        243 436
        115 164
        413 389
        378 114
        379 115
        251 406
        88 41
        75 439
        88 72
        196 429
        86 404
        361 296
        46 282
        136 83
        278 5
        421 411
        78 48
        130 2
        200 49
        68 137
        270 312
        409 449
        192 272
        6 31
        332 143
        447 245
        408 356
        47 234
        146 319
        170 263
        256 76
        374 431
        136 154
        257 385
        106 63
        331 402
        195 52
        56 185
        136 262
        346 197
        65 341
        140 387
        423 306
        258 173
        225 432
        80 44
        260 60
        75 267
        132 73
        11 311
        186 118
        85 337
        330 392
        371 400
        390 145
        121 286
        412 180
        335 90
        184 245
        218 425
        161 313
        107 415
        234 403
        223 144
        71 344
        248 126
        29 223
        409 362
        366 23
        367 22
        97 34
        414 229
        146 326
        249 356
        254 413
        321 247
        452 219
        336 179
        332 279
        442 434
        66 296
        116 402
        444 318
        7 300
        223 324
        209 431
        408 157
        27 76
        396 216
        255 264
        446 159
        109 287
        406 166
        65 210
        109 366
        139 175
        89 194
        123 38
        142 418
        398 227
        208 93
        223 366
        50 440
        6 335
        393 230
        191 37
        151 338
        138 176
        354 365
        268 5
        316 367
        68 72
        225 288
        262 298
        29 162
        383 333
        190 315
        265 102
        408 352
        238 321
        128 324
        139 451
        10 399
        24 334
        46 16
        208 308
        307 82
        111 286
        338 48
        256 32
        70 244
        266 286
        394 273
        279 323
        138 64
        236 435
        376 282
        396 363
        75 154
        87 44
        2 15
        235 148
        154 233
        328 220
        325 178
        405 240
        365 273
        353 40
        63 331
        384 257
        247 140
        369 97
        51 15
        314 309
        91 329
        54 454
        213 410
        51 357
        88 305
        422 12
        355 432
        315 28
        454 119
        33 9
        379 187
        59 38
        32 381
        314 382
        66 295
        145 377
        124 350
        433 442
        28 218
        255 407
        105 13
        381 41
        269 423
        222 113
        129 345
        228 31
        117 21
        105 109
        388 48
        413 173
        383 382
        59 221
        292 117
        203 215
        290 135
        228 261
        320 344
        95 153
        181 271
        211 373
        451 64
        67 101
        84 261
        105 92
        220 319
        428 304
        254 124
        67 316
        219 313
        34 264
        64 316
        78 229
        361 0
        35 160
        445 127
        117 160
        265 99
        181 60
        169 375
        65 107
        170 291
        410 250
        8 430
        222 50
        289 285
        301 111
        352 399
        302 36
        391 231
        123 109
        67 362
        34 349
        43 239
        86 33
        444 288
        94 148
        260 419
        283 135
        116 80
        77 143
        422 241
        79 83
        398 340
        307 453
        336 176
        133 260
        106 126
        54 28
        178 218
        398 272
        253 13
        274 300
        251 296
        259 262
        414 312
        158 88
        27 271
        184 365
        55 92
        200 240
        162 81
        285 115
        212 337
        258 213
        385 343
        318 268
        387 280
        388 328
        226 242
        35 102
        79 298
        42 91
        134 431
        165 227
        420 162
        359 216
        30 409
        78 277
        200 401
        59 333
        294 0
        222 426
        394 404
        25 173
        317 379
        179 276
        90 57
        175 20
        155 360
        165 51
        362 202
        62 9
        35 98
        274 171
        188 430
        290 72
        360 261
        146 275
        346 187
        325 434
        93 215
        243 149
        412 280
        217 0
        55 293
        56 294
        255 62
        314 159
        434 425
        429 127
        209 313
        333 39
        334 40
        179 448
        236 189
        422 321
        71 241
        238 283
        282 57
        384 3
        426 250
        122 204
        323 33
        206 372
        121 302
        83 134
        137 228
        376 162
        445 4
        10 30
        373 295
        116 93
        182 298
        384 38
        106 452
        168 59
        256 433
        99 440
        182 382
        330 268
        243 324
        53 125
        435 252
        359 166
        398 177
        320 43
        350 334
        429 14
        160 229
        108 37
        303 245
        378 130
        232 452
        347 63
        387 450
        75 172
        292 270
        50 120
        428 218
        302 276
        263 61
        237 430
        12 103
        372 380
        204 285
        87 343
        427 102
        205 207
        141 61
        17 364
        22 101
        439 374
        96 446
        213 291
        246 392
        78 370
        144 437
        131 19
        370 310
        368 421
        350 170
        23 309
        226 363
        346 281
        41 239
        237 452
        361 166
        54 427
        409 118
        152 103
        129 47
        355 441
        132 447
        85 287
        95 419
        429 284
        369 108
        158 400
        210 292
        85 244
        441 15
        127 332
        329 17
        200 127
        292 119
        327 232
        420 46
        439 87
        259 183
        337 149
        254 111
        205 363
        205 364
        235 393
        389 174
        94 450
        117 275
        25 291
        277 152
        391 418
        371 283
        216 74
        338 160
        259 233
        195 348
        297 278
        400 31
        147 419
        84 299
        444 247
        320 94
        261 72
        111 174
        192 437
        396 379
        353 438
        248 167
        311 42
        25 124
        220 76
        178 113
        355 318
        455 297
        41 344
        228 90
        371 27
        337 13
        303 34
        350 176
        231 17
        417 227
        401 273
        363 175
        70 105
        209 87
        36 201
        400 290
        235 321
        233 372
        277 443
        168 298
        170 301
        99 98
        415 377
        164 17
        254 24
        120 250
        55 455
        345 130
        29 47
        373 69
        123 183
        84 57
        342 80
        158 152
        375 61
        185 20
        211 216
        299 357
        323 397
        7 1
        132 289
        147 305
        54 229
        342 237
        325 440
        265 434
        181 283
        94 268
        7 306
        91 82
        287 144
        26 14
        124 266
        291 174
        326 21
        168 212
        8 80
        354 9
        46 280
        345 335
        322 123
        386 405
        47 165
        5 16
        256 277
        416 30
        42 1
        420 55
        421 56
        393 441
        24 222
        317 284
        26 264
        353 22
        190 213
        327 303
        19 20
        135 114
        453 197
        302 175
        208 112
        341 270
        38 206
        304 252
        345 357
        341 377
        138 266
        203 327
        29 89
        186 10
        45 349
        293 225
        294 226
        417 432
        238 378
        370 427
        196 49
        126 214
        58 271
        356 40
        66 401
        155 392
        249 351
        58 419
        258 104
        108 45
        327 430
        15 417
        381 443
        30 224
        355 148
        433 319
        358 263
        407 349
        43 60
        168 436
        368 0
        274 82
        121 451
        332 97
        423 18
        237 161
        11 26
        215 45
        438 448
        359 49
        396 19
        323 37
        6 299
        142 207
        210 390
        122 1
        221 257
        197 91
        364 242
        149 403
        279 303
        26 447
        348 92
        267 44
        83 385
        416 316
        239 48
        169 440
        131 295
        58 241
        281 115
        130 110
        428 99
        248 116
        224 367
        152 239
        199 373
        359 269
        413 426
        69 401
        183 13
        382 331
        167 182
        424 199
        224 352
        383 112
        106 267
        79 221
        52 297
        27 147
        432 455
        427 425
        266 367
        141 301
        317 424
        406 193
        158 76
        180 278
        357 114
        125 335
        368 307
        249 375
        142 339
        157 351
        195 293
        203 100
        195 180
        118 339
        155 31
        447 4
        368 18
        397 143
        310 443
        231 82
        442 270
        198 238
        354 188
        416 150
        190 120
        5 246
        89 180
        221 112
        424 329
        174 351
        315 113
        421 416
        364 418
        114 441
        77 62
        211 196
        293 280
        68 147
        439 257
        276 207
        217 306
        32 21
        104 315
        3 214
        451 362
        133 235
        141 356
        96 182
        169 304
        198 2
        12 330
        84 16
        121 336
        405 193
        232 349
        328 271
        97 14
        217 449
        42 171
        151 310
        101 157
        128 253
        159 402
        190 263
        150 307
        301 336
        249 107
        383 262
        156 81
        250 119
        376 165
        391 150
        342 343
        253 395
        376 340
        187 329
        191 161
        208 331
        3 372
        375 435
        347 308
        136 374
        251 273
        217 453
        149 272
        442 21
        104 426
        154 214
        226 74
        342 126
        224 202
        95 151
        444 378
        65 169
        120 98
        389 410
        348 194
        284 285
        394 9
        202 157
        199 289
        275 414
        22 189
        100 163
        74 295
        282 125
        309 380
        244 403
        118 453
        67 339
        274 18
        107 389
        330 247
        354 397
        358 113
        212 206
        128 23
        188 255
        436 39
        399 276
        450 16
        314 39
        412 246
        252 377
        60 388
        167 163
        438 201
        369 33
        399 201
        98 28
        437 380
        153 220
        173 415
        62 405
        156 340
        387 392
        11 284
        288 52
        225 140
        6 246
        131 242
        286 202
        """

        self.waters = """
        0.5 0.0272 0.79323
        0.30626 0.95611 0.58812
        0.0 0.50171 0.336
        0.6871 0.71155 0.7223
        0.69095 0.8941 0.21076
        0.5 0.50788 0.77383
        0.68126 0.48797 0.58557
        0.18126 0.98797 0.58557
        0.5 0.81715 0.51321
        0.5 0.88084 0.83141
        0.0 0.07585 0.42933
        0.30626 0.92901 0.39085
        0.68405 0.44 0.91293
        0.125 0.63741 0.0832
        0.30905 0.8941 0.21076
        0.19374 0.52039 0.2887
        0.31874 0.49974 0.71057
        0.69374 0.02039 0.2887
        0.81874 0.99974 0.71057
        0.0 0.01566 0.02383
        0.0 0.04903 0.96422
        0.18791 0.33349 0.55127
        0.69095 0.14807 0.55041
        0.19095 0.64807 0.55041
        0.0 0.19437 0.09703
        0.68791 0.18566 0.74669
        0.375 0.89822 0.36877
        0.875 0.39822 0.36877
        0.625 0.28603 0.06556
        0.5 0.58753 0.58773
        0.0 0.08753 0.58773
        0.80626 0.45611 0.58812
        0.125 0.3626 0.5832
        0.5 0.86713 0.01106
        0.125 0.86085 0.34842
        0.25 0.30655 0.96427
        0.875 0.09596 0.06686
        0.625 0.82437 0.0826
        0.5 0.68215 0.91705
        0.375 0.67454 0.34621
        0.875 0.17454 0.34621
        0.31595 0.40143 0.72101
        0.5 0.96302 0.51042
        0.5 0.42415 0.92933
        0.3121 0.78896 0.70707
        0.3121 0.81434 0.24669
        0.19374 0.53021 0.71395
        0.5 0.57585 0.42933
        0.5 0.36783 0.9149
        0.18405 0.94 0.91293
        0.1871 0.23936 0.15228
        0.31874 0.52704 0.39768
        0.68126 0.56611 0.01248
        0.80905 0.56489 0.5413
        0.75 0.30655 0.96427
        0.19374 0.57099 0.89085
        0.69374 0.07099 0.89085
        0.19374 0.51199 0.50672
        0.0 0.39149 0.11491
        0.5 0.69437 0.09703
        0.5 0.41247 0.08773
        0.3121 0.21104 0.20707
        0.30905 0.87219 0.74554
        0.0 0.76295 0.43402
        0.625 0.10178 0.86877
        0.18791 0.24463 0.52728
        0.81874 0.97296 0.89768
        0.5 0.10851 0.61491
        0.19374 0.42901 0.39085
        0.69095 0.93511 0.0413
        0.375 0.59596 0.06686
        0.0 0.41165 0.85303
        0.31874 0.43389 0.51248
        0.81874 0.93389 0.51248
        0.5 0.00279 0.961
        0.18791 0.73979 0.77728
        0.75 0.38017 0.46708
        0.18405 0.85287 0.87688
        0.68405 0.35287 0.87688
        0.6871 0.73936 0.15228
        0.5 0.79138 0.61381
        0.19095 0.6059 0.71076
        0.69374 0.01199 0.50672
        0.8121 0.75538 0.02728
        0.31874 0.48797 0.58557
        0.75 0.61984 0.96708
        0.5 0.89149 0.11491
        0.375 0.78638 0.86319
        0.375 0.40404 0.56686
        0.68405 0.57813 0.65356
        0.0 0.49721 0.461
        0.5 0.99721 0.461
        0.125 0.60178 0.86877
        0.5 0.7707 0.34008
        0.31874 0.47296 0.89768
        0.31595 0.36951 0.18428
        0.75 0.69345 0.46427
        0.18405 0.86951 0.18428
        0.375 0.28603 0.06556
        0.31291 0.28845 0.2223
        0.81291 0.78845 0.2223
        0.5 0.13287 0.51106
        0.125 0.32437 0.0826
        0.80905 0.42594 0.79048
        0.81291 0.25549 0.90228
        0.25 0.61984 0.96708
        0.0 0.77102 0.59008
        0.125 0.21397 0.56556
        0.375 0.82437 0.0826
        0.375 0.63915 0.84842
        0.875 0.54924 0.21197
        0.1871 0.16675 0.87864
        0.31291 0.73936 0.15228
        0.81291 0.23936 0.15228
        0.5 0.49212 0.27383
        0.0 0.99212 0.27383
        0.5 0.76291 0.49617
        0.31291 0.31567 0.68294
        0.30905 0.06489 0.5413
        0.125 0.28638 0.86319
        0.3121 0.25538 0.02728
        0.25 0.11984 0.96708
        0.18126 0.93389 0.51248
        0.31291 0.66675 0.87864
        0.81291 0.16675 0.87864
        0.875 0.53556 0.58779
        0.81291 0.76065 0.65228
        0.0 0.91247 0.08773
        0.31595 0.64713 0.37688
        0.68405 0.56 0.41293
        0.80626 0.52039 0.2887
        0.81874 0.01203 0.08557
        0.69374 0.92901 0.39085
        0.19095 0.43511 0.0413
        0.875 0.78603 0.06556
        0.5 0.45486 0.30723
        0.0 0.73709 0.99617
        0.0 0.44759 0.40475
        0.75 0.11984 0.96708
        0.30626 0.07099 0.89085
        0.0 0.50279 0.961
        0.1871 0.18434 0.18294
        0.5 0.08835 0.35303
        0.0 0.86783 0.9149
        0.68405 0.6305 0.68428
        0.6871 0.26065 0.65228
        0.5 0.31785 0.41705
        0.125 0.39822 0.36877
        0.19374 0.48801 0.00672
        0.80905 0.62782 0.24554
        0.69095 0.06489 0.5413
        0.19095 0.35194 0.05041
        0.68405 0.40143 0.72101
        0.375 0.36085 0.34842
        0.0 0.7293 0.84008
        0.875 0.45077 0.71197
        0.0 0.60851 0.61491
        0.30905 0.14807 0.55041
        0.625 0.40404 0.56686
        0.375 0.71397 0.56556
        0.375 0.32546 0.84621
        0.875 0.82546 0.84621
        0.31595 0.57813 0.65356
        0.68791 0.76022 0.27728
        0.81874 0.00026 0.21057
        0.31595 0.56 0.41293
        0.30626 0.97961 0.7887
        0.81291 0.74451 0.40228
        0.6871 0.68434 0.18294
        0.31291 0.24451 0.40228
        0.5 0.18285 0.01321
        0.69374 0.95611 0.58812
        0.31291 0.71155 0.7223
        0.81291 0.21155 0.7223
        0.3121 0.18566 0.74669
        0.18126 0.06611 0.01248
        0.625 0.13741 0.0832
        0.80905 0.57406 0.29048
        0.8121 0.26022 0.27728
        0.30905 0.12782 0.24554
        0.68126 0.55693 0.76331
        0.68405 0.42187 0.15356
        0.875 0.71362 0.36319
        0.18791 0.66652 0.05127
        0.875 0.90404 0.56686
        0.81874 0.06611 0.01248
        0.18405 0.06 0.41293
        0.30626 0.02039 0.2887
        0.625 0.8626 0.5832
        0.625 0.17563 0.5826
        0.5 0.23709 0.99617
        0.75 0.80655 0.96427
        0.0 0.63287 0.51106
        0.30905 0.92594 0.79048
        0.80905 0.6059 0.71076
        0.80626 0.57099 0.89085
        0.30905 0.93511 0.0413
        0.30626 0.01199 0.50672
        0.0 0.47281 0.29323
        0.69374 0.96979 0.21395
        0.0 0.92415 0.92933
        0.81595 0.09857 0.22101
        0.18405 0.1305 0.68428
        0.68791 0.81434 0.24669
        0.0 0.95097 0.46422
        0.375 0.04924 0.21197
        0.6871 0.66675 0.87864
        0.30905 0.07406 0.29048
        0.3121 0.76022 0.27728
        0.25 0.80655 0.96427
        0.31291 0.26065 0.65228
        0.375 0.96445 0.08779
        0.8121 0.66652 0.05127
        0.5 0.2293 0.84008
        0.8121 0.73979 0.77728
        0.5 0.80454 0.33341
        0.30626 0.98801 0.00672
        0.30626 0.03021 0.71395
        0.6871 0.28845 0.2223
        0.1871 0.81567 0.68294
        0.625 0.36085 0.34842
        0.5 0.72898 0.09008
        0.0 0.22898 0.09008
        0.5 0.62091 0.59662
        0.0 0.12091 0.59662
        0.0 0.53698 0.01042
        0.5 0.03698 0.01042
        0.19095 0.57406 0.29048
        0.0 0.46302 0.51042
        0.625 0.32546 0.84621
        0.31874 0.44307 0.26331
        0.81874 0.02704 0.39768
        0.0 0.81785 0.41705
        0.0 0.69546 0.83341
        0.5 0.60269 0.313
        0.125 0.46445 0.08779
        0.75 0.19345 0.46427
        0.81291 0.81567 0.68294
        0.80626 0.46979 0.21395
        0.5 0.39731 0.813
        0.0 0.89731 0.813
        0.0 0.41693 0.01084
        0.69374 0.04389 0.08812
        0.68405 0.64713 0.37688
        0.625 0.59596 0.06686
        0.75 0.88017 0.46708
        0.68126 0.49974 0.71057
        0.80626 0.48801 0.00672
        0.68791 0.74463 0.52728
        0.25 0.19345 0.46427
        0.1871 0.25549 0.90228
        0.625 0.95077 0.71197
        0.6871 0.24451 0.40228
        0.19095 0.62782 0.24554
        0.0 0.18215 0.91705
        0.375 0.8626 0.5832
        0.875 0.3626 0.5832
        0.5 0.73705 0.93402
        0.68791 0.23979 0.77728
        0.0 0.68285 0.01321
        0.31595 0.42187 0.15356
        0.19374 0.45611 0.58812
        0.0 0.70862 0.11381
        0.5 0.20862 0.11381
        0.25 0.88017 0.46708
        0.18791 0.31434 0.24669
        0.875 0.13915 0.84842
        0.1871 0.76065 0.65228
        0.5 0.49008 0.89883
        0.0 0.99008 0.89883
        0.0 0.29138 0.61381
        0.80905 0.3941 0.21076
        0.0 0.61916 0.33141
        0.69095 0.92594 0.79048
        0.81874 0.98797 0.58557
        0.5 0.30564 0.59703
        0.18405 0.09857 0.22101
        0.80905 0.37219 0.74554
        0.5 0.54514 0.80723
        0.81595 0.86951 0.18428
        0.0 0.5272 0.79323
        0.0 0.00992 0.39883
        0.125 0.53556 0.58779
        0.68126 0.44307 0.26331
        0.18126 0.94307 0.26331
        0.0 0.95486 0.30723
        0.125 0.13915 0.84842
        0.625 0.63915 0.84842
        0.80626 0.54389 0.08812
        0.81874 0.94307 0.26331
        0.5 0.45097 0.46422
        0.5 0.19546 0.83341
        0.18791 0.28896 0.70707
        0.0 0.55241 0.90475
        0.5 0.05241 0.90475
        0.69374 0.98801 0.00672
        0.69374 0.97961 0.7887
        0.5 0.54903 0.96422
        0.8121 0.71104 0.20707
        0.5 0.48434 0.52383
        0.0 0.98434 0.52383
        0.3121 0.16652 0.05127
        0.125 0.09596 0.06686
        0.875 0.86085 0.34842
        0.5 0.26295 0.43402
        0.25 0.38017 0.46708
        0.18126 0.99974 0.71057
        0.625 0.03556 0.58779
        0.1871 0.78845 0.2223
        0.125 0.67563 0.5826
        0.0 0.36713 0.01106
        0.5 0.94759 0.40475
        0.8121 0.28896 0.70707
        0.125 0.82546 0.84621
        0.25 0.69345 0.46427
        0.68791 0.25538 0.02728
        0.69095 0.1059 0.71076
        0.30626 0.96979 0.21395
        0.5 0.51566 0.02383
        0.6871 0.33325 0.37864
        0.31595 0.44 0.91293
        0.875 0.46445 0.08779
        0.18791 0.68566 0.74669
        0.69095 0.85194 0.05041
        0.5 0.63217 0.4149
        0.0 0.2707 0.34008
        0.31291 0.33325 0.37864
        0.81291 0.83325 0.37864
        0.68405 0.36951 0.18428
        0.5 0.00171 0.336
        0.68126 0.47296 0.89768
        0.1871 0.74451 0.40228
        0.0 0.8791 0.09662
        0.31291 0.68434 0.18294
        0.81291 0.18434 0.18294
        0.80626 0.51199 0.50672
        0.375 0.13741 0.0832
        0.875 0.63741 0.0832
        0.31595 0.35287 0.87688
        0.5 0.08307 0.51084
        0.0 0.58307 0.51084
        0.0 0.26291 0.49617
        0.68791 0.78896 0.70707
        0.625 0.78638 0.86319
        0.19095 0.42594 0.79048
        0.68126 0.52704 0.39768
        0.18126 0.02704 0.39768
        0.0 0.79103 0.31619
        0.875 0.60178 0.86877
        0.1871 0.83325 0.37864
        0.68791 0.16652 0.05127
        0.375 0.17563 0.5826
        0.0 0.13217 0.4149
        0.81595 0.14713 0.37688
        0.69095 0.87219 0.74554
        0.31874 0.51203 0.08557
        0.125 0.17454 0.34621
        0.5 0.50992 0.39883
        0.68791 0.21104 0.20707
        0.18126 0.97296 0.89768
        0.125 0.45077 0.71197
        0.5 0.99829 0.836
        0.30905 0.1059 0.71076
        0.30626 0.04389 0.08812
        0.625 0.04924 0.21197
        0.81595 0.90143 0.72101
        0.31595 0.6305 0.68428
        0.81595 0.1305 0.68428
        0.69374 0.03021 0.71395
        0.30905 0.85194 0.05041
        0.80905 0.35194 0.05041
        0.80626 0.42901 0.39085
        0.8121 0.68566 0.74669
        0.625 0.96445 0.08779
        0.18791 0.75538 0.02728
        0.375 0.21362 0.36319
        0.19095 0.56489 0.5413
        0.8121 0.24463 0.52728
        0.68126 0.50026 0.21057
        0.18126 0.00026 0.21057
        0.875 0.67563 0.5826
        0.19095 0.37219 0.74554
        0.125 0.71362 0.36319
        0.18791 0.71104 0.20707
        0.5 0.70897 0.81619
        0.6871 0.75549 0.90228
        0.125 0.90404 0.56686
        0.0 0.49829 0.836
        0.5 0.3791 0.09662
        0.1871 0.21155 0.7223
        0.5 0.27102 0.59008
        0.81595 0.06 0.41293
        0.80626 0.47961 0.7887
        0.19374 0.46979 0.21395
        0.5 0.91165 0.85303
        0.31595 0.59857 0.22101
        0.18126 0.01203 0.08557
        0.81595 0.85287 0.87688
        0.0 0.58835 0.35303
        0.0 0.10269 0.313
        0.68126 0.43389 0.51248
        0.81595 0.94 0.91293
        0.3121 0.74463 0.52728
        0.68405 0.59857 0.22101
        0.5 0.91693 0.01084
        0.18405 0.90143 0.72101
        0.375 0.95077 0.71197
        0.3121 0.83349 0.55127
        0.18405 0.14713 0.37688
        0.18405 0.07813 0.65356
        0.3121 0.23979 0.77728
        0.0 0.04514 0.80723
        0.80626 0.53021 0.71395
        0.0 0.20897 0.81619
        0.6871 0.31567 0.68294
        0.875 0.21397 0.56556
        0.81595 0.07813 0.65356
        0.125 0.54924 0.21197
        0.69095 0.07406 0.29048
        0.19095 0.3941 0.21076
        0.31874 0.55693 0.76331
        0.81874 0.05693 0.76331
        0.80905 0.43511 0.0413
        0.0 0.00788 0.77383
        0.5 0.97281 0.29323
        0.8121 0.31434 0.24669
        0.0 0.23705 0.93402
        0.875 0.32437 0.0826
        0.5 0.29103 0.31619
        0.18405 0.92187 0.15356
        0.68791 0.83349 0.55127
        0.125 0.78603 0.06556
        0.19374 0.54389 0.08812
        0.8121 0.33349 0.55127
        0.0 0.30454 0.33341
        0.625 0.21362 0.36319
        0.625 0.67454 0.34621
        0.80905 0.64807 0.55041
        0.69095 0.12782 0.24554
        0.31291 0.75549 0.90228
        0.18791 0.26022 0.27728
        0.31874 0.50026 0.21057
        0.0 0.31715 0.51321
        0.0 0.38084 0.83141
        0.68126 0.51203 0.08557
        0.81595 0.92187 0.15356
        0.625 0.71397 0.56556
        0.625 0.89822 0.36877
        0.5 0.11916 0.33141
        0.18126 0.05693 0.76331
        0.19374 0.47961 0.7887
        0.375 0.10178 0.86877
        0.0 0.80564 0.59703
        0.375 0.03556 0.58779
        0.875 0.28638 0.86319
        0.31874 0.56611 0.01248
        """

        self.coord = "relative"

        self.cages = """
        14 0.5 0.71796 0.33875
        14 0.5 0.28204 0.83875
        14 0.0 0.21796 0.33875
        14 0.0 0.78204 0.83875
        12 0.27495 0.47646 0.40041
        12 0.72505 0.52354 0.90041
        12 0.27495 0.52354 0.90041
        12 0.77495 0.97646 0.40041
        12 0.72505 0.47646 0.40041
        12 0.22505 0.02354 0.90041
        12 0.77495 0.02354 0.90041
        12 0.22505 0.97646 0.40041
        12 0.5 0.00901 0.14738
        12 0.5 0.99099 0.64738
        12 0.0 0.50901 0.14738
        12 0.0 0.49099 0.64738
        12 0.25162 0.29172 0.46571
        12 0.74838 0.70828 0.96571
        12 0.25162 0.70828 0.96571
        12 0.75162 0.79172 0.46571
        12 0.74838 0.29172 0.46571
        12 0.24838 0.20828 0.96571
        12 0.75162 0.20828 0.96571
        12 0.24838 0.79172 0.46571
        14 0.5 0.21859 0.59016
        14 0.5 0.78141 0.09016
        14 0.0 0.71859 0.59016
        14 0.0 0.28141 0.09016
        15 0.5 0.16816 0.30933
        15 0.5 0.83184 0.80933
        15 0.0 0.66816 0.30933
        15 0.0 0.33184 0.80933
        15 0.5 0.09184 0.09346
        15 0.5 0.90816 0.59346
        15 0.0 0.59184 0.09346
        15 0.0 0.40816 0.59346
        16 0.5 0.55117 0.21122
        16 0.5 0.44883 0.71122
        16 0.0 0.05117 0.21122
        16 0.0 0.94883 0.71122
        15 0.0 0.14294 0.11795
        15 0.0 0.85706 0.61795
        15 0.5 0.64294 0.11795
        15 0.5 0.35706 0.61795
        15 0.5 0.3309 0.11882
        15 0.5 0.6691 0.61882
        15 0.0 0.8309 0.11882
        15 0.0 0.1691 0.61882
        14 0.5 0.40212 0.34482
        14 0.5 0.59788 0.84482
        14 0.0 0.90212 0.34482
        14 0.0 0.09788 0.84482
        15 0.5 0.4644 0.08327
        15 0.5 0.5356 0.58327
        15 0.0 0.9644 0.08327
        15 0.0 0.0356 0.58327
        12 0.5 0.04492 0.3958
        12 0.5 0.95508 0.8958
        12 0.0 0.54492 0.3958
        12 0.0 0.45508 0.8958
        12 0.5 0.07071 0.72472
        12 0.5 0.92929 0.22472
        12 0.0 0.57071 0.72472
        12 0.0 0.42929 0.22472
        15 0.5 0.14668 0.81207
        15 0.5 0.85332 0.31207
        15 0.0 0.64668 0.81207
        15 0.0 0.35332 0.31207
        12 0.23619 0.10832 0.46142
        12 0.76381 0.89168 0.96142
        12 0.23619 0.89168 0.96142
        12 0.73619 0.60832 0.46142
        12 0.76381 0.10832 0.46142
        12 0.26381 0.39168 0.96142
        12 0.73619 0.39168 0.96142
        12 0.26381 0.60832 0.46142
        12 0.5 0.24977 0.2145
        12 0.5 0.75023 0.7145
        12 0.0 0.74977 0.2145
        12 0.0 0.25023 0.7145
        """

        self.bondlen = 3

        self.cell = """
        16.277534865206228 114.43420763235943 21.692280574253285
        """

        self.density = 0.33732372106521624

        self.cell = cellvectors(a=16.277534865206228,
                                b=114.43420763235943,
                                c=21.692280574253285)
