# -*- coding: utf-8 -*-
import numpy as np

from dewloosh.geom.cells import T3 as Triangle

from ..elem import FiniteElement
from ..model.membrane import Membrane
from ..model.plate import Plate



class CSTM(Triangle, Membrane, FiniteElement):
    """
    The constant-strain triangle (a.k.a., CST triangle, Turner triangle)
    """

    qrule = 'full'
    quadrature = {
        'full': (np.array([[1/3, 1/3]]), np.array([1/2])),
    }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


class CSTP(Triangle, Plate, FiniteElement):
    """
    The constant-strain triangle (a.k.a., CST triangle, Turner triangle)
    """

    qrule = 'full'
    quadrature = {
        'full': (np.array([[1/3, 1/3]]), np.array([1/2])),
    }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)


if __name__ == '__main__':
    pass
