from ._commands import (hidden, session, database, preproc, aux15_, map_cmd,
                        aux2_, aux3_, aux12_, reduced, apdl, post26_, solution,
                        post1_, graphics_, display_, conn)

class Commands:
    """Wrapped MAPDL commands"""

    ##################
    # Session commands
    ##################

    config = session.run_controls.config
    cwd = session.run_controls.cwd
    filname = session.run_controls.filname
    keyw = session.run_controls.keyw
    memm = session.run_controls.memm
    nerr = session.run_controls.nerr
    pause = session.run_controls.pause
    slashstatus = session.run_controls.slashstatus
    starstatus = session.run_controls.starstatus
    syp = session.run_controls.syp
    sys = session.run_controls.sys
    unpause = session.run_controls.unpause

    anstoaqwa = session.files.anstoaqwa
    anstoasas = session.files.anstoasas
    assign = session.files.assign
    copy = session.files.copy
    slashdelete = session.files.slashdelete
    fcomp = session.files.fcomp
    lgwrite = session.files.lgwrite
    starlist = session.files.starlist
    rename = session.files.rename
    slashclog = session.files.slashclog
    slashfdele = session.files.slashfdele

    com = session.list_controls.com
    golist = session.list_controls.golist
    gopr = session.list_controls.gopr
    nolist = session.list_controls.nolist
    nopr = session.list_controls.nopr

    aux2 = session.processor_entry.aux2
    aux3 = session.processor_entry.aux3
    aux12 = session.processor_entry.aux12
    aux15 = session.processor_entry.aux15
    finish = session.processor_entry.finish
    map = session.processor_entry.map
    post1 = session.processor_entry.post1
    post26 = session.processor_entry.post26
    prep7 = session.processor_entry.prep7
    quit = session.processor_entry.quit
    slashsolu = session.processor_entry.slashsolu

    ###################
    # Database commands
    ###################
    cm = database.components.cm
    cmdele = database.components.cmdele
    cmedit = database.components.cmedit
    cmgrp = database.components.cmgrp
    cmlist = database.components.cmlist
    cmmod = database.components.cmmod
    cmplot = database.components.cmplot
    cmsel = database.components.cmsel
    cmwrite = database.components.cmwrite

    clocal = database.coord_sys.clocal
    cs = database.coord_sys.cs
    cscir = database.coord_sys.cscir
    csdele = database.coord_sys.csdele
    cskp = database.coord_sys.cskp
    cslist = database.coord_sys.cslist
    cswpla = database.coord_sys.cswpla
    csys = database.coord_sys.csys
    local = database.coord_sys.local

    fitem = database.picking.fitem
    flst = database.picking.flst

    allsel = database.selecting.allsel
    asll = database.selecting.asll
    asel = database.selecting.asel
    aslv = database.selecting.aslv
    dofsel = database.selecting.dofsel
    esel = database.selecting.esel
    esla = database.selecting.esla
    esll = database.selecting.esll
    esln = database.selecting.esln
    eslv = database.selecting.eslv
    ksel = database.selecting.ksel
    ksll = database.selecting.ksll
    ksln = database.selecting.ksln
    lsel = database.selecting.lsel
    lsla = database.selecting.lsla
    lslk = database.selecting.lslk
    nsel = database.selecting.nsel
    nsla = database.selecting.nsla
    nsle = database.selecting.nsle
    nslk = database.selecting.nslk
    nsll = database.selecting.nsll
    nslv = database.selecting.nslv
    partsel = database.selecting.partsel
    vsel = database.selecting.vsel
    vsla = database.selecting.vsla
    seltol = database.selecting.seltol

    resume = database.setup.resume
    save = database.setup.save
    smbc = database.setup.smbc
    stat = database.setup.stat
    stitle = database.setup.stitle
    title = database.setup.title
    units = database.setup.units

    kwpave = database.working_plane.kwpave
    kwplan = database.working_plane.kwplan
    lwplan = database.working_plane.lwplan
    nwpave = database.working_plane.nwpave
    nwplan = database.working_plane.nwplan
    wpave = database.working_plane.wpave
    wpcsys = database.working_plane.wpcsys
    wplane = database.working_plane.wplane
    wpoffs = database.working_plane.wpoffs
    wprota = database.working_plane.wprota
    wpstyl = database.working_plane.wpstyl

    # mapping processor
    ftype = map_cmd.ftype
    map_ = map_cmd.map_
    plgeom = map_cmd.plgeom
    plmap = map_cmd.plmap
    read = map_cmd.read
    slashmap = map_cmd.slashmap
    target = map_cmd.target
    writemap = map_cmd.writemap

    # AUX15
    igesin = aux15_.igesin
    ioptn = aux15_.ioptn

    # AUX2
    combine = aux2_.bin_manip.combine
    hbmat = aux2_.bin_manip.hbmat
    psmat = aux2_.bin_manip.psmat
    dump = aux2_.bin_dump.dump
    fileaux2 = aux2_.bin_dump.fileaux2
    form = aux2_.bin_dump.form
    ptr = aux2_.bin_dump.ptr

    # AUX3
    compress = aux3_.compress
    delete = aux3_.delete
    fileaux3 = aux3_.fileaux3
    list = aux3_.list
    modify = aux3_.modify
    undelete = aux3_.undelete

    # AUX12
    emis = aux12_.radiation_mat.emis
    geom = aux12_.radiation_mat.geom
    mprint = aux12_.radiation_mat.mprint
    space = aux12_.radiation_mat.space
    vtype = aux12_.radiation_mat.vtype
    write = aux12_.radiation_mat.write
    stef = aux12_.general_radiation.stef
    toffst = aux12_.general_radiation.toffst
    hemiopt = aux12_.radiosity_solver.hemiopt
    radopt = aux12_.radiosity_solver.radopt
    spcnod = aux12_.radiosity_solver.spcnod
    spctemp = aux12_.radiosity_solver.spctemp
    v2dopt = aux12_.radiosity_solver.v2dopt
    vfopt = aux12_.radiosity_solver.vfopt
    vfsm = aux12_.radiosity_solver.vfsm
    vfquery = aux12_.radiosity_solver.vfquery

    # reduced processor
    rmndisp = reduced.preparation.rmndisp
    rmnevec = reduced.preparation.rmnevec
    rmresume = reduced.setup.rmresume
    rmsave = reduced.setup.rmsave
    dcvswp = reduced.use_pass.dcvswp
    rmlvscale = reduced.use_pass.rmlvscale
    rmuse = reduced.use_pass.rmuse
    rmalist = reduced.generation.rmalist
    rmanl = reduced.generation.rmanl
    rmaster = reduced.generation.rmaster
    rmcap = reduced.generation.rmcap
    rmclist = reduced.generation.rmclist
    rmmlist = reduced.generation.rmmlist
    rmmrange = reduced.generation.rmmrange
    rmmselect = reduced.generation.rmmselect
    rmporder = reduced.generation.rmporder
    rmrgenerate = reduced.generation.rmrgenerate
    rmroptions = reduced.generation.rmroptions
    rmrplot = reduced.generation.rmrplot
    rmrstatus = reduced.generation.rmrstatus
    rmsmple = reduced.generation.rmsmple
    rmxport = reduced.generation.rmxport

    ################
    # PREP7 commands
    ################
    aflist = preproc.database.aflist
    cdread = preproc.database.cdread
    cdwrite = preproc.database.cdwrite
    cdopt = preproc.database.cdopt
    cecheck = preproc.database.cecheck
    check = preproc.database.check
    cncheck = preproc.database.cncheck
    igesout = preproc.database.igesout
    mfimport = preproc.database.mfimport
    nooffset = preproc.database.nooffset
    numcmp = preproc.database.numcmp
    nummrg = preproc.database.nummrg
    numoff = preproc.database.numoff
    numstr = preproc.database.numstr
    nsvr = preproc.element_type.nsvr
    dof = preproc.element_type.dof
    elbow = preproc.element_type.elbow
    et = preproc.element_type.et
    etchg = preproc.element_type.etchg
    etcontrol = preproc.element_type.etcontrol
    etdele = preproc.element_type.etdele
    etlist = preproc.element_type.etlist
    keyopt = preproc.element_type.keyopt
    r = preproc.real_constants.r
    rdele = preproc.real_constants.rdele
    rlist = preproc.real_constants.rlist
    rmodif = preproc.real_constants.rmodif
    rmore = preproc.real_constants.rmore
    setfgap = preproc.real_constants.setfgap
    emunit = preproc.materials.emunit
    mp = preproc.materials.mp
    mpamod = preproc.materials.mpamod
    mpchg = preproc.materials.mpchg
    mpcopy = preproc.materials.mpcopy
    mpdata = preproc.materials.mpdata
    mpdele = preproc.materials.mpdele
    mpdres = preproc.materials.mpdres
    mplib = preproc.materials.mplib
    mplist = preproc.materials.mplist
    mpplot = preproc.materials.mpplot
    mpread = preproc.materials.mpread
    mptemp = preproc.materials.mptemp
    mptgen = preproc.materials.mptgen
    mptres = preproc.materials.mptres
    mpwrite = preproc.materials.mpwrite
    tbft = preproc.materials.tbft
    uimp = preproc.materials.uimp
    tb = preproc.material_data_tables.tb
    tbcopy = preproc.material_data_tables.tbcopy
    tbdata = preproc.material_data_tables.tbdata
    tbdele = preproc.material_data_tables.tbdele
    tbeo = preproc.material_data_tables.tbeo
    tbfield = preproc.material_data_tables.tbfield
    tbin = preproc.material_data_tables.tbin
    tblist = preproc.material_data_tables.tblist
    tbmodif = preproc.material_data_tables.tbmodif
    tbplot = preproc.material_data_tables.tbplot
    tbpt = preproc.material_data_tables.tbpt
    tbtemp = preproc.material_data_tables.tbtemp
    accat = preproc.meshing.accat
    aclear = preproc.meshing.aclear
    aesize = preproc.meshing.aesize
    amap = preproc.meshing.amap
    amesh = preproc.meshing.amesh
    arefine = preproc.meshing.arefine
    chkmsh = preproc.meshing.chkmsh
    clrmshln = preproc.meshing.clrmshln
    cpcyc = preproc.meshing.cpcyc
    czdel = preproc.meshing.czdel
    czmesh = preproc.meshing.czmesh
    desize = preproc.meshing.desize
    eorient = preproc.meshing.eorient
    erefine = preproc.meshing.erefine
    esize = preproc.meshing.esize
    esys = preproc.meshing.esys
    fvmesh = preproc.meshing.fvmesh
    gsgdata = preproc.meshing.gsgdata
    imesh = preproc.meshing.imesh
    katt = preproc.meshing.katt
    kclear = preproc.meshing.kclear
    kesize = preproc.meshing.kesize
    kmesh = preproc.meshing.kmesh
    krefine = preproc.meshing.krefine
    kscon = preproc.meshing.kscon
    latt = preproc.meshing.latt
    lccat = preproc.meshing.lccat
    lclear = preproc.meshing.lclear
    lesize = preproc.meshing.lesize
    lmesh = preproc.meshing.lmesh
    lrefine = preproc.meshing.lrefine
    mat = preproc.meshing.mat
    mcheck = preproc.meshing.mcheck
    modmsh = preproc.meshing.modmsh
    mopt = preproc.meshing.mopt
    mshape = preproc.meshing.mshape
    mshcopy = preproc.meshing.mshcopy
    mshkey = preproc.meshing.mshkey
    mshmid = preproc.meshing.mshmid
    mshpattern = preproc.meshing.mshpattern
    nrefine = preproc.meshing.nrefine
    psmesh = preproc.meshing.psmesh
    real = preproc.meshing.real
    rthick = preproc.meshing.rthick
    shpp = preproc.meshing.shpp
    smrtsize = preproc.meshing.smrtsize
    tchg = preproc.meshing.tchg
    timp = preproc.meshing.timp
    type = preproc.meshing.type
    vatt = preproc.meshing.vatt
    vclear = preproc.meshing.vclear
    vimp = preproc.meshing.vimp
    vmesh = preproc.meshing.vmesh
    veorient = preproc.meshing.veorient
    vsweep = preproc.meshing.vsweep
    ce = preproc.constraint_equations.ce
    cecyc = preproc.constraint_equations.cecyc
    cedele = preproc.constraint_equations.cedele
    ceintf = preproc.constraint_equations.ceintf
    celist = preproc.constraint_equations.celist
    cerig = preproc.constraint_equations.cerig
    cesgen = preproc.constraint_equations.cesgen
    rbe3 = preproc.constraint_equations.rbe3
    a = preproc.areas.a
    aatt = preproc.areas.aatt
    adele = preproc.areas.adele
    adgl = preproc.areas.adgl
    adrag = preproc.areas.adrag
    afillt = preproc.areas.afillt
    agen = preproc.areas.agen
    al = preproc.areas.al
    alist = preproc.areas.alist
    anorm = preproc.areas.anorm
    aoffst = preproc.areas.aoffst
    aplot = preproc.areas.aplot
    areverse = preproc.areas.areverse
    arotat = preproc.areas.arotat
    arscale = preproc.areas.arscale
    arsym = preproc.areas.arsym
    askin = preproc.areas.askin
    asub = preproc.areas.asub
    asum = preproc.areas.asum
    atran = preproc.areas.atran
    gsum = preproc.areas.gsum
    splot = preproc.areas.splot
    cp = preproc.coupled_dof.cp
    cpdele = preproc.coupled_dof.cpdele
    cpintf = preproc.coupled_dof.cpintf
    cplgen = preproc.coupled_dof.cplgen
    cplist = preproc.coupled_dof.cplist
    cpmerge = preproc.coupled_dof.cpmerge
    cpngen = preproc.coupled_dof.cpngen
    cpsgen = preproc.coupled_dof.cpsgen
    pmlopt = preproc.artificially_matched_layers.pmlopt
    pmlsize = preproc.artificially_matched_layers.pmlsize
    aerocoeff = preproc.special_purpose.aerocoeff
    cint = preproc.special_purpose.cint
    cycfreq = preproc.special_purpose.cycfreq
    cyclic = preproc.special_purpose.cyclic
    cycopt = preproc.special_purpose.cycopt
    emsym = preproc.special_purpose.emsym
    mstole = preproc.special_purpose.mstole
    perbc2d = preproc.special_purpose.perbc2d
    physics = preproc.special_purpose.physics
    race = preproc.special_purpose.race
    sstate = preproc.special_purpose.sstate
    xfdata = preproc.special_purpose.xfdata
    xfenrich = preproc.special_purpose.xfenrich
    xflist = preproc.special_purpose.xflist
    edasmp = preproc.explicit_dynamics.edasmp
    edbound = preproc.explicit_dynamics.edbound
    edbx = preproc.explicit_dynamics.edbx
    edcgen = preproc.explicit_dynamics.edcgen
    edclist = preproc.explicit_dynamics.edclist
    edcmore = preproc.explicit_dynamics.edcmore
    edcnstr = preproc.explicit_dynamics.edcnstr
    edcontact = preproc.explicit_dynamics.edcontact
    edcrb = preproc.explicit_dynamics.edcrb
    edcurve = preproc.explicit_dynamics.edcurve
    eddbl = preproc.explicit_dynamics.eddbl
    eddc = preproc.explicit_dynamics.eddc
    edipart = preproc.explicit_dynamics.edipart
    edlcs = preproc.explicit_dynamics.edlcs
    edmp = preproc.explicit_dynamics.edmp
    ednb = preproc.explicit_dynamics.ednb
    edndtsd = preproc.explicit_dynamics.edndtsd
    ednrot = preproc.explicit_dynamics.ednrot
    edpart = preproc.explicit_dynamics.edpart
    edpc = preproc.explicit_dynamics.edpc
    edsp = preproc.explicit_dynamics.edsp
    edweld = preproc.explicit_dynamics.edweld
    edadapt = preproc.explicit_dynamics.edadapt
    edale = preproc.explicit_dynamics.edale
    edbvis = preproc.explicit_dynamics.edbvis
    edcadapt = preproc.explicit_dynamics.edcadapt
    edcpu = preproc.explicit_dynamics.edcpu
    edcsc = preproc.explicit_dynamics.edcsc
    edcts = preproc.explicit_dynamics.edcts
    eddamp = preproc.explicit_dynamics.eddamp
    eddrelax = preproc.explicit_dynamics.eddrelax
    eddump = preproc.explicit_dynamics.eddump
    edenergy = preproc.explicit_dynamics.edenergy
    edfplot = preproc.explicit_dynamics.edfplot
    edgcale = preproc.explicit_dynamics.edgcale
    edhgls = preproc.explicit_dynamics.edhgls
    edhist = preproc.explicit_dynamics.edhist
    edhtime = preproc.explicit_dynamics.edhtime
    edint = preproc.explicit_dynamics.edint
    edis = preproc.explicit_dynamics.edis
    edload = preproc.explicit_dynamics.edload
    edopt = preproc.explicit_dynamics.edopt
    edout = preproc.explicit_dynamics.edout
    edpl = preproc.explicit_dynamics.edpl
    edpvel = preproc.explicit_dynamics.edpvel
    edrc = preproc.explicit_dynamics.edrc
    edrd = preproc.explicit_dynamics.edrd
    edri = preproc.explicit_dynamics.edri
    edrst = preproc.explicit_dynamics.edrst
    edrun = preproc.explicit_dynamics.edrun
    edshell = preproc.explicit_dynamics.edshell
    edsolv = preproc.explicit_dynamics.edsolv
    edstart = preproc.explicit_dynamics.edstart
    edterm = preproc.explicit_dynamics.edterm
    edtp = preproc.explicit_dynamics.edtp
    edvel = preproc.explicit_dynamics.edvel
    edwrite = preproc.explicit_dynamics.edwrite
    rexport = preproc.explicit_dynamics.rexport
    bsplin = preproc.lines.bsplin
    circle = preproc.lines.circle
    l = preproc.lines.l
    l2ang = preproc.lines.l2ang
    l2tan = preproc.lines.l2tan
    lang = preproc.lines.lang
    larc = preproc.lines.larc
    larea = preproc.lines.larea
    lcomb = preproc.lines.lcomb
    ldele = preproc.lines.ldele
    ldiv = preproc.lines.ldiv
    ldrag = preproc.lines.ldrag
    lextnd = preproc.lines.lextnd
    lfillt = preproc.lines.lfillt
    lgen = preproc.lines.lgen
    llist = preproc.lines.llist
    lplot = preproc.lines.lplot
    lreverse = preproc.lines.lreverse
    lrotat = preproc.lines.lrotat
    lsscale = preproc.lines.lsscale
    lstr = preproc.lines.lstr
    lsum = preproc.lines.lsum
    lsymm = preproc.lines.lsymm
    ltan = preproc.lines.ltan
    ltran = preproc.lines.ltran
    spline = preproc.lines.spline
    ssln = preproc.lines.ssln
    morph = preproc.morphing.morph
    damorph = preproc.morphing.damorph
    demorph = preproc.morphing.demorph
    dvmorph = preproc.morphing.dvmorph
    dig = preproc.digitizing.dig
    dmove = preproc.digitizing.dmove
    dset = preproc.digitizing.dset
    dsurf = preproc.digitizing.dsurf
    blc4 = preproc.primitives.blc4
    blc5 = preproc.primitives.blc5
    block = preproc.primitives.block
    con4 = preproc.primitives.con4
    cone = preproc.primitives.cone
    cyl4 = preproc.primitives.cyl4
    cyl5 = preproc.primitives.cyl5
    cylind = preproc.primitives.cylind
    pcirc = preproc.primitives.pcirc
    poly = preproc.primitives.poly
    pri2 = preproc.primitives.pri2
    prism = preproc.primitives.prism
    ptxy = preproc.primitives.ptxy
    rectng = preproc.primitives.rectng
    rpoly = preproc.primitives.rpoly
    rpr4 = preproc.primitives.rpr4
    rprism = preproc.primitives.rprism
    sph4 = preproc.primitives.sph4
    sph5 = preproc.primitives.sph5
    sphere = preproc.primitives.sphere
    torus = preproc.primitives.torus
    bsax = preproc.sections.bsax
    bsm1 = preproc.sections.bsm1
    bsm2 = preproc.sections.bsm2
    bsmd = preproc.sections.bsmd
    bss1 = preproc.sections.bss1
    bss2 = preproc.sections.bss2
    bste = preproc.sections.bste
    bstq = preproc.sections.bstq
    cbmd = preproc.sections.cbmd
    cbmx = preproc.sections.cbmx
    cbte = preproc.sections.cbte
    cbtmp = preproc.sections.cbtmp
    sdelete = preproc.sections.sdelete
    secmodif = preproc.sections.secmodif
    secfunction = preproc.sections.secfunction
    seccontrol = preproc.sections.seccontrol
    secdata = preproc.sections.secdata
    secjoint = preproc.sections.secjoint
    seclib = preproc.sections.seclib
    seclock = preproc.sections.seclock
    secnum = preproc.sections.secnum
    secoffset = preproc.sections.secoffset
    secplot = preproc.sections.secplot
    secread = preproc.sections.secread
    secstop = preproc.sections.secstop
    sectype = preproc.sections.sectype
    secwrite = preproc.sections.secwrite
    sflex = preproc.sections.sflex
    slist = preproc.sections.slist
    sload = preproc.sections.sload
    ssbt = preproc.sections.ssbt
    ssmt = preproc.sections.ssmt
    sspa = preproc.sections.sspa
    sspb = preproc.sections.sspb
    sspd = preproc.sections.sspd
    sspe = preproc.sections.sspe
    sspm = preproc.sections.sspm
    extopt = preproc.volumes.extopt
    v = preproc.volumes.v
    va = preproc.volumes.va
    vdele = preproc.volumes.vdele
    vdgl = preproc.volumes.vdgl
    vdrag = preproc.volumes.vdrag
    vext = preproc.volumes.vext
    vgen = preproc.volumes.vgen
    vlist = preproc.volumes.vlist
    vlscale = preproc.volumes.vlscale
    voffst = preproc.volumes.voffst
    vplot = preproc.volumes.vplot
    vrotat = preproc.volumes.vrotat
    vsum = preproc.volumes.vsum
    vsymm = preproc.volumes.vsymm
    vtran = preproc.volumes.vtran
    areas = preproc.status.areas
    bool = preproc.status.bool
    ceqn = preproc.status.ceqn
    couple = preproc.status.couple
    digit = preproc.status.digit
    elem = preproc.status.elem
    etype = preproc.status.etype
    febody = preproc.status.febody
    fecons = preproc.status.fecons
    fefor = preproc.status.fefor
    fesurf = preproc.status.fesurf
    geometry = preproc.status.geometry
    keypts = preproc.status.keypts
    line = preproc.status.line
    mater = preproc.status.mater
    meshing = preproc.status.meshing
    nodes = preproc.status.nodes
    prim = preproc.status.prim
    rcon = preproc.status.rcon
    selm = preproc.status.selm
    tble = preproc.status.tble
    volumes = preproc.status.volumes
    k = preproc.keypoints.k
    kbetw = preproc.keypoints.kbetw
    kcenter = preproc.keypoints.kcenter
    kdele = preproc.keypoints.kdele
    kdist = preproc.keypoints.kdist
    kfill = preproc.keypoints.kfill
    kgen = preproc.keypoints.kgen
    kl = preproc.keypoints.kl
    klist = preproc.keypoints.klist
    kmodif = preproc.keypoints.kmodif
    kmove = preproc.keypoints.kmove
    knode = preproc.keypoints.knode
    kplot = preproc.keypoints.kplot
    kpscale = preproc.keypoints.kpscale
    kscale = preproc.keypoints.kscale
    ksum = preproc.keypoints.ksum
    ksymm = preproc.keypoints.ksymm
    ktran = preproc.keypoints.ktran
    source = preproc.keypoints.source
    aadd = preproc.booleans.aadd
    aglue = preproc.booleans.aglue
    aina = preproc.booleans.aina
    ainp = preproc.booleans.ainp
    ainv = preproc.booleans.ainv
    aovlap = preproc.booleans.aovlap
    aptn = preproc.booleans.aptn
    asba = preproc.booleans.asba
    asbl = preproc.booleans.asbl
    asbv = preproc.booleans.asbv
    asbw = preproc.booleans.asbw
    boptn = preproc.booleans.boptn
    btol = preproc.booleans.btol
    lcsl = preproc.booleans.lcsl
    lglue = preproc.booleans.lglue
    lina = preproc.booleans.lina
    linl = preproc.booleans.linl
    linp = preproc.booleans.linp
    linv = preproc.booleans.linv
    lovlap = preproc.booleans.lovlap
    lptn = preproc.booleans.lptn
    lsba = preproc.booleans.lsba
    lsbl = preproc.booleans.lsbl
    lsbv = preproc.booleans.lsbv
    lsbw = preproc.booleans.lsbw
    vadd = preproc.booleans.vadd
    vglue = preproc.booleans.vglue
    vinp = preproc.booleans.vinp
    vinv = preproc.booleans.vinv
    vovlap = preproc.booleans.vovlap
    vptn = preproc.booleans.vptn
    vsba = preproc.booleans.vsba
    vsbv = preproc.booleans.vsbv
    vsbw = preproc.booleans.vsbw
    hptcreate = preproc.hard_points.hptcreate
    hptdelete = preproc.hard_points.hptdelete
    se = preproc.superelements.se
    sedlist = preproc.superelements.sedlist
    selist = preproc.superelements.selist
    sesymm = preproc.superelements.sesymm
    setran = preproc.superelements.setran
    afsurf = preproc.elements.afsurf
    e = preproc.elements.e
    ecpchg = preproc.elements.ecpchg
    edele = preproc.elements.edele
    eextrude = preproc.elements.eextrude
    egen = preproc.elements.egen
    einfin = preproc.elements.einfin
    eintf = preproc.elements.eintf
    elist = preproc.elements.elist
    emid = preproc.elements.emid
    emodif = preproc.elements.emodif
    emore = preproc.elements.emore
    emtgen = preproc.elements.emtgen
    en = preproc.elements.en
    endrelease = preproc.elements.endrelease
    engen = preproc.elements.engen
    enorm = preproc.elements.enorm
    ensym = preproc.elements.ensym
    eplot = preproc.elements.eplot
    eread = preproc.elements.eread
    ereinf = preproc.elements.ereinf
    errang = preproc.elements.errang
    esurf = preproc.elements.esurf
    esym = preproc.elements.esym
    ewrite = preproc.elements.ewrite
    gcdef = preproc.elements.gcdef
    gcgen = preproc.elements.gcgen
    inistate = preproc.elements.inistate
    laylist = preproc.elements.laylist
    layplot = preproc.elements.layplot
    lfsurf = preproc.elements.lfsurf
    ndsurf = preproc.elements.ndsurf
    shsd = preproc.elements.shsd
    swadd = preproc.elements.swadd
    swdel = preproc.elements.swdel
    swgen = preproc.elements.swgen
    swlist = preproc.elements.swlist
    tshap = preproc.elements.tshap
    upgeom = preproc.elements.upgeom
    usrdof = preproc.elements.usrdof
    usrelem = preproc.elements.usrelem
    wtbcreate = preproc.elements.wtbcreate
    center = preproc.nodes.center
    fill = preproc.nodes.fill
    move = preproc.nodes.move
    n = preproc.nodes.n
    naxis = preproc.nodes.naxis
    nang = preproc.nodes.nang
    ndele = preproc.nodes.ndele
    ndist = preproc.nodes.ndist
    ngen = preproc.nodes.ngen
    nkpt = preproc.nodes.nkpt
    nlist = preproc.nodes.nlist
    nmodif = preproc.nodes.nmodif
    nora = preproc.nodes.nora
    norl = preproc.nodes.norl
    nplot = preproc.nodes.nplot
    nread = preproc.nodes.nread
    nrotat = preproc.nodes.nrotat
    nrrang = preproc.nodes.nrrang
    nscale = preproc.nodes.nscale
    nsmooth = preproc.nodes.nsmooth
    nsym = preproc.nodes.nsym
    nwrite = preproc.nodes.nwrite
    quad = preproc.nodes.quad
    transfer = preproc.nodes.transfer


    # APDL commands
    cfclos = apdl.macro_files.cfclos
    cfopen = apdl.macro_files.cfopen
    cfwrite = apdl.macro_files.cfwrite
    create = apdl.macro_files.create
    dflab = apdl.macro_files.dflab
    end = apdl.macro_files.end
    mkdir = apdl.macro_files.mkdir
    msg = apdl.macro_files.msg
    pmacro = apdl.macro_files.pmacro
    psearch = apdl.macro_files.psearch
    rmdir = apdl.macro_files.rmdir
    tee = apdl.macro_files.tee
    ulib = apdl.macro_files.ulib
    use = apdl.macro_files.use
    mfouri = apdl.array_parm.mfouri
    mfun = apdl.array_parm.mfun
    moper = apdl.array_parm.moper
    mwrite = apdl.array_parm.mwrite
    sread = apdl.array_parm.sread
    toper = apdl.array_parm.toper
    vabs = apdl.array_parm.vabs
    vcol = apdl.array_parm.vcol
    vcum = apdl.array_parm.vcum
    vfact = apdl.array_parm.vfact
    vfun = apdl.array_parm.vfun
    vitrp = apdl.array_parm.vitrp
    vlen = apdl.array_parm.vlen
    vmask = apdl.array_parm.vmask
    voper = apdl.array_parm.voper
    starvput = apdl.array_parm.starvput
    vscfun = apdl.array_parm.vscfun
    vstat = apdl.array_parm.vstat
    vwrite = apdl.array_parm.vwrite
    afun = apdl.parameter_definition.afun
    dim = apdl.parameter_definition.dim
    get = apdl.parameter_definition.get
    inquire = apdl.parameter_definition.inquire
    parres = apdl.parameter_definition.parres
    parsav = apdl.parameter_definition.parsav
    starset = apdl.parameter_definition.starset
    taxis = apdl.parameter_definition.taxis
    tread = apdl.parameter_definition.tread
    vfill = apdl.parameter_definition.vfill
    starvget = apdl.parameter_definition.starvget
    vread = apdl.parameter_definition.vread
    abbr = apdl.abbreviations.abbr
    abbres = apdl.abbreviations.abbres
    abbsav = apdl.abbreviations.abbsav
    ucmd = apdl.abbreviations.ucmd
    axpy = apdl.matrix_op.axpy
    comp = apdl.matrix_op.comp
    dmat = apdl.matrix_op.dmat
    dot = apdl.matrix_op.dot
    eigen = apdl.matrix_op.eigen
    export = apdl.matrix_op.export
    fft = apdl.matrix_op.fft
    free = apdl.matrix_op.free
    init = apdl.matrix_op.init
    itengine = apdl.matrix_op.itengine
    lsbac = apdl.matrix_op.lsbac
    lsdump = apdl.matrix_op.lsdump
    lsengine = apdl.matrix_op.lsengine
    lsfactor = apdl.matrix_op.lsfactor
    lsrestore = apdl.matrix_op.lsrestore
    merge = apdl.matrix_op.merge
    mult = apdl.matrix_op.mult
    nrm = apdl.matrix_op.nrm
    remove = apdl.matrix_op.remove
    scal = apdl.matrix_op.scal
    smat = apdl.matrix_op.smat
    starprint = apdl.matrix_op.starprint
    sort = apdl.matrix_op.sort
    vec = apdl.matrix_op.vec
    wrk = apdl.matrix_op.wrk
    wait = apdl.process_controls.wait

    # post26
    cvar = post26_.special.cvar
    pmgtran = post26_.special.pmgtran
    rcyc = post26_.special.rcyc
    resp = post26_.special.resp
    rpsd = post26_.special.rpsd
    smooth = post26_.special.smooth
    vput = post26_.special.vput
    vget = post26_.special.vget
    ansol = post26_.setup.ansol
    cisol = post26_.setup.cisol
    data = post26_.setup.data
    edread = post26_.setup.edread
    enersol = post26_.setup.enersol
    esol = post26_.setup.esol
    file = post26_.setup.file
    gapf = post26_.setup.gapf
    gssol = post26_.setup.gssol
    jsol = post26_.setup.jsol
    nsol = post26_.setup.nsol
    nstore = post26_.setup.nstore
    numvar = post26_.setup.numvar
    reset = post26_.setup.reset
    rforce = post26_.setup.rforce
    rgb = post26_.setup.rgb
    solu = post26_.setup.solu
    store = post26_.setup.store
    timerange = post26_.setup.timerange
    vardel = post26_.setup.vardel
    varnam = post26_.setup.varnam
    define = post26_.status.define
    operate = post26_.status.operate
    plotting = post26_.status.plotting
    print = post26_.status.print
    extrem = post26_.listing.extrem
    lines = post26_.listing.lines
    nprint = post26_.listing.nprint
    prcplx = post26_.listing.prcplx
    prtime = post26_.listing.prtime
    prvar = post26_.listing.prvar
    keep = post26_.display.keep
    plcplx = post26_.display.plcplx
    pltime = post26_.display.pltime
    plvar = post26_.display.plvar
    spread = post26_.display.spread
    xvar = post26_.display.xvar
    cfact = post26_.controls.cfact
    force = post26_.controls.force
    layerp26 = post26_.controls.layerp26
    shell = post26_.controls.shell
    tvar = post26_.controls.tvar
    abs = post26_.operations.abs
    add = post26_.operations.add
    atan = post26_.operations.atan
    clog = post26_.operations.clog
    conjug = post26_.operations.conjug
    deriv = post26_.operations.deriv
    exp = post26_.operations.exp
    filldata = post26_.operations.filldata
    imagin = post26_.operations.imagin
    int1 = post26_.operations.int1
    large = post26_.operations.large
    nlog = post26_.operations.nlog
    prod = post26_.operations.prod
    quot = post26_.operations.quot
    realvar = post26_.operations.realvar
    small = post26_.operations.small
    sqrt = post26_.operations.sqrt

    # post1
    curr2d = post1_.magnetics_calc.curr2d
    emagerr = post1_.magnetics_calc.emagerr
    emf = post1_.magnetics_calc.emf
    emft = post1_.magnetics_calc.emft
    fluxv = post1_.magnetics_calc.fluxv
    mmf = post1_.magnetics_calc.mmf
    plf2d = post1_.magnetics_calc.plf2d
    powerh = post1_.magnetics_calc.powerh
    senergy = post1_.magnetics_calc.senergy
    lcabs = post1_.load_case.lcabs
    lcase = post1_.load_case.lcase
    lcdef = post1_.load_case.lcdef
    lcfact = post1_.load_case.lcfact
    lcfile = post1_.load_case.lcfile
    lcoper = post1_.load_case.lcoper
    lcsel = post1_.load_case.lcsel
    lcsum = post1_.load_case.lcsum
    lcwrite = post1_.load_case.lcwrite
    lczero = post1_.load_case.lczero
    rappnd = post1_.load_case.rappnd
    nsort = post1_.results.nsort
    nusort = post1_.results.nusort
    plcint = post1_.results.plcint
    pldisp = post1_.results.pldisp
    plesol = post1_.results.plesol
    plnsol = post1_.results.plnsol
    plorb = post1_.results.plorb
    prenergy = post1_.results.prenergy
    prorb = post1_.results.prorb
    plvect = post1_.results.plvect
    prcint = post1_.results.prcint
    presol = post1_.results.presol
    prjsol = post1_.results.prjsol
    prnld = post1_.results.prnld
    prnsol = post1_.results.prnsol
    prrfor = post1_.results.prrfor
    prrsol = post1_.results.prrsol
    prvect = post1_.results.prvect
    sumtype = post1_.results.sumtype
    bfint = post1_.special.bfint
    cbdof = post1_.special.cbdof
    cmsfile = post1_.special.cmsfile
    cyccalc = post1_.special.cyccalc
    cycfiles = post1_.special.cycfiles
    cycphase = post1_.special.cycphase
    cycspec = post1_.special.cycspec
    exoption = post1_.special.exoption
    expand = post1_.special.expand
    exprofile = post1_.special.exprofile
    exunit = post1_.special.exunit
    fssparm = post1_.special.fssparm
    fsum = post1_.special.fsum
    hfang = post1_.special.hfang
    hfsym = post1_.special.hfsym
    intsrf = post1_.special.intsrf
    kcalc = post1_.special.kcalc
    nforce = post1_.special.nforce
    nldpost = post1_.special.nldpost
    plcamp = post1_.special.plcamp
    plcfreq = post1_.special.plcfreq
    plchist = post1_.special.plchist
    plfar = post1_.special.plfar
    plmc = post1_.special.plmc
    plnear = post1_.special.plnear
    plzz = post1_.special.plzz
    pras = post1_.special.pras
    prcamp = post1_.special.prcamp
    prfar = post1_.special.prfar
    prnear = post1_.special.prnear
    reswrite = post1_.special.reswrite
    rmflvec = post1_.special.rmflvec
    rsplit = post1_.special.rsplit
    rstmac = post1_.special.rstmac
    spoint = post1_.special.spoint
    spmwrite = post1_.special.spmwrite
    append = post1_.setup.append
    desol = post1_.setup.desol
    dnsol = post1_.setup.dnsol
    hrcplx = post1_.setup.hrcplx
    rescombine = post1_.setup.rescombine
    set = post1_.setup.set
    subset = post1_.setup.subset
    pltrac = post1_.trace_points.pltrac
    trpdel = post1_.trace_points.trpdel
    trplis = post1_.trace_points.trplis
    trpoin = post1_.trace_points.trpoin
    padele = post1_.path_operations.padele
    paget = post1_.path_operations.paget
    paput = post1_.path_operations.paput
    paresu = post1_.path_operations.paresu
    pasave = post1_.path_operations.pasave
    path = post1_.path_operations.path
    pcalc = post1_.path_operations.pcalc
    pcross = post1_.path_operations.pcross
    pdef = post1_.path_operations.pdef
    pdot = post1_.path_operations.pdot
    plpagm = post1_.path_operations.plpagm
    plpath = post1_.path_operations.plpath
    plsect = post1_.path_operations.plsect
    pmap = post1_.path_operations.pmap
    ppath = post1_.path_operations.ppath
    prange = post1_.path_operations.prange
    prpath = post1_.path_operations.prpath
    prsect = post1_.path_operations.prsect
    psel = post1_.path_operations.psel
    pvect = post1_.path_operations.pvect
    detab = post1_.element_table.detab
    esort = post1_.element_table.esort
    etable = post1_.element_table.etable
    eusort = post1_.element_table.eusort
    pletab = post1_.element_table.pletab
    plls = post1_.element_table.plls
    pretab = post1_.element_table.pretab
    sabs = post1_.element_table.sabs
    sadd = post1_.element_table.sadd
    sallow = post1_.element_table.sallow
    sexp = post1_.element_table.sexp
    sfact = post1_.element_table.sfact
    sfcalc = post1_.element_table.sfcalc
    smax = post1_.element_table.smax
    smin = post1_.element_table.smin
    smult = post1_.element_table.smult
    ssum = post1_.element_table.ssum
    tallow = post1_.element_table.tallow
    vcross = post1_.element_table.vcross
    vdot = post1_.element_table.vdot
    ancntr = post1_.animation.ancntr
    ancut = post1_.animation.ancut
    andata = post1_.animation.andata
    andscl = post1_.animation.andscl
    ancyc = post1_.animation.ancyc
    andyna = post1_.animation.andyna
    anfile = post1_.animation.anfile
    anflow = post1_.animation.anflow
    anharm = post1_.animation.anharm
    anim = post1_.animation.anim
    anisos = post1_.animation.anisos
    anmode = post1_.animation.anmode
    anmres = post1_.animation.anmres
    antime = post1_.animation.antime
    trtime = post1_.animation.trtime
    calc = post1_.status.calc
    datadef = post1_.status.datadef
    display = post1_.status.display
    lccalc = post1_.status.lccalc
    point = post1_.status.point
    spec = post1_.status.spec
    format = post1_.listing.format
    header = post1_.listing.header
    irlist = post1_.listing.irlist
    page = post1_.listing.page
    prerr = post1_.listing.prerr
    priter = post1_.listing.priter
    sucalc = post1_.surface_operations.sucalc
    sucr = post1_.surface_operations.sucr
    sudel = post1_.surface_operations.sudel
    sueval = post1_.surface_operations.sueval
    suget = post1_.surface_operations.suget
    sumap = post1_.surface_operations.sumap
    supl = post1_.surface_operations.supl
    supr = post1_.surface_operations.supr
    suresu = post1_.surface_operations.suresu
    susave = post1_.surface_operations.susave
    susel = post1_.surface_operations.susel
    suvect = post1_.surface_operations.suvect
    avprin = post1_.controls.avprin
    avres = post1_.controls.avres
    efacet = post1_.controls.efacet
    ernorm = post1_.controls.ernorm
    inres = post1_.controls.inres
    layer = post1_.controls.layer
    rsys = post1_.controls.rsys
    fc = post1_.failure_criteria.fc
    fccheck = post1_.failure_criteria.fccheck
    fcdele = post1_.failure_criteria.fcdele
    fclist = post1_.failure_criteria.fclist
    fctyp = post1_.failure_criteria.fctyp

    # solution
    gp = solution.gap_conditions.gp
    gpdele = solution.gap_conditions.gpdele
    gplist = solution.gap_conditions.gplist
    f = solution.fe_forces.f
    fcum = solution.fe_forces.fcum
    fdele = solution.fe_forces.fdele
    fj = solution.fe_forces.fj
    fjdele = solution.fe_forces.fjdele
    fjlist = solution.fe_forces.fjlist
    flist = solution.fe_forces.flist
    fscale = solution.fe_forces.fscale
    fssect = solution.fe_forces.fssect
    map2dto3d = solution.twod_to_3d_analysis.map2dto3d
    mfconv = solution.multi_field_solver_convergence_controls.mfconv
    mfiter = solution.multi_field_solver_convergence_controls.mfiter
    mfrelax = solution.multi_field_solver_convergence_controls.mfrelax
    m = solution.master_dof.m
    mdele = solution.master_dof.mdele
    mgen = solution.master_dof.mgen
    mlist = solution.master_dof.mlist
    bf = solution.fe_body_loads.bf
    bfcum = solution.fe_body_loads.bfcum
    bfdele = solution.fe_body_loads.bfdele
    bfe = solution.fe_body_loads.bfe
    bfecum = solution.fe_body_loads.bfecum
    bfedele = solution.fe_body_loads.bfedele
    bfelist = solution.fe_body_loads.bfelist
    bfescal = solution.fe_body_loads.bfescal
    bflist = solution.fe_body_loads.bflist
    bfscale = solution.fe_body_loads.bfscale
    bfunif = solution.fe_body_loads.bfunif
    ldread = solution.fe_body_loads.ldread
    rimport = solution.fe_body_loads.rimport
    tunif = solution.fe_body_loads.tunif
    abextract = solution.analysis_options.abextract
    accoption = solution.analysis_options.accoption
    adams = solution.analysis_options.adams
    antype = solution.analysis_options.antype
    ascres = solution.analysis_options.ascres
    asol = solution.analysis_options.asol
    bcsoption = solution.analysis_options.bcsoption
    cgrow = solution.analysis_options.cgrow
    cmatrix = solution.analysis_options.cmatrix
    cmsopt = solution.analysis_options.cmsopt
    cncheck = solution.analysis_options.cncheck
    cnkmod = solution.analysis_options.cnkmod
    cntr = solution.analysis_options.cntr
    cutcontrol = solution.analysis_options.cutcontrol
    ddoption = solution.analysis_options.ddoption
    dmpext = solution.analysis_options.dmpext
    dmpoption = solution.analysis_options.dmpoption
    dspoption = solution.analysis_options.dspoption
    exbopt = solution.analysis_options.exbopt
    ematwrite = solution.analysis_options.ematwrite
    eqslv = solution.analysis_options.eqslv
    eresx = solution.analysis_options.eresx
    escheck = solution.analysis_options.escheck
    essolv = solution.analysis_options.essolv
    expass = solution.analysis_options.expass
    gauge = solution.analysis_options.gauge
    gmatrix = solution.analysis_options.gmatrix
    lanboption = solution.analysis_options.lanboption
    lumpm = solution.analysis_options.lumpm
    moddir = solution.analysis_options.moddir
    monitor = solution.analysis_options.monitor
    msave = solution.analysis_options.msave
    msolve = solution.analysis_options.msolve
    opncontrol = solution.analysis_options.opncontrol
    outaero = solution.analysis_options.outaero
    ovcheck = solution.analysis_options.ovcheck
    pcgopt = solution.analysis_options.pcgopt
    perturb = solution.analysis_options.perturb
    prscontrol = solution.analysis_options.prscontrol
    pscontrol = solution.analysis_options.pscontrol
    rate = solution.analysis_options.rate
    resvec = solution.analysis_options.resvec
    rstoff = solution.analysis_options.rstoff
    scopt = solution.analysis_options.scopt
    seexp = solution.analysis_options.seexp
    seopt = solution.analysis_options.seopt
    snoption = solution.analysis_options.snoption
    solve = solution.analysis_options.solve
    stabilize = solution.analysis_options.stabilize
    thexpand = solution.analysis_options.thexpand
    thopt = solution.analysis_options.thopt
    rdec = solution.radiosity.rdec
    rsopt = solution.radiosity.rsopt
    rsurf = solution.radiosity.rsurf
    rsymm = solution.radiosity.rsymm
    qsopt = solution.radiosity.qsopt
    ealive = solution.birth_and_death.ealive
    ekill = solution.birth_and_death.ekill
    estif = solution.birth_and_death.estif
    anpres = solution.miscellaneous_loads.anpres
    aport = solution.miscellaneous_loads.aport
    asifile = solution.miscellaneous_loads.asifile
    awave = solution.miscellaneous_loads.awave
    biot = solution.miscellaneous_loads.biot
    dfswave = solution.miscellaneous_loads.dfswave
    fluread = solution.miscellaneous_loads.fluread
    ic = solution.miscellaneous_loads.ic
    icdele = solution.miscellaneous_loads.icdele
    iclist = solution.miscellaneous_loads.iclist
    icrotate = solution.miscellaneous_loads.icrotate
    mpchg = solution.miscellaneous_loads.mpchg
    mrpm = solution.miscellaneous_loads.mrpm
    outpr = solution.miscellaneous_loads.outpr
    outres = solution.miscellaneous_loads.outres
    rescontrol = solution.miscellaneous_loads.rescontrol
    sbclist = solution.miscellaneous_loads.sbclist
    sbctran = solution.miscellaneous_loads.sbctran
    wsprings = solution.miscellaneous_loads.wsprings
    mfcalc = solution.multi_field_solver_time_controls.mfcalc
    mfdtime = solution.multi_field_solver_time_controls.mfdtime
    mfoutput = solution.multi_field_solver_time_controls.mfoutput
    mfrstart = solution.multi_field_solver_time_controls.mfrstart
    mftime = solution.multi_field_solver_time_controls.mftime
    lsclear = solution.load_step_operations.lsclear
    lsdele = solution.load_step_operations.lsdele
    lsread = solution.load_step_operations.lsread
    lssolve = solution.load_step_operations.lssolve
    lswrite = solution.load_step_operations.lswrite
    alphad = solution.dynamic_options.alphad
    betad = solution.dynamic_options.betad
    dmprat = solution.dynamic_options.dmprat
    dmpstr = solution.dynamic_options.dmpstr
    frqscl = solution.dynamic_options.frqscl
    harfrq = solution.dynamic_options.harfrq
    hrexp = solution.dynamic_options.hrexp
    hrocean = solution.dynamic_options.hrocean
    hropt = solution.dynamic_options.hropt
    hrout = solution.dynamic_options.hrout
    lvscale = solution.dynamic_options.lvscale
    mascale = solution.dynamic_options.mascale
    mdamp = solution.dynamic_options.mdamp
    mdplot = solution.dynamic_options.mdplot
    midtol = solution.dynamic_options.midtol
    modcont = solution.dynamic_options.modcont
    modseloption = solution.dynamic_options.modseloption
    modopt = solution.dynamic_options.modopt
    mxpand = solution.dynamic_options.mxpand
    qrdopt = solution.dynamic_options.qrdopt
    rigid = solution.dynamic_options.rigid
    subopt = solution.dynamic_options.subopt
    timint = solution.dynamic_options.timint
    tintp = solution.dynamic_options.tintp
    trnopt = solution.dynamic_options.trnopt
    da = solution.solid_constraints.da
    dadele = solution.solid_constraints.dadele
    dalist = solution.solid_constraints.dalist
    dk = solution.solid_constraints.dk
    dkdele = solution.solid_constraints.dkdele
    dklist = solution.solid_constraints.dklist
    dl = solution.solid_constraints.dl
    dldele = solution.solid_constraints.dldele
    dllist = solution.solid_constraints.dllist
    dtran = solution.solid_constraints.dtran
    addam = solution.spectrum_options.addam
    coval = solution.spectrum_options.coval
    cqc = solution.spectrum_options.cqc
    ddaspec = solution.spectrum_options.ddaspec
    dsum = solution.spectrum_options.dsum
    freq = solution.spectrum_options.freq
    grp = solution.spectrum_options.grp
    mmass = solution.spectrum_options.mmass
    nrlsum = solution.spectrum_options.nrlsum
    pfact = solution.spectrum_options.pfact
    pivcheck = solution.spectrum_options.pivcheck
    psdcom = solution.spectrum_options.psdcom
    psdfrq = solution.spectrum_options.psdfrq
    psdgraph = solution.spectrum_options.psdgraph
    psdres = solution.spectrum_options.psdres
    psdspl = solution.spectrum_options.psdspl
    psdunit = solution.spectrum_options.psdunit
    psdval = solution.spectrum_options.psdval
    psdwav = solution.spectrum_options.psdwav
    qdval = solution.spectrum_options.qdval
    rock = solution.spectrum_options.rock
    rose = solution.spectrum_options.rose
    rigresp = solution.spectrum_options.rigresp
    sed = solution.spectrum_options.sed
    spdamp = solution.spectrum_options.spdamp
    spfreq = solution.spectrum_options.spfreq
    spgraph = solution.spectrum_options.spgraph
    spopt = solution.spectrum_options.spopt
    spunit = solution.spectrum_options.spunit
    spval = solution.spectrum_options.spval
    srss = solution.spectrum_options.srss
    sv = solution.spectrum_options.sv
    svplot = solution.spectrum_options.svplot
    svtyp = solution.spectrum_options.svtyp
    vddam = solution.spectrum_options.vddam
    mfbucket = solution.multi_field_solver_interface_mapping.mfbucket
    mfci = solution.multi_field_solver_interface_mapping.mfci
    mfmap = solution.multi_field_solver_interface_mapping.mfmap
    mftol = solution.multi_field_solver_interface_mapping.mftol
    sf = solution.fe_surface_loads.sf
    sfbeam = solution.fe_surface_loads.sfbeam
    sfcum = solution.fe_surface_loads.sfcum
    sfdele = solution.fe_surface_loads.sfdele
    sfe = solution.fe_surface_loads.sfe
    sfedele = solution.fe_surface_loads.sfedele
    sfelist = solution.fe_surface_loads.sfelist
    sffun = solution.fe_surface_loads.sffun
    sfgrad = solution.fe_surface_loads.sfgrad
    sflist = solution.fe_surface_loads.sflist
    sfscale = solution.fe_surface_loads.sfscale
    autots = solution.load_step_options.autots
    campbell = solution.load_step_options.campbell
    cecmod = solution.load_step_options.cecmod
    deltim = solution.load_step_options.deltim
    expsol = solution.load_step_options.expsol
    kbc = solution.load_step_options.kbc
    kuse = solution.load_step_options.kuse
    magopt = solution.load_step_options.magopt
    magsolv = solution.load_step_options.magsolv
    mode = solution.load_step_options.mode
    nsubst = solution.load_step_options.nsubst
    numexp = solution.load_step_options.numexp
    time = solution.load_step_options.time
    tref = solution.load_step_options.tref
    tsres = solution.load_step_options.tsres
    upcoord = solution.load_step_options.upcoord
    usrcal = solution.load_step_options.usrcal
    wrfull = solution.load_step_options.wrfull
    acel = solution.inertia.acel
    cgloc = solution.inertia.cgloc
    cgomga = solution.inertia.cgomga
    cmacel = solution.inertia.cmacel
    cmdomega = solution.inertia.cmdomega
    cmomega = solution.inertia.cmomega
    cmrotate = solution.inertia.cmrotate
    coriolis = solution.inertia.coriolis
    dcgomg = solution.inertia.dcgomg
    domega = solution.inertia.domega
    irlf = solution.inertia.irlf
    omega = solution.inertia.omega
    synchro = solution.inertia.synchro
    mfcmmand = solution.multi_field_solver_definition_commands.mfcmmand
    mfelem = solution.multi_field_solver_definition_commands.mfelem
    mfem = solution.multi_field_solver_definition_commands.mfem
    mfexter = solution.multi_field_solver_definition_commands.mfexter
    mffname = solution.multi_field_solver_definition_commands.mffname
    arclen = solution.nonlinear_options.arclen
    arctrm = solution.nonlinear_options.arctrm
    bucopt = solution.nonlinear_options.bucopt
    cnvtol = solution.nonlinear_options.cnvtol
    crplim = solution.nonlinear_options.crplim
    gst = solution.nonlinear_options.gst
    lnsrch = solution.nonlinear_options.lnsrch
    ncnv = solution.nonlinear_options.ncnv
    neqit = solution.nonlinear_options.neqit
    nladaptive = solution.nonlinear_options.nladaptive
    nldiag = solution.nonlinear_options.nldiag
    nlgeom = solution.nonlinear_options.nlgeom
    nlhist = solution.nonlinear_options.nlhist
    nlmesh = solution.nonlinear_options.nlmesh
    nropt = solution.nonlinear_options.nropt
    pred = solution.nonlinear_options.pred
    pstres = solution.nonlinear_options.pstres
    bfa = solution.solid_body_loads.bfa
    bfadele = solution.solid_body_loads.bfadele
    bfalist = solution.solid_body_loads.bfalist
    bfk = solution.solid_body_loads.bfk
    bfkdele = solution.solid_body_loads.bfkdele
    bfklist = solution.solid_body_loads.bfklist
    bfl = solution.solid_body_loads.bfl
    bfldele = solution.solid_body_loads.bfldele
    bfllist = solution.solid_body_loads.bfllist
    bftran = solution.solid_body_loads.bftran
    bfv = solution.solid_body_loads.bfv
    bfvdele = solution.solid_body_loads.bfvdele
    bfvlist = solution.solid_body_loads.bfvlist
    fk = solution.solid_forces.fk
    fkdele = solution.solid_forces.fkdele
    fklist = solution.solid_forces.fklist
    ftran = solution.solid_forces.ftran
    sfa = solution.solid_surface_loads.sfa
    sfadele = solution.solid_surface_loads.sfadele
    sfalist = solution.solid_surface_loads.sfalist
    sfl = solution.solid_surface_loads.sfl
    sfldele = solution.solid_surface_loads.sfldele
    sfllist = solution.solid_surface_loads.sfllist
    sftran = solution.solid_surface_loads.sftran
    d = solution.fe_constraints.d
    dcum = solution.fe_constraints.dcum
    ddele = solution.fe_constraints.ddele
    dflx = solution.fe_constraints.dflx
    dj = solution.fe_constraints.dj
    djdele = solution.fe_constraints.djdele
    djlist = solution.fe_constraints.djlist
    dlist = solution.fe_constraints.dlist
    dscale = solution.fe_constraints.dscale
    dsym = solution.fe_constraints.dsym
    dval = solution.fe_constraints.dval
    gsbdata = solution.fe_constraints.gsbdata
    gslist = solution.fe_constraints.gslist
    rezone = solution.rezoning.rezone
    mapsolve = solution.rezoning.mapsolve
    mapvar = solution.rezoning.mapvar
    remesh = solution.rezoning.remesh
    aremesh = solution.rezoning.aremesh
    mfanalysis = solution.multi_field_solver_global_controls.mfanalysis
    mfclear = solution.multi_field_solver_global_controls.mfclear
    mffr = solution.multi_field_solver_global_controls.mffr
    mfinter = solution.multi_field_solver_global_controls.mfinter
    mflist = solution.multi_field_solver_global_controls.mflist
    mforder = solution.multi_field_solver_global_controls.mforder
    mfpsimul = solution.multi_field_solver_global_controls.mfpsimul
    mfsorder = solution.multi_field_solver_global_controls.mfsorder
    mfwrite = solution.multi_field_solver_global_controls.mfwrite
    ocdata = solution.ocean.ocdata
    ocdelete = solution.ocean.ocdelete
    oclist = solution.ocean.oclist
    ocread = solution.ocean.ocread
    octable = solution.ocean.octable
    octype = solution.ocean.octype
    oczone = solution.ocean.oczone
    atype = solution.solution_status.atype
    bioopt = solution.solution_status.bioopt
    deact = solution.solution_status.deact
    dynopt = solution.solution_status.dynopt
    gap = solution.solution_status.gap
    genopt = solution.solution_status.genopt
    inrtia = solution.solution_status.inrtia
    lsoper = solution.solution_status.lsoper
    master = solution.solution_status.master
    nlopt = solution.solution_status.nlopt
    outopt = solution.solution_status.outopt
    smbody = solution.solution_status.smbody
    smcons = solution.solution_status.smcons
    smfor = solution.solution_status.smfor
    smsurf = solution.solution_status.smsurf
    soluopt = solution.solution_status.soluopt
    sptopt = solution.solution_status.sptopt
    mflcomm = solution.multi_field_solver_load_transfer.mflcomm
    mfsurface = solution.multi_field_solver_load_transfer.mfsurface
    mfvolume = solution.multi_field_solver_load_transfer.mfvolume

    # graphics
    an3d = graphics_.annotation.an3d
    annot = graphics_.annotation.annot
    anum = graphics_.annotation.anum
    lspec = graphics_.annotation.lspec
    lsymbol = graphics_.annotation.lsymbol
    pcircle = graphics_.annotation.pcircle
    pmore = graphics_.annotation.pmore
    polygon = graphics_.annotation.polygon
    pspec = graphics_.annotation.pspec
    pwedge = graphics_.annotation.pwedge
    tlabel = graphics_.annotation.tlabel
    tspec = graphics_.annotation.tspec
    axlab = graphics_.graphs.axlab
    grid = graphics_.graphs.grid
    gropt = graphics_.graphs.gropt
    grtyp = graphics_.graphs.grtyp
    gthk = graphics_.graphs.gthk
    xrange = graphics_.graphs.xrange
    yrange = graphics_.graphs.yrange
    color = graphics_.setup.color
    device = graphics_.setup.device
    dsys = graphics_.setup.dsys
    dv3d = graphics_.setup.dv3d
    gcmd = graphics_.setup.gcmd
    gcolumn = graphics_.setup.gcolumn
    gfile = graphics_.setup.gfile
    gplot = graphics_.setup.gplot
    graphics = graphics_.setup.graphics
    gresume = graphics_.setup.gresume
    gsave = graphics_.setup.gsave
    gtype = graphics_.setup.gtype
    image = graphics_.setup.image
    jpeg = graphics_.setup.jpeg
    mrep = graphics_.setup.mrep
    pcopy = graphics_.setup.pcopy
    pngr = graphics_.setup.pngr
    pscr = graphics_.setup.pscr
    pstatus = graphics_.setup.pstatus
    replot = graphics_.setup.replot
    slashreset = graphics_.setup.slashreset
    seg = graphics_.setup.seg
    show = graphics_.setup.show
    tiff = graphics_.setup.tiff
    window = graphics_.setup.window
    cformat = graphics_.labeling.cformat
    clabel = graphics_.labeling.clabel
    contour = graphics_.labeling.contour
    cval = graphics_.labeling.cval
    gformat = graphics_.labeling.gformat
    hbc = graphics_.labeling.hbc
    number = graphics_.labeling.number
    pbc = graphics_.labeling.pbc
    pbf = graphics_.labeling.pbf
    plopts = graphics_.labeling.plopts
    pnum = graphics_.labeling.pnum
    psf = graphics_.labeling.psf
    psymb = graphics_.labeling.psymb
    triad = graphics_.labeling.triad
    udoc = graphics_.labeling.udoc
    cplane = graphics_.style.cplane
    ctype = graphics_.style.ctype
    edge = graphics_.style.edge
    eshape = graphics_.style.eshape
    facet = graphics_.style.facet
    gline = graphics_.style.gline
    gmarker = graphics_.style.gmarker
    gmface = graphics_.style.gmface
    light = graphics_.style.light
    normal = graphics_.style.normal
    shade = graphics_.style.shade
    trlcy = graphics_.style.trlcy
    iclwid = graphics_.scaling.iclwid
    icscale = graphics_.scaling.icscale
    ratio = graphics_.scaling.ratio
    shrink = graphics_.scaling.shrink
    sscale = graphics_.scaling.sscale
    txtre = graphics_.scaling.txtre
    vscale = graphics_.scaling.vscale
    angle = graphics_.views.angle
    auto = graphics_.views.auto
    dist = graphics_.views.dist
    focus = graphics_.views.focus
    user = graphics_.views.user
    vcone = graphics_.views.vcone
    view = graphics_.views.view
    vup = graphics_.views.vup
    xfrm = graphics_.views.xfrm
    zoom = graphics_.views.zoom

    cmap = display_.setup.cmap
    devdisp = display_.setup.devdisp
    filedisp = display_.setup.filedisp
    nocolor = display_.setup.nocolor
    showdisp = display_.setup.showdisp
    trans = display_.setup.trans

    # connection
    cat5in = conn.cat5in
    catiain = conn.catiain
    parain = conn.parain
    proein = conn.proein
    satin = conn.satin
    ugin = conn.ugin

    # hidden
    _batch = hidden.batch
    _output = hidden.output
