#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 679
#define LARGE_STATE_COUNT 375
#define SYMBOL_COUNT 93
#define ALIAS_COUNT 0
#define TOKEN_COUNT 61
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 6
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 14

enum {
  sym_semicolon = 1,
  anon_sym_LBRACK = 2,
  anon_sym_RBRACK = 3,
  sym_symbol = 4,
  sym_string = 5,
  sym_any = 6,
  sym_zero = 7,
  sym_boundary = 8,
  sym_symbol_group = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_BQUOTE = 12,
  anon_sym_COMMA = 13,
  sym_colon = 14,
  sym_complement = 15,
  sym_term_complement = 16,
  sym_contains = 17,
  sym_plus = 18,
  sym_star = 19,
  sym_repeat = 20,
  sym_upper = 21,
  sym_lower = 22,
  sym_reverse = 23,
  sym_inverse = 24,
  sym_ignore = 25,
  sym_ignore_inside = 26,
  sym_union = 27,
  sym_intersect = 28,
  sym_subtract = 29,
  anon_sym__ = 30,
  anon_sym_EQ_GT = 31,
  anon_sym_DASH_GT = 32,
  anon_sym_LT_DASH = 33,
  anon_sym_LPAREN_DASH_GT_RPAREN = 34,
  anon_sym_LPAREN_LT_DASH_RPAREN = 35,
  anon_sym_AT_DASH_GT = 36,
  anon_sym_DASH_GT_AT = 37,
  anon_sym_AT_GT = 38,
  anon_sym_GT_AT = 39,
  anon_sym_LBRACK_DOT = 40,
  anon_sym_DOT_RBRACK = 41,
  anon_sym_DOT_DOT_DOT = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_SLASH_SLASH = 44,
  anon_sym_BSLASH_BSLASH = 45,
  anon_sym_BSLASH_SLASH = 46,
  anon_sym_COMMA_COMMA = 47,
  sym_crossproduct = 48,
  sym_compose = 49,
  sym_comment = 50,
  sym_multichar_symbols_header = 51,
  aux_sym_alphabet_symbol_token1 = 52,
  anon_sym_LEXICON = 53,
  sym_lexicon_start_wrong_case = 54,
  aux_sym_lexicon_token1 = 55,
  sym_gloss = 56,
  anon_sym_LT = 57,
  anon_sym_GT = 58,
  anon_sym_END = 59,
  aux_sym_end_comment_token1 = 60,
  sym_source_file = 61,
  sym_expression = 62,
  sym_optional = 63,
  sym_substitute = 64,
  sym_context = 65,
  sym_context_list = 66,
  sym_restrict = 67,
  sym_arrow = 68,
  sym_simple_replace = 69,
  sym_single_replace = 70,
  sym_mark = 71,
  sym_parallel_replace = 72,
  sym_condition_operators = 73,
  sym_conditional_replace = 74,
  sym_parallel_conditional_replace = 75,
  sym_alphabet_symbol = 76,
  sym_multichar_symbols = 77,
  sym_lexicon_start = 78,
  sym_lexicon = 79,
  sym_lexicon_line = 80,
  sym_lexicon_name = 81,
  sym_lexicon_string = 82,
  sym_regex = 83,
  sym_end_comment = 84,
  aux_sym_source_file_repeat1 = 85,
  aux_sym_optional_repeat1 = 86,
  aux_sym_substitute_repeat1 = 87,
  aux_sym_context_list_repeat1 = 88,
  aux_sym_parallel_replace_repeat1 = 89,
  aux_sym_parallel_conditional_replace_repeat1 = 90,
  aux_sym_multichar_symbols_repeat1 = 91,
  aux_sym_lexicon_repeat1 = 92,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_semicolon] = "semicolon",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_symbol] = "symbol",
  [sym_string] = "string",
  [sym_any] = "any",
  [sym_zero] = "zero",
  [sym_boundary] = "boundary",
  [sym_symbol_group] = "symbol_group",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_COMMA] = ",",
  [sym_colon] = "colon",
  [sym_complement] = "complement",
  [sym_term_complement] = "term_complement",
  [sym_contains] = "contains",
  [sym_plus] = "plus",
  [sym_star] = "star",
  [sym_repeat] = "repeat",
  [sym_upper] = "upper",
  [sym_lower] = "lower",
  [sym_reverse] = "reverse",
  [sym_inverse] = "inverse",
  [sym_ignore] = "ignore",
  [sym_ignore_inside] = "ignore_inside",
  [sym_union] = "union",
  [sym_intersect] = "intersect",
  [sym_subtract] = "subtract",
  [anon_sym__] = "_",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LPAREN_DASH_GT_RPAREN] = "(->)",
  [anon_sym_LPAREN_LT_DASH_RPAREN] = "(<-)",
  [anon_sym_AT_DASH_GT] = "@->",
  [anon_sym_DASH_GT_AT] = "->@",
  [anon_sym_AT_GT] = "@>",
  [anon_sym_GT_AT] = ">@",
  [anon_sym_LBRACK_DOT] = "[.",
  [anon_sym_DOT_RBRACK] = ".]",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_COMMA_COMMA] = ",,",
  [sym_crossproduct] = "crossproduct",
  [sym_compose] = "compose",
  [sym_comment] = "comment",
  [sym_multichar_symbols_header] = "multichar_symbols_header",
  [aux_sym_alphabet_symbol_token1] = "alphabet_symbol_token1",
  [anon_sym_LEXICON] = "LEXICON",
  [sym_lexicon_start_wrong_case] = "lexicon_start_wrong_case",
  [aux_sym_lexicon_token1] = "lexicon_token1",
  [sym_gloss] = "gloss",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_END] = "END",
  [aux_sym_end_comment_token1] = "end_comment_token1",
  [sym_source_file] = "source_file",
  [sym_expression] = "expression",
  [sym_optional] = "optional",
  [sym_substitute] = "substitute",
  [sym_context] = "context",
  [sym_context_list] = "context_list",
  [sym_restrict] = "restrict",
  [sym_arrow] = "arrow",
  [sym_simple_replace] = "simple_replace",
  [sym_single_replace] = "single_replace",
  [sym_mark] = "mark",
  [sym_parallel_replace] = "parallel_replace",
  [sym_condition_operators] = "condition_operators",
  [sym_conditional_replace] = "conditional_replace",
  [sym_parallel_conditional_replace] = "parallel_conditional_replace",
  [sym_alphabet_symbol] = "alphabet_symbol",
  [sym_multichar_symbols] = "multichar_symbols",
  [sym_lexicon_start] = "lexicon_start",
  [sym_lexicon] = "lexicon",
  [sym_lexicon_line] = "lexicon_line",
  [sym_lexicon_name] = "lexicon_name",
  [sym_lexicon_string] = "lexicon_string",
  [sym_regex] = "regex",
  [sym_end_comment] = "end_comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_optional_repeat1] = "optional_repeat1",
  [aux_sym_substitute_repeat1] = "substitute_repeat1",
  [aux_sym_context_list_repeat1] = "context_list_repeat1",
  [aux_sym_parallel_replace_repeat1] = "parallel_replace_repeat1",
  [aux_sym_parallel_conditional_replace_repeat1] = "parallel_conditional_replace_repeat1",
  [aux_sym_multichar_symbols_repeat1] = "multichar_symbols_repeat1",
  [aux_sym_lexicon_repeat1] = "lexicon_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_semicolon] = sym_semicolon,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_symbol] = sym_symbol,
  [sym_string] = sym_string,
  [sym_any] = sym_any,
  [sym_zero] = sym_zero,
  [sym_boundary] = sym_boundary,
  [sym_symbol_group] = sym_symbol_group,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_colon] = sym_colon,
  [sym_complement] = sym_complement,
  [sym_term_complement] = sym_term_complement,
  [sym_contains] = sym_contains,
  [sym_plus] = sym_plus,
  [sym_star] = sym_star,
  [sym_repeat] = sym_repeat,
  [sym_upper] = sym_upper,
  [sym_lower] = sym_lower,
  [sym_reverse] = sym_reverse,
  [sym_inverse] = sym_inverse,
  [sym_ignore] = sym_ignore,
  [sym_ignore_inside] = sym_ignore_inside,
  [sym_union] = sym_union,
  [sym_intersect] = sym_intersect,
  [sym_subtract] = sym_subtract,
  [anon_sym__] = anon_sym__,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LPAREN_DASH_GT_RPAREN] = anon_sym_LPAREN_DASH_GT_RPAREN,
  [anon_sym_LPAREN_LT_DASH_RPAREN] = anon_sym_LPAREN_LT_DASH_RPAREN,
  [anon_sym_AT_DASH_GT] = anon_sym_AT_DASH_GT,
  [anon_sym_DASH_GT_AT] = anon_sym_DASH_GT_AT,
  [anon_sym_AT_GT] = anon_sym_AT_GT,
  [anon_sym_GT_AT] = anon_sym_GT_AT,
  [anon_sym_LBRACK_DOT] = anon_sym_LBRACK_DOT,
  [anon_sym_DOT_RBRACK] = anon_sym_DOT_RBRACK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_COMMA_COMMA] = anon_sym_COMMA_COMMA,
  [sym_crossproduct] = sym_crossproduct,
  [sym_compose] = sym_compose,
  [sym_comment] = sym_comment,
  [sym_multichar_symbols_header] = sym_multichar_symbols_header,
  [aux_sym_alphabet_symbol_token1] = aux_sym_alphabet_symbol_token1,
  [anon_sym_LEXICON] = anon_sym_LEXICON,
  [sym_lexicon_start_wrong_case] = sym_lexicon_start_wrong_case,
  [aux_sym_lexicon_token1] = aux_sym_lexicon_token1,
  [sym_gloss] = sym_gloss,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_END] = anon_sym_END,
  [aux_sym_end_comment_token1] = aux_sym_end_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym_expression] = sym_expression,
  [sym_optional] = sym_optional,
  [sym_substitute] = sym_substitute,
  [sym_context] = sym_context,
  [sym_context_list] = sym_context_list,
  [sym_restrict] = sym_restrict,
  [sym_arrow] = sym_arrow,
  [sym_simple_replace] = sym_simple_replace,
  [sym_single_replace] = sym_single_replace,
  [sym_mark] = sym_mark,
  [sym_parallel_replace] = sym_parallel_replace,
  [sym_condition_operators] = sym_condition_operators,
  [sym_conditional_replace] = sym_conditional_replace,
  [sym_parallel_conditional_replace] = sym_parallel_conditional_replace,
  [sym_alphabet_symbol] = sym_alphabet_symbol,
  [sym_multichar_symbols] = sym_multichar_symbols,
  [sym_lexicon_start] = sym_lexicon_start,
  [sym_lexicon] = sym_lexicon,
  [sym_lexicon_line] = sym_lexicon_line,
  [sym_lexicon_name] = sym_lexicon_name,
  [sym_lexicon_string] = sym_lexicon_string,
  [sym_regex] = sym_regex,
  [sym_end_comment] = sym_end_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_optional_repeat1] = aux_sym_optional_repeat1,
  [aux_sym_substitute_repeat1] = aux_sym_substitute_repeat1,
  [aux_sym_context_list_repeat1] = aux_sym_context_list_repeat1,
  [aux_sym_parallel_replace_repeat1] = aux_sym_parallel_replace_repeat1,
  [aux_sym_parallel_conditional_replace_repeat1] = aux_sym_parallel_conditional_replace_repeat1,
  [aux_sym_multichar_symbols_repeat1] = aux_sym_multichar_symbols_repeat1,
  [aux_sym_lexicon_repeat1] = aux_sym_lexicon_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_semicolon] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_any] = {
    .visible = true,
    .named = true,
  },
  [sym_zero] = {
    .visible = true,
    .named = true,
  },
  [sym_boundary] = {
    .visible = true,
    .named = true,
  },
  [sym_symbol_group] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_complement] = {
    .visible = true,
    .named = true,
  },
  [sym_term_complement] = {
    .visible = true,
    .named = true,
  },
  [sym_contains] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_upper] = {
    .visible = true,
    .named = true,
  },
  [sym_lower] = {
    .visible = true,
    .named = true,
  },
  [sym_reverse] = {
    .visible = true,
    .named = true,
  },
  [sym_inverse] = {
    .visible = true,
    .named = true,
  },
  [sym_ignore] = {
    .visible = true,
    .named = true,
  },
  [sym_ignore_inside] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_intersect] = {
    .visible = true,
    .named = true,
  },
  [sym_subtract] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_GT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LT_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_crossproduct] = {
    .visible = true,
    .named = true,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_multichar_symbols_header] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_alphabet_symbol_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LEXICON] = {
    .visible = true,
    .named = false,
  },
  [sym_lexicon_start_wrong_case] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_lexicon_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_gloss] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_END] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_end_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [sym_substitute] = {
    .visible = true,
    .named = true,
  },
  [sym_context] = {
    .visible = true,
    .named = true,
  },
  [sym_context_list] = {
    .visible = true,
    .named = true,
  },
  [sym_restrict] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_single_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_operators] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_conditional_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_alphabet_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_multichar_symbols] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_start] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_line] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_name] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_string] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_end_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_optional_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_substitute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_context_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parallel_replace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parallel_conditional_replace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multichar_symbols_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lexicon_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_continuation = 1,
  field_gloss = 2,
  field_left = 3,
  field_name = 4,
  field_right = 5,
  field_whole = 6,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_continuation] = "continuation",
  [field_gloss] = "gloss",
  [field_left] = "left",
  [field_name] = "name",
  [field_right] = "right",
  [field_whole] = "whole",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 3},
  [10] = {.index = 16, .length = 3},
  [11] = {.index = 19, .length = 3},
  [12] = {.index = 22, .length = 3},
  [13] = {.index = 25, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 2},
  [1] =
    {field_continuation, 0},
  [2] =
    {field_continuation, 1},
  [3] =
    {field_continuation, 0},
    {field_gloss, 1},
  [5] =
    {field_continuation, 1},
    {field_whole, 0},
  [7] =
    {field_continuation, 1},
    {field_gloss, 2},
  [9] =
    {field_continuation, 2},
    {field_right, 1},
  [11] =
    {field_continuation, 2},
    {field_left, 0},
  [13] =
    {field_continuation, 1},
    {field_gloss, 2},
    {field_whole, 0},
  [16] =
    {field_continuation, 2},
    {field_gloss, 3},
    {field_right, 1},
  [19] =
    {field_continuation, 2},
    {field_gloss, 3},
    {field_left, 0},
  [22] =
    {field_continuation, 3},
    {field_left, 0},
    {field_right, 2},
  [25] =
    {field_continuation, 3},
    {field_gloss, 4},
    {field_left, 0},
    {field_right, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [2] = sym_lexicon_name,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 9,
  [11] = 9,
  [12] = 12,
  [13] = 13,
  [14] = 9,
  [15] = 15,
  [16] = 16,
  [17] = 13,
  [18] = 9,
  [19] = 19,
  [20] = 20,
  [21] = 16,
  [22] = 5,
  [23] = 15,
  [24] = 12,
  [25] = 6,
  [26] = 2,
  [27] = 9,
  [28] = 9,
  [29] = 9,
  [30] = 15,
  [31] = 4,
  [32] = 32,
  [33] = 8,
  [34] = 3,
  [35] = 7,
  [36] = 6,
  [37] = 5,
  [38] = 3,
  [39] = 16,
  [40] = 2,
  [41] = 13,
  [42] = 12,
  [43] = 8,
  [44] = 4,
  [45] = 7,
  [46] = 6,
  [47] = 12,
  [48] = 19,
  [49] = 49,
  [50] = 20,
  [51] = 32,
  [52] = 15,
  [53] = 20,
  [54] = 19,
  [55] = 8,
  [56] = 7,
  [57] = 32,
  [58] = 5,
  [59] = 3,
  [60] = 16,
  [61] = 2,
  [62] = 13,
  [63] = 4,
  [64] = 6,
  [65] = 16,
  [66] = 4,
  [67] = 8,
  [68] = 12,
  [69] = 13,
  [70] = 2,
  [71] = 9,
  [72] = 3,
  [73] = 9,
  [74] = 5,
  [75] = 7,
  [76] = 9,
  [77] = 49,
  [78] = 32,
  [79] = 20,
  [80] = 19,
  [81] = 15,
  [82] = 9,
  [83] = 32,
  [84] = 3,
  [85] = 6,
  [86] = 9,
  [87] = 3,
  [88] = 9,
  [89] = 16,
  [90] = 9,
  [91] = 7,
  [92] = 8,
  [93] = 6,
  [94] = 5,
  [95] = 12,
  [96] = 9,
  [97] = 5,
  [98] = 7,
  [99] = 15,
  [100] = 20,
  [101] = 2,
  [102] = 19,
  [103] = 2,
  [104] = 13,
  [105] = 9,
  [106] = 15,
  [107] = 16,
  [108] = 13,
  [109] = 12,
  [110] = 8,
  [111] = 4,
  [112] = 4,
  [113] = 2,
  [114] = 12,
  [115] = 8,
  [116] = 4,
  [117] = 32,
  [118] = 20,
  [119] = 19,
  [120] = 7,
  [121] = 6,
  [122] = 5,
  [123] = 3,
  [124] = 16,
  [125] = 49,
  [126] = 13,
  [127] = 16,
  [128] = 2,
  [129] = 13,
  [130] = 15,
  [131] = 12,
  [132] = 8,
  [133] = 5,
  [134] = 4,
  [135] = 19,
  [136] = 20,
  [137] = 32,
  [138] = 6,
  [139] = 3,
  [140] = 7,
  [141] = 13,
  [142] = 32,
  [143] = 5,
  [144] = 32,
  [145] = 20,
  [146] = 16,
  [147] = 19,
  [148] = 2,
  [149] = 12,
  [150] = 8,
  [151] = 4,
  [152] = 49,
  [153] = 7,
  [154] = 6,
  [155] = 49,
  [156] = 19,
  [157] = 3,
  [158] = 20,
  [159] = 19,
  [160] = 32,
  [161] = 16,
  [162] = 49,
  [163] = 8,
  [164] = 7,
  [165] = 4,
  [166] = 5,
  [167] = 20,
  [168] = 12,
  [169] = 13,
  [170] = 2,
  [171] = 4,
  [172] = 49,
  [173] = 8,
  [174] = 6,
  [175] = 3,
  [176] = 7,
  [177] = 5,
  [178] = 16,
  [179] = 2,
  [180] = 20,
  [181] = 13,
  [182] = 12,
  [183] = 6,
  [184] = 184,
  [185] = 12,
  [186] = 4,
  [187] = 8,
  [188] = 13,
  [189] = 2,
  [190] = 19,
  [191] = 16,
  [192] = 32,
  [193] = 5,
  [194] = 7,
  [195] = 195,
  [196] = 3,
  [197] = 49,
  [198] = 20,
  [199] = 199,
  [200] = 195,
  [201] = 201,
  [202] = 202,
  [203] = 7,
  [204] = 204,
  [205] = 202,
  [206] = 201,
  [207] = 207,
  [208] = 207,
  [209] = 202,
  [210] = 210,
  [211] = 211,
  [212] = 8,
  [213] = 207,
  [214] = 214,
  [215] = 20,
  [216] = 207,
  [217] = 4,
  [218] = 202,
  [219] = 219,
  [220] = 220,
  [221] = 219,
  [222] = 195,
  [223] = 12,
  [224] = 13,
  [225] = 2,
  [226] = 226,
  [227] = 227,
  [228] = 207,
  [229] = 207,
  [230] = 5,
  [231] = 207,
  [232] = 49,
  [233] = 32,
  [234] = 19,
  [235] = 202,
  [236] = 201,
  [237] = 214,
  [238] = 202,
  [239] = 219,
  [240] = 201,
  [241] = 202,
  [242] = 207,
  [243] = 219,
  [244] = 244,
  [245] = 202,
  [246] = 246,
  [247] = 204,
  [248] = 16,
  [249] = 195,
  [250] = 207,
  [251] = 207,
  [252] = 207,
  [253] = 253,
  [254] = 207,
  [255] = 195,
  [256] = 253,
  [257] = 244,
  [258] = 258,
  [259] = 246,
  [260] = 214,
  [261] = 227,
  [262] = 195,
  [263] = 220,
  [264] = 20,
  [265] = 244,
  [266] = 226,
  [267] = 204,
  [268] = 258,
  [269] = 258,
  [270] = 258,
  [271] = 258,
  [272] = 258,
  [273] = 273,
  [274] = 220,
  [275] = 211,
  [276] = 276,
  [277] = 195,
  [278] = 49,
  [279] = 214,
  [280] = 258,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 253,
  [285] = 258,
  [286] = 286,
  [287] = 246,
  [288] = 204,
  [289] = 289,
  [290] = 290,
  [291] = 226,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 227,
  [296] = 184,
  [297] = 246,
  [298] = 220,
  [299] = 227,
  [300] = 253,
  [301] = 246,
  [302] = 244,
  [303] = 195,
  [304] = 253,
  [305] = 214,
  [306] = 195,
  [307] = 214,
  [308] = 204,
  [309] = 246,
  [310] = 220,
  [311] = 244,
  [312] = 227,
  [313] = 226,
  [314] = 211,
  [315] = 226,
  [316] = 210,
  [317] = 204,
  [318] = 195,
  [319] = 195,
  [320] = 293,
  [321] = 227,
  [322] = 282,
  [323] = 227,
  [324] = 214,
  [325] = 294,
  [326] = 292,
  [327] = 195,
  [328] = 290,
  [329] = 246,
  [330] = 220,
  [331] = 214,
  [332] = 195,
  [333] = 246,
  [334] = 273,
  [335] = 226,
  [336] = 226,
  [337] = 211,
  [338] = 276,
  [339] = 281,
  [340] = 253,
  [341] = 286,
  [342] = 283,
  [343] = 204,
  [344] = 244,
  [345] = 289,
  [346] = 244,
  [347] = 253,
  [348] = 220,
  [349] = 204,
  [350] = 195,
  [351] = 210,
  [352] = 220,
  [353] = 244,
  [354] = 204,
  [355] = 220,
  [356] = 246,
  [357] = 211,
  [358] = 244,
  [359] = 253,
  [360] = 195,
  [361] = 214,
  [362] = 253,
  [363] = 220,
  [364] = 195,
  [365] = 195,
  [366] = 244,
  [367] = 246,
  [368] = 195,
  [369] = 227,
  [370] = 195,
  [371] = 214,
  [372] = 204,
  [373] = 195,
  [374] = 195,
  [375] = 293,
  [376] = 281,
  [377] = 273,
  [378] = 290,
  [379] = 282,
  [380] = 286,
  [381] = 276,
  [382] = 283,
  [383] = 292,
  [384] = 220,
  [385] = 220,
  [386] = 244,
  [387] = 226,
  [388] = 211,
  [389] = 204,
  [390] = 294,
  [391] = 253,
  [392] = 214,
  [393] = 289,
  [394] = 244,
  [395] = 226,
  [396] = 226,
  [397] = 226,
  [398] = 226,
  [399] = 253,
  [400] = 214,
  [401] = 204,
  [402] = 244,
  [403] = 214,
  [404] = 220,
  [405] = 204,
  [406] = 211,
  [407] = 210,
  [408] = 220,
  [409] = 244,
  [410] = 214,
  [411] = 294,
  [412] = 289,
  [413] = 253,
  [414] = 204,
  [415] = 244,
  [416] = 211,
  [417] = 276,
  [418] = 293,
  [419] = 220,
  [420] = 290,
  [421] = 273,
  [422] = 292,
  [423] = 283,
  [424] = 244,
  [425] = 220,
  [426] = 281,
  [427] = 286,
  [428] = 282,
  [429] = 429,
  [430] = 429,
  [431] = 429,
  [432] = 429,
  [433] = 429,
  [434] = 434,
  [435] = 429,
  [436] = 436,
  [437] = 429,
  [438] = 434,
  [439] = 429,
  [440] = 429,
  [441] = 434,
  [442] = 434,
  [443] = 434,
  [444] = 429,
  [445] = 434,
  [446] = 429,
  [447] = 429,
  [448] = 429,
  [449] = 434,
  [450] = 429,
  [451] = 434,
  [452] = 452,
  [453] = 453,
  [454] = 452,
  [455] = 452,
  [456] = 452,
  [457] = 452,
  [458] = 458,
  [459] = 459,
  [460] = 452,
  [461] = 453,
  [462] = 452,
  [463] = 458,
  [464] = 452,
  [465] = 458,
  [466] = 452,
  [467] = 453,
  [468] = 452,
  [469] = 452,
  [470] = 452,
  [471] = 458,
  [472] = 453,
  [473] = 473,
  [474] = 473,
  [475] = 473,
  [476] = 473,
  [477] = 473,
  [478] = 478,
  [479] = 473,
  [480] = 473,
  [481] = 473,
  [482] = 473,
  [483] = 473,
  [484] = 484,
  [485] = 473,
  [486] = 473,
  [487] = 473,
  [488] = 473,
  [489] = 473,
  [490] = 473,
  [491] = 473,
  [492] = 473,
  [493] = 473,
  [494] = 473,
  [495] = 484,
  [496] = 484,
  [497] = 473,
  [498] = 484,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 500,
  [505] = 499,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 499,
  [510] = 503,
  [511] = 508,
  [512] = 501,
  [513] = 508,
  [514] = 502,
  [515] = 502,
  [516] = 503,
  [517] = 502,
  [518] = 501,
  [519] = 508,
  [520] = 508,
  [521] = 506,
  [522] = 522,
  [523] = 501,
  [524] = 508,
  [525] = 525,
  [526] = 525,
  [527] = 501,
  [528] = 501,
  [529] = 500,
  [530] = 503,
  [531] = 525,
  [532] = 501,
  [533] = 503,
  [534] = 499,
  [535] = 507,
  [536] = 506,
  [537] = 502,
  [538] = 525,
  [539] = 501,
  [540] = 503,
  [541] = 499,
  [542] = 503,
  [543] = 502,
  [544] = 499,
  [545] = 506,
  [546] = 502,
  [547] = 500,
  [548] = 506,
  [549] = 501,
  [550] = 522,
  [551] = 522,
  [552] = 499,
  [553] = 508,
  [554] = 501,
  [555] = 502,
  [556] = 503,
  [557] = 499,
  [558] = 503,
  [559] = 499,
  [560] = 503,
  [561] = 506,
  [562] = 499,
  [563] = 502,
  [564] = 501,
  [565] = 502,
  [566] = 503,
  [567] = 499,
  [568] = 501,
  [569] = 500,
  [570] = 506,
  [571] = 525,
  [572] = 501,
  [573] = 502,
  [574] = 503,
  [575] = 499,
  [576] = 525,
  [577] = 502,
  [578] = 503,
  [579] = 499,
  [580] = 525,
  [581] = 499,
  [582] = 500,
  [583] = 507,
  [584] = 502,
  [585] = 503,
  [586] = 501,
  [587] = 502,
  [588] = 507,
  [589] = 500,
  [590] = 508,
  [591] = 525,
  [592] = 506,
  [593] = 500,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 598,
  [600] = 598,
  [601] = 598,
  [602] = 598,
  [603] = 598,
  [604] = 598,
  [605] = 598,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 631,
  [634] = 631,
  [635] = 635,
  [636] = 629,
  [637] = 637,
  [638] = 629,
  [639] = 639,
  [640] = 631,
  [641] = 629,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 654,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 654,
  [663] = 663,
  [664] = 658,
  [665] = 665,
  [666] = 654,
  [667] = 658,
  [668] = 657,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 657,
  [676] = 658,
  [677] = 657,
  [678] = 678,
};

static inline bool sym_symbol_character_set_1(int32_t c) {
  return (c < '<'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= '&' || (c < ':'
        ? (c >= '*' && c <= '/')
        : c <= ':')))
    : (c <= '<' || (c < '['
      ? (c < 'E'
        ? (c >= '>' && c <= '?')
        : c <= 'E')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_symbol_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < ')'
        ? (c >= ' ' && c <= '&')
        : c <= '/')))
    : (c <= ':' || (c < 'E'
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= 'E' || (c < '{'
        ? (c >= '[' && c <= '`')
        : c <= '~')))));
}

static inline bool sym_symbol_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_symbol_character_set_4(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : (c <= '?' || c == 'D'))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_symbol_character_set_5(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : (c <= '?' || c == 'N'))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(96);
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(112);
      if (lookahead == '0') ADVANCE(89);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(163);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == '>') ADVANCE(165);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == 'E') ADVANCE(39);
      if (lookahead == 'L') ADVANCE(37);
      if (lookahead == 'M') ADVANCE(61);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '_') ADVANCE(118);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(115);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(162);
      if (lookahead == 'E') ADVANCE(146);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == '(') ADVANCE(22);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '>') ADVANCE(34);
      if (lookahead == '@') ADVANCE(24);
      if (lookahead == 'E') ADVANCE(39);
      if (lookahead == '[') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == 'E') ADVANCE(39);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(160);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(96);
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(112);
      if (lookahead == '0') ADVANCE(89);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(165);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(115);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '}') ADVANCE(84);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(96);
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(111);
      if (lookahead == '0') ADVANCE(89);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(165);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(99);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '}') ADVANCE(84);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(96);
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(112);
      if (lookahead == '0') ADVANCE(89);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(34);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(100);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(115);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(84);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '(') ADVANCE(93);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(102);
      if (lookahead == ',') ADVANCE(96);
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(111);
      if (lookahead == '0') ADVANCE(89);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(34);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(99);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '|') ADVANCE(114);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(84);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '(') ADVANCE(92);
      if (lookahead == ')') ADVANCE(94);
      if (lookahead == '.') ADVANCE(13);
      if (lookahead == '0') ADVANCE(89);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(84);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(99);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(86);
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '(') ADVANCE(92);
      if (lookahead == '.') ADVANCE(12);
      if (lookahead == '0') ADVANCE(89);
      if (!sym_symbol_character_set_2(lookahead)) ADVANCE(84);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == 'E') ADVANCE(83);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(99);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == '`') ADVANCE(95);
      if (lookahead == '{') ADVANCE(74);
      if (lookahead == '~') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(87);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(161);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(25);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '.') ADVANCE(26);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 18:
      if (lookahead == ')') ADVANCE(123);
      END_STATE();
    case 19:
      if (lookahead == ')') ADVANCE(124);
      END_STATE();
    case 20:
      if (lookahead == ',') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(122);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '<') ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(19);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(90);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(131);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(113);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(138);
      END_STATE();
    case 29:
      if (lookahead == '.') ADVANCE(137);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(18);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 34:
      if (lookahead == '@') ADVANCE(128);
      END_STATE();
    case 35:
      if (lookahead == 'C') ADVANCE(41);
      END_STATE();
    case 36:
      if (lookahead == 'D') ADVANCE(166);
      END_STATE();
    case 37:
      if (lookahead == 'E') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'I') ADVANCE(35);
      END_STATE();
    case 39:
      if (lookahead == 'N') ADVANCE(36);
      END_STATE();
    case 40:
      if (lookahead == 'N') ADVANCE(156);
      END_STATE();
    case 41:
      if (lookahead == 'O') ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == 'S') ADVANCE(63);
      END_STATE();
    case 43:
      if (lookahead == 'X') ADVANCE(38);
      END_STATE();
    case 44:
      if (lookahead == '_') ADVANCE(42);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 46:
      if (lookahead == 'b') ADVANCE(57);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(56);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(49);
      END_STATE();
    case 49:
      if (lookahead == 'h') ADVANCE(45);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 54:
      if (lookahead == 'm') ADVANCE(46);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 59:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 62:
      if (lookahead == 'x') ADVANCE(50);
      END_STATE();
    case 63:
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 64:
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '<' ||
          lookahead == '>') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 65:
      if (lookahead == '}') ADVANCE(91);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 66:
      if (lookahead == '}') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 70:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(84);
      END_STATE();
    case 71:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(155);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(10);
      END_STATE();
    case 73:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(11);
      END_STATE();
    case 74:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(65);
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(162);
      if (lookahead == 'E') ADVANCE(146);
      if (lookahead == 'L') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(75)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != ';' &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_semicolon);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '.') ADVANCE(129);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(70);
      if (lookahead == '-') ADVANCE(33);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(84);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_4(lookahead)) ADVANCE(84);
      if (lookahead == 'D') ADVANCE(167);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_5(lookahead)) ADVANCE(84);
      if (lookahead == 'N') ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(84);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(140);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(86);
      if (sym_comment_character_set_1(lookahead)) ADVANCE(139);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_any);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_zero);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_boundary);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_symbol_group);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '-') ADVANCE(32);
      if (lookahead == '<') ADVANCE(23);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead == ',') ADVANCE(136);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_complement);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_term_complement);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_term_complement);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == '\\') ADVANCE(134);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_contains);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_repeat);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_repeat);
      if (lookahead == ',') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_repeat);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_upper);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_lower);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_reverse);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_inverse);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_ignore);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_ignore);
      if (lookahead == '/') ADVANCE(133);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_ignore_inside);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_union);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_union);
      if (lookahead == '|') ADVANCE(132);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_intersect);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_subtract);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(84);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '@') ADVANCE(126);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_GT_RPAREN);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LPAREN_LT_DASH_RPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_AT_DASH_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DASH_GT_AT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_AT_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_AT);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LBRACK_DOT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DOT_RBRACK);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_COMMA_COMMA);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_crossproduct);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(86);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_multichar_symbols_header);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'C') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'D') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'E') ADVANCE(149);
      if (lookahead == 'e') ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'I') ADVANCE(142);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'N') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'N') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'O') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'X') ADVANCE(145);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'c') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'i') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'n') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead == 'x') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_alphabet_symbol_token1);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LEXICON);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LEXICON);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_lexicon_start_wrong_case);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_lexicon_start_wrong_case);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_lexicon_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(160);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_gloss);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(122);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '@') ADVANCE(128);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_END);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_END);
      if (lookahead == '%') ADVANCE(70);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(84);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_END);
      if (lookahead == '%') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '"' < lookahead) &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>') ADVANCE(155);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_END);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_end_comment_token1);
      if (lookahead == '!') ADVANCE(139);
      if (lookahead == 'E') ADVANCE(172);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_end_comment_token1);
      if (lookahead == 'D') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_end_comment_token1);
      if (lookahead == 'N') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_end_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 4},
  [4] = {.lex_state = 4},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 4},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 4},
  [12] = {.lex_state = 4},
  [13] = {.lex_state = 4},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 4},
  [17] = {.lex_state = 4},
  [18] = {.lex_state = 4},
  [19] = {.lex_state = 4},
  [20] = {.lex_state = 4},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 4},
  [34] = {.lex_state = 4},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 4},
  [37] = {.lex_state = 4},
  [38] = {.lex_state = 4},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 4},
  [52] = {.lex_state = 4},
  [53] = {.lex_state = 4},
  [54] = {.lex_state = 4},
  [55] = {.lex_state = 4},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 4},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 4},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 6},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 6},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 6},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 6},
  [77] = {.lex_state = 4},
  [78] = {.lex_state = 4},
  [79] = {.lex_state = 4},
  [80] = {.lex_state = 4},
  [81] = {.lex_state = 6},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 6},
  [84] = {.lex_state = 6},
  [85] = {.lex_state = 6},
  [86] = {.lex_state = 6},
  [87] = {.lex_state = 6},
  [88] = {.lex_state = 6},
  [89] = {.lex_state = 6},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 6},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 6},
  [94] = {.lex_state = 6},
  [95] = {.lex_state = 6},
  [96] = {.lex_state = 6},
  [97] = {.lex_state = 6},
  [98] = {.lex_state = 6},
  [99] = {.lex_state = 6},
  [100] = {.lex_state = 6},
  [101] = {.lex_state = 6},
  [102] = {.lex_state = 6},
  [103] = {.lex_state = 6},
  [104] = {.lex_state = 6},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 6},
  [107] = {.lex_state = 6},
  [108] = {.lex_state = 6},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 6},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 6},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 6},
  [123] = {.lex_state = 6},
  [124] = {.lex_state = 6},
  [125] = {.lex_state = 6},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 5},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 6},
  [130] = {.lex_state = 6},
  [131] = {.lex_state = 6},
  [132] = {.lex_state = 6},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 6},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 6},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 6},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 6},
  [156] = {.lex_state = 6},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 6},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 5},
  [164] = {.lex_state = 5},
  [165] = {.lex_state = 5},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 7},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 7},
  [174] = {.lex_state = 7},
  [175] = {.lex_state = 7},
  [176] = {.lex_state = 7},
  [177] = {.lex_state = 7},
  [178] = {.lex_state = 7},
  [179] = {.lex_state = 7},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 7},
  [182] = {.lex_state = 7},
  [183] = {.lex_state = 7},
  [184] = {.lex_state = 4},
  [185] = {.lex_state = 7},
  [186] = {.lex_state = 7},
  [187] = {.lex_state = 7},
  [188] = {.lex_state = 7},
  [189] = {.lex_state = 7},
  [190] = {.lex_state = 7},
  [191] = {.lex_state = 7},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 7},
  [194] = {.lex_state = 7},
  [195] = {.lex_state = 4},
  [196] = {.lex_state = 7},
  [197] = {.lex_state = 7},
  [198] = {.lex_state = 7},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 4},
  [201] = {.lex_state = 5},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 7},
  [204] = {.lex_state = 4},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 5},
  [207] = {.lex_state = 7},
  [208] = {.lex_state = 7},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 4},
  [211] = {.lex_state = 4},
  [212] = {.lex_state = 7},
  [213] = {.lex_state = 7},
  [214] = {.lex_state = 4},
  [215] = {.lex_state = 7},
  [216] = {.lex_state = 7},
  [217] = {.lex_state = 7},
  [218] = {.lex_state = 5},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 4},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 7},
  [225] = {.lex_state = 7},
  [226] = {.lex_state = 4},
  [227] = {.lex_state = 4},
  [228] = {.lex_state = 7},
  [229] = {.lex_state = 7},
  [230] = {.lex_state = 7},
  [231] = {.lex_state = 7},
  [232] = {.lex_state = 7},
  [233] = {.lex_state = 7},
  [234] = {.lex_state = 7},
  [235] = {.lex_state = 5},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 5},
  [239] = {.lex_state = 5},
  [240] = {.lex_state = 5},
  [241] = {.lex_state = 5},
  [242] = {.lex_state = 7},
  [243] = {.lex_state = 5},
  [244] = {.lex_state = 4},
  [245] = {.lex_state = 5},
  [246] = {.lex_state = 4},
  [247] = {.lex_state = 4},
  [248] = {.lex_state = 7},
  [249] = {.lex_state = 4},
  [250] = {.lex_state = 7},
  [251] = {.lex_state = 7},
  [252] = {.lex_state = 7},
  [253] = {.lex_state = 4},
  [254] = {.lex_state = 7},
  [255] = {.lex_state = 4},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 4},
  [258] = {.lex_state = 5},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 4},
  [261] = {.lex_state = 4},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 7},
  [265] = {.lex_state = 4},
  [266] = {.lex_state = 4},
  [267] = {.lex_state = 4},
  [268] = {.lex_state = 5},
  [269] = {.lex_state = 5},
  [270] = {.lex_state = 5},
  [271] = {.lex_state = 5},
  [272] = {.lex_state = 5},
  [273] = {.lex_state = 4},
  [274] = {.lex_state = 4},
  [275] = {.lex_state = 4},
  [276] = {.lex_state = 4},
  [277] = {.lex_state = 4},
  [278] = {.lex_state = 7},
  [279] = {.lex_state = 4},
  [280] = {.lex_state = 5},
  [281] = {.lex_state = 4},
  [282] = {.lex_state = 4},
  [283] = {.lex_state = 4},
  [284] = {.lex_state = 4},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 4},
  [287] = {.lex_state = 4},
  [288] = {.lex_state = 4},
  [289] = {.lex_state = 4},
  [290] = {.lex_state = 4},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 4},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4},
  [302] = {.lex_state = 4},
  [303] = {.lex_state = 6},
  [304] = {.lex_state = 6},
  [305] = {.lex_state = 6},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 6},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 6},
  [313] = {.lex_state = 6},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 4},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 6},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 6},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 6},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 6},
  [328] = {.lex_state = 6},
  [329] = {.lex_state = 6},
  [330] = {.lex_state = 6},
  [331] = {.lex_state = 6},
  [332] = {.lex_state = 6},
  [333] = {.lex_state = 6},
  [334] = {.lex_state = 6},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 6},
  [337] = {.lex_state = 6},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 6},
  [340] = {.lex_state = 6},
  [341] = {.lex_state = 6},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 6},
  [344] = {.lex_state = 6},
  [345] = {.lex_state = 6},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 6},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 6},
  [350] = {.lex_state = 6},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 6},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 6},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 6},
  [359] = {.lex_state = 6},
  [360] = {.lex_state = 4},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 6},
  [368] = {.lex_state = 4},
  [369] = {.lex_state = 6},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 6},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 4},
  [396] = {.lex_state = 4},
  [397] = {.lex_state = 4},
  [398] = {.lex_state = 4},
  [399] = {.lex_state = 7},
  [400] = {.lex_state = 7},
  [401] = {.lex_state = 7},
  [402] = {.lex_state = 7},
  [403] = {.lex_state = 7},
  [404] = {.lex_state = 7},
  [405] = {.lex_state = 7},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 7},
  [408] = {.lex_state = 7},
  [409] = {.lex_state = 7},
  [410] = {.lex_state = 7},
  [411] = {.lex_state = 7},
  [412] = {.lex_state = 7},
  [413] = {.lex_state = 7},
  [414] = {.lex_state = 7},
  [415] = {.lex_state = 7},
  [416] = {.lex_state = 7},
  [417] = {.lex_state = 7},
  [418] = {.lex_state = 7},
  [419] = {.lex_state = 7},
  [420] = {.lex_state = 7},
  [421] = {.lex_state = 7},
  [422] = {.lex_state = 7},
  [423] = {.lex_state = 7},
  [424] = {.lex_state = 7},
  [425] = {.lex_state = 7},
  [426] = {.lex_state = 7},
  [427] = {.lex_state = 7},
  [428] = {.lex_state = 7},
  [429] = {.lex_state = 9},
  [430] = {.lex_state = 9},
  [431] = {.lex_state = 9},
  [432] = {.lex_state = 9},
  [433] = {.lex_state = 9},
  [434] = {.lex_state = 9},
  [435] = {.lex_state = 9},
  [436] = {.lex_state = 8},
  [437] = {.lex_state = 9},
  [438] = {.lex_state = 9},
  [439] = {.lex_state = 9},
  [440] = {.lex_state = 9},
  [441] = {.lex_state = 9},
  [442] = {.lex_state = 9},
  [443] = {.lex_state = 9},
  [444] = {.lex_state = 9},
  [445] = {.lex_state = 9},
  [446] = {.lex_state = 9},
  [447] = {.lex_state = 9},
  [448] = {.lex_state = 9},
  [449] = {.lex_state = 9},
  [450] = {.lex_state = 9},
  [451] = {.lex_state = 9},
  [452] = {.lex_state = 9},
  [453] = {.lex_state = 8},
  [454] = {.lex_state = 9},
  [455] = {.lex_state = 9},
  [456] = {.lex_state = 9},
  [457] = {.lex_state = 9},
  [458] = {.lex_state = 8},
  [459] = {.lex_state = 8},
  [460] = {.lex_state = 9},
  [461] = {.lex_state = 8},
  [462] = {.lex_state = 9},
  [463] = {.lex_state = 8},
  [464] = {.lex_state = 9},
  [465] = {.lex_state = 8},
  [466] = {.lex_state = 9},
  [467] = {.lex_state = 8},
  [468] = {.lex_state = 9},
  [469] = {.lex_state = 9},
  [470] = {.lex_state = 9},
  [471] = {.lex_state = 8},
  [472] = {.lex_state = 8},
  [473] = {.lex_state = 8},
  [474] = {.lex_state = 8},
  [475] = {.lex_state = 8},
  [476] = {.lex_state = 8},
  [477] = {.lex_state = 8},
  [478] = {.lex_state = 8},
  [479] = {.lex_state = 8},
  [480] = {.lex_state = 8},
  [481] = {.lex_state = 8},
  [482] = {.lex_state = 8},
  [483] = {.lex_state = 8},
  [484] = {.lex_state = 8},
  [485] = {.lex_state = 8},
  [486] = {.lex_state = 8},
  [487] = {.lex_state = 8},
  [488] = {.lex_state = 8},
  [489] = {.lex_state = 8},
  [490] = {.lex_state = 8},
  [491] = {.lex_state = 8},
  [492] = {.lex_state = 8},
  [493] = {.lex_state = 8},
  [494] = {.lex_state = 8},
  [495] = {.lex_state = 8},
  [496] = {.lex_state = 8},
  [497] = {.lex_state = 8},
  [498] = {.lex_state = 8},
  [499] = {.lex_state = 8},
  [500] = {.lex_state = 8},
  [501] = {.lex_state = 8},
  [502] = {.lex_state = 8},
  [503] = {.lex_state = 8},
  [504] = {.lex_state = 8},
  [505] = {.lex_state = 8},
  [506] = {.lex_state = 8},
  [507] = {.lex_state = 8},
  [508] = {.lex_state = 8},
  [509] = {.lex_state = 8},
  [510] = {.lex_state = 8},
  [511] = {.lex_state = 8},
  [512] = {.lex_state = 8},
  [513] = {.lex_state = 8},
  [514] = {.lex_state = 8},
  [515] = {.lex_state = 8},
  [516] = {.lex_state = 8},
  [517] = {.lex_state = 8},
  [518] = {.lex_state = 8},
  [519] = {.lex_state = 8},
  [520] = {.lex_state = 8},
  [521] = {.lex_state = 8},
  [522] = {.lex_state = 8},
  [523] = {.lex_state = 8},
  [524] = {.lex_state = 8},
  [525] = {.lex_state = 8},
  [526] = {.lex_state = 8},
  [527] = {.lex_state = 8},
  [528] = {.lex_state = 8},
  [529] = {.lex_state = 8},
  [530] = {.lex_state = 8},
  [531] = {.lex_state = 8},
  [532] = {.lex_state = 8},
  [533] = {.lex_state = 8},
  [534] = {.lex_state = 8},
  [535] = {.lex_state = 8},
  [536] = {.lex_state = 8},
  [537] = {.lex_state = 8},
  [538] = {.lex_state = 8},
  [539] = {.lex_state = 8},
  [540] = {.lex_state = 8},
  [541] = {.lex_state = 8},
  [542] = {.lex_state = 8},
  [543] = {.lex_state = 8},
  [544] = {.lex_state = 8},
  [545] = {.lex_state = 8},
  [546] = {.lex_state = 8},
  [547] = {.lex_state = 8},
  [548] = {.lex_state = 8},
  [549] = {.lex_state = 8},
  [550] = {.lex_state = 8},
  [551] = {.lex_state = 8},
  [552] = {.lex_state = 8},
  [553] = {.lex_state = 8},
  [554] = {.lex_state = 8},
  [555] = {.lex_state = 8},
  [556] = {.lex_state = 8},
  [557] = {.lex_state = 8},
  [558] = {.lex_state = 8},
  [559] = {.lex_state = 8},
  [560] = {.lex_state = 8},
  [561] = {.lex_state = 8},
  [562] = {.lex_state = 8},
  [563] = {.lex_state = 8},
  [564] = {.lex_state = 8},
  [565] = {.lex_state = 8},
  [566] = {.lex_state = 8},
  [567] = {.lex_state = 8},
  [568] = {.lex_state = 8},
  [569] = {.lex_state = 8},
  [570] = {.lex_state = 8},
  [571] = {.lex_state = 8},
  [572] = {.lex_state = 8},
  [573] = {.lex_state = 8},
  [574] = {.lex_state = 8},
  [575] = {.lex_state = 8},
  [576] = {.lex_state = 8},
  [577] = {.lex_state = 8},
  [578] = {.lex_state = 8},
  [579] = {.lex_state = 8},
  [580] = {.lex_state = 8},
  [581] = {.lex_state = 8},
  [582] = {.lex_state = 8},
  [583] = {.lex_state = 8},
  [584] = {.lex_state = 8},
  [585] = {.lex_state = 8},
  [586] = {.lex_state = 8},
  [587] = {.lex_state = 8},
  [588] = {.lex_state = 8},
  [589] = {.lex_state = 8},
  [590] = {.lex_state = 8},
  [591] = {.lex_state = 8},
  [592] = {.lex_state = 8},
  [593] = {.lex_state = 8},
  [594] = {.lex_state = 9},
  [595] = {.lex_state = 8},
  [596] = {.lex_state = 75},
  [597] = {.lex_state = 75},
  [598] = {.lex_state = 2},
  [599] = {.lex_state = 2},
  [600] = {.lex_state = 2},
  [601] = {.lex_state = 2},
  [602] = {.lex_state = 2},
  [603] = {.lex_state = 2},
  [604] = {.lex_state = 2},
  [605] = {.lex_state = 2},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 75},
  [608] = {.lex_state = 75},
  [609] = {.lex_state = 75},
  [610] = {.lex_state = 75},
  [611] = {.lex_state = 75},
  [612] = {.lex_state = 75},
  [613] = {.lex_state = 75},
  [614] = {.lex_state = 75},
  [615] = {.lex_state = 75},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 75},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 75},
  [621] = {.lex_state = 75},
  [622] = {.lex_state = 75},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 75},
  [625] = {.lex_state = 75},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 1},
  [628] = {.lex_state = 75},
  [629] = {.lex_state = 8},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 8},
  [632] = {.lex_state = 75},
  [633] = {.lex_state = 8},
  [634] = {.lex_state = 8},
  [635] = {.lex_state = 1},
  [636] = {.lex_state = 8},
  [637] = {.lex_state = 1},
  [638] = {.lex_state = 8},
  [639] = {.lex_state = 8},
  [640] = {.lex_state = 8},
  [641] = {.lex_state = 8},
  [642] = {.lex_state = 1},
  [643] = {.lex_state = 2},
  [644] = {.lex_state = 8},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 2},
  [648] = {.lex_state = 2},
  [649] = {.lex_state = 1},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 2},
  [652] = {.lex_state = 1},
  [653] = {.lex_state = 1},
  [654] = {.lex_state = 8},
  [655] = {.lex_state = 8},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 2},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 1},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 8},
  [663] = {.lex_state = 1},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 8},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 2},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 3},
  [672] = {.lex_state = 170},
  [673] = {.lex_state = 3},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 2},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 2},
  [678] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_end_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_semicolon] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_any] = ACTIONS(1),
    [sym_zero] = ACTIONS(1),
    [sym_boundary] = ACTIONS(1),
    [sym_symbol_group] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_complement] = ACTIONS(1),
    [sym_term_complement] = ACTIONS(1),
    [sym_contains] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_repeat] = ACTIONS(1),
    [sym_upper] = ACTIONS(1),
    [sym_lower] = ACTIONS(1),
    [sym_reverse] = ACTIONS(1),
    [sym_inverse] = ACTIONS(1),
    [sym_ignore] = ACTIONS(1),
    [sym_ignore_inside] = ACTIONS(1),
    [sym_union] = ACTIONS(1),
    [sym_intersect] = ACTIONS(1),
    [sym_subtract] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(1),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_AT_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_AT] = ACTIONS(1),
    [anon_sym_AT_GT] = ACTIONS(1),
    [anon_sym_GT_AT] = ACTIONS(1),
    [anon_sym_LBRACK_DOT] = ACTIONS(1),
    [anon_sym_DOT_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_COMMA_COMMA] = ACTIONS(1),
    [sym_crossproduct] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_multichar_symbols_header] = ACTIONS(1),
    [anon_sym_LEXICON] = ACTIONS(1),
    [sym_lexicon_start_wrong_case] = ACTIONS(1),
    [sym_gloss] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_END] = ACTIONS(5),
  },
  [1] = {
    [sym_source_file] = STATE(674),
    [sym_multichar_symbols] = STATE(623),
    [sym_lexicon_start] = STATE(673),
    [sym_lexicon] = STATE(630),
    [sym_end_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(619),
    [sym_comment] = ACTIONS(3),
    [sym_multichar_symbols_header] = ACTIONS(7),
    [anon_sym_LEXICON] = ACTIONS(9),
    [sym_lexicon_start_wrong_case] = ACTIONS(11),
    [anon_sym_END] = ACTIONS(5),
  },
  [2] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(2),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [3] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(3),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [4] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(4),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [5] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(5),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [6] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(6),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [7] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(7),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [8] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(8),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [9] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(9),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [10] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(10),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(73),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [11] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(11),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [12] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(12),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [13] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(13),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [14] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(14),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [15] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(15),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(79),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(81),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [anon_sym_COMMA_COMMA] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(81),
    [anon_sym_END] = ACTIONS(43),
  },
  [16] = {
    [sym_expression] = STATE(8),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(474),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(16),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(27),
    [sym_complement] = ACTIONS(29),
    [sym_term_complement] = ACTIONS(31),
    [sym_contains] = ACTIONS(29),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(35),
    [sym_ignore_inside] = ACTIONS(37),
    [sym_union] = ACTIONS(49),
    [sym_intersect] = ACTIONS(51),
    [sym_subtract] = ACTIONS(49),
    [anon_sym_EQ_GT] = ACTIONS(83),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(39),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [17] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(17),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [18] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(18),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [19] = {
    [sym_expression] = STATE(3),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(19),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [20] = {
    [sym_expression] = STATE(5),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(20),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [21] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(21),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [22] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(22),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [23] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(23),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(79),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(81),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [anon_sym_COMMA_COMMA] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(81),
    [anon_sym_END] = ACTIONS(43),
  },
  [24] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(24),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [25] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(25),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [26] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(26),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [27] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(27),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [28] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(28),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(131),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [29] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(29),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(133),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_END] = ACTIONS(43),
  },
  [30] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(30),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(79),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(79),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(79),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(81),
    [anon_sym_END] = ACTIONS(43),
  },
  [31] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(31),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [32] = {
    [sym_expression] = STATE(6),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(195),
    [sym_single_replace] = STATE(195),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(237),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(32),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [33] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(33),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [34] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(34),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [35] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(35),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [36] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(36),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [37] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(37),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [38] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(38),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [39] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(39),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(125),
    [sym_intersect] = ACTIONS(127),
    [sym_subtract] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(135),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [40] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(40),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(117),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(117),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [41] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(41),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [42] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(42),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [43] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(43),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(123),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [44] = {
    [sym_expression] = STATE(43),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(477),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(44),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(115),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [45] = {
    [sym_expression] = STATE(33),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(473),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(45),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(89),
    [sym_complement] = ACTIONS(91),
    [sym_term_complement] = ACTIONS(93),
    [sym_contains] = ACTIONS(91),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(95),
    [sym_ignore_inside] = ACTIONS(97),
    [sym_union] = ACTIONS(99),
    [sym_intersect] = ACTIONS(101),
    [sym_subtract] = ACTIONS(99),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(103),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [46] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(46),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [47] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(47),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [48] = {
    [sym_expression] = STATE(34),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(48),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [49] = {
    [sym_expression] = STATE(35),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(49),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(59),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(59),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(59),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [50] = {
    [sym_expression] = STATE(22),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(50),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [51] = {
    [sym_expression] = STATE(36),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(51),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [52] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(52),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(79),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(79),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(79),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(81),
    [anon_sym_END] = ACTIONS(43),
  },
  [53] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(53),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [54] = {
    [sym_expression] = STATE(38),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(200),
    [sym_single_replace] = STATE(200),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(279),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(54),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [55] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(55),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [56] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(56),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [57] = {
    [sym_expression] = STATE(25),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(222),
    [sym_single_replace] = STATE(222),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(226),
    [sym_conditional_replace] = STATE(214),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(57),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [58] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(58),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [59] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(59),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [60] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(60),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(153),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [61] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(61),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(17),
    [sym_string] = ACTIONS(19),
    [sym_any] = ACTIONS(19),
    [sym_zero] = ACTIONS(19),
    [sym_boundary] = ACTIONS(19),
    [sym_symbol_group] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(23),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(139),
    [sym_term_complement] = ACTIONS(141),
    [sym_contains] = ACTIONS(139),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(143),
    [sym_ignore_inside] = ACTIONS(145),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [62] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(62),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(33),
    [sym_star] = ACTIONS(33),
    [sym_repeat] = ACTIONS(33),
    [sym_upper] = ACTIONS(33),
    [sym_lower] = ACTIONS(33),
    [sym_reverse] = ACTIONS(33),
    [sym_inverse] = ACTIONS(33),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [63] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_arrow] = STATE(476),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(63),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(137),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [64] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(64),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [65] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(65),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [66] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(66),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [67] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(67),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [68] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(68),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [69] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(69),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [70] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(70),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [71] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(71),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [72] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(72),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [73] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(73),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(185),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [74] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(74),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [75] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(75),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [76] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(76),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [77] = {
    [sym_expression] = STATE(56),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(77),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(59),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(59),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(59),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [78] = {
    [sym_expression] = STATE(46),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(78),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [79] = {
    [sym_expression] = STATE(58),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(79),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [80] = {
    [sym_expression] = STATE(59),
    [sym_optional] = STATE(289),
    [sym_substitute] = STATE(289),
    [sym_restrict] = STATE(289),
    [sym_simple_replace] = STATE(277),
    [sym_single_replace] = STATE(277),
    [sym_mark] = STATE(289),
    [sym_parallel_replace] = STATE(266),
    [sym_conditional_replace] = STATE(260),
    [sym_parallel_conditional_replace] = STATE(289),
    [sym_end_comment] = STATE(80),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [81] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(81),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(81),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [anon_sym_COMMA_COMMA] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [82] = {
    [sym_expression] = STATE(67),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(486),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(82),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(165),
    [sym_complement] = ACTIONS(167),
    [sym_term_complement] = ACTIONS(169),
    [sym_contains] = ACTIONS(167),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(173),
    [sym_ignore_inside] = ACTIONS(175),
    [sym_union] = ACTIONS(177),
    [sym_intersect] = ACTIONS(179),
    [sym_subtract] = ACTIONS(177),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(181),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [83] = {
    [sym_expression] = STATE(64),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(83),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [84] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(84),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [85] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(85),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [86] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(86),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [87] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(87),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [88] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(88),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [89] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(89),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(223),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [90] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(90),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(77),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [91] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(91),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [92] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(92),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [93] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(93),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [94] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(94),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [95] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(95),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [96] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(96),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(225),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [97] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(97),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [98] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(98),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [99] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(99),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(81),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [anon_sym_COMMA_COMMA] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [100] = {
    [sym_expression] = STATE(74),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(100),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [101] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(101),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [102] = {
    [sym_expression] = STATE(72),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(303),
    [sym_single_replace] = STATE(303),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(305),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(102),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [103] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(103),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [104] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(104),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [105] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(105),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [106] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(106),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(79),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(79),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [107] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(107),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(207),
    [sym_term_complement] = ACTIONS(209),
    [sym_contains] = ACTIONS(207),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(215),
    [sym_intersect] = ACTIONS(217),
    [sym_subtract] = ACTIONS(215),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(229),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [108] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(108),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [109] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(109),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [110] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(110),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(211),
    [sym_ignore_inside] = ACTIONS(213),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [111] = {
    [sym_expression] = STATE(110),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(488),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(111),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(205),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [112] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(475),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(112),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [113] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(113),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [114] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(114),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [115] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(115),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [116] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(116),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [117] = {
    [sym_expression] = STATE(85),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(117),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [118] = {
    [sym_expression] = STATE(97),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(118),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [119] = {
    [sym_expression] = STATE(84),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(119),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [120] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(120),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [121] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(121),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [122] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(122),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [123] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(123),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [124] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(124),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [125] = {
    [sym_expression] = STATE(98),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(319),
    [sym_single_replace] = STATE(319),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(324),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(125),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(59),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(59),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(59),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [126] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(126),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [127] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(127),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(267),
    [sym_intersect] = ACTIONS(267),
    [sym_subtract] = ACTIONS(269),
    [anon_sym_EQ_GT] = ACTIONS(271),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [128] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(128),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [129] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(129),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [130] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(130),
    [anon_sym_LBRACK] = ACTIONS(155),
    [sym_symbol] = ACTIONS(157),
    [sym_string] = ACTIONS(159),
    [sym_any] = ACTIONS(159),
    [sym_zero] = ACTIONS(159),
    [sym_boundary] = ACTIONS(159),
    [sym_symbol_group] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(161),
    [anon_sym_BQUOTE] = ACTIONS(163),
    [anon_sym_COMMA] = ACTIONS(79),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(251),
    [sym_term_complement] = ACTIONS(253),
    [sym_contains] = ACTIONS(251),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(259),
    [sym_intersect] = ACTIONS(261),
    [sym_subtract] = ACTIONS(259),
    [anon_sym__] = ACTIONS(81),
    [anon_sym_EQ_GT] = ACTIONS(79),
    [anon_sym_DASH_GT] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(79),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(79),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(79),
    [anon_sym_AT_DASH_GT] = ACTIONS(79),
    [anon_sym_DASH_GT_AT] = ACTIONS(79),
    [anon_sym_AT_GT] = ACTIONS(79),
    [anon_sym_GT_AT] = ACTIONS(79),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(79),
    [anon_sym_SLASH_SLASH] = ACTIONS(79),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(79),
    [sym_crossproduct] = ACTIONS(79),
    [sym_compose] = ACTIONS(79),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [131] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(131),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [132] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(132),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(171),
    [sym_star] = ACTIONS(171),
    [sym_repeat] = ACTIONS(171),
    [sym_upper] = ACTIONS(171),
    [sym_lower] = ACTIONS(171),
    [sym_reverse] = ACTIONS(171),
    [sym_inverse] = ACTIONS(171),
    [sym_ignore] = ACTIONS(255),
    [sym_ignore_inside] = ACTIONS(257),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [133] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(133),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(267),
    [sym_intersect] = ACTIONS(267),
    [sym_subtract] = ACTIONS(269),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [134] = {
    [sym_expression] = STATE(132),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_arrow] = STATE(485),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(134),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(249),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [135] = {
    [sym_expression] = STATE(87),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(135),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [136] = {
    [sym_expression] = STATE(94),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(136),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [137] = {
    [sym_expression] = STATE(93),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(306),
    [sym_single_replace] = STATE(306),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(313),
    [sym_conditional_replace] = STATE(307),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(137),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [138] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(138),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(267),
    [sym_intersect] = ACTIONS(267),
    [sym_subtract] = ACTIONS(269),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [139] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(139),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(267),
    [sym_intersect] = ACTIONS(267),
    [sym_subtract] = ACTIONS(269),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [140] = {
    [sym_expression] = STATE(115),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(490),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(140),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(243),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(247),
    [sym_ignore_inside] = ACTIONS(247),
    [sym_union] = ACTIONS(267),
    [sym_intersect] = ACTIONS(267),
    [sym_subtract] = ACTIONS(269),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(129),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [141] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(141),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [142] = {
    [sym_expression] = STATE(121),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(142),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(47),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(47),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(47),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_PIPE_PIPE] = ACTIONS(45),
    [anon_sym_SLASH_SLASH] = ACTIONS(45),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(45),
    [anon_sym_BSLASH_SLASH] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [143] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(143),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [144] = {
    [sym_expression] = STATE(138),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(144),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(45),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(45),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [145] = {
    [sym_expression] = STATE(133),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(145),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [146] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(146),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(283),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [147] = {
    [sym_expression] = STATE(139),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(147),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(107),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(107),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(107),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [148] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(148),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [149] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(149),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [150] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(150),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [151] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(151),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [152] = {
    [sym_expression] = STATE(140),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(249),
    [sym_single_replace] = STATE(249),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(371),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(152),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [153] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(153),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [154] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(154),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(63),
    [anon_sym_END] = ACTIONS(43),
  },
  [155] = {
    [sym_expression] = STATE(120),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(155),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(59),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(59),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(59),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_SLASH_SLASH] = ACTIONS(57),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(57),
    [anon_sym_BSLASH_SLASH] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [156] = {
    [sym_expression] = STATE(123),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(156),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(105),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(105),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_PIPE_PIPE] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(107),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(107),
    [anon_sym_BSLASH_SLASH] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [157] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(157),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [158] = {
    [sym_expression] = STATE(122),
    [sym_optional] = STATE(345),
    [sym_substitute] = STATE(345),
    [sym_restrict] = STATE(345),
    [sym_simple_replace] = STATE(350),
    [sym_single_replace] = STATE(350),
    [sym_mark] = STATE(345),
    [sym_parallel_replace] = STATE(336),
    [sym_conditional_replace] = STATE(331),
    [sym_parallel_conditional_replace] = STATE(345),
    [sym_end_comment] = STATE(158),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(109),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(109),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_PIPE_PIPE] = ACTIONS(111),
    [anon_sym_SLASH_SLASH] = ACTIONS(111),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(111),
    [anon_sym_BSLASH_SLASH] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [159] = {
    [sym_expression] = STATE(157),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(159),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(107),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(107),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(107),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(107),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(107),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_DOT_RBRACK] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_END] = ACTIONS(43),
  },
  [160] = {
    [sym_expression] = STATE(154),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(160),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_RBRACK] = ACTIONS(45),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_RPAREN] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(45),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(45),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_DOT_RBRACK] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(47),
    [anon_sym_END] = ACTIONS(43),
  },
  [161] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(161),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [162] = {
    [sym_expression] = STATE(153),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(162),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [163] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(163),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [164] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(164),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_END] = ACTIONS(43),
  },
  [165] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(165),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [166] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(166),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [167] = {
    [sym_expression] = STATE(143),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(167),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [168] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(168),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [169] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(169),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [170] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(170),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [171] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(171),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [172] = {
    [sym_expression] = STATE(164),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(172),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_RBRACK] = ACTIONS(57),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_DOT_RBRACK] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_END] = ACTIONS(43),
  },
  [173] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(173),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [174] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(174),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(315),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(317),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [175] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(175),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(315),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(317),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [176] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(176),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(315),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(317),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [177] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(177),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(315),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(317),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [178] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(178),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(315),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(317),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [179] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(179),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(313),
    [sym_term_complement] = ACTIONS(313),
    [sym_contains] = ACTIONS(313),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(301),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [180] = {
    [sym_expression] = STATE(166),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(180),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(111),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_DOT_RBRACK] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(109),
    [anon_sym_END] = ACTIONS(43),
  },
  [181] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(181),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(297),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [182] = {
    [sym_expression] = STATE(173),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(492),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(182),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [183] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(183),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(327),
    [sym_intersect] = ACTIONS(327),
    [sym_subtract] = ACTIONS(329),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [184] = {
    [sym_condition_operators] = STATE(441),
    [sym_end_comment] = STATE(184),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(333),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(331),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_RBRACK] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_END] = ACTIONS(43),
  },
  [185] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(185),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [186] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(186),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [187] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(187),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [188] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(188),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [189] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(189),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [190] = {
    [sym_expression] = STATE(175),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(190),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(105),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(107),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(107),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(107),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [anon_sym_COMMA_COMMA] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [191] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(191),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(15),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(327),
    [sym_intersect] = ACTIONS(327),
    [sym_subtract] = ACTIONS(329),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(335),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [192] = {
    [sym_expression] = STATE(174),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(192),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(47),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(45),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(45),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [anon_sym_COMMA_COMMA] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [193] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(193),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(327),
    [sym_intersect] = ACTIONS(327),
    [sym_subtract] = ACTIONS(329),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [194] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(194),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(327),
    [sym_intersect] = ACTIONS(327),
    [sym_subtract] = ACTIONS(329),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [195] = {
    [sym_condition_operators] = STATE(442),
    [sym_end_comment] = STATE(195),
    [aux_sym_parallel_replace_repeat1] = STATE(246),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(341),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [196] = {
    [sym_expression] = STATE(187),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(494),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(196),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(321),
    [sym_complement] = ACTIONS(323),
    [sym_term_complement] = ACTIONS(323),
    [sym_contains] = ACTIONS(323),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(325),
    [sym_ignore_inside] = ACTIONS(325),
    [sym_union] = ACTIONS(327),
    [sym_intersect] = ACTIONS(327),
    [sym_subtract] = ACTIONS(329),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [197] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(197),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(59),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [anon_sym_COMMA_COMMA] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [198] = {
    [sym_expression] = STATE(177),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(318),
    [sym_single_replace] = STATE(318),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(400),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(198),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(109),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [anon_sym_COMMA_COMMA] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [199] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(199),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(345),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(349),
    [anon_sym_END] = ACTIONS(43),
  },
  [200] = {
    [sym_condition_operators] = STATE(443),
    [sym_end_comment] = STATE(200),
    [aux_sym_parallel_replace_repeat1] = STATE(259),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(351),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [201] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(201),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(353),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(283),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(355),
    [sym_compose] = ACTIONS(355),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [202] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(202),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(357),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [203] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(203),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [204] = {
    [sym_end_comment] = STATE(204),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(211),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(373),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [205] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(205),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(375),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [206] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(206),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(377),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(283),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(355),
    [sym_compose] = ACTIONS(355),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [207] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(207),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [208] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(208),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(385),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [209] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(209),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(387),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [210] = {
    [sym_end_comment] = STATE(210),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(389),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_RBRACK] = ACTIONS(391),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_RBRACK] = ACTIONS(391),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(391),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_END] = ACTIONS(43),
  },
  [211] = {
    [sym_end_comment] = STATE(211),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(211),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_RBRACK] = ACTIONS(391),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_RBRACK] = ACTIONS(391),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(393),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_END] = ACTIONS(43),
  },
  [212] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(212),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [213] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(213),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(396),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [214] = {
    [sym_end_comment] = STATE(214),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(204),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(373),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [215] = {
    [sym_expression] = STATE(193),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(215),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [216] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(216),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(398),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [217] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(217),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(55),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(55),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(55),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [218] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(218),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(400),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [219] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(219),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(402),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [220] = {
    [sym_end_comment] = STATE(220),
    [aux_sym_context_list_repeat1] = STATE(244),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(404),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [221] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(221),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(408),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [222] = {
    [sym_condition_operators] = STATE(442),
    [sym_end_comment] = STATE(222),
    [aux_sym_parallel_replace_repeat1] = STATE(287),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(410),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [223] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(223),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [224] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(224),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(15),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [225] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(225),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(15),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [226] = {
    [sym_condition_operators] = STATE(442),
    [sym_end_comment] = STATE(226),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [227] = {
    [sym_end_comment] = STATE(227),
    [aux_sym_parallel_replace_repeat1] = STATE(227),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(333),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(412),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_RBRACK] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_END] = ACTIONS(43),
  },
  [228] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(228),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(415),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [229] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(229),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(417),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [230] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(230),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [231] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(231),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(419),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [232] = {
    [sym_expression] = STATE(194),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(232),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [233] = {
    [sym_expression] = STATE(183),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(233),
    [anon_sym_LBRACK] = ACTIONS(47),
    [sym_symbol] = ACTIONS(47),
    [sym_string] = ACTIONS(45),
    [sym_any] = ACTIONS(45),
    [sym_zero] = ACTIONS(45),
    [sym_boundary] = ACTIONS(45),
    [sym_symbol_group] = ACTIONS(45),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(45),
    [anon_sym_COMMA] = ACTIONS(45),
    [sym_colon] = ACTIONS(45),
    [sym_complement] = ACTIONS(45),
    [sym_term_complement] = ACTIONS(45),
    [sym_contains] = ACTIONS(45),
    [sym_plus] = ACTIONS(45),
    [sym_star] = ACTIONS(45),
    [sym_repeat] = ACTIONS(45),
    [sym_upper] = ACTIONS(45),
    [sym_lower] = ACTIONS(45),
    [sym_reverse] = ACTIONS(45),
    [sym_inverse] = ACTIONS(45),
    [sym_ignore] = ACTIONS(45),
    [sym_ignore_inside] = ACTIONS(45),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(45),
    [sym_subtract] = ACTIONS(47),
    [anon_sym__] = ACTIONS(47),
    [anon_sym_EQ_GT] = ACTIONS(45),
    [anon_sym_DASH_GT] = ACTIONS(47),
    [anon_sym_LT_DASH] = ACTIONS(45),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(45),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(45),
    [anon_sym_AT_DASH_GT] = ACTIONS(45),
    [anon_sym_DASH_GT_AT] = ACTIONS(45),
    [anon_sym_AT_GT] = ACTIONS(45),
    [anon_sym_GT_AT] = ACTIONS(45),
    [anon_sym_LBRACK_DOT] = ACTIONS(45),
    [sym_crossproduct] = ACTIONS(45),
    [sym_compose] = ACTIONS(45),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [234] = {
    [sym_expression] = STATE(196),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(332),
    [sym_single_replace] = STATE(332),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(335),
    [sym_conditional_replace] = STATE(403),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(234),
    [anon_sym_LBRACK] = ACTIONS(105),
    [sym_symbol] = ACTIONS(105),
    [sym_string] = ACTIONS(107),
    [sym_any] = ACTIONS(107),
    [sym_zero] = ACTIONS(107),
    [sym_boundary] = ACTIONS(107),
    [sym_symbol_group] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_COMMA] = ACTIONS(107),
    [sym_colon] = ACTIONS(107),
    [sym_complement] = ACTIONS(107),
    [sym_term_complement] = ACTIONS(107),
    [sym_contains] = ACTIONS(107),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(107),
    [sym_ignore_inside] = ACTIONS(107),
    [sym_union] = ACTIONS(107),
    [sym_intersect] = ACTIONS(107),
    [sym_subtract] = ACTIONS(105),
    [anon_sym__] = ACTIONS(105),
    [anon_sym_EQ_GT] = ACTIONS(107),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_LT_DASH] = ACTIONS(107),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(107),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(107),
    [anon_sym_AT_DASH_GT] = ACTIONS(107),
    [anon_sym_DASH_GT_AT] = ACTIONS(107),
    [anon_sym_AT_GT] = ACTIONS(107),
    [anon_sym_GT_AT] = ACTIONS(107),
    [anon_sym_LBRACK_DOT] = ACTIONS(107),
    [sym_crossproduct] = ACTIONS(107),
    [sym_compose] = ACTIONS(107),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [235] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(235),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(421),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [236] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(236),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(423),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(283),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(355),
    [sym_compose] = ACTIONS(355),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [237] = {
    [sym_end_comment] = STATE(237),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(247),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(373),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [238] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(238),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(425),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [239] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(239),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(427),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [240] = {
    [sym_expression] = STATE(150),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(497),
    [sym_simple_replace] = STATE(262),
    [sym_single_replace] = STATE(262),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(291),
    [sym_conditional_replace] = STATE(361),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(240),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(429),
    [sym_colon] = ACTIONS(273),
    [sym_complement] = ACTIONS(275),
    [sym_term_complement] = ACTIONS(275),
    [sym_contains] = ACTIONS(275),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(277),
    [sym_ignore_inside] = ACTIONS(277),
    [sym_union] = ACTIONS(279),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(281),
    [anon_sym_EQ_GT] = ACTIONS(283),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(355),
    [sym_compose] = ACTIONS(355),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [241] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(241),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(431),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [242] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(242),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(433),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [243] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(243),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(435),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [244] = {
    [sym_end_comment] = STATE(244),
    [aux_sym_context_list_repeat1] = STATE(253),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(437),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [245] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(245),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [anon_sym_DOT_RBRACK] = ACTIONS(441),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [246] = {
    [sym_end_comment] = STATE(246),
    [aux_sym_parallel_replace_repeat1] = STATE(227),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(445),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(443),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_RBRACK] = ACTIONS(445),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [anon_sym_COMMA_COMMA] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_END] = ACTIONS(43),
  },
  [247] = {
    [sym_end_comment] = STATE(247),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(211),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(371),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [248] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(248),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [249] = {
    [sym_condition_operators] = STATE(438),
    [sym_end_comment] = STATE(249),
    [aux_sym_parallel_replace_repeat1] = STATE(259),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(351),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [250] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(250),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(447),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [251] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(251),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(449),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [252] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(252),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(451),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [253] = {
    [sym_end_comment] = STATE(253),
    [aux_sym_context_list_repeat1] = STATE(253),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(457),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [254] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_arrow] = STATE(491),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(254),
    [anon_sym_LBRACK] = ACTIONS(303),
    [sym_symbol] = ACTIONS(305),
    [sym_string] = ACTIONS(307),
    [sym_any] = ACTIONS(307),
    [sym_zero] = ACTIONS(307),
    [sym_boundary] = ACTIONS(307),
    [sym_symbol_group] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(311),
    [sym_colon] = ACTIONS(359),
    [sym_complement] = ACTIONS(361),
    [sym_term_complement] = ACTIONS(361),
    [sym_contains] = ACTIONS(361),
    [sym_plus] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_repeat] = ACTIONS(299),
    [sym_upper] = ACTIONS(299),
    [sym_lower] = ACTIONS(299),
    [sym_reverse] = ACTIONS(299),
    [sym_inverse] = ACTIONS(299),
    [sym_ignore] = ACTIONS(363),
    [sym_ignore_inside] = ACTIONS(363),
    [sym_union] = ACTIONS(365),
    [sym_intersect] = ACTIONS(365),
    [sym_subtract] = ACTIONS(367),
    [anon_sym__] = ACTIONS(460),
    [anon_sym_EQ_GT] = ACTIONS(381),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(263),
    [sym_crossproduct] = ACTIONS(383),
    [sym_compose] = ACTIONS(383),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [255] = {
    [sym_condition_operators] = STATE(441),
    [sym_end_comment] = STATE(255),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [256] = {
    [sym_end_comment] = STATE(256),
    [aux_sym_context_list_repeat1] = STATE(256),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(464),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [257] = {
    [sym_end_comment] = STATE(257),
    [aux_sym_context_list_repeat1] = STATE(256),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(437),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [258] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(480),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(258),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [259] = {
    [sym_end_comment] = STATE(259),
    [aux_sym_parallel_replace_repeat1] = STATE(261),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(445),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(443),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_RBRACK] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [anon_sym_COMMA_COMMA] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_END] = ACTIONS(43),
  },
  [260] = {
    [sym_end_comment] = STATE(260),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(267),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(467),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [261] = {
    [sym_end_comment] = STATE(261),
    [aux_sym_parallel_replace_repeat1] = STATE(261),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(333),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(469),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_RBRACK] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_END] = ACTIONS(43),
  },
  [262] = {
    [sym_condition_operators] = STATE(438),
    [sym_end_comment] = STATE(262),
    [aux_sym_parallel_replace_repeat1] = STATE(301),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [263] = {
    [sym_end_comment] = STATE(263),
    [aux_sym_context_list_repeat1] = STATE(257),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(404),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [264] = {
    [sym_expression] = STATE(230),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(264),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_symbol] = ACTIONS(109),
    [sym_string] = ACTIONS(111),
    [sym_any] = ACTIONS(111),
    [sym_zero] = ACTIONS(111),
    [sym_boundary] = ACTIONS(111),
    [sym_symbol_group] = ACTIONS(111),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BQUOTE] = ACTIONS(111),
    [sym_colon] = ACTIONS(111),
    [sym_complement] = ACTIONS(111),
    [sym_term_complement] = ACTIONS(111),
    [sym_contains] = ACTIONS(111),
    [sym_plus] = ACTIONS(111),
    [sym_star] = ACTIONS(111),
    [sym_repeat] = ACTIONS(111),
    [sym_upper] = ACTIONS(111),
    [sym_lower] = ACTIONS(111),
    [sym_reverse] = ACTIONS(111),
    [sym_inverse] = ACTIONS(111),
    [sym_ignore] = ACTIONS(111),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(111),
    [sym_intersect] = ACTIONS(111),
    [sym_subtract] = ACTIONS(109),
    [anon_sym__] = ACTIONS(109),
    [anon_sym_EQ_GT] = ACTIONS(111),
    [anon_sym_DASH_GT] = ACTIONS(109),
    [anon_sym_LT_DASH] = ACTIONS(111),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(111),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(111),
    [anon_sym_AT_DASH_GT] = ACTIONS(111),
    [anon_sym_DASH_GT_AT] = ACTIONS(111),
    [anon_sym_AT_GT] = ACTIONS(111),
    [anon_sym_GT_AT] = ACTIONS(111),
    [anon_sym_LBRACK_DOT] = ACTIONS(111),
    [sym_crossproduct] = ACTIONS(111),
    [sym_compose] = ACTIONS(111),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [265] = {
    [sym_end_comment] = STATE(265),
    [aux_sym_context_list_repeat1] = STATE(284),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [266] = {
    [sym_condition_operators] = STATE(443),
    [sym_end_comment] = STATE(266),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [267] = {
    [sym_end_comment] = STATE(267),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(275),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(467),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [268] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(481),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(268),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [269] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(483),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(269),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [270] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(482),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(270),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [271] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(479),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(271),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [272] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(489),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(272),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [273] = {
    [sym_end_comment] = STATE(273),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(55),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [274] = {
    [sym_end_comment] = STATE(274),
    [aux_sym_context_list_repeat1] = STATE(265),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [275] = {
    [sym_end_comment] = STATE(275),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(275),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_RBRACK] = ACTIONS(391),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_RBRACK] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(472),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_END] = ACTIONS(43),
  },
  [276] = {
    [sym_end_comment] = STATE(276),
    [anon_sym_LBRACK] = ACTIONS(475),
    [anon_sym_RBRACK] = ACTIONS(477),
    [sym_symbol] = ACTIONS(475),
    [sym_string] = ACTIONS(477),
    [sym_any] = ACTIONS(477),
    [sym_zero] = ACTIONS(477),
    [sym_boundary] = ACTIONS(477),
    [sym_symbol_group] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_RPAREN] = ACTIONS(477),
    [anon_sym_BQUOTE] = ACTIONS(477),
    [anon_sym_COMMA] = ACTIONS(475),
    [sym_colon] = ACTIONS(477),
    [sym_complement] = ACTIONS(477),
    [sym_term_complement] = ACTIONS(475),
    [sym_contains] = ACTIONS(477),
    [sym_plus] = ACTIONS(477),
    [sym_star] = ACTIONS(477),
    [sym_repeat] = ACTIONS(477),
    [sym_upper] = ACTIONS(477),
    [sym_lower] = ACTIONS(477),
    [sym_reverse] = ACTIONS(477),
    [sym_inverse] = ACTIONS(477),
    [sym_ignore] = ACTIONS(475),
    [sym_ignore_inside] = ACTIONS(477),
    [sym_union] = ACTIONS(475),
    [sym_intersect] = ACTIONS(477),
    [sym_subtract] = ACTIONS(475),
    [anon_sym_EQ_GT] = ACTIONS(477),
    [anon_sym_DASH_GT] = ACTIONS(475),
    [anon_sym_LT_DASH] = ACTIONS(477),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(477),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(477),
    [anon_sym_AT_DASH_GT] = ACTIONS(477),
    [anon_sym_DASH_GT_AT] = ACTIONS(477),
    [anon_sym_AT_GT] = ACTIONS(477),
    [anon_sym_GT_AT] = ACTIONS(477),
    [anon_sym_LBRACK_DOT] = ACTIONS(477),
    [anon_sym_DOT_RBRACK] = ACTIONS(477),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_SLASH_SLASH] = ACTIONS(477),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(477),
    [anon_sym_BSLASH_SLASH] = ACTIONS(477),
    [anon_sym_COMMA_COMMA] = ACTIONS(477),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(475),
    [anon_sym_END] = ACTIONS(43),
  },
  [277] = {
    [sym_condition_operators] = STATE(443),
    [sym_end_comment] = STATE(277),
    [aux_sym_parallel_replace_repeat1] = STATE(301),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [278] = {
    [sym_expression] = STATE(203),
    [sym_optional] = STATE(412),
    [sym_substitute] = STATE(412),
    [sym_restrict] = STATE(412),
    [sym_simple_replace] = STATE(327),
    [sym_single_replace] = STATE(327),
    [sym_mark] = STATE(412),
    [sym_parallel_replace] = STATE(387),
    [sym_conditional_replace] = STATE(410),
    [sym_parallel_conditional_replace] = STATE(412),
    [sym_end_comment] = STATE(278),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_symbol] = ACTIONS(59),
    [sym_string] = ACTIONS(57),
    [sym_any] = ACTIONS(57),
    [sym_zero] = ACTIONS(57),
    [sym_boundary] = ACTIONS(57),
    [sym_symbol_group] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_BQUOTE] = ACTIONS(57),
    [sym_colon] = ACTIONS(57),
    [sym_complement] = ACTIONS(57),
    [sym_term_complement] = ACTIONS(57),
    [sym_contains] = ACTIONS(57),
    [sym_plus] = ACTIONS(57),
    [sym_star] = ACTIONS(57),
    [sym_repeat] = ACTIONS(57),
    [sym_upper] = ACTIONS(57),
    [sym_lower] = ACTIONS(57),
    [sym_reverse] = ACTIONS(57),
    [sym_inverse] = ACTIONS(57),
    [sym_ignore] = ACTIONS(57),
    [sym_ignore_inside] = ACTIONS(57),
    [sym_union] = ACTIONS(57),
    [sym_intersect] = ACTIONS(57),
    [sym_subtract] = ACTIONS(59),
    [anon_sym__] = ACTIONS(59),
    [anon_sym_EQ_GT] = ACTIONS(57),
    [anon_sym_DASH_GT] = ACTIONS(59),
    [anon_sym_LT_DASH] = ACTIONS(57),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(57),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(57),
    [anon_sym_AT_DASH_GT] = ACTIONS(57),
    [anon_sym_DASH_GT_AT] = ACTIONS(57),
    [anon_sym_AT_GT] = ACTIONS(57),
    [anon_sym_GT_AT] = ACTIONS(57),
    [anon_sym_LBRACK_DOT] = ACTIONS(57),
    [sym_crossproduct] = ACTIONS(57),
    [sym_compose] = ACTIONS(57),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [279] = {
    [sym_end_comment] = STATE(279),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(288),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(467),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [280] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(487),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(280),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [281] = {
    [sym_end_comment] = STATE(281),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_RBRACK] = ACTIONS(481),
    [sym_symbol] = ACTIONS(479),
    [sym_string] = ACTIONS(481),
    [sym_any] = ACTIONS(481),
    [sym_zero] = ACTIONS(481),
    [sym_boundary] = ACTIONS(481),
    [sym_symbol_group] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_RPAREN] = ACTIONS(481),
    [anon_sym_BQUOTE] = ACTIONS(481),
    [anon_sym_COMMA] = ACTIONS(479),
    [sym_colon] = ACTIONS(481),
    [sym_complement] = ACTIONS(481),
    [sym_term_complement] = ACTIONS(479),
    [sym_contains] = ACTIONS(481),
    [sym_plus] = ACTIONS(481),
    [sym_star] = ACTIONS(481),
    [sym_repeat] = ACTIONS(481),
    [sym_upper] = ACTIONS(481),
    [sym_lower] = ACTIONS(481),
    [sym_reverse] = ACTIONS(481),
    [sym_inverse] = ACTIONS(481),
    [sym_ignore] = ACTIONS(479),
    [sym_ignore_inside] = ACTIONS(481),
    [sym_union] = ACTIONS(479),
    [sym_intersect] = ACTIONS(481),
    [sym_subtract] = ACTIONS(479),
    [anon_sym_EQ_GT] = ACTIONS(481),
    [anon_sym_DASH_GT] = ACTIONS(479),
    [anon_sym_LT_DASH] = ACTIONS(481),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(481),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(481),
    [anon_sym_AT_DASH_GT] = ACTIONS(481),
    [anon_sym_DASH_GT_AT] = ACTIONS(481),
    [anon_sym_AT_GT] = ACTIONS(481),
    [anon_sym_GT_AT] = ACTIONS(481),
    [anon_sym_LBRACK_DOT] = ACTIONS(481),
    [anon_sym_DOT_RBRACK] = ACTIONS(481),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_SLASH_SLASH] = ACTIONS(481),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(481),
    [anon_sym_BSLASH_SLASH] = ACTIONS(481),
    [anon_sym_COMMA_COMMA] = ACTIONS(481),
    [sym_crossproduct] = ACTIONS(481),
    [sym_compose] = ACTIONS(481),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_END] = ACTIONS(43),
  },
  [282] = {
    [sym_end_comment] = STATE(282),
    [anon_sym_LBRACK] = ACTIONS(483),
    [anon_sym_RBRACK] = ACTIONS(485),
    [sym_symbol] = ACTIONS(483),
    [sym_string] = ACTIONS(485),
    [sym_any] = ACTIONS(485),
    [sym_zero] = ACTIONS(485),
    [sym_boundary] = ACTIONS(485),
    [sym_symbol_group] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(483),
    [anon_sym_RPAREN] = ACTIONS(485),
    [anon_sym_BQUOTE] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(483),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(485),
    [sym_term_complement] = ACTIONS(483),
    [sym_contains] = ACTIONS(485),
    [sym_plus] = ACTIONS(485),
    [sym_star] = ACTIONS(485),
    [sym_repeat] = ACTIONS(485),
    [sym_upper] = ACTIONS(485),
    [sym_lower] = ACTIONS(485),
    [sym_reverse] = ACTIONS(485),
    [sym_inverse] = ACTIONS(485),
    [sym_ignore] = ACTIONS(483),
    [sym_ignore_inside] = ACTIONS(485),
    [sym_union] = ACTIONS(483),
    [sym_intersect] = ACTIONS(485),
    [sym_subtract] = ACTIONS(483),
    [anon_sym_EQ_GT] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_LT_DASH] = ACTIONS(485),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(485),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(485),
    [anon_sym_AT_DASH_GT] = ACTIONS(485),
    [anon_sym_DASH_GT_AT] = ACTIONS(485),
    [anon_sym_AT_GT] = ACTIONS(485),
    [anon_sym_GT_AT] = ACTIONS(485),
    [anon_sym_LBRACK_DOT] = ACTIONS(485),
    [anon_sym_DOT_RBRACK] = ACTIONS(485),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_SLASH_SLASH] = ACTIONS(485),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(485),
    [anon_sym_BSLASH_SLASH] = ACTIONS(485),
    [anon_sym_COMMA_COMMA] = ACTIONS(485),
    [sym_crossproduct] = ACTIONS(485),
    [sym_compose] = ACTIONS(485),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(483),
    [anon_sym_END] = ACTIONS(43),
  },
  [283] = {
    [sym_end_comment] = STATE(283),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(55),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_END] = ACTIONS(43),
  },
  [284] = {
    [sym_end_comment] = STATE(284),
    [aux_sym_context_list_repeat1] = STATE(284),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(487),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [285] = {
    [sym_expression] = STATE(163),
    [sym_optional] = STATE(393),
    [sym_substitute] = STATE(393),
    [sym_restrict] = STATE(393),
    [sym_arrow] = STATE(493),
    [sym_simple_replace] = STATE(255),
    [sym_single_replace] = STATE(255),
    [sym_mark] = STATE(393),
    [sym_parallel_replace] = STATE(315),
    [sym_conditional_replace] = STATE(392),
    [sym_parallel_conditional_replace] = STATE(393),
    [sym_end_comment] = STATE(285),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [sym_colon] = ACTIONS(285),
    [sym_complement] = ACTIONS(287),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(287),
    [sym_plus] = ACTIONS(245),
    [sym_star] = ACTIONS(245),
    [sym_repeat] = ACTIONS(245),
    [sym_upper] = ACTIONS(245),
    [sym_lower] = ACTIONS(245),
    [sym_reverse] = ACTIONS(245),
    [sym_inverse] = ACTIONS(245),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(289),
    [sym_union] = ACTIONS(291),
    [sym_intersect] = ACTIONS(291),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(295),
    [anon_sym_DASH_GT] = ACTIONS(85),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(151),
    [sym_crossproduct] = ACTIONS(347),
    [sym_compose] = ACTIONS(347),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [286] = {
    [sym_end_comment] = STATE(286),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(453),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [287] = {
    [sym_end_comment] = STATE(287),
    [aux_sym_parallel_replace_repeat1] = STATE(295),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(445),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_RBRACK] = ACTIONS(445),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_END] = ACTIONS(43),
  },
  [288] = {
    [sym_end_comment] = STATE(288),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(275),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(371),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [289] = {
    [sym_end_comment] = STATE(289),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [290] = {
    [sym_end_comment] = STATE(290),
    [anon_sym_LBRACK] = ACTIONS(490),
    [anon_sym_RBRACK] = ACTIONS(492),
    [sym_symbol] = ACTIONS(490),
    [sym_string] = ACTIONS(492),
    [sym_any] = ACTIONS(492),
    [sym_zero] = ACTIONS(492),
    [sym_boundary] = ACTIONS(492),
    [sym_symbol_group] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_RPAREN] = ACTIONS(492),
    [anon_sym_BQUOTE] = ACTIONS(492),
    [anon_sym_COMMA] = ACTIONS(490),
    [sym_colon] = ACTIONS(492),
    [sym_complement] = ACTIONS(492),
    [sym_term_complement] = ACTIONS(490),
    [sym_contains] = ACTIONS(492),
    [sym_plus] = ACTIONS(492),
    [sym_star] = ACTIONS(492),
    [sym_repeat] = ACTIONS(492),
    [sym_upper] = ACTIONS(492),
    [sym_lower] = ACTIONS(492),
    [sym_reverse] = ACTIONS(492),
    [sym_inverse] = ACTIONS(492),
    [sym_ignore] = ACTIONS(490),
    [sym_ignore_inside] = ACTIONS(492),
    [sym_union] = ACTIONS(490),
    [sym_intersect] = ACTIONS(492),
    [sym_subtract] = ACTIONS(490),
    [anon_sym_EQ_GT] = ACTIONS(492),
    [anon_sym_DASH_GT] = ACTIONS(490),
    [anon_sym_LT_DASH] = ACTIONS(492),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(492),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(492),
    [anon_sym_AT_DASH_GT] = ACTIONS(492),
    [anon_sym_DASH_GT_AT] = ACTIONS(492),
    [anon_sym_AT_GT] = ACTIONS(492),
    [anon_sym_GT_AT] = ACTIONS(492),
    [anon_sym_LBRACK_DOT] = ACTIONS(492),
    [anon_sym_DOT_RBRACK] = ACTIONS(492),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(492),
    [anon_sym_PIPE_PIPE] = ACTIONS(492),
    [anon_sym_SLASH_SLASH] = ACTIONS(492),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(492),
    [anon_sym_BSLASH_SLASH] = ACTIONS(492),
    [anon_sym_COMMA_COMMA] = ACTIONS(492),
    [sym_crossproduct] = ACTIONS(492),
    [sym_compose] = ACTIONS(492),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(490),
    [anon_sym_END] = ACTIONS(43),
  },
  [291] = {
    [sym_condition_operators] = STATE(438),
    [sym_end_comment] = STATE(291),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [292] = {
    [sym_end_comment] = STATE(292),
    [anon_sym_LBRACK] = ACTIONS(494),
    [anon_sym_RBRACK] = ACTIONS(496),
    [sym_symbol] = ACTIONS(494),
    [sym_string] = ACTIONS(496),
    [sym_any] = ACTIONS(496),
    [sym_zero] = ACTIONS(496),
    [sym_boundary] = ACTIONS(496),
    [sym_symbol_group] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_RPAREN] = ACTIONS(496),
    [anon_sym_BQUOTE] = ACTIONS(496),
    [anon_sym_COMMA] = ACTIONS(494),
    [sym_colon] = ACTIONS(496),
    [sym_complement] = ACTIONS(496),
    [sym_term_complement] = ACTIONS(494),
    [sym_contains] = ACTIONS(496),
    [sym_plus] = ACTIONS(496),
    [sym_star] = ACTIONS(496),
    [sym_repeat] = ACTIONS(496),
    [sym_upper] = ACTIONS(496),
    [sym_lower] = ACTIONS(496),
    [sym_reverse] = ACTIONS(496),
    [sym_inverse] = ACTIONS(496),
    [sym_ignore] = ACTIONS(494),
    [sym_ignore_inside] = ACTIONS(496),
    [sym_union] = ACTIONS(494),
    [sym_intersect] = ACTIONS(496),
    [sym_subtract] = ACTIONS(494),
    [anon_sym_EQ_GT] = ACTIONS(496),
    [anon_sym_DASH_GT] = ACTIONS(494),
    [anon_sym_LT_DASH] = ACTIONS(496),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(496),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(496),
    [anon_sym_AT_DASH_GT] = ACTIONS(496),
    [anon_sym_DASH_GT_AT] = ACTIONS(496),
    [anon_sym_AT_GT] = ACTIONS(496),
    [anon_sym_GT_AT] = ACTIONS(496),
    [anon_sym_LBRACK_DOT] = ACTIONS(496),
    [anon_sym_DOT_RBRACK] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(496),
    [anon_sym_PIPE_PIPE] = ACTIONS(496),
    [anon_sym_SLASH_SLASH] = ACTIONS(496),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(496),
    [anon_sym_BSLASH_SLASH] = ACTIONS(496),
    [anon_sym_COMMA_COMMA] = ACTIONS(496),
    [sym_crossproduct] = ACTIONS(496),
    [sym_compose] = ACTIONS(496),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(494),
    [anon_sym_END] = ACTIONS(43),
  },
  [293] = {
    [sym_end_comment] = STATE(293),
    [anon_sym_LBRACK] = ACTIONS(498),
    [anon_sym_RBRACK] = ACTIONS(500),
    [sym_symbol] = ACTIONS(498),
    [sym_string] = ACTIONS(500),
    [sym_any] = ACTIONS(500),
    [sym_zero] = ACTIONS(500),
    [sym_boundary] = ACTIONS(500),
    [sym_symbol_group] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_RPAREN] = ACTIONS(500),
    [anon_sym_BQUOTE] = ACTIONS(500),
    [anon_sym_COMMA] = ACTIONS(498),
    [sym_colon] = ACTIONS(500),
    [sym_complement] = ACTIONS(500),
    [sym_term_complement] = ACTIONS(498),
    [sym_contains] = ACTIONS(500),
    [sym_plus] = ACTIONS(500),
    [sym_star] = ACTIONS(500),
    [sym_repeat] = ACTIONS(500),
    [sym_upper] = ACTIONS(500),
    [sym_lower] = ACTIONS(500),
    [sym_reverse] = ACTIONS(500),
    [sym_inverse] = ACTIONS(500),
    [sym_ignore] = ACTIONS(498),
    [sym_ignore_inside] = ACTIONS(500),
    [sym_union] = ACTIONS(498),
    [sym_intersect] = ACTIONS(500),
    [sym_subtract] = ACTIONS(498),
    [anon_sym_EQ_GT] = ACTIONS(500),
    [anon_sym_DASH_GT] = ACTIONS(498),
    [anon_sym_LT_DASH] = ACTIONS(500),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(500),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(500),
    [anon_sym_AT_DASH_GT] = ACTIONS(500),
    [anon_sym_DASH_GT_AT] = ACTIONS(500),
    [anon_sym_AT_GT] = ACTIONS(500),
    [anon_sym_GT_AT] = ACTIONS(500),
    [anon_sym_LBRACK_DOT] = ACTIONS(500),
    [anon_sym_DOT_RBRACK] = ACTIONS(500),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(500),
    [anon_sym_PIPE_PIPE] = ACTIONS(500),
    [anon_sym_SLASH_SLASH] = ACTIONS(500),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(500),
    [anon_sym_BSLASH_SLASH] = ACTIONS(500),
    [anon_sym_COMMA_COMMA] = ACTIONS(500),
    [sym_crossproduct] = ACTIONS(500),
    [sym_compose] = ACTIONS(500),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(498),
    [anon_sym_END] = ACTIONS(43),
  },
  [294] = {
    [sym_end_comment] = STATE(294),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_RBRACK] = ACTIONS(15),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(15),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_RBRACK] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(25),
    [anon_sym_END] = ACTIONS(43),
  },
  [295] = {
    [sym_end_comment] = STATE(295),
    [aux_sym_parallel_replace_repeat1] = STATE(295),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(333),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(502),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_RBRACK] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_END] = ACTIONS(43),
  },
  [296] = {
    [sym_condition_operators] = STATE(441),
    [sym_end_comment] = STATE(296),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(331),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(331),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [297] = {
    [sym_end_comment] = STATE(297),
    [aux_sym_parallel_replace_repeat1] = STATE(299),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(445),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_RBRACK] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_END] = ACTIONS(43),
  },
  [298] = {
    [sym_end_comment] = STATE(298),
    [aux_sym_context_list_repeat1] = STATE(302),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [299] = {
    [sym_end_comment] = STATE(299),
    [aux_sym_parallel_replace_repeat1] = STATE(299),
    [anon_sym_LBRACK] = ACTIONS(331),
    [anon_sym_RBRACK] = ACTIONS(333),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(505),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_RBRACK] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_END] = ACTIONS(43),
  },
  [300] = {
    [sym_end_comment] = STATE(300),
    [aux_sym_context_list_repeat1] = STATE(300),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(508),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [301] = {
    [sym_end_comment] = STATE(301),
    [aux_sym_parallel_replace_repeat1] = STATE(299),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_RBRACK] = ACTIONS(445),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(445),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_RBRACK] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_END] = ACTIONS(43),
  },
  [302] = {
    [sym_end_comment] = STATE(302),
    [aux_sym_context_list_repeat1] = STATE(300),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [303] = {
    [sym_condition_operators] = STATE(445),
    [sym_end_comment] = STATE(303),
    [aux_sym_parallel_replace_repeat1] = STATE(309),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(511),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [304] = {
    [sym_end_comment] = STATE(304),
    [aux_sym_context_list_repeat1] = STATE(304),
    [anon_sym_LBRACK] = ACTIONS(453),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(513),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym__] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [305] = {
    [sym_end_comment] = STATE(305),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(308),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(516),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [306] = {
    [sym_condition_operators] = STATE(445),
    [sym_end_comment] = STATE(306),
    [aux_sym_parallel_replace_repeat1] = STATE(329),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(518),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [307] = {
    [sym_end_comment] = STATE(307),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(317),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(516),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [308] = {
    [sym_end_comment] = STATE(308),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(314),
    [anon_sym_LBRACK] = ACTIONS(369),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym__] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(371),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [309] = {
    [sym_end_comment] = STATE(309),
    [aux_sym_parallel_replace_repeat1] = STATE(312),
    [anon_sym_LBRACK] = ACTIONS(443),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(443),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym__] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [anon_sym_COMMA_COMMA] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [310] = {
    [sym_end_comment] = STATE(310),
    [aux_sym_context_list_repeat1] = STATE(311),
    [anon_sym_LBRACK] = ACTIONS(404),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(404),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym__] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [311] = {
    [sym_end_comment] = STATE(311),
    [aux_sym_context_list_repeat1] = STATE(304),
    [anon_sym_LBRACK] = ACTIONS(437),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(437),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym__] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [312] = {
    [sym_end_comment] = STATE(312),
    [aux_sym_parallel_replace_repeat1] = STATE(312),
    [anon_sym_LBRACK] = ACTIONS(331),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(520),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [313] = {
    [sym_condition_operators] = STATE(445),
    [sym_end_comment] = STATE(313),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [314] = {
    [sym_end_comment] = STATE(314),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(314),
    [anon_sym_LBRACK] = ACTIONS(389),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym__] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(523),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [315] = {
    [sym_condition_operators] = STATE(441),
    [sym_end_comment] = STATE(315),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [316] = {
    [sym_end_comment] = STATE(316),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(389),
    [anon_sym_LBRACK] = ACTIONS(389),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym__] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(391),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [317] = {
    [sym_end_comment] = STATE(317),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(314),
    [anon_sym_LBRACK] = ACTIONS(369),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym__] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(516),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [318] = {
    [sym_condition_operators] = STATE(451),
    [sym_end_comment] = STATE(318),
    [aux_sym_parallel_replace_repeat1] = STATE(333),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(526),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [319] = {
    [sym_condition_operators] = STATE(449),
    [sym_end_comment] = STATE(319),
    [aux_sym_parallel_replace_repeat1] = STATE(333),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(526),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [320] = {
    [sym_end_comment] = STATE(320),
    [anon_sym_LBRACK] = ACTIONS(498),
    [sym_symbol] = ACTIONS(498),
    [sym_string] = ACTIONS(500),
    [sym_any] = ACTIONS(500),
    [sym_zero] = ACTIONS(500),
    [sym_boundary] = ACTIONS(500),
    [sym_symbol_group] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_BQUOTE] = ACTIONS(500),
    [anon_sym_COMMA] = ACTIONS(498),
    [sym_colon] = ACTIONS(500),
    [sym_complement] = ACTIONS(500),
    [sym_term_complement] = ACTIONS(498),
    [sym_contains] = ACTIONS(500),
    [sym_plus] = ACTIONS(500),
    [sym_star] = ACTIONS(500),
    [sym_repeat] = ACTIONS(500),
    [sym_upper] = ACTIONS(500),
    [sym_lower] = ACTIONS(500),
    [sym_reverse] = ACTIONS(500),
    [sym_inverse] = ACTIONS(500),
    [sym_ignore] = ACTIONS(498),
    [sym_ignore_inside] = ACTIONS(500),
    [sym_union] = ACTIONS(498),
    [sym_intersect] = ACTIONS(500),
    [sym_subtract] = ACTIONS(498),
    [anon_sym__] = ACTIONS(498),
    [anon_sym_EQ_GT] = ACTIONS(500),
    [anon_sym_DASH_GT] = ACTIONS(498),
    [anon_sym_LT_DASH] = ACTIONS(500),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(500),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(500),
    [anon_sym_AT_DASH_GT] = ACTIONS(500),
    [anon_sym_DASH_GT_AT] = ACTIONS(500),
    [anon_sym_AT_GT] = ACTIONS(500),
    [anon_sym_GT_AT] = ACTIONS(500),
    [anon_sym_LBRACK_DOT] = ACTIONS(500),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(500),
    [anon_sym_PIPE_PIPE] = ACTIONS(500),
    [anon_sym_SLASH_SLASH] = ACTIONS(500),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(500),
    [anon_sym_BSLASH_SLASH] = ACTIONS(500),
    [anon_sym_COMMA_COMMA] = ACTIONS(500),
    [sym_crossproduct] = ACTIONS(500),
    [sym_compose] = ACTIONS(500),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [321] = {
    [sym_end_comment] = STATE(321),
    [aux_sym_parallel_replace_repeat1] = STATE(321),
    [anon_sym_LBRACK] = ACTIONS(331),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(528),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [322] = {
    [sym_end_comment] = STATE(322),
    [anon_sym_LBRACK] = ACTIONS(483),
    [sym_symbol] = ACTIONS(483),
    [sym_string] = ACTIONS(485),
    [sym_any] = ACTIONS(485),
    [sym_zero] = ACTIONS(485),
    [sym_boundary] = ACTIONS(485),
    [sym_symbol_group] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(483),
    [anon_sym_BQUOTE] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(483),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(485),
    [sym_term_complement] = ACTIONS(483),
    [sym_contains] = ACTIONS(485),
    [sym_plus] = ACTIONS(485),
    [sym_star] = ACTIONS(485),
    [sym_repeat] = ACTIONS(485),
    [sym_upper] = ACTIONS(485),
    [sym_lower] = ACTIONS(485),
    [sym_reverse] = ACTIONS(485),
    [sym_inverse] = ACTIONS(485),
    [sym_ignore] = ACTIONS(483),
    [sym_ignore_inside] = ACTIONS(485),
    [sym_union] = ACTIONS(483),
    [sym_intersect] = ACTIONS(485),
    [sym_subtract] = ACTIONS(483),
    [anon_sym__] = ACTIONS(483),
    [anon_sym_EQ_GT] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(483),
    [anon_sym_LT_DASH] = ACTIONS(485),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(485),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(485),
    [anon_sym_AT_DASH_GT] = ACTIONS(485),
    [anon_sym_DASH_GT_AT] = ACTIONS(485),
    [anon_sym_AT_GT] = ACTIONS(485),
    [anon_sym_GT_AT] = ACTIONS(485),
    [anon_sym_LBRACK_DOT] = ACTIONS(485),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_SLASH_SLASH] = ACTIONS(485),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(485),
    [anon_sym_BSLASH_SLASH] = ACTIONS(485),
    [anon_sym_COMMA_COMMA] = ACTIONS(485),
    [sym_crossproduct] = ACTIONS(485),
    [sym_compose] = ACTIONS(485),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [323] = {
    [sym_end_comment] = STATE(323),
    [aux_sym_parallel_replace_repeat1] = STATE(323),
    [anon_sym_LBRACK] = ACTIONS(331),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(531),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [anon_sym_COMMA_COMMA] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [324] = {
    [sym_end_comment] = STATE(324),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(349),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(534),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [325] = {
    [sym_end_comment] = STATE(325),
    [anon_sym_LBRACK] = ACTIONS(25),
    [sym_symbol] = ACTIONS(25),
    [sym_string] = ACTIONS(15),
    [sym_any] = ACTIONS(15),
    [sym_zero] = ACTIONS(15),
    [sym_boundary] = ACTIONS(15),
    [sym_symbol_group] = ACTIONS(15),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_BQUOTE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(25),
    [sym_colon] = ACTIONS(15),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(25),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(15),
    [sym_star] = ACTIONS(15),
    [sym_repeat] = ACTIONS(15),
    [sym_upper] = ACTIONS(15),
    [sym_lower] = ACTIONS(15),
    [sym_reverse] = ACTIONS(15),
    [sym_inverse] = ACTIONS(15),
    [sym_ignore] = ACTIONS(25),
    [sym_ignore_inside] = ACTIONS(15),
    [sym_union] = ACTIONS(25),
    [sym_intersect] = ACTIONS(15),
    [sym_subtract] = ACTIONS(25),
    [anon_sym__] = ACTIONS(25),
    [anon_sym_EQ_GT] = ACTIONS(15),
    [anon_sym_DASH_GT] = ACTIONS(25),
    [anon_sym_LT_DASH] = ACTIONS(15),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(15),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(15),
    [anon_sym_AT_DASH_GT] = ACTIONS(15),
    [anon_sym_DASH_GT_AT] = ACTIONS(15),
    [anon_sym_AT_GT] = ACTIONS(15),
    [anon_sym_GT_AT] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(15),
    [anon_sym_PIPE_PIPE] = ACTIONS(15),
    [anon_sym_SLASH_SLASH] = ACTIONS(15),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(15),
    [anon_sym_BSLASH_SLASH] = ACTIONS(15),
    [anon_sym_COMMA_COMMA] = ACTIONS(15),
    [sym_crossproduct] = ACTIONS(15),
    [sym_compose] = ACTIONS(15),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [326] = {
    [sym_end_comment] = STATE(326),
    [anon_sym_LBRACK] = ACTIONS(494),
    [sym_symbol] = ACTIONS(494),
    [sym_string] = ACTIONS(496),
    [sym_any] = ACTIONS(496),
    [sym_zero] = ACTIONS(496),
    [sym_boundary] = ACTIONS(496),
    [sym_symbol_group] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_BQUOTE] = ACTIONS(496),
    [anon_sym_COMMA] = ACTIONS(494),
    [sym_colon] = ACTIONS(496),
    [sym_complement] = ACTIONS(496),
    [sym_term_complement] = ACTIONS(494),
    [sym_contains] = ACTIONS(496),
    [sym_plus] = ACTIONS(496),
    [sym_star] = ACTIONS(496),
    [sym_repeat] = ACTIONS(496),
    [sym_upper] = ACTIONS(496),
    [sym_lower] = ACTIONS(496),
    [sym_reverse] = ACTIONS(496),
    [sym_inverse] = ACTIONS(496),
    [sym_ignore] = ACTIONS(494),
    [sym_ignore_inside] = ACTIONS(496),
    [sym_union] = ACTIONS(494),
    [sym_intersect] = ACTIONS(496),
    [sym_subtract] = ACTIONS(494),
    [anon_sym__] = ACTIONS(494),
    [anon_sym_EQ_GT] = ACTIONS(496),
    [anon_sym_DASH_GT] = ACTIONS(494),
    [anon_sym_LT_DASH] = ACTIONS(496),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(496),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(496),
    [anon_sym_AT_DASH_GT] = ACTIONS(496),
    [anon_sym_DASH_GT_AT] = ACTIONS(496),
    [anon_sym_AT_GT] = ACTIONS(496),
    [anon_sym_GT_AT] = ACTIONS(496),
    [anon_sym_LBRACK_DOT] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(496),
    [anon_sym_PIPE_PIPE] = ACTIONS(496),
    [anon_sym_SLASH_SLASH] = ACTIONS(496),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(496),
    [anon_sym_BSLASH_SLASH] = ACTIONS(496),
    [anon_sym_COMMA_COMMA] = ACTIONS(496),
    [sym_crossproduct] = ACTIONS(496),
    [sym_compose] = ACTIONS(496),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [327] = {
    [sym_condition_operators] = STATE(434),
    [sym_end_comment] = STATE(327),
    [aux_sym_parallel_replace_repeat1] = STATE(356),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(536),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [328] = {
    [sym_end_comment] = STATE(328),
    [anon_sym_LBRACK] = ACTIONS(490),
    [sym_symbol] = ACTIONS(490),
    [sym_string] = ACTIONS(492),
    [sym_any] = ACTIONS(492),
    [sym_zero] = ACTIONS(492),
    [sym_boundary] = ACTIONS(492),
    [sym_symbol_group] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_BQUOTE] = ACTIONS(492),
    [anon_sym_COMMA] = ACTIONS(490),
    [sym_colon] = ACTIONS(492),
    [sym_complement] = ACTIONS(492),
    [sym_term_complement] = ACTIONS(490),
    [sym_contains] = ACTIONS(492),
    [sym_plus] = ACTIONS(492),
    [sym_star] = ACTIONS(492),
    [sym_repeat] = ACTIONS(492),
    [sym_upper] = ACTIONS(492),
    [sym_lower] = ACTIONS(492),
    [sym_reverse] = ACTIONS(492),
    [sym_inverse] = ACTIONS(492),
    [sym_ignore] = ACTIONS(490),
    [sym_ignore_inside] = ACTIONS(492),
    [sym_union] = ACTIONS(490),
    [sym_intersect] = ACTIONS(492),
    [sym_subtract] = ACTIONS(490),
    [anon_sym__] = ACTIONS(490),
    [anon_sym_EQ_GT] = ACTIONS(492),
    [anon_sym_DASH_GT] = ACTIONS(490),
    [anon_sym_LT_DASH] = ACTIONS(492),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(492),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(492),
    [anon_sym_AT_DASH_GT] = ACTIONS(492),
    [anon_sym_DASH_GT_AT] = ACTIONS(492),
    [anon_sym_AT_GT] = ACTIONS(492),
    [anon_sym_GT_AT] = ACTIONS(492),
    [anon_sym_LBRACK_DOT] = ACTIONS(492),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(492),
    [anon_sym_PIPE_PIPE] = ACTIONS(492),
    [anon_sym_SLASH_SLASH] = ACTIONS(492),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(492),
    [anon_sym_BSLASH_SLASH] = ACTIONS(492),
    [anon_sym_COMMA_COMMA] = ACTIONS(492),
    [sym_crossproduct] = ACTIONS(492),
    [sym_compose] = ACTIONS(492),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [329] = {
    [sym_end_comment] = STATE(329),
    [aux_sym_parallel_replace_repeat1] = STATE(321),
    [anon_sym_LBRACK] = ACTIONS(443),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym__] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [330] = {
    [sym_end_comment] = STATE(330),
    [aux_sym_context_list_repeat1] = STATE(346),
    [anon_sym_LBRACK] = ACTIONS(404),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(404),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym__] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [331] = {
    [sym_end_comment] = STATE(331),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(343),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(534),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [332] = {
    [sym_condition_operators] = STATE(451),
    [sym_end_comment] = STATE(332),
    [aux_sym_parallel_replace_repeat1] = STATE(367),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(536),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [333] = {
    [sym_end_comment] = STATE(333),
    [aux_sym_parallel_replace_repeat1] = STATE(323),
    [anon_sym_LBRACK] = ACTIONS(443),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(443),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym__] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [anon_sym_COMMA_COMMA] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [334] = {
    [sym_end_comment] = STATE(334),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(55),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [335] = {
    [sym_condition_operators] = STATE(451),
    [sym_end_comment] = STATE(335),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [336] = {
    [sym_condition_operators] = STATE(449),
    [sym_end_comment] = STATE(336),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [337] = {
    [sym_end_comment] = STATE(337),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(337),
    [anon_sym_LBRACK] = ACTIONS(389),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(389),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(389),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(389),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym__] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_SLASH_SLASH] = ACTIONS(391),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(391),
    [anon_sym_BSLASH_SLASH] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(538),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [338] = {
    [sym_end_comment] = STATE(338),
    [anon_sym_LBRACK] = ACTIONS(475),
    [sym_symbol] = ACTIONS(475),
    [sym_string] = ACTIONS(477),
    [sym_any] = ACTIONS(477),
    [sym_zero] = ACTIONS(477),
    [sym_boundary] = ACTIONS(477),
    [sym_symbol_group] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_BQUOTE] = ACTIONS(477),
    [anon_sym_COMMA] = ACTIONS(475),
    [sym_colon] = ACTIONS(477),
    [sym_complement] = ACTIONS(477),
    [sym_term_complement] = ACTIONS(475),
    [sym_contains] = ACTIONS(477),
    [sym_plus] = ACTIONS(477),
    [sym_star] = ACTIONS(477),
    [sym_repeat] = ACTIONS(477),
    [sym_upper] = ACTIONS(477),
    [sym_lower] = ACTIONS(477),
    [sym_reverse] = ACTIONS(477),
    [sym_inverse] = ACTIONS(477),
    [sym_ignore] = ACTIONS(475),
    [sym_ignore_inside] = ACTIONS(477),
    [sym_union] = ACTIONS(475),
    [sym_intersect] = ACTIONS(477),
    [sym_subtract] = ACTIONS(475),
    [anon_sym__] = ACTIONS(475),
    [anon_sym_EQ_GT] = ACTIONS(477),
    [anon_sym_DASH_GT] = ACTIONS(475),
    [anon_sym_LT_DASH] = ACTIONS(477),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(477),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(477),
    [anon_sym_AT_DASH_GT] = ACTIONS(477),
    [anon_sym_DASH_GT_AT] = ACTIONS(477),
    [anon_sym_AT_GT] = ACTIONS(477),
    [anon_sym_GT_AT] = ACTIONS(477),
    [anon_sym_LBRACK_DOT] = ACTIONS(477),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_SLASH_SLASH] = ACTIONS(477),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(477),
    [anon_sym_BSLASH_SLASH] = ACTIONS(477),
    [anon_sym_COMMA_COMMA] = ACTIONS(477),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [339] = {
    [sym_end_comment] = STATE(339),
    [anon_sym_LBRACK] = ACTIONS(479),
    [sym_symbol] = ACTIONS(479),
    [sym_string] = ACTIONS(481),
    [sym_any] = ACTIONS(481),
    [sym_zero] = ACTIONS(481),
    [sym_boundary] = ACTIONS(481),
    [sym_symbol_group] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_BQUOTE] = ACTIONS(481),
    [anon_sym_COMMA] = ACTIONS(479),
    [sym_colon] = ACTIONS(481),
    [sym_complement] = ACTIONS(481),
    [sym_term_complement] = ACTIONS(479),
    [sym_contains] = ACTIONS(481),
    [sym_plus] = ACTIONS(481),
    [sym_star] = ACTIONS(481),
    [sym_repeat] = ACTIONS(481),
    [sym_upper] = ACTIONS(481),
    [sym_lower] = ACTIONS(481),
    [sym_reverse] = ACTIONS(481),
    [sym_inverse] = ACTIONS(481),
    [sym_ignore] = ACTIONS(479),
    [sym_ignore_inside] = ACTIONS(481),
    [sym_union] = ACTIONS(479),
    [sym_intersect] = ACTIONS(481),
    [sym_subtract] = ACTIONS(479),
    [anon_sym__] = ACTIONS(479),
    [anon_sym_EQ_GT] = ACTIONS(481),
    [anon_sym_DASH_GT] = ACTIONS(479),
    [anon_sym_LT_DASH] = ACTIONS(481),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(481),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(481),
    [anon_sym_AT_DASH_GT] = ACTIONS(481),
    [anon_sym_DASH_GT_AT] = ACTIONS(481),
    [anon_sym_AT_GT] = ACTIONS(481),
    [anon_sym_GT_AT] = ACTIONS(481),
    [anon_sym_LBRACK_DOT] = ACTIONS(481),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_SLASH_SLASH] = ACTIONS(481),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(481),
    [anon_sym_BSLASH_SLASH] = ACTIONS(481),
    [anon_sym_COMMA_COMMA] = ACTIONS(481),
    [sym_crossproduct] = ACTIONS(481),
    [sym_compose] = ACTIONS(481),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [340] = {
    [sym_end_comment] = STATE(340),
    [aux_sym_context_list_repeat1] = STATE(340),
    [anon_sym_LBRACK] = ACTIONS(453),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(541),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym__] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [341] = {
    [sym_end_comment] = STATE(341),
    [anon_sym_LBRACK] = ACTIONS(453),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(453),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym__] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [342] = {
    [sym_end_comment] = STATE(342),
    [anon_sym_LBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(53),
    [sym_string] = ACTIONS(55),
    [sym_any] = ACTIONS(55),
    [sym_zero] = ACTIONS(55),
    [sym_boundary] = ACTIONS(55),
    [sym_symbol_group] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(55),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(55),
    [sym_complement] = ACTIONS(55),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(55),
    [sym_plus] = ACTIONS(55),
    [sym_star] = ACTIONS(55),
    [sym_repeat] = ACTIONS(55),
    [sym_upper] = ACTIONS(55),
    [sym_lower] = ACTIONS(55),
    [sym_reverse] = ACTIONS(55),
    [sym_inverse] = ACTIONS(55),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(55),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(55),
    [sym_subtract] = ACTIONS(53),
    [anon_sym__] = ACTIONS(53),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(53),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [343] = {
    [sym_end_comment] = STATE(343),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(337),
    [anon_sym_LBRACK] = ACTIONS(369),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym__] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(534),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [344] = {
    [sym_end_comment] = STATE(344),
    [aux_sym_context_list_repeat1] = STATE(340),
    [anon_sym_LBRACK] = ACTIONS(437),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym__] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [345] = {
    [sym_end_comment] = STATE(345),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_SLASH_SLASH] = ACTIONS(339),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(339),
    [anon_sym_BSLASH_SLASH] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [346] = {
    [sym_end_comment] = STATE(346),
    [aux_sym_context_list_repeat1] = STATE(347),
    [anon_sym_LBRACK] = ACTIONS(437),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(437),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym__] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [347] = {
    [sym_end_comment] = STATE(347),
    [aux_sym_context_list_repeat1] = STATE(347),
    [anon_sym_LBRACK] = ACTIONS(453),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(544),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym__] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [348] = {
    [sym_end_comment] = STATE(348),
    [aux_sym_context_list_repeat1] = STATE(344),
    [anon_sym_LBRACK] = ACTIONS(404),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym__] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [349] = {
    [sym_end_comment] = STATE(349),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(337),
    [anon_sym_LBRACK] = ACTIONS(369),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(369),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(369),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(369),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym__] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_SLASH_SLASH] = ACTIONS(371),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(371),
    [anon_sym_BSLASH_SLASH] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(371),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [350] = {
    [sym_condition_operators] = STATE(449),
    [sym_end_comment] = STATE(350),
    [aux_sym_parallel_replace_repeat1] = STATE(367),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(536),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym__] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [351] = {
    [sym_end_comment] = STATE(351),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(389),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_RBRACK] = ACTIONS(391),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(391),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(391),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(391),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_RBRACK] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(391),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_END] = ACTIONS(43),
  },
  [352] = {
    [sym_end_comment] = STATE(352),
    [aux_sym_context_list_repeat1] = STATE(358),
    [anon_sym_LBRACK] = ACTIONS(404),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(404),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(404),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(404),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym__] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_PIPE_PIPE] = ACTIONS(406),
    [anon_sym_SLASH_SLASH] = ACTIONS(406),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(406),
    [anon_sym_BSLASH_SLASH] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [353] = {
    [sym_end_comment] = STATE(353),
    [aux_sym_context_list_repeat1] = STATE(362),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(547),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(439),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(439),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(439),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [354] = {
    [sym_end_comment] = STATE(354),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(357),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(371),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(371),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(549),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [355] = {
    [sym_end_comment] = STATE(355),
    [aux_sym_context_list_repeat1] = STATE(353),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(547),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(406),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(406),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(406),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [356] = {
    [sym_end_comment] = STATE(356),
    [aux_sym_parallel_replace_repeat1] = STATE(369),
    [anon_sym_LBRACK] = ACTIONS(443),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(536),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym__] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [357] = {
    [sym_end_comment] = STATE(357),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(357),
    [anon_sym_LBRACK] = ACTIONS(389),
    [anon_sym_RBRACK] = ACTIONS(391),
    [sym_symbol] = ACTIONS(389),
    [sym_string] = ACTIONS(391),
    [sym_any] = ACTIONS(391),
    [sym_zero] = ACTIONS(391),
    [sym_boundary] = ACTIONS(391),
    [sym_symbol_group] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(389),
    [sym_colon] = ACTIONS(391),
    [sym_complement] = ACTIONS(391),
    [sym_term_complement] = ACTIONS(391),
    [sym_contains] = ACTIONS(391),
    [sym_plus] = ACTIONS(391),
    [sym_star] = ACTIONS(391),
    [sym_repeat] = ACTIONS(391),
    [sym_upper] = ACTIONS(391),
    [sym_lower] = ACTIONS(391),
    [sym_reverse] = ACTIONS(391),
    [sym_inverse] = ACTIONS(391),
    [sym_ignore] = ACTIONS(391),
    [sym_ignore_inside] = ACTIONS(391),
    [sym_union] = ACTIONS(391),
    [sym_intersect] = ACTIONS(391),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(389),
    [anon_sym_LT_DASH] = ACTIONS(391),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(391),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(391),
    [anon_sym_AT_DASH_GT] = ACTIONS(391),
    [anon_sym_DASH_GT_AT] = ACTIONS(391),
    [anon_sym_AT_GT] = ACTIONS(391),
    [anon_sym_GT_AT] = ACTIONS(391),
    [anon_sym_LBRACK_DOT] = ACTIONS(391),
    [anon_sym_DOT_RBRACK] = ACTIONS(391),
    [anon_sym_COMMA_COMMA] = ACTIONS(551),
    [sym_crossproduct] = ACTIONS(391),
    [sym_compose] = ACTIONS(391),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_END] = ACTIONS(43),
  },
  [358] = {
    [sym_end_comment] = STATE(358),
    [aux_sym_context_list_repeat1] = STATE(359),
    [anon_sym_LBRACK] = ACTIONS(437),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(437),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(437),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(437),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym__] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_SLASH_SLASH] = ACTIONS(439),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(439),
    [anon_sym_BSLASH_SLASH] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [359] = {
    [sym_end_comment] = STATE(359),
    [aux_sym_context_list_repeat1] = STATE(359),
    [anon_sym_LBRACK] = ACTIONS(453),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(554),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(453),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(453),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(453),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym__] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_SLASH_SLASH] = ACTIONS(455),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(455),
    [anon_sym_BSLASH_SLASH] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [360] = {
    [sym_condition_operators] = STATE(438),
    [sym_end_comment] = STATE(360),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [361] = {
    [sym_end_comment] = STATE(361),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(354),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(339),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(339),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(339),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(549),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [362] = {
    [sym_end_comment] = STATE(362),
    [aux_sym_context_list_repeat1] = STATE(362),
    [anon_sym_LBRACK] = ACTIONS(453),
    [anon_sym_RBRACK] = ACTIONS(455),
    [sym_symbol] = ACTIONS(453),
    [sym_string] = ACTIONS(455),
    [sym_any] = ACTIONS(455),
    [sym_zero] = ACTIONS(455),
    [sym_boundary] = ACTIONS(455),
    [sym_symbol_group] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(557),
    [sym_colon] = ACTIONS(455),
    [sym_complement] = ACTIONS(455),
    [sym_term_complement] = ACTIONS(455),
    [sym_contains] = ACTIONS(455),
    [sym_plus] = ACTIONS(455),
    [sym_star] = ACTIONS(455),
    [sym_repeat] = ACTIONS(455),
    [sym_upper] = ACTIONS(455),
    [sym_lower] = ACTIONS(455),
    [sym_reverse] = ACTIONS(455),
    [sym_inverse] = ACTIONS(455),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(455),
    [sym_intersect] = ACTIONS(455),
    [sym_subtract] = ACTIONS(453),
    [anon_sym_EQ_GT] = ACTIONS(455),
    [anon_sym_DASH_GT] = ACTIONS(453),
    [anon_sym_LT_DASH] = ACTIONS(455),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(455),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(455),
    [anon_sym_AT_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_AT] = ACTIONS(455),
    [anon_sym_AT_GT] = ACTIONS(455),
    [anon_sym_GT_AT] = ACTIONS(455),
    [anon_sym_LBRACK_DOT] = ACTIONS(455),
    [anon_sym_DOT_RBRACK] = ACTIONS(455),
    [anon_sym_COMMA_COMMA] = ACTIONS(455),
    [sym_crossproduct] = ACTIONS(455),
    [sym_compose] = ACTIONS(455),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_END] = ACTIONS(43),
  },
  [363] = {
    [sym_end_comment] = STATE(363),
    [aux_sym_context_list_repeat1] = STATE(366),
    [anon_sym_LBRACK] = ACTIONS(404),
    [anon_sym_RBRACK] = ACTIONS(406),
    [sym_symbol] = ACTIONS(404),
    [sym_string] = ACTIONS(406),
    [sym_any] = ACTIONS(406),
    [sym_zero] = ACTIONS(406),
    [sym_boundary] = ACTIONS(406),
    [sym_symbol_group] = ACTIONS(406),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_BQUOTE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(404),
    [sym_colon] = ACTIONS(406),
    [sym_complement] = ACTIONS(406),
    [sym_term_complement] = ACTIONS(406),
    [sym_contains] = ACTIONS(406),
    [sym_plus] = ACTIONS(406),
    [sym_star] = ACTIONS(406),
    [sym_repeat] = ACTIONS(406),
    [sym_upper] = ACTIONS(406),
    [sym_lower] = ACTIONS(406),
    [sym_reverse] = ACTIONS(406),
    [sym_inverse] = ACTIONS(406),
    [sym_ignore] = ACTIONS(406),
    [sym_ignore_inside] = ACTIONS(406),
    [sym_union] = ACTIONS(406),
    [sym_intersect] = ACTIONS(406),
    [sym_subtract] = ACTIONS(404),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DASH_GT] = ACTIONS(404),
    [anon_sym_LT_DASH] = ACTIONS(406),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(406),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(406),
    [anon_sym_AT_DASH_GT] = ACTIONS(406),
    [anon_sym_DASH_GT_AT] = ACTIONS(406),
    [anon_sym_AT_GT] = ACTIONS(406),
    [anon_sym_GT_AT] = ACTIONS(406),
    [anon_sym_LBRACK_DOT] = ACTIONS(406),
    [anon_sym_DOT_RBRACK] = ACTIONS(406),
    [anon_sym_COMMA_COMMA] = ACTIONS(406),
    [sym_crossproduct] = ACTIONS(406),
    [sym_compose] = ACTIONS(406),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_END] = ACTIONS(43),
  },
  [364] = {
    [sym_condition_operators] = STATE(449),
    [sym_end_comment] = STATE(364),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [365] = {
    [sym_condition_operators] = STATE(443),
    [sym_end_comment] = STATE(365),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [366] = {
    [sym_end_comment] = STATE(366),
    [aux_sym_context_list_repeat1] = STATE(362),
    [anon_sym_LBRACK] = ACTIONS(437),
    [anon_sym_RBRACK] = ACTIONS(439),
    [sym_symbol] = ACTIONS(437),
    [sym_string] = ACTIONS(439),
    [sym_any] = ACTIONS(439),
    [sym_zero] = ACTIONS(439),
    [sym_boundary] = ACTIONS(439),
    [sym_symbol_group] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(437),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(437),
    [sym_colon] = ACTIONS(439),
    [sym_complement] = ACTIONS(439),
    [sym_term_complement] = ACTIONS(439),
    [sym_contains] = ACTIONS(439),
    [sym_plus] = ACTIONS(439),
    [sym_star] = ACTIONS(439),
    [sym_repeat] = ACTIONS(439),
    [sym_upper] = ACTIONS(439),
    [sym_lower] = ACTIONS(439),
    [sym_reverse] = ACTIONS(439),
    [sym_inverse] = ACTIONS(439),
    [sym_ignore] = ACTIONS(439),
    [sym_ignore_inside] = ACTIONS(439),
    [sym_union] = ACTIONS(439),
    [sym_intersect] = ACTIONS(439),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(437),
    [anon_sym_LT_DASH] = ACTIONS(439),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(439),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(439),
    [anon_sym_AT_DASH_GT] = ACTIONS(439),
    [anon_sym_DASH_GT_AT] = ACTIONS(439),
    [anon_sym_AT_GT] = ACTIONS(439),
    [anon_sym_GT_AT] = ACTIONS(439),
    [anon_sym_LBRACK_DOT] = ACTIONS(439),
    [anon_sym_DOT_RBRACK] = ACTIONS(439),
    [anon_sym_COMMA_COMMA] = ACTIONS(439),
    [sym_crossproduct] = ACTIONS(439),
    [sym_compose] = ACTIONS(439),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_END] = ACTIONS(43),
  },
  [367] = {
    [sym_end_comment] = STATE(367),
    [aux_sym_parallel_replace_repeat1] = STATE(369),
    [anon_sym_LBRACK] = ACTIONS(443),
    [sym_symbol] = ACTIONS(443),
    [sym_string] = ACTIONS(445),
    [sym_any] = ACTIONS(445),
    [sym_zero] = ACTIONS(445),
    [sym_boundary] = ACTIONS(445),
    [sym_symbol_group] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_BQUOTE] = ACTIONS(445),
    [anon_sym_COMMA] = ACTIONS(445),
    [sym_colon] = ACTIONS(445),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(443),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(445),
    [sym_star] = ACTIONS(445),
    [sym_repeat] = ACTIONS(445),
    [sym_upper] = ACTIONS(445),
    [sym_lower] = ACTIONS(445),
    [sym_reverse] = ACTIONS(445),
    [sym_inverse] = ACTIONS(445),
    [sym_ignore] = ACTIONS(443),
    [sym_ignore_inside] = ACTIONS(445),
    [sym_union] = ACTIONS(443),
    [sym_intersect] = ACTIONS(445),
    [sym_subtract] = ACTIONS(443),
    [anon_sym__] = ACTIONS(443),
    [anon_sym_EQ_GT] = ACTIONS(445),
    [anon_sym_DASH_GT] = ACTIONS(443),
    [anon_sym_LT_DASH] = ACTIONS(445),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(445),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(445),
    [anon_sym_AT_DASH_GT] = ACTIONS(445),
    [anon_sym_DASH_GT_AT] = ACTIONS(445),
    [anon_sym_AT_GT] = ACTIONS(445),
    [anon_sym_GT_AT] = ACTIONS(445),
    [anon_sym_LBRACK_DOT] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_SLASH_SLASH] = ACTIONS(445),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(445),
    [anon_sym_BSLASH_SLASH] = ACTIONS(445),
    [sym_crossproduct] = ACTIONS(445),
    [sym_compose] = ACTIONS(445),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [368] = {
    [sym_condition_operators] = STATE(434),
    [sym_end_comment] = STATE(368),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [369] = {
    [sym_end_comment] = STATE(369),
    [aux_sym_parallel_replace_repeat1] = STATE(369),
    [anon_sym_LBRACK] = ACTIONS(331),
    [sym_symbol] = ACTIONS(331),
    [sym_string] = ACTIONS(333),
    [sym_any] = ACTIONS(333),
    [sym_zero] = ACTIONS(333),
    [sym_boundary] = ACTIONS(333),
    [sym_symbol_group] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(560),
    [sym_colon] = ACTIONS(333),
    [sym_complement] = ACTIONS(333),
    [sym_term_complement] = ACTIONS(331),
    [sym_contains] = ACTIONS(333),
    [sym_plus] = ACTIONS(333),
    [sym_star] = ACTIONS(333),
    [sym_repeat] = ACTIONS(333),
    [sym_upper] = ACTIONS(333),
    [sym_lower] = ACTIONS(333),
    [sym_reverse] = ACTIONS(333),
    [sym_inverse] = ACTIONS(333),
    [sym_ignore] = ACTIONS(331),
    [sym_ignore_inside] = ACTIONS(333),
    [sym_union] = ACTIONS(331),
    [sym_intersect] = ACTIONS(333),
    [sym_subtract] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
    [anon_sym_EQ_GT] = ACTIONS(333),
    [anon_sym_DASH_GT] = ACTIONS(331),
    [anon_sym_LT_DASH] = ACTIONS(333),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(333),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(333),
    [anon_sym_AT_DASH_GT] = ACTIONS(333),
    [anon_sym_DASH_GT_AT] = ACTIONS(333),
    [anon_sym_AT_GT] = ACTIONS(333),
    [anon_sym_GT_AT] = ACTIONS(333),
    [anon_sym_LBRACK_DOT] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_SLASH_SLASH] = ACTIONS(333),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(333),
    [anon_sym_BSLASH_SLASH] = ACTIONS(333),
    [sym_crossproduct] = ACTIONS(333),
    [sym_compose] = ACTIONS(333),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [370] = {
    [sym_condition_operators] = STATE(451),
    [sym_end_comment] = STATE(370),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [371] = {
    [sym_end_comment] = STATE(371),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(372),
    [anon_sym_LBRACK] = ACTIONS(337),
    [anon_sym_RBRACK] = ACTIONS(339),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(337),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(339),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(339),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(339),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_DOT_RBRACK] = ACTIONS(339),
    [anon_sym_COMMA_COMMA] = ACTIONS(549),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_END] = ACTIONS(43),
  },
  [372] = {
    [sym_end_comment] = STATE(372),
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(357),
    [anon_sym_LBRACK] = ACTIONS(369),
    [anon_sym_RBRACK] = ACTIONS(371),
    [sym_symbol] = ACTIONS(369),
    [sym_string] = ACTIONS(371),
    [sym_any] = ACTIONS(371),
    [sym_zero] = ACTIONS(371),
    [sym_boundary] = ACTIONS(371),
    [sym_symbol_group] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(369),
    [sym_colon] = ACTIONS(371),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(371),
    [sym_star] = ACTIONS(371),
    [sym_repeat] = ACTIONS(371),
    [sym_upper] = ACTIONS(371),
    [sym_lower] = ACTIONS(371),
    [sym_reverse] = ACTIONS(371),
    [sym_inverse] = ACTIONS(371),
    [sym_ignore] = ACTIONS(371),
    [sym_ignore_inside] = ACTIONS(371),
    [sym_union] = ACTIONS(371),
    [sym_intersect] = ACTIONS(371),
    [sym_subtract] = ACTIONS(369),
    [anon_sym_EQ_GT] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(369),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(371),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(371),
    [anon_sym_AT_DASH_GT] = ACTIONS(371),
    [anon_sym_DASH_GT_AT] = ACTIONS(371),
    [anon_sym_AT_GT] = ACTIONS(371),
    [anon_sym_GT_AT] = ACTIONS(371),
    [anon_sym_LBRACK_DOT] = ACTIONS(371),
    [anon_sym_DOT_RBRACK] = ACTIONS(371),
    [anon_sym_COMMA_COMMA] = ACTIONS(371),
    [sym_crossproduct] = ACTIONS(371),
    [sym_compose] = ACTIONS(371),
    [sym_comment] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_END] = ACTIONS(43),
  },
  [373] = {
    [sym_condition_operators] = STATE(442),
    [sym_end_comment] = STATE(373),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
  [374] = {
    [sym_condition_operators] = STATE(445),
    [sym_end_comment] = STATE(374),
    [aux_sym_parallel_replace_repeat1] = STATE(297),
    [anon_sym_LBRACK] = ACTIONS(337),
    [sym_symbol] = ACTIONS(337),
    [sym_string] = ACTIONS(339),
    [sym_any] = ACTIONS(339),
    [sym_zero] = ACTIONS(339),
    [sym_boundary] = ACTIONS(339),
    [sym_symbol_group] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_BQUOTE] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(462),
    [sym_colon] = ACTIONS(339),
    [sym_complement] = ACTIONS(339),
    [sym_term_complement] = ACTIONS(337),
    [sym_contains] = ACTIONS(339),
    [sym_plus] = ACTIONS(339),
    [sym_star] = ACTIONS(339),
    [sym_repeat] = ACTIONS(339),
    [sym_upper] = ACTIONS(339),
    [sym_lower] = ACTIONS(339),
    [sym_reverse] = ACTIONS(339),
    [sym_inverse] = ACTIONS(339),
    [sym_ignore] = ACTIONS(337),
    [sym_ignore_inside] = ACTIONS(339),
    [sym_union] = ACTIONS(337),
    [sym_intersect] = ACTIONS(339),
    [sym_subtract] = ACTIONS(337),
    [anon_sym_EQ_GT] = ACTIONS(339),
    [anon_sym_DASH_GT] = ACTIONS(337),
    [anon_sym_LT_DASH] = ACTIONS(339),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(339),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(339),
    [anon_sym_AT_DASH_GT] = ACTIONS(339),
    [anon_sym_DASH_GT_AT] = ACTIONS(339),
    [anon_sym_AT_GT] = ACTIONS(339),
    [anon_sym_GT_AT] = ACTIONS(339),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(343),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(343),
    [anon_sym_BSLASH_SLASH] = ACTIONS(343),
    [sym_crossproduct] = ACTIONS(339),
    [sym_compose] = ACTIONS(339),
    [sym_comment] = ACTIONS(41),
    [anon_sym_END] = ACTIONS(43),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(375), 1,
      sym_end_comment,
    ACTIONS(498), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(500), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [57] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(376), 1,
      sym_end_comment,
    ACTIONS(479), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(481), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [114] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(377), 1,
      sym_end_comment,
    ACTIONS(53), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(55), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [171] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(378), 1,
      sym_end_comment,
    ACTIONS(490), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(492), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [228] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(379), 1,
      sym_end_comment,
    ACTIONS(483), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(485), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [285] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(380), 1,
      sym_end_comment,
    ACTIONS(453), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(455), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [342] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(381), 1,
      sym_end_comment,
    ACTIONS(475), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(477), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [399] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(382), 1,
      sym_end_comment,
    ACTIONS(53), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(55), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [456] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(383), 1,
      sym_end_comment,
    ACTIONS(494), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(496), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [513] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(384), 1,
      sym_end_comment,
    STATE(386), 1,
      aux_sym_context_list_repeat1,
    ACTIONS(404), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(406), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      anon_sym_COMMA,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [572] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(563), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      sym_end_comment,
    STATE(394), 1,
      aux_sym_context_list_repeat1,
    ACTIONS(404), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(406), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [633] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(386), 1,
      sym_end_comment,
    STATE(391), 1,
      aux_sym_context_list_repeat1,
    ACTIONS(437), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(439), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      anon_sym_COMMA,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [692] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(387), 1,
      sym_end_comment,
    STATE(434), 1,
      sym_condition_operators,
    ACTIONS(343), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SLASH,
    ACTIONS(337), 9,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_term_complement,
      sym_ignore,
      sym_union,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(339), 29,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore_inside,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [753] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(565), 1,
      anon_sym_COMMA_COMMA,
    STATE(388), 2,
      sym_end_comment,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(389), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(391), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [812] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(568), 1,
      anon_sym_COMMA_COMMA,
    STATE(388), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    STATE(389), 1,
      sym_end_comment,
    ACTIONS(369), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(371), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [873] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(390), 1,
      sym_end_comment,
    ACTIONS(25), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(15), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [930] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(570), 1,
      anon_sym_COMMA,
    STATE(391), 2,
      sym_end_comment,
      aux_sym_context_list_repeat1,
    ACTIONS(453), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(455), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [989] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(568), 1,
      anon_sym_COMMA_COMMA,
    STATE(389), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    STATE(392), 1,
      sym_end_comment,
    ACTIONS(337), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(339), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [1050] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(393), 1,
      sym_end_comment,
    ACTIONS(337), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(339), 36,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1107] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(563), 1,
      anon_sym_COMMA,
    STATE(391), 1,
      aux_sym_context_list_repeat1,
    STATE(394), 1,
      sym_end_comment,
    ACTIONS(437), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym_DASH_GT,
      anon_sym_GT,
    ACTIONS(439), 35,
      anon_sym_RBRACK,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_RPAREN,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_DOT_RBRACK,
      sym_crossproduct,
      sym_compose,
  [1168] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(395), 1,
      sym_end_comment,
    STATE(451), 1,
      sym_condition_operators,
    ACTIONS(343), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SLASH,
    ACTIONS(337), 8,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_term_complement,
      sym_ignore,
      sym_union,
      sym_subtract,
      anon_sym_DASH_GT,
    ACTIONS(339), 29,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore_inside,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1228] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(396), 1,
      sym_end_comment,
    STATE(445), 1,
      sym_condition_operators,
    ACTIONS(343), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SLASH,
    ACTIONS(337), 8,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_term_complement,
      sym_ignore,
      sym_union,
      sym_subtract,
      anon_sym_DASH_GT,
    ACTIONS(339), 29,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore_inside,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1288] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(397), 1,
      sym_end_comment,
    STATE(434), 1,
      sym_condition_operators,
    ACTIONS(343), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SLASH,
    ACTIONS(337), 8,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_term_complement,
      sym_ignore,
      sym_union,
      sym_subtract,
      anon_sym_DASH_GT,
    ACTIONS(339), 29,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore_inside,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1348] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(398), 1,
      sym_end_comment,
    STATE(449), 1,
      sym_condition_operators,
    ACTIONS(343), 4,
      anon_sym_PIPE_PIPE,
      anon_sym_SLASH_SLASH,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SLASH,
    ACTIONS(337), 8,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_term_complement,
      sym_ignore,
      sym_union,
      sym_subtract,
      anon_sym_DASH_GT,
    ACTIONS(339), 29,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore_inside,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1408] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(573), 1,
      anon_sym_COMMA,
    STATE(399), 2,
      sym_end_comment,
      aux_sym_context_list_repeat1,
    ACTIONS(453), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(455), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1465] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(576), 1,
      anon_sym_COMMA_COMMA,
    STATE(400), 1,
      sym_end_comment,
    STATE(405), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(337), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(339), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1524] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(576), 1,
      anon_sym_COMMA_COMMA,
    STATE(401), 1,
      sym_end_comment,
    STATE(406), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(369), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(371), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1583] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(399), 1,
      aux_sym_context_list_repeat1,
    STATE(402), 1,
      sym_end_comment,
    ACTIONS(437), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(439), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1640] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(576), 1,
      anon_sym_COMMA_COMMA,
    STATE(401), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    STATE(403), 1,
      sym_end_comment,
    ACTIONS(337), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(339), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1699] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(402), 1,
      aux_sym_context_list_repeat1,
    STATE(404), 1,
      sym_end_comment,
    ACTIONS(404), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(406), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1756] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(405), 1,
      sym_end_comment,
    STATE(406), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(369), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(371), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1813] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(578), 1,
      anon_sym_COMMA_COMMA,
    STATE(406), 2,
      sym_end_comment,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(389), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(391), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [1870] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(389), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    STATE(407), 1,
      sym_end_comment,
    ACTIONS(389), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(391), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1927] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(581), 1,
      anon_sym_COMMA,
    STATE(408), 1,
      sym_end_comment,
    STATE(409), 1,
      aux_sym_context_list_repeat1,
    ACTIONS(404), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(406), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [1986] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(581), 1,
      anon_sym_COMMA,
    STATE(399), 1,
      aux_sym_context_list_repeat1,
    STATE(409), 1,
      sym_end_comment,
    ACTIONS(437), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(439), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2045] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(583), 1,
      anon_sym_COMMA_COMMA,
    STATE(410), 1,
      sym_end_comment,
    STATE(414), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(337), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(339), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2103] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(411), 1,
      sym_end_comment,
    ACTIONS(25), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(15), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2157] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(412), 1,
      sym_end_comment,
    ACTIONS(337), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(339), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2211] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(585), 1,
      anon_sym_COMMA,
    STATE(413), 2,
      sym_end_comment,
      aux_sym_context_list_repeat1,
    ACTIONS(453), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(455), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2267] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(583), 1,
      anon_sym_COMMA_COMMA,
    STATE(414), 1,
      sym_end_comment,
    STATE(416), 1,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(369), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(371), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2325] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(588), 1,
      anon_sym_COMMA,
    STATE(413), 1,
      aux_sym_context_list_repeat1,
    STATE(415), 1,
      sym_end_comment,
    ACTIONS(437), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(439), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2383] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(590), 1,
      anon_sym_COMMA_COMMA,
    STATE(416), 2,
      sym_end_comment,
      aux_sym_parallel_conditional_replace_repeat1,
    ACTIONS(389), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(391), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2439] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(417), 1,
      sym_end_comment,
    ACTIONS(475), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(477), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2493] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(418), 1,
      sym_end_comment,
    ACTIONS(498), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(500), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2547] = 7,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(588), 1,
      anon_sym_COMMA,
    STATE(415), 1,
      aux_sym_context_list_repeat1,
    STATE(419), 1,
      sym_end_comment,
    ACTIONS(404), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(406), 32,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2605] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(420), 1,
      sym_end_comment,
    ACTIONS(490), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(492), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2659] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(421), 1,
      sym_end_comment,
    ACTIONS(53), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(55), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2713] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(422), 1,
      sym_end_comment,
    ACTIONS(494), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(496), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2767] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(423), 1,
      sym_end_comment,
    ACTIONS(53), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(55), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2821] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(413), 1,
      aux_sym_context_list_repeat1,
    STATE(424), 1,
      sym_end_comment,
    ACTIONS(437), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(439), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      anon_sym_COMMA,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2877] = 6,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(424), 1,
      aux_sym_context_list_repeat1,
    STATE(425), 1,
      sym_end_comment,
    ACTIONS(404), 6,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(406), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      anon_sym_COMMA,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      sym_crossproduct,
      sym_compose,
  [2933] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(426), 1,
      sym_end_comment,
    ACTIONS(479), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(481), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [2987] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(427), 1,
      sym_end_comment,
    ACTIONS(453), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(455), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [3041] = 5,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    STATE(428), 1,
      sym_end_comment,
    ACTIONS(483), 7,
      anon_sym_LBRACK,
      sym_symbol,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      sym_subtract,
      anon_sym__,
      anon_sym_DASH_GT,
    ACTIONS(485), 33,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
      anon_sym_BQUOTE,
      sym_colon,
      sym_complement,
      sym_term_complement,
      sym_contains,
      sym_plus,
      sym_star,
      sym_repeat,
      sym_upper,
      sym_lower,
      sym_reverse,
      sym_inverse,
      sym_ignore,
      sym_ignore_inside,
      sym_union,
      sym_intersect,
      anon_sym_EQ_GT,
      anon_sym_LT_DASH,
      anon_sym_LPAREN_DASH_GT_RPAREN,
      anon_sym_LPAREN_LT_DASH_RPAREN,
      anon_sym_AT_DASH_GT,
      anon_sym_DASH_GT_AT,
      anon_sym_AT_GT,
      anon_sym_GT_AT,
      anon_sym_LBRACK_DOT,
      anon_sym_COMMA_COMMA,
      sym_crossproduct,
      sym_compose,
  [3095] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(595), 1,
      anon_sym__,
    STATE(220), 1,
      sym_context,
    STATE(228), 1,
      sym_expression,
    STATE(292), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(429), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3161] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym__,
    STATE(213), 1,
      sym_expression,
    STATE(363), 1,
      sym_context,
    STATE(383), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(430), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3227] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(599), 1,
      anon_sym__,
    STATE(229), 1,
      sym_expression,
    STATE(383), 1,
      sym_context_list,
    STATE(384), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(431), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3293] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym__,
    STATE(231), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(404), 1,
      sym_context,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(422), 1,
      sym_context_list,
    STATE(432), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3359] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(603), 1,
      anon_sym__,
    STATE(216), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(422), 1,
      sym_context_list,
    STATE(425), 1,
      sym_context,
    STATE(433), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3425] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym__,
    STATE(231), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(408), 1,
      sym_context,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(420), 1,
      sym_context_list,
    STATE(434), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3491] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(605), 1,
      anon_sym__,
    STATE(242), 1,
      sym_expression,
    STATE(310), 1,
      sym_context,
    STATE(326), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(435), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3557] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(610), 1,
      sym_symbol,
    ACTIONS(616), 1,
      anon_sym_LPAREN,
    ACTIONS(621), 1,
      anon_sym_BQUOTE,
    ACTIONS(627), 1,
      anon_sym_LBRACK_DOT,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    ACTIONS(619), 2,
      anon_sym_RPAREN,
      anon_sym_GT,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    STATE(436), 2,
      sym_end_comment,
      aux_sym_optional_repeat1,
    ACTIONS(624), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(613), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3619] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(630), 1,
      anon_sym__,
    STATE(207), 1,
      sym_expression,
    STATE(274), 1,
      sym_context,
    STATE(292), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(437), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3685] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym__,
    STATE(213), 1,
      sym_expression,
    STATE(363), 1,
      sym_context,
    STATE(378), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(438), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3751] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(603), 1,
      anon_sym__,
    STATE(216), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(419), 1,
      sym_context,
    STATE(422), 1,
      sym_context_list,
    STATE(439), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3817] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(599), 1,
      anon_sym__,
    STATE(229), 1,
      sym_expression,
    STATE(383), 1,
      sym_context_list,
    STATE(385), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(440), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3883] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym__,
    STATE(213), 1,
      sym_expression,
    STATE(355), 1,
      sym_context,
    STATE(378), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(441), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [3949] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(595), 1,
      anon_sym__,
    STATE(220), 1,
      sym_context,
    STATE(228), 1,
      sym_expression,
    STATE(290), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(442), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4015] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(632), 1,
      anon_sym__,
    STATE(251), 1,
      sym_expression,
    STATE(263), 1,
      sym_context,
    STATE(290), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(443), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4081] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(634), 1,
      anon_sym__,
    STATE(208), 1,
      sym_expression,
    STATE(326), 1,
      sym_context_list,
    STATE(348), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(444), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4147] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(605), 1,
      anon_sym__,
    STATE(242), 1,
      sym_expression,
    STATE(310), 1,
      sym_context,
    STATE(328), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(445), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4213] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(636), 1,
      anon_sym__,
    STATE(250), 1,
      sym_expression,
    STATE(292), 1,
      sym_context_list,
    STATE(298), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(446), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4279] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(638), 1,
      anon_sym__,
    STATE(252), 1,
      sym_expression,
    STATE(326), 1,
      sym_context_list,
    STATE(352), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(447), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4345] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      anon_sym__,
    STATE(254), 1,
      sym_expression,
    STATE(326), 1,
      sym_context_list,
    STATE(330), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(448), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4411] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      anon_sym__,
    STATE(254), 1,
      sym_expression,
    STATE(328), 1,
      sym_context_list,
    STATE(330), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(449), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4477] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(632), 1,
      anon_sym__,
    STATE(251), 1,
      sym_expression,
    STATE(263), 1,
      sym_context,
    STATE(292), 1,
      sym_context_list,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(450), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4543] = 18,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym__,
    STATE(231), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(404), 1,
      sym_context,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(420), 1,
      sym_context_list,
    STATE(451), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4609] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(632), 1,
      anon_sym__,
    STATE(251), 1,
      sym_expression,
    STATE(286), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(452), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4672] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(644), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(436), 1,
      aux_sym_optional_repeat1,
    STATE(453), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4735] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(634), 1,
      anon_sym__,
    STATE(208), 1,
      sym_expression,
    STATE(341), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(454), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4798] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(601), 1,
      anon_sym__,
    STATE(231), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(427), 1,
      sym_context,
    STATE(455), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4861] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(603), 1,
      anon_sym__,
    STATE(216), 1,
      sym_expression,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(427), 1,
      sym_context,
    STATE(456), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4924] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(595), 1,
      anon_sym__,
    STATE(228), 1,
      sym_expression,
    STATE(286), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(457), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [4987] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(453), 1,
      aux_sym_optional_repeat1,
    STATE(458), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5050] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(648), 1,
      anon_sym_GT,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(436), 1,
      aux_sym_optional_repeat1,
    STATE(459), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5113] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(630), 1,
      anon_sym__,
    STATE(207), 1,
      sym_expression,
    STATE(286), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(460), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5176] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(650), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(436), 1,
      aux_sym_optional_repeat1,
    STATE(461), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5239] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(640), 1,
      anon_sym__,
    STATE(254), 1,
      sym_expression,
    STATE(341), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(462), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5302] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(652), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(461), 1,
      aux_sym_optional_repeat1,
    STATE(463), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5365] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(599), 1,
      anon_sym__,
    STATE(229), 1,
      sym_expression,
    STATE(380), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(464), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5428] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(654), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(465), 1,
      sym_end_comment,
    STATE(467), 1,
      aux_sym_optional_repeat1,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5491] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(638), 1,
      anon_sym__,
    STATE(252), 1,
      sym_expression,
    STATE(341), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(466), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5554] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(656), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(436), 1,
      aux_sym_optional_repeat1,
    STATE(467), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5617] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(636), 1,
      anon_sym__,
    STATE(250), 1,
      sym_expression,
    STATE(286), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(468), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5680] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(605), 1,
      anon_sym__,
    STATE(242), 1,
      sym_expression,
    STATE(341), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(469), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5743] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    ACTIONS(597), 1,
      anon_sym__,
    STATE(213), 1,
      sym_expression,
    STATE(380), 1,
      sym_context,
    STATE(387), 1,
      sym_parallel_replace,
    STATE(410), 1,
      sym_conditional_replace,
    STATE(470), 1,
      sym_end_comment,
    STATE(327), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(361), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5806] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(658), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(471), 1,
      sym_end_comment,
    STATE(472), 1,
      aux_sym_optional_repeat1,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5869] = 17,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(660), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(436), 1,
      aux_sym_optional_repeat1,
    STATE(472), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5932] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(664), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(18), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(473), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [5992] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(666), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(9), 1,
      sym_expression,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(237), 1,
      sym_conditional_replace,
    STATE(474), 1,
      sym_end_comment,
    STATE(195), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(29), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6052] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(670), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(73), 1,
      sym_expression,
    STATE(305), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(475), 1,
      sym_end_comment,
    STATE(303), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(167), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6112] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(672), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(28), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(476), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6172] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(674), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(10), 1,
      sym_expression,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(237), 1,
      sym_conditional_replace,
    STATE(477), 1,
      sym_end_comment,
    STATE(195), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(29), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6232] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(199), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(459), 1,
      aux_sym_optional_repeat1,
    STATE(478), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6292] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(86), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(479), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6352] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(14), 1,
      sym_expression,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(237), 1,
      sym_conditional_replace,
    STATE(480), 1,
      sym_end_comment,
    STATE(195), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(29), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6412] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(71), 1,
      sym_expression,
    STATE(305), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(481), 1,
      sym_end_comment,
    STATE(303), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(167), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6472] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(76), 1,
      sym_expression,
    STATE(305), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(482), 1,
      sym_end_comment,
    STATE(303), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(167), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6532] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(9), 1,
      sym_expression,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(237), 1,
      sym_conditional_replace,
    STATE(483), 1,
      sym_end_comment,
    STATE(195), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(29), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6592] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(678), 1,
      anon_sym_RBRACK,
    STATE(219), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(484), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6652] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(680), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(88), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(485), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6712] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(682), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(71), 1,
      sym_expression,
    STATE(305), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(486), 1,
      sym_end_comment,
    STATE(303), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(167), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6772] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(18), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(487), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6832] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(684), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(86), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(488), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6892] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(27), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(489), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [6952] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(39), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(686), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_expression,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(237), 1,
      sym_conditional_replace,
    STATE(490), 1,
      sym_end_comment,
    STATE(195), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(29), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7012] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(688), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(96), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(491), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7072] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(82), 1,
      sym_expression,
    STATE(305), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(492), 1,
      sym_end_comment,
    STATE(303), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(167), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7132] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(676), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(90), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(493), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7192] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    ACTIONS(692), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(105), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(494), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7252] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(694), 1,
      anon_sym_RBRACK,
    STATE(221), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(495), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7312] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_RBRACK,
    STATE(239), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(496), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7372] = 16,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(29), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(497), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7432] = 16,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_RBRACK,
    STATE(243), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(498), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7492] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(148), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(499), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7549] = 15,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(30), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(500), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7606] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(111), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(501), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7663] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(502), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7720] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(108), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(503), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7777] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(106), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(504), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7834] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(219), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(101), 1,
      sym_expression,
    STATE(307), 1,
      sym_conditional_replace,
    STATE(313), 1,
      sym_parallel_replace,
    STATE(505), 1,
      sym_end_comment,
    STATE(306), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(207), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7891] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(181), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(268), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(506), 1,
      sym_end_comment,
    STATE(296), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [7948] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(206), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(507), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8005] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(202), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(508), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8062] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(400), 1,
      sym_conditional_replace,
    STATE(509), 1,
      sym_end_comment,
    STATE(318), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(313), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8119] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(400), 1,
      sym_conditional_replace,
    STATE(510), 1,
      sym_end_comment,
    STATE(318), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(313), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8176] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(218), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(511), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8233] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(165), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(512), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8290] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(238), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(513), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8347] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(182), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(400), 1,
      sym_conditional_replace,
    STATE(514), 1,
      sym_end_comment,
    STATE(318), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(313), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8404] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(149), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(515), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8461] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(516), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8518] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(185), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(403), 1,
      sym_conditional_replace,
    STATE(517), 1,
      sym_end_comment,
    STATE(332), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(323), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8575] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(129), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(371), 1,
      sym_conditional_replace,
    STATE(518), 1,
      sym_end_comment,
    STATE(249), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(243), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8632] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(209), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(519), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8689] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(241), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(520), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8746] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(270), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(521), 1,
      sym_end_comment,
    STATE(296), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8803] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(146), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(522), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8860] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(171), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(400), 1,
      sym_conditional_replace,
    STATE(523), 1,
      sym_end_comment,
    STATE(318), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(313), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8917] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(205), 1,
      sym_expression,
    STATE(315), 1,
      sym_parallel_replace,
    STATE(392), 1,
      sym_conditional_replace,
    STATE(524), 1,
      sym_end_comment,
    STATE(255), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [8974] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(272), 1,
      sym_expression,
    STATE(316), 1,
      sym_conditional_replace,
    STATE(398), 1,
      sym_parallel_replace,
    STATE(525), 1,
      sym_end_comment,
    STATE(364), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9031] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(210), 1,
      sym_conditional_replace,
    STATE(266), 1,
      sym_parallel_replace,
    STATE(272), 1,
      sym_expression,
    STATE(526), 1,
      sym_end_comment,
    STATE(365), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9088] = 15,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(129), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(44), 1,
      sym_expression,
    STATE(266), 1,
      sym_parallel_replace,
    STATE(279), 1,
      sym_conditional_replace,
    STATE(527), 1,
      sym_end_comment,
    STATE(200), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(117), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9145] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(112), 1,
      sym_expression,
    STATE(324), 1,
      sym_conditional_replace,
    STATE(336), 1,
      sym_parallel_replace,
    STATE(528), 1,
      sym_end_comment,
    STATE(319), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(191), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9202] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(155), 1,
      anon_sym_LBRACK,
    ACTIONS(157), 1,
      sym_symbol,
    ACTIONS(163), 1,
      anon_sym_BQUOTE,
    ACTIONS(203), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(668), 1,
      anon_sym_LPAREN,
    STATE(99), 1,
      sym_expression,
    STATE(324), 1,
      sym_conditional_replace,
    STATE(336), 1,
      sym_parallel_replace,
    STATE(529), 1,
      sym_end_comment,
    STATE(319), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(191), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(159), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(345), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9259] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(188), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(403), 1,
      sym_conditional_replace,
    STATE(530), 1,
      sym_end_comment,
    STATE(332), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(323), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9316] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(210), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(272), 1,
      sym_expression,
    STATE(531), 1,
      sym_end_comment,
    STATE(373), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(287), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9373] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      anon_sym_BQUOTE,
    ACTIONS(642), 1,
      anon_sym_LPAREN,
    STATE(151), 1,
      sym_expression,
    STATE(291), 1,
      sym_parallel_replace,
    STATE(361), 1,
      sym_conditional_replace,
    STATE(532), 1,
      sym_end_comment,
    STATE(262), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(275), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(235), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(393), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9430] = 15,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(17), 1,
      sym_symbol,
    ACTIONS(23), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(103), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(662), 1,
      anon_sym_LPAREN,
    STATE(17), 1,
      sym_expression,
    STATE(214), 1,
      sym_conditional_replace,
    STATE(226), 1,
      sym_parallel_replace,
    STATE(533), 1,
      sym_end_comment,
    STATE(222), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(91), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(19), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(289), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9487] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(263), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      sym_symbol,
    ACTIONS(311), 1,
      anon_sym_BQUOTE,
    ACTIONS(593), 1,
      anon_sym_LPAREN,
    STATE(189), 1,
      sym_expression,
    STATE(335), 1,
      sym_parallel_replace,
    STATE(403), 1,
      sym_conditional_replace,
    STATE(534), 1,
      sym_end_comment,
    STATE(332), 2,
      sym_simple_replace,
      sym_single_replace,
    ACTIONS(323), 3,
      sym_complement,
      sym_term_complement,
      sym_contains,
    ACTIONS(307), 5,
      sym_string,
      sym_any,
      sym_zero,
      sym_boundary,
      sym_symbol_group,
    STATE(412), 5,
      sym_optional,
      sym_substitute,
      sym_restrict,
      sym_mark,
      sym_parallel_conditional_replace,
  [9544] = 15,
    ACTIONS(41), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_END,
    ACTIONS(151), 1,
      anon_sym_LBRACK_DOT,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(233), 1,
      sym_symbol,
    ACTIONS(239), 1,
      