"""
pyGoogleTranslate data module.

© Anime no Sekai - 2020\n
Credit to py-googletrans by ssut for the list of google translate domains.
"""

def language_code_data():
    """
    List of available language code for Google Translate.\n
    Used to check if the correct language code is provided\n
    © Anime no Sekai - 2020
    """
    data_list = [
        'auto',
        'af',
        'sq',
        'am',
        'ar',
        'hy',
        'az',
        'eu',
        'be',
        'bn',
        'bs',
        'bg',
        'ca',
        'ceb',
        'ny',
        'zh-cn',
        'zh-tw',
        'co',
        'hr',
        'cs',
        'da',
        'nl',
        'en',
        'eo',
        'et',
        'tl',
        'fi',
        'fr',
        'fy',
        'gl',
        'ka',
        'de',
        'el',
        'gu',
        'ht',
        'ha',
        'haw',
        'iw',
        'hi',
        'hmn',
        'hu',
        'is',
        'ig',
        'id',
        'ga',
        'it',
        'ja',
        'jw',
        'kn',
        'kk',
        'km',
        'ko',
        'ku',
        'ky',
        'lo',
        'la',
        'lv',
        'lt',
        'lb',
        'mk',
        'mg',
        'ms',
        'ml',
        'mt',
        'mi',
        'mr',
        'mn',
        'my',
        'ne',
        'no',
        'or',
        'ps',
        'fa',
        'pl',
        'pt',
        'pa',
        'ro',
        'ru',
        'sm',
        'gd',
        'sr',
        'st',
        'sn',
        'sd',
        'si',
        'sk',
        'sl',
        'so',
        'es',
        'su',
        'sw',
        'sv',
        'tg',
        'ta',
        'te',
        'th',
        'tr',
        'uk',
        'ur',
        'ug',
        'uz',
        'vi',
        'cy',
        'xh',
        'yi',
        'yo',
        'zu'
    ]
    return data_list


def language_name_to_code():
    """
    English language name to code language for Google Translate.\n
    © Anime no Sekai - 2020
    """
    data_dict = {
        'automatic': 'auto',
        'afrikaans': 'af',
        'albanian': 'sq',
        'amharic': 'am',
        'arabic': 'ar',
        'armenian': 'hy',
        'azerbaijani': 'az',
        'basque': 'eu',
        'belarusian': 'be',
        'bengali': 'bn',
        'bosnian': 'bs',
        'bulgarian': 'bg',
        'catalan': 'ca',
        'cebuano': 'ceb',
        'chichewa': 'ny',
        'chinese': 'zh-CN',
        'chinese (simplified)': 'zh-CN',
        'chinese (traditional)': 'zh-TW',
        'corsican': 'co',
        'croatian': 'hr',
        'czech': 'cs',
        'danish': 'da',
        'dutch': 'nl',
        'english': 'en',
        'esperanto': 'eo',
        'estonian': 'et',
        'filipino': 'tl',
        'finnish': 'fi',
        'french': 'fr',
        'frisian': 'fy',
        'galician': 'gl',
        'georgian': 'ka',
        'german': 'de',
        'greek': 'el',
        'gujarati': 'gu',
        'haitian': 'ht',
        'creole': 'ht',
        'haitian creole': 'ht',
        'hausa': 'ha',
        'hawaiian': 'haw',
        'hindi': 'hi',
        'hmong': 'hmn',
        'hungarian': 'hu',
        'icelandic': 'is',
        'igbo': 'ig',
        'indonesian': 'id',
        'irish': 'ga',
        'italian': 'it',
        'japanese': 'ja',
        'javanese': 'jw',
        'kannada': 'kn',
        'kazakh': 'kk',
        'khmer': 'km',
        'korean': 'ko',
        'kurdish': 'ku',
        'kurdish (kurmanji)': 'ku',
        'kyrgyz': 'ky',
        'lao': 'lo',
        'latin': 'la',
        'latvian': 'lv',
        'lithuanian': 'lt',
        'luxembourgish': 'lb',
        'macedonian': 'mk',
        'malagasy': 'mg',
        'malay': 'ms',
        'malayalam': 'ml',
        'maltese': 'mt',
        'maori': 'mi',
        'marathi': 'mr',
        'mongolian': 'mn',
        'myanmar': 'my',
        'burmese': 'my',
        'myanmar (burmese)': 'my',
        'nepali': 'ne',
        'norwegian': 'no',
        'odia': 'or',
        'pashto': 'ps',
        'persian': 'fa',
        'polish': 'pl',
        'portuguese': 'pt',
        'punjabi': 'pa',
        'romanian': 'ro',
        'russian': 'ru',
        'samoan': 'sm',
        'scots': 'gd',
        'gaelic': 'gd',
        'scots gaelic': 'gd',
        'serbian': 'sr',
        'sesotho': 'st',
        'shona': 'sn',
        'sindhi': 'sd',
        'sinhala': 'si',
        'slovak': 'sk',
        'slovenian': 'sl',
        'somali': 'so',
        'spanish': 'es',
        'sundanese': 'su',
        'swahili': 'sw',
        'swedish': 'sv',
        'tajik': 'tg',
        'tamil': 'ta',
        'telugu': 'te',
        'thai': 'th',
        'turkish': 'tr',
        'ukrainian': 'uk',
        'urdu': 'ur',
        'uyghur': 'ug',
        'uzbek': 'uz',
        'vietnamese': 'vi',
        'welsh': 'cy',
        'xhosa': 'xh',
        'yiddish': 'yi',
        'yoruba': 'yo',
        'zulu': 'zu'
    }
    return data_dict

def international_language_name_to_code():
    """
    Translation of all the language names into all the languages available on Google Translate (+11200 translations/7〜9 hours of work)\n
    Used to always get the correct language code, even if a language name is provided.\n
    © Anime no Sekai - 2020\n
    © Google Translate by Google LLC
    """
    data_dict = {
        "afrikaans":"af",
        "አፍሪካንስ":"af",
        "الأفارقة":"af",
        "աֆրիկյան":"af",
        "афрыкаанс":"af",
        "আফ্রিকান্স":"af",
        "африканс":"af",
        "mga afrikaan":"af",
        "aafrika":"af",
        "afrikánština":"af",
        "mga afrikaans":"af",
        "afrikaansk":"af",
        "ინფორმაცია":"af",
        "αφρικανοί":"af",
        "હવામાન":"af",
        "yan afirka":"af",
        "apikana":"af",
        "אפריקאית":"af",
        "दी":"af",
        "afrískt":"af",
        "ndị africa":"af",
        "afrikanas":"af",
        "アフリカーンス語":"af",
        "wong afrikaan":"af",
        "ಆಫ್ರಿಕಾನ್ಸ್":"af",
        "африкалықтар":"af",
        "អាហ្វ្រិក":"af",
        "아프리카 어":"af",
        "afrîkansî":"af",
        "африкаансча":"af",
        "ຊາວອາເມລິກາ":"af",
        "africanica":"af",
        "afrikiečių":"af",
        "orang afrika":"af",
        "ആഫ്രിക്കക്കാർ":"af",
        "indja":"af",
        "afrikaana":"af",
        "हवामान":"af",
        "африк":"af",
        "လှိုင်":"af",
        "ठाउ":"af",
        "ଆଫ୍ରିକୀୟ":"af",
        "افریقایی":"af",
        "اطلاعات":"af",
        "ਹਵਾਈ ਅੱਡਾ":"af",
        "африкаанс":"af",
        "faʻa afelika":"af",
        "afrikaanach":"af",
        "ma-afrika":"af",
        "chiafrikaans":"af",
        "آفريڪي":"af",
        "අප්\u200dරිකානු":"af",
        "afrikánčina":"af",
        "afrikaanka":"af",
        "africaans":"af",
        "waafrika":"af",
        "африкоиён":"af",
        "ஆப்பிரிக்கா":"af",
        "แอฟริกาใต้":"af",
        "اراضی":"af",
        "isibhulu":"af",
        "אפריקאנער":"af",
        "ọmọ ilu afirika":"af",
        "abase-afrika":"af",
        "albanian":"sq",
        "shqiptar":"sq",
        "አልበንያኛ":"sq",
        "الألبانية":"sq",
        "ալբանական":"sq",
        "alban":"sq",
        "албанскі":"sq",
        "albanski":"sq",
        "албански":"sq",
        "apolisi":"sq",
        "albanese":"sq",
        "albanac":"sq",
        "albánský":"sq",
        "albansk":"sq",
        "albanees":"sq",
        "albaanlane":"sq",
        "albanialainen":"sq",
        "albanais":"sq",
        "albaneesk":"sq",
        "ალბანური":"sq",
        "αλβανός":"sq",
        "હાઉસિંગ":"sq",
        "albani":"sq",
        "alapania":"sq",
        "אלבנית":"sq",
        "अल्बानियन":"sq",
        "neeg txawv teb chaws":"sq",
        "albán":"sq",
        "albanska":"sq",
        "bahasa albania":"sq",
        "アルバニア語":"sq",
        "ಅಲ್ಬೇನಿಯನ್":"sq",
        "албаниялық":"sq",
        "អាល់បានី":"sq",
        "알바니아":"sq",
        "albanî":"sq",
        "албанча":"sq",
        "ຄົນຕ່າງຊາດ":"sq",
        "illyrica":"sq",
        "albanietis":"sq",
        "albanesch":"sq",
        "albaney":"sq",
        "orang albania":"sq",
        "അൽബേനിയൻ":"sq",
        "taljan":"it",
        "निवासी":"sq",
        "албани":"sq",
        "आवास":"sq",
        "ଆଲବାନ୍":"sq",
        "آلبانیایی":"sq",
        "albański":"sq",
        "albanês":"sq",
        "ਹਾ albanianਸਿੰਗ":"sq",
        "albanez":"sq",
        "албанский":"sq",
        "albànianach":"sq",
        "bafolisi":"sq",
        "chialbanian":"sq",
        "الباني":"sq",
        "ඇල්බේනියානු":"sq",
        "albánsky":"sq",
        "albaniin":"sq",
        "albanesa":"sq",
        "wananchi":"sq",
        "nian":"sq",
        "албания":"sq",
        "அல்பேனிய":"sq",
        "แอลเบเนีย":"sq",
        "arnavut":"sq",
        "албанська":"sq",
        "رہائش":"sq",
        "bia":"sq",
        "albania":"sq",
        "אַלבאַניש":"sq",
        "alibani":"sq",
        "abafowethu":"sq",
        "amharies":"am",
        "amharic":"am",
        "አማርኛ":"am",
        "الأمهرية":"am",
        "ամհարերեն":"am",
        "amharik":"am",
        "амхарскі":"am",
        "আমহারিক":"am",
        "amharski":"am",
        "амхарски":"am",
        "amàric":"am",
        "amaricu":"am",
        "amharský":"am",
        "amharisk":"am",
        "amhaars":"am",
        "amikeco":"am",
        "amhaarne":"am",
        "amhara":"am",
        "amharique":"am",
        "amhaarsk":"am",
        "amárico":"am",
        "ამჰარული":"am",
        "amharisch":"am",
        "αμαρικά":"am",
        "અમ્હારિક":"am",
        "amawik":"am",
        "hausa":"ha",
        "amahapika":"am",
        "אמהרית":"am",
        "अम्हारिक्":"am",
        "amharíska":"am",
        "bekee":"en",
        "amarica":"am",
        "アムハラ語":"am",
        "kenthel":"am",
        "ಅಂಹರಿಕ್":"am",
        "амхар":"am",
        "អាម៉ារិច":"am",
        "암하라 어":"am",
        "amharîkî":"am",
        "амхарча":"am",
        "aethiopica":"am",
        "amharinis":"am",
        "amharesch":"am",
        "amrarika":"am",
        "अम्हारिक":"am",
        "амхарик":"am",
        "ଆମହାରିକ୍ |":"am",
        "امهاریک":"am",
        "آماره":"am",
        "ਅਮਹਾਰਿਕ":"am",
        "amharică":"am",
        "амхарский":"am",
        "chiamharic":"am",
        "امهاري":"am",
        "amharčina":"am",
        "амҳарикӣ":"am",
        "அம்ஹாரிக்":"am",
        "amharca":"am",
        "амхарний":"am",
        "امھارک":"am",
        "amhar tilida":"am",
        "amharig":"am",
        "èdè amẹrika":"am",
        "isi-amharic":"am",
        "arabies":"ar",
        "arab":"ar",
        "አረብኛ":"ar",
        "عربى":"ar",
        "արաբական":"ar",
        "ərəb":"ar",
        "arabic":"ar",
        "арабская":"ar",
        "আরবি":"ar",
        "arapski":"ar",
        "арабски":"ar",
        "àrab":"ar",
        "arabiko":"ar",
        "arabu":"ar",
        "arabština":"ar",
        "arabisk":"ar",
        "arabisch":"ar",
        "la araba":"ar",
        "araabia":"ar",
        "arabialainen":"ar",
        "arabe":"ar",
        "arabysk":"ar",
        "árabe":"ar",
        "არაბული":"ar",
        "αραβικός":"ar",
        "અરબી":"ar",
        "larabci":"ar",
        "apapika":"ar",
        "עֲרָבִית":"ar",
        "अरबी":"ar",
        "neeg arabic":"ar",
        "arabíska":"ar",
        "mkpụrụedemede":"ar",
        "araibis":"ar",
        "araba":"ar",
        "アラビア語":"ar",
        "ಅರೇಬಿಕ್":"ar",
        "араб":"ar",
        "អារ៉ាប់":"ar",
        "아라비아 말":"ar",
        "erebî":"ar",
        "арабча":"ar",
        "ອາຣັບ":"ar",
        "arābu":"ar",
        "arabiškas":"ar",
        "arabesch":"ar",
        "арапски":"ar",
        "arabo":"ar",
        "orang arab":"ar",
        "അറബിക്":"ar",
        "għarbi":"ar",
        "arapi":"ar",
        "အာရဗီ":"ar",
        "ଆରବୀ":"ar",
        "عربي...":"ar",
        "arabski":"ar",
        "ਅਰਬੀ":"ar",
        "арабский":"ar",
        "alapi":"ar",
        "arabach":"ar",
        "chiarabic":"ar",
        "عربي":"ar",
        "අරාබි":"ar",
        "arabčina":"ar",
        "arabsko":"ar",
        "carabi":"ar",
        "arábica":"ar",
        "arabiki":"ar",
        "arabicum":"ar",
        "арабӣ":"ar",
        "அரபு":"ar",
        "అరబిక్":"ar",
        "ภาษาอาหรับ":"ar",
        "arapça":"ar",
        "арабська":"ar",
        "عربی":"ar",
        "ئەرەبچە":"ar",
        "arabcha":"ar",
        "tiếng ả rập":"ar",
        "arabeg":"ar",
        "isiarabhu":"ar",
        "אַראַביש":"ar",
        ".bíbáwá":"ar",
        "i-arabic":"ar",
        "armenian":"hy",
        "armen":"hy",
        "አርመንያኛ":"hy",
        "الأرمينية":"hy",
        "հայերեն":"hy",
        "erməni":"hy",
        "армянскі":"hy",
        "armenski":"hy",
        "арменски":"hy",
        "informar":"hy",
        "armenu":"hy",
        "armenac":"hy",
        "arménský":"hy",
        "armensk":"hy",
        "armeens":"hy",
        "informi":"hy",
        "armeenlane":"hy",
        "arménienne":"hy",
        "armeensk":"hy",
        "სომხური":"hy",
        "armenisch":"hy",
        "αρμενικός":"hy",
        "વનવાસી":"hy",
        "armeniyanci":"hy",
        "ameniana":"hy",
        "אַרְמֶנִי":"hy",
        "örmény":"hy",
        "arabískur":"hy",
        "onye armenia":"hy",
        "armenia":"hy",
        "armena":"hy",
        "アルメニア語":"hy",
        "ಅರ್ಮೇನಿಯನ್":"hy",
        "армян":"hy",
        "អាមេរិច":"hy",
        "아르메니아 사람":"hy",
        "ermenî":"hy",
        "армянча":"hy",
        "ອາແມນ":"hy",
        "armenias":"hy",
        "armēņu":"hy",
        "armėnų":"hy",
        "armenesch":"hy",
        "ерменски":"hy",
        "armeniana":"hy",
        "അർമേനിയൻ":"hy",
        "titlob":"hy",
        "वनवासी":"hy",
        "арменийн":"hy",
        "အာရပ်":"hy",
        "गाउँ":"hy",
        "ଆର୍ମେନିଆ":"hy",
        "ارمنی":"hy",
        "ormiański":"hy",
        "armênio":"hy",
        "ਜੰਗਲੀ":"hy",
        "armean":"hy",
        "армянин":"hy",
        "armenianach":"hy",
        "армени":"hy",
        "آرمينيائي":"hy",
        "ආර්මේනියානු":"hy",
        "armensko":"hy",
        "kiarmenia":"hy",
        "armenian ":"hy",
        "ஆர்மீனியன்":"hy",
        "อาร์เมเนีย":"hy",
        "ermeni":"hy",
        "арм":"hy",
        "دیہی":"hy",
        "mật ong":"hy",
        "ארמעניש":"hy",
        "ara ilu armenia":"hy",
        "armanian":"hy",
        "azerbaijani":"az",
        "አዝበርባይጃኒ":"az",
        "أذربيجان":"az",
        "ղուրան":"az",
        "azerbaycan":"az",
        "азербайджанскія":"az",
        "азербайджански":"az",
        "ebra":"az",
        "wazazali":"az",
        "sfarente":"az",
        "ázerbájdžán":"az",
        "aserbajdsjansk":"az",
        "uza":"az",
        "aserbaidžaani":"az",
        "azerbaïdjanaise":"az",
        "azerbeidzjan":"az",
        "ouria":"az",
        "ოღონდ":"az",
        "aserbaidschaner":"az",
        "αζερμπαϊτζάν":"az",
        "પર્વત":"az",
        "haitian":"sl",
        "אזרביג'אן":"az",
        "a azerbaijaniani":"az",
        "azerbajdzsáni":"az",
        "aserbaídsjan":"az",
        "azero":"az",
        "アゼルバイジャン語":"az",
        "ಅಜೆರ್ಬೈಜಾನಿ":"az",
        "азербайжан":"az",
        "អាហ្សង់ទីន":"az",
        "아제르바이잔":"az",
        "kirdar":"az",
        "азербайжанча":"az",
        "a azerbaijani":"az",
        "azerbaidžāņu":"az",
        "azerbaidžaniečių":"az",
        "aserbaidschan":"az",
        "океан":"az",
        "azerbaijaney":"az",
        "azerbaijan":"az",
        "അസർബൈജാനി":"az",
        "tista '":"az",
        "पर्वत":"az",
        "азэрбани":"az",
        "အဇာဘိုင်ဂျန်":"az",
        "हिउँ":"az",
        "ଆଜେରବାଇଜାନି":"az",
        "سیند":"az",
        "اوکان":"az",
        "azerbejdżański":"az",
        "azerbaijana":"az",
        "ਪਹਾੜ":"az",
        "azeră":"az",
        "азербайджанец":"az",
        "aisani":"az",
        "азербаијани":"az",
        "azarus":"az",
        "azarusian":"az",
        "آذربائيجان...":"az",
        "azerbaiyana":"az",
        "azaba":"az",
        "озарбойҷон":"az",
        "அஜர்பைஜானி":"az",
        "อาเซอร์ไบจัน":"az",
        "azeri":"az",
        "азербайджанці":"az",
        "پہاڑ":"az",
        "ozarbayjon":"az",
        "thuyền":"az",
        "aserbaijani":"az",
        "iazerbaijan":"az",
        "isi-azerbaijani":"az",
        "basque":"eu",
        "bask":"eu",
        "ባስክ":"eu",
        "الباسك":"eu",
        "բասկերեն":"eu",
        "баска":"eu",
        "bas":"eu",
        "basc":"eu",
        "basurahan":"eu",
        "vascu":"eu",
        "baskijski":"eu",
        "baskicko":"eu",
        "baskisch":"eu",
        "eŭska":"eu",
        "baski":"eu",
        "baskysk":"eu",
        "vasco":"eu",
        "ბასკური":"eu",
        "βασκικός":"eu",
        "પ્રવાહી":"eu",
        "pōkē":"eu",
        "בסקית":"eu",
        "baszk":"eu",
        "baskneska":"eu",
        "basach":"eu",
        "basca":"eu",
        "バスク語":"eu",
        "basil":"eu",
        "ಬಾಸ್ಕ್":"eu",
        "баск":"eu",
        "바스크 사람":"eu",
        "baskî":"eu",
        "баскча":"eu",
        "ບົກ":"eu",
        "vasca":"eu",
        "basku":"eu",
        "baskų":"eu",
        "baskesch":"eu",
        "баскиски":"eu",
        "baska":"eu",
        "ബാസ്\u200cക്":"eu",
        "waiwai":"eu",
        "ओतणे":"eu",
        "сагс":"eu",
        "ရက်":"eu",
        "पोखरी":"eu",
        "baskisk":"eu",
        "ବାସ୍କ":"eu",
        "باسک":"eu",
        "باسکی":"eu",
        "basco":"eu",
        "ਫਲੈਟ":"eu",
        "bască":"eu",
        "баскский":"eu",
        "basgach":"eu",
        "бас":"eu",
        "chibasque":"eu",
        "بسڪاني":"eu",
        "බාස්ක්":"eu",
        "ชาวแบสค์":"eu",
        "روانی":"eu",
        "باسك":"eu",
        "cung cấp":"eu",
        "basgeg":"eu",
        "agbọn":"eu",
        "i-basque":"eu",
        "belarusian":"be",
        "bjellorusisht":"be",
        "ቤላሩሲያን":"be",
        "البيلاروسية":"be",
        "բելառուս":"be",
        "belarus":"be",
        "па-беларуску":"be",
        "bjeloruski":"be",
        "беларус":"be",
        "volem":"be",
        "bielorussu":"be",
        "běloruský":"be",
        "hviderussisk":"be",
        "wit-russisch":"be",
        "deziras":"be",
        "valgevenelane":"be",
        "valkovenäjä":"be",
        "biélorusse":"be",
        "wytrussysk":"be",
        "queremos":"be",
        "ბელორუსი":"be",
        "belarussisch":"be",
        "λευκορωσικά":"be",
        "વિદ્યુત":"be",
        "bèljik":"be",
        "belarusiyanci":"be",
        "ōlelo belarusa":"be",
        "בלארוסית":"be",
        "belorusz":"be",
        "hvítrússneska":"be",
        "bahasa belarus":"be",
        "bealarúisis":"be",
        "bielorussa":"be",
        "ベラルーシの":"be",
        "ಬೆಲರೂಸಿಯನ್":"be",
        "беларуссиялық":"be",
        "벨로루시 어":"be",
        "belarûsî":"be",
        "беларусча":"be",
        "belarusica":"be",
        "baltkrievu":"be",
        "baltarusis":"be",
        "wäissrussesch":"be",
        "блок":"be",
        "belarosiana":"be",
        "ബെലാറഷ്യൻ":"be",
        "xewqat":"be",
        "उर्जा":"be",
        "ဘီလာစီ":"be",
        "ବେଲାରସୀୟ":"be",
        "بلاروسي":"be",
        "بلاک":"be",
        "białoruski":"be",
        "bielorrusso":"be",
        "ਬਿਜਲੀ":"be",
        "belarusă":"be",
        "белорусский":"be",
        "pelalusiana":"be",
        "belarusianach":"be",
        "бјелоруски":"be",
        "chiberaruzi":"be",
        "بيلاروسي":"be",
        "බෙලාරුසියානු":"be",
        "beloruski":"be",
        "belarusiyaan":"be",
        "bielorrusa":"be",
        "vitryska":"be",
        "беларусӣ":"be",
        "பெலாரஷ்யன்":"be",
        "เบลารุส":"be",
        "білоруська":"be",
        "گرمی":"be",
        "بېلورۇسىيە":"be",
        "belaruslik":"be",
        "người belarus":"be",
        "belarwseg":"be",
        "isibhelarushiyen":"be",
        "בעלגיע":"be",
        "i-belarusian":"be",
        "bengali":"bn",
        "ቤንጋሊ":"bn",
        "البنغالية":"bn",
        "բենգալի":"bn",
        "бенгальская":"bn",
        "বাংলা":"bn",
        "бенгалски":"bn",
        "bengalski":"bn",
        "bengálský":"bn",
        "bengaals":"bn",
        "bengaalsk":"bn",
        "bengalí":"bn",
        "ბენგალი":"bn",
        "μπενγκάλι":"bn",
        "બેંગાલી":"bn",
        "penekali":"bn",
        "בנגאלי":"bn",
        "बंगाली":"bn",
        "bengáli":"bn",
        "benggala":"bn",
        "bengalese":"bn",
        "ベンガル語":"bn",
        "ಬೆಂಗಾಲಿ":"bn",
        "бенгали":"bn",
        "បេនហ្គាលី":"bn",
        "벵골 사람":"bn",
        "bengalî":"bn",
        "бенгалча":"bn",
        "ເບື່ອ":"bn",
        "bengalica":"bn",
        "bengāļu valoda":"bn",
        "bengalų kalba":"bn",
        "bengalesch":"bn",
        "ബംഗാളി":"bn",
        "ဘင်ဂါလီ":"bn",
        "ବଙ୍ଗାଳୀ":"bn",
        "بنگالی":"bn",
        "ਬੰਗਾਲੀ":"bn",
        "бенгальский":"bn",
        "bengàlach":"bn",
        "chibengali":"bn",
        "بنگالي":"bn",
        "බෙංගාලි":"bn",
        "бенгалй":"bn",
        "பெங்காலி":"bn",
        "బెంగాలీ":"bn",
        "ประเทศบังคลาเทศ":"bn",
        "bengal":"bn",
        "бенгальська":"bn",
        "bosniese":"bs",
        "boshnjake":"bs",
        "ቦስንያን":"bs",
        "البوسنية":"bs",
        "բոսնյան":"bs",
        "bosniyalı":"bs",
        "bosniako":"bs",
        "баснійскі":"bs",
        "বসনীয়":"bs",
        "bosanski":"bs",
        "босненски":"bs",
        "bosnià":"bs",
        "bosnian":"bs",
        "wa pachifuwa":"bs",
        "bosniacu":"bs",
        "bosniske":"bs",
        "bosnisch":"bs",
        "bosno":"bs",
        "bosniaque":"bs",
        "bosnysk":"bs",
        "bosnio":"bs",
        "ბოსნიური":"bs",
        "μποσνιανός":"bs",
        "બોસ્નિઅન":"bs",
        "bosnyen":"bs",
        "ponia":"bs",
        "בוסני":"bs",
        "बोस्नियाई":"bs",
        "bosníska":"bs",
        "bosniaca":"bs",
        "ボスニア語":"bs",
        "ಬೋಸ್ನಿಯನ್":"bs",
        "босния":"bs",
        "보스니아 어":"bs",
        "bosnayî":"bs",
        "бошнакча":"bs",
        "bosnesch":"bs",
        "босански":"bs",
        "bosniaka":"bs",
        "ബോസ്നിയൻ":"bs",
        "bosnjan":"bs",
        "rangatira":"bs",
        "बोसनीयन":"bs",
        "босний":"bs",
        "။ ။":"bs",
        "बोसियन":"bs",
        "bosnisk":"bs",
        "بوسنیایی":"bs",
        "بوسنی":"bs",
        "bośniacki":"bs",
        "bósnio":"bs",
        "ਬੋਸਨੀਅਨ":"bs",
        "bosniac":"bs",
        "боснийский":"bs",
        "bosnianach":"bs",
        "chibosnian":"bs",
        "بوسنيائي":"bs",
        "බොස්නියානු":"bs",
        "bosnianska":"bs",
        "bosnia":"bs",
        "босня":"bs",
        "போஸ்னியன்":"bs",
        "బోస్నియన్":"bs",
        "บอสเนีย":"bs",
        "bosnalı":"bs",
        "боснійський":"bs",
        "بوسنیا":"bs",
        "bosniya":"bs",
        "bosniani":"bs",
        "bulgarian":"bg",
        "ቡልጋርያኛ":"bg",
        "البلغارية":"bg",
        "բուլղարերեն":"bg",
        "bulqar":"bg",
        "балгарская":"bg",
        "বুলগেরীয়":"bg",
        "bugarski":"bg",
        "български":"bg",
        "búlgar":"bg",
        "chibugariya":"bg",
        "bulgaru":"bg",
        "bulharský":"bg",
        "bulgarsk":"bg",
        "bulgaars":"bg",
        "bulgara":"bg",
        "bulgaaria keel":"bg",
        "bulgarialainen":"bg",
        "bulgare":"bg",
        "bulgaarsk":"bg",
        "búlgaro":"bg",
        "ბულგარული":"bg",
        "bulgarisch":"bg",
        "βούλγαρος":"bg",
        "ઇલેક્ટ્રિકલ":"bg",
        "bulgari":"bg",
        "pukalia":"bg",
        "בולגרית":"bg",
        "bolgár":"bg",
        "búlgarska":"bg",
        "bulgaria":"bg",
        "bulgáiris":"bg",
        "ブルガリア語":"bg",
        "ಬಲ್ಗೇರಿಯನ್":"bg",
        "болгар":"bg",
        "불가리아 사람":"bg",
        "bûlgarî":"bg",
        "болгарча":"bg",
        "bulgarica":"bg",
        "bulgāru":"bg",
        "bulgarų":"bg",
        "bulgarescg":"bg",
        "бугарски":"bg",
        "biolgara":"bg",
        "orang bulgaria":"bg",
        "ബൾഗേറിയൻ":"bg",
        "बडबड":"bg",
        "болгар хүн":"bg",
        "ဘူဂေးရီးယား":"bg",
        "ब्लड":"bg",
        "ବୁଲଗେରିଆନ୍ |":"bg",
        "bułgarski":"bg",
        "búlgara":"bg",
        "ਇਲੈਕਟ੍ਰੋਲਿਕ":"bg",
        "bulgară":"bg",
        "болгарский":"bg",
        "bulgàrianach":"bg",
        "chibulgarian":"bg",
        "بلغاريائي":"bg",
        "බල්ගේරියානු":"bg",
        "bolgarščina":"bg",
        "булгарӣ":"bg",
        "பல்கேரியன்":"bg",
        "บัลแกเรีย":"bg",
        "bulgar":"bg",
        "болгарська":"bg",
        "بلغاری":"bg",
        "بۇلغارىيە":"bg",
        "bulgariyalik":"bg",
        "bungari":"bg",
        "bwlgaria":"bg",
        "בולגאַריש":"bg",
        "isi-bulgaria":"bg",
        "catalan":"ca",
        "ካታሊያን":"ca",
        "الكاتالونية":"ca",
        "կատալաներեն":"ca",
        "katalan":"ca",
        "лад":"ca",
        "каталонски":"ca",
        "català":"ca",
        "chikatalani":"ca",
        "catalanu":"ca",
        "katalonski":"ca",
        "katalánština":"ca",
        "catalansk":"ca",
        "catalaans":"ca",
        "kataluna":"ca",
        "katalaani keeles":"ca",
        "catalane":"ca",
        "katalaansk":"ca",
        "catalán":"ca",
        "კატალონიური":"ca",
        "katalanisch":"ca",
        "καταλανικά":"ca",
        "સંપૂર્ણ":"ca",
        "ōlelo katalonia":"ca",
        "קטלאנית":"ca",
        "katalán":"ca",
        "katalónska":"ca",
        "katalogi":"ca",
        "catalóinis":"ca",
        "catalana":"ca",
        "カタロニア語":"ca",
        "ಕ್ಯಾಟಲಾನ್":"ca",
        "каталан":"ca",
        "카탈로니아 사람":"ca",
        "katalanî":"ca",
        "каталанча":"ca",
        "katalāņu":"ca",
        "katalonų":"ca",
        "katalanesch":"ca",
        "katalana":"ca",
        "കറ്റാലൻ":"ca",
        "परिपूर्ण":"ca",
        "ကွမ်းခြံကုန်း":"ca",
        "सिद्ध":"ca",
        "କାଟାଲାନ୍":"ca",
        "کتالین":"ca",
        "كاتاليك":"ca",
        "kataloński":"ca",
        "catalã":"ca",
        "ਸੰਪੂਰਨ":"ca",
        "каталонский":"ca",
        "catalanach":"ca",
        "цаталан":"ca",
        "katatata":"ca",
        "katarani":"ca",
        "කැටලන්":"ca",
        "katalánčina":"ca",
        "kulinarično":"ca",
        "katol":"ca",
        "kikatalani":"ca",
        "katalansk":"ca",
        "கற்றலான்":"ca",
        "คาตาลัน":"ca",
        "каталон":"ca",
        "کامل":"ca",
        "quy mô":"ca",
        "isikhathalan":"ca",
        "ikatalani":"ca",
        "cebuano":"ceb",
        "سيبوانو":"ceb",
        "ցեբուանո":"ceb",
        "চেবুয়ানো":"ceb",
        "себуано":"ceb",
        "tsebuano":"ceb",
        "კებუანო":"ceb",
        "સિબુઆનો":"ceb",
        "קבאו":"ceb",
        "सिबुआनो":"ceb",
        "cebsiab":"ceb",
        "kebúano":"ceb",
        "セブアノ":"ceb",
        "ಸೆಬುವಾನೋ":"ceb",
        "អាហារបំប៉ន":"ceb",
        "세부 아노":"ceb",
        "ຄວາມເບີກບານ":"ceb",
        "цебуано":"ceb",
        "кебуана":"ceb",
        "ସେବୁଆନୋ |":"ceb",
        "سیبانو...":"ceb",
        "cebuana":"ceb",
        "ਸੇਬੂਆਨੋ":"ceb",
        "кебуано":"ceb",
        "ڪيوبوانو":"ceb",
        "సేబుఆనో":"ceb",
        "سیبانو":"ceb",
        "kabuano":"ceb",
        "cevano":"ceb",
        "chichewa":"ny",
        "ቺካዋዋ":"ny",
        "شيشوا":"ny",
        "չիչվա":"ny",
        "çichewa":"ny",
        "чычэва":"ny",
        "চীচেওয়া":"ny",
        "чичеуа":"ny",
        "ჩიჩავა":"ny",
        "ચિચેવા":"ny",
        "צ'יצ'ווה":"ny",
        "चिचेवा":"ny",
        "チチェワ":"ny",
        "ಚಿಚೆವಾ":"ny",
        "чичева":"ny",
        "ឈីហេវ៉ា":"ny",
        "치체와":"ny",
        "жапон":"ja",
        "čičeva":"ny",
        "ചിചേവ":"ny",
        "ချစ်ချစ်":"ny",
        "چيچوا":"ny",
        "چیچوا":"ny",
        "ਚੀਚੇਵਾ":"ny",
        "цхицхева":"ny",
        "چيچي":"ny",
        "චිචෙවා":"ny",
        "చిచెవా":"ny",
        "chicheva":"ny",
        "чічева":"ny",
        "chinees (vereenvoudig)":"zh-CN",
        "chinees":"zh-CN",
        "kineze (e thjeshtuar)":"zh-CN",
        "kineze":"zh-CN",
        "ቻይንኛ (ቀለል ያለ)":"zh-CN",
        "ቻይንኛ":"zh-CN",
        "الصينية المبسطة)":"zh-CN",
        "չինական (պարզեցված)":"zh-cn",
        "չինական":"zh-cn",
        "çin (sadələşdirilmiş)":"zh-CN",
        "çin":"zh-CN",
        "txinera (sinplifikatua)":"zh-CN",
        "txinera":"zh-CN",
        "кітайскі (спрошчаны)":"zh-CN",
        "кітайскі":"zh-CN",
        "সরলীকৃত চীনা)":"zh-CN",
        "kineska (pojednostavljena)":"zh-CN",
        "kineska":"zh-CN",
        "опростен китайски)":"zh-CN",
        "xinès (simplificat)":"zh-CN",
        "xinès":"zh-CN",
        "chinese (gipasimple)":"zh-CN",
        "chinese (chosavuta)":"zh-CN",
        "cinese (simplificatu)":"zh-CN",
        "cinese":"zh-CN",
        "zjednodušená čínština":"zh-cn",
        "kinesisk forenklet":"zh-cn",
        "versimpeld chinees":"zh-CN",
        "chinese (simplified)":"zh-CN",
        "ĉina (simpligita)":"zh-CN",
        "ĉina":"zh-CN",
        "lihtsustatud hiina keel)":"zh-CN",
        "intsik (pinasimple)":"zh-cn",
        "intsik":"zh-cn",
        "yksinkertaistettu kiina)":"zh-cn",
        "chinois":"zh-CN",
        "chinois simplifié":"zh-CN",
        "chinois (simplifié)":"zh-CN",
        "sineesk (ferienfâldige)":"zh-CN",
        "sineesk":"zh-CN",
        "chinés (simplificado)":"zh-cn",
        "chinés":"zh-cn",
        "გამარტივებული ჩინური)":"zh-CN",
        "vereinfachtes chinesisch)":"zh-CN",
        "απλοποιημένα κινέζικα)":"zh-CN",
        "ચાઇનીઝ (સરળ)":"zh-CN",
        "chinwa (senplifye)":"zh-CN",
        "kasar sinanci (a saukake)":"zh-CN",
        "ʻohana":"zh-CN",
        "סינית מופשטת)":"zh-CN",
        "सरलीकृत चीनी)":"zh-CN",
        "suav (yooj yim zog)":"zh-CN",
        "kínai (egyszerűsített)":"zh-CN",
        "kínverska (einfölduð)":"zh-CN",
        "china (simplified)":"zh-CN",
        "bahasa tiongkok yang disederhanakan)":"zh-CN",
        "sínis (simplithe)":"zh-CN",
        "cinese semplificato)":"zh-cn",
        "中国語（簡体字）":"zh-CN",
        "cina (disederhanakake)":"zh-CN",
        "ಚೈನೀಸ್ (ಸರಳೀಕೃತ)":"zh-CN",
        "қытай (жеңілдетілген)":"zh-CN",
        "ចិន (សាមញ្ញ)":"zh-CN",
        "중국어 (간체)":"zh-CN",
        "çînî (sade kirin)":"zh-CN",
        "кытайча (жөнөкөйлөтүлгөн)":"zh-CN",
        "ພາສາຈີນ (ແບບງ່າຍ)":"zh-CN",
        "seres (facilius)":"zh-CN",
        "ķīniešu (vienkāršota)":"zh-CN",
        "kinų (supaprastinta)":"zh-CN",
        "chineesesch (vereinfacht)":"zh-CN",
        "кинески (поедноставен)":"zh-CN",
        "sinoa (natsotra)":"zh-CN",
        "cina (dipermudahkan)":"zh-cn",
        "സുഗമമാക്കിയ ചൈനീസ്)":"zh-CN",
        "ċiniż (simplifikat)":"zh-CN",
        "hainamana (ka whakatauhia)":"zh-cn",
        "चीनी (सरलीकृत)":"zh-CN",
        "хятад (хялбаршуулсан)":"zh-CN",
        "တရုတ် (ရိုးရှင်း)":"zh-CN",
        "चिनियाँ (सरलीकृत)":"zh-CN",
        "forenklet kinesisk)":"zh-CN",
        "ଚାଇନିଜ୍ (ସରଳୀକୃତ)":"zh-CN",
        "چینایی (ساده شوی)":"zh-CN",
        "زبان چینی ساده شده)":"zh-CN",
        "uproszczony chiński)":"zh-CN",
        "chinês simplificado)":"zh-CN",
        "ਚੀਨੀ (ਸਰਲ)":"zh-CN",
        "chineză simplificată)":"zh-CN",
        "китайский упрощенный)":"zh-CN",
        "saina (faʻafaigofie)":"zh-CN",
        "china (simplichte)":"zh-CN",
        "кинеска (поједностављена)":"zh-CN",
        "chinese (e nolofalitsoeng)":"zh-CN",
        "chinese (chinorerutswa)":"zh-CN",
        "چيني (سادگي وارو)":"zh-CN",
        "චීන (සරල)":"zh-CN",
        "kitajska (poenostavljena)":"zh-CN",
        "shiinaha (la fududeeyey)":"zh-cn",
        "china (simplificada)":"zh-CN",
        "cina (disederhanakeun)":"zh-CN",
        "kichina (kilichorahisishwa)":"zh-CN",
        "förenklad kinesiska)":"zh-CN",
        "хитоӣ (соддакардашуда)":"zh-CN",
        "சீன (எளிமைப்படுத்தப்பட்ட)":"zh-CN",
        "సులభమైన చైనా భాష)":"zh-CN",
        "จีน (ตัวย่อ)":"zh-CN",
        "basitleştirilmiş çince)":"zh-CN",
        "китайська (спрощена)":"zh-CN",
        "آسان چینی زبان)":"zh-CN",
        "خەنزۇچە (ئاددىيلاشتۇرۇلغان)":"zh-CN",
        "xitoycha (soddalashtirilgan)":"zh-CN",
        "trung quốc (đơn giản hóa)":"zh-CN",
        "tsieineaidd (wedi'i symleiddio)":"zh-CN",
        "isi-chinese (lula)":"zh-CN",
        "כינעזיש":"zh-cn",
        "kannada (ni irọrun)":"zh-CN",
        "chinees (tradisioneel)":"zh-TW",
        "tradita kineze)":"zh-TW",
        "ቻይንኛ (ባህላዊ)":"zh-TW",
        "تقاليد صينية)":"zh-TW",
        "չինական (ավանդական)":"zh-tw",
        "çin (ənənəvi)":"zh-TW",
        "txinatarra (tradizionala)":"zh-TW",
        "кітайскі (традыцыйны)":"zh-TW",
        "প্রথাগত চীনা)":"zh-TW",
        "kineska (tradicionalna)":"zh-TW",
        "традиционен китайски)":"zh-TW",
        "xinès (tradicional)":"zh-TW",
        "chinese (tradisyonal)":"zh-TW",
        "wachichaina (wachikhalidwe)":"zh-TW",
        "cinese (tradiziunale)":"zh-TW",
        "kinesko tradicionalno)":"zh-TW",
        "čínština (tradiční)":"zh-tw",
        "kinesisk (traditionel)":"zh-tw",
        "chinese traditionele)":"zh-TW",
        "chinese (traditional)":"zh-TW",
        "ĉina (tradicia)":"zh-TW",
        "traditsiooniline hiina keel)":"zh-TW",
        "intsik (tradisyonal)":"zh-tw",
        "kiinalainen perinteinen)":"zh-tw",
        "chinois (traditionnel)":"zh-TW",
        "sineesk (tradisjoneel)":"zh-TW",
        "chinés (tradicional)":"zh-tw",
        "ჩინური (ტრადიციული)":"zh-TW",
        "chinesische tradition)":"zh-TW",
        "παραδοσιακά κινέζικα)":"zh-TW",
        "ચાઇનીઝ (પરંપરાગત)":"zh-TW",
        "chinwa (tradisyonèl)":"zh-TW",
        "harshen kasar sin (na gargajiya)":"zh-TW",
        "laulima":"zh-TW",
        "מסורת סינית)":"zh-TW",
        "चीनी पारंपरिक)":"zh-TW",
        "suav (tsoos)":"zh-TW",
        "kínai (hagyományos)":"zh-TW",
        "kínverska (hefðbundin)":"zh-TW",
        "china (ọdịnala)":"zh-TW",
        "cina tradisional)":"zh-TW",
        "sínis (traidisiúnta)":"zh-TW",
        "cinese tradizionale)":"zh-tw",
        "中国の伝統的な）":"zh-TW",
        "cina (tradisional)":"zh-tw",
        "ಚೈನೀಸ್ (ಸಾಂಪ್ರದಾಯಿಕ)":"zh-TW",
        "қытай (дәстүрлі)":"zh-TW",
        "ប្រពៃណីចិន)":"zh-TW",
        "중국 전통)":"zh-TW",
        "çînî (kevneşopî)":"zh-TW",
        "кытай (салттуу)":"zh-TW",
        "ຈີນ (ດັ້ງເດີມ)":"zh-TW",
        "seres (traditional)":"zh-TW",
        "ķīniešu (tradicionālā)":"zh-TW",
        "kinų tradicinis)":"zh-TW",
        "chineesesch (traditionell)":"zh-TW",
        "кинески (традиционален)":"zh-TW",
        "sinoa (nentin-drazana)":"zh-TW",
        "ചൈനീസ് പാരമ്പര്യമായ)":"zh-TW",
        "ċiniż (tradizzjonali)":"zh-TW",
        "hainamana (tuku iho)":"zh-tw",
        "पारंपारिक चीनी)":"zh-TW",
        "хятадын уламжлалт)":"zh-TW",
        "တရုတ်ရိုးရာ)":"zh-TW",
        "चिनियाँ (परम्परागत)":"zh-TW",
        "tradisjonell kinesisk)":"zh-TW",
        "ଚାଇନିଜ୍ (ପାରମ୍ପାରିକ)":"zh-TW",
        "چینایي":"zh-TW",
        "چینی (سنتی)":"zh-TW",
        "chiński tradycyjny)":"zh-TW",
        "chinês tradicional)":"zh-TW",
        "ਚੀਨੀ (ਰਵਾਇਤੀ)":"zh-TW",
        "tradițional chinezesc)":"zh-TW",
        "китайский традиционный)":"zh-TW",
        "saina (masani)":"zh-TW",
        "sìneach (traidiseanta)":"zh-TW",
        "традиционални кинески)":"zh-TW",
        "chinese (setso)":"zh-TW",
        "chinese (zvetsika)":"zh-TW",
        "چيني (روايتي)":"zh-TW",
        "චීන (සාම්ප්\u200dරදායික)":"zh-TW",
        "tradične čínske)":"zh-TW",
        "kitajska (tradicionalna)":"zh-TW",
        "shiinaha (dhaqameed)":"zh-tw",
        "china (tradicional)":"zh-TW",
        "kichina (cha jadi)":"zh-TW",
        "traditionell kinesisk)":"zh-TW",
        "хитоӣ (анъанавӣ)":"zh-TW",
        "சீன (பாரம்பரிய)":"zh-TW",
        "చైనీస్ (సాంప్రదాయ)":"zh-TW",
        "จีน (ดั้งเดิม)":"zh-TW",
        "çin geleneği)":"zh-TW",
        "китайський традиційний)":"zh-TW",
        "چینی (روایتی)":"zh-TW",
        "خەنزۇچە (ئەنئەنىۋى)":"zh-TW",
        "xitoy (an'anaviy)":"zh-TW",
        "truyền thống trung hoa)":"zh-TW",
        "tsieineaidd (traddodiadol)":"zh-TW",
        "isi-chinese (ngokwesiko)":"zh-TW",
        "כינעזיש (טראַדיציאָנעל)":"zh-tw",
        "kannada (ibile)":"zh-TW",
        "isishayina (ngokwesiko)":"zh-TW",
        "korsikaans":"co",
        "corsican":"co",
        "ኮርሲካን":"co",
        "كورسيكان":"co",
        "կորսիկյան":"co",
        "korsikalı":"co",
        "korsikera":"co",
        "карсіканскі":"co",
        "কর্সিকান":"co",
        "korzikanski":"co",
        "корсикански":"co",
        "corsari":"co",
        "kakhori":"co",
        "corsu":"co",
        "korzički":"co",
        "korsičan":"co",
        "korsikansk":"co",
        "corsicaans":"co",
        "korsikano":"co",
        "korsikalainen":"co",
        "corse":"co",
        "korsikaansk":"co",
        "corsario":"co",
        "კორსიკელი":"co",
        "korsisch":"co",
        "κορσικανός":"co",
        "કોર્સિકન":"co",
        "korsik":"co",
        "ōlelo kokia":"co",
        "קורסיקנית":"co",
        "कोर्सीकन":"co",
        "korzikai":"co",
        "korsíska":"co",
        "korsika":"co",
        "コルシカ":"co",
        "korsikan":"co",
        "ಕಾರ್ಸಿಕನ್":"co",
        "корсик":"co",
        "코르시카 어":"co",
        "korsîkayî":"co",
        "корсикче":"co",
        "corsica":"co",
        "korsikānis":"co",
        "korsikas":"co",
        "korsesch":"co",
        "корзикан":"co",
        "കോർസിക്കൻ":"co",
        "korsikjan":"co",
        "कोर्सिकन":"co",
        "कोर्सिकान":"co",
        "କର୍ସିକାନ୍ |":"co",
        "کورسیکن":"co",
        "کره ای":"ko",
        "korsykański":"co",
        "ਕਾਰਸਿਕਨ":"co",
        "corsicană":"co",
        "корсиканец":"co",
        "kosikana":"co",
        "corsicanach":"co",
        "корзикански":"co",
        "kosikeni":"co",
        "ڪارسيڪائي":"co",
        "korzičan":"co",
        "korziška":"co",
        "corso":"co",
        "korosho":"co",
        "корсикан":"co",
        "கோர்சிகன்":"co",
        "కోర్సికన్":"co",
        "คอร์ซิกา":"co",
        "корсиканський":"co",
        "کارسیکن":"co",
        "korsikalik":"co",
        "isikhorsikhen":"co",
        "kọsitọmu":"co",
        "i-corsican":"co",
        "croatian":"hr",
        "ክሮኤሽያን":"hr",
        "الكرواتية":"hr",
        "խորվաթերեն":"hr",
        "xoruz":"hr",
        "харвацкая":"hr",
        "hrvatska":"hr",
        "хърватски":"hr",
        "croat":"hr",
        "momwemonso":"hr",
        "cruatu":"hr",
        "hrvatski":"hr",
        "chorvatský":"hr",
        "kroatisk":"hr",
        "kroatisch":"hr",
        "kroata":"hr",
        "horvaadi keeles":"hr",
        "kroaatti":"hr",
        "croate":"hr",
        "kroatysk":"hr",
        "croata":"hr",
        "ხორვატული":"hr",
        "κροατία":"hr",
        "કુશળ":"hr",
        "kwoasyen":"hr",
        "koalia":"hr",
        "קרואטי":"hr",
        "क्रोएशियाई":"hr",
        "caj pas":"hr",
        "horvát":"hr",
        "króatíska":"hr",
        "kroasia":"hr",
        "クロアチア語":"hr",
        "ಕ್ರೊಯೇಷಿಯನ್":"hr",
        "хорват":"hr",
        "크로아티아":"hr",
        "xirwatî":"hr",
        "хорватча":"hr",
        "crovatica":"hr",
        "horvātu":"hr",
        "kroatų":"hr",
        "kroatesch":"hr",
        "хрватски":"hr",
        "kroaty":"hr",
        "ക്രൊയേഷ്യൻ":"hr",
        "kroat":"hr",
        "कुशल":"hr",
        "крипиан":"hr",
        "ခရိုဒီးယား":"hr",
        "प्राविधिक":"hr",
        "କ୍ରୋଏସିଆନ୍":"hr",
        "کرواسین":"hr",
        "کرواتی":"hr",
        "chorwacki":"hr",
        "ਕੁਸ਼ਲ":"hr",
        "хорватский":"hr",
        "croatianach":"hr",
        "ka mokhoa o ts'oanang":"hr",
        "chicroatian":"hr",
        "ڪروشيائي":"hr",
        "ක්\u200dරොඒෂියානු":"hr",
        "chorvátsky":"hr",
        "hrvaščina":"hr",
        "vivyo hivyo":"hr",
        "ҳунарманд":"hr",
        "குரோஷியன்":"hr",
        "โครเอเชีย":"hr",
        "hırvat":"hr",
        "хорватська":"hr",
        "ماہر":"hr",
        "xorvatiyalik":"hr",
        "tiếng anh":"en",
        "קראָאַטיאַן":"hr",
        "ngokufanayo":"hr",
        "czech":"cs",
        "çek":"cs",
        "ቼክ":"cs",
        "التشيكية":"cs",
        "չեխերեն":"cs",
        "çex":"cs",
        "чэшская":"cs",
        "চেক":"cs",
        "češki":"cs",
        "чешки":"cs",
        "txec":"cs",
        "ceccu":"cs",
        "čeština":"cs",
        "tjekkisk":"cs",
        "tsjechisch":"cs",
        "ĉe .a":"cs",
        "tšehhi":"cs",
        "tchèque":"cs",
        "tsjechysk":"cs",
        "checo":"cs",
        "ჩეხური":"cs",
        "tschechisch":"cs",
        "τσέχος":"cs",
        "ચેક":"cs",
        "keka":"cs",
        "צ'כית":"cs",
        "चेक":"cs",
        "cseh":"cs",
        "tékknesku":"cs",
        "njikwa":"cs",
        "ceko":"cs",
        "ceca":"cs",
        "チェコ語":"cs",
        "ಜೆಕ್":"cs",
        "чех":"cs",
        "ឆែក":"cs",
        "체코 사람":"cs",
        "çekî":"cs",
        "чехче":"cs",
        "ເຊັກ":"cs",
        "bohemica":"cs",
        "čehu":"cs",
        "čekų":"cs",
        "tschechesch":"cs",
        "bahasa czech":"cs",
        "ചെക്ക്":"cs",
        "ċeka":"cs",
        "ချက်":"cs",
        "tsjekkisk":"cs",
        "ଚେକ୍":"cs",
        "کشور چک":"cs",
        "tcheca":"cs",
        "ਚੈਕ":"cs",
        "ceh":"cs",
        "чешский":"cs",
        "seacach":"cs",
        "chiczech":"cs",
        "چيڪ ٻولي":"cs",
        "චෙක්":"cs",
        "český":"cs",
        "češko":"cs",
        "checa":"cs",
        "tjeck":"cs",
        "чехия":"cs",
        "செக்":"cs",
        "สาธารณรัฐเช็ก":"cs",
        "чеська":"cs",
        "چیک":"cs",
        "chex":"cs",
        "séc":"cs",
        "sosipo":"cs",
        "danish":"da",
        "danez":"da",
        "ዳኒሽ":"da",
        "دانماركي":"da",
        "դանիերեն":"da",
        "датчане":"da",
        "ডেনমার্কের":"da",
        "danski":"da",
        "датски":"da",
        "danès":"da",
        "danese":"da",
        "dánština":"da",
        "dansk":"da",
        "deens":"da",
        "danoj":"da",
        "taanlane":"da",
        "tanskan kieli":"da",
        "danoise":"da",
        "deensk":"da",
        "danés":"da",
        "დანიური":"da",
        "dänisch":"da",
        "δανικός":"da",
        "ડેનિશ":"da",
        "danwa":"da",
        "kenemaka":"da",
        "דַנִי":"da",
        "दानिश":"da",
        "seev cev":"da",
        "dán":"da",
        "dönsku":"da",
        "ịgba egwu":"da",
        "orang denmark":"da",
        "デンマーク語":"da",
        "nari":"da",
        "ಡ್ಯಾನಿಶ್":"da",
        "дат":"da",
        "រាំ":"da",
        "덴마크 말":"da",
        "danîmarkî":"da",
        "датча":"da",
        "ເຕັ້ນ":"da",
        "danica":"da",
        "dāņu":"da",
        "danai":"da",
        "dänesch":"da",
        "дански":"da",
        "danoà":"da",
        "ഡാനിഷ്":"da",
        "daniż":"da",
        "whakangahau":"da",
        "डॅनिश":"da",
        "дани":"da",
        "ဒိန်းမတ်":"da",
        "डेनिस":"da",
        "ଡାନିଶ୍ |":"da",
        "دنمارکي":"da",
        "دانمارکی":"da",
        "duński":"da",
        "dinamarquês":"da",
        "ਡੈਨਿਸ਼":"da",
        "датский язык":"da",
        "dànach":"da",
        "chidanish":"da",
        "ڊينش ٻولي":"da",
        "දානිෂ්":"da",
        "dánsky":"da",
        "dhaanto":"da",
        "danesa":"da",
        "nanjak":"da",
        "даниш":"da",
        "เดนมาร์ก":"da",
        "danimarkalı":"da",
        "датський":"da",
        "ڈینش":"da",
        "daniyalik":"da",
        "người đan mạch":"da",
        "דאַניש":"da",
        "ijó":"da",
        "nederlands":"nl",
        "holandez":"nl",
        "ደች":"nl",
        "هولندي":"nl",
        "հոլանդական":"nl",
        "xəndək":"nl",
        "dutch":"nl",
        "галандская":"nl",
        "ডাচ":"nl",
        "holandski":"nl",
        "холандски":"nl",
        "holandès":"nl",
        "chisilamu":"nl",
        "ulandesa":"nl",
        "nizozemac":"nl",
        "holandský":"nl",
        "hollandske":"nl",
        "nederlanda":"nl",
        "hollandlane":"nl",
        "tulak":"nl",
        "hollannin kieli":"nl",
        "néerlandaise":"nl",
        "nederlânsk":"nl",
        "holandés":"nl",
        "ჰოლანდიური":"nl",
        "niederländisch":"nl",
        "ολλανδός":"nl",
        "ડચ":"nl",
        "olandè":"nl",
        "hōlani":"nl",
        "הוֹלַנדִי":"nl",
        "डच":"nl",
        "lub dutch":"nl",
        "holland":"nl",
        "hollensk":"nl",
        "belanda":"nl",
        "ollainnis":"nl",
        "olandese":"nl",
        "オランダの":"nl",
        "dhuh":"nl",
        "ಡಚ್":"nl",
        "ілмек":"nl",
        "ប្រទេសហូឡង់":"nl",
        "네덜란드 사람":"nl",
        "holandî":"nl",
        "нидерландча":"nl",
        "ໂຮນລັງ":"nl",
        "batavica":"nl",
        "holandiešu":"nl",
        "olandas":"nl",
        "hollänesch":"nl",
        "anarana iombonana":"nl",
        "ഡച്ച്":"nl",
        "olandiż":"nl",
        "horoi":"nl",
        "ဒတ်ချ်":"nl",
        "nederlandsk":"nl",
        "ଡଚ୍":"nl",
        "الماني":"nl",
        "هلندی":"nl",
        "holenderski":"nl",
        "holandesa":"nl",
        "ਡੱਚ":"nl",
        "olandeză":"nl",
        "нидерландский язык":"nl",
        "siamani":"de",
        "duitseach":"nl",
        "borithane":"nl",
        "chidutch":"nl",
        "ڊچ ٻولي":"nl",
        "ලන්දේසි":"nl",
        "nizozemski":"nl",
        "déwék":"nl",
        "jadi":"nl",
        "дандон":"nl",
        "டச்சு":"nl",
        "ดัตช์":"nl",
        "flemenkçe":"nl",
        "голландський":"nl",
        "ڈچ":"nl",
        "hà lan":"lv",
        "isidatshi":"nl",
        "האָלענדיש":"nl",
        "i-arabhu":"nl",
        "engels":"en",
        "anglisht":"en",
        "እንግሊዝኛ":"en",
        "الإنجليزية":"en",
        "անգլերեն":"en",
        "ingilis":"en",
        "ingelesez":"en",
        "англійская":"en",
        "ইংরেজি":"en",
        "engleski":"en",
        "английски":"en",
        "anglès":"en",
        "iningles":"en",
        "chingerezi":"en",
        "inglese":"en",
        "angličtina":"en",
        "engelsk":"en",
        "english":"en",
        "angla":"en",
        "inglise":"en",
        "ingles":"en",
        "englanti":"en",
        "anglaise":"en",
        "ingelsk":"en",
        "inglés":"en",
        "ინგლისური":"en",
        "englisch":"en",
        "αγγλικά":"en",
        "અંગ્રેજી":"en",
        "anglè":"en",
        "turanci":"en",
        "pelekania":"en",
        "אנגלית":"en",
        "अंग्रेज़ी":"en",
        "askiv":"en",
        "angol":"en",
        "enska":"en",
        "inggris":"en",
        "béarla":"en",
        "英語":"en",
        "ಆಂಗ್ಲ":"en",
        "қазақша":"en",
        "ភាសាអង់គ្លេស":"en",
        "영어":"en",
        "îngilîzî":"en",
        "англисче":"en",
        "ອັງກິດ":"en",
        "anglicus":"en",
        "angļu":"en",
        "anglų":"en",
        "englesch":"en",
        "англиски":"en",
        "anglisy":"en",
        "bahasa inggeris":"en",
        "ഇംഗ്ലീഷ്":"en",
        "bl-ingliż":"en",
        "ingarihi":"en",
        "इंग्रजी":"en",
        "англи хэл":"en",
        "အင်္ဂလိပ်":"en",
        "अंग्रेजी":"en",
        "ଇଂରାଜୀ":"en",
        "انګلیسي...":"en",
        "język angielski":"en",
        "inglês":"en",
        "ਅੰਗਰੇਜ਼ੀ":"en",
        "engleză":"en",
        "английский":"en",
        "igilisi":"uz",
        "sasannach":"en",
        "енглески језик":"en",
        "chirungu":"en",
        "انگريزي":"en",
        "ඉංග්රීසි":"en",
        "angleščina":"en",
        "ingiriisi":"en",
        "inglesa":"en",
        "kiingereza":"en",
        "англисӣ":"en",
        "ஆங்கிலம்":"en",
        "ఆంగ్ల":"en",
        "อังกฤษ":"en",
        "ingilizce":"en",
        "англійська":"en",
        "انگریزی":"en",
        "inglizcha":"en",
        "saesneg":"en",
        "isingesi":"en",
        "ענגליש":"en",
        "gẹẹsi":"en",
        "isingisi":"en",
        "esperanto":"eo",
        "እስፔራንቶ":"eo",
        "إسبرانتو":"eo",
        "էսպերանտո":"eo",
        "эсперанта":"eo",
        "এস্পেরান্তো":"eo",
        "есперанто":"eo",
        "esperantu":"eo",
        "espéranto":"eo",
        "ესპერანტო":"eo",
        "εσπεράντο":"eo",
        "એસ્પેરેન્ટો":"eo",
        "ōlelo esperanto":"eo",
        "אֶסְפֵּרַנְטוֹ":"eo",
        "एस्पेरांतो":"eo",
        "eszperantó":"eo",
        "エスペラント":"eo",
        "ಎಸ್ಪೆರಾಂಟೊ":"eo",
        "эсперанто":"eo",
        "에스페란토 말":"eo",
        "esperanto kalba":"eo",
        "എസ്പെരാന്തോ":"eo",
        "အက်စ်တိုးတို":"eo",
        "ایسپیرینټو":"eo",
        "اسپرانتو":"eo",
        "ਐਸਪੇਰਾਂਤੋ":"eo",
        "eseperano":"eo",
        "esiperando":"eo",
        "ايسپرانتو":"eo",
        "එස්පෙරාන්තෝ":"eo",
        "ఎస్పరెన్టొ":"eo",
        "ภาษาโลก":"eo",
        "ایسپرانو":"eo",
        "isiesperanto":"eo",
        "estonian":"et",
        "estonez":"et",
        "ኢስቶኒያን":"et",
        "الإستونية":"et",
        "էստոնական":"et",
        "eston":"et",
        "эст":"et",
        "est":"et",
        "естонски":"et",
        "estonià":"et",
        "estonia":"et",
        "estone":"et",
        "estonski":"et",
        "estonština":"et",
        "estisk":"et",
        "ests":"et",
        "estono":"et",
        "eesti keel":"et",
        "virolainen":"et",
        "estonien":"et",
        "estysk":"et",
        "estonio":"et",
        "ესტონური":"et",
        "estnisch":"et",
        "εσθονικά":"et",
        "ઇંગ્લિશ":"et",
        "estonyen":"et",
        "isonian":"et",
        "ekekonia":"et",
        "אסטורי":"et",
        "észt":"et",
        "eistneska, eisti, eistneskur":"et",
        "estónach":"et",
        "エストニア語":"et",
        "ಎಸ್ಟೋನಿಯನ್":"et",
        "эстондық":"et",
        "អេស្តូន":"et",
        "에스토니아 사람":"et",
        "estonî":"et",
        "эстончо":"et",
        "igauņu":"et",
        "estų":"et",
        "estonesch":"et",
        "estoniana":"et",
        "orang estonia":"et",
        "എസ്റ്റോണിയൻ":"et",
        "estonjan":"et",
        "kariki":"is",
        "कीबोर्ड":"et",
        "эстон":"et",
        "အက်စတိုးနီးယား":"et",
        "इन्डियन":"et",
        "ଇଷ୍ଟୋନିଆନ୍ |":"et",
        "ایستونین":"et",
        "استونیایی":"et",
        "estoński":"et",
        "ਸ਼ਬਦ":"et",
        "эстонский":"et",
        "estòinianach":"et",
        "ест":"et",
        "chiestonian":"et",
        "ايستونائي":"et",
        "එස්තෝනියානු":"et",
        "estónsky":"et",
        "éstonia":"et",
        "kiestonia":"et",
        "estniska":"et",
        "эстонӣ":"et",
        "எஸ்டோனியன்":"et",
        "เอสโตเนีย":"et",
        "estonyalı":"et",
        "اردو":"ur",
        "dân tộc":"et",
        "עסטיש":"et",
        "ara ilu estonia":"et",
        "isi-estonia":"et",
        "filipino":"tl",
        "tagalogisht":"tl",
        "الفلبينية":"tl",
        "դանդաղ":"tl",
        "закід":"tl",
        "филипински":"tl",
        "filipí":"tl",
        "chotsimikizika":"tl",
        "filippinu":"tl",
        "filipijns":"tl",
        "filipina":"tl",
        "philippin":"tl",
        "filipynsk":"tl",
        "filipinas":"tl",
        "ფილიპინურად":"tl",
        "φιλιππίνος":"tl",
        "ઈડિન":"tl",
        "filipin":"tl",
        "פיליפיני":"tl",
        "filippínó":"tl",
        "filippseyska":"tl",
        "filippina":"tl",
        "フィリピン語":"tl",
        "ಫಿಲಿಪಿನೋ":"tl",
        "филипино":"tl",
        "필리핀 사람":"tl",
        "bi hêsanî":"tl",
        "philippinica":"tl",
        "filippinesch":"tl",
        "filipiana":"tl",
        "ഫിലിപ്പിനോ":"tl",
        "filippin":"tl",
        "इपिनियन":"tl",
        "ဖိလစ်ပိုင်":"tl",
        "इपिलियन":"tl",
        "filippinsk":"tl",
        "ଫିଲିପିନୋ":"tl",
        "افلاین":"tl",
        "فیلیلی":"tl",
        "filipiński":"tl",
        "ਓਪਿਨ":"tl",
        "filipineză":"tl",
        "филиппинский":"tl",
        "faila":"tl",
        "tlatsitsoe":"tl",
        "vakatsikirirwa":"tl",
        "فلپينو":"tl",
        "පිලිපීන":"tl",
        "imesawazishwa":"tl",
        "ஃபிலிபினோ":"tl",
        "ฟิลิปปินส์":"tl",
        "пілінг":"tl",
        "بولی":"tl",
        "philippines":"tl",
        "gqibezela":"tl",
        "פיליפּינאָ":"tl",
        "qeda":"tl",
        "finnish":"fi",
        "finlandez":"fi",
        "ፊኒሽ":"fi",
        "الفنلندية":"fi",
        "ֆիններեն":"fi",
        "fin":"fi",
        "фінскія":"fi",
        "finski":"fi",
        "фински":"fi",
        "finès":"fi",
        "chifinishi":"fi",
        "finlandese":"fi",
        "finský":"fi",
        "finsk":"fi",
        "fins":"fi",
        "finno":"fi",
        "soome keel":"fi",
        "suomalainen":"fi",
        "finlandaise":"fi",
        "finés":"fi",
        "ფინური":"fi",
        "finnisch":"fi",
        "φινλανδικός":"fi",
        "ફિનિશ":"fi",
        "pinilana":"fi",
        "פִינִית":"fi",
        "फिनिश":"fi",
        "ua tiav":"fi",
        "finn":"fi",
        "finnska":"fi",
        "finlandia":"fi",
        "フィンランド語":"fi",
        "finalis":"fi",
        "ಫಿನ್ನಿಷ್":"fi",
        "финдік":"fi",
        "បញ្ចប់":"fi",
        "핀란드어":"fi",
        "fînlandî":"fi",
        "финче":"fi",
        "ສຳ ເລັດຮູບ":"fi",
        "fennica":"fi",
        "somu":"fi",
        "suomių":"fi",
        "finnesch":"fi",
        "anarana":"sv",
        "finland":"fi",
        "ഫിന്നിഷ്":"fi",
        "finlandiż":"fi",
        "फिन्निश":"fi",
        "фин":"fi",
        "ဖင်လန်":"fi",
        "ଫିନିଶ୍ |":"fi",
        "فنلاندی":"fi",
        "fiński":"fi",
        "finlandesa":"fi",
        "ਫਿਨਿਸ਼":"fi",
        "finlandeză":"fi",
        "финский язык":"fi",
        "fionnlaineach":"fi",
        "sefinnishe":"fi",
        "chifinish":"fi",
        "فني":"fi",
        "ෆින්ලන්ත":"fi",
        "fínsky":"fi",
        "finansial":"fi",
        "kifini":"fi",
        "finska":"fi",
        "финн":"fi",
        "பின்னிஷ்":"fi",
        "ฟินแลนด์":"fi",
        "fince":"fi",
        "фінські":"fi",
        "فینیش":"fi",
        "fincha":"fi",
        "phần lan":"fi",
        "פֿיניש":"fi",
        "isi-finish":"fi",
        "frans":"fr",
        "frëngjisht":"fr",
        "ፈረንሳይኛ":"fr",
        "فرنسي":"fr",
        "ֆրանսերեն":"fr",
        "fransız dili":"fr",
        "frantziako":"fr",
        "французскі":"fr",
        "ফরাসি":"fr",
        "francuski":"fr",
        "френски":"fr",
        "francès":"fr",
        "pransiya":"fr",
        "french":"fr",
        "francese":"fr",
        "francouzština":"fr",
        "fransk":"fr",
        "franca":"fr",
        "prantsuse keeles":"fr",
        "pranses":"fr",
        "ranskan kieli":"fr",
        "français":"fr",
        "francais":"fr",
        "frânsk":"fr",
        "francés":"fr",
        "ფრანგული":"fr",
        "französisch":"fr",
        "γαλλική γλώσσα":"fr",
        "ફ્રેન્ચ":"fr",
        "franse":"fr",
        "faransa":"fr",
        "palani":"fr",
        "צָרְפָתִית":"fr",
        "फ्रेंच":"fr",
        "fabkis":"fr",
        "francia":"fr",
        "frönsku":"fr",
        "perancis":"fr",
        "fraincis":"fr",
        "フランス語":"fr",
        "ಫ್ರೆಂಚ್":"fr",
        "француз":"fr",
        "បារាំង":"fr",
        "프랑스 국민":"fr",
        "fransî":"fr",
        "франсузча":"fr",
        "ຝຣັ່ງ":"fr",
        "gallico":"fr",
        "franču valoda":"fr",
        "prancūzų kalba":"fr",
        "franséisch":"fr",
        "француски":"fr",
        "frantsay":"fr",
        "ഫ്രഞ്ച്":"fr",
        "franċiż":"fr",
        "kuikani":"fr",
        "франц":"fr",
        "ပြင်သစ်":"fy",
        "फ्रेन्च":"fr",
        "ଫ୍ରେଞ୍ଚ":"fr",
        "فرانسوي":"fr",
        "فرانسوی":"fr",
        "francesa":"fr",
        "ਫ੍ਰੈਂਚ":"fr",
        "limba franceza":"fr",
        "французский язык":"fr",
        "falani":"fr",
        "frangach":"fr",
        "chifrench":"fr",
        "فرانسي":"fr",
        "ප්\u200dරංශ":"fr",
        "francúzsky":"fr",
        "francoski":"fr",
        "faransiis":"fr",
        "kifaransa":"fr",
        "franska":"fr",
        "фаронсавӣ":"fr",
        "பிரஞ்சு":"fr",
        "ఫ్రెంచ్":"fr",
        "ฝรั่งเศส":"fr",
        "fransızca":"fr",
        "французький":"fr",
        "فرانسیسی":"fr",
        "fransuzcha":"fr",
        "người pháp":"fy",
        "ffrangeg":"fr",
        "isifrentshi":"fr",
        "פראנצויזיש":"fr",
        "faranse":"fr",
        "friese":"fy",
        "frisian":"fy",
        "ፍሪስያን":"fy",
        "الفريزية":"fy",
        "ֆրանսիական":"fy",
        "friz":"fy",
        "euskara":"fy",
        "фрызская":"fy",
        "ফ্রিসিয়":"fy",
        "frizijski":"fy",
        "фризийски":"fy",
        "frisiana":"fy",
        "wachi frisian":"fy",
        "frisianu":"fy",
        "van friesland afkomstige":"fy",
        "frisiano":"fy",
        "friisi":"fy",
        "frison":"fy",
        "ფრიზიანი":"fy",
        "γαλλική":"fy",
        "ફ્રિશિયન":"fy",
        "frisyen":"fy",
        "ʻōlani":"fy",
        "פריזית":"fy",
        "फ़्रिसियाई":"fy",
        "faus ntuj":"fy",
        "fríz":"fy",
        "frísneska":"fy",
        "frisona":"fy",
        "フリジア語":"fy",
        "фриз":"fy",
        "ហ្វាំងឡង់":"fy",
        "프리지아 어":"fy",
        "frîsî":"fy",
        "ພາສາລັດເຊຍ":"fy",
        "frisica":"fy",
        "frizieris":"fy",
        "fryzų":"fy",
        "frisesch":"fy",
        "фризијан":"fy",
        "फ्रिसियन":"fy",
        "фрисиан":"fy",
        "frisisk":"fy",
        "ଫ୍ରିଜିଆନ୍":"fy",
        "فروشي":"fy",
        "فرانسه":"fy",
        "fryzyjski":"fy",
        "frisão":"fy",
        "ਫ੍ਰੀਸੀਅਨ":"fy",
        "фризский":"fy",
        "faʻa frisian":"fy",
        "фризијски":"fy",
        "فريسيئن":"fy",
        "frízština":"fy",
        "frisio":"fy",
        "frisiska":"fy",
        "фризан":"fy",
        "ఫ్రిసియన్":"fy",
        "фризька":"fy",
        "umfulentshi":"fy",
        "galician":"gl",
        "ጋላሺያን":"gl",
        "الجاليكية":"gl",
        "պատկերասրահ":"gl",
        "qalisian":"gl",
        "галісійскі":"gl",
        "galicijski":"gl",
        "галисийски":"gl",
        "gallec":"gl",
        "wamatsenga":"gl",
        "galizianu":"gl",
        "galicijský":"gl",
        "galicisch":"gl",
        "galegoj":"gl",
        "galicia":"gl",
        "galicienne":"gl",
        "galyskysk":"gl",
        "galego":"gl",
        "გალერეა":"gl",
        "galizisch":"gl",
        "γαλικίας":"gl",
        "ગૌરવ":"gl",
        "galizyen":"gl",
        "yar galiki":"gl",
        "kalikia":"gl",
        "גליציאנית":"gl",
        "tus ua si galician":"gl",
        "galíciai":"gl",
        "galískur":"gl",
        "onye dibia":"gl",
        "galiziano":"gl",
        "ガリシア語":"gl",
        "ಗ್ಯಾಲಿಶಿಯನ್":"gl",
        "галисик":"gl",
        "អ្នកលេងហ្គីតា":"gl",
        "갈리시아어":"gl",
        "galîsyayî":"gl",
        "галицияча":"gl",
        "ນັກກາຍະສິນ":"gl",
        "gallaeca":"gl",
        "galicianas":"gl",
        "galizesch":"gl",
        "галерија":"gl",
        "ahli galeri":"gl",
        "ഗലീഷ്യൻ":"gl",
        "gallegjan":"gl",
        "tapawaru":"gl",
        "फोर्ड":"gl",
        "галисист":"gl",
        "အဝတ်အစား":"gl",
        "सेना":"gl",
        "ଗାଲିସିଆନ୍":"gl",
        "ګالیسي":"gl",
        "گالری":"gl",
        "galicyjski":"gl",
        "galega":"gl",
        "ਫੋਰਡ":"gl",
        "galiciană":"gl",
        "галисийский":"gl",
        "galicianach":"gl",
        "галицијски":"gl",
        "chigalician":"gl",
        "گاليشين ٻولي":"gl",
        "ගැලීසියානු":"gl",
        "galicij":"gl",
        "gallega":"gl",
        "tukang bégal":"gl",
        "mtaalam":"gl",
        "галик":"gl",
        "காலிசியன்":"gl",
        "กาลิเซีย":"gl",
        "galicia'ya ait":"gl",
        "галичанин":"gl",
        "جماعت":"gl",
        "galaktikalik":"gl",
        "igalofu":"gl",
        "georgian":"ka",
        "ጆርጅያን":"ka",
        "الجورجية":"ka",
        "վրացերեն":"ka",
        "грузінскі":"ka",
        "gruzijski":"ka",
        "грузински":"ka",
        "wolamulira":"ka",
        "georgianu":"ka",
        "gruzínské":"ka",
        "georgisk":"ka",
        "georgisch":"ka",
        "georgiano":"ka",
        "gruusia":"ka",
        "géorgienne":"ka",
        "georgysk":"ka",
        "xeorxiano":"ka",
        "ქართული":"ka",
        "γεωργίας":"ka",
        "શાખા":"ka",
        "jojiyanci":"ka",
        "keokia":"ka",
        "גרדיאית":"ka",
        "grúz":"ka",
        "glæsilegur":"ka",
        "asụsụ ala":"ka",
        "orang georgian":"ka",
        "georgiana":"ka",
        "ジョージア語":"ka",
        "ಜಾರ್ಜಿಯನ್":"ka",
        "георгий":"ka",
        "조르지아 주 사람":"ka",
        "gurcî":"ka",
        "грузинче":"ka",
        "pontica":"ka",
        "gruzīnu":"ka",
        "gruzinas":"ka",
        "georgesch":"ka",
        "грузиски":"ka",
        "zeorziana":"ka",
        "ahli geografi":"ka",
        "ജോർജിയൻ":"ka",
        "ġorġ":"ka",
        "सरकारी":"ka",
        "газарчин":"ka",
        "ဂျော်ဂျီယာ":"ka",
        "हवाइज":"ka",
        "ଜର୍ଜିଆ":"ka",
        "ګرجستاني":"ka",
        "گرجی":"ka",
        "gruziński":"ka",
        "ਸਰਕਾਰੀ":"ka",
        "грузинский":"ka",
        "georgianach":"ka",
        "лита":"ka",
        "chigeorgian":"ka",
        "جيارجي":"ka",
        "ජෝර්ජියානු":"ka",
        "gruzínsky":"ka",
        "joorjiyaanka":"ka",
        "georgiansk":"ka",
        "ஜார்ஜியன்":"ka",
        "จอร์เจีย":"ka",
        "gürcü":"ka",
        "грузинська":"ka",
        "محکمہ":"ka",
        "georgiyalik":"ka",
        "mũi nhọn":"ka",
        "גיאָרגי":"ka",
        "german":"de",
        "gjermanisht":"de",
        "ጀርመንኛ":"de",
        "ألمانية":"de",
        "գերմանական":"de",
        "alman":"de",
        "нямецкі":"de",
        "জার্মান":"de",
        "njemački":"de",
        "немски":"de",
        "alemany":"de",
        "wachijeremani":"de",
        "tedescu":"de",
        "němec":"de",
        "tysk":"de",
        "duitse":"de",
        "germano":"de",
        "sakslane":"de",
        "saksan kieli":"de",
        "allemande":"de",
        "dútsk":"de",
        "alemán":"de",
        "გერმანული":"de",
        "deutsche":"de",
        "γερμανός":"de",
        "જર્મન":"de",
        "jamusawa":"de",
        "alemania":"de",
        "גֶרמָנִיָת":"de",
        "जर्मन":"de",
        "német":"de",
        "þýska, þjóðverji, þýskur":"de",
        "jerman":"de",
        "gearmáinis":"de",
        "tedesca":"de",
        "ドイツ語":"de",
        "ಜರ್ಮನ್":"de",
        "неміс":"de",
        "독일 사람":"de",
        "almanî":"de",
        "немисче":"de",
        "ເຍຍລະມັນ":"de",
        "vācietis":"de",
        "vokietis":"de",
        "däitsch":"de",
        "ജർമ്മൻ":"de",
        "ġermaniż":"de",
        "āpiha":"de",
        "герман хүн":"de",
        "ဂျာမန်":"de",
        "ଜର୍ମାନ":"de",
        "آلمانی":"de",
        "niemiecki":"de",
        "alemã":"de",
        "ਜਰਮਨ":"de",
        "limba germana":"de",
        "немецкий":"de",
        "gearmailteach":"de",
        "немачки":"de",
        "jeremane":"de",
        "chijerimani":"de",
        "جرمني":"de",
        "ජර්මානු":"de",
        "nemec":"de",
        "nemško":"de",
        "alemana":"de",
        "jamani":"jw",
        "немис":"de",
        "ஜெர்மன்":"de",
        "జర్మన్":"de",
        "เยอรมัน":"de",
        "almanca":"de",
        "німецька":"de",
        "جرمن":"de",
        "گېرمان":"de",
        "nemis":"de",
        "tiếng đức":"de",
        "isijamani":"de",
        "דייַטש":"de",
        "jẹmánì":"de",
        "isijalimane":"de",
        "griekse":"el",
        "grek":"el",
        "ግሪክኛ":"el",
        "اليونانية":"el",
        "հունական":"el",
        "yunan":"el",
        "greek":"el",
        "грэчаская мова":"el",
        "গ্রিক":"el",
        "grčki":"el",
        "гръцки":"el",
        "grec":"el",
        "grey":"el",
        "mayeso":"el",
        "grecu":"el",
        "řecký":"el",
        "græsk":"el",
        "grieks":"el",
        "greka":"el",
        "kreeka keel":"el",
        "kreikkalainen":"el",
        "grecque":"el",
        "gryksk":"el",
        "grego":"el",
        "ბერძნული":"el",
        "griechisch":"el",
        "ελληνικά":"el",
        "ગ્રીક":"el",
        "grèk":"el",
        "girgiza kai":"el",
        "helene":"el",
        "יווני":"el",
        "यूनानी":"el",
        "görög":"el",
        "gríska":"el",
        "ọya":"el",
        "yunani":"el",
        "gréigis":"el",
        "greca":"el",
        "ギリシャ語":"el",
        "greja":"el",
        "ಗ್ರೀಕ್":"el",
        "грек":"el",
        "ក្រិក":"el",
        "그리스 어":"el",
        "yewnanî":"el",
        "грекче":"el",
        "ກະເຣັກ":"el",
        "graeca":"el",
        "grieķu":"el",
        "graikų kalba":"el",
        "griichesch":"el",
        "грчки":"el",
        "bahasa yunani":"el",
        "ഗ്രീക്ക്":"el",
        "grieg":"el",
        "kākariki":"el",
        "ग्रीक":"el",
        "ဂရိ":"el",
        "gresk":"el",
        "ଗ୍ରୀକ୍":"el",
        "یوناني":"el",
        "یونانی":"el",
        "grecki":"el",
        "grega":"el",
        "ਯੂਨਾਨੀ":"el",
        "greacă":"el",
        "греческий":"el",
        "grèigeach":"el",
        "tlhoko":"el",
        "chigiriki":"el",
        "يوناني":"el",
        "ග්\u200dරීක":"el",
        "grécky":"el",
        "grško":"el",
        "cirfiid":"el",
        "griega":"el",
        "héjo":"el",
        "busara":"el",
        "grekisk":"el",
        "กรีก":"el",
        "грецький":"el",
        "grekcha":"el",
        "người hy lạp":"el",
        "isigrike":"el",
        "ọfun":"el",
        "iseluleko":"el",
        "gujarati":"gu",
        "ጉጅራቲ":"gu",
        "الغوجاراتية":"gu",
        "գուարաթի":"gu",
        "гуджараці":"gu",
        "গুজরাটি":"gu",
        "гуджарати":"gu",
        "maguleta":"gu",
        "gujaratioj":"gu",
        "gujaratysk":"gu",
        "გუჯარათი":"gu",
        "γκουτζαράτι":"gu",
        "ગુજરાતી":"gu",
        "kuhalaki":"gu",
        "גוג'ראטי":"gu",
        "गुजराती":"gu",
        "gudzsaráti":"gu",
        "グジャラート語":"gu",
        "ಗುಜರಾತಿ":"gu",
        "гужарати":"gu",
        "구자라트":"gu",
        "gujaratî":"gu",
        "гужаратиче":"gu",
        "gujārati":"gu",
        "гуџарија":"gu",
        "ഗുജറാത്തി":"gu",
        "гужарат хэл":"gu",
        "ဂူဂျာတီ":"gu",
        "ଗୁଜରାଟୀ":"gu",
        "ګجراتي":"gu",
        "گواتواري":"gu",
        "gudżarati":"gu",
        "гујарати":"gu",
        "mojarati":"gu",
        "chigujarati":"gu",
        "گجراتي":"gu",
        "ගුජරාටි":"gu",
        "gijarati":"gu",
        "குஜராத்தி":"gu",
        "คุชราต":"gu",
        "گجراتی":"gu",
        "isigagu":"gu",
        "haïtiese kreol":"ht",
        "kollaj haiti":"ht",
        "ሓይቲያን ክሬኦሌ":"ht",
        "الكريولية الهايتية":"ht",
        "հաջի կրեոլ":"ht",
        "haitian creole":"ht",
        "haitiar kreolera":"ht",
        "гітара крэол":"ht",
        "হাইতিয়ান ক্রেওল":"ht",
        "китари креол":"ht",
        "crioll haitian":"ht",
        "mbiri creole":"ht",
        "creolu haitianu":"ht",
        "haitian kreole":"ht",
        "haitský kreol":"ht",
        "haiti kreolsk":"ht",
        "haïtiaanse creoolse":"ht",
        "haitian kreolo":"ht",
        "haiti kreool":"ht",
        "haitin kreoli":"ht",
        "créole haïtien":"ht",
        "haïtiaansk kreaolsk":"ht",
        "creole haitiano":"ht",
        "ჰაიტი კრეოლი":"ht",
        "haitianisches kreol":"ht",
        "αρετή κρεόλη":"ht",
        "સમાપ્ત ક્રેઓલ":"ht",
        "kreyòl ayisyen":"ht",
        "ōlelo haiki":"ht",
        "קריאולית של האיטי":"ht",
        "हैतियाई क्रेओल":"ht",
        "haiti kreol":"ht",
        "haíí creole":"ht",
        "kreol haitian":"ht",
        "creole haitian":"ht",
        "creolo haitiano":"ht",
        "ハイチのクレオール":"ht",
        "ಹೈಟಿ ಕ್ರಿಯೋಲ್":"ht",
        "гаитикалық креол":"ht",
        "creole ហៃ":"ht",
        "아이티 크리올":"ht",
        "kreoliya haîtiyî":"ht",
        "haiti kreols":"ht",
        "haičio kreolis":"ht",
        "haitescht creole":"ht",
        "хаити креол":"ht",
        "kreol haiti":"ht",
        "ഹെയ്\u200cതിയൻ ക്രിയോൾ":"ht",
        "ħallieni kreol":"ht",
        "haole":"ht",
        "क्रिड क्रिओल":"ht",
        "haitian креол":"ht",
        "ဂီတာ":"ht",
        "समापन क्रियोल":"ht",
        "haitian kreolsk":"ht",
        "ହାଟିଆ କ୍ରେଓଲ୍ |":"ht",
        "پای کریول":"ht",
        "کریول هائیتی":"ht",
        "kreolski haitański":"ht",
        "crioulo haitiano":"ht",
        "ਖਤਮ ਕਰਿਓਲ":"ht",
        "гаитянский креольский":"ht",
        "haiti kereole":"ht",
        "хаићански креол":"ht",
        "tlhokomeliso ea botumo":"ht",
        "kiriyoro yehaiti":"ht",
        "هيٽي ڪرولي":"ht",
        "හයිටි ක්\u200dරෙයෝල්":"ht",
        "igralka kreole":"ht",
        "criollo haitiano":"ht",
        "creole ya jina":"ht",
        "haitisk kreol":"ht",
        "креоли ҳайти":"ht",
        "ஹைட்டியன் கிரியோல்":"ht",
        "హైటియన్ క్రియోల్":"ht",
        "ครีโอลเฮติ":"ht",
        "haiti kreole":"ht",
        "гітара-креоль":"ht",
        "خاتمہ کریول":"ht",
        "haitian kreol":"ht",
        "bánh creole":"ht",
        "isikriyoli sasehayiti":"ht",
        "isihlonipho se -umo":"ht",
        "ሃውሳ":"ha",
        "هوسا":"xh",
        "հաուսա":"ha",
        "хаўса":"ha",
        "হাউসা":"ha",
        "хауса":"ha",
        "haŭso":"ha",
        "ჰაუსა":"ha",
        "χαζά":"ha",
        "હૌસા":"ha",
        "hauka":"ha",
        "חאוסה":"ha",
        "होउसा":"ha",
        "hausza":"ha",
        "ハウサ":"ha",
        "ಹೌಸಾ":"ha",
        "ភេសជ្ជៈa":"ha",
        "하우사":"ha",
        "хаусача":"ha",
        "haussa":"ha",
        "ഹ aus സ":"ha",
        "हौसा":"ha",
        "ဟွာ":"ha",
        "ହାଉସା":"ha",
        "هاوسا":"ha",
        "ਹਉਸਾ":"ha",
        "chihausa":"ha",
        "هوسا ٻولي":"ha",
        "හවුසා":"ha",
        "хаоса":"ha",
        "ஹ aus ஸா":"ha",
        "ہاؤسا":"ha",
        "hawaiian":"haw",
        "ሐዋያን":"haw",
        "هاواي":"haw",
        "հաավայեան":"haw",
        "həvayi":"haw",
        "oiasso":"haw",
        "гавайская":"haw",
        "হাওয়াইয়ান":"haw",
        "havajski":"haw",
        "хавайски":"haw",
        "hawaià":"haw",
        "tradisyon":"haw",
        "hawaiianu":"haw",
        "havajský":"haw",
        "hawaiiaans":"haw",
        "hawaiiano":"haw",
        "havai":"haw",
        "sining":"haw",
        "havaijilainen":"haw",
        "hawaïen":"haw",
        "hawaïaansk":"haw",
        "hawaiano":"haw",
        "ჰავაიანი":"haw",
        "hawaiisch":"haw",
        "χαβάης":"haw",
        "હવાઈ":"haw",
        "hawayi":"haw",
        "ōlelo hawaiʻi":"haw",
        "הוואי":"haw",
        "हवाई":"haw",
        "hawaii":"haw",
        "hawiian":"haw",
        "hawaiana":"haw",
        "ハワイアン":"haw",
        "ngulati":"haw",
        "ಹವಾಯಿಯನ್":"haw",
        "хауайян":"haw",
        "ហាវ៉ាយៀន":"haw",
        "하와이":"haw",
        "hawaiyî":"haw",
        "гавайча":"haw",
        "havajietiškas":"haw",
        "hawaianesch":"haw",
        "хавајски":"haw",
        "hawai":"haw",
        "ഹവായിയൻ":"haw",
        "ħawajjan":"haw",
        "maori":"mi",
        "हवाईयन":"haw",
        "хайвайн":"haw",
        "ဟာဝိုင်ယီ":"haw",
        "हवाइयन":"haw",
        "هوایی":"haw",
        "هاوایی":"haw",
        "hawajski":"haw",
        "havaiana":"haw",
        "ਹਵਾਈਅਨ":"haw",
        "hawaiană":"haw",
        "гавайский":"haw",
        "havaii":"haw",
        "hawaiianach":"haw",
        "chihawayi":"haw",
        "هوائين":"haw",
        "හවායි":"haw",
        "kasenian":"haw",
        "ҳавайӣ":"haw",
        "ஹவாய்":"haw",
        "హవాయి":"haw",
        "ฮาวาย":"haw",
        "гавайський":"haw",
        "حوثیان":"haw",
        "xayvon":"haw",
        "isihawayi":"haw",
        "האַוואַייאַן":"haw",
        "i-hawaiian":"haw",
        "hebreeus":"iw",
        "hebraik":"iw",
        "ሂብሩ":"iw",
        "اللغة العبرية":"iw",
        "եբրայերեն":"iw",
        "hebrew":"iw",
        "іўрыт":"iw",
        "হিব্রু":"iw",
        "hebrejski":"iw",
        "иврит":"iw",
        "hebreu":"iw",
        "kuzungulira":"iw",
        "ebraicu":"iw",
        "hebrejština":"iw",
        "hebraisk":"iw",
        "hebreeuws":"iw",
        "hebreo":"iw",
        "heprealainen":"iw",
        "hébreue":"iw",
        "hebrieuwsk":"iw",
        "ებრაული":"iw",
        "hebräisch":"iw",
        "εβραϊκά":"iw",
        "હેબ્રીબ":"iw",
        "ebrew":"iw",
        "hepela":"iw",
        "עִברִית":"iw",
        "यहूदी":"yi",
        "héber":"iw",
        "hebreska":"iw",
        "ibrani":"iw",
        "ebraica":"iw",
        "ヘブライ語":"iw",
        "ಹೀಬ್ರೂ":"iw",
        "еврей":"iw",
        "ហេប៊ឺរ":"iw",
        "헤브라이 사람":"iw",
        "îbranî":"iw",
        "еврейче":"iw",
        "ivrits":"iw",
        "hebrajiškai":"iw",
        "hebräesch":"iw",
        "хебрејски":"iw",
        "ഹീബ്രു":"iw",
        "हिब्रू":"iw",
        "гүү":"iw",
        "herew":"iw",
        "ହେବ୍ରୁ":"iw",
        "عبري":"iw",
        "هباتی":"iw",
        "hebrajski":"iw",
        "hebraica":"iw",
        "ਹੇਬਰਿw":"iw",
        "ebraică":"iw",
        "eperu":"iw",
        "eabhrach":"iw",
        "chihebhuru":"iw",
        "عبراني":"iw",
        "හෙබ්\u200dරෙව්":"iw",
        "hebrejčina":"iw",
        "hebrejščina":"iw",
        "hebrea":"iw",
        "kizuizi":"iw",
        "hebré":"iw",
        "губернатор":"iw",
        "హిబ్రూ":"iw",
        "ชาวอิสราเอล":"iw",
        "i̇branice":"iw",
        "іврит":"iw",
        "ہیبرو":"iw",
        "shayton":"iw",
        "isihebhere":"iw",
        "i-hebrew":"iw",
        "heebrea keeles":"iw",
        "ஹீப்ரு":"iw",
        "hindi":"hi",
        "ሂንዲ":"hi",
        "الهندية":"hi",
        "հինդի":"hi",
        "хіндзі":"hi",
        "хинди":"hi",
        "hindski":"hi",
        "hindština":"hi",
        "hindoestaansk":"hi",
        "ჰინდი":"hi",
        "χίντι":"hi",
        "હિન્દી":"hi",
        "hiniki":"hi",
        "הינדית":"hi",
        "हिन्दी":"hi",
        "ヒンディー語":"hi",
        "ora":"hi",
        "ហិណ្ឌូ":"hi",
        "힌디 어":"hi",
        "hindî":"hi",
        "хиндиче":"hi",
        "ഹിന്ദി":"hi",
        "kauaka":"hi",
        "हिंदी":"hi",
        "ဟိဒီ":"hi",
        "ହିନ୍ଦୀ":"hi",
        "هندي":"hi",
        "هندی":"hi",
        "hinduski":"hi",
        "ਹਿੰਦੀ":"hi",
        "indeach":"hi",
        "se hindi":"hi",
        "chihindi":"hi",
        "හින්දි":"hi",
        "hindčina":"hi",
        "teu":"hi",
        "இந்தி":"hi",
        "హిందీ":"hi",
        "ภาษาฮินดี":"hi",
        "hintçe":"hi",
        "хінді":"hi",
        "ہندی":"hi",
        "tiếng hin-ddi":"hi",
        "הינדיש":"hi",
        "hmong":"hmn",
        "ሕሞንግ":"hmn",
        "الهمونغ":"hmn",
        "հմոնգ":"hmn",
        "хмонг":"hmn",
        "мон":"hmn",
        "hmonged":"hmn",
        "ჰმონგი":"hmn",
        "χονγκ":"hmn",
        "mona":"hmn",
        "המונג":"hmn",
        "हमोंग":"hmn",
        "kwv tij hmoob":"hmn",
        "モン語":"hmn",
        "បងប្អូនប្រុស":"hmn",
        "몽족":"hmn",
        "hmongî":"hmn",
        "хмонгчо":"hmn",
        "ມົ້ງ":"hmn",
        "hmongi":"hmn",
        "hmongai":"hmn",
        "همونګ":"hmn",
        "هومونگ":"hmn",
        "ਹਮੰਗ":"hmn",
        "мяо":"hmn",
        "chihmong":"hmn",
        "همنگي":"hmn",
        "ม้ง":"hmn",
        "ہمونگ":"hmn",
        "hungarian":"hu",
        "hungarez":"hu",
        "ሃንጋሪያን":"hu",
        "المجري":"hu",
        "հունգարական":"hu",
        "macar":"hu",
        "венгерская":"hu",
        "mađarski":"hu",
        "унгарски":"hu",
        "hongarès":"hu",
        "ungherese":"hu",
        "madžarski":"hu",
        "maďarský":"hu",
        "ungarsk":"hu",
        "hongaars":"hu",
        "hungarian...":"hu",
        "ungarlane":"hu",
        "unkarin kieli":"hu",
        "hongroise":"hu",
        "hongaarsk":"hu",
        "húngaro":"hu",
        "უნგრული":"hu",
        "ungarisch":"hu",
        "ουγγρικός":"hu",
        "હની":"hu",
        "ongri":"hu",
        "maƙiyi":"hu",
        "hunakalia":"hu",
        "הוּנגָרִי":"hu",
        "हंगेरी":"hu",
        "neeg ntxim nyiam":"hu",
        "magyar":"hu",
        "ungverska, ungverji, ungverskt":"hu",
        "onye agu":"hu",
        "hongaria":"hu",
        "ハンガリー語":"hu",
        "ಹಂಗೇರಿಯನ್":"hu",
        "венгерлік":"hu",
        "ឃ្លាន":"hu",
        "헝가리 인":"hu",
        "macarî":"hu",
        "венгерче":"hu",
        "ຄົນຂີ້ຄ້ານ":"hu",
        "ungāru valoda":"hu",
        "vengrų":"hu",
        "ungaresch":"hu",
        "hongariana":"hu",
        "bahasa hungary":"hu",
        "ഹംഗേറിയൻ":"hu",
        "ungeriż":"hu",
        "हानी":"hu",
        "өлгий":"hu",
        "ဟန်ဂေရီယန်":"hu",
        "ଭୋକିଲା":"hu",
        "هنګري":"hu",
        "مجارستانی":"hu",
        "język węgierski":"hu",
        "húngara":"hu",
        "ਹੈਨੀਅਨ":"hu",
        "maghiară":"hu",
        "венгерский язык":"hu",
        "hungàrianach":"hu",
        "мађарски":"hu",
        "chihungarian":"hu",
        "هنگري":"hu",
        "බඩගිනි":"hu",
        "madžarsko":"hu",
        "gaajaysan":"hu",
        "ungerska":"hu",
        "венгерӣ":"hu",
        "பசி":"hu",
        "ฮังการี":"hu",
        "macarca":"hu",
        "угорський":"hu",
        "ہانی":"hu",
        "ئاچارچىلىق":"hu",
        "osilgan":"hu",
        "người hungary":"hu",
        "אונגעריש":"hu",
        "agunrin":"hu",
        "hungary":"hu",
        "icelandic":"is",
        "islandez":"is",
        "አይስላንዲ ክ":"is",
        "الآيسلندية":"is",
        "իսլանդերեն":"is",
        "ісландская":"is",
        "islandski":"is",
        "исландски":"is",
        "denunciat":"is",
        "nzeru":"is",
        "islandesu":"is",
        "islandský":"is",
        "ijslands":"is",
        "denunco":"is",
        "islandi":"is",
        "islantilainen":"is",
        "islandais":"is",
        "yslânsk":"is",
        "denunciado":"is",
        "ისლანდიელი":"is",
        "isländisch":"is",
        "ισλανδικός":"is",
        "સ્ત્રી":"is",
        "āinahau":"is",
        "איסלנדית":"is",
        "आइसलैंड का":"is",
        "izlandi":"is",
        "íslensku":"is",
        "islandia":"is",
        "íoslainnis":"is",
        "islandese":"is",
        "アイスランド語":"is",
        "ionik":"is",
        "ಐಸ್ಲ್ಯಾಂಡಿಕ್":"is",
        "ирландиялық":"is",
        "아이슬란드 어":"is",
        "îzlandî":"is",
        "исландияча":"is",
        "islandiešu":"is",
        "islandai":"is",
        "islännesch":"is",
        "ഐസ്\u200cലാൻഡിക്":"is",
        "il-kliżinjan":"is",
        "स्त्री":"is",
        "အဘိဓာန်":"is",
        "विवाह":"is",
        "islandsk":"is",
        "ଆଇସଲାଣ୍ଡିକ୍ |":"is",
        "ایلینډیک":"is",
        "ایسلندی":"is",
        "islandzki":"is",
        "islandês":"is",
        "ਕੁਮਾਰੀ":"is",
        "исландский":"is",
        "innis tìleach":"is",
        "kutloisiso":"is",
        "chiicelandic":"is",
        "آئس لينڊي":"is",
        "අයිස්ලන්ත":"is",
        "barafka":"is",
        "islandesa":"is",
        "ufahamu":"is",
        "isländsk":"is",
        "ஐஸ்லாந்து":"is",
        "ไอซ์แลนด์":"is",
        "i̇zlandaca":"is",
        "ісландський":"is",
        "شادی":"is",
        "muzlik":"is",
        "quan":"is",
        "gwlad yr iâ":"is",
        "iceland":"is",
        "איסלענדיש":"is",
        "yinyin":"is",
        "ukuzwela":"is",
        "igbo":"ig",
        "ጫካ":"ig",
        "ігба":"ig",
        "ইগ্বো":"ig",
        "игбо":"ig",
        "ઇગ્બો":"ig",
        "daji":"ig",
        "איגבו":"ig",
        "ईग्बो":"ig",
        "イボ":"ig",
        "ಇಗ್ಬೊ":"ig",
        "이 그보":"ig",
        "इग्बो":"ig",
        "ibo":"ig",
        "ਇਗਬੋ":"ig",
        "آئي بيبو":"ig",
        "baadiyaha":"ig",
        "ఇగ్బో":"ig",
        "i̇bo":"ig",
        "ігбо":"ig",
        "ایگبو":"ig",
        "indonesian":"id",
        "indonezian":"id",
        "ኢንዶኔዥያን":"id",
        "الأندونيسية":"id",
        "ինդոնեզերեն":"id",
        "indoneziyalı":"id",
        "інданезійская":"id",
        "indonezijski":"id",
        "индонезийски":"id",
        "indonèsia":"id",
        "indiano":"id",
        "indiya":"id",
        "indonesianu":"id",
        "indonéština":"id",
        "indonesisk":"id",
        "indonesisch":"id",
        "indonezia":"id",
        "indoneeslane":"id",
        "indonesialainen":"id",
        "indonésienne":"id",
        "yndonesysk":"id",
        "indonesio":"id",
        "ინდონეზიური":"id",
        "ινδονησιακά":"id",
        "ઇન્ડોનેશિયા":"id",
        "endonezyen":"id",
        "yar kasar indonesiya":"id",
        "inikonia":"id",
        "אינדונזית":"id",
        "इंडोनेशियाई":"id",
        "indonéz":"id",
        "indónesísku":"id",
        "bahasa indonesia":"id",
        "indinéisis":"id",
        "indonesiana":"id",
        "インドネシア語":"id",
        "ಇಂಡೋನೇಷಿಯನ್":"id",
        "үнділік":"id",
        "ឥណ្ឌូនេស៊ី":"id",
        "인도네시아 인":"id",
        "îndonezî":"id",
        "индонезияча":"id",
        "ອິນໂດເນເຊຍ":"id",
        "indonesiaca":"id",
        "indonēzietis":"id",
        "indonezietis":"id",
        "indonesesch":"id",
        "индонезиски":"id",
        "indonezianina":"id",
        "orang indonesia":"id",
        "ഇന്തോനേഷ്യൻ":"id",
        "indoneżjan":"id",
        "इंडोनेशियन":"id",
        "индонези":"id",
        "အင်ဒိုနီးရှား":"id",
        "इन्डोनेशियाई":"id",
        "ଇଣ୍ଡୋନେସିଆନ୍ |":"id",
        "انډونیزین":"id",
        "اندونزیایی":"id",
        "indonezyjski":"id",
        "indonésia":"id",
        "ਇੰਡੋਨੇਸ਼ੀਆ":"id",
        "indoneziana":"id",
        "индонезийский":"id",
        "and-innseach":"id",
        "индонезијски":"id",
        "index":"id",
        "chiindonesian":"id",
        "انڊونيشي":"id",
        "ඉන්දුනීසියානු":"id",
        "indonézsky":"id",
        "indonezijščina":"id",
        "indonesia":"id",
        "indema":"id",
        "indonesiska":"id",
        "индонезӣ":"id",
        "இந்தோனேசிய":"id",
        "ชาวอินโดนีเซีย":"id",
        "endonezya":"id",
        "індонезійська":"id",
        "انڈونیشیا":"id",
        "indoneziyalik":"id",
        "אינדאָנעזיש":"id",
        "ara ilu indonesian":"id",
        "isi-ind":"id",
        "irish":"ga",
        "irlandez":"ga",
        "አይሪሽ":"ga",
        "الأيرلندية":"ga",
        "իռլանդական":"ga",
        "iriş":"ga",
        "ірландская":"ga",
        "irski":"ga",
        "ирландски":"ga",
        "irlandès":"ga",
        "dziko":"ga",
        "irlandese":"ga",
        "irština":"ga",
        "iers":"ga",
        "irlandano":"ga",
        "iirlane":"ga",
        "irlantilainen":"ga",
        "irlandaise":"ga",
        "iersk":"ga",
        "irlandés":"ga",
        "ირლანდიელი":"ga",
        "irisch":"ga",
        "ιρλανδικός":"ga",
        "આઇરિશ":"ga",
        "ilandè":"ga",
        "ipelana":"ga",
        "אִירִית":"ga",
        "आयरिश":"ga",
        "ír":"ga",
        "írska":"ga",
        "orang irlandia":"ga",
        "gaeilge":"ga",
        "irlandesi":"ga",
        "アイルランド語":"ga",
        "ಐರಿಶ್":"ga",
        "ириш":"ga",
        "아일랜드의":"ga",
        "irlandî":"ga",
        "ирландча":"ga",
        "hibernica":"ga",
        "īru":"ga",
        "airių":"ga",
        "iresch":"ga",
        "ирски":"ga",
        "irlandey":"ga",
        "ഐറിഷ്":"ga",
        "irlandiż":"ga",
        "ирланд":"ga",
        "အိုင်းရစ်":"ga",
        "आयरिस":"ga",
        "irsk":"ga",
        "ایرلینډي":"ga",
        "ایرلندی":"ga",
        "irlandzki":"ga",
        "irlandesa":"ga",
        "ਆਇਰਿਸ਼":"ga",
        "ирландцы":"ga",
        "aialani":"ga",
        "èireannach":"ga",
        "naha":"ga",
        "chiirish":"ga",
        "آئرستاني":"ga",
        "අයිරිෂ්":"ga",
        "írsky":"ga",
        "basa irlandia":"ga",
        "nchi":"ga",
        "irländsk":"ga",
        "ирландӣ":"ga",
        "ஐரிஷ்":"ga",
        "ไอร์แลนด์":"ga",
        "i̇rlandalı":"ga",
        "ірландський":"ga",
        "آئرش":"ga",
        "ailen":"ga",
        "gwyddeleg":"ga",
        "איריש":"ga",
        "izwe":"ga",
        "italian":"it",
        "ጣሊያንኛ":"it",
        "إيطالي":"it",
        "իտալական":"it",
        "italyan":"it",
        "італьянскі":"it",
        "ইতালিয়ান":"it",
        "italijanski":"it",
        "италиански":"it",
        "italià":"it",
        "italya":"it",
        "chitali":"it",
        "talianu":"it",
        "talijanski":"it",
        "italština":"it",
        "italiensk":"it",
        "italiaans":"it",
        "itala":"it",
        "itaalia":"it",
        "italialainen":"it",
        "italienne":"it",
        "italiaansk":"it",
        "italiano":"it",
        "იტალიური":"it",
        "italienisch":"it",
        "ιταλικός":"it",
        "ઇટાલિયન":"it",
        "italyen":"it",
        "italiyanci":"it",
        "ikalia":"it",
        "אִיטַלְקִית":"it",
        "इतालवी":"it",
        "olasz":"it",
        "ítalska":"it",
        "italia":"it",
        "iodáilis":"it",
        "italiana":"it",
        "イタリア語":"it",
        "ಇಟಾಲಿಯನ್":"it",
        "итальяндық":"it",
        "អ៊ីតាលី":"it",
        "이탈리아 사람":"it",
        "îtalî":"it",
        "итальянча":"it",
        "ອິຕາລີ":"it",
        "itālietis":"it",
        "italų kalba":"it",
        "italienesch":"it",
        "италијански":"it",
        "itali":"it",
        "ഇറ്റാലിയൻ":"it",
        "इटालियन":"it",
        "итали":"it",
        "အီတလီ":"it",
        "ଇଟାଲୀୟ":"it",
        "ایټالیوي":"it",
        "ایتالیایی":"it",
        "ਇਤਾਲਵੀ":"it",
        "italiană":"it",
        "итальянский":"it",
        "eadailteach":"it",
        "италијан":"it",
        "setaliana":"it",
        "chiitalian":"it",
        "اطالوي":"it",
        "ඉතාලි":"it",
        "taliansky":"it",
        "итолиёвӣ":"it",
        "இத்தாலிய":"it",
        "ఇటాలియన్":"it",
        "อิตาลี":"it",
        "i̇talyan":"it",
        "італійський":"it",
        "اطالوی":"it",
        "italiyalik":"it",
        "người ý":"it",
        "isitaliyani":"it",
        "איטאַליעניש":"it",
        "e-italy":"it",
        "japanese":"ja",
        "japonez":"ja",
        "ጃፓንኛ":"ja",
        "اليابانية":"ja",
        "ճապոնական":"ja",
        "yapon":"ja",
        "японскі":"ja",
        "জাপানি":"ja",
        "japanski":"ja",
        "японски":"ja",
        "japonès":"ja",
        "phokoso":"ja",
        "ghjappunese":"ja",
        "japonský":"ja",
        "japansk":"ja",
        "japans":"ja",
        "japana":"ja",
        "jaapani":"ja",
        "japanilainen":"ja",
        "japonaise":"ja",
        "xaponés":"ja",
        "იაპონელი":"ja",
        "japanisch":"ja",
        "ιαπωνικά":"ja",
        "જાપાની":"ja",
        "japonè":"ja",
        "japanisanci":"ja",
        "kepanī":"ja",
        "יַפָּנִית":"ja",
        "जापानी":"ja",
        "puskawg":"ja",
        "japán":"ja",
        "japönsku":"ja",
        "jepang":"ja",
        "seapánach":"ja",
        "giapponese":"ja",
        "日本語":"ja",
        "ಜಪಾನೀಸ್":"ja",
        "ជនជាតិជប៉ុន":"ja",
        "일본어":"ja",
        "japonî":"ja",
        "жапончо":"ja",
        "ຍີ່ປຸ່ນ":"ja",
        "iaponica":"ja",
        "japāņu":"ja",
        "japonų":"ja",
        "japanesch":"ja",
        "јапонски":"ja",
        "jepun":"ja",
        "ജാപ്പനീസ്":"ja",
        "ġappuniż":"ja",
        "जपानी":"ja",
        "япон":"ja",
        "ဂျပန်":"ja",
        "ଜାପାନୀ":"ja",
        "جاپاني":"ja",
        "ژاپنی":"ja",
        "język japoński":"ja",
        "japonesa":"ja",
        "ਜਪਾਨੀ":"ja",
        "японский язык":"ja",
        "iapani":"ja",
        "iapanach":"ja",
        "јапански":"ja",
        "chijapanese":"ja",
        "ජපන්":"ja",
        "japonski":"ja",
        "kijapani":"ja",
        "японй":"ja",
        "ஜப்பானிய":"ja",
        "ญี่ปุ่น":"ja",
        "japonca":"ja",
        "японці":"ja",
        "جاپانی":"ja",
        "tiếng nhật":"ja",
        "japan":"ja",
        "isijaphani":"ja",
        "יאַפּאַניש":"ja",
        "ede japan":"ja",
        "ijaphane":"ja",
        "javaanse":"jw",
        "javanese":"jw",
        "ጃቫኒስ":"jw",
        "الجاوية":"jw",
        "yava":"jw",
        "javera":"jw",
        "яванскі":"jw",
        "জাভানি":"jw",
        "javanski":"jw",
        "явански":"jw",
        "javanès":"jw",
        "giavanese":"jw",
        "javanesisk":"jw",
        "javaans":"jw",
        "javananoj":"jw",
        "jaava":"jw",
        "jaavalainen":"jw",
        "javanais":"jw",
        "javaansk":"jw",
        "xavanés":"jw",
        "ჯავანური":"jw",
        "javanisch":"jw",
        "ιάβας":"jw",
        "જાવાની":"jw",
        "javèn":"jw",
        "kawanī":"jw",
        "ג'וואן":"jw",
        "जावानीस":"jw",
        "jávai":"jw",
        "javanska":"jw",
        "jawa":"jw",
        "iávais":"jw",
        "ジャワ語":"jw",
        "wong jawi":"jw",
        "ಜಾವಾನೀಸ್":"jw",
        "ចាវ៉ាន់":"jw",
        "자바어":"jw",
        "javanesî":"jw",
        "жанавизче":"jw",
        "iavanica":"jw",
        "javāns":"jw",
        "javai":"jw",
        "javanesesch":"jw",
        "јаванец":"jw",
        "javaney":"jw",
        "orang jawa":"jw",
        "ജാവനീസ്":"jw",
        "ġavaniż":"jw",
        "жава":"jw",
        "ဂျာဗား":"jw",
        "जाभानीज":"jw",
        "ଯବାନ":"jw",
        "جاوه ای":"jw",
        "ژوانی":"jw",
        "jawajski":"jw",
        "javanesa":"jw",
        "ਜਾਵਨੀਜ਼":"jw",
        "javaneză":"jw",
        "яванский":"jw",
        "iabhaininnseach":"jw",
        "јаванесе":"jw",
        "chijavanese":"jw",
        "جاواني":"jw",
        "jávsky":"jw",
        "javanščina":"jw",
        "чавони":"jw",
        "ஜாவானீஸ்":"jw",
        "జావానెసె":"jw",
        "ชาวชวา":"jw",
        "cava":"jw",
        "яванський":"jw",
        "جاویانی":"jw",
        "java":"jw",
        "jafanese":"jw",
        "ede javanese":"jw",
        "isijavane":"jw",
        "kannada":"kn",
        "ካናዳ":"kn",
        "الكانادا":"kn",
        "կաննադա":"kn",
        "каннада":"kn",
        "কন্নড":"kn",
        "канада":"kn",
        "კანადა":"kn",
        "κανάντα":"kn",
        "કન્નડ":"kn",
        "kanākā":"kn",
        "קנאדה":"kn",
        "कन्नड़":"kn",
        "cannadais":"kn",
        "カンナダ語":"kn",
        "ಕನ್ನಡ":"kn",
        "កន្នដា":"kn",
        "칸나다어":"kn",
        "kanadayî":"kn",
        "каннадача":"kn",
        "ການາດາ":"kn",
        "duis egestas elementum risus":"kn",
        "കന്നഡ":"kn",
        "कन्नड":"kn",
        "ကန္တာရ":"kn",
        "कन्नडा":"kn",
        "କାନ୍ନାଡା |":"kn",
        "کناډا":"kn",
        "کانادایی":"kn",
        "chikannada":"kn",
        "ڪنادي":"kn",
        "කන්නඩ":"kn",
        "ดา":"kn",
        "کناڈا":"kn",
        "kazakh":"kk",
        "ካዛክሀ":"kk",
        "الكازاخ":"kk",
        "ղազախ":"kk",
        "qazax":"kk",
        "казах":"kk",
        "কাজাখ":"kk",
        "казахски":"kk",
        "kazak":"kk",
        "kazach":"kk",
        "kasakhisk":"kk",
        "kazachs":"kk",
        "kasahh":"kk",
        "kazakstanin":"kk",
        "kazakhe":"kk",
        "kazachsk":"kk",
        "ყაზახი":"kk",
        "καζακ":"kk",
        "કાઝાખ":"kk",
        "ōlelo kazaka":"kk",
        "קזאח":"kk",
        "कजाख":"kk",
        "kazah":"kk",
        "カザフ":"kk",
        "ಕ kazakh ಕ್":"kk",
        "қазақ":"kk",
        "카자흐어":"kk",
        "qazakî":"kk",
        "казакча":"kk",
        "kazahs":"kk",
        "kazakas":"kk",
        "kasachesch":"kk",
        "കസാഖ്":"kk",
        "काझाख":"kk",
        "ကချင်":"kk",
        "काजाख":"kk",
        "କାଜାକ୍":"kk",
        "قزاقي":"kk",
        "قزاقی":"kk",
        "kazachski":"kk",
        "cazaque":"kk",
        "ਕਾਜ਼ਾਖ":"kk",
        "kazahă":"kk",
        "kasaka":"kk",
        "kasakh":"kk",
        "казакх":"kk",
        "kazaki":"kk",
        "قازق":"kk",
        "කසක":"kk",
        "kazašský":"kk",
        "казок":"kk",
        "கசாக்":"kk",
        "కజఖ్":"kk",
        "คาซัคสถาน":"kk",
        "کازاخ":"kk",
        "qozoq":"kk",
        "isikazakh":"kk",
        "khmer":"km",
        "ክመር":"km",
        "الخمير":"km",
        "խմեր":"km",
        "xmer":"km",
        "кхмер":"km",
        "খেমের":"km",
        "червените":"km",
        "crvenih":"km",
        "khmeeri":"km",
        "ხამერი":"km",
        "χμερ":"km",
        "ખ્મેર":"km",
        "חמר":"km",
        "खमेर":"km",
        "kwv":"km",
        "クメール":"km",
        "ಖಮೇರ್":"km",
        "크메르":"km",
        "кечки":"km",
        "ລາວ":"km",
        "khmeru":"km",
        "khmerų":"km",
        "кмер":"km",
        "ഖെമർ":"km",
        "ख्मेर":"km",
        "کمر":"km",
        "خمر":"km",
        "ਖਮੇਰ":"km",
        "khmeră":"km",
        "кхмерский":"km",
        "خميسو":"km",
        "ඛමර්":"km",
        "ఖ్మేర్":"km",
        "ขอม":"km",
        "خمیر":"km",
        "kxmer":"km",
        "kmer":"km",
        "korean":"ko",
        "ኮሪያኛ":"ko",
        "الكورية":"ko",
        "կորեերեն":"ko",
        "koreya":"ko",
        "карэйская":"ko",
        "কোরিয়ান":"ko",
        "korejski":"ko",
        "корейски":"ko",
        "coreà":"ko",
        "mga koreano":"ko",
        "koresi":"ko",
        "coreanu":"ko",
        "korejština":"ko",
        "koreansk":"ko",
        "koreaans":"ko",
        "korea":"ko",
        "korea keel":"ko",
        "korealainen":"ko",
        "coréen":"ko",
        "koreaansk":"ko",
        "coreano":"ko",
        "კორეული":"ko",
        "koreanisch":"ko",
        "κορεάτης":"ko",
        "કોરિયન":"ko",
        "koreyen an":"ko",
        "kolea":"ko",
        "קוריאנית":"ko",
        "कोरियाई":"ko",
        "koreai":"ko",
        "kóreska":"ko",
        "cóiréis":"ko",
        "coreana":"ko",
        "韓国語":"ko",
        "ಕೊರಿಯನ್":"ko",
        "корей":"ko",
        "កូរ៉េ":"ko",
        "한국어":"ko",
        "koreyî":"ko",
        "корейче":"ko",
        "ເກົາຫຼີ":"ko",
        "coreanica":"ko",
        "korejiešu":"ko",
        "korėjiečių":"ko",
        "koreanesch":"ko",
        "корејски":"ko",
        "koreana":"ko",
        "orang korea":"ko",
        "കൊറിയൻ":"ko",
        "koreani":"ko",
        "कोरियन":"ko",
        "солонгос":"ko",
        "ကိုရီးယား":"ko",
        "कोरियाली":"ko",
        "କୋରିଆନ୍":"ko",
        "کوریایی":"ko",
        "koreański":"ko",
        "coreana...":"ko",
        "coreeană":"ko",
        "корейский язык":"ko",
        "corèanach":"ko",
        "chikorean":"ko",
        "ڪورين":"ko",
        "කොරියානු":"ko",
        "kórejský":"ko",
        "kikorea":"ko",
        "koreanska":"ko",
        "корея":"ko",
        "கொரியன்":"ko",
        "เกาหลี":"ko",
        "koreli":"ko",
        "корейський":"ko",
        "کورین":"ko",
        "koreys":"ko",
        "hàn quốc":"ko",
        "corea":"ko",
        "קאָרעיִש":"ko",
        "arabinrin":"so",
        "isikorea":"ko",
        "koerdies (kurmanji)":"ku",
        "kurdish (kurmanji)":"ku",
        "ኩርዲሽ (ኩርማንጂ)":"ku",
        "الكردية (kurmanji)":"ku",
        "քրդերեն (kurmanji)":"ku",
        "kürd (kurmanji)":"ku",
        "курдскі (курманджы)":"ku",
        "কুর্দিশ (কুরমানজি)":"ku",
        "kurdski (kurmanji)":"ku",
        "курдски (курманджи)":"ku",
        "kurdština (kurmanji)":"ku",
        "kurdisk (kurmanji)":"ku",
        "koerdisch (kurmanji)":"ku",
        "kurdi (kurmanji)":"ku",
        "kurde (kurmanji)":"ku",
        "ქურთული (kurmanji)":"ku",
        "kurdisch (kurmanji)":"ku",
        "κουρδικά (kurmanji)":"ku",
        "કુર્દિશ (કુર્મનજી)":"ku",
        "ʻilikai (kurmanji)":"ku",
        "כורדית (kurmanji)":"ku",
        "कुरदीश (कुरमानजी)":"ku",
        "kurd (kurmanji)":"ku",
        "kúrdískt (kurmanji)":"ku",
        "coirdis (kurmanji)":"ku",
        "クルド語（クルマンジー）":"ku",
        "ಕುರ್ದಿಶ್ (ಕುರ್ಮನ್ಜಿ)":"ku",
        "күрд (курманжи)":"ku",
        "쿠르드어 (kurmanji)":"ku",
        "курдиш":"ku",
        "lingua kurdica (kurmanji)":"ku",
        "kurdu (kurmanji)":"ku",
        "kurdas (kurmanji)":"ku",
        "kurdesch (kurmanji)":"ku",
        "курдски (kurmanji)":"ku",
        "sokajin-teny":"ku",
        "കുർദിഷ് (കുർമാൻജി)":"ku",
        "कुर्दिश (कुरमानजी)":"ku",
        "курд (курманжи)":"ku",
        "କୁର୍ଡିସ୍ (କୁରମାନଜୀ)":"ku",
        "کرديش (کرمانجي)":"ku",
        "کردی (kurmanji)":"ku",
        "kurdyjski (kurmanji)":"ku",
        "curdo (kurmanji)":"ku",
        "ਕੁਰਦੀਸ਼ (ਕੁਰਮਨਜੀ)":"ku",
        "курдиш (курманджи)":"ku",
        "курдски (курмањи)":"ku",
        "ڪرديش (ڪرمانجي)":"ku",
        "කුර්දි (කුර්මන්ජි)":"ku",
        "kurdsky (kurmanji)":"ku",
        "kurdo (kurmanji)":"ku",
        "kurudisha (kurmanji)":"ku",
        "kurdiska (kurmanji)":"ku",
        "курдӣ (курмани)":"ku",
        "குர்திஷ் (குர்மன்ஜி)":"ku",
        "కుర్దిష్ (కుర్మంజీ)":"ku",
        "ดิช (kurmanji)":"ku",
        "kürtçe (kurmanci)":"ku",
        "курдський (курманджі)":"ku",
        "کردش (کرمانجی)":"ku",
        "kurdcha (kurmanji)":"ku",
        "người kurd (kurmanji)":"ku",
        "cwrdeg (kurmanji)":"ku",
        "קורדיש (kurmanji)":"ku",
        "kirgisies":"ky",
        "kyrgyz":"ky",
        "ክይርግያዝ":"ky",
        "قيرغيزستان":"ky",
        "քիրգզ":"ky",
        "qırğız":"ky",
        "kirgizera":"ky",
        "кіргіз":"ky",
        "কির্গিজ":"ky",
        "киргизстан":"ky",
        "kirguiz":"ky",
        "miliri":"ky",
        "kirgistanu":"ky",
        "kirgisisk":"ky",
        "kirgizië":"ky",
        "kirgizo":"ky",
        "kirgiisi":"ky",
        "kirgisian":"ky",
        "kirghize":"ky",
        "kirgizysk":"ky",
        "ყირგიზი":"ky",
        "kirgisisch":"ky",
        "κιργιζία":"ky",
        "કિર્ગિઝ":"ky",
        "ōlelo kyrgyz":"ky",
        "קירגיז":"ky",
        "किरगिज़":"ky",
        "kirgiz":"ky",
        "kerabat":"ky",
        "キルギス":"ky",
        "ಕಿರ್ಗಿಜ್":"ky",
        "қырғыз":"ky",
        "키르기스":"ky",
        "qirgizî":"ky",
        "кыргызча":"ky",
        "lingua kirgistana":"ky",
        "kirgīzu":"ky",
        "kirgizas":"ky",
        "kirgisesch":"ky",
        "киргиз":"ky",
        "കിർഗിസ്":"ky",
        "kirgiż":"ky",
        "किर्गिझ":"ky",
        "किर्गिज":"ky",
        "kirgisistan":"ky",
        "କିର୍ଗିଜ୍":"ky",
        "قرغیزي":"ky",
        "کیرگیز":"ky",
        "kirgiski":"ky",
        "quirguiz":"ky",
        "ਕਿਰਗੀਜ਼":"ky",
        "kârgâză":"ky",
        "киргизский":"ky",
        "kirikisi":"ky",
        "kiyagizi":"ky",
        "ڪرغيز":"ky",
        "කිර්ගිස්":"ky",
        "kirgizská":"ky",
        "kirgizi":"ky",
        "kirguisa":"ky",
        "қирғиз":"ky",
        "கிர்கிஸ்":"ky",
        "కిర్గిజ్":"ky",
        "คีร์กีซ":"ky",
        "kırgız":"ky",
        "کرغیز":"ky",
        "قىرغىز":"ky",
        "qirg'iz":"ky",
        "kyrangu":"ky",
        "isikyrgyz":"ky",
        "lao":"lo",
        "ላኦ":"lo",
        "لاو":"lo",
        "լաո":"lo",
        "лаос":"lo",
        "লাও":"lo",
        "лао":"lo",
        "laotjaansk":"lo",
        "ლაო":"lo",
        "λάο":"lo",
        "લાઓ":"lo",
        "ōlelo laosa":"lo",
        "לאו":"lo",
        "लाओ":"lo",
        "laó":"lo",
        "ラオス":"lo",
        "ಲಾವೊ":"lo",
        "ឡាវ":"lo",
        "라오 어":"lo",
        "laoyî":"lo",
        "лаочо":"lo",
        "laomedonteae":"lo",
        "laosas":"lo",
        "laotesch":"lo",
        "ലാവോ":"lo",
        "လာအို":"lo",
        "ଲାଓ":"lo",
        "لائو":"lo",
        "ਲਾਓ":"lo",
        "layo":"lo",
        "ලාඕ":"lo",
        "laoški":"lo",
        "laos":"lo",
        "லாவோ":"lo",
        "లావో":"lo",
        "ลาว":"lo",
        "لاؤ":"lo",
        "isilawo":"lo",
        "i-lao":"lo",
        "latin":"la",
        "ላቲን":"la",
        "اللاتينية":"la",
        "լատիներեն":"la",
        "latın":"la",
        "латынь":"la",
        "ল্যাটিন":"la",
        "latinica":"la",
        "латински":"la",
        "llatí":"la",
        "latini":"la",
        "latinu":"la",
        "latinski":"la",
        "latinský":"la",
        "latijns":"la",
        "latina":"la",
        "ladina keeles":"la",
        "latine":"la",
        "latyn":"la",
        "latín":"la",
        "ლათინური":"la",
        "latein":"la",
        "λατινικά":"la",
        "લેટિન":"la",
        "ōlelo lākni":"la",
        "לָטִינִית":"la",
        "लैटिन":"la",
        "latína":"la",
        "laidin":"la",
        "ラテン":"la",
        "ಲ್ಯಾಟಿನ್":"la",
        "латын":"la",
        "ឡាតាំង":"la",
        "라틴":"la",
        "latînî":"la",
        "латынча":"la",
        "ລາຕິນ":"la",
        "latīņu":"la",
        "lotyniškas":"la",
        "laténgesch":"la",
        "bahasa latin":"la",
        "ലാറ്റിൻ":"la",
        "लॅटिन":"la",
        "латин":"la",
        "လက်တင်":"lv",
        "ल्याटिन":"la",
        "ଲାଟିନ୍":"la",
        "لاتین":"la",
        "łacina":"la",
        "latim":"la",
        "ਲਾਤੀਨੀ":"la",
        "латинский":"la",
        "laidinn":"la",
        "ratini":"la",
        "لاطيني":"la",
        "ලතින්":"la",
        "latinčina":"la",
        "latinščina":"la",
        "лотинӣ":"la",
        "லத்தீன்":"la",
        "లాటిన్":"la",
        "ละติน":"la",
        "latince":"la",
        "латинь":"la",
        "لاطینی":"la",
        "lotin":"la",
        "lladin":"la",
        "isilatini":"la",
        "לאַטייַן":"la",
        "latari":"la",
        "i-latin":"la",
        "latvian":"lv",
        "letonisht":"lv",
        "ላትቪያን":"lv",
        "اللاتفية":"lv",
        "լատ":"lv",
        "latviyalı":"lv",
        "адмяніць":"lv",
        "odbiti":"lv",
        "латвийски":"lv",
        "llet":"lv",
        "lettone":"lv",
        "lotyšský":"lv",
        "lettisk":"lv",
        "lets":"lv",
        "latuno":"lv",
        "lätlane":"lv",
        "latvialainen":"lv",
        "letton":"lv",
        "letsk":"lv",
        "letón":"lv",
        "ლატ":"lv",
        "lettisch":"lv",
        "λετονικά":"lv",
        "આંખ":"lv",
        "letoni":"lv",
        "lakiwiana":"lv",
        "לטבית":"lv",
        "lett":"lv",
        "lettneska":"lv",
        "latvia":"lv",
        "ラトビア語":"lv",
        "ಲಟ್ವಿಯನ್":"lv",
        "латвиялық":"lv",
        "라트비아 사람":"lv",
        "letonî":"lv",
        "латвияча":"lv",
        "latvijas":"lv",
        "latvis":"lv",
        "lettesch":"lv",
        "лат":"lv",
        "zavatra tsy":"lv",
        "bahasa latvia":"lv",
        "ലാത്വിയൻ":"lv",
        "ara":"lv",
        "डोळा":"lv",
        "латви":"lv",
        "आँखा":"lv",
        "latvisk":"lv",
        "ଲାଟଭିଆନ୍":"lv",
        "لیتوین":"lv",
        "لتونی":"lv",
        "łotewski":"lv",
        "letã":"lv",
        "ਅੱਖ":"lv",
        "letonă":"lv",
        "латышский":"lv",
        "latbhianach":"lv",
        "латвиан":"lv",
        "chilatvian":"lv",
        "لاتوين ٻولي":"lv",
        "ලැට්වියානු":"lv",
        "upadati":"lv",
        "letona":"lv",
        "латвия":"lv",
        "லாட்வியன்":"lv",
        "ลัตเวีย":"lv",
        "letonyalı":"lv",
        "скоромовка":"lv",
        "پیاری":"lv",
        "latviyalik":"lv",
        "let":"lv",
        "isi-latvian":"lv",
        "lithuanian":"lt",
        "lituanez":"lt",
        "ሊቱኒያን":"lt",
        "اللتوانية":"lt",
        "հնարավոր":"lt",
        "litvalı":"lt",
        "літоўскі":"lt",
        "litvanski":"lt",
        "литовски":"lt",
        "indiscutible":"lt",
        "littuanianu":"lt",
        "litevský":"lt",
        "litauisk":"lt",
        "litouws":"lt",
        "leedulane":"lt",
        "liettualainen":"lt",
        "lituanienne":"lt",
        "litousk":"lt",
        "indio":"lt",
        "შესაძლებელია":"lt",
        "litauisch":"lt",
        "λιθουανικά":"lt",
        "રમત":"lt",
        "lityanyen":"lt",
        "lithuaniyanci":"lt",
        "ōlelo lituania":"lt",
        "ליטאית":"lt",
        "litván":"lt",
        "litháen":"lt",
        "lithuania":"lt",
        "lituana":"lt",
        "リトアニア語":"lt",
        "ljurian":"lt",
        "ಲಿಥುವೇನಿಯನ್":"lt",
        "литвалық":"lt",
        "លីចូយាន":"lt",
        "리투아니아 사람":"lt",
        "lîtvanyayî":"lt",
        "литвача":"lt",
        "lietuviete":"lt",
        "lietuvis":"lt",
        "litauesch":"lt",
        "можна":"lt",
        "litoanianina":"lt",
        "bahasa lithuania":"lt",
        "ലിത്വാനിയൻ":"lt",
        "indika":"lt",
        "खेळ":"mt",
        "литвийн":"lt",
        "လစ်သူ":"lt",
        "खेलौना":"lt",
        "ଲିଥୁଆନିଆ":"lt",
        "لیتوانیایی":"lt",
        "توانا":"lt",
        "litewski":"lt",
        "ਖੇਡ":"lt",
        "lituanian":"lt",
        "литовский":"lt",
        "lituaniana":"lt",
        "lithuanianach":"lt",
        "литвански":"lt",
        "ritunia":"lt",
        "ليٿونيائي":"lt",
        "ලිතුවේනියානු":"lt",
        "litovský":"lt",
        "litovska":"lt",
        "лётчикхо":"lt",
        "லிதுவேனியன்":"lt",
        "ภาษาลิธัวเนีย":"lt",
        "litvanyalı":"lt",
        "литовський":"lt",
        "کھیل":"mt",
        "litvalik":"lt",
        "áo choàng":"lt",
        "isilithuwaniya":"lt",
        "ליטוויש":"lt",
        "isi-lithuanian":"lt",
        "luxemburgs":"lb",
        "luksemburgase":"lb",
        "ሉክዜምብርጊሽ":"lb",
        "لوكسمبورج":"lb",
        "շքեղ":"lb",
        "lüks":"lb",
        "luxenburgera":"lb",
        "люксембургскі":"lb",
        "লুক্সেমবার্গীয়":"lb",
        "luksemburški":"lb",
        "люксембургски":"lb",
        "luxemburguès":"lb",
        "maluho":"lb",
        "zapembourgish":"lb",
        "lussemburghese":"lb",
        "lucembursky":"lb",
        "luxembourgsk":"lb",
        "luxembourgish":"lb",
        "luksaĵo":"lb",
        "luksemburglik":"lb",
        "luxemburg":"lb",
        "luxembourgeois":"lb",
        "lúksemboarchsk":"lb",
        "luxemburgo":"lb",
        "ლუქსემბურგული":"lb",
        "luxemburgisch":"lb",
        "λουξεμβούργο":"lb",
        "લક્ઝમ્બર્ગીશ":"lb",
        "kayan kwalliya":"lb",
        "ōlelo lukemapuka":"lb",
        "לוקסמבורגית":"lb",
        "लक्जमबर्गिश":"lb",
        "nplua nuj":"lb",
        "luxemburgi":"lb",
        "lúxemborgar":"lb",
        "okomoko":"lb",
        "ルクセンブルク語":"lb",
        "ಲಕ್ಸೆಂಬರ್ಗ್":"lb",
        "люкс":"lb",
        "លុចសំបួរ":"lb",
        "룩셈부르크":"lb",
        "luksembûrgî":"lb",
        "люксембургча":"lb",
        "luksemburgietis":"lb",
        "prabangus":"lb",
        "lëtzebuergesch":"lb",
        "луксемкинец":"lb",
        "mewah":"lb",
        "ലക്സംബർഗ്":"lb",
        "लक्झंबर्गिश":"lb",
        "дээд зэрэглэлийн":"lb",
        "လူဇင်ဘတ်":"lb",
        "लक्जम्बर्गिश":"lb",
        "ବିଳାସପୂର୍ଣ୍ଣ":"lb",
        "لوګزامبورګي":"lb",
        "لوکزامبورگ":"lb",
        "luksemburski":"lb",
        "luxemburguês":"lb",
        "ਲਗਜ਼ਬਰਗ":"lb",
        "luxemburgheză":"lb",
        "люксембургский":"lb",
        "lusemipoukisi":"lb",
        "luxembourgach":"lb",
        "луксембуршки":"lb",
        "rukusembogi":"lb",
        "لڪسمبرگي":"lb",
        "luxemburský":"lb",
        "luxemburguesa":"lb",
        "méwah":"lb",
        "kifahari":"lb",
        "லக்ஸம்பர்க்":"lb",
        "లుక్సంబర్గిష్":"lb",
        "ลักเซมเบิร์ก":"lb",
        "lüksemburg'un":"lb",
        "люксембурзький":"lb",
        "لکسبورگش":"lb",
        "ھەشەمەتلىك":"lb",
        "hashamatli":"lb",
        "xa xỉ":"lb",
        "moethus":"lb",
        "isiluksembogu":"lb",
        "לוקסעמבאָורגיש":"lb",
        "adunrere":"lb",
        "i-luxembourgish":"lb",
        "macedonian":"mk",
        "maqedonas":"mk",
        "ማስዶንያን":"mk",
        "المقدونية":"mk",
        "մակեդոնական":"mk",
        "makedoniyalı":"mk",
        "македонская":"mk",
        "makedonski":"mk",
        "македонски":"mk",
        "instal·lada":"mk",
        "macedonia":"mk",
        "macedone":"mk",
        "macedonský":"mk",
        "makedonsk":"mk",
        "macedonisch":"mk",
        "macedonian...":"mk",
        "makedoonia":"mk",
        "macédonien":"mk",
        "masedoanysk":"mk",
        "instalado":"mk",
        "მაკედონიური":"mk",
        "mazedonisch":"mk",
        "μακεδόνας":"mk",
        "બરફ":"mk",
        "mèkredi":"mk",
        "makekoni":"mk",
        "מקדונית":"mk",
        "macedóniai":"mk",
        "makedónska":"mk",
        "onye macedonian":"mk",
        "makedonia":"mk",
        "マケドニアの":"mk",
        "ಮ್ಯಾಸಿಡೋನಿಯನ್":"mk",
        "македониялық":"mk",
        "마케도니아 어":"mk",
        "makedonî":"mk",
        "македонияча":"mk",
        "macedonica":"mk",
        "maķedonietis":"mk",
        "makedonietis":"mk",
        "mazedonesch":"mk",
        "masedoniana":"mk",
        "മാസിഡോണിയൻ":"mk",
        "magħżul":"mk",
        "बर्फ":"mk",
        "македони":"mk",
        "မက်ဒို":"mk",
        "ମାକେଡୋନିଆନ୍ |":"mk",
        "مقدوني":"mk",
        "مقدونی":"mk",
        "macedoński":"mk",
        "macedônia":"mk",
        "ਬਰਫ":"mk",
        "macedonean":"mk",
        "македонский":"mk",
        "macedonianach":"mk",
        "chimacedonian":"mk",
        "මැසිඩෝනියානු":"mk",
        "macedónio":"mk",
        "makedonska":"mk",
        "македонй":"mk",
        "มาซิโดเนีย":"mk",
        "makedonya":"mk",
        "македонський":"mk",
        "برف":"mk",
        "makedoniyalik":"mk",
        "nhà hát":"mk",
        "macedonaidd":"mk",
        "mecedonian":"mk",
        "מאַקעדאָניש":"mk",
        "madagaskar":"mg",
        "malagasy":"mg",
        "مدغشقر":"mg",
        "մալագասերեն":"mg",
        "малагасійскі":"mg",
        "মালাগাসি":"mg",
        "malagaški":"mg",
        "мадагаскарски":"mg",
        "zodandaula":"mg",
        "malaga":"mg",
        "malagasi":"mg",
        "madagaskars":"mg",
        "malgaza":"mg",
        "malagaasia":"mg",
        "madagaskarin":"mg",
        "malgache":"mg",
        "malgaxe":"mg",
        "მალაგური":"mg",
        "madagassisch":"mg",
        "δυστυχία":"mg",
        "મલાગસી":"mg",
        "hawaiʻi":"mg",
        "मालागासी":"mg",
        "malntx":"mg",
        "madagaszkári":"mg",
        "malgascia":"mg",
        "マダガスカル":"mg",
        "ಮಲಗಾಸಿ":"mg",
        "малагаси":"mg",
        "សាហាវ":"mg",
        "마다가스카르 사람":"mg",
        "malavanî":"mg",
        "ມະໂຫ":"mg",
        "madagascar":"mg",
        "negalavimas":"mg",
        "малгашки":"mg",
        "മലഗാസി":"mg",
        "malagażi":"mg",
        "ငှက်ဖျား":"mg",
        "gassisk":"mg",
        "ମାଲାଗାସୀ |":"mg",
        "ملاګاسي":"mg",
        "مالاوگا":"mg",
        "malgaski":"mg",
        "ਮਲਗਾਸੀ":"mg",
        "malgașă":"mg",
        "малагасиец":"mg",
        "malaia":"ms",
        "малагашки":"mg",
        "خرابي":"mg",
        "අක්\u200dරමිකතාව":"mg",
        "madagaskaru":"mg",
        "malagaščina":"mg",
        "madagascarí":"mg",
        "balaa":"mg",
        "малагасия":"mg",
        "மலகாஸி":"mg",
        "మాలాగసి":"mg",
        "มาดากัสการ์":"mg",
        "madagaskarlı":"mg",
        "малагасійський":"mg",
        "ملاگاسی":"mg",
        "imalagasy":"mg",
        "מאַלאַגאַסי":"mg",
        "malay":"ms",
        "malajas":"ms",
        "ማላይ":"ms",
        "لغة الملايو":"ms",
        "մալայերեն":"ms",
        "малая":"ms",
        "малайски":"ms",
        "malai":"ms",
        "maldito":"ms",
        "malese":"ms",
        "malajski":"ms",
        "mrzutý":"ms",
        "maleis":"ms",
        "malaja":"ms",
        "malaiji":"ms",
        "malaise":"ms",
        "maleisk":"ms",
        "malayo":"ms",
        "მალაიზი":"ms",
        "malaiisch":"ms",
        "μαλάι":"ms",
        "મલય":"ms",
        "mālei":"ms",
        "מלזית":"ms",
        "मलय":"ms",
        "maláj":"ms",
        "melayu":"ms",
        "athnuachana":"ms",
        "マレー語":"ms",
        "wong lanang":"ms",
        "ಮಲಯ":"ms",
        "малай":"ms",
        "말레이 사람":"ms",
        "malayî":"ms",
        "малайча":"ms",
        "ມະຫິມະ":"ms",
        "malaeorum":"ms",
        "malajietis":"ms",
        "malajų":"ms",
        "malaiesch":"ms",
        "малајски":"ms",
        "മലായ്":"ms",
        "malajan":"ms",
        "မလေး":"ml",
        "माला":"ms",
        "مالایا":"ms",
        "مالایی":"ms",
        "ਮਾਲੇ":"ms",
        "malaezian":"ms",
        "малайский":"ms",
        "malaidheach":"ms",
        "малаи":"ms",
        "mala":"ms",
        "chimalay":"ms",
        "مالائي":"ms",
        "මැලේ":"ms",
        "malajsky":"ms",
        "malega":"ms",
        "malaya":"ms",
        "malayaga":"ms",
        "malaika":"ms",
        "malajiska":"ms",
        "மலாய்":"ms",
        "ภาษามลายู":"ms",
        "малайський":"ms",
        "مالائی":"ms",
        "mã lai":"ml",
        "maleieg":"ms",
        "malabaars":"ml",
        "malayalam":"ml",
        "المالايالامية":"ml",
        "մալամալամ":"ml",
        "малаялам":"ml",
        "মালায়ালম":"ml",
        "malajalam":"ml",
        "malaalam":"ml",
        "malajala":"ml",
        "malabar":"ml",
        "მალაჰალამი":"ml",
        "μαλαγιάλαμ":"ml",
        "મલયાલમ":"ml",
        "mālealama":"ml",
        "מלזאלם":"ml",
        "मलयालम":"ml",
        "athnuachan":"ml",
        "マラヤーラム語":"ml",
        "ಮಲಯಾಳಂ":"ml",
        "ម៉ាលឡាឡាំ":"ml",
        "말라 얄 람어":"ml",
        "malayalamî":"ml",
        "малаяламча":"ml",
        "ມະຫາໄລ":"ml",
        "malajalamas":"ml",
        "малахалам":"ml",
        "മലയാളം":"ml",
        "मल्याळम":"ml",
        "ମାଲାୟାଲମ୍":"ml",
        "ملایلم":"ml",
        "مالالامال":"ml",
        "ਮਲਿਆਲਮ":"ml",
        "малаяла":"ml",
        "malayalamach":"ml",
        "малајалам":"ml",
        "chimalayalam":"ml",
        "مالايالم":"ml",
        "මලයාලම්":"ml",
        "malajálamčina":"ml",
        "மலையாளம்":"ml",
        "మలయాళ":"ml",
        "มาลายาลัม":"ml",
        "ملیالم":"ml",
        "isi-malayalam":"ml",
        "maltese":"mt",
        "maltez":"mt",
        "ማልትስ":"mt",
        "المالطية":"mt",
        "մալթերեն":"mt",
        "мальтыйскі":"mt",
        "malteški":"mt",
        "малтийски":"mt",
        "maltès":"mt",
        "malta":"mt",
        "maltština":"mt",
        "maltesisk":"mt",
        "maltees":"mt",
        "maltalainen":"mt",
        "maltais":"mt",
        "malteesk":"mt",
        "maltés":"mt",
        "მალტური":"mt",
        "maltesisch":"mt",
        "μαλτέζος":"mt",
        "સ્પોટ":"mt",
        "malkī":"mt",
        "מלטזית":"mt",
        "máltai":"mt",
        "maltneska":"mt",
        "mháltais":"mt",
        "マルタ語":"mt",
        "ಮಾಲ್ಟೀಸ್":"mt",
        "мальтеза":"mt",
        "ជនជាតិម៉ាល់ឌីវ":"mt",
        "몰티즈":"mt",
        "maltezî":"mt",
        "малтизче":"mt",
        "ຄົນຕະລົກ":"mt",
        "melitensis":"mt",
        "maltiešu":"mt",
        "maltiečių":"mt",
        "maltesesch":"mt",
        "малтешки":"mt",
        "മാൾട്ടീസ്":"mt",
        "maltin":"mt",
        "малтит":"mt",
        "खेलकुद":"mt",
        "ମାଲ୍ଟି":"mt",
        "مالتیس":"mt",
        "مالتی":"mt",
        "maltański":"mt",
        "maltesa":"mt",
        "ਕਪੜੇ":"mt",
        "мальтийский":"mt",
        "malteseach":"mt",
        "malwetse":"mt",
        "chimaltese":"mt",
        "مالٽي":"mt",
        "මෝල්ටිස්":"mt",
        "maltčina":"mt",
        "малтесе":"mt",
        "மால்டிஸ்":"mt",
        "มอลตา":"mt",
        "мальтійська":"mt",
        "cây nho":"mt",
        "malteg":"mt",
        "מאלטיזיש":"mt",
        "isi-malta":"mt",
        "ማኦሪይ":"mi",
        "الماوري":"mi",
        "маоры":"mi",
        "মাওরি":"mi",
        "маорски":"mi",
        "maor":"mi",
        "maoorid":"mi",
        "maorie":"mi",
        "maorí":"mi",
        "მაორი":"mi",
        "μάορι":"mi",
        "માઓરી":"mi",
        "ōlelo māori":"mi",
        "מאורי":"mi",
        "माओरी":"mi",
        "マオリ":"mi",
        "ಮಾವೊರಿ":"mi",
        "маори":"mi",
        "ម៉ារីអូ":"mi",
        "마오리족":"mi",
        "maorîyî":"mi",
        "маориче":"mi",
        "maorice":"mi",
        "maorių":"mi",
        "maoresch":"mi",
        "മ ori റി":"mi",
        "माऊरी":"mi",
        "माउरी":"mi",
        "ମାଧୁରୀ |":"mi",
        "ماوري":"mi",
        "مائوری":"mi",
        "maoryski":"mi",
        "ਮਾਓਰੀ":"mi",
        "maoli":"mi",
        "مائوري":"mi",
        "ம ori ரி":"mi",
        "మయోరి":"mi",
        "ชาวเมารี":"mi",
        "маорі":"mi",
        "ماوری":"mi",
        "isimawori":"mi",
        "marathi":"mr",
        "ማራቲ":"mr",
        "المهاراتية":"mr",
        "marati":"mr",
        "маратхі":"mr",
        "মারাঠি":"mr",
        "маратхи":"mr",
        "maratysk":"mr",
        "მარათი":"mr",
        "μαράθι":"mr",
        "મરાઠી":"mr",
        "malapi":"mr",
        "מרתי":"mr",
        "मराठी":"mr",
        "マラーティー語":"mr",
        "ಮರಾಠಿ":"mr",
        "ម៉ារ៉ាធី":"mr",
        "마라 티어":"mr",
        "maratî":"mr",
        "маратиче":"mr",
        "maratų":"mr",
        "марати":"mr",
        "മറാത്തി":"mr",
        "марати хэл":"mr",
        "မာရသီ":"mr",
        "माराठी":"mr",
        "ମରାଠୀ":"mr",
        "مراټي":"mr",
        "ماراتی":"mr",
        "ਮਰਾਠੀ":"mr",
        "marathiach":"mr",
        "chimarati":"mr",
        "مراٺي":"mr",
        "මරාති":"mr",
        "maráthčina":"mr",
        "маратҳӣ":"mr",
        "மராத்தி":"mr",
        "మరాఠీ":"mr",
        "ฐี":"mr",
        "مراٹھی":"mr",
        "marafiy":"mr",
        "isimarathi":"mr",
        "mongoolse":"mn",
        "mongolian":"mn",
        "ሞኒጎሊያን":"mn",
        "المنغولية":"mn",
        "monqol":"mn",
        "мангольская":"mn",
        "মঙ্গোলিয়":"mn",
        "mongolski":"mn",
        "монголски":"mn",
        "mongoli":"mn",
        "mongolianu":"mn",
        "mongolský":"mn",
        "mongools":"mn",
        "mongola":"mn",
        "mongoli keel":"mn",
        "mongolialainen":"mn",
        "mongole":"mn",
        "mongoalsk":"mn",
        "mongoliano":"mn",
        "მონღოლური":"mn",
        "mongolisch":"mn",
        "μογγόλος":"mn",
        "મંગોલિયન":"mn",
        "ōlelo monokolia":"mn",
        "מוֹנגוֹלִי":"mn",
        "मंगोलियन":"mn",
        "mongol":"mn",
        "mongólískt":"mn",
        "mongolia":"mn",
        "mongóil":"mn",
        "モンゴル語":"mn",
        "ಮಂಗೋಲಿಯನ್":"mn",
        "моңғол":"mn",
        "몽고 어":"mn",
        "moxolî":"mn",
        "монголчо":"mn",
        "ມົງໂກລີ":"mn",
        "mongolica":"mn",
        "mongoļu":"mn",
        "mongolų":"mn",
        "mongolesch":"mn",
        "mongoliana":"mn",
        "മംഗോളിയൻ":"mn",
        "монгол":"mn",
        "မွန်ဂိုလီးယန်း":"mn",
        "mongolsk":"mn",
        "مغولي":"mn",
        "مغول":"mn",
        "ਮੰਗੋਲੀਅਨ":"mn",
        "монгольский":"mn",
        "mokoliana":"mn",
        "mongolianach":"mn",
        "chimongoria":"mn",
        "منگولي":"mn",
        "මොන්ගෝලියානු":"mn",
        "mongoliska":"mn",
        "муғулистон":"mn",
        "மங்கோலியன்":"mn",
        "มองโกเลีย":"mn",
        "moğolca":"mn",
        "монгольська":"mn",
        "منگولین":"mn",
        "mo'g'ul":"mn",
        "mông cổ":"mn",
        "mongolaidd":"mn",
        "isimongoliya":"mn",
        "ara ilu mongolia":"mn",
        "mianmar (birmaans)":"my",
        "myanmar (burimes)":"my",
        "ሚያንማር (burmese)":"my",
        "ميانمار (بورما)":"my",
        "myanmar (burma)":"my",
        "myanmar (burmeo)":"my",
        "м'янма (бірманская)":"my",
        "মায়ানমার (বার্মিজ)":"my",
        "mjanmar (burma)":"my",
        "мианма (бирма)":"my",
        "myanmar (burmaia)":"my",
        "myanmar (burmese)":"my",
        "myanmar (barmština)":"my",
        "myanmar (burmesisk)":"my",
        "myanmar (birmees)":"my",
        "myanmar (burmese)...":"my",
        "myanmar (birma)":"my",
        "myanmar (burmalainen)":"my",
        "myanmar (birman)":"my",
        "myanmar (birmaansk)":"my",
        "მიანმარა (ბირმული)":"my",
        "myanmar (burmesisch)":"my",
        "myanmar (βιρμανία)":"my",
        "મ્યાનમાર (બર્મીઝ)":"my",
        "myanma (burmese)":"my",
        "madium (burmese)":"my",
        "honu":"my",
        "מיאנמר (בורמזי)":"my",
        "म्यांमार (बर्मी)":"my",
        "mianmar (burmai)":"my",
        "maenmar (burmais)":"my",
        "myanmar (birmano)":"my",
        "ミャンマー（ビルマ）":"my",
        "ಮ್ಯಾನ್ಮಾರ್ (ಬರ್ಮೀಸ್)":"my",
        "мьянма (бирма)":"my",
        "មីយ៉ាន់ម៉ា (burmese)":"my",
        "미얀마 (버마어)":"my",
        "myanmar":"my",
        "ມຽນມາ (burmese)":"my",
        "suspendisse (burmese)":"my",
        "mjanma (birmiešu)":"my",
        "mianmaras (birmos)":"my",
        "myanmar (birmanesch)":"my",
        "мијанмар":"my",
        "മ്യാൻമർ (ബർമീസ്)":"my",
        "mjanmar (burmaż)":"my",
        "म्यानमार (बर्मीज)":"my",
        "мьянмар (бурмэс)":"my",
        "မြန်မာ (မြန်မာ)":"my",
        "म्यानमार (बर्मिज)":"my",
        "ମିଆଁମାର (ବର୍ମା)":"my",
        "میانمار (برمی)":"my",
        "میانمار (برمه ای)":"my",
        "myanmar (birmański)":"my",
        "myanmar (birmanês)":"my",
        "ਮਿਆਂਮਾਰ (ਬਰਮੀ)":"my",
        "myanmar (birmania)":"my",
        "мьянма (бирманская)":"my",
        "мјанмар (бурмански)":"my",
        "ميانمار (برمي)":"my",
        "මියන්මාරය (බුරුමය)":"my",
        "mjanmarsko (barmsky)":"my",
        "mjanmarica (burma)":"my",
        "myanmar (tukang basa)":"my",
        "myanmar (burmesiska)":"my",
        "мянмар (бирма)":"my",
        "மியான்மர் (பர்மிய)":"my",
        "మయన్మార్ (బర్మీస్)":"my",
        "เมียนมาร์ (พม่า)":"my",
        "myanmar (birmanya)":"my",
        "м'янма (бірма)":"my",
        "myanma (birma)":"my",
        "umyenam (burmese)":"my",
        "myanmar (בורמעזיש)":"my",
        "i-myanmar (burmese)":"my",
        "nepalees":"ne",
        "nepali":"ne",
        "ኔፓሊ":"ne",
        "النيبالية":"ne",
        "непалі":"ne",
        "নেপালি":"ne",
        "непалски":"ne",
        "nepalese":"ne",
        "nepalski":"ne",
        "nepalesisk":"ne",
        "nepala":"ne",
        "népalaise":"ne",
        "nepaleesk":"ne",
        "ნეპალი":"ne",
        "νεπαλί":"ne",
        "નેપાળી":"ne",
        "נפאלי":"ne",
        "नेपाली":"ne",
        "ziag no":"ne",
        "nepáli":"ne",
        "nepalska":"ne",
        "ネパール語":"ne",
        "ನೇಪಾಳಿ":"ne",
        "непалы":"ne",
        "네팔":"ne",
        "nepalî":"ne",
        "непаличе":"ne",
        "nepālietis":"ne",
        "nepalesesch":"ne",
        "непали":"ne",
        "നേപ്പാളി":"ne",
        "နီပေါ":"ne",
        "ନେପାଳୀ":"ne",
        "نیپالي":"ne",
        "نپالی":"ne",
        "ਨੇਪਾਲੀ":"ne",
        "nepaleză":"ne",
        "непальский":"ne",
        "nepalach":"ne",
        "chinepali":"ne",
        "نيپالي":"ne",
        "නෙපාලි":"ne",
        "nepálsky":"ne",
        "nepalí":"ne",
        "நேபாளி":"ne",
        "నేపాలి":"ne",
        "เนปาล":"ne",
        "nepalcedeki":"ne",
        "نیپالی":"ne",
        "נעפּאַליש":"ne",
        "norwegian":"no",
        "norvegjez":"no",
        "ኖርወይኛ":"no",
        "النرويجية":"no",
        "norveç":"no",
        "нарвежская":"no",
        "নরওয়েজীয়":"no",
        "norveški":"no",
        "норвежки":"no",
        "noruec":"no",
        "novegese":"no",
        "norština":"no",
        "norsk":"no",
        "noors":"no",
        "norvega":"no",
        "norra keeles":"no",
        "norjan kieli":"no",
        "norvégienne":"no",
        "noarsk":"no",
        "noruegués":"no",
        "ნორვეგიელი":"no",
        "norwegisch":"no",
        "νορβηγός":"no",
        "નોર્વેજીયન":"no",
        "nòvejyen":"no",
        "harshen koriya":"no",
        "nolewai":"no",
        "נורווגית":"no",
        "norvég":"no",
        "norsku":"no",
        "norwegia":"no",
        "norvegese":"no",
        "ノルウェー語":"no",
        "ನಾರ್ವೇಜಿಯನ್":"no",
        "норвегиялық":"no",
        "ន័រវែស":"no",
        "노르웨이 인":"no",
        "norwêcî":"no",
        "норвежче":"no",
        "ນອກແວ":"no",
        "norvēģi":"no",
        "norvegų":"no",
        "norweegesch":"no",
        "норвешки":"no",
        "norvejiana":"no",
        "നോർവീജിയൻ":"no",
        "norveġiż":"no",
        "नॉर्लियन":"no",
        "норвег":"no",
        "နော်ဝေ":"no",
        "नेदरल्याण्डियन":"no",
        "ନରୱେଜ୍":"no",
        "نارویژي":"no",
        "نروژی":"no",
        "norweski":"no",
        "norueguesa":"no",
        "ਨਾਰਵੇਲੀਅਨ":"no",
        "norvegian":"no",
        "норвежский":"no",
        "lochlannach":"no",
        "se-norway":"no",
        "chinorwegian":"no",
        "نارويجي":"no",
        "නෝර්වීජියානු":"no",
        "nórsky":"no",
        "norveška":"no",
        "noruega":"no",
        "kinorwe":"no",
        "norska":"no",
        "норвегӣ":"no",
        "நோர்வே":"no",
        "నార్వేజియన్":"no",
        "นอร์เวย์":"no",
        "norveççe":"no",
        "норвезька":"no",
        "نیدرلینائی":"no",
        "norvegcha":"no",
        "tiếng na uy":"no",
        "נאָרוועגיש":"no",
        "isinorway":"no",
        "odia":"or",
        "ኦሊያ":"or",
        "أوديا":"or",
        "одыя":"or",
        "ოდია":"or",
        "οδία":"or",
        "ઓડિયા":"or",
        "odya":"or",
        "אודיה":"or",
        "オディア":"or",
        "ಒಡಿಯಾ":"or",
        "одиа":"or",
        "오 디아":"or",
        "штаны":"or",
        "odija":"or",
        "одја":"or",
        "ഓഡിയ":"or",
        "ओडिया":"or",
        "နေ":"or",
        "ଓଡିଆ":"or",
        "اوډیا":"or",
        "اودیا":"or",
        "ਓਡੀਆ":"or",
        "اوديا":"or",
        "одия":"or",
        "ஓடியா":"or",
        "ఒడియా":"or",
        "одія":"or",
        "mùi hương":"or",
        "oorun":"or",
        "pasjtoe":"ps",
        "pashto":"ps",
        "الباشتو":"ps",
        "puştu":"ps",
        "пушто":"ps",
        "পুশতু":"ps",
        "paštu":"ps",
        "пущу":"ps",
        "pašto":"ps",
        "pastu":"ps",
        "pashtu":"ps",
        "პასტო":"ps",
        "παστώ":"ps",
        "પશ્તો":"ps",
        "ōlelo pashto":"ps",
        "פשטו":"ps",
        "पश्तो":"ps",
        "パシュトー語":"ps",
        "ಪಾಷ್ಟೋ":"ps",
        "пушту":"ps",
        "ផាសតូ":"ps",
        "파슈토":"ps",
        "peştûyî":"ps",
        "пуштунча":"ps",
        "ປາແດກ":"ps",
        "pastua":"ps",
        "puštu":"ps",
        "пафто":"ps",
        "പാഷ്ടോ":"ps",
        "пашто":"ps",
        "ပက်တို":"ps",
        "ପାଶ୍ଟୁ |":"ps",
        "پښتو":"ps",
        "پشتو":"ps",
        "paszto":"ps",
        "ਪਸ਼ਤੋ":"ps",
        "pasato":"ps",
        "пасхто":"ps",
        "pashito":"ps",
        "පැෂ්ටෝ":"ps",
        "paštčina":"ps",
        "пашту":"ps",
        "பாஷ்டோ":"ps",
        "పాష్టో":"ps",
        "isiphashto":"ps",
        "פּאַשטאָ":"ps",
        "persiese":"fa",
        "persian":"fa",
        "ፐርሽያን":"fa",
        "اللغة الفارسية":"fa",
        "fars":"fa",
        "персідскі":"fa",
        "পারসিক":"fa",
        "perzijski":"fa",
        "персийски":"fa",
        "persa":"fa",
        "kupitirira":"fa",
        "persianu":"fa",
        "persijski":"fa",
        "peršan":"fa",
        "persisk":"fa",
        "perzisch":"fa",
        "pärsia":"fa",
        "persialainen":"fa",
        "persane":"fa",
        "perzysk":"fa",
        "სპარსული":"fa",
        "persisch":"fa",
        "περσικός":"fa",
        "પર્સિયન":"fa",
        "pèsik":"fa",
        "tsani":"fa",
        "pelekia":"fa",
        "פַּרסִית":"fa",
        "फ़ारसी":"fa",
        "pheej":"fa",
        "perzsa":"fa",
        "persneskur":"fa",
        "tei":"fa",
        "orang persia":"fa",
        "persiana":"fa",
        "ペルシア語":"fa",
        "ಪರ್ಷಿಯನ್":"fa",
        "персия":"fa",
        "페르시아 인":"fa",
        "farsî":"fa",
        "парсча":"fa",
        "ເປີເຊຍ":"fa",
        "persici":"fa",
        "persiešu":"fa",
        "persų":"fa",
        "persesch":"fa",
        "персиски":"fa",
        "persianina":"fa",
        "പേർഷ്യൻ":"fa",
        "persjan":"fa",
        "पर्शियन":"fa",
        "перс":"fa",
        "ပါရှား":"fa",
        "पर्सियन":"fa",
        "farsi":"fa",
        "فارسي":"fa",
        "فارسی":"fa",
        "perski":"fa",
        "ਪਰਸੀਅਨ":"fa",
        "persană":"fa",
        "persianach":"fa",
        "перзијски":"fa",
        "chipersian":"fa",
        "පර්සියානු":"fa",
        "perzský":"fa",
        "mfuasi":"fa",
        "персид":"fa",
        "பெர்சியன்":"fa",
        "పెర్షియన్":"fa",
        "เปอร์เซีย":"fa",
        "farsça":"fa",
        "персидський":"fa",
        "فارس":"fa",
        "ba tư":"fa",
        "aṣa":"fa",
        "i-persian":"fa",
        "polish":"pl",
        "polonisht":"pl",
        "ፖሊሽ":"pl",
        "تلميع":"pl",
        "cilalamaq":"pl",
        "паліраваць":"pl",
        "পালিশ":"pl",
        "poljski":"pl",
        "лак":"pl",
        "polir":"pl",
        "kahamis":"pl",
        "kupukuta":"pl",
        "pulaccu":"pl",
        "polirati":"pl",
        "polština":"pl",
        "polere":"pl",
        "pools":"pl",
        "poluri":"pl",
        "poola":"pl",
        "kiillottaa":"pl",
        "polonais":"pl",
        "poalsk":"pl",
        "პოლონური":"pl",
        "polieren":"pl",
        "στίλβωση":"pl",
        "પોલિશ":"pl",
        "polonè":"pl",
        "goge baki":"pl",
        "pōlani":"pl",
        "פולני":"pl",
        "पोलिश":"pl",
        "txhuam":"pl",
        "fényesít":"pl",
        "pólskur":"pl",
        "polandia":"pl",
        "snas":"pl",
        "polacca":"pl",
        "研磨":"pl",
        "ಹೊಳಪು ಕೊಡು":"pl",
        "жылтырату":"pl",
        "ប៉ូលា":"pl",
        "광택":"pl",
        "polandî":"pl",
        "полякча":"pl",
        "ຂັດ":"pl",
        "poloniae":"pl",
        "pulēt":"pl",
        "lenkas":"pl",
        "polnesch":"pl",
        "полски":"pl",
        "poloney":"pl",
        "പോളിഷ്":"pl",
        "lustrar":"pl",
        "पॉलिश":"pl",
        "өнгөлөх":"pl",
        "အရောင်တင်သည်":"pl",
        "pusse":"pl",
        "ପଲିସ୍ |":"pl",
        "پولیش":"pl",
        "لهستانی":"pl",
        "polskie":"pl",
        "polonês":"pl",
        "ਪੋਲਿਸ਼":"pl",
        "lustrui":"pl",
        "полировать":"pl",
        "pòlainneach":"pl",
        "пољски":"pl",
        "polasetiki":"pl",
        "chipolish":"pl",
        "پالش":"pl",
        "පොලිෂ්":"pl",
        "lesk":"pl",
        "polaca":"pl",
        "hemir":"pl",
        "kipolishi":"pl",
        "putsa":"pl",
        "полиш":"pl",
        "lehçe":"pl",
        "шліфувати":"pl",
        "jilo":"pl",
        "đánh bóng":"pl",
        "sglein":"pl",
        "פּויליש":"pl",
        "pólándì":"pl",
        "songa":"pl",
        "portugees":"pt",
        "portugalisht":"pt",
        "ፖርቹጋልኛ":"pt",
        "البرتغالية":"pt",
        "portuqalca":"pt",
        "portuguese":"pt",
        "партугальская":"pt",
        "পর্তুগীজ":"pt",
        "portugalski":"pt",
        "португалски":"pt",
        "portuguès":"pt",
        "portuges":"pt",
        "chi portuguese":"pt",
        "portughese":"pt",
        "portugalština":"pt",
        "portugisisk":"pt",
        "portugalin kieli":"pt",
        "portugais":"pt",
        "portegeesk":"pt",
        "პორტუგალიური":"pt",
        "portugiesisch":"pt",
        "πορτογαλικά":"pt",
        "પોર્ટુગીઝ":"pt",
        "pòtigè":"pt",
        "pukikī":"pt",
        "פורטוגזית":"pt",
        "पुर्तगाली":"pt",
        "portugál":"pt",
        "portúgalska":"pt",
        "portugis":"pt",
        "portoghese":"pt",
        "ポルトガル語":"pt",
        "ಪೋರ್ಚುಗೀಸ್":"pt",
        "португал тілі":"pt",
        "ព័រទុយហ្កាល់":"pt",
        "포르투갈 인":"pt",
        "portekizî":"pt",
        "португалча":"pt",
        "ພາສາປອກຕຸຍການ":"pt",
        "portugāļi":"pt",
        "portugalų":"pt",
        "portugisesch":"pt",
        "portogey":"pt",
        "പോർച്ചുഗീസ്":"pt",
        "portugiż":"pt",
        "पोर्तुगीज":"pt",
        "португал хэлтэй":"pt",
        "ပေါ်တူဂီ":"pt",
        "पोर्तुगाली":"pt",
        "ପର୍ତ୍ତୁଗୀଜ୍":"pt",
        "پورتګالي":"pt",
        "پرتغالی":"pt",
        "portuguesa":"pt",
        "ਪੁਰਤਗਾਲੀ":"pt",
        "portugheză":"pt",
        "португальский":"pt",
        "portugalach":"pt",
        "chiputukezi":"pt",
        "پرتگالي":"pt",
        "පෘතුගීසි":"pt",
        "portugalský":"pt",
        "portugalščina":"pt",
        "portugisiska":"pt",
        "португалӣ":"pt",
        "போர்த்துகீசியம்":"pt",
        "โปรตุเกส":"pt",
        "portekizce":"pt",
        "португальська":"pt",
        "پرتگالی":"pt",
        "portugal tilida":"pt",
        "bồ đào nha":"pt",
        "isiphuthukezi":"pt",
        "פארטוגעזיש":"pt",
        "isi-portuguese":"pt",
        "punjabi":"pa",
        "ፑንጃቢ":"pa",
        "البنجابية":"pa",
        "панджабі":"pa",
        "পাঞ্জাবি":"pa",
        "пенджабски":"pa",
        "patar":"pa",
        "pendžabljanin":"pa",
        "pûndjaabsk":"pa",
        "პუნჯი":"pa",
        "પંજાબી":"pa",
        "ōlelo punajabi":"pa",
        "פנג'אבי":"pa",
        "पंजाबी":"pa",
        "pandzsábi":"pa",
        "パンジャブ語":"pa",
        "ಪಂಜಾಬಿ":"pa",
        "пунджаби":"pa",
        "ប៉ឺជ្កា":"pa",
        "펀자 브어":"pa",
        "pencabî":"pa",
        "пунжабиче":"pa",
        "romancica":"pa",
        "pundschabi":"pa",
        "панџаби":"pa",
        "പഞ്ചാബി":"pa",
        "пунжаби":"pa",
        "ပန်ဂျီ":"pa",
        "ପଞ୍ଜାବୀ |":"pa",
        "پنجابي":"pa",
        "پنجابی":"pa",
        "pendżabski":"pa",
        "ਪੰਜਾਬੀ":"pa",
        "панджаби":"pa",
        "punitapi":"pa",
        "пуњаби":"pa",
        "sepanish":"pa",
        "පන්ජාබි":"pa",
        "papi":"pa",
        "పంజాబీ":"pa",
        "ปัญจาบ":"pa",
        "pencap":"pa",
        "пенджабі":"pa",
        "panjabi":"pa",
        "trừng phạt":"pa",
        "isiphunjabi":"pa",
        "isipanish":"pa",
        "romanian":"ro",
        "rumun":"ro",
        "ሮማንያን":"ro",
        "روماني":"ro",
        "rumın":"ro",
        "румынская":"ro",
        "rumunski":"ro",
        "румънски":"ro",
        "romanès":"ro",
        "wachisomania":"ro",
        "rumenu":"ro",
        "rumunština":"ro",
        "rumænsk":"ro",
        "roemeense":"ro",
        "rumano":"ro",
        "rumeenlane":"ro",
        "romanialainen":"ro",
        "roumaine":"ro",
        "roemeensk":"ro",
        "რუმინული":"ro",
        "rumänisch":"ro",
        "ρουμανικός":"ro",
        "રોમન":"ro",
        "romaniyanci":"ro",
        "lomānia":"ro",
        "רומנית":"ro",
        "रोमानियाई":"ro",
        "román":"ro",
        "rúmensk":"ro",
        "romania":"ro",
        "rumania":"ro",
        "rómhánach":"ro",
        "rumena":"ro",
        "ルーマニア語":"ro",
        "ರೊಮೇನಿಯನ್":"ro",
        "румын":"ro",
        "រ៉ូម៉ានី":"ro",
        "루마니아 사람":"ro",
        "romanyayî":"ro",
        "румынча":"ro",
        "ໂລມາເນຍ":"ro",
        "rumāņu":"ro",
        "rumunų":"ro",
        "rumänesch":"ro",
        "романски":"ro",
        "romainina":"ro",
        "റൊമാനിയൻ":"ro",
        "rumeni":"ro",
        "रोमानियन":"ro",
        "румын хэл":"ro",
        "ရိုမေးနီးယား":"ro",
        "रोमान्टिक":"ro",
        "rumensk":"ro",
        "ରୋମାନିଆନ୍":"ro",
        "رومانیایی":"ro",
        "rumuński":"ro",
        "romena":"ro",
        "ਰੋਚਿੰਗ":"ro",
        "română":"ro",
        "румынский":"ro",
        "lomani":"ro",
        "romànianach":"ro",
        "румунски":"ro",
        "chiromanian":"ro",
        "رومانوي":"ro",
        "රොමේනියානු":"ro",
        "rumunský":"ro",
        "romunski":"ro",
        "rumana":"ro",
        "rumänska":"ro",
        "романӣ":"ro",
        "ரோமானியன்":"ro",
        "โรมาเนีย":"ro",
        "romen":"ro",
        "румунська":"ro",
        "چھٹی":"ro",
        "ruminiyalik":"ro",
        "rumani":"ro",
        "rhufeinig":"ro",
        "רומעניש":"ro",
        "ara ilu róòmù":"ro",
        "russiese":"ru",
        "rusisht":"ru",
        "ራሺያኛ":"ru",
        "الروسية":"ru",
        "rus":"ru",
        "russian":"ru",
        "руская":"ru",
        "রাশিয়ান":"ru",
        "ruski":"ru",
        "руски":"ru",
        "russu":"ru",
        "ruština":"ru",
        "russisk":"ru",
        "russisch":"ru",
        "ruso":"ru",
        "vene keeles":"ru",
        "venäjän kieli":"ru",
        "russe":"ru",
        "russysk":"ru",
        "რუსი":"ru",
        "ρωσική":"ru",
        "રશિયન":"ru",
        "ris":"ru",
        "rasha":"ru",
        "lukia":"ru",
        "רוּסִי":"ru",
        "रूसी":"ru",
        "lavxias teb sab":"ru",
        "orosz":"ru",
        "rússneskt":"ru",
        "ndị russia":"ru",
        "rusia":"ru",
        "rúisis":"ru",
        "russa":"ru",
        "ロシア":"ru",
        "ರಷ್ಯನ್":"ru",
        "орыс":"ru",
        "រូស្សី":"ru",
        "러시아인":"ru",
        "rûsî":"ru",
        "орусча":"ru",
        "ລັດເຊຍ":"ru",
        "krievu":"ru",
        "rusų":"ru",
        "russesch":"ru",
        "rosiana":"ru",
        "റഷ്യൻ":"ru",
        "रशियन":"ru",
        "орос":"ru",
        "ရုရှား":"ru",
        "रसियन":"ru",
        "russian ଷୀୟ":"ru",
        "روسي":"ru",
        "روسی":"ru",
        "rosyjski":"ru",
        "ਰਸ਼ੀਅਨ":"ru",
        "rusă":"ru",
        "русский":"ru",
        "lusia":"ru",
        "ruiseanach":"ru",
        "serussia":"ru",
        "chirussian":"ru",
        "රුසියානු":"ru",
        "ruský":"ru",
        "rusa":"ru",
        "kirusi":"ru",
        "ryska":"ru",
        "русй":"ru",
        "ரஷ்ய":"ru",
        "రష్యన్":"ru",
        "รัสเซีย":"ru",
        "rusça":"ru",
        "російський":"ru",
        "ruscha":"ru",
        "tiếng nga":"ru",
        "isirashiya":"ru",
        "רוסיש":"ru",
        "ara ilu russia":"ru",
        "samoa":"sm",
        "samoan":"sm",
        "ናታን":"sm",
        "ساموا":"sm",
        "samoako":"sm",
        "самоан":"sm",
        "সামোয়ান":"sm",
        "самоански":"sm",
        "samoà":"sm",
        "wokongola":"sm",
        "samoaans":"sm",
        "samoano":"sm",
        "სამოა":"sm",
        "samoaner":"sm",
        "σαμοάν":"sm",
        "સમોન":"sm",
        "סמואן":"sm",
        "सामोन":"sm",
        "サモア語":"sm",
        "ಸಮೋವನ್":"sm",
        "사모아":"sm",
        "saman":"sm",
        "самоа":"sm",
        "samoanis":"sm",
        "samoans":"sm",
        "samoanas":"sm",
        "самоана":"sm",
        "samoanina":"sm",
        "സമോവൻ":"sm",
        "ရှမ်း":"sm",
        "samoansk":"sm",
        "ସାମୋଆନ୍ |":"sm",
        "سماوان":"sm",
        "ساموون":"sm",
        "samoana":"sm",
        "самоанский":"sm",
        "سامانو":"sm",
        "සමෝවාන්":"sm",
        "samojština":"sm",
        "సమోవన్":"sm",
        "ซามัว":"sm",
        "samoalı":"sm",
        "سامون":"sm",
        "usaman":"sm",
        "isisamoa":"sm",
        "skotse gaelies":"gd",
        "copëza gaelike":"gd",
        "ስታትስቲክስ ጋለሊክ":"gd",
        "الغيلية الأسكتلندية":"gd",
        "skots gaelic":"gd",
        "scots gaelic":"gd",
        "шатландскі гэльскі":"gd",
        "স্কট গ্যালিক":"gd",
        "scots galski":"gd",
        "шотландски галски":"gd",
        "škotski galski":"gd",
        "skotský gaelský":"gd",
        "skotsk gælisk":"gd",
        "schots gaëlisch":"gd",
        "skotoj gaelic":"gd",
        "šoti gaeli":"gd",
        "skotti gaelinen":"gd",
        "gaélique écossais":"gd",
        "skotsk gaelic":"gd",
        "schottisch gälisch":"gd",
        "σκωτσέζικος γαελικός":"gd",
        "સ્કોટ્સ ગેલેક":"gd",
        "pye kalòt":"gd",
        "גאלית סקוטית":"gd",
        "स्कॉट्स गेलिक":"gd",
        "nkaub gaelic":"gd",
        "skót gael":"gd",
        "skoska gaelísk":"gd",
        "skotlandia gaelik":"gd",
        "gaelico scozzese":"gd",
        "スコットランドゲール語":"gd",
        "gatel gaelic":"gd",
        "ಸ್ಕಾಟ್ಸ್ ಗೇಲಿಕ್":"gd",
        "скотчтар":"gd",
        "sca gaelic":"gd",
        "스코틀랜드 게일":"gd",
        "scots гаэлик":"gd",
        "caledonica":"gd",
        "skotu gēlu":"gd",
        "škotų gaelika":"gd",
        "scots gaelesch":"gd",
        "скокови гаил":"gd",
        "സ്കോട്ട്സ് ഗാലിക്":"gd",
        "скотчууд":"gd",
        "स्कट्स गालील":"gd",
        "ସ୍କଟସ୍ ଗେଲିକ୍ |":"gd",
        "اسکاټ ګیلیک":"gd",
        "اسکات gaelic":"gd",
        "szkocki gaelicki":"gd",
        "gaélico escocês":"gd",
        "ਸਕਾਟਸ ਗੈਲਿਕ":"gd",
        "шотландский гэльский":"gd",
        "sikola gaeloa":"gd",
        "сцотс галски":"gd",
        "اسڪاٽس گئليڪڪ":"gd",
        "ස්කොට්ස් ගේලික්":"gd",
        "škótsky gaelský":"gd",
        "gaélico escocés":"gd",
        "karéta gaelic":"gd",
        "ஸ்காட்ஸ் கேலிக்":"gd",
        "స్కాట్స్ గేలిక్":"gd",
        "สก็อตเกลิค":"gd",
        "i̇skoç gaelic":"gd",
        "шотландський гель":"gd",
        "اسکاٹس گیلیک":"gd",
        "skots gaelik":"gd",
        "gaelic scots":"gd",
        "serbian":"sr",
        "serb":"sr",
        "ሰሪቢያን":"sr",
        "الصربية":"sr",
        "сербскі":"sr",
        "srpski":"sr",
        "сръбски":"sr",
        "serbi":"sr",
        "mserikali":"sr",
        "serbianu":"sr",
        "srbština":"sr",
        "serbisk":"sr",
        "servisch":"sr",
        "serba":"sr",
        "serbia keeles":"sr",
        "serbialainen":"sr",
        "serbe":"sr",
        "servysk":"sr",
        "სერბული":"sr",
        "serbisch":"sr",
        "σέρβος":"sr",
        "દુકાન":"sr",
        "sèb":"sr",
        "ōlelo serbia":"sr",
        "סרבית":"sr",
        "szerb":"sr",
        "serbneska":"sr",
        "ndị serbian":"sr",
        "orang serbia":"sr",
        "seirbis":"sr",
        "セルビア語":"sr",
        "ಸರ್ಬಿಯನ್":"sr",
        "серб":"sr",
        "សេរ៉ូម":"sr",
        "세르비아 사람":"sr",
        "sirbî":"sr",
        "сербче":"sr",
        "servica":"sr",
        "serbu":"sr",
        "serbų":"sr",
        "serbesch":"sr",
        "српски":"sr",
        "serbianina":"sr",
        "സെർബിയൻ":"sr",
        "serw":"sr",
        "दुकान":"sr",
        "ဆားဗီးယား":"sr",
        "पसल":"sr",
        "ସର୍ବିଆନ୍ |":"sr",
        "صربي":"sr",
        "صربی":"sr",
        "serbski":"sr",
        "sérvia":"sr",
        "ਦੁਕਾਨ":"sr",
        "sârb":"sr",
        "сербский":"sr",
        "serbianach":"sr",
        "seserbia":"sr",
        "chisebhiya":"sr",
        "سربيائي":"sr",
        "සර්බියානු":"sr",
        "srbský":"sr",
        "srbščina":"sr",
        "serbia":"sr",
        "seria":"sr",
        "சேர்பியன்":"sr",
        "సెర్బియన్":"sr",
        "เซอร์เบีย":"sr",
        "sırpça":"sr",
        "сербський":"sr",
        "دکان":"sr",
        "serbiya":"sr",
        "thành phố":"sr",
        "serbeg":"sr",
        "isisebhiya":"sr",
        "סערביש":"sr",
        "ara serbia":"sr",
        "i-serbian":"sr",
        "sotho":"st",
        "sesotho":"st",
        "سيسوتو":"st",
        "sesoto":"st",
        "сясота":"st",
        "সেসোথো":"st",
        "сесото":"st",
        "სესოტო":"st",
        "σεσότο":"st",
        "ששוטו":"st",
        "सेसोथो":"st",
        "セソト":"st",
        "ಸೆಸೊಥೊ":"st",
        "소토":"st",
        "സെസോതോ":"st",
        "နှမ်း":"st",
        "ସେସୋଥୋ |":"st",
        "سیسوتو":"st",
        "سسوتو":"st",
        "ਸੇਸੋਥੋ":"st",
        "сесотхо":"st",
        "سٿسو":"st",
        "సెసోతో":"st",
        "vừng":"st",
        "isesotho":"st",
        "shona":"sn",
        "ሻና":"sn",
        "الشونا":"sn",
        "şona":"sn",
        "шона":"sn",
        "শোনা":"sn",
        "ŝona":"sn",
        "შონა":"sn",
        "σόνα":"sn",
        "શોના":"sn",
        "שונה":"sn",
        "शोना":"sn",
        "ショナ":"sn",
        "ಶೋನಾ":"sn",
        "쇼나":"sn",
        "сранан-тонго":"sn",
        "šona":"sn",
        "ഷോന":"sn",
        "ଶୋନା |":"sn",
        "شونا":"sn",
        "ਸ਼ੋਨਾ":"sn",
        "схона":"sn",
        "ෂෝනා":"sn",
        "ஷோனா":"sn",
        "โชนา":"sn",
        "sindhi":"sd",
        "ስንድሂ":"sd",
        "السندية":"sd",
        "сіндзі":"sd",
        "সিন্ধি":"sd",
        "синдхи":"sd",
        "sindysk":"sd",
        "სინდური":"sd",
        "σίντι":"sd",
        "સિંધી":"sd",
        "kiniki":"sd",
        "סינדי":"sd",
        "सिंधी":"sd",
        "szindhi":"sd",
        "シンド語":"sd",
        "ಸಿಂಧಿ":"sd",
        "синди":"sd",
        "ស៊ីនឌី":"sd",
        "신디":"sd",
        "sindî":"sd",
        "синдиче":"sd",
        "sindhiana":"sd",
        "സിന്ധി":"sd",
        "စင်ဒီ":"sd",
        "सिन्धी":"sd",
        "ସିନ୍ଧି |":"sd",
        "سندي":"sd",
        "سندی":"sd",
        "sindi":"sd",
        "ਸਿੰਧੀ":"sd",
        "sindeach":"sd",
        "chisindhi":"sd",
        "සින්දි":"sd",
        "sindhčina":"sd",
        "சிந்தி":"sd",
        "సింధీ":"sd",
        "สินธุ":"sd",
        "синді":"sd",
        "سندھی":"sd",
        "سىندى":"sd",
        "sinhala":"si",
        "ሲንሃላ":"si",
        "السنهالية":"si",
        "сінгала":"si",
        "সিংহলী":"si",
        "синхалска":"si",
        "cinghalais":"si",
        "სინჰალა":"si",
        "singhalesisch":"si",
        "σινάλα":"si",
        "સિહલા":"si",
        "סינהלה":"si",
        "सिंहली":"si",
        "singalese":"si",
        "シンハラ語":"si",
        "ಸಿಂಹಳ":"si",
        "синхала":"si",
        "신 할라 어":"si",
        "сихала":"si",
        "സിംഹള":"si",
        "ဆင်ဟွာ":"si",
        "singalesiske":"si",
        "ସିହ୍ନା":"si",
        "سینهاله":"si",
        "سیناله":"si",
        "cingalês":"si",
        "سنهالا":"si",
        "සිංහල":"si",
        "sinhálčina":"si",
        "cingalés":"si",
        "சிங்கள":"si",
        "సింహళం":"si",
        "สิงหล":"si",
        "сингала":"si",
        "slovak":"sk",
        "sllovak":"sk",
        "ስሎቫክ":"sk",
        "السلوفاكية":"sk",
        "славацкі":"sk",
        "slovački":"sk",
        "словашки":"sk",
        "eslovac":"sk",
        "sluvaccu":"sk",
        "slowaaks":"sk",
        "slovaka":"sk",
        "slovakian":"sk",
        "slovaque":"sk",
        "slowaaksk":"sk",
        "სლოვაკური":"sk",
        "slowakisch":"sk",
        "σλοβάκος":"sk",
        "કેટલોગ":"sk",
        "kolowakia":"sk",
        "סלובקית":"sk",
        "teb chaws mekas":"sk",
        "szlovák":"sk",
        "slóvakía":"sk",
        "orang slovakia":"sk",
        "slovacca":"sk",
        "スロバキア語":"sk",
        "ಸ್ಲೋವಾಕ್":"sk",
        "словак":"sk",
        "ស្លូវ៉ាគី":"sk",
        "슬로바키아 사람":"sk",
        "slovakî":"sk",
        "словакча":"sk",
        "ສະໂລວາກີ":"sk",
        "moravica":"sk",
        "slovāks":"sk",
        "slovakas":"sk",
        "slowakesch":"sk",
        "словачки":"sk",
        "silaovaka":"sk",
        "സ്ലോവാക്":"sk",
        "slovakk":"sk",
        "झटपट":"sk",
        "ဆလိုဗက်ကီးယား":"sk",
        "प्यालास":"sk",
        "ସ୍ଲୋଭାକ୍":"sk",
        "سلواکي":"sk",
        "اسلواکی":"sk",
        "słowacki":"sk",
        "eslovaca":"sk",
        "ਕੈਟਲੋਜ਼":"sk",
        "slovacă":"sk",
        "словацкий":"sk",
        "slovacanach":"sk",
        "chislovak":"sk",
        "سلوويڪي":"sk",
        "slovenský":"sk",
        "slovaški":"sk",
        "ஸ்லோவாக்":"sk",
        "สโลวาเกีย":"sk",
        "словацький":"sk",
        "ذخیرے":"sk",
        "slovakia":"sk",
        "סלאָוואַקיש":"sk",
        "isiqubulo":"sk",
        "slovenian":"sl",
        "slloven":"sl",
        "ስሎቬንያን":"sl",
        "السلوفانية":"sl",
        "sloven":"sl",
        "славен":"sl",
        "slovenački":"sl",
        "словенски":"sl",
        "drac":"sl",
        "chilozi":"sl",
        "sluvenu":"sl",
        "slovenac":"sl",
        "sloveens":"sl",
        "tial":"sl",
        "sloveenlane":"sl",
        "slovène":"sl",
        "sloveensk":"sl",
        "ნიდერლანდური":"sl",
        "slowenisch":"sl",
        "σλοβενικά":"sl",
        "સંદેશ":"sl",
        "yar kasar slovenian":"sl",
        "kolewenia":"sl",
        "סלובנית":"sl",
        "szlovén":"sl",
        "slóvenía":"sl",
        "onye nke slovenian":"sl",
        "jorok":"sl",
        "slovena":"sl",
        "スロベニア語":"sl",
        "ಸ್ಲೊವೇನಿಯನ್":"sl",
        "словен":"sl",
        "슬로베니아":"sl",
        "slovenî":"sl",
        "словенияча":"sl",
        "carnica":"sl",
        "slovēņu":"sl",
        "slovėnų":"sl",
        "slowenesch":"sl",
        "словенечки":"sl",
        "slovenianina":"sl",
        "സ്ലൊവേനിയൻ":"sl",
        "għalhekk":"sl",
        "संदेश":"sl",
        "словени хэл":"sl",
        "ထောက်ပံ့":"sl",
        "ब्राउज":"sl",
        "ସ୍ଲୋଭେନିଆନ୍":"sl",
        "سلوانیایی":"sl",
        "اسلوونی":"sl",
        "słoweński":"sl",
        "eslovena":"sl",
        "ਸੰਗੀਤ":"sl",
        "словенский":"sl",
        "slobhenianach":"sl",
        "словеначки":"sl",
        "seromania":"sl",
        "chislovanian":"sl",
        "سلوويني":"sl",
        "slovinčina":"sl",
        "slovenščina":"sl",
        "kislovenia":"sl",
        "словенӣ":"sl",
        "ஸ்லோவேனியன்":"sl",
        "ภาษาสโลเวเนีย":"sl",
        "словенська":"sl",
        "بانٹیں":"sl",
        "سىلوۋېنىيە":"sl",
        "slovencha":"sl",
        "סלאוועניש":"sl",
        "alade":"sl",
        "isilozi":"sl",
        "somaliese":"so",
        "somali":"so",
        "ሶማሌ":"so",
        "الصومالية":"so",
        "somaliako":"so",
        "самалійскія":"so",
        "সোমালী":"so",
        "somalijski":"so",
        "сомалийски":"so",
        "somalianu":"so",
        "somalisch":"so",
        "somalysk":"so",
        "სომალი":"so",
        "σομαλοί":"so",
        "સોમાલી":"so",
        "dan somaliya":"so",
        "ōlelo somalia":"so",
        "סומאלי":"so",
        "सोमाली":"so",
        "szomáli":"so",
        "sómalíu":"so",
        "onye igbo":"so",
        "somala":"so",
        "ソマリ語":"so",
        "ಸೊಮಾಲಿ":"so",
        "сомали":"so",
        "소말리아":"so",
        "somalîkî":"so",
        "сомаличе":"so",
        "somalis":"so",
        "somalesch":"so",
        "സോമാലി":"so",
        "ဆိုမာလီ":"so",
        "ସୋମାଲି":"so",
        "سومالیایی":"so",
        "سومالی":"so",
        "ਸੋਮਾਲੀ":"so",
        "сомалийский":"so",
        "somari":"so",
        "صومالي":"so",
        "සෝමාලි":"so",
        "somálsky":"so",
        "somalí":"so",
        "сомалӣ":"so",
        "சோமாலி":"so",
        "సోమాలి":"so",
        "โซมาลี":"so",
        "сомалі":"so",
        "صومالی":"so",
        "tiếng somalia":"so",
        "somalïaidd":"so",
        "isisomali":"so",
        "spaans":"es",
        "spanjisht":"es",
        "ስፓንኛ":"es",
        "الأسبانية":"es",
        "ispan":"es",
        "gaztelania":"es",
        "іспанскі":"es",
        "স্পেনীয়":"es",
        "španski":"es",
        "испански":"es",
        "espanyol":"es",
        "spanish":"es",
        "spagnolu":"es",
        "španjolski":"es",
        "hispana":"es",
        "hispaania keeles":"es",
        "espanja":"es",
        "espagnol":"es",
        "spaansk":"es",
        "ესპანური":"es",
        "spanisch":"es",
        "ισπανικά":"es",
        "સ્પૅનિશ":"es",
        "panyòl":"es",
        "kepania":"es",
        "ספרדית":"es",
        "स्पेनिश":"es",
        "spanyol":"es",
        "spænska, spænskt":"es",
        "orang spanyol":"es",
        "spainnis":"es",
        "spagnola":"es",
        "スペイン語":"es",
        "ಸ್ಪ್ಯಾನಿಷ್":"es",
        "испан":"es",
        "ភាសាអេស្ប៉ាញ":"es",
        "스페인의":"es",
        "îspanyolî":"es",
        "испанча":"es",
        "ແອສປາໂຍນ":"es",
        "spāņu":"es",
        "ispanų":"es",
        "spuenesch":"es",
        "шпански":"es",
        "fikarohana":"es",
        "സ്പാനിഷ്":"es",
        "spanjol":"es",
        "स्पॅनिश":"es",
        "испани":"es",
        "စပိန်ဘာသာ":"es",
        "spansk":"es",
        "ସ୍ପାନିସ୍":"es",
        "هسپانیه ایی":"es",
        "اسپانیایی":"es",
        "hiszpański":"es",
        "espanhola":"es",
        "ਸਪੈਨਿਸ਼":"es",
        "spaniolă":"es",
        "испанский":"es",
        "sipaniolo":"es",
        "spàinneach":"es",
        "sepanishe":"es",
        "chispanish":"es",
        "اندلسي":"es",
        "ස්පාඤ්ඤ":"es",
        "španielsky":"es",
        "española":"es",
        "kihispania":"es",
        "spanska":"es",
        "испанӣ":"es",
        "ஸ்பானிஷ்":"es",
        "สเปน":"es",
        "i̇spanyol":"es",
        "іспанська":"es",
        "ہسپانوی":"es",
        "ئىسپانىيە":"es",
        "người tây ban nha":"es",
        "sbaen":"es",
        "שפּאַניש":"es",
        "sipaki":"es",
        "soendanees":"su",
        "sundanezisht":"su",
        "ሳንዲሽኛ":"su",
        "السندانية":"su",
        "sundanese":"su",
        "sundanera":"su",
        "суданскі":"su",
        "সুদানী":"su",
        "sundanski":"su",
        "сундански":"su",
        "sundanès":"su",
        "sundan":"su",
        "ma sundanese":"su",
        "sundanees":"su",
        "sunda":"su",
        "sundanais":"su",
        "სუნდური":"su",
        "sundanesisch":"su",
        "σουντάνικα":"su",
        "સુન્ડાનિઝ":"su",
        "luanaka":"su",
        "סנדנית":"su",
        "सुंडानी":"su",
        "sudanese":"su",
        "スンダ語":"su",
        "순 다어":"su",
        "сунданча":"su",
        "sundanica":"su",
        "saulėlydis":"su",
        "сундан":"su",
        "सुंडनीज":"su",
        "нардан":"su",
        "ဆူဒန်":"su",
        "सून्डानीज":"su",
        "ସୁନ୍ଦରୀ":"su",
        "سوډاني":"su",
        "ساندانی":"su",
        "sundańczyk":"su",
        "ਸਨਡੇਨੀਜ਼":"su",
        "sundaneză":"su",
        "суданский":"su",
        "satani":"su",
        "сунданесе":"su",
        "سنڊينيز":"su",
        "sundčina":"su",
        "sundanés":"su",
        "sundanesiska":"su",
        "சண்டானீஸ்":"su",
        "ซุนดา":"su",
        "сунданський":"su",
        "سنڈنیز":"su",
        "isundanese":"su",
        "ede sundanese":"su",
        "swahili":"sw",
        "ስዋሕሊ":"sw",
        "السواحيلية":"sw",
        "suahili":"sw",
        "злучыць":"sw",
        "সোয়াহিলি":"sw",
        "smeše":"sw",
        "суахили":"sw",
        "chiswahili":"sw",
        "svahila":"sw",
        "suahiili keel":"sw",
        "swahily":"sw",
        "სუაჰილი":"sw",
        "σουαχίλι":"sw",
        "દૈવી":"sw",
        "kawahili":"sw",
        "סוואלי":"sw",
        "sw sw":"sw",
        "szuahéli":"sw",
        "svahaílis":"sw",
        "スワヒリ語":"sw",
        "ಸ್ವಹಿಲಿ":"sw",
        "ស្វាហ៊ីលី":"sw",
        "스와힐리어":"sw",
        "swahîlîyî":"sw",
        "свахиличе":"sw",
        "sw swing":"sw",
        "svahili":"sw",
        "свахили":"sw",
        "സ്വാഹിലി":"sw",
        "कृती":"sw",
        "швахили хэл":"sw",
        "ဆွာဟီလီ":"sw",
        "मेसिन":"sw",
        "سواحلي":"sw",
        "سواحیلی":"sw",
        "suaíli":"sw",
        "ਪਕਵਾਨ":"sw",
        "swahilieach":"sw",
        "seswahili":"sw",
        "سواهلي":"sw",
        "ස්වහීලී":"sw",
        "mešanica":"sw",
        "kiswahili":"sw",
        "своҳили":"sw",
        "சுவாஹிலி":"sw",
        "ภาษาสวาฮิลี":"sw",
        "суміш":"sw",
        "مرکب":"sw",
        "suaxili":"sw",
        "đổ":"sw",
        "סאליש":"sw",
        "isi-swahili":"sw",
        "sweeds":"sv",
        "suedez":"sv",
        "ስዊድንኛ":"sv",
        "السويدية":"sv",
        "şved":"sv",
        "swedish":"sv",
        "шведская":"sv",
        "সুইডিশ":"sv",
        "švedski":"sv",
        "шведски":"sv",
        "suec":"sv",
        "nag-swedish":"sv",
        "chilengedwe":"sv",
        "svedese":"sv",
        "zweeds":"sv",
        "sveda":"sv",
        "rootsi":"sv",
        "ruotsin kieli":"sv",
        "suédoise":"sv",
        "sweedsk":"sv",
        "შვედური":"sv",
        "schwedisch":"sv",
        "σουηδικά":"sv",
        "સ્વીડિશ":"sv",
        "suedwa":"sv",
        "kuekene":"sv",
        "שוודית":"sv",
        "स्वीडिश":"sv",
        "svéd":"sv",
        "sænsku":"sv",
        "orang swedia":"sv",
        "スウェーデンの":"sv",
        "ಸ್ವಿಚ್":"sv",
        "швед":"sv",
        "스웨덴어":"sv",
        "swêdî":"sv",
        "шведче":"sv",
        "zviedri":"sv",
        "švedų":"sv",
        "schweedesch":"sv",
        "സ്വീഡിഷ്":"sv",
        "svediż":"sv",
        "шуугиантай":"sv",
        "ဆွီဒင်":"sv",
        "svensk":"sv",
        "ସ୍ୱିଡିଶ୍ |":"sv",
        "سوئدی":"sv",
        "szwedzki":"sv",
        "sueca":"sv",
        "ਸਿਡਿਸੀ":"sv",
        "шведский":"sv",
        "suaineach":"sv",
        "leholimo":"sv",
        "chiswedish":"sv",
        "سويڊني":"sv",
        "පැද්දීම":"sv",
        "švédsky":"sv",
        "ulimwengu":"sv",
        "svenska":"sv",
        "ஸ்விட்ச்":"sv",
        "สวีเดน":"sv",
        "i̇sveççe":"sv",
        "шведська":"sv",
        "سویڈش":"sv",
        "shved":"sv",
        "thụy điển":"sv",
        "שוועדיש":"sv",
        "izulu":"sv",
        "tajik":"tg",
        "taxhik":"tg",
        "ታጂክ":"tg",
        "طاجيك":"tg",
        "tacik":"tg",
        "таджыкскі":"tg",
        "তাজিক":"tg",
        "таджикски":"tg",
        "tadžički":"tg",
        "tadžik":"tg",
        "tadzhikistanin":"tg",
        "tadjik":"tg",
        "ტაჯიკი":"tg",
        "tadschikisch":"tg",
        "τατζίκ":"tg",
        "તાજિક":"tg",
        "טג'יק":"tg",
        "ताजिक":"tg",
        "tádzsik":"tg",
        "タジク語":"tg",
        "ತಾಜಿಕ್":"tg",
        "тәжік":"tg",
        "타직":"tg",
        "памирлик кыргыздар":"tg",
        "tadžiks":"tg",
        "tadžikų":"tg",
        "тајкик":"tg",
        "താജിക്":"tg",
        "तजिक":"tg",
        "тажик":"tg",
        "ତାଜିକ୍":"tg",
        "تاجيک":"tg",
        "تاجیک":"tg",
        "tadżycki":"tg",
        "tajique":"tg",
        "ਤਾਜਿਕ":"tg",
        "tadjică":"tg",
        "таджикский":"tg",
        "тајик":"tg",
        "tadžické":"tg",
        "tayika":"tg",
        "tadzjikiska":"tg",
        "точики":"tg",
        "தாஜிக்":"tg",
        "తజిక్":"tg",
        "ทาจิกิสถาน":"tg",
        "таджик":"tg",
        "تاجک":"tg",
        "تاجىك":"tg",
        "tojik":"tg",
        "tamil":"ta",
        "ታሚል":"ta",
        "التاميل":"ta",
        "таміл":"ta",
        "তামিল":"ta",
        "тамилски":"ta",
        "tamyl":"ta",
        "ტამილი":"ta",
        "ταμίλ":"ta",
        "તામિલ":"ta",
        "kamili":"ta",
        "טמיל":"ta",
        "タミル語":"ta",
        "ತಮಿಳು":"ta",
        "тамил":"ta",
        "타밀 사람":"ta",
        "tamîlî":"ta",
        "тамилче":"ta",
        "tamils":"ta",
        "tamilis":"ta",
        "തമിഴ്":"ta",
        "तमिळ":"ta",
        "တမာ":"ta",
        "तामिल":"ta",
        "تامیل":"ta",
        "tâmil":"ta",
        "ਤਾਮਿਲ":"ta",
        "тамильский":"ta",
        "tamileach":"ta",
        "chitamil":"ta",
        "تاملي":"ta",
        "දෙමළ":"ta",
        "தமிழ்":"ta",
        "తమిళ":"ta",
        "มิลักขะ":"ta",
        "تمل":"ta",
        "telugu":"te",
        "ተሉጉ":"te",
        "التيلجو":"te",
        "тэлугу":"te",
        "তেলুগু":"te",
        "телугу":"te",
        "telugua":"te",
        "ტელუგუ":"te",
        "τελούγκου":"te",
        "તેલુગુ":"te",
        "keluku":"te",
        "טלוגו":"te",
        "तेलुगू":"te",
        "ತೆಲುಗು":"te",
        "តេលូហ្គូ":"te",
        "텔루구 어":"te",
        "teluguyî":"te",
        "телугуча":"te",
        "телегу":"te",
        "തെലുങ്ക്":"te",
        "तेलगु":"te",
        "တယ်လီဂူ":"te",
        "तेलुगु":"te",
        "ତେଲୁଗୁ":"te",
        "تولیګو":"te",
        "تلوگو":"te",
        "ਤੇਲਗੂ":"te",
        "telugach":"te",
        "chitelugu":"te",
        "تيلوگو ٻولي":"te",
        "තෙළිඟු":"te",
        "தெலுங்கு":"te",
        "తెలుగు":"te",
        "กู":"te",
        "تلگو":"te",
        "thai":"th",
        "ታይ":"th",
        "التايلاندية":"th",
        "tay":"th",
        "тайская":"th",
        "থাই":"th",
        "tajlandski":"th",
        "тайландски":"th",
        "tailandès":"th",
        "thais":"th",
        "taja":"th",
        "tai":"th",
        "thaïlandais":"th",
        "taisk":"th",
        "ტაილანდური":"th",
        "thailändisch":"th",
        "ταϊλανδικά":"th",
        "થાઇ":"th",
        "kailani":"th",
        "תאילנדי":"th",
        "थाई":"th",
        "thaib":"th",
        "taílensku":"th",
        "タイ語":"th",
        "ಥಾಯ್":"th",
        "тай":"th",
        "ថៃ":"th",
        "타이":"th",
        "thayîkî":"th",
        "тайча":"th",
        "ໄທ":"th",
        "taizemietis":"th",
        "тајландски":"th",
        "തായ്":"th",
        "tajlandiż":"th",
        "ထိုင်း":"th",
        "ଥାଇ":"th",
        "تای":"th",
        "تایلندی":"th",
        "tajski":"th",
        "tailandesa":"th",
        "ਥਾਈ":"th",
        "tailandez":"th",
        "тайский":"th",
        "faʻa thai":"th",
        "thaidheach":"th",
        "chithai":"th",
        "ٿائي ٻولي":"th",
        "තායි":"th",
        "tajska":"th",
        "tongo":"th",
        "тй":"th",
        "தாய்":"th",
        "ไทย":"th",
        "tayland":"th",
        "тайський":"th",
        "تھائی":"th",
        "تاي":"th",
        "thái lan":"th",
        "turkish":"tr",
        "ቱሪክሽ":"tr",
        "اللغة التركية":"tr",
        "türk":"tr",
        "турэцкі":"tr",
        "তুর্কী":"tr",
        "turski":"tr",
        "турски":"tr",
        "turc":"tr",
        "chitonki":"tr",
        "turcu":"tr",
        "turks":"tr",
        "turka":"tr",
        "türgi":"tr",
        "turque":"tr",
        "turksk":"tr",
        "თურქული":"tr",
        "türkisch":"tr",
        "τούρκικος":"tr",
        "તુર્કી":"tr",
        "tik":"tr",
        "טורקי":"tr",
        "तुर्की":"tr",
        "török":"tr",
        "tyrkneska":"tr",
        "turki":"tr",
        "tuircis":"tr",
        "トルコ語":"tr",
        "turis":"tr",
        "ಟರ್ಕಿಶ್":"tr",
        "түрік":"tr",
        "ទួរគី":"tr",
        "터키어":"tr",
        "tirkî":"tr",
        "түркчө":"tr",
        "turcorum":"tr",
        "turku":"tr",
        "turkų":"tr",
        "tierkesch":"tr",
        "tiorka":"tr",
        "ടർക്കിഷ്":"tr",
        "torok":"tr",
        "турк":"tr",
        "တူရကီ":"tr",
        "टर्की":"tr",
        "tyrkisk":"tr",
        "ତୁର୍କୀ":"tr",
        "ترکي":"tr",
        "ترکی":"tr",
        "turecki":"tr",
        "turca":"tr",
        "ਤੁਰਕੀ":"tr",
        "турецкий":"tr",
        "turisi":"tr",
        "turcach":"tr",
        "seterekere":"tr",
        "ترڪي":"tr",
        "තුර්කි":"tr",
        "turecký":"tr",
        "turško":"tr",
        "kituruki":"tr",
        "turkiska":"tr",
        "туркӣ":"tr",
        "துருக்கிய":"tr",
        "ตุรกี":"tr",
        "турецька":"tr",
        "turkcha":"tr",
        "thổ nhĩ kỳ":"tr",
        "twrceg":"tr",
        "i-turkish":"tr",
        "טערקיש":"tr",
        "tọki":"tr",
        "ukrainian":"uk",
        "ukrainas":"uk",
        "ዩክሬንያን":"uk",
        "الأوكرانية":"uk",
        "ukraynalı":"uk",
        "ўкраінскі":"uk",
        "ukrajinski":"uk",
        "украински":"uk",
        "ucraïnès":"uk",
        "ukaragwayon":"uk",
        "kukhulupirira":"uk",
        "ucraina":"uk",
        "oekraïens":"uk",
        "ukraina":"uk",
        "ukraina keel":"uk",
        "ukrainien":"uk",
        "oekraynsk":"uk",
        "უკრაინული":"uk",
        "ukrainisch":"uk",
        "ουκρανός":"uk",
        "તપાસ":"uk",
        "ukraine":"uk",
        "ukakaki":"uk",
        "אוקראינית":"uk",
        "यूक्रेनी":"uk",
        "suav teb":"uk",
        "ukrán":"uk",
        "úkraínskt":"uk",
        "orang ukraina":"uk",
        "ウクライナ語":"uk",
        "ಉಕ್ರೇನಿಯನ್":"uk",
        "украин":"uk",
        "អ៊ុយក្រែន":"uk",
        "우크라이나 인":"uk",
        "ûkraynî":"uk",
        "украинче":"uk",
        "ອູແກຣນ":"uk",
        "ukraiņu":"uk",
        "ukrainiečių":"uk",
        "ukrainesch":"uk",
        "okrainiana":"uk",
        "ഉക്രേനിയൻ":"uk",
        "ukrajni":"uk",
        "तपासणी":"uk",
        "украйн":"uk",
        "ယူကရိန်း":"uk",
        "अनुसन्धान":"uk",
        "ukrainsk":"uk",
        "اوکرایني":"uk",
        "اوکراینی":"uk",
        "ukraiński":"uk",
        "ucraniana":"uk",
        "ਜਾਂਚ":"uk",
        "ucrainean":"uk",
        "украинец":"uk",
        "ukaraina":"uk",
        "украјински":"uk",
        "tumelo":"uk",
        "kutenda":"uk",
        "يوڪرينين":"uk",
        "යුක්රේන":"uk",
        "ukrajinský":"uk",
        "ukrajinsko":"uk",
        "ucrania":"uk",
        "imani":"uk",
        "ukrainska":"uk",
        "украинӣ":"uk",
        "உக்ரேனிய":"uk",
        "ఉక్రేనియన్":"uk",
        "ยูเครน":"uk",
        "ukrayna":"uk",
        "українська":"uk",
        "تحقیقات":"uk",
        "ukrainalik":"uk",
        "inkolelo":"uk",
        "אוקרייניש":"uk",
        "ti ukarain":"uk",
        "ukukholwa":"uk",
        "oerdoe":"ur",
        "urdu":"ur",
        "ኡርዱ":"ur",
        "الأردية":"ur",
        "урду":"ur",
        "উর্দু":"ur",
        "ourdou":"ur",
        "ურდუ":"ur",
        "אורדו":"ur",
        "उर्दू":"ur",
        "úrdú":"ur",
        "ウルドゥー語":"ur",
        "ಉರ್ದು":"ur",
        "우르두어":"ur",
        "ûrdûyî":"ur",
        "урдуча":"ur",
        "ഉർദു":"ur",
        "උර්දු":"ur",
        "ఉర్దూ":"ur",
        "ภาษาอูรดู":"ur",
        "urduca":"ur",
        "tiếng urdu":"ur",
        "uyghur":"ug",
        "ujgur":"ug",
        "ኡይግሁር":"ug",
        "الأويغور":"ug",
        "uyğur":"ug",
        "uigur":"ug",
        "уйгур":"ug",
        "উইগুর":"ug",
        "уйгурски":"ug",
        "ujgurski":"ug",
        "uragano":"ug",
        "uiguur":"ug",
        "ouïghour":"ug",
        "oejgoersk":"ug",
        "უიღურ":"ug",
        "uigurisch":"ug",
        "ōlelo uyghur":"ug",
        "אוג'ור":"ug",
        "उईघुर":"ug",
        "ウイグル":"ug",
        "ಉಯಿಘರ್":"ug",
        "ұйғыр":"ug",
        "អយហ្គឺរ":"ug",
        "위구르어":"ug",
        "uygurî":"ug",
        "уйгурча":"ug",
        "uiguru":"ug",
        "uigūras":"ug",
        "uiguresch":"ug",
        "ујгур":"ug",
        "युगुर":"ug",
        "ဟုတ်တယ်":"ug",
        "उइघुर":"ug",
        "uighur":"ug",
        "اویغور":"ug",
        "ਉਇਗੂਰ":"ug",
        "уйгурский":"ug",
        "uikaha":"ug",
        "уигхур":"ug",
        "ugwa":"ug",
        "يوغور":"ug",
        "උයිගර්":"ug",
        "ujgurov":"ug",
        "వైఘుర్":"ug",
        "อุยกูร์":"ug",
        "uygur":"ug",
        "یوغور":"ug",
        "uyg'ur":"ug",
        "isiuyghur":"ug",
        "oesbekies":"uz",
        "uzbek":"uz",
        "ኡዝቤክ":"uz",
        "узбек":"uz",
        "উজবেকীয়":"uz",
        "узбекски":"uz",
        "uzbečki":"uz",
        "oezbeeks":"uz",
        "uzbekaj":"uz",
        "usbeki":"uz",
        "ouzbek":"uz",
        "უზბეკური":"uz",
        "usbekisch":"uz",
        "ουζμπεκιστάν":"uz",
        "ઉઝબેક":"uz",
        "uzbekyen":"uz",
        "אוזבקית":"uz",
        "उज़बेक":"uz",
        "üzbég":"uz",
        "úsbek":"uz",
        "ウズベク語":"uz",
        "ಉಜ್ಬೆಕ್":"uz",
        "өзбек":"uz",
        "우즈벡":"uz",
        "ozbekî":"uz",
        "өзбекче":"uz",
        "ອູເບເບ":"uz",
        "uzbecorum":"uz",
        "uzbeku":"uz",
        "uzbekas":"uz",
        "usbekesch":"uz",
        "узбекистански":"uz",
        "उझबॅक":"uz",
        "မင်္ဂလာပါ":"uz",
        "उज्बेक":"uz",
        "usbekiske":"uz",
        "ازبکي":"uz",
        "ازبک":"uz",
        "uzbecki":"uz",
        "uzbeque":"uz",
        "ਉਜ਼ਬੇਕ":"uz",
        "uzbec":"uz",
        "ازبڪ":"uz",
        "uzbeka":"uz",
        "อุซเบก":"uz",
        "özbekçe":"uz",
        "vietnamese":"vi",
        "vietnamisht":"vi",
        "ቪትናሜሴ":"vi",
        "الفيتنامية":"vi",
        "vyetnam":"vi",
        "в'етнамская":"vi",
        "vijetnamski":"vi",
        "виетнамски":"vi",
        "vietnamita":"vi",
        "vietnamees":"vi",
        "vietnami keel":"vi",
        "vietnamienne":"vi",
        "fietnam":"vi",
        "ვიეტნამის":"vi",
        "vietnamesisch":"vi",
        "βιετναμέζικα":"vi",
        "વિયેટનામ":"vi",
        "vyetnamyen":"vi",
        "laia":"vi",
        "ויאטנמית":"vi",
        "वियतनामी":"vi",
        "nyab laj":"vi",
        "vietnami":"vi",
        "víetnamskt":"vi",
        "orang vietnam":"vi",
        "ベトナム語":"vi",
        "ವಿಯೆಟ್ನಾಮೀಸ್":"vi",
        "вьетнамдық":"vi",
        "ប្រទេសវៀតណាម":"vi",
        "베트남어":"vi",
        "vîetnamî":"vi",
        "вьетнамча":"vi",
        "ປະເທດຫວຽດນາມ":"vi",
        "vietnamica":"vi",
        "vjetnamiešu":"vi",
        "vietnamiečių":"vi",
        "vietnamesesch":"vi",
        "vietnamiana":"vi",
        "വിയറ്റ്നാമീസ്":"vi",
        "vjetnamiż":"vi",
        "व्हिएतनामी":"vi",
        "вьетнам хэлтэй":"vi",
        "ဗီယက်နမ်လူမျိုး":"vi",
        "भियतनामी":"vi",
        "vietnamesisk":"vi",
        "ଭିଏତନାମ":"vi",
        "ویتنامي":"vi",
        "ویتنامی":"vi",
        "wietnamski":"vi",
        "ਵੀਅਤਨਾਮੀ":"vi",
        "вьетнамский":"vi",
        "вијетнамски":"vi",
        "ويٽنامي":"vi",
        "vietnamský":"vi",
        "vietnamski":"vi",
        "ветй":"vi",
        "வியட்நாமிய":"vi",
        "เวียตนาม":"vi",
        "vietnam":"vi",
        "в’єтнамська":"vi",
        "vyetnamlik":"vi",
        "tiếng việt":"vi",
        "welsh":"cy",
        "ዋልሽ":"cy",
        "تهرب من دفع الرهان":"cy",
        "вал":"cy",
        "vel":"cy",
        "уелски":"cy",
        "significat":"cy",
        "win":"cy",
        "sinceru":"cy",
        "velški":"cy",
        "signifa":"cy",
        "kõmri":"cy",
        "gallois":"cy",
        "უელსური":"cy",
        "walisisch":"cy",
        "δεν πληρώνω τα οφειλόμενα":"cy",
        "વિચાર":"cy",
        "galeri":"cy",
        "וולשית":"cy",
        "walesi":"cy",
        "velska":"cy",
        "breatnais":"cy",
        "ウェールズ":"cy",
        "ಉತ್ತಮ":"cy",
        "велш":"cy",
        "វ៉ែល":"cy",
        "웨일스 말":"cy",
        "galerkî":"cy",
        "валлийче":"cy",
        "ແວວ":"cy",
        "cambrica":"cy",
        "velsietis":"cy",
        "valų":"cy",
        "велшки":"cy",
        "valesa":"cy",
        "നല്ല":"cy",
        "tifsira":"cy",
        "विरघळली":"cy",
        "гэлээ":"cy",
        "ဝီလီ":"cy",
        "घन":"cy",
        "walisisk":"cy",
        "ୱେଲ୍ସ |":"cy",
        "ولش":"cy",
        "ویلتی":"cy",
        "walijski":"cy",
        "galês":"cy",
        "ਘੋਲ":"cy",
        "velșă":"cy",
        "валлийский":"cy",
        "uelese":"cy",
        "cuimreach":"cy",
        "вел":"cy",
        "mofumahatsana":"cy",
        "ويلش":"cy",
        "වේල්ස්":"cy",
        "waleský":"cy",
        "galesa":"cy",
        "bwana":"cy",
        "เวลส์":"cy",
        "sözünü tutmamak":"cy",
        "غور":"cy",
        "yaxshi":"cy",
        "người xứ wales":"cy",
        "cymraeg":"cy",
        "umnumzana":"cy",
        "àwæn":"cy",
        "i-win":"cy",
        "xhosa":"xh",
        "xhose":"xh",
        "ዛይሆሳ":"xh",
        "خوسا":"xh",
        "জোসা":"xh",
        "ксоски":"xh",
        "ჟოზა":"xh",
        "ખોસા":"xh",
        "ōlelo xhosa":"xh",
        "षोसा":"xh",
        "コーサ語":"xh",
        "ហ្សូសា":"xh",
        "코사":"xh",
        "xhosayî":"xh",
        "хосача":"xh",
        "јоза":"xh",
        "झोसा":"xh",
        "ဇို":"xh",
        "ژوسا":"xh",
        "ژوزا":"xh",
        "кос":"xh",
        "siosa":"xh",
        "zhosa":"xh",
        "кхоса":"xh",
        "โซซา":"xh",
        "ژھوسا":"xh",
        "isixhosa":"xh",
        "jiddisj":"yi",
        "jidish":"yi",
        "ዪዲሽ":"yi",
        "اليديشية":"yi",
        "yəhudi":"yi",
        "yiddish":"yi",
        "ідыш":"yi",
        "jidiš":"yi",
        "идиш":"yi",
        "yidià":"yi",
        "yuscita":"yi",
        "jiddisch":"yi",
        "jida":"yi",
        "იდიში":"yi",
        "γερμανοεβραϊκή διάλεκτος":"yi",
        "યીદ્દીન":"yi",
        "ʻōleʻele":"yi",
        "אִידִישׁ":"yi",
        "yuag":"yi",
        "jiddis":"yi",
        "jiddíska":"yi",
        "yiddi":"yi",
        "giúdais":"yi",
        "イディッシュ語":"yi",
        "ಯಿಡ್ಡಿಷ್":"yi",
        "យូយូ":"yi",
        "이디시":"yi",
        "yîddîşî":"yi",
        "идишче":"yi",
        "y yiddish":"yi",
        "jidišs":"yi",
        "jiddesch":"yi",
        "јидски":"yi",
        "yizjdi":"yi",
        "येडी":"yi",
        "ကရီ":"yi",
        "यिद्दिस":"yi",
        "یدیش":"yi",
        "ییدیش":"yi",
        "jidysz":"yi",
        "iídiche":"yi",
        "ਯਿਦਿ":"yi",
        "idiş":"yi",
        "fiafia":"yi",
        "јидиш":"yi",
        "يِدش":"yi",
        "yídish":"yi",
        "ядиш":"yi",
        "இத்திஷ்":"yi",
        "ยิดดิช":"yi",
        "eskenazi dili":"yi",
        "ідиш":"yi",
        "یدید":"yi",
        "yahudiy":"yi",
        "yidi":"yi",
        "yoruba":"yo",
        "ዮሩባ":"yo",
        "اليوروبا":"yo",
        "ёруба":"yo",
        "ইওরুবা":"yo",
        "йоруба":"yo",
        "youba":"yo",
        "joruba":"yo",
        "იორუბა":"yo",
        "γιορούμπα":"yo",
        "યોરૂબા":"yo",
        "יורובה":"yo",
        "योरूबा":"yo",
        "jórúba":"yo",
        "ヨルバ":"yo",
        "ಯೊರುಬಾ":"yo",
        "요 루바":"yo",
        "yorûbayî":"yo",
        "йорубача":"yo",
        "јоруба":"yo",
        "യൊറുബ":"yo",
        "ଓଡ଼ିଆ":"yo",
        "یوروبا":"yo",
        "ioruba":"yo",
        "ਯੋਰੂਬਾ":"yo",
        "malo":"yo",
        "иоруба":"yo",
        "يوورابا":"yo",
        "යොරුබා":"yo",
        "jorubština":"yo",
        "யோருப்பா":"yo",
        "yenyuba":"yo",
        "yekauba":"yo",
        "zulu":"zu",
        "ዙሉ":"zu",
        "الزولو":"zu",
        "зулу":"zu",
        "জুলু":"zu",
        "zoulou":"zu",
        "ზულუ":"zu",
        "ζουλού":"zu",
        "ઝુલુ":"zu",
        "זולו":"zu",
        "ज़ुलु":"zu",
        "súlú":"zu",
        "ズールー":"zu",
        "ಜುಲು":"zu",
        "ហ្សូលូ":"zu",
        "줄루 족":"zu",
        "зулуча":"zu",
        "zuluensis":"zu",
        "സുലു":"zu",
        "żulu":"zu",
        "झुलू":"zu",
        "ଜୁଲୁ":"zu",
        "زولو":"zu",
        "zulus":"zu",
        "ਜ਼ੁਲੂ":"zu",
        "зулус":"zu",
        "zulú":"zu",
        "ஜூலு":"zu",
        "జులు":"zu",
        "พวกสูลู":"zu",
        "zulu dili":"zu",
        "南非语":"af",
        "南非語":"af",
        "阿尔巴尼亚语":"sq",
        "阿爾巴尼亞語":"sq",
        "阿姆哈拉语":"am",
        "阿姆哈拉語":"am",
        "阿拉伯":"ar",
        "亚美尼亚语":"hy",
        "亞美尼亞語":"hy",
        "阿塞拜疆":"az",
        "巴斯克":"eu",
        "白俄罗斯语":"be",
        "白俄羅斯語":"be",
        "孟加拉":"bn",
        "波斯尼亚语":"bs",
        "波斯尼亞語":"bs",
        "保加利亚语":"bg",
        "保加利亞語":"bg",
        "加泰罗尼亚语":"ca",
        "加泰羅尼亞語":"ca",
        "tara":"iw",
        "宿务":"ceb",
        "宿務":"ceb",
        "奇切瓦":"ny",
        "简体中文":"zh-cn",
        "簡體中文":"zh-cn",
        "中国传统的":"zh-tw",
        "中國傳統的":"zh-tw",
        "科西嘉语":"co",
        "科西嘉語":"co",
        "orang korsika":"co",
        "克罗地亚语":"hr",
        "克羅地亞語":"hr",
        "捷克语":"cs",
        "捷克語":"cs",
        "丹麦语":"da",
        "丹麥語":"da",
        "荷兰语":"nl",
        "荷蘭語":"nl",
        "英语":"en",
        "世界语":"eo",
        "世界語":"eo",
        "爱沙尼亚语":"et",
        "愛沙尼亞語":"et",
        "菲律宾语":"tl",
        "菲律賓語":"tl",
        "芬兰":"fi",
        "芬蘭":"fi",
        "法国语":"fr",
        "法國語":"fr",
        "弗里斯兰语":"fy",
        "弗里斯蘭語":"fy",
        "加利西亚语":"gl",
        "加利西亞語":"gl",
        "乔治亚风格":"ka",
        "喬治亞風格":"ka",
        "德语":"de",
        "德語":"de",
        "希腊语":"el",
        "希臘語":"el",
        "גריכיש":"el",
        "古吉拉特语":"gu",
        "古吉拉特語":"gu",
        "海地克里奥尔语":"ht",
        "海地克里奧爾語":"ht",
        "哈萨":"ha",
        "哈薩":"ha",
        "夏威夷语":"haw",
        "夏威夷語":"haw",
        "希伯来语":"iw",
        "希伯來語":"iw",
        "印地语":"hi",
        "印地語":"hi",
        "苗语":"hmn",
        "苗語":"hmn",
        "匈牙利":"hu",
        "冰岛的":"is",
        "冰島的":"is",
        "伊博":"ig",
        "punahu":"ig",
        "印度尼西亚":"id",
        "印度尼西亞":"id",
        "inia":"id",
        "爱尔兰语":"ga",
        "愛爾蘭語":"ga",
        "waihoki":"ga",
        "义大利文":"it",
        "義大利文":"it",
        "italyano":"it",
        "日本":"ja",
        "hapani":"ja",
        "爪哇语":"jw",
        "爪哇語":"jw",
        "卡纳达语":"kn",
        "卡納達語":"kn",
        "哈萨克语":"kk",
        "哈薩克語":"kk",
        "高棉":"km",
        "韩国语":"ko",
        "韓國語":"ko",
        "koreano":"ko",
        "kuuriyaan":"ko",
        "库尔德（kurmanji）":"ku",
        "庫爾德（kurmanji）":"ku",
        "吉尔吉斯":"ky",
        "吉爾吉斯":"ky",
        "老挝":"lo",
        "老撾":"lo",
        "拉丁":"la",
        "拉脱维亚语":"lv",
        "拉脫維亞語":"lv",
        "立陶宛语":"lt",
        "立陶宛語":"lt",
        "lcapian":"lt",
        "lithuaniyaan":"lt",
        "卢森堡":"lb",
        "盧森堡":"lb",
        "whakapaipai":"lb",
        "马其顿语":"mk",
        "馬其頓語":"mk",
        "马尔加什":"mg",
        "馬爾加什":"mg",
        "kepincangan":"mg",
        "马来语":"ms",
        "馬來語":"ms",
        "马拉雅拉姆语":"ml",
        "馬拉雅拉姆語":"ml",
        "马耳他的":"mt",
        "馬耳他的":"mt",
        "mangere":"mt",
        "毛利语":"mi",
        "毛利語":"mi",
        "մաորի":"mi",
        "马拉地语":"mr",
        "馬拉地語":"mr",
        "մարաթի":"mr",
        "蒙":"mn",
        "orang mongolia":"mn",
        "մոնղոլական":"mn",
        "缅甸语":"my",
        "緬甸語":"my",
        "myanmar (բիրմայերեն)":"my",
        "尼泊尔语":"ne",
        "尼泊爾語":"ne",
        "նեպալի":"ne",
        "挪威":"no",
        "norwejiga":"no",
        "orang norway":"no",
        "նորվեգերեն":"no",
        "奥迪亚":"or",
        "奧迪亞":"or",
        "օդիա":"or",
        "普什图语":"ps",
        "普什圖語":"ps",
        "պասթո":"ps",
        "波斯语":"fa",
        "波斯語":"fa",
        "dhejis":"fa",
        "parsi":"fa",
        "պարսկերեն":"fa",
        "抛光":"pl",
        "拋光":"pl",
        "hāneanea":"pl",
        "boolis":"pl",
        "menggilap":"pl",
        "լեհական":"pl",
        "polaco":"pl",
        "葡萄牙语":"pt",
        "葡萄牙語":"pt",
        "harawana":"pt",
        "պորտուգալերեն":"pt",
        "portugués":"pt",
        "旁遮普语":"pa",
        "旁遮普語":"pa",
        "փանջաջին":"pa",
        "罗马尼亚语":"ro",
        "羅馬尼亞語":"ro",
        "romaniga":"ro",
        "orang romania":"ro",
        "ռումինական":"ro",
        "romanés":"ro",
        "俄语":"ru",
        "俄語":"ru",
        "ruushka":"ru",
        "orang rusia":"ru",
        "ռուսերեն":"ru",
        "萨摩亚语":"sm",
        "薩摩亞語":"sm",
        "սամոան":"sm",
        "苏格兰盖尔语":"gd",
        "蘇格蘭蓋爾語":"gd",
        "karoti gaelic":"gd",
        "塞尔维亚":"sr",
        "塞爾維亞":"sr",
        "սերբ":"sr",
        "serbio":"sr",
        "塞索托":"st",
        "սեսոտո":"st",
        "绍娜":"sn",
        "紹娜":"sn",
        "շոնա":"sn",
        "辛迪":"sd",
        "սինդհի":"sd",
        "辛哈拉":"si",
        "սինհալա":"si",
        "singalesisk":"si",
        "斯洛伐克文":"sk",
        "paheke":"sk",
        "սլովակ":"sk",
        "eslovaco":"sk",
        "slovák":"sk",
        "斯洛文尼亚文":"sl",
        "斯洛文尼亞文":"sl",
        "he rūriana":"sl",
        "halyeeyga":"sl",
        "orang slovenia":"sl",
        "սլանկ":"sl",
        "calado":"sl",
        "slovinský":"sl",
        "slovensk":"sl",
        "索马里":"so",
        "索馬里":"so",
        "սոմալի":"so",
        "somálský":"so",
        "西班牙文":"es",
        "pānuitia":"es",
        "isbaanish":"es",
        "sepanyol":"es",
        "իսպանական":"es",
        "español":"es",
        "španělština":"es",
        "dan":"su",
        "riwai":"su",
        "bahasa sunda":"su",
        "sundánský":"su",
        "sundanesisk":"su",
        "斯瓦希里语":"sw",
        "斯瓦希里語":"sw",
        "սուահիլի":"sw",
        "svahilština":"sw",
        "瑞典":"sv",
        "taiharo":"sv",
        "iswiidhishka":"sv",
        "swedia":"sv",
        "շվեդերեն":"sv",
        "sueco":"sv",
        "švédský":"sv",
        "塔吉克":"tg",
        "տաջիկ":"tg",
        "泰米尔语":"ta",
        "泰米爾語":"ta",
        "pahara":"ta",
        "տամիլ":"ta",
        "泰卢固语":"te",
        "泰盧固語":"te",
        "տելուգու":"te",
        "泰国":"th",
        "泰國":"th",
        "orang thailand":"th",
        "թայերեն":"th",
        "tailandés":"th",
        "tailandese":"th",
        "thaimaalainen":"th",
        "土耳其":"tr",
        "orang turki":"tr",
        "թուրքերեն":"tr",
        "turco":"tr",
        "turečtina":"tr",
        "turkki":"tr",
        "乌克兰":"uk",
        "烏克蘭":"uk",
        "iukereiniana":"uk",
        "yukreeniyaan":"uk",
        "orang ukraine":"uk",
        "ուկրաիներեն":"uk",
        "ucraíno":"uk",
        "ukrajinština":"uk",
        "ukrainalainen":"uk",
        "乌尔都语":"ur",
        "烏爾都語":"ur",
        "ուրդու":"ur",
        "维吾尔语":"ug",
        "維吾爾語":"ug",
        "ույղուր":"ug",
        "uiguro":"ug",
        "uiguuri":"ug",
        "乌兹别克语":"uz",
        "烏茲別克語":"uz",
        "orang uzbekistan":"uz",
        "ուզբեկ":"uz",
        "uzbekki":"uz",
        "越南语":"vi",
        "越南語":"vi",
        "bahasa vietnam":"vi",
        "վիետնամական":"vi",
        "vietnamština":"vi",
        "וויעטנאַמעזיש":"vi",
        "威尔士语":"cy",
        "威爾士語":"cy",
        "ուելսերեն":"cy",
        "significado":"cy",
        "velština":"cy",
        "gallese":"cy",
        "walesin":"cy",
        "וואָליש":"cy",
        "科萨":"xh",
        "科薩":"xh",
        "依地语":"yi",
        "依地語":"yi",
        "ngatu":"yi",
        "orang yiddish":"yi",
        "քրքական":"yi",
        "xudeu":"yi",
        "jiddiš":"yi",
        "ייִדיש":"yi",
        "约鲁巴":"yo",
        "約魯巴":"yo",
        "յորուբա":"yo",
        "祖鲁语":"zu",
        "祖魯語":"zu",
        "զուլու":"zu",
        "zulù":"zu"
    }
    return data_dict


def google_translate_domains_data():
    """
    All the Google Translate's domain names.\n
    Credit to py-googletrans by ssut (constants.py)
    """
    data_list = [
        'translate.google.ac',
        'translate.google.ad',
        'translate.google.ae',
        'translate.google.al',
        'translate.google.am',
        'translate.google.as',
        'translate.google.at',
        'translate.google.az',
        'translate.google.ba',
        'translate.google.be',
        'translate.google.bf',
        'translate.google.bg',
        'translate.google.bi',
        'translate.google.bj',
        'translate.google.bs',
        'translate.google.bt',
        'translate.google.by',
        'translate.google.ca',
        'translate.google.cat',
        'translate.google.cc',
        'translate.google.cd',
        'translate.google.cf',
        'translate.google.cg',
        'translate.google.ch',
        'translate.google.ci',
        'translate.google.cl',
        'translate.google.cm',
        'translate.google.cn',
        'translate.google.co.ao',
        'translate.google.co.bw',
        'translate.google.co.ck',
        'translate.google.co.cr',
        'translate.google.co.id',
        'translate.google.co.il',
        'translate.google.co.in',
        'translate.google.co.jp',
        'translate.google.co.ke',
        'translate.google.co.kr',
        'translate.google.co.ls',
        'translate.google.co.ma',
        'translate.google.co.mz',
        'translate.google.co.nz',
        'translate.google.co.th',
        'translate.google.co.tz',
        'translate.google.co.ug',
        'translate.google.co.uk',
        'translate.google.co.uz',
        'translate.google.co.ve',
        'translate.google.co.vi',
        'translate.google.co.za',
        'translate.google.co.zm',
        'translate.google.co.zw',
        'translate.google.co',
        'translate.google.com.af',
        'translate.google.com.ag',
        'translate.google.com.ai',
        'translate.google.com.ar',
        'translate.google.com.au',
        'translate.google.com.bd',
        'translate.google.com.bh',
        'translate.google.com.bn',
        'translate.google.com.bo',
        'translate.google.com.br',
        'translate.google.com.bz',
        'translate.google.com.co',
        'translate.google.com.cu',
        'translate.google.com.cy',
        'translate.google.com.do',
        'translate.google.com.ec',
        'translate.google.com.eg',
        'translate.google.com.et',
        'translate.google.com.fj',
        'translate.google.com.gh',
        'translate.google.com.gi',
        'translate.google.com.gt',
        'translate.google.com.hk',
        'translate.google.com.jm',
        'translate.google.com.kh',
        'translate.google.com.kw',
        'translate.google.com.lb',
        'translate.google.com.lc',
        'translate.google.com.ly',
        'translate.google.com.mm',
        'translate.google.com.mt',
        'translate.google.com.mx',
        'translate.google.com.my',
        'translate.google.com.na',
        'translate.google.com.ng',
        'translate.google.com.ni',
        'translate.google.com.np',
        'translate.google.com.om',
        'translate.google.com.pa',
        'translate.google.com.pe',
        'translate.google.com.pg',
        'translate.google.com.ph',
        'translate.google.com.pk',
        'translate.google.com.pr',
        'translate.google.com.py',
        'translate.google.com.qa',
        'translate.google.com.sa',
        'translate.google.com.sb',
        'translate.google.com.sg',
        'translate.google.com.sl',
        'translate.google.com.sv',
        'translate.google.com.tj',
        'translate.google.com.tr',
        'translate.google.com.tw',
        'translate.google.com.ua',
        'translate.google.com.uy',
        'translate.google.com.vc',
        'translate.google.com.vn',
        'translate.google.com',
        'translate.google.cv',
        'translate.google.cx',
        'translate.google.cz',
        'translate.google.de',
        'translate.google.dj',
        'translate.google.dk',
        'translate.google.dm',
        'translate.google.dz',
        'translate.google.ee',
        'translate.google.es',
        'translate.google.eu',
        'translate.google.fi',
        'translate.google.fm',
        'translate.google.fr',
        'translate.google.ga',
        'translate.google.ge',
        'translate.google.gf',
        'translate.google.gg',
        'translate.google.gl',
        'translate.google.gm',
        'translate.google.gp',
        'translate.google.gr',
        'translate.google.gy',
        'translate.google.hn',
        'translate.google.hr',
        'translate.google.ht',
        'translate.google.hu',
        'translate.google.ie',
        'translate.google.im',
        'translate.google.io',
        'translate.google.iq',
        'translate.google.is',
        'translate.google.it',
        'translate.google.je',
        'translate.google.jo',
        'translate.google.kg',
        'translate.google.ki',
        'translate.google.kz',
        'translate.google.la',
        'translate.google.li',
        'translate.google.lk',
        'translate.google.lt',
        'translate.google.lu',
        'translate.google.lv',
        'translate.google.md',
        'translate.google.me',
        'translate.google.mg',
        'translate.google.mk',
        'translate.google.ml',
        'translate.google.mn',
        'translate.google.ms',
        'translate.google.mu',
        'translate.google.mv',
        'translate.google.mw',
        'translate.google.ne',
        'translate.google.nf',
        'translate.google.nl',
        'translate.google.no',
        'translate.google.nr',
        'translate.google.nu',
        'translate.google.pl',
        'translate.google.pn',
        'translate.google.ps',
        'translate.google.pt',
        'translate.google.ro',
        'translate.google.rs',
        'translate.google.ru',
        'translate.google.rw',
        'translate.google.sc',
        'translate.google.se',
        'translate.google.sh',
        'translate.google.si',
        'translate.google.sk',
        'translate.google.sm',
        'translate.google.sn',
        'translate.google.so',
        'translate.google.sr',
        'translate.google.st',
        'translate.google.td',
        'translate.google.tg',
        'translate.google.tk',
        'translate.google.tl',
        'translate.google.tm',
        'translate.google.tn',
        'translate.google.to',
        'translate.google.tt',
        'translate.google.us',
        'translate.google.vg',
        'translate.google.vu',
        'translate.google.ws'
    ]
    return data_list
