"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Parameter = exports.ParameterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const oos_generated_1 = require("./oos.generated");
Object.defineProperty(exports, "ParameterProperty", { enumerable: true, get: function () { return oos_generated_1.RosParameter; } });
/**
 * A ROS resource type:  `ALIYUN::OOS::Parameter`
 */
class Parameter extends ros.Resource {
    /**
     * Create a new `ALIYUN::OOS::Parameter`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosParameter = new oos_generated_1.RosParameter(this, id, {
            type: props.type,
            description: props.description,
            constraints: props.constraints,
            resourceGroupId: props.resourceGroupId,
            value: props.value,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosParameter;
        this.attrName = rosParameter.attrName;
        this.attrValue = rosParameter.attrValue;
    }
}
exports.Parameter = Parameter;
//# sourceMappingURL=data:application/json;base64,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