"""Top-level package for Poisson Approval."""

__author__ = """François Durand"""
__email__ = 'fradurand@gmail.com'
__version__ = '0.14.0'


# Utils
from poisson_approval.utils.DictPrintingInOrder import DictPrintingInOrder
from poisson_approval.utils.DictPrintingInOrderIgnoringNone import DictPrintingInOrderIgnoringNone
from poisson_approval.utils.DictPrintingInOrderIgnoringZeros import DictPrintingInOrderIgnoringZeros
from poisson_approval.utils.SetPrintingInOrder import SetPrintingInOrder
from poisson_approval.utils.Util import *
from poisson_approval.utils.UtilCache import *
from poisson_approval.utils.UtilMasks import *

# Constants
from poisson_approval.constants.constants import *
from poisson_approval.constants.EquilibriumStatus import EquilibriumStatus
from poisson_approval.constants.Focus import Focus

# Simple containers
from poisson_approval.containers.Winners import Winners
from poisson_approval.containers.Scores import Scores
from poisson_approval.containers.AnalyzedStrategies import AnalyzedStrategies

# Events
from poisson_approval.events.Asymptotic import Asymptotic
from poisson_approval.events.Event import Event
from poisson_approval.events.EventDuo import EventDuo
from poisson_approval.events.EventPivotStrict import EventPivotStrict
from poisson_approval.events.EventPivotTij import EventPivotTij
from poisson_approval.events.EventPivotTjk import EventPivotTjk
from poisson_approval.events.EventPivotWeak import EventPivotWeak
from poisson_approval.events.EventTrio import EventTrio
from poisson_approval.events.EventTrio1t import EventTrio1t
from poisson_approval.events.EventTrio2t import EventTrio2t

# Best response
from poisson_approval.best_response.BestResponse import BestResponse
from poisson_approval.best_response.BestResponseAntiPlurality import BestResponseAntiPlurality
from poisson_approval.best_response.BestResponseApproval import BestResponseApproval
from poisson_approval.best_response.BestResponsePlurality import BestResponsePlurality

# Tau-vector
from poisson_approval.tau_vector.TauVector import TauVector

# Strategies
from poisson_approval.strategies.Strategy import Strategy
from poisson_approval.strategies.StrategyTwelve import StrategyTwelve
from poisson_approval.strategies.StrategyThreshold import StrategyThreshold
from poisson_approval.strategies.StrategyOrdinal import StrategyOrdinal

# Profiles
from poisson_approval.profiles.Profile import Profile
from poisson_approval.profiles.ProfileDiscrete import ProfileDiscrete
from poisson_approval.profiles.ProfileOrdinal import ProfileOrdinal
from poisson_approval.profiles.ProfileCardinal import ProfileCardinal
from poisson_approval.profiles.ProfileTwelve import ProfileTwelve
from poisson_approval.profiles.ProfileHistogram import ProfileHistogram

# Grid explorations
from poisson_approval.explore_grid.ExploreGridProfilesOrdinal import ExploreGridProfilesOrdinal
from poisson_approval.explore_grid.ExploreGridTaus import ExploreGridTaus

# Random generators
from poisson_approval.generators.GeneratorExample import GeneratorExample
from poisson_approval.generators.GeneratorProfileOrdinalGridUniform import GeneratorProfileOrdinalGridUniform
from poisson_approval.generators.GeneratorProfileOrdinalUniform import GeneratorProfileOrdinalUniform
from poisson_approval.generators.GeneratorProfileOrdinalVariations import GeneratorProfileOrdinalVariations
from poisson_approval.generators.GeneratorProfileHistogramSinglePeakedUniform \
    import GeneratorProfileHistogramSinglePeakedUniform
from poisson_approval.generators.GeneratorProfileHistogramUniform import GeneratorProfileHistogramUniform
from poisson_approval.generators.GeneratorStrategyOrdinalUniform import GeneratorStrategyOrdinalUniform
from poisson_approval.generators.GeneratorStrategyThresholdUniform import GeneratorStrategyThresholdUniform
from poisson_approval.generators.GeneratorTauVectorGridUniform import GeneratorTauVectorGridUniform
from poisson_approval.generators.GeneratorTauVectorUniform import GeneratorTauVectorUniform

# Meta-analysis
from poisson_approval.meta_analysis.NiceStatsProfileOrdinal import NiceStatsProfileOrdinal
from poisson_approval.meta_analysis.ternary_plots import TernaryAxesSubplotPoisson, ternary_figure
