# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['iredis',
 'iredis.data',
 'iredis.data.commands',
 'tests',
 'tests.cli_tests',
 'tests.unittests',
 'tests.unittests.command_parse']

package_data = \
{'': ['*']}

install_requires = \
['Pygments>=2,<3',
 'click>=7.0,<8.0',
 'configobj>=5.0,<6.0',
 'importlib-resources>=5.1.0,<6.0.0',
 'mistune>=2.0,<3.0',
 'packaging>=21.3,<22.0',
 'pendulum>=2.0,<3.0',
 'prompt_toolkit>=3,<4',
 'redis>=4.3.4,<5.0.0',
 'wcwidth==0.1.9']

entry_points = \
{'console_scripts': ['iredis = iredis.entry:main']}

setup_kwargs = {
    'name': 'iredis',
    'version': '1.12.2',
    'description': 'Terminal client for Redis with auto-completion and syntax highlighting.',
    'long_description': '<p align="center">\n  <img width="100" height="100" src="https://raw.githubusercontent.com/laixintao/iredis/master/docs/assets/logo.png" />\n</p>\n\n<h3 align="center">Interactive Redis: A Cli for Redis with AutoCompletion and Syntax Highlighting.</h3>\n\n<p align="center">\n<a href="https://github.com/laixintao/iredis/actions"><img src="https://github.com/laixintao/iredis/workflows/Test/badge.svg" alt="Github Action"></a>\n<a href="https://badge.fury.io/py/iredis"><img src="https://badge.fury.io/py/iredis.svg" alt="PyPI version"></a>\n<img src="https://badgen.net/badge/python/3.6%20%7C%203.7%20%7C%203.8%20%7C%203.9%20%7C%203.10/" alt="Python version">\n<a href="https://pepy.tech/project/iredis"><img src="https://pepy.tech/badge/iredis" alt="Download stats"></a>\n</p>\n\n<p align="center">\n  <img src="./docs/assets/demo.svg" alt="demo">\n</p>\n\nIRedis is a terminal client for redis with auto-completion and syntax\nhighlighting. IRedis lets you type Redis commands smoothly, and displays results\nin a user-friendly format.\n\nIRedis is an alternative for redis-cli. In most cases, IRedis behaves exactly\nthe same as redis-cli. Besides, it is safer to use IRedis on production servers\nthan redis-cli: IRedis will prevent accidentally running dangerous commands,\nlike `KEYS *` (see\n[Redis docs / Latency generated by slow commands](https://redis.io/topics/latency#latency-generated-by-slow-commands)).\n\n## Features\n\n- Advanced code completion. If you run command `KEYS` then run `DEL`, IRedis\n  will auto-complete your command based on `KEYS` result.\n- Command validation. IRedis will validate command while you are typing, and\n  highlight errors. E.g. try `CLUSTER MEET IP PORT`, IRedis will validate IP and\n  PORT for you.\n- Command highlighting, fully based on redis grammar. Any valid command in\n  IRedis shell is a valid redis command.\n- Human-friendly result display.\n- _pipeline_ feature, you can use your favorite shell tools to parse redis\'\n  response, like `get json | jq .`.\n- Support pager for long output.\n- Support connection via URL, `iredis --url redis://example.com:6379/1`.\n- Support cluster, IRedis will auto reissue command for `MOVED` response in\n  cluster mode.\n- Store server configuration: `iredis -d prod-redis` (see [dsn](#using-dsn) for\n  more).\n- `peek` command to check the key\'s type then automatically call\n  `get`/`lrange`/`sscan`, etc, depending on types. You don\'t need to call the\n  `type` command then type another command to get the value. `peek` will also\n  display the key\'s length and memory usage.\n- <kbd>Ctrl</kbd> + <kbd>C</kbd> to cancel the current typed command, this won\'t\n  exit IRedis, exactly like bash behaviour. Use <kbd>Ctrl</kbd> + <kbd>D</kbd>\n  to send a EOF to exit IRedis.\n- <kbd>Ctrl</kbd> + <kbd>R</kbd> to open **reverse-i-search** to search through\n  your command history.\n- Auto suggestions. (Like [fish shell](http://fishshell.com/).)\n- Support `--encode=utf-8`, to decode Redis\' bytes responses.\n- Command hint on bottom, include command syntax, supported redis version, and\n  time complexity.\n- Official docs with built-in `HELP` command, try `HELP SET`!\n- Written in pure Python, but IRedis was packaged into a single binary with\n  [PyOxidizer](https://github.com/indygreg/PyOxidizer), you can use cURL to\n  download and run, it just works, even you don\'t have a Python interpreter.\n- You can change the cli prompt using `--prompt` option or set via `~/.iredisrc`\n  config file.\n- Hide password for `AUTH` command.\n- Says "Goodbye!" to you when you exit!\n- For full features, please see: [iredis.io](https://www.iredis.io)\n\n## Install\n\n### Pip\n\nInstall via pip:\n\n```\npip install iredis\n```\n\n[pipx](https://github.com/pipxproject/pipx) is recommended:\n\n```\npipx install iredis\n```\n\n### Brew\n\nFor Mac users, you can install iredis via brew 🍻\n\n```\nbrew install iredis\n```\n\n### Linux\n\nYou can also use your Linux package manager to install IRedis, like `apt` in\nUbuntu (Only available on Ubuntu 21.04+).\n\n```shell\napt install iredis\n```\n\n[![Packaging status](https://repology.org/badge/vertical-allrepos/iredis.svg)](https://repology.org/project/iredis/versions)\n\n### Download Binary\n\nOr you can download the executable binary with cURL(or wget), untar, then run.\nIt is especially useful when you don\'t have a python interpreter(E.g. the\n[official Redis docker image](https://hub.docker.com/_/redis/) which doesn\'t\nhave Python installed.):\n\n```\nwget  https://github.com/laixintao/iredis/releases/latest/download/iredis.tar.gz \\\n && tar -xzf iredis.tar.gz \\\n && ./iredis\n```\n\n(Check the [release page](https://github.com/laixintao/iredis/releases) if you\nwant to download an old version of IRedis.)\n\n## Usage\n\nOnce you install IRedis, you will know how to use it. Just remember, IRedis\nsupports similar options like redis-cli, like `-h` for redis-server\'s host and\n`-p` for port.\n\n```\n$ iredis --help\n\nUsage: iredis [OPTIONS] [CMD]...\n\n  IRedis: Interactive Redis\n\n  When no command is given, IRedis starts in interactive mode.\n\n  Examples:\n    - iredis\n    - iredis -d dsn\n    - iredis -h 127.0.0.1 -p 6379\n    - iredis -h 127.0.0.1 -p 6379 -a <password>\n    - iredis --url redis://localhost:7890/3\n\n  Type "help" in interactive mode for information on available commands and\n  settings.\n\nOptions:\n  -h TEXT                         Server hostname (default: 127.0.0.1).\n  -p TEXT                         Server port (default: 6379).\n  -s, --socket TEXT               Server socket (overrides hostname and port).\n  -n INTEGER                      Database number.(overwrites dsn/url\'s db\n                                  number)\n\n  -u, --username TEXT             User name used to auth, will be ignore for\n                                  redis version < 6.\n\n  -a, --password TEXT             Password to use when connecting to the\n                                  server.\n\n  --url TEXT                      Use Redis URL to indicate connection(Can set\n                                  with env `IREDIS_URL`), Example:     redis:/\n                                  /[[username]:[password]]@localhost:6379/0\n                                  rediss://[[username]:[password]]@localhost:6\n                                  379/0     unix://[[username]:[password]]@/pa\n                                  th/to/socket.sock?db=0\n\n  -d, --dsn TEXT                  Use DSN configured into the [alias_dsn]\n                                  section of iredisrc file. (Can set with env\n                                  `IREDIS_DSN`)\n\n  --newbie / --no-newbie          Show command hints and useful helps.\n  --iredisrc TEXT                 Config file for iredis, default is\n                                  ~/.iredisrc.\n\n  --decode TEXT                   decode response, default is No decode, which\n                                  will output all bytes literals.\n\n  --client_name TEXT              Assign a name to the current connection.\n  --raw / --no-raw                Use raw formatting for replies (default when\n                                  STDOUT is not a tty). However, you can use\n                                  --no-raw to force formatted output even when\n                                  STDOUT is not a tty.\n\n  --rainbow / --no-rainbow        Display colorful prompt.\n  --shell / --no-shell            Allow to run shell commands, default to\n                                  True.\n\n  --pager / --no-pager            Using pager when output is too tall for your\n                                  window, default to True.\n\n  --verify-ssl [none|optional|required]\n                                  Set the TLS certificate verification\n                                  strategy\n\n  --prompt TEXT                   Prompt format (supported interpolations:\n                                  {client_name}, {db}, {host}, {path}, {port},\n                                  {username}, {client_addr}, {client_id}).\n\n  --version                       Show the version and exit.\n  --help                          Show this message and exit.\n\n```\n\n### Using DSN\n\nIRedis support storing server configuration in config file. Here is a DSN\nconfig:\n\n```\n[alias_dsn]\ndev=redis://localhost:6379/4\nstaging=redis://username:password@staging-redis.example.com:6379/1\n```\n\nPut this in your `iredisrc` then connect via `iredis -d staging` or\n`iredis -d dev`.\n\n### Change The Default Prompt\n\nYou can change the prompt str, the default prompt is:\n\n```shell\n127.0.0.1:6379>\n```\n\nWhich is rendered by `{host}:{port}[{db}]> `, you can change this via `--prompt`\noption or change\n[iredisrc](https://github.com/laixintao/iredis/blob/master/iredis/data/iredisrc)\nconfig file. The prompwt string uses python string format engine, supported\ninterpolations:\n\n- `{client_name}`\n- `{db}`\n- `{host}`\n- `{path}`\n- `{port}`\n- `{username}`\n- `{client_addr}`\n- `{client_id}`\n\nThe `--prompt` utilize\n[Python String format engine](https://docs.python.org/3/library/string.html#formatstrings),\nso as long as it is a valid string formatter, it will work( anything that\n`"<your prompt>".format(...)` accepts). For example, you can limit your Redis\nserver host name\'s length to 5 by setting `--prompt` to\n`iredis --prompt \'{host:.5s}\'`.\n\n### Configuration\n\nIRedis supports config files. Command-line options will always take precedence\nover config. Configuration resolution from highest to lowest precedence is:\n\n- _Options from command line_\n- `$PWD/.iredisrc`\n- `~/.iredisrc` (this path can be changed with `iredis --iredisrc $YOUR_PATH`)\n- `/etc/iredisrc`\n- default config in IRedis package.\n\nYou can copy the _self-explained_ default config here:\n\nhttps://raw.githubusercontent.com/laixintao/iredis/master/iredis/data/iredisrc\n\nAnd then make your own changes.\n\n(If you are using an old versions of IRedis, please use the config file below,\nand change the version in URL):\n\nhttps://raw.githubusercontent.com/laixintao/iredis/v1.0.4/iredis/data/iredisrc\n\n### Keys\n\nIRedis support unix/readline-style REPL keyboard shortcuts, which means keys\nlike <kbd>Ctrl</kbd> + <kbd>F</kbd> to forward work.\n\nAlso:\n\n- <kbd>Ctrl</kbd> + <kbd>D</kbd> (i.e. EOF) to exit; you can also use the `exit`\n  command.\n- <kbd>Ctrl</kbd> + <kbd>L</kbd> to clear screen; you can also use the `clear`\n  command.\n- <kbd>Ctrl</kbd> + <kbd>X</kbd> <kbd>Ctrl</kbd> + <kbd>E</kbd> to open an\n  editor to edit command, or <kbd>V</kbd> in vi-mode.\n\n## Development\n\n### Release Strategy\n\nIRedis is built and released by `GitHub Actions`. Whenever a tag is pushed to\nthe `master` branch, a new release is built and uploaded to pypi.org, it\'s very\nconvenient.\n\nThus, we release as often as possible, so that users can always enjoy the new\nfeatures and bugfixes quickly. Any bugfix or new feature will get at least a\npatch release, whereas big features will get a minor release.\n\n### Setup Environment\n\nIRedis favors [poetry](https://github.com/sdispater/poetry) as package\nmanagement tool. To setup a develop environment on your computer:\n\nFirst, install poetry (you can do it in a python\'s virtualenv):\n\n```\npip install poetry\n```\n\nThen run (which is similar to `pip install -e .`):\n\n```\npoetry install\n```\n\n**Be careful running testcases locally, it may flush you db!!!**\n\n### Development Logs\n\nThis is a command-line tool, so we don\'t write logs to stdout.\n\nYou can `tail -f ~/.iredis.log` to see logs, the log is pretty clear, you can\nsee what actually happens from log files.\n\n### Catch Up with Latest Redis-doc\n\nIRedis use a git submodule to track current-up-to-date redis-doc version. To\ncatch up with latest:\n\n1. Git pull in redis-doc\n2. Copy doc files to `/data`: `cp -r redis-doc/commands* iredis/data`\n3. Prettier\n   markdown`prettier --prose-wrap always iredis/data/commands/*.md --write`\n4. Check the diff, update IRedis\' code if needed.\n\n## Related Projects\n\n- [redis-tui](https://github.com/mylxsw/redis-tui)\n\nIf you like iredis, you may also like other cli tools by\n[dbcli](https://www.dbcli.com/):\n\n- [pgcli](https://www.pgcli.com) - Postgres Client with Auto-completion and\n  Syntax Highlighting\n- [mycli](https://www.mycli.net) - MySQL/MariaDB/Percona Client with\n  Auto-completion and Syntax Highlighting\n- [litecli](https://litecli.com) - SQLite Client with Auto-completion and Syntax\n  Highlighting\n- [mssql-cli](https://github.com/dbcli/mssql-cli) - Microsoft SQL Server Client\n  with Auto-completion and Syntax Highlighting\n- [athenacli](https://github.com/dbcli/athenacli) - AWS Athena Client with\n  Auto-completion and Syntax Highlighting\n- [vcli](https://github.com/dbcli/vcli) - VerticaDB client\n- [iredis](https://github.com/laixintao/iredis/) - Client for Redis with\n  AutoCompletion and Syntax Highlighting\n\nIRedis is build on the top of\n[prompt_toolkit](https://github.com/jonathanslenders/python-prompt-toolkit), a\nPython library (by [Jonathan Slenders](https://twitter.com/jonathan_s)) for\nbuilding rich commandline applications.\n',
    'author': 'laixintao',
    'author_email': 'laixintao1995@163.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/laixintao/iredis',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
