# -*- coding: utf-8 -*-
# pylint: disable=wrong-import-position
import numpy as np

import pytest

pyilt2 = pytest.importorskip('pyilt2')

import mincepy


def get_dataset():
    # pylint: disable=line-too-long

    dataset = pyilt2.dataset.__new__(pyilt2.dataset)
    dataset.setid = 'nwnQG'

    dataset.data = np.array([])
    dataset.headerList = []
    dataset.physProps = []
    dataset.physUnits = []
    dataset.phases = []

    dataset.setDict = {
        'solvent':
            None,
        'ref': {
            'title':
                'Physicochemical properties of (1-butyl-1-methylpyrrolydinium dicyanamide + .gamma.-butyrolactone) binary mixtures',
            'full':
                'Zec, N.; Bester-Rogac, M.; Vranes, M.; Gadzuric, S. (2015) J. Chem. Thermodyn. 91, 327-335.'
        },
        'title':
            'Transport properties: Electrical conductivity',
        'phases': ['Liquid'],
        'expmeth':
            'Alternating current cell with electrodes',
        'data': [[['273.15'], ['100'], ['0.0005'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.001'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.0015'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.002'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.0025'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.003'], ['0.522', '0.005']],
                 [['273.15'], ['100'], ['0.00347222'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.004'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00446429'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.005'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.005454'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.006'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00652174'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00694444'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.0075'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.008'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00857143'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00892857'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.00961538'], ['0.523', '0.005']],
                 [['273.15'], ['100'], ['0.01'], ['0.523', '0.005']],
                 [['283.15'], ['100'], ['0.0005'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.001'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.0015'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.002'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.0025'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.003'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00347222'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.004'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00446429'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.005'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.005454'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.006'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00652174'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00694444'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.0075'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.008'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00857143'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00892857'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.00961538'], ['0.786', '0.008']],
                 [['283.15'], ['100'], ['0.01'], ['0.786', '0.008']],
                 [['293.15'], ['100'], ['0.0005'], ['1.122', '0.011']],
                 [['293.15'], ['100'], ['0.001'], ['1.122', '0.011']],
                 [['293.15'], ['100'], ['0.0015'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.002'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.0025'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.003'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00347222'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.004'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00446429'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.005'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.005454'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.006'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00652174'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00694444'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.0075'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.008'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00857143'], ['1.123', '0.011']],
                 [['293.15'], ['100'], ['0.00892857'], ['1.124', '0.011']],
                 [['293.15'], ['100'], ['0.00961538'], ['1.124', '0.011']],
                 [['293.15'], ['100'], ['0.01'], ['1.124', '0.011']],
                 [['298.15'], ['100'], ['0.0005'], ['1.315', '0.013']],
                 [['298.15'], ['100'], ['0.001'], ['1.316', '0.013']],
                 [['298.15'], ['100'], ['0.0015'], ['1.316', '0.013']],
                 [['298.15'], ['100'], ['0.002'], ['1.316', '0.013']],
                 [['298.15'], ['100'], ['0.0025'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.003'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.00347222'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.004'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.00446429'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.005'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.005454'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.006'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.00652174'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.00694444'], ['1.317', '0.013']],
                 [['298.15'], ['100'], ['0.0075'], ['1.318', '0.013']],
                 [['298.15'], ['100'], ['0.008'], ['1.318', '0.013']],
                 [['298.15'], ['100'], ['0.00857143'], ['1.318', '0.013']],
                 [['298.15'], ['100'], ['0.00892857'], ['1.318', '0.013']],
                 [['298.15'], ['100'], ['0.00961538'], ['1.318', '0.013']],
                 [['298.15'], ['100'], ['0.01'], ['1.318', '0.013']],
                 [['303.15'], ['100'], ['0.0005'], ['1.525', '0.015']],
                 [['303.15'], ['100'], ['0.001'], ['1.526', '0.015']],
                 [['303.15'], ['100'], ['0.0015'], ['1.526', '0.015']],
                 [['303.15'], ['100'], ['0.002'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.0025'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.003'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00347222'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.004'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00446429'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.005'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.005454'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.006'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00652174'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00694444'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.0075'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.008'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00857143'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00892857'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.00961538'], ['1.527', '0.015']],
                 [['303.15'], ['100'], ['0.01'], ['1.527', '0.015']],
                 [['313.15'], ['100'], ['0.0005'], ['1.993', '0.02']],
                 [['313.15'], ['100'], ['0.001'], ['1.995', '0.02']],
                 [['313.15'], ['100'], ['0.0015'], ['1.995', '0.02']],
                 [['313.15'], ['100'], ['0.002'], ['1.996', '0.02']],
                 [['313.15'], ['100'], ['0.0025'], ['1.996', '0.02']],
                 [['313.15'], ['100'], ['0.003'], ['1.996', '0.02']],
                 [['313.15'], ['100'], ['0.00347222'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.004'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00446429'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.005'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.005454'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.006'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00652174'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00694444'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.0075'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.008'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00857143'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00892857'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.00961538'], ['1.997', '0.02']],
                 [['313.15'], ['100'], ['0.01'], ['1.997', '0.02']],
                 [['323.15'], ['100'], ['0.0005'], ['2.525', '0.025']],
                 [['323.15'], ['100'], ['0.001'], ['2.526', '0.025']],
                 [['323.15'], ['100'], ['0.0015'], ['2.527', '0.025']],
                 [['323.15'], ['100'], ['0.002'], ['2.528', '0.025']],
                 [['323.15'], ['100'], ['0.0025'], ['2.528', '0.025']],
                 [['323.15'], ['100'], ['0.003'], ['2.528', '0.025']],
                 [['323.15'], ['100'], ['0.00347222'], ['2.528', '0.025']],
                 [['323.15'], ['100'], ['0.004'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00446429'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.005'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.005454'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.006'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00652174'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00694444'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.0075'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.008'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00857143'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00892857'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.00961538'], ['2.529', '0.025']],
                 [['323.15'], ['100'], ['0.01'], ['2.529', '0.025']]],
        'footer':
            '',
        'constr': [],
        'components': [{
            'mw': '208.31',
            'sample': [['Source:', 'commercial source'],
                       ['Initial purification:', 'stated by supplier'],
                       ['Initial purity:', '98 mass %'],
                       ['Final purification:', 'ion chromatography;Karl Fischer titration'],
                       [
                           'Final purity:',
                           '2 halide impurity mol %;0.0211 water mass %(dried by vacuum heating)'
                       ]],
            'idout': 'AAoDFo',
            'name': '1-butyl-1-methylpyrrolidinium dicyanamide',
            'formula': 'C<SUB>11</SUB>H<SUB>20</SUB>N<SUB>4</SUB>'
        }],
        'dhead': [['Temperature, K', None], ['Pressure, kPa', None], ['Frequency, MHz', 'Liquid'],
                  ['Electrical conductivity, S/m', 'Liquid']]
    }

    # pylint: disable=protected-access
    dataset._dataNpArray()
    dataset._dataHeader()
    return dataset


def test_saving_dataset(historian: mincepy.Historian):
    dataset = get_dataset()
    oid = historian.save(dataset)
    del dataset

    loaded = historian.load(oid)
    orig = get_dataset()

    assert loaded.setid == orig.setid
    assert np.all(loaded.data == orig.data)
    assert loaded.headerList == orig.headerList
    assert loaded.physProps == orig.physProps
    assert loaded.physUnits == orig.physUnits
    assert loaded.phases == orig.phases
    assert loaded.setDict == orig.setDict
