# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.message_response import MessageResponse
from ..types.workflow_request_chunk_strategy import WorkflowRequestChunkStrategy
from ..types.workflow_response import WorkflowResponse
from ..types.workflow_steps import WorkflowSteps
from ..types.workflows_response import WorkflowsResponse
from .types.workflows_get_request_id import WorkflowsGetRequestId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[WorkflowsResponse]:
        """
        Get all workflows associated with the API key.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowsResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflow",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowsResponse,
                    parse_obj_as(
                        type_=WorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WorkflowResponse]:
        """
        Create a workflow.

        Parameters
        ----------
        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowResponse]
            Workflow successfully created
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflow",
            method="POST",
            json={
                "chunkStrategy": chunk_strategy,
                "name": name,
                "extract": extract,
                "steps": convert_and_respect_annotation_metadata(
                    object_=steps, annotation=WorkflowSteps, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_account(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[WorkflowResponse]:
        """
        Get the workflow associated with customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_to_account(
        self, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MessageResponse]:
        """
        Assigns the given workflow to the customer account and is applied by default to all files unless overridden by document or bucket workflows.

        Parameters
        ----------
        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MessageResponse]
            Apply success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="POST",
            json={
                "workflowId": workflow_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def remove_from_account(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MessageResponse]:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MessageResponse]
            Apply success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def add_to_id(
        self, id: int, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MessageResponse]:
        """
        Assigns the given workflow to the group or bucket and is applied by default to all files unless overridden by document workflows.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will be assigned to.

        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MessageResponse]
            Apply success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow/relationship/{jsonable_encoder(id)}",
            method="POST",
            json={
                "workflowId": workflow_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def remove_from_id(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MessageResponse]:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will removed from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MessageResponse]
            Apply success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow/relationship/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, id: WorkflowsGetRequestId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WorkflowResponse]:
        """
        look up a specific workflow by groupId, bucketId, or workflowId.

        Parameters
        ----------
        id : WorkflowsGetRequestId
            The id of the group, bucket, or workflow to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WorkflowResponse]:
        """
        Update an existing workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being updated.

        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowResponse]
            Update success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "chunkStrategy": chunk_strategy,
                "name": name,
                "extract": extract,
                "steps": convert_and_respect_annotation_metadata(
                    object_=steps, annotation=WorkflowSteps, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[MessageResponse]:
        """
        Delete a workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MessageResponse]
            Delete success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WorkflowsResponse]:
        """
        Get all workflows associated with the API key.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowsResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflow",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowsResponse,
                    parse_obj_as(
                        type_=WorkflowsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WorkflowResponse]:
        """
        Create a workflow.

        Parameters
        ----------
        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowResponse]
            Workflow successfully created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflow",
            method="POST",
            json={
                "chunkStrategy": chunk_strategy,
                "name": name,
                "extract": extract,
                "steps": convert_and_respect_annotation_metadata(
                    object_=steps, annotation=WorkflowSteps, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_account(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WorkflowResponse]:
        """
        Get the workflow associated with customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_to_account(
        self, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MessageResponse]:
        """
        Assigns the given workflow to the customer account and is applied by default to all files unless overridden by document or bucket workflows.

        Parameters
        ----------
        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MessageResponse]
            Apply success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="POST",
            json={
                "workflowId": workflow_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def remove_from_account(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MessageResponse]:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MessageResponse]
            Apply success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/workflow/relationship",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def add_to_id(
        self, id: int, *, workflow_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MessageResponse]:
        """
        Assigns the given workflow to the group or bucket and is applied by default to all files unless overridden by document workflows.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will be assigned to.

        workflow_id : str
            The id of the workflow that is being applied.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MessageResponse]
            Apply success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow/relationship/{jsonable_encoder(id)}",
            method="POST",
            json={
                "workflowId": workflow_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def remove_from_id(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MessageResponse]:
        """
        Removes the assigned workflow from the customer account.

        Parameters
        ----------
        id : int
            The id of the group or bucket that the workflow will removed from.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MessageResponse]
            Apply success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow/relationship/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: WorkflowsGetRequestId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WorkflowResponse]:
        """
        look up a specific workflow by groupId, bucketId, or workflowId.

        Parameters
        ----------
        id : WorkflowsGetRequestId
            The id of the group, bucket, or workflow to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        chunk_strategy: typing.Optional[WorkflowRequestChunkStrategy] = OMIT,
        name: typing.Optional[str] = OMIT,
        extract: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        steps: typing.Optional[WorkflowSteps] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WorkflowResponse]:
        """
        Update an existing workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being updated.

        chunk_strategy : typing.Optional[WorkflowRequestChunkStrategy]

        name : typing.Optional[str]
            The name of the workflow being created.

        extract : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Extract agent definitions.

        steps : typing.Optional[WorkflowSteps]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowResponse]
            Update success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "chunkStrategy": chunk_strategy,
                "name": name,
                "extract": extract,
                "steps": convert_and_respect_annotation_metadata(
                    object_=steps, annotation=WorkflowSteps, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowResponse,
                    parse_obj_as(
                        type_=WorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[MessageResponse]:
        """
        Delete a workflow.

        Parameters
        ----------
        id : str
            The workflowId of the workflow being deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MessageResponse]
            Delete success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MessageResponse,
                    parse_obj_as(
                        type_=MessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
